<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller;

use app\common\service\Config;
use think\facade\Request;
use app\adminapi\validate\Admin as AdminValidate;
use app\adminapi\service\Admin as AdminService;

/**
 * @package app\adminapi\controller
 * @class Login
 * @author xzncit 2024-01-12
 */
class Login extends Controller {

    public $auth = [
        'except'=>['index']
    ];

    public function index(){
        if(Request::isPost()){
            $params = Request::param();
            validate(AdminValidate::class)->check($params);
            return returnAjax("msg:ok",1,AdminService::login($params));
        }

        return returnAjax("msg:ok",1,Config::getArray("copy",[
            "icp"               => "",
            "operate"           => "",
            "gov_record"        => "",
            "gov_link"          => "",
            "supervision_url"   => ""
        ],true));
    }

}