<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller;

use app\adminapi\service\Statistic;
use app\common\service\Config;
use think\facade\Request;

/**
 * @package app\adminapi\controller
 * @class Index
 * @author xzncit 2024-01-12
 */
class Index extends Controller {

    public $auth = ['except'=>['setting']];

    /**
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,Statistic::getData());
    }

    public function order(){
        return returnAjax("msg:ok",1,Statistic::getOrder(Request::param()));
    }

    public function setting(){
        return returnAjax("msg:ok",1,Config::getArray("website"));
    }

}