<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller;

use think\facade\Request;
use app\common\model\Category as CategoryModel;
use app\common\model\AdminMenu as AdminMenuModel;
use app\common\model\Region as RegionModel;
use app\common\library\utils\Data;

/**
 * @package app\adminapi\controller
 * @class Common
 * @author xzncit 2024-01-12
 */
class Common extends Controller {

    public $auth = [
        "except"=>["category","menu","get_area","get_region","get_region_children"]
    ];

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function category(){
        $pid = Request::param("pid","0","intval");
        $module = Request::param("module","goods","trim,strip_tags");

        $condition = [];
        $condition[] = ["module","=",$module];
        $condition[] = ["pid","=",$pid];
        $category = CategoryModel::where($condition)->select()->toArray();
        foreach($category as $key=>$item){
            $category[$key]['has'] = CategoryModel::where($condition)->count() ? 1 : 0;
        }

        return returnAjax("msg:ok",1,$category);
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function menu(){
        $pid = Request::param("pid","0","intval");
        $category = AdminMenuModel::where("pid",$pid)->where("status",1)->select()->toArray();
        foreach($category as $key=>$item){
            $category[$key]['has'] = AdminMenuModel::where("pid",$item["id"])->where("status",1)->count() ? 1 : 0;
        }

        return returnAjax("msg:ok",1,$category);
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function get_area(){
        $pid = Request::param("pid","0","intval");
        $area = RegionModel::where("pid",$pid)->select()->toArray();

        foreach($area as $key=>$item){
            $area[$key]['has'] = RegionModel::where("pid",$item["id"])->count() ? 1 : 0;
        }

        return returnAjax("msg:ok",1,$area);
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function get_region(){
        $area = RegionModel::field("id,pid,name")->where("pid",0)->select()->toArray();
        $array = [];
        foreach($area as $key=>$item){
            $array[$key] = $item;
            $children = RegionModel::field("id,pid,name")->where("pid",$item["id"])->select()->toArray();

            foreach($children as $k=>$v){
                $children[$k]["children"] = RegionModel::field("id,pid,name")->where("pid",$v["id"])->select()->toArray();
            }

            $array[$key]["children"] = $children;
        }

        return returnAjax("msg:ok",1,$array);
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function get_region_children(){
        $id = Request::param("id");
        $result = RegionModel::field("id,pid,name")->where("id","in",$id)->select()->toArray();

        $area = Data::familyProcess($result);
        return returnAjax("msg:ok",1,$area);
    }

}