<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller;

use app\common\library\file\FileManager;
use app\common\library\utils\Image;
use app\adminapi\service\Attachment as AttachmentService;
use think\facade\Request;

/**
 * @package app\adminapi\controller
 * @class Attachment
 * @author xzncit 2024-01-12
 */
class Attachment extends Controller {

    public $auth = [
        'except'=>['index','upload','group_list','create_group','delete_group','delete']
    ];

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        $params             = Request::param();
        $params["accept"]   = !empty($params["accept"]) && is_array($params["accept"]) ? implode(",",$params["accept"]) : $params["accept"];
        return returnAjax("msg:ok",1,AttachmentService::getList($params));
    }

    /**
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function upload(){
        $array = FileManager::upload("file",Request::param("cat_id",0,"intval"),Request::param("thumb",0,"intval"));
        return returnAjax("msg:ok",1,[
            "src"    => Image::thumb($array["path"]),
            "title"  => $array["filename"],
            "id"     => $array["id"]
        ]);
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function group_list(){
        return returnAjax("msg:ok",1,AttachmentService::getGroupList());
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function create_group(){
        return returnAjax("msg:ok",1,AttachmentService::createGroup(Request::param()));
    }

    /**
     * @return \think\response\Json
     */
    public function delete_group(){
        return returnAjax("msg:ok",1,AttachmentService::deleteGroup(Request::param("id",0,"intval")));
    }

    /**
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function delete(){
        return returnAjax("msg:ok",1,AttachmentService::delete(Request::param("id")));
    }

}