"""
要測的任務：
文章摘要、長文章特定要求摘要、中翻英、英翻中、從長文章中回答問題、從長文章在某限制下回答問題、自由文本生成、有限制的文章生成
抓實體、抓關係、抓事件
分類情緒、股價影響判斷、文章標籤
"""

import logging

from ..serve.model import ModelServe


def init_logger():
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)
    handler = logging.FileHandler("/home/jovyan/Alpaca-7b/validation/task-experiments.log", "w", "utf-8")
    handler.setFormatter(logging.Formatter('%(name)s %(message)s'))
    logger.addHandler(handler)
    return logger


prompts = [
    {
        "name": "文章摘要",
        "instruction": "請摘要以下文章", 
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "文章摘要 - Instruction only",
        "instruction": "請摘要以下文章：\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。", 
        "input": ""
    },
    {
        "name": "文章摘要 (附加條件)",
        "instruction": "請從以下文章摘要，卡塔爾在天然氣市場中有哪些行動", 
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "文章摘要 (附加條件) - Instruction only",
        "instruction": "請從以下文章摘要，卡塔爾在天然氣市場中有哪些行動：\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。", 
        "input": ""
    },
    {
        "name": "中翻英",
        "instruction": "請將以下文章翻譯成英文", 
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "中翻英 - Instruction only",
        "instruction": "請將以下文章翻譯成英文\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。", 
        "input": ""
    },
    {
        "name": "英翻中",
        "instruction": "請將以下文章翻譯成中文",
        "input": "Investors have moved cash into the precious metal as Covid-19 cases rise in the US and more money is pumped into the global economy. The record high gold price has also been driven by concerns over tensions between Washington and Beijing. Prices of other precious metals, including silver, have also risen sharply since the start of this year. The price of gold has increased by more than 30% this year as coronavirus cases continue to rise in America, causing dozens of states to halt or reverse their plans to reopen. The rapid rise in cases, which has dented hopes of a swift US economic recovery, has also helped to drive up the price of silver by around a third this year."
    },
    {
        "name": "英翻中 - Instruction only",
        "instruction": "請將以下文章翻譯成中文\n\n文章：\nInvestors have moved cash into the precious metal as Covid-19 cases rise in the US and more money is pumped into the global economy. The record high gold price has also been driven by concerns over tensions between Washington and Beijing. Prices of other precious metals, including silver, have also risen sharply since the start of this year. The price of gold has increased by more than 30% this year as coronavirus cases continue to rise in America, causing dozens of states to halt or reverse their plans to reopen. The rapid rise in cases, which has dented hopes of a swift US economic recovery, has also helped to drive up the price of silver by around a third this year.",
        "input": ""
    },
    {
        "name": "文章問答",
        "instruction": "請問以下文章中提到哪些文心一言的優點？",
        "input": "文心一中最大優勢：中文能力。從發布會現場來看，經由在文學創作、商業文案創作、數理推算、中文理解、多模態生成五個使用場景中的能力展現，文心一言也確實在一定程度上具備對人類意圖的理解能力，回答的準確性、邏輯性、流暢性也都逐漸接近人類水準。例如，在文學創作場景中，李彥宏以著名科幻小說《三體》為例，圍繞小說核心內容、內容續寫提問文心一言，在幾秒時間內，文心一言給出綜合性強、內容精緻度高的回答；在數理推算能力展示中，文心一言對「雞兔同籠」問題進行作答，並糾正了題目給出的錯誤資訊。此外，文心一言還具備文本、圖片、音樂和影片的多模態生成能力，甚至能夠生成四川話等方言語音。「多模態是生成式 AI 一個明確的發展趨勢。」李彥宏表示，「未來，隨著百度多模態統一大模型的能力增強，文心一言的多模態生成能力也會不斷提升。」一位業內觀察人士指出，文心一言看似簡單，其實背後具備很高的技術門檻。「能做應用題，意味著對長文本的理解能力要求很高，整體文生圖、文生影片這些多模態生成能力也需要大量的技術積累。」浙江大學國際聯合商學院數字經濟與金融創新研究中心聯席主任盤和林認為，作為高度本土化的生成式 AI 產品，文心一言更加匹配國內用戶的中文使用習慣，表現出較高的中文語言和中國文化的理解能力。對中文的準確理解，離不開高密度的中文資料訓練。IDC 中國研究總監盧言霞認為，文心一言有中文語言優勢，有國內領域相關資料積累。"
    },
    {
        "name": "文章問答 - Instruction only",
        "instruction": "請問以下文章中提到哪些文心一言的優點？\n\n文章：\n文心一言最大優勢：中文能力。從發布會現場來看，經由在文學創作、商業文案創作、數理推算、中文理解、多模態生成五個使用場景中的能力展現，文心一言也確實在一定程度上具備對人類意圖的理解能力，回答的準確性、邏輯性、流暢性也都逐漸接近人類水準。例如，在文學創作場景中，李彥宏以著名科幻小說《三體》為例，圍繞小說核心內容、內容續寫提問文心一言，在幾秒時間內，文心一言給出綜合性強、內容精緻度高的回答；在數理推算能力展示中，文心一言對「雞兔同籠」問題進行作答，並糾正了題目給出的錯誤資訊。此外，文心一言還具備文本、圖片、音樂和影片的多模態生成能力，甚至能夠生成四川話等方言語音。「多模態是生成式 AI 一個明確的發展趨勢。」李彥宏表示，「未來，隨著百度多模態統一大模型的能力增強，文心一言的多模態生成能力也會不斷提升。」一位業內觀察人士指出，文心一言看似簡單，其實背後具備很高的技術門檻。「能做應用題，意味著對長文本的理解能力要求很高，整體文生圖、文生影片這些多模態生成能力也需要大量的技術積累。」浙江大學國際聯合商學院數字經濟與金融創新研究中心聯席主任盤和林認為，作為高度本土化的生成式 AI 產品，文心一言更加匹配國內用戶的中文使用習慣，表現出較高的中文語言和中國文化的理解能力。對中文的準確理解，離不開高密度的中文資料訓練。IDC 中國研究總監盧言霞認為，文心一言有中文語言優勢，有國內領域相關資料積累。",
        "input": ""
    },
    {
        "name": "文章問答 (附加條件)",
        "instruction": "請列出以下文章內有提到的五個文心一言的優點？",
        "input": "文心一言最大優勢：中文能力。從發布會現場來看，經由在文學創作、商業文案創作、數理推算、中文理解、多模態生成五個使用場景中的能力展現，文心一言也確實在一定程度上具備對人類意圖的理解能力，回答的準確性、邏輯性、流暢性也都逐漸接近人類水準。例如，在文學創作場景中，李彥宏以著名科幻小說《三體》為例，圍繞小說核心內容、內容續寫提問文心一言，在幾秒時間內，文心一言給出綜合性強、內容精緻度高的回答；在數理推算能力展示中，文心一言對「雞兔同籠」問題進行作答，並糾正了題目給出的錯誤資訊。此外，文心一言還具備文本、圖片、音樂和影片的多模態生成能力，甚至能夠生成四川話等方言語音。「多模態是生成式 AI 一個明確的發展趨勢。」李彥宏表示，「未來，隨著百度多模態統一大模型的能力增強，文心一言的多模態生成能力也會不斷提升。」一位業內觀察人士指出，文心一言看似簡單，其實背後具備很高的技術門檻。「能做應用題，意味著對長文本的理解能力要求很高，整體文生圖、文生影片這些多模態生成能力也需要大量的技術積累。」浙江大學國際聯合商學院數字經濟與金融創新研究中心聯席主任盤和林認為，作為高度本土化的生成式 AI 產品，文心一言更加匹配國內用戶的中文使用習慣，表現出較高的中文語言和中國文化的理解能力。對中文的準確理解，離不開高密度的中文資料訓練。IDC 中國研究總監盧言霞認為，文心一言有中文語言優勢，有國內領域相關資料積累。"
    },
    {
        "name": "文章問答 (附加條件) - Instruction only",
        "instruction": "請列出以下文章內有提到的五個文心一言的優點？\n\n文章：\n文心一言最大優勢：中文能力。從發布會現場來看，經由在文學創作、商業文案創作、數理推算、中文理解、多模態生成五個使用場景中的能力展現，文心一言也確實在一定程度上具備對人類意圖的理解能力，回答的準確性、邏輯性、流暢性也都逐漸接近人類水準。例如，在文學創作場景中，李彥宏以著名科幻小說《三體》為例，圍繞小說核心內容、內容續寫提問文心一言，在幾秒時間內，文心一言給出綜合性強、內容精緻度高的回答；在數理推算能力展示中，文心一言對「雞兔同籠」問題進行作答，並糾正了題目給出的錯誤資訊。此外，文心一言還具備文本、圖片、音樂和影片的多模態生成能力，甚至能夠生成四川話等方言語音。「多模態是生成式 AI 一個明確的發展趨勢。」李彥宏表示，「未來，隨著百度多模態統一大模型的能力增強，文心一言的多模態生成能力也會不斷提升。」一位業內觀察人士指出，文心一言看似簡單，其實背後具備很高的技術門檻。「能做應用題，意味著對長文本的理解能力要求很高，整體文生圖、文生影片這些多模態生成能力也需要大量的技術積累。」浙江大學國際聯合商學院數字經濟與金融創新研究中心聯席主任盤和林認為，作為高度本土化的生成式 AI 產品，文心一言更加匹配國內用戶的中文使用習慣，表現出較高的中文語言和中國文化的理解能力。對中文的準確理解，離不開高密度的中文資料訓練。IDC 中國研究總監盧言霞認為，文心一言有中文語言優勢，有國內領域相關資料積累。",
        "input": ""
    },
    {
        "name": "文本生成",
        "instruction": "請寫出一篇 150 字左右的故事",
        "input": ""
    },
    {
        "name": "文本生成 (附加條件)",
        "instruction": "請寫出一篇 150 字左右的故事，故事裡要包含怪物和英雄的情節",
        "input": ""
    },
    {
        "name": "文本生成 (附加條件)",
        "instruction": "請寫出一封文情並茂的邀請函給本公司的 VIP 客戶，邀他來參加新名牌包的內部發表會",
        "input": ""
    },
    {
        "name": "實體識別 (多個)",
        "instruction": "請列出以下文章提及的國家、人名、產品名、原物料、公司、組織",
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "實體識別 (多個) - Instruction only",
        "instruction": "請列出以下文章提及的國家、人名、產品名、原物料、公司、組織\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。",
        "input": ""
    },
    {
        "name": "實體識別 (單一)",
        "instruction": "請列出以下文章提及的國家",
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "實體識別 (單一) - Instruction only",
        "instruction": "請列出文章提及的國家：\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。",
        "input": ""
    },
    {
        "name": "關係識別",
        "instruction": "請判斷以下句子中公司間的關係",
        "input": "高通供應 5G 晶片給蘋果公司製造最新一代 iPhone"
    },
    {
        "name": "關係識別 - Instruction only",
        "instruction": "請判斷以下句子中公司間的關係：\n\n文章：\n高通供應 5G 晶片給蘋果公司製造最新一代 iPhone",
        "input": ""
    },
    {
        "name": "事件抽取",
        "instruction": "請對以下文章做事件抽取 (Event Extraction)",
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "事件抽取 - Instruction only",
        "instruction": "請對以下文章做事件抽取 (Event Extraction)\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。",
        "input": ""
    },
    {
        "name": "事件抽取 (附加提示)",
        "instruction": "請對以下文章做事件抽取 (Event Extraction)，需要包含事件主體、事件涉及到的實體、事件發生時間、事件發生地點、事件的綜合影響：",
        "input": "俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。"
    },
    {
        "name": "事件抽取 (附加提示) - Instruction only",
        "instruction": "請對以下文章做事件抽取 (Event Extraction)，需要包含事件主體、事件涉及到的實體、事件發生時間、事件發生地點、事件的綜合影響：\n\n文章：\n俄烏戰爭與能源危機 液化天然氣為什麼變得如此重要？\n俄羅斯削減了對歐洲的天然氣供應，迫使各國尋找替代能源。填補這一空白的燃料主要是液化天然氣（LNG），但由於運輸量太大，油輪在港口排起了長隊。\n什麼是液化天然氣？\n液化天然氣是甲烷，或與乙烷混合的甲烷，是清除了雜質的天然氣，在冷卻到大約零下160℃後成為液體。液化天然氣不僅更加清潔，所佔空間也比天然氣減少600倍。\n它像原油一樣被裝入油輪運輸。在送達目的地後，液化天然氣再次被轉化為氣體，像其他天然氣一樣，用於供暖、烹飪和發電。能源分析公司Crystol Energy的卡蘿·納克爾（Carole Nakhle）說：「在液化天然氣之前，天然氣只能通過管道輸送，這限制了它的銷售地。」\n哪些國家供應液化天然氣？\n世界上最大的液化天然氣出口國是澳大利亞、卡塔爾和美國。美國對歐洲的出口量增加了一倍多，僅在2022年前9個月就達到4600萬噸。美國已經成為歐洲大陸最大的液化天然氣供應商。澳大利亞幾乎將其所有的液化天然氣運往亞洲的買家。\n卡塔爾將其部分液化天然氣運往亞洲國家，部分運往歐洲國家，如英國、比利時和意大利。2022年1月至10月，卡塔爾向歐洲供應了1300萬噸液化天然氣，但它幾乎所有的產品都是按長線合同出售的，因此想在短時間內增加從卡塔爾購買液化天然氣比較困難。阿爾及利亞等國家也向歐洲出口液化天然氣。俄羅斯也供應液化天然氣，雖然它已經削減了通過管道向歐洲提供天然氣。\n液化天然氣如何幫助歐洲繼續有照明用電？\n俄羅斯2022年2月入侵烏克蘭受到了歐洲國家的譴責。作為回應，俄羅斯將對歐洲的天然氣出口減少了約80%。國際天然氣價格因此上漲超過四倍，家庭能源開銷大幅飆升。\n由於擔心斷電，歐盟與美國簽署了一項協議，進口更多的液化天然氣。\n據歐盟委員會稱，現在液化天然氣佔歐盟國家使用的所有天然氣的40%。液化天然氣也佔英國進口天然氣總量的一半，其中主要來自美國。這些額外增加的液態天然氣供應有助於阻止天然氣價格攀升至更高水平。\n為什麼歐洲不能接受更多的液化天然氣？\n能源研究所（Energy Institute）的凱特·杜麗安（Kate Dourian）說：「美國的液化天然氣幫助歐洲擺脫了困境。」\n「但是現在市場已經飽和了，因為歐洲已經達到了所能接受的液化天然氣極限。」\n想要進口液化天然氣的國家需要有工廠來卸裝液化天然氣，並轉變成天然氣。法國、英國、意大利和西班牙已經建立了此類儲存倉庫，但其他國家，如歐洲最大的天然氣進口國德國還沒有。歐洲缺乏液化天然氣存儲能力已經造成了瓶頸。10月底，有報道稱歐洲水域有51艘液化天然氣油輪，其中很多都在等待進入港口。德國和荷蘭等國家已經試圖通過僱用浮動倉庫來存儲和轉換天然氣來解決倉庫短缺問題。然而，即使有這些浮動倉庫，這些國家也無法處理所有被運送來的液化天然氣。能源分析公司（Crystol Energy）的卡蘿·納克爾（Carole Nakhle）說這些浮動倉庫規模很小，他們不能快速處理大量的液化天然氣， 「正因為如此，運輸油輪排隊的情況越來越多。」歐洲不能接受所有被送來的液化天然氣還有其他原因。凱特·杜麗安（Kate Dourian）說：「各國無法接受更多的液化天然氣，因為它們的大部分儲存設施已經滿了。」她說，歐洲國家都在儲存天然氣，以便在天氣變冷時供暖使用，但今年秋天的天氣相對溫和。歐洲國家正計劃再建17個液化天然氣倉庫。這可以使產能增加40%以上。然而，大多數將在2026年才投入使用。",
        "input": ""
    },
    {
        "name": "文本多分類",
        "instruction": "請判斷以下文章屬於何種類別，類別有半導體業、金融業、航運業、汽車工業、網路資訊業",
        "input": "2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。"
    },
    {
        "name": "文本多分類 - Instruction only",
        "instruction": "請判斷文章屬於何種類別，類別有半導體業、金融業、航運業、汽車工業、網路資訊業：\n\n文章：\n2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。",
        "input": ""
    },
    {
        "name": "情緒分類",
        "instruction": "請判斷以下文章的情緒分類，類別有正面、負面、中立",
        "input": "2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。"
    },
    {
        "name": "情緒分類 - Instruction only",
        "instruction": "請判斷以下文章的情緒分類，類別有正面、負面、中立：\n\n文章：\n2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。",
        "input": ""
    },
    {
        "name": "股市波動判斷",
        "instruction": "請判斷以下文章會對股市造成何種影響，類別有上揚、下跌、持平",
        "input": "2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。"
    },
    {
        "name": "股市波動判斷 - Instruction only",
        "instruction": "請判斷文章會對股市造成何種影響，類別有上揚、下跌、持平：\n\n文章：\n2022年聯準會（Fed）大幅升息，公債殖利率走高，SVB帳上MBS價格大跌，相關部位累積了龐大未實現損失。又逢市場流動性降低，為應付存款快速流失，不得不處分HTM部位，認列產生評價損失，進而影響資本適足率。摩根大通估算，經考量未實損後SVB的CET1趨近於0％。事後看，SVB業務過於集中新創公司，Fed快速升息致其資產負債表惡化，產生資金缺口，進而遭美國聯邦存款保險公司（FDIC）收管。隨美國財政部、Fed、FDIC聯合出手，保住SVB存戶所有存款，並對符合條件存款機構提供一年期250億美元緊急貸款計畫，擔保品以面額評價，初步平息擠兌風險。",
        "input": ""
    }
]


logger = init_logger()
# inference
model = ModelServe(load_8bit=True)
for sample in prompts:
    logger.info(f'===== {sample["name"]} ===== \n> Instruction: \n{sample["instruction"]}\n\n> Input: \n{sample["input"]}\n\n')
    output = model.generate(instruction=sample["instruction"], input=sample["input"])
    logger.info(f"> Output: \n{output}\n\n")
