<?php
/**
 * 支付成功异步回调接口
 *
 * 当用户支付成功后，支付平台会把订单支付信息异步请求到本接口(最多5次)
 *
 * @date 2017年3月13日
 * @copyright 重庆迅虎网络有限公司
 */
require_once "xunhupay_config.php";
require_once("config.php");
require_once 'xunhupay_api.php';
ini_set('date.timezone','Asia/Shanghai');

/**
 * 回调数据
 * @var array(
 *       'trade_order_id'，商户网站订单ID
         'total_fee',订单支付金额
         'transaction_id',//支付平台订单ID
         'order_date',//支付时间
         'plugins',//自定义插件ID,与支付请求时一致
         'status'=>'OD'//订单状态，OD已支付，WP未支付
 *   )
 */

$appid              = trim($xunhupay_config['appid']);//测试账户，仅支持一元内支付
$appsecret          = trim($xunhupay_config['appsecret']);//测试账户，仅支持一元内支付
$my_plugin_id       = 'my-plugins-id';

$data = $_POST;
foreach ($data as $k=>$v){
    $data[$k] = stripslashes($v);
}
if(!isset($data['hash'])||!isset($data['trade_order_id'])){
   echo 'failed';exit;
}

//自定义插件ID,请与支付请求时一致
if(isset($data['plugins'])&&$data['plugins']!=$my_plugin_id){
    echo 'failed';exit;
}

//APP SECRET
$appkey =$appsecret;
$hash =XH_Payment_Api::generate_xh_hash($data,$appkey);
if($data['hash']!=$hash){
    //签名验证失败
    echo 'failed';exit;
}

//商户订单ID
$trade_order_id =$data['trade_order_id'];

if($data['status']=='OD'){
    /************商户业务处理******************/
    //TODO:此处处理订单业务逻辑,支付平台会多次调用本接口(防止网络异常导致回调失败等情况)
    //     请避免订单被二次更新而导致业务异常！！！
    //     if(订单未处理){
    //         处理订单....
    //      }

    $orderid = $trade_order_id;
		$fee = $data['total_fee']*100;
		$postdata = array(
			'orderid'      => $orderid,
			'fee'      => $fee 
		);

		$sign =  sign($postdata, trim( $config_8tupian['key_id']) );
		
		$url = sprintf("%s?orderid=%s&fee=%d&sign=%s", $config_8tupian['api_url'], $orderid, $fee , $sign);
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch);
		
		$response = trim($response, "\xEF\xBB\xBF");
    if($response == "success") 
		{
			if( file_exists("config.php") )
			{
				require_once "config.php";
			}
			if( file_exists("api/callback.php") )
			{
				require_once "api/callback.php";
			}
          
          echo "success";	
    }
		else
		{
			echo "fail";
		}
    /*************商户业务处理 END*****************/
}else{
    //处理未支付的情况
    echo 'success';
}

//以下是处理成功后输出，当支付平台接收到此消息后，将不再重复回调当前接口

exit;
?>
