<!DOCTYPE html>
<html><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    
<title>对接自己的支付接口</title>
    <meta name="description" content="">
    <meta name="keywords" content="">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<link rel="stylesheet" href="./style/style.css"><link rel="stylesheet" href="./style/style(1).css"><style type="text/css" data-react-helmet="true">.ಠhighlight-container code[class*=language-],.ಠhighlight-container pre[class*=language-]{color:#000;background:none;text-shadow:0 1px #fff;font-family:Consolas,Monaco,Andale Mono,Ubuntu Mono,monospace;text-align:left;white-space:pre;word-spacing:normal;word-break:normal;word-wrap:normal;line-height:1.5;-moz-tab-size:4;-o-tab-size:4;tab-size:4;-webkit-hyphens:none;-ms-hyphens:none;hyphens:none}.ಠhighlight-container code[class*=language-]::-moz-selection,.ಠhighlight-container code[class*=language-] ::-moz-selection,.ಠhighlight-container pre[class*=language-]::-moz-selection,.ಠhighlight-container pre[class*=language-] ::-moz-selection{text-shadow:none;background:#b3d4fc}.ಠhighlight-container code[class*=language-]::selection,.ಠhighlight-container code[class*=language-] ::selection,.ಠhighlight-container pre[class*=language-]::selection,.ಠhighlight-container pre[class*=language-] ::selection{text-shadow:none;background:#b3d4fc}@media print{.ಠhighlight-container code[class*=language-],.ಠhighlight-container pre[class*=language-]{text-shadow:none}}.ಠhighlight-container pre[class*=language-]{padding:1em;margin:.5em 0;overflow:auto}.ಠhighlight-container :not(pre)>code[class*=language-],.ಠhighlight-container pre[class*=language-]{background:#f5f2f0}.ಠhighlight-container :not(pre)>code[class*=language-]{padding:.1em;border-radius:.3em;white-space:normal}.ಠhighlight-container .token.cdata,.ಠhighlight-container .token.comment,.ಠhighlight-container .token.doctype,.ಠhighlight-container .token.prolog{color:#708090}.ಠhighlight-container .token.punctuation{color:#999}.ಠhighlight-container .namespace{opacity:.7}.ಠhighlight-container .token.boolean,.ಠhighlight-container .token.constant,.ಠhighlight-container .token.deleted,.ಠhighlight-container .token.number,.ಠhighlight-container .token.property,.ಠhighlight-container .token.symbol,.ಠhighlight-container .token.tag{color:#905}.ಠhighlight-container .token.attr-name,.ಠhighlight-container .token.builtin,.ಠhighlight-container .token.char,.ಠhighlight-container .token.inserted,.ಠhighlight-container .token.selector,.ಠhighlight-container .token.string{color:#690}.ಠhighlight-container .language-css .token.string,.ಠhighlight-container .style .token.string,.ಠhighlight-container .token.entity,.ಠhighlight-container .token.operator,.ಠhighlight-container .token.url{color:#9a6e3a;background:hsla(0,0%,100%,.5)}.ಠhighlight-container .token.atrule,.ಠhighlight-container .token.attr-value,.ಠhighlight-container .token.keyword{color:#07a}.ಠhighlight-container .token.class-name,.ಠhighlight-container .token.function{color:#dd4a68}.ಠhighlight-container .token.important,.ಠhighlight-container .token.regex,.ಠhighlight-container .token.variable{color:#e90}.ಠhighlight-container .token.bold,.ಠhighlight-container .token.important{font-weight:700}.ಠhighlight-container .token.italic{font-style:italic}.ಠhighlight-container .token.entity{cursor:help}</style></head>
<body>
<div id="main"><div class="window-container"><img src="./style/logo.gif" style="position: absolute; visibility: hidden;"><div class="window-body "><div class="workspace"><div class="article"><div class="article-head"><div class="left tools"><a class="item icon"><i class="icon align justify"></i></a></div><h1>对接自己的支付接口</h1></div><div class="article-body kancloud-markdown-body"><h2><a id="_0"></a>设置支付地址</h2>
<p>你如果自己有微信或者支付宝的接口，那么可以使用自己的支付接口来对接平台。</p>
<p>在“api接口”页面，设置自己的支付地址后，再上传并生成的图片，扫码将跳转到你自己设置的支付地址。</p>
<p>这样，用户支付的金额直接进入你自己的接口账户，不经过平台。<br>
这种方式下，每完成一次交易，平台将收取一定的服务费。<br>
服务费直接从账户余额中扣除，如果账户余额不足，可以在“api接口”页面中进行充值。</p>
<hr>
<p>……</p>
<h2><a id="_11"></a>对接说明</h2>
<h4><a id="_12"></a><strong>付款请求</strong></h4>
<p>设置了支付地址后，当用户扫描二维码，平台将发送付款请求到支付地址。<br>
示例：</p>
<pre><code class="ಠhighlight-container"><span class="token punctuation">{</span>你的支付地址<span class="token punctuation">}</span><span class="token operator">?</span>orderid<span class="token operator">=</span><span class="token number">27</span>_274_1_18966986<span class="token operator">&amp;</span>fee<span class="token operator">=</span><span class="token number">10</span><span class="token operator">&amp;</span>picurl<span class="token operator">=</span>http<span class="token punctuation">:</span><span class="token operator">/</span><span class="token operator">/</span>test<span class="token punctuation">.</span><span class="token number">8</span>tupian<span class="token punctuation">.</span>com<span class="token operator">/</span><span class="token number">1</span>a1b1<span class="token punctuation">.</span>pg0
</code></pre>
<h5><a id="GET_18"></a>请求方式：GET</h5>
<hr>
<p>请求参数：</p>
<table><thead><tr><th>参数名</th><th>类型</th><th>说明</th><th>示例值</th></tr></thead><tbody><tr><td>fee</td><td>int</td><td>支付金额，即图片价格（单位：分）</td><td>10</td></tr><tr><td>orderid</td><td>string</td><td>平台的订单号</td><td>27_274_1_18966986</td></tr><tr><td>picurl</td><td>string</td><td>图片的网络地址</td><td>http://test.8tupian.com/1a1b1.pg0</td></tr></tbody></table>
<hr>
<p>……</p>
<h4><a id="_28"></a><strong>发送通知</strong></h4>
<p>当用户在你自己的支付系统中完成支付后，需要再发送一个通知给平台，平台收到通知后，会开放相应的权限给用户。</p>
<h5><a id="URL_30"></a>通知URL地址：</h5>
<?php
	$explode  = explode("/api/", $_SERVER["REQUEST_URI"] );
	$apiurl = ($_SERVER['SERVER_PORT'] == '443' ? 'https://' : 'http://').$_SERVER['HTTP_HOST'] . $explode[0] . "/api/notify.php" ;
?>
<p><code><?php echo $apiurl;?></code><br>
示例：</p>
<pre><code class="ಠhighlight-container"><?php echo $apiurl;?>?orderid=27_274_1_18966986&fee=10&sign=202cb962ac59075b964b07152d234b70
</code></pre>
<p>通知方式：GET<br>
通知参数：</p>
<table><thead><tr><th>参数名</th><th>类型</th><th>说明</th><th>示例值</th></tr></thead><tbody><tr><td>fee</td><td>int</td><td>支付金额，即图片价格（单位：分）</td><td>10</td></tr><tr><td>orderid</td><td>string</td><td>发起付款请求时，传递的平台的订单号</td><td>27_274_1_18966986</td></tr><tr><td>sign</td><td>string</td><td>以“api接口”页面中的key作为秘钥，生成数据签名。请参见下面的签名算法</td><td>202cb962ac59075b964b07152d234b70</td></tr></tbody></table>
<p>返回值： success 表示成功，fail 表示失败</p>
<p>PHP 示例代码:</p>
<pre><code class="ಠhighlight-container"><span class="token comment">//平台的订单号</span>
$orderid <span class="token operator">=</span> $out_trade_no<span class="token punctuation">;</span>
 
<span class="token comment">//支付金额，单位：分</span>
$fee <span class="token operator">=</span> $price <span class="token operator">*</span> <span class="token number">100</span><span class="token punctuation">;</span>
 
$postdata <span class="token operator">=</span> <span class="token function">array</span><span class="token punctuation">(</span>
	<span class="token string">'orderid'</span>      <span class="token operator">=</span><span class="token operator">&gt;</span> $orderid<span class="token punctuation">,</span>
	<span class="token string">'fee'</span>      <span class="token operator">=</span><span class="token operator">&gt;</span> $fee 
<span class="token punctuation">)</span><span class="token punctuation">;</span>

<span class="token comment">//生成签名，请参见后面的签名算法</span>
$sign <span class="token operator">=</span>  <span class="token function">sign</span><span class="token punctuation">(</span>$postdata<span class="token punctuation">,</span> ‘<span class="token number">98800e620</span>e693c95d4f08b7992971c3d’<span class="token punctuation">)</span><span class="token punctuation">;</span>

$url <span class="token operator">=</span> <span class="token function">sprintf</span><span class="token punctuation">(</span><span class="token string">"<?php echo $apiurl;?>?orderid=%s&amp;fee=%d&amp;sign=%s"</span><span class="token punctuation">,</span> $orderid<span class="token punctuation">,</span> $fee <span class="token punctuation">,</span> $sign<span class="token punctuation">)</span><span class="token punctuation">;</span>

$ch <span class="token operator">=</span> <span class="token function">curl_init</span><span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">;</span>
<span class="token function">curl_setopt</span><span class="token punctuation">(</span>$ch<span class="token punctuation">,</span> CURLOPT_URL<span class="token punctuation">,</span> $url<span class="token punctuation">)</span><span class="token punctuation">;</span>
<span class="token function">curl_setopt</span><span class="token punctuation">(</span>$ch<span class="token punctuation">,</span> CURLOPT_SSL_VERIFYPEER<span class="token punctuation">,</span> false<span class="token punctuation">)</span><span class="token punctuation">;</span>
<span class="token function">curl_setopt</span><span class="token punctuation">(</span>$ch<span class="token punctuation">,</span> CURLOPT_SSL_VERIFYHOST<span class="token punctuation">,</span> false<span class="token punctuation">)</span><span class="token punctuation">;</span>
<span class="token function">curl_setopt</span><span class="token punctuation">(</span>$ch<span class="token punctuation">,</span> CURLOPT_RETURNTRANSFER<span class="token punctuation">,</span> <span class="token number">1</span><span class="token punctuation">)</span><span class="token punctuation">;</span>
$response <span class="token operator">=</span> <span class="token function">curl_exec</span><span class="token punctuation">(</span>$ch<span class="token punctuation">)</span><span class="token punctuation">;</span>

$response <span class="token operator">=</span> <span class="token function">trim</span><span class="token punctuation">(</span>$response<span class="token punctuation">,</span> <span class="token string">"\xEF\xBB\xBF"</span><span class="token punctuation">)</span><span class="token punctuation">;</span>
<span class="token keyword">if</span><span class="token punctuation">(</span>$response <span class="token operator">==</span> <span class="token string">"success"</span><span class="token punctuation">)</span> 
<span class="token punctuation">{</span>
     echo <span class="token string">"成功！"</span><span class="token punctuation">;</span>	
 <span class="token punctuation">}</span>
<span class="token keyword">else</span>
<span class="token punctuation">{</span>
     echo <span class="token string">"失败！"</span><span class="token punctuation">;</span>
<span class="token punctuation">}</span>
</code></pre>
<hr>
<p>……</p>
<h4><a id="_80"></a><strong>签名算法</strong></h4>
<p>签名生成的通用步骤如下：</p>
<p>第一步，设所有发送或者接收到的数据为集合M，将集合M内非空参数值的参数按照参数名ASCII码从小到大排序（字典序），使用URL键值对的格式（即key1=value1&amp;key2=value2…）拼接成字符串stringA。</p>
<p>第二步，在stringA最后拼接上 &amp;key=密钥 得到stringSignTemp字符串，并对stringSignTemp进行MD5运算，得到sign值</p>
<p>PHP 示例代码:</p>
<pre><code class="ಠhighlight-container"><span class="token keyword">function</span> <span class="token function">sign</span><span class="token punctuation">(</span>$data<span class="token punctuation">,</span> $key<span class="token punctuation">)</span> <span class="token punctuation">{</span>
    <span class="token function">ksort</span><span class="token punctuation">(</span>$data<span class="token punctuation">)</span><span class="token punctuation">;</span>
    $sign <span class="token operator">=</span> <span class="token function">md5</span><span class="token punctuation">(</span><span class="token function">urldecode</span><span class="token punctuation">(</span><span class="token function">http_build_query</span><span class="token punctuation">(</span>$data<span class="token punctuation">)</span><span class="token punctuation">)</span><span class="token punctuation">.</span><span class="token string">'&amp;key='</span><span class="token punctuation">.</span>$key<span class="token punctuation">)</span><span class="token punctuation">;</span>
    <span class="token keyword">return</span> $sign<span class="token punctuation">;</span>
<span class="token punctuation">}</span>
</code></pre>
<hr>
<p>……</p>
<h2><a id="Demo_99"></a>支付Demo</h2>
<p>Demo源码供参考，也可以简单配置后直接使用。</p>
<p>源码采用的接口类型：支付宝手机网站支付，微信JSAPI支付，支付宝当面付</p>
<p><a href="../8tp/downloadcode.php?type=1" target="_blank">点击下载支付DEMO源码</a></p>
<p>……</p>
</div></div></div></div></div></div>
	<div style="display:none">
<script src="https://s95.cnzz.com/z_stat.php?id=1261199792&web_id=1261199792" language="JavaScript"></script>
</div>

</body></html>