# JSR-303 校验

JSR-303 是JAVA EE 6 中的一项子规范，叫做Bean Validation，Hibernate Validator 是 Bean Validation 的参考实现 . Hibernate Validator 提供了 JSR 303 规范中所有内置 constraint 的实现，除此之外还有一些附加的 constraint。

**验证注解采用`javax.validation.constraints`下的注解**，具体实现是采用的`Hibernate Validator `。使用时候可以参考注解类的JavaDoc。

## @Validated 和 @Valid

二者基本都可以使校验生效，可在类、字段等

- @Validated 是@Valid 的一次封装，是Spring提供的校验机制使用，主要具备分组验证功能，但**不支持嵌套验证**。

- @Valid 是 javax.validation提供，不具备分组，但支持**嵌套验证**。

> 嵌套验证指的是，类A需要验证，类A中的字段类B也需要验证，这时候只能在B属性上加上@Valid。

框架默认在类上统一使用@Validated，继承也可以生效，例如：

```
com.seezoon.framework.web.BaseController
com.seezoon.admin.framework.service.AbstractBaseService
com.seezoon.dao.framework.BaseDao
```

## 常用验证注解

这里列举常用的注解，都是包`javax.validation.constraints` 下面的，其余如Boolean、时间等，有需求可以自行使用。

## @NotNull  

不能为null。

## @NotEmpty

不能为null 不能为空，适用字符、集合、Map、数组的验证。

## @NotBlank

不能为null或者空白符。

## @Null

必须为null，用的较少。

## @Size

为null的时候不生效，适用字符长度，集合、Map、数组容量校验。

## @Pattern

为null的时候不生效，适用字符正则验证。

## @Min和@Max

为null的时候不生效，适合数值类验证。

## @Email

为null的时候不生效，验证字符是否符合邮箱格式。

## @Digits

为null的时候不生效，小数验证。