# 01. 相机内参和外参的含义？如果将图像放大两倍，内外参如何变化？

-   相机有两个最基础的数据：内参(Instrinsics)和外参(Extrinsics)，内参主要描述的是相机的CCD/CMOS感光片尺寸/分辨率以及光学镜头的系数，外参主要描述的是相机在世界坐标系下的摆放位置和朝向角度。

- 参考：https://zhuanlan.zhihu.com/p/646310465

# 02. 坐标系的变换

- BEV训练数据集的世界坐标系, 比如nuScenes地图，它的世界坐标系是图片坐标系，原点在图片左下角，单位是米。数据集中会根据时间序列给出车辆的瞬时位置，也就是在这个图片上的XY。

- BEV里，这个Ego是特指车辆本身，它是用来描述摄像机/激光雷达（Lidar，light detection and ranging）/毫米波雷达（一般代码里就简称为Radar）/IMU在车身上的安装位置（单位默认都是米）和朝向角度，坐标原点一般是车身中间，外参（Extrinsics Matrix）主要就是描述这个坐标系的。

- 相机坐标系，坐标原点在CCD/CMOS感光片的中央，单位是像素，内参（Intrinsics Matrix）主要就是描述这个坐标系的。

- 照片坐标系，坐标原点在图片的左上角，单位是像素，横纵坐标轴一般不写成XY，而是uv。

- 照片中的像素位置转换到世界坐标系时，要经历：Image_to_Camera, Camera_to_Ego, Ego_to_World；Camera_to_Image通常就是Intrinsics参数矩阵，Ego_to_Camera就是Extrinsics参数矩阵。

# 03. 放射变换与逆投影变换分别是什么

- 仿射变换： 仿射变换是一种线性变换，保持了直线的平行性和比例关系。它可以用于将一个二维平面上的点映射到另一个二维平面上。仿射变换可以通过一个矩阵乘法和一个平移向量来表示。它包括平移、旋转、缩放和剪切等操作。在计算机视觉领域，仿射变换常用于图像的平移、旋转、缩放和仿射校正等操作。

- 逆投影变换： 逆投影变换是指通过相机内参和外参，将图像上的点投影到三维空间中的过程。它是相机成像过程的逆过程。逆投影变换可以用于将图像上的点转换为三维空间中的点坐标。逆投影变换的计算需要相机的内参矩阵、外参矩阵和图像上的点坐标。在计算机视觉和计算机图形学中，逆投影变换常用于三维重建、相机姿态估计和虚拟现实等应用。

```python
import numpy as np

# 定义相机内参和外参
K = np.array([[1000, 0, 500], [0, 1000, 300], [0, 0, 1]], dtype=np.float32)
R = np.array([[1, 0, 0], [0, 1, 0], [0, 0, 1]], dtype=np.float32)
T = np.array([1, 2, 3], dtype=np.float32)

# 定义图像上的点坐标
uv = np.array([[200, 300], [400, 500]], dtype=np.float32)

# 计算逆投影变换
Rc2w_invK = np.linalg.inv(np.dot(R, K))
H = np.dot(Rc2w_invK, np.append(uv, np.ones((uv.shape[0], 1)), axis=1).T)
Pxyz = H * (T[2] / H[2]) - T[:2]

# 定义仿射变换矩阵
M = np.array([[1, 0, 100], [0, 1, 50]], dtype=np.float32)

# 进行仿射变换
output = cv2.warpAffine(image, M, (image.shape[1], image.shape[0]))
```

# 04. 卡尔曼滤波Q和R怎么调

- Q值为过程噪声，越小系统越容易收敛，表示对模型预测的值信任度越高；
- R值为测量噪声。R太大，滤波的响应会变慢，对新测量的值的信任度降低；
- 当Q过小时，易发散，当R过小时，误差会变大。调试时可以先将Q从小往大调整，将R从大往小调整；先固定一个值去调整另外一个值，看收敛速度与波形输出。


# 05. 如何理解BEV空间及生成BEV特征

Bev就是鸟瞰图，从上往下看应该就是二维的一个平面。如果是相机透视图的话会存在遮挡还有近大远小问题，所以需要转换成bev，但是不能直接转换，需要通过3D空间作为中介，就是先从透视图转换到3D，再从3D转换到bev，即图像提取出来特征(C,H,W）转换到3D空间后(C,D,H,W）再拍扁到bev空间，

# 06. 如何在标注存在错误的数据上训练模型

# 07. 视频与图像中的目标检测具体有什么区别

视频检测是比单张图片检测多了Temporal Context（时间上下文）的信息。充分利用好时序上下文关系，可以解决视频中连续帧之间的大量冗余的情况，提高检测速度；还可以提高检测质量，解决视频相对于图像存在的运动模糊、视频失焦、部分遮挡以及奇异姿势等问题。

视频目标检测更需注重稳定性的问题，在实际的应用中其实也会带来很多困扰。例如在自动驾驶中，需要稳定的2D检测框来进行车辆距离和速度的估计。不稳定的检测都会极大影响后续任务的准确性。

[视频目标检测](https://www.zhihu.com/question/52185576/answer/155679253)

# 16. 解释KF中的噪声矩阵含义。运动方程中估计噪声是变大还是变小？修正方程中估计噪声是变大还是变小？

# 17. 举出几种光流方法，说明LK光流的建模方式？

- LK
- Flownet

# 20. 车道线检测的任务通常采用分割方案，如何将方案降级至检测，甚至是车道线分类？

- 分类任务输出通道数决定了检测车道线条数的上限；
- 检测任务类似于Yolo将图像分块，检测每一个块内是否存在车道线点；

# 23. 银行经理收到一个数据集，其中包含数千名申请贷款的申请人的记录。人工智能如何帮助经理了解他可以批准哪些贷款？

该问题可以使用 KNN 算法来解决，该算法将申请人的贷款请求分为两类：得到正式认可的
和未批准。可以执行以下步骤来预测贷款是否必须获得批准：

数据提取：在此阶段，数据要么通过调查收集，要么执行网络抓取。必须收集有关客户的数据。这包括他们的账户余额、信贷金额、年龄、职业、贷款记录等。通过使用这些数据，我们可以预测是否批准申请人的贷款。

数据清理：在这个阶段，必须删除冗余变量。其中一些变量对于预测申请人的贷款来说并不是必需的，例如电话、并发信用等变量。必须删除这些变量，因为它们只会增加机器学习模型的复杂性。

数据探索与分析：研究各种预测变量之间的关系。例如，如果一个人有未偿还贷款的历史，那么他的贷款申请人很可能无法获得批准。在此阶段必须检测和理解此类模式。

构建机器学习模型：有 n 种机器学习算法可用于预测申请人的贷款请求是否获得批准。其中一个例子是 K 最近邻，它是一种分类和回归算法。它将申请人的贷款请求分为两类，即批准和拒绝。

# 24. 简述BEVformer的Decoder逻辑？

在获取到需要用到的query、query_pos、reference_points参数后，后面的逻辑有些类似 Deformabe DETR 的 Decoder 过程，简单概括如下几点：

- 利用query和query_pos去做常规的 Self-Attention 运算更新query；
- 利用 Self-Attention 得到的 query，之前获得的 bev_embedding作为value，query_pos，由 query生成的reference_points（虽然生成的x，y，z参考点位置，但是 BEV Embedding 是二维的，所以参考点只选择了前两维）仿照 Deformable Attention Module 的 pipeline 做可变形注意力；


# 25. BEVFormer中的Spatial Cross-Attention的步骤？

Step 1 Lift each BEV query to be a pillar
Step 2 Project the 3D points in pillar to 2D points in views
Step 3 Sample features from regions in hit views
Step 4 Fuse by weight

# 26. 车上多个摄像头图像投影到2D平面如何实现？

- 标定：首先需要对每个摄像头进行标定，以确定其内部参数（如焦距、主点位置）和外部参数（相机的位置和朝向）。还原摄像头成像物体在真实世界的位置，就需要知道世界坐标系到图像平面坐标系如何变换，求解内外参矩阵，另一个是针孔摄像头的畸变参数求解。

- 立体匹配：如果要将多个摄像头的图像投影到2D平面以进行立体视觉分析，那么需要进行立体匹配，即找到多个视角下对应的像素点。这可以通过计算视差（disparity）来实现，从而确定不同视角下的像素对应关系。

- 三角测量：一旦找到了多个视角下的对应点，就可以使用三角测量方法来将这些点投影到3D空间中，并进一步将其投影到2D平面上。

- 投影：最后，可以将3D空间中的点通过透视变换（perspective transformation）投影到2D平面上。这通常涉及将3D点坐标乘以相机投影矩阵，以获得其在图像上的投影坐标。

# 28. 假如当前需要你把场景里的砖头分割出来，靠点云分割能否正确识别？

可以利用4个激光雷达在不同角度上进行面特征检测，以及对四个角特征进行识别来分割出砖头。

# 29. 点云中的水雾怎么去除？

水雾可通过加强激光雷达强度或采用毫米波雷达等多传感器融合的方法来增强激光的穿透能力，从而去除水雾。

# 30. 车宽测距和接地点测距分别使用了什么样的先验知识？这些先验如果不成立的时候能有什么手段来放宽限制？

[CNN靠什么得到深度线索](https://zhuanlan.zhihu.com/p/95758284)

# 31. 车辆行驶过程中 Pitch 角度的三种方法？

[单目相机的测距](https://funnywii.com/archives/%E5%8D%95%E7%9B%AE%E7%9B%B8%E6%9C%BA%E7%9A%84%E6%B5%8B%E8%B7%9D-thedistanceestimationofmonocularcamera)


# 34. 单目3D目标检测的预测信息包含哪些，在预测3D框中心偏差时针对截断目标如何处理？

[截断目标单目3D预测](https://developer.aliyun.com/article/1376388)

# 35. 通过几何关系估计深度过程中，由于高度的误差使得深度的估计不确定性高，如何缓解？

[单目3D预测](https://zhuanlan.zhihu.com/p/435139846)

# 36. Nuscenes数据集中相机传感器配置及标注内容包含哪些？

[Nuscenes数据集](https://bbs.huaweicloud.com/blogs/349392)

# 09. 鱼眼相机具备更大的视场角，因此常用在一些监控场景下，如何在鱼眼图像下做检测或分割任务？

矫正卷积：ADAPTING CNNS FOR FISHEYE CAMERAS WITHOUT RETRAINING

https://arxiv.org/pdf/2404.08187.pdf

# 10. 昼夜跨域车辆重识别车辆重识别如何处理，即在包括白天和夜间域在内的不同域中识别相同的车辆？

Day-Night Cross-domain Vehicle Re-identification，一种用于车辆重识别的 GAN-Siamese 网络结构

# 38. 简述生成BEV特征图的几种方式，其中LSS的lift操作具体做了什么？

https://zhuanlan.zhihu.com/p/567880155


# 11. 如果一个数据集在图像的某个区域中几乎没有猫这个物体，那么目标检测器会不会也在这个区域不擅长检测猫？

- 第一，检测器并没有表现出明显的"不擅长", 主要依靠的是CNN的平移不变性。
- 第二，检测器确实在此区域不擅长检测猫了, CNN可以学习出物体的绝对位置，并把它当作额外的信息辅助分类。
- https://zhuanlan.zhihu.com/p/602113455


# 06. 模型问题：如何给模型加入先验知识，有哪几种方法？

https://zhuanlan.zhihu.com/p/188572028

# 39. 感知算法既希望获得高分辨率的输入图像又希望获得大FOV的输入图像，业内一般做法是设置ROI区域，怎么选？

去除空间冗余

- 感知算法既希望获得高分辨率的输入图像又希望获得大FOV的输入图像。如果鱼和熊掌都满足，感知所需算力将高得离谱。通过观察，一般图像中心某个ROI区域才是感知最关心的，尤其是前视camera。于是，大家想出了兼得的好办法，中心画个ROI区域抠图，而原图scale down到比较小的尺寸。两张图的总像素个数远小于原始像素总数。这是业内一般做法。

- 这里面的关键问题是ROI区域怎么选？ROI的目标是利用高分辨率信息检测到更远处的物体，在大幅度转弯时，远方车辆可能在画面的两边，或者远处岔路深处的车辆也可能分布在图像两边，所以，为了覆盖全面需要横跨整个图像。剩下的就是ROI高度和中线位置的确定。显然不需要原始分辨率的高度，因为天空和挡风玻璃下部的座舱内部都可以被剔除。难以确定的是中线位置，因为上下坡时的天地分割线会随之发生改变。

https://zhuanlan.zhihu.com/p/888151027



# 03. 图像识别：在实际应用中部署人脸识别算法的一个重要方面是它们能够从连续数据流中学习新的人脸身份，如何做？

CLFace: A Scalable and Resource-Efficient Continual Learning Framework for Lifelong Face Recognition