(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["mongoose"] = factory();
	else
		root["mongoose"] = factory();
})(typeof self !== 'undefined' ? self : this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 5507:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Export lib/mongoose
 *
 */


module.exports = __webpack_require__(1735);

/***/ }),

/***/ 1735:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];
/* eslint-env browser */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

(__webpack_require__(9906).set)(__webpack_require__(6333));

var DocumentProvider = __webpack_require__(4304);

var PromiseProvider = __webpack_require__(6755);

DocumentProvider.setBrowser(true);
/**
 * The Mongoose [Promise](#promise_Promise) constructor.
 *
 * @method Promise
 * @api public
 */

Object.defineProperty(exports, "Promise", ({
  get: function get() {
    return PromiseProvider.get();
  },
  set: function set(lib) {
    PromiseProvider.set(lib);
  }
}));
/**
 * Storage layer for mongoose promises
 *
 * @method PromiseProvider
 * @api public
 */

exports.PromiseProvider = PromiseProvider;
/**
 * The [MongooseError](#error_MongooseError) constructor.
 *
 * @method Error
 * @api public
 */

exports.Error = __webpack_require__(4888);
/**
 * The Mongoose [Schema](#schema_Schema) constructor
 *
 * #### Example:
 *
 *     const mongoose = require('mongoose');
 *     const Schema = mongoose.Schema;
 *     const CatSchema = new Schema(..);
 *
 * @method Schema
 * @api public
 */

exports.Schema = __webpack_require__(5506);
/**
 * The various Mongoose Types.
 *
 * #### Example:
 *
 *     const mongoose = require('mongoose');
 *     const array = mongoose.Types.Array;
 *
 * #### Types:
 *
 * - [Array](/docs/schematypes.html#arrays)
 * - [Buffer](/docs/schematypes.html#buffers)
 * - [Embedded](/docs/schematypes.html#schemas)
 * - [DocumentArray](/docs/api/documentarraypath.html)
 * - [Decimal128](/docs/api.html#mongoose_Mongoose-Decimal128)
 * - [ObjectId](/docs/schematypes.html#objectids)
 * - [Map](/docs/schematypes.html#maps)
 * - [Subdocument](/docs/schematypes.html#schemas)
 *
 * Using this exposed access to the `ObjectId` type, we can construct ids on demand.
 *
 *     const ObjectId = mongoose.Types.ObjectId;
 *     const id1 = new ObjectId;
 *
 * @property Types
 * @api public
 */

exports.Types = __webpack_require__(8941);
/**
 * The Mongoose [VirtualType](#virtualtype_VirtualType) constructor
 *
 * @method VirtualType
 * @api public
 */

exports.VirtualType = __webpack_require__(459);
/**
 * The various Mongoose SchemaTypes.
 *
 * #### Note:
 *
 * _Alias of mongoose.Schema.Types for backwards compatibility._
 *
 * @property SchemaTypes
 * @see Schema.SchemaTypes #schema_Schema.Types
 * @api public
 */

exports.SchemaType = __webpack_require__(4289);
/**
 * Internal utils
 *
 * @property utils
 * @api private
 */

exports.utils = __webpack_require__(6872);
/**
 * The Mongoose browser [Document](/api/document.html) constructor.
 *
 * @method Document
 * @api public
 */

exports.Document = DocumentProvider();
/**
 * Return a new browser model. In the browser, a model is just
 * a simplified document with a schema - it does **not** have
 * functions like `findOne()`, etc.
 *
 * @method model
 * @api public
 * @param {String} name
 * @param {Schema} schema
 * @return Class
 */

exports.model = function (name, schema) {
  var Model = /*#__PURE__*/function (_exports$Document) {
    _inherits(Model, _exports$Document);

    var _super = _createSuper(Model);

    function Model(obj, fields) {
      _classCallCheck(this, Model);

      return _super.call(this, obj, schema, fields);
    }

    return _createClass(Model);
  }(exports.Document);

  Model.modelName = name;
  return Model;
};
/*!
 * Module exports.
 */


if (typeof window !== 'undefined') {
  window.mongoose = module.exports;
  window.Buffer = Buffer;
}

/***/ }),

/***/ 3434:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var NodeJSDocument = __webpack_require__(8727);

var EventEmitter = (__webpack_require__(9620).EventEmitter);

var MongooseError = __webpack_require__(4888);

var Schema = __webpack_require__(5506);

var ObjectId = __webpack_require__(6079);

var ValidationError = MongooseError.ValidationError;

var applyHooks = __webpack_require__(8859);

var isObject = __webpack_require__(5721);
/**
 * Document constructor.
 *
 * @param {Object} obj the values to set
 * @param {Object} schema
 * @param {Object} [fields] optional object containing the fields which were selected in the query returning this document and any populated paths data
 * @param {Boolean} [skipId] bool, should we auto create an ObjectId _id
 * @inherits NodeJS EventEmitter https://nodejs.org/api/events.html#events_class_events_eventemitter
 * @event `init`: Emitted on a document after it has was retrieved from the db and fully hydrated by Mongoose.
 * @event `save`: Emitted when the document is successfully saved
 * @api private
 */


function Document(obj, schema, fields, skipId, skipInit) {
  if (!(this instanceof Document)) {
    return new Document(obj, schema, fields, skipId, skipInit);
  }

  if (isObject(schema) && !schema.instanceOfSchema) {
    schema = new Schema(schema);
  } // When creating EmbeddedDocument, it already has the schema and he doesn't need the _id


  schema = this.schema || schema; // Generate ObjectId if it is missing, but it requires a scheme

  if (!this.schema && schema.options._id) {
    obj = obj || {};

    if (obj._id === undefined) {
      obj._id = new ObjectId();
    }
  }

  if (!schema) {
    throw new MongooseError.MissingSchemaError();
  }

  this.$__setSchema(schema);
  NodeJSDocument.call(this, obj, fields, skipId, skipInit);
  applyHooks(this, schema, {
    decorateDoc: true
  }); // apply methods

  for (var m in schema.methods) {
    this[m] = schema.methods[m];
  } // apply statics


  for (var s in schema.statics) {
    this[s] = schema.statics[s];
  }
}
/*!
 * Inherit from the NodeJS document
 */


Document.prototype = Object.create(NodeJSDocument.prototype);
Document.prototype.constructor = Document;
/*!
 * ignore
 */

Document.events = new EventEmitter();
/*!
 * Browser doc exposes the event emitter API
 */

Document.$emitter = new EventEmitter();
['on', 'once', 'emit', 'listeners', 'removeListener', 'setMaxListeners', 'removeAllListeners', 'addListener'].forEach(function (emitterFn) {
  Document[emitterFn] = function () {
    return Document.$emitter[emitterFn].apply(Document.$emitter, arguments);
  };
});
/*!
 * Module exports.
 */

Document.ValidationError = ValidationError;
module.exports = exports = Document;

/***/ }),

/***/ 6787:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var CastError = __webpack_require__(1795);

var StrictModeError = __webpack_require__(3328);

var Types = __webpack_require__(5251);

var cast$expr = __webpack_require__(9739);

var castTextSearch = __webpack_require__(6495);

var get = __webpack_require__(9981);

var getConstructorName = __webpack_require__(1981);

var getSchemaDiscriminatorByValue = __webpack_require__(2392);

var isOperator = __webpack_require__(9627);

var util = __webpack_require__(161);

var isObject = __webpack_require__(5721);

var isMongooseObject = __webpack_require__(6584);

var ALLOWED_GEOWITHIN_GEOJSON_TYPES = ['Polygon', 'MultiPolygon'];
/**
 * Handles internal casting for query filters.
 *
 * @param {Schema} schema
 * @param {Object} obj Object to cast
 * @param {Object} options the query options
 * @param {Query} context passed to setters
 * @api private
 */

module.exports = function cast(schema, obj, options, context) {
  if (Array.isArray(obj)) {
    throw new Error('Query filter must be an object, got an array ', util.inspect(obj));
  }

  if (obj == null) {
    return obj;
  }

  if (schema != null && schema.discriminators != null && obj[schema.options.discriminatorKey] != null) {
    schema = getSchemaDiscriminatorByValue(schema, obj[schema.options.discriminatorKey]) || schema;
  }

  var paths = Object.keys(obj);
  var i = paths.length;

  var _keys;

  var any$conditionals;
  var schematype;
  var nested;
  var path;
  var type;
  var val;
  options = options || {};

  while (i--) {
    path = paths[i];
    val = obj[path];

    if (path === '$or' || path === '$nor' || path === '$and') {
      if (!Array.isArray(val)) {
        throw new CastError('Array', val, path);
      }

      for (var k = 0; k < val.length; ++k) {
        if (val[k] == null || _typeof(val[k]) !== 'object') {
          throw new CastError('Object', val[k], path + '.' + k);
        }

        val[k] = cast(schema, val[k], options, context);
      }
    } else if (path === '$where') {
      type = _typeof(val);

      if (type !== 'string' && type !== 'function') {
        throw new Error('Must have a string or function for $where');
      }

      if (type === 'function') {
        obj[path] = val.toString();
      }

      continue;
    } else if (path === '$expr') {
      val = cast$expr(val, schema);
      continue;
    } else if (path === '$elemMatch') {
      val = cast(schema, val, options, context);
    } else if (path === '$text') {
      val = castTextSearch(val, path);
    } else {
      if (!schema) {
        // no casting for Mixed types
        continue;
      }

      schematype = schema.path(path); // Check for embedded discriminator paths

      if (!schematype) {
        var split = path.split('.');
        var j = split.length;

        while (j--) {
          var pathFirstHalf = split.slice(0, j).join('.');
          var pathLastHalf = split.slice(j).join('.');

          var _schematype = schema.path(pathFirstHalf);

          var discriminatorKey = _schematype && _schematype.schema && _schematype.schema.options && _schematype.schema.options.discriminatorKey; // gh-6027: if we haven't found the schematype but this path is
          // underneath an embedded discriminator and the embedded discriminator
          // key is in the query, use the embedded discriminator schema

          if (_schematype != null && (_schematype.schema && _schematype.schema.discriminators) != null && discriminatorKey != null && pathLastHalf !== discriminatorKey) {
            var discriminatorVal = get(obj, pathFirstHalf + '.' + discriminatorKey);

            if (discriminatorVal != null) {
              schematype = _schematype.schema.discriminators[discriminatorVal].path(pathLastHalf);
            }
          }
        }
      }

      if (!schematype) {
        // Handle potential embedded array queries
        var _split = path.split('.');

        var _j = _split.length;

        var _pathFirstHalf = void 0;

        var _pathLastHalf = void 0;

        var remainingConds = void 0; // Find the part of the var path that is a path of the Schema

        while (_j--) {
          _pathFirstHalf = _split.slice(0, _j).join('.');
          schematype = schema.path(_pathFirstHalf);

          if (schematype) {
            break;
          }
        } // If a substring of the input path resolves to an actual real path...


        if (schematype) {
          // Apply the casting; similar code for $elemMatch in schema/array.js
          if (schematype.caster && schematype.caster.schema) {
            remainingConds = {};
            _pathLastHalf = _split.slice(_j).join('.');
            remainingConds[_pathLastHalf] = val;

            var ret = cast(schematype.caster.schema, remainingConds, options, context)[_pathLastHalf];

            if (ret === void 0) {
              delete obj[path];
            } else {
              obj[path] = ret;
            }
          } else {
            obj[path] = val;
          }

          continue;
        }

        if (isObject(val)) {
          // handle geo schemas that use object notation
          // { loc: { long: Number, lat: Number }
          var geo = '';

          if (val.$near) {
            geo = '$near';
          } else if (val.$nearSphere) {
            geo = '$nearSphere';
          } else if (val.$within) {
            geo = '$within';
          } else if (val.$geoIntersects) {
            geo = '$geoIntersects';
          } else if (val.$geoWithin) {
            geo = '$geoWithin';
          }

          if (geo) {
            var numbertype = new Types.Number('__QueryCasting__');
            var value = val[geo];

            if (val.$maxDistance != null) {
              val.$maxDistance = numbertype.castForQueryWrapper({
                val: val.$maxDistance,
                context: context
              });
            }

            if (val.$minDistance != null) {
              val.$minDistance = numbertype.castForQueryWrapper({
                val: val.$minDistance,
                context: context
              });
            }

            if (geo === '$within') {
              var withinType = value.$center || value.$centerSphere || value.$box || value.$polygon;

              if (!withinType) {
                throw new Error('Bad $within parameter: ' + JSON.stringify(val));
              }

              value = withinType;
            } else if (geo === '$near' && typeof value.type === 'string' && Array.isArray(value.coordinates)) {
              // geojson; cast the coordinates
              value = value.coordinates;
            } else if ((geo === '$near' || geo === '$nearSphere' || geo === '$geoIntersects') && value.$geometry && typeof value.$geometry.type === 'string' && Array.isArray(value.$geometry.coordinates)) {
              if (value.$maxDistance != null) {
                value.$maxDistance = numbertype.castForQueryWrapper({
                  val: value.$maxDistance,
                  context: context
                });
              }

              if (value.$minDistance != null) {
                value.$minDistance = numbertype.castForQueryWrapper({
                  val: value.$minDistance,
                  context: context
                });
              }

              if (isMongooseObject(value.$geometry)) {
                value.$geometry = value.$geometry.toObject({
                  transform: false,
                  virtuals: false
                });
              }

              value = value.$geometry.coordinates;
            } else if (geo === '$geoWithin') {
              if (value.$geometry) {
                if (isMongooseObject(value.$geometry)) {
                  value.$geometry = value.$geometry.toObject({
                    virtuals: false
                  });
                }

                var geoWithinType = value.$geometry.type;

                if (ALLOWED_GEOWITHIN_GEOJSON_TYPES.indexOf(geoWithinType) === -1) {
                  throw new Error('Invalid geoJSON type for $geoWithin "' + geoWithinType + '", must be "Polygon" or "MultiPolygon"');
                }

                value = value.$geometry.coordinates;
              } else {
                value = value.$box || value.$polygon || value.$center || value.$centerSphere;

                if (isMongooseObject(value)) {
                  value = value.toObject({
                    virtuals: false
                  });
                }
              }
            }

            _cast(value, numbertype, context);

            continue;
          }
        }

        if (schema.nested[path]) {
          continue;
        }

        var strict = 'strict' in options ? options.strict : schema.options.strict;
        var strictQuery = 'strictQuery' in options ? options.strictQuery : 'strict' in options ? options.strict : 'strict' in schema._userProvidedOptions ? schema._userProvidedOptions.strict : schema.options.strictQuery;

        if (options.upsert && strict) {
          if (strict === 'throw') {
            throw new StrictModeError(path);
          }

          throw new StrictModeError(path, 'Path "' + path + '" is not in ' + 'schema, strict mode is `true`, and upsert is `true`.');
        }

        if (strictQuery === 'throw') {
          throw new StrictModeError(path, 'Path "' + path + '" is not in ' + 'schema and strictQuery is \'throw\'.');
        } else if (strictQuery) {
          delete obj[path];
        }
      } else if (val == null) {
        continue;
      } else if (getConstructorName(val) === 'Object') {
        any$conditionals = Object.keys(val).some(isOperator);

        if (!any$conditionals) {
          obj[path] = schematype.castForQueryWrapper({
            val: val,
            context: context
          });
        } else {
          var ks = Object.keys(val);
          var $cond = void 0;
          var _k = ks.length;

          while (_k--) {
            $cond = ks[_k];
            nested = val[$cond];

            if ($cond === '$not') {
              if (nested && schematype) {
                _keys = Object.keys(nested);

                if (_keys.length && isOperator(_keys[0])) {
                  for (var key in nested) {
                    nested[key] = schematype.castForQueryWrapper({
                      $conditional: key,
                      val: nested[key],
                      context: context
                    });
                  }
                } else {
                  val[$cond] = schematype.castForQueryWrapper({
                    $conditional: $cond,
                    val: nested,
                    context: context
                  });
                }

                continue;
              }
            } else {
              val[$cond] = schematype.castForQueryWrapper({
                $conditional: $cond,
                val: nested,
                context: context
              });
            }
          }
        }
      } else if (Array.isArray(val) && ['Buffer', 'Array'].indexOf(schematype.instance) === -1) {
        var casted = [];
        var valuesArray = val;

        var _iterator = _createForOfIteratorHelper(valuesArray),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var _val = _step.value;
            casted.push(schematype.castForQueryWrapper({
              val: _val,
              context: context
            }));
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        obj[path] = {
          $in: casted
        };
      } else {
        obj[path] = schematype.castForQueryWrapper({
          val: val,
          context: context
        });
      }
    }
  }

  return obj;
};

function _cast(val, numbertype, context) {
  if (Array.isArray(val)) {
    val.forEach(function (item, i) {
      if (Array.isArray(item) || isObject(item)) {
        return _cast(item, numbertype, context);
      }

      val[i] = numbertype.castForQueryWrapper({
        val: item,
        context: context
      });
    });
  } else {
    var nearKeys = Object.keys(val);
    var nearLen = nearKeys.length;

    while (nearLen--) {
      var nkey = nearKeys[nearLen];
      var item = val[nkey];

      if (Array.isArray(item) || isObject(item)) {
        _cast(item, numbertype, context);

        val[nkey] = item;
      } else {
        val[nkey] = numbertype.castForQuery({
          val: item,
          context: context
        });
      }
    }
  }
}

/***/ }),

/***/ 6670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var CastError = __webpack_require__(1795);
/*!
 * Given a value, cast it to a boolean, or throw a `CastError` if the value
 * cannot be casted. `null` and `undefined` are considered valid.
 *
 * @param {Any} value
 * @param {String} [path] optional the path to set on the CastError
 * @return {Boolean|null|undefined}
 * @throws {CastError} if `value` is not one of the allowed values
 * @api private
 */


module.exports = function castBoolean(value, path) {
  if (module.exports.convertToTrue.has(value)) {
    return true;
  }

  if (module.exports.convertToFalse.has(value)) {
    return false;
  }

  if (value == null) {
    return value;
  }

  throw new CastError('boolean', value, path);
};

module.exports.convertToTrue = new Set([true, 'true', 1, '1', 'yes']);
module.exports.convertToFalse = new Set([false, 'false', 0, '0', 'no']);

/***/ }),

/***/ 195:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var assert = __webpack_require__(9373);

module.exports = function castDate(value) {
  // Support empty string because of empty form values. Originally introduced
  // in https://github.com/Automattic/mongoose/commit/efc72a1898fc3c33a319d915b8c5463a22938dfe
  if (value == null || value === '') {
    return null;
  }

  if (value instanceof Date) {
    assert.ok(!isNaN(value.valueOf()));
    return value;
  }

  var date;
  assert.ok(typeof value !== 'boolean');

  if (value instanceof Number || typeof value === 'number') {
    date = new Date(value);
  } else if (typeof value === 'string' && !isNaN(Number(value)) && (Number(value) >= 275761 || Number(value) < -271820)) {
    // string representation of milliseconds take this path
    date = new Date(Number(value));
  } else if (typeof value.valueOf === 'function') {
    // support for moment.js. This is also the path strings will take because
    // strings have a `valueOf()`
    date = new Date(value.valueOf());
  } else {
    // fallback
    date = new Date(value);
  }

  if (!isNaN(date.valueOf())) {
    return date;
  }

  assert.ok(false);
};

/***/ }),

/***/ 6209:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var Decimal128Type = __webpack_require__(5003);

var assert = __webpack_require__(9373);

module.exports = function castDecimal128(value) {
  if (value == null) {
    return value;
  }

  if (_typeof(value) === 'object' && typeof value.$numberDecimal === 'string') {
    return Decimal128Type.fromString(value.$numberDecimal);
  }

  if (value instanceof Decimal128Type) {
    return value;
  }

  if (typeof value === 'string') {
    return Decimal128Type.fromString(value);
  }

  if (Buffer.isBuffer(value)) {
    return new Decimal128Type(value);
  }

  if (typeof value === 'number') {
    return Decimal128Type.fromString(String(value));
  }

  if (typeof value.valueOf === 'function' && typeof value.valueOf() === 'string') {
    return Decimal128Type.fromString(value.valueOf());
  }

  assert.ok(false);
};

/***/ }),

/***/ 3065:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var assert = __webpack_require__(9373);
/*!
 * Given a value, cast it to a number, or throw an `Error` if the value
 * cannot be casted. `null` and `undefined` are considered valid.
 *
 * @param {Any} value
 * @return {Number}
 * @throws {Error} if `value` is not one of the allowed values
 * @api private
 */


module.exports = function castNumber(val) {
  if (val == null) {
    return val;
  }

  if (val === '') {
    return null;
  }

  if (typeof val === 'string' || typeof val === 'boolean') {
    val = Number(val);
  }

  assert.ok(!isNaN(val));

  if (val instanceof Number) {
    return val.valueOf();
  }

  if (typeof val === 'number') {
    return val;
  }

  if (!Array.isArray(val) && typeof val.valueOf === 'function') {
    return Number(val.valueOf());
  }

  if (val.toString && !Array.isArray(val) && val.toString() == Number(val)) {
    return Number(val);
  }

  assert.ok(false);
};

/***/ }),

/***/ 4731:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isBsonType = __webpack_require__(1563);

var ObjectId = (__webpack_require__(9906).get)().ObjectId;

module.exports = function castObjectId(value) {
  if (value == null) {
    return value;
  }

  if (isBsonType(value, 'ObjectID')) {
    return value;
  }

  if (value._id) {
    if (isBsonType(value._id, 'ObjectID')) {
      return value._id;
    }

    if (value._id.toString instanceof Function) {
      return new ObjectId(value._id.toString());
    }
  }

  if (value.toString instanceof Function) {
    return new ObjectId(value.toString());
  }

  return new ObjectId(value);
};

/***/ }),

/***/ 2417:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var CastError = __webpack_require__(1795);
/*!
 * Given a value, cast it to a string, or throw a `CastError` if the value
 * cannot be casted. `null` and `undefined` are considered valid.
 *
 * @param {Any} value
 * @param {String} [path] optional the path to set on the CastError
 * @return {string|null|undefined}
 * @throws {CastError}
 * @api private
 */


module.exports = function castString(value, path) {
  // If null or undefined
  if (value == null) {
    return value;
  } // handle documents being passed


  if (value._id && typeof value._id === 'string') {
    return value._id;
  } // Re: gh-647 and gh-3030, we're ok with casting using `toString()`
  // **unless** its the default Object.toString, because "[object Object]"
  // doesn't really qualify as useful data


  if (value.toString && value.toString !== Object.prototype.toString && !Array.isArray(value)) {
    return value.toString();
  }

  throw new CastError('string', value, path);
};

/***/ }),

/***/ 8727:
/***/ ((module, exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var EventEmitter = (__webpack_require__(9620).EventEmitter);

var InternalCache = __webpack_require__(6379);

var MongooseError = __webpack_require__(4888);

var MixedSchema = __webpack_require__(3861);

var ObjectExpectedError = __webpack_require__(4107);

var ObjectParameterError = __webpack_require__(900);

var ParallelValidateError = __webpack_require__(7962);

var Schema = __webpack_require__(5506);

var StrictModeError = __webpack_require__(3328);

var ValidationError = __webpack_require__(122);

var ValidatorError = __webpack_require__(2037);

var VirtualType = __webpack_require__(459);

var $__hasIncludedChildren = __webpack_require__(7427);

var promiseOrCallback = __webpack_require__(8486);

var cleanModifiedSubpaths = __webpack_require__(4134);

var compile = (__webpack_require__(8724)/* .compile */ .M);

var defineKey = (__webpack_require__(8724)/* .defineKey */ .c);

var flatten = (__webpack_require__(2829)/* .flatten */ .x);

var flattenObjectWithDottedPaths = __webpack_require__(207);

var get = __webpack_require__(9981);

var getEmbeddedDiscriminatorPath = __webpack_require__(111);

var getKeysInSchemaOrder = __webpack_require__(37);

var handleSpreadDoc = __webpack_require__(719);

var immediate = __webpack_require__(1490);

var isDefiningProjection = __webpack_require__(2183);

var isExclusive = __webpack_require__(9098);

var inspect = (__webpack_require__(161).inspect);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var markArraySubdocsPopulated = __webpack_require__(5837);

var mpath = __webpack_require__(3564);

var queryhelpers = __webpack_require__(2888);

var utils = __webpack_require__(6872);

var isPromise = __webpack_require__(5543);

var clone = utils.clone;
var deepEqual = utils.deepEqual;
var isMongooseObject = utils.isMongooseObject;

var arrayAtomicsBackupSymbol = (__webpack_require__(8770).arrayAtomicsBackupSymbol);

var arrayAtomicsSymbol = (__webpack_require__(8770).arrayAtomicsSymbol);

var documentArrayParent = (__webpack_require__(8770).documentArrayParent);

var documentIsModified = (__webpack_require__(8770).documentIsModified);

var documentModifiedPaths = (__webpack_require__(8770).documentModifiedPaths);

var documentSchemaSymbol = (__webpack_require__(8770).documentSchemaSymbol);

var getSymbol = (__webpack_require__(8770).getSymbol);

var populateModelSymbol = (__webpack_require__(8770).populateModelSymbol);

var scopeSymbol = (__webpack_require__(8770).scopeSymbol);

var schemaMixedSymbol = (__webpack_require__(8107).schemaMixedSymbol);

var parentPaths = __webpack_require__(251);

var DocumentArray;
var MongooseArray;
var Embedded;
var specialProperties = utils.specialProperties;
/**
 * The core Mongoose document constructor. You should not call this directly,
 * the Mongoose [Model constructor](./api.html#Model) calls this for you.
 *
 * @param {Object} obj the values to set
 * @param {Object} [fields] optional object containing the fields which were selected in the query returning this document and any populated paths data
 * @param {Object} [options] various configuration options for the document
 * @param {Boolean} [options.defaults=true] if `false`, skip applying default values to this document.
 * @inherits NodeJS EventEmitter https://nodejs.org/api/events.html#events_class_events_eventemitter
 * @event `init`: Emitted on a document after it has been retrieved from the db and fully hydrated by Mongoose.
 * @event `save`: Emitted when the document is successfully saved
 * @api private
 */

function Document(obj, fields, skipId, options) {
  if (_typeof(skipId) === 'object' && skipId != null) {
    options = skipId;
    skipId = options.skipId;
  }

  options = Object.assign({}, options); // Support `browserDocument.js` syntax

  if (this.$__schema == null) {
    var _schema = utils.isObject(fields) && !fields.instanceOfSchema ? new Schema(fields) : fields;

    this.$__setSchema(_schema);
    fields = skipId;
    skipId = options;
    options = arguments[4] || {};
  }

  this.$__ = new InternalCache();
  this.$isNew = 'isNew' in options ? options.isNew : true;

  if (options.priorDoc != null) {
    this.$__.priorDoc = options.priorDoc;
  }

  if (skipId) {
    this.$__.skipId = skipId;
  }

  if (obj != null && _typeof(obj) !== 'object') {
    throw new ObjectParameterError(obj, 'obj', 'Document');
  }

  var defaults = true;

  if (options.defaults !== undefined) {
    this.$__.defaults = options.defaults;
    defaults = options.defaults;
  }

  var schema = this.$__schema;

  if (typeof fields === 'boolean' || fields === 'throw') {
    this.$__.strictMode = fields;
    fields = undefined;
  } else {
    this.$__.strictMode = schema.options.strict;

    if (fields != null) {
      this.$__.selected = fields;
    }
  }

  var requiredPaths = schema.requiredPaths(true);

  var _iterator = _createForOfIteratorHelper(requiredPaths),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var path = _step.value;

      this.$__.activePaths.require(path);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var exclude = null; // determine if this doc is a result of a query with
  // excluded fields

  if (utils.isPOJO(fields)) {
    exclude = isExclusive(fields);
    this.$__.fields = fields;
    this.$__.exclude = exclude;
  }

  var hasIncludedChildren = exclude === false && fields ? $__hasIncludedChildren(fields) : null;

  if (this._doc == null) {
    this.$__buildDoc(obj, fields, skipId, exclude, hasIncludedChildren, false); // By default, defaults get applied **before** setting initial values
    // Re: gh-6155

    if (defaults) {
      $__applyDefaults(this, fields, exclude, hasIncludedChildren, true, null);
    }
  }

  if (obj) {
    // Skip set hooks
    if (this.$__original_set) {
      this.$__original_set(obj, undefined, true, options);
    } else {
      this.$set(obj, undefined, true, options);
    }

    if (obj instanceof Document) {
      this.$isNew = obj.$isNew;
    }
  } // Function defaults get applied **after** setting initial values so they
  // see the full doc rather than an empty one, unless they opt out.
  // Re: gh-3781, gh-6155


  if (options.willInit && defaults) {
    if (options.skipDefaults) {
      this.$__.skipDefaults = options.skipDefaults;
    }
  } else if (defaults) {
    $__applyDefaults(this, fields, exclude, hasIncludedChildren, false, options.skipDefaults);
  }

  if (!this.$__.strictMode && obj) {
    var _this = this;

    var keys = Object.keys(this._doc);
    keys.forEach(function (key) {
      // Avoid methods, virtuals, existing fields, and `$` keys. The latter is to avoid overwriting
      // Mongoose internals.
      if (!(key in schema.tree) && !(key in schema.methods) && !(key in schema.virtuals) && !key.startsWith('$')) {
        defineKey({
          prop: key,
          subprops: null,
          prototype: _this
        });
      }
    });
  }

  applyQueue(this);
}

Object.defineProperty(Document.prototype, 'isNew', {
  get: function get() {
    return this.$isNew;
  },
  set: function set(value) {
    this.$isNew = value;
  }
});
Object.defineProperty(Document.prototype, 'errors', {
  get: function get() {
    return this.$errors;
  },
  set: function set(value) {
    this.$errors = value;
  }
});
/*!
 * Document exposes the NodeJS event emitter API, so you can use
 * `on`, `once`, etc.
 */

utils.each(['on', 'once', 'emit', 'listeners', 'removeListener', 'setMaxListeners', 'removeAllListeners', 'addListener'], function (emitterFn) {
  Document.prototype[emitterFn] = function () {
    // Delay creating emitter until necessary because emitters take up a lot of memory,
    // especially for subdocuments.
    if (!this.$__.emitter) {
      if (emitterFn === 'emit') {
        return;
      }

      this.$__.emitter = new EventEmitter();
      this.$__.emitter.setMaxListeners(0);
    }

    return this.$__.emitter[emitterFn].apply(this.$__.emitter, arguments);
  };

  Document.prototype["$".concat(emitterFn)] = Document.prototype[emitterFn];
});
Document.prototype.constructor = Document;

for (var i in EventEmitter.prototype) {
  Document[i] = EventEmitter.prototype[i];
}
/**
 * The document's internal schema.
 *
 * @api private
 * @property schema
 * @memberOf Document
 * @instance
 */


Document.prototype.$__schema;
/**
 * The document's schema.
 *
 * @api public
 * @property schema
 * @memberOf Document
 * @instance
 */

Document.prototype.schema;
/**
 * Empty object that you can use for storing properties on the document. This
 * is handy for passing data to middleware without conflicting with Mongoose
 * internals.
 *
 * #### Example:
 *
 *     schema.pre('save', function() {
 *       // Mongoose will set `isNew` to `false` if `save()` succeeds
 *       this.$locals.wasNew = this.isNew;
 *     });
 *
 *     schema.post('save', function() {
 *       // Prints true if `isNew` was set before `save()`
 *       console.log(this.$locals.wasNew);
 *     });
 *
 * @api public
 * @property $locals
 * @memberOf Document
 * @instance
 */

Object.defineProperty(Document.prototype, '$locals', {
  configurable: false,
  enumerable: false,
  get: function get() {
    if (this.$__.locals == null) {
      this.$__.locals = {};
    }

    return this.$__.locals;
  },
  set: function set(v) {
    this.$__.locals = v;
  }
});
/**
 * Boolean flag specifying if the document is new.
 *
 * @api public
 * @property $isNew
 * @memberOf Document
 * @instance
 */

Document.prototype.$isNew;
/**
 * Boolean flag specifying if the document is new.
 *
 * @api public
 * @property isNew
 * @memberOf Document
 * @instance
 */

Document.prototype.isNew;
/**
 * Set this property to add additional query filters when Mongoose saves this document and `isNew` is false.
 *
 * #### Example:
 *
 *     // Make sure `save()` never updates a soft deleted document.
 *     schema.pre('save', function() {
 *       this.$where = { isDeleted: false };
 *     });
 *
 * @api public
 * @property $where
 * @memberOf Document
 * @instance
 */

Object.defineProperty(Document.prototype, '$where', {
  configurable: false,
  enumerable: false,
  writable: true
});
/**
 * The string version of this documents _id.
 *
 * #### Note:
 *
 * This getter exists on all documents by default. The getter can be disabled by setting the `id` [option](/docs/guide.html#id) of its `Schema` to false at construction time.
 *
 *     new Schema({ name: String }, { id: false });
 *
 * @api public
 * @see Schema options /docs/guide.html#options
 * @property id
 * @memberOf Document
 * @instance
 */

Document.prototype.id;
/**
 * Hash containing current validation $errors.
 *
 * @api public
 * @property $errors
 * @memberOf Document
 * @instance
 */

Document.prototype.$errors;
/**
 * Hash containing current validation errors.
 *
 * @api public
 * @property errors
 * @memberOf Document
 * @instance
 */

Document.prototype.errors;
/**
 * A string containing the current operation that Mongoose is executing
 * on this document. May be `null`, `'save'`, `'validate'`, or `'remove'`.
 *
 * #### Example:
 *
 *     const doc = new Model({ name: 'test' });
 *     doc.$op; // null
 *
 *     const promise = doc.save();
 *     doc.$op; // 'save'
 *
 *     await promise;
 *     doc.$op; // null
 *
 * @api public
 * @property $op
 * @memberOf Document
 * @instance
 */

Object.defineProperty(Document.prototype, '$op', {
  get: function get() {
    return this.$__.op || null;
  },
  set: function set(value) {
    this.$__.op = value;
  }
});
/*!
 * ignore
 */

function $__applyDefaults(doc, fields, exclude, hasIncludedChildren, isBeforeSetters, pathsToSkip) {
  var paths = Object.keys(doc.$__schema.paths);
  var plen = paths.length;

  for (var _i = 0; _i < plen; ++_i) {
    var def = void 0;
    var curPath = '';
    var p = paths[_i];

    if (p === '_id' && doc.$__.skipId) {
      continue;
    }

    var type = doc.$__schema.paths[p];
    var path = type.splitPath();
    var len = path.length;
    var included = false;
    var doc_ = doc._doc;

    for (var j = 0; j < len; ++j) {
      if (doc_ == null) {
        break;
      }

      var piece = path[j];
      curPath += (!curPath.length ? '' : '.') + piece;

      if (exclude === true) {
        if (curPath in fields) {
          break;
        }
      } else if (exclude === false && fields && !included) {
        var hasSubpaths = type.$isSingleNested || type.$isMongooseDocumentArray;

        if (curPath in fields || hasSubpaths && hasIncludedChildren != null && hasIncludedChildren[curPath]) {
          included = true;
        } else if (hasIncludedChildren != null && !hasIncludedChildren[curPath]) {
          break;
        }
      }

      if (j === len - 1) {
        if (doc_[piece] !== void 0) {
          break;
        }

        if (typeof type.defaultValue === 'function') {
          if (!type.defaultValue.$runBeforeSetters && isBeforeSetters) {
            break;
          }

          if (type.defaultValue.$runBeforeSetters && !isBeforeSetters) {
            break;
          }
        } else if (!isBeforeSetters) {
          // Non-function defaults should always run **before** setters
          continue;
        }

        if (pathsToSkip && pathsToSkip[curPath]) {
          break;
        }

        if (fields && exclude !== null) {
          if (exclude === true) {
            // apply defaults to all non-excluded fields
            if (p in fields) {
              continue;
            }

            try {
              def = type.getDefault(doc, false);
            } catch (err) {
              doc.invalidate(p, err);
              break;
            }

            if (typeof def !== 'undefined') {
              doc_[piece] = def;
              doc.$__.activePaths["default"](p);
            }
          } else if (included) {
            // selected field
            try {
              def = type.getDefault(doc, false);
            } catch (err) {
              doc.invalidate(p, err);
              break;
            }

            if (typeof def !== 'undefined') {
              doc_[piece] = def;
              doc.$__.activePaths["default"](p);
            }
          }
        } else {
          try {
            def = type.getDefault(doc, false);
          } catch (err) {
            doc.invalidate(p, err);
            break;
          }

          if (typeof def !== 'undefined') {
            doc_[piece] = def;
            doc.$__.activePaths["default"](p);
          }
        }
      } else {
        doc_ = doc_[piece];
      }
    }
  }
}
/*!
 * ignore
 */


function $applyDefaultsToNested(val, path, doc) {
  if (val == null) {
    return;
  }

  flattenObjectWithDottedPaths(val);
  var paths = Object.keys(doc.$__schema.paths);
  var plen = paths.length;
  var pathPieces = path.indexOf('.') === -1 ? [path] : path.split('.');

  for (var _i2 = 0; _i2 < plen; ++_i2) {
    var curPath = '';
    var p = paths[_i2];

    if (!p.startsWith(path + '.')) {
      continue;
    }

    var type = doc.$__schema.paths[p];
    var pieces = type.splitPath().slice(pathPieces.length);
    var len = pieces.length;

    if (type.defaultValue === void 0) {
      continue;
    }

    var cur = val;

    for (var j = 0; j < len; ++j) {
      if (cur == null) {
        break;
      }

      var piece = pieces[j];

      if (j === len - 1) {
        if (cur[piece] !== void 0) {
          break;
        }

        try {
          var def = type.getDefault(doc, false);

          if (def !== void 0) {
            cur[piece] = def;
          }
        } catch (err) {
          doc.invalidate(path + '.' + curPath, err);
          break;
        }

        break;
      }

      curPath += (!curPath.length ? '' : '.') + piece;
      cur[piece] = cur[piece] || {};
      cur = cur[piece];
    }
  }
}
/**
 * Builds the default doc structure
 *
 * @param {Object} obj
 * @param {Object} [fields]
 * @param {Boolean} [skipId]
 * @api private
 * @method $__buildDoc
 * @memberOf Document
 * @instance
 */


Document.prototype.$__buildDoc = function (obj, fields, skipId, exclude, hasIncludedChildren) {
  var doc = {};
  var paths = Object.keys(this.$__schema.paths). // Don't build up any paths that are underneath a map, we don't know
  // what the keys will be
  filter(function (p) {
    return !p.includes('$*');
  });
  var plen = paths.length;
  var ii = 0;

  for (; ii < plen; ++ii) {
    var p = paths[ii];

    if (p === '_id') {
      if (skipId) {
        continue;
      }

      if (obj && '_id' in obj) {
        continue;
      }
    }

    var path = this.$__schema.paths[p].splitPath();
    var len = path.length;
    var last = len - 1;
    var curPath = '';
    var doc_ = doc;
    var included = false;

    for (var _i3 = 0; _i3 < len; ++_i3) {
      var piece = path[_i3];

      if (!curPath.length) {
        curPath = piece;
      } else {
        curPath += '.' + piece;
      } // support excluding intermediary levels


      if (exclude === true) {
        if (curPath in fields) {
          break;
        }
      } else if (exclude === false && fields && !included) {
        if (curPath in fields) {
          included = true;
        } else if (!hasIncludedChildren[curPath]) {
          break;
        }
      }

      if (_i3 < last) {
        doc_ = doc_[piece] || (doc_[piece] = {});
      }
    }
  }

  this._doc = doc;
};
/*!
 * Converts to POJO when you use the document for querying
 */


Document.prototype.toBSON = function () {
  return this.toObject(internalToObjectOptions);
};
/**
 * Initializes the document without setters or marking anything modified.
 *
 * Called internally after a document is returned from mongodb. Normally,
 * you do **not** need to call this function on your own.
 *
 * This function triggers `init` [middleware](/docs/middleware.html).
 * Note that `init` hooks are [synchronous](/docs/middleware.html#synchronous).
 *
 * @param {Object} doc document returned by mongo
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.init = function (doc, opts, fn) {
  if (typeof opts === 'function') {
    fn = opts;
    opts = null;
  }

  this.$__init(doc, opts);

  if (fn) {
    fn(null, this);
  }

  return this;
};

Document.prototype.$init = function () {
  return this.constructor.prototype.init.apply(this, arguments);
};

Document.prototype.$__init = function (doc, opts) {
  this.$isNew = false;
  opts = opts || {}; // handle docs with populated paths
  // If doc._id is not null or undefined

  if (doc._id != null && opts.populated && opts.populated.length) {
    var id = String(doc._id);

    var _iterator2 = _createForOfIteratorHelper(opts.populated),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var item = _step2.value;

        if (item.isVirtual) {
          this.$populated(item.path, utils.getValue(item.path, doc), item);
        } else {
          this.$populated(item.path, item._docs[id], item);
        }

        if (item._childDocs == null) {
          continue;
        }

        var _iterator3 = _createForOfIteratorHelper(item._childDocs),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var child = _step3.value;

            if (child == null || child.$__ == null) {
              continue;
            }

            child.$__.parent = this;
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        item._childDocs = [];
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }

  init(this, doc, this._doc, opts);
  markArraySubdocsPopulated(this, opts.populated);
  this.$emit('init', this);
  this.constructor.emit('init', this);
  var hasIncludedChildren = this.$__.exclude === false && this.$__.fields ? $__hasIncludedChildren(this.$__.fields) : null;
  $__applyDefaults(this, this.$__.fields, this.$__.exclude, hasIncludedChildren, false, this.$__.skipDefaults);
  return this;
};
/*!
 * Init helper.
 *
 * @param {Object} self document instance
 * @param {Object} obj raw mongodb doc
 * @param {Object} doc object we are initializing
 * @api private
 */


function init(self, obj, doc, opts, prefix) {
  prefix = prefix || '';
  var keys = Object.keys(obj);
  var len = keys.length;
  var schemaType;
  var path;
  var i;
  var index = 0;
  var strict = self.$__.strictMode;
  var docSchema = self.$__schema;

  while (index < len) {
    _init(index++);
  }

  function _init(index) {
    i = keys[index];
    path = prefix + i;
    schemaType = docSchema.path(path); // Should still work if not a model-level discriminator, but should not be
    // necessary. This is *only* to catch the case where we queried using the
    // base model and the discriminated model has a projection

    if (docSchema.$isRootDiscriminator && !self.$__isSelected(path)) {
      return;
    }

    if (!schemaType && utils.isPOJO(obj[i])) {
      // assume nested object
      if (!doc[i]) {
        doc[i] = {};

        if (!strict && !(i in docSchema.tree) && !(i in docSchema.methods) && !(i in docSchema.virtuals)) {
          self[i] = doc[i];
        }
      }

      init(self, obj[i], doc[i], opts, path + '.');
    } else if (!schemaType) {
      doc[i] = obj[i];

      if (!strict && !prefix) {
        self[i] = obj[i];
      }
    } else {
      // Retain order when overwriting defaults
      if (doc.hasOwnProperty(i) && obj[i] !== void 0) {
        delete doc[i];
      }

      if (obj[i] === null) {
        doc[i] = schemaType._castNullish(null);
      } else if (obj[i] !== undefined) {
        var wasPopulated = obj[i].$__ == null ? null : obj[i].$__.wasPopulated;

        if (schemaType && !wasPopulated) {
          try {
            doc[i] = schemaType.cast(obj[i], self, true);
          } catch (e) {
            self.invalidate(e.path, new ValidatorError({
              path: e.path,
              message: e.message,
              type: 'cast',
              value: e.value,
              reason: e
            }));
          }
        } else {
          doc[i] = obj[i];
        }
      } // mark as hydrated


      if (!self.$isModified(path)) {
        self.$__.activePaths.init(path);
      }
    }
  }
}
/**
 * Sends an update command with this document `_id` as the query selector.
 *
 * #### Example:
 *
 *     weirdCar.update({$inc: {wheels:1}}, { w: 1 }, callback);
 *
 * #### Valid options:
 *
 *  - same as in [Model.update](#model_Model.update)
 *
 * @see Model.update #model_Model.update
 * @param {Object} doc
 * @param {Object} options
 * @param {Function} callback
 * @return {Query}
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.update = function update() {
  var args = Array.prototype.slice.call(arguments);
  args.unshift({
    _id: this._id
  });
  var query = this.constructor.update.apply(this.constructor, args);

  if (this.$session() != null) {
    if (!('session' in query.options)) {
      query.options.session = this.$session();
    }
  }

  return query;
};
/**
 * Sends an updateOne command with this document `_id` as the query selector.
 *
 * #### Example:
 *
 *     weirdCar.updateOne({$inc: {wheels:1}}, { w: 1 }, callback);
 *
 * #### Valid options:
 *
 *  - same as in [Model.updateOne](#model_Model.updateOne)
 *
 * @see Model.updateOne #model_Model.updateOne
 * @param {Object} doc
 * @param {Object} [options] optional see [`Query.prototype.setOptions()`](https://mongoosejs.com/docs/api.html#query_Query-setOptions)
 * @param {Object} [options.lean] if truthy, mongoose will return the document as a plain JavaScript object rather than a mongoose document. See [`Query.lean()`](/docs/api.html#query_Query-lean) and the [Mongoose lean tutorial](/docs/tutorials/lean.html).
 * @param {Boolean|String} [options.strict] overwrites the schema's [strict mode option](https://mongoosejs.com/docs/guide.html#strict)
 * @param {Boolean} [options.timestamps=null] If set to `false` and [schema-level timestamps](/docs/guide.html#timestamps) are enabled, skip timestamps for this update. Note that this allows you to overwrite timestamps. Does nothing if schema-level timestamps are not set.
 * @param {Function} callback
 * @return {Query}
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.updateOne = function updateOne(doc, options, callback) {
  var _this2 = this;

  var query = this.constructor.updateOne({
    _id: this._id
  }, doc, options);
  query.pre(function (cb) {
    _this2.constructor._middleware.execPre('updateOne', _this2, [_this2], cb);
  });
  query.post(function (cb) {
    _this2.constructor._middleware.execPost('updateOne', _this2, [_this2], {}, cb);
  });

  if (this.$session() != null) {
    if (!('session' in query.options)) {
      query.options.session = this.$session();
    }
  }

  if (callback != null) {
    return query.exec(callback);
  }

  return query;
};
/**
 * Sends a replaceOne command with this document `_id` as the query selector.
 *
 * #### Valid options:
 *
 *  - same as in [Model.replaceOne](https://mongoosejs.com/docs/api/model.html#model_Model.replaceOne)
 *
 * @see Model.replaceOne #model_Model.replaceOne
 * @param {Object} doc
 * @param {Object} options
 * @param {Function} callback
 * @return {Query}
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.replaceOne = function replaceOne() {
  var args = Array.prototype.slice.call(arguments);
  args.unshift({
    _id: this._id
  });
  return this.constructor.replaceOne.apply(this.constructor, args);
};
/**
 * Getter/setter around the session associated with this document. Used to
 * automatically set `session` if you `save()` a doc that you got from a
 * query with an associated session.
 *
 * #### Example:
 *
 *     const session = MyModel.startSession();
 *     const doc = await MyModel.findOne().session(session);
 *     doc.$session() === session; // true
 *     doc.$session(null);
 *     doc.$session() === null; // true
 *
 * If this is a top-level document, setting the session propagates to all child
 * docs.
 *
 * @param {ClientSession} [session] overwrite the current session
 * @return {ClientSession}
 * @method $session
 * @api public
 * @memberOf Document
 */


Document.prototype.$session = function $session(session) {
  if (arguments.length === 0) {
    if (this.$__.session != null && this.$__.session.hasEnded) {
      this.$__.session = null;
      return null;
    }

    return this.$__.session;
  }

  if (session != null && session.hasEnded) {
    throw new MongooseError('Cannot set a document\'s session to a session that has ended. Make sure you haven\'t ' + 'called `endSession()` on the session you are passing to `$session()`.');
  }

  if (session == null && this.$__.session == null) {
    return;
  }

  this.$__.session = session;

  if (!this.$isSubdocument) {
    var subdocs = this.$getAllSubdocs();

    var _iterator4 = _createForOfIteratorHelper(subdocs),
        _step4;

    try {
      for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
        var child = _step4.value;
        child.$session(session);
      }
    } catch (err) {
      _iterator4.e(err);
    } finally {
      _iterator4.f();
    }
  }

  return session;
};
/**
 * Overwrite all values in this document with the values of `obj`, except
 * for immutable properties. Behaves similarly to `set()`, except for it
 * unsets all properties that aren't in `obj`.
 *
 * @param {Object} obj the object to overwrite this document with
 * @method overwrite
 * @name overwrite
 * @memberOf Document
 * @instance
 * @api public
 */


Document.prototype.overwrite = function overwrite(obj) {
  var keys = Array.from(new Set(Object.keys(this._doc).concat(Object.keys(obj))));

  for (var _i4 = 0, _keys = keys; _i4 < _keys.length; _i4++) {
    var key = _keys[_i4];

    if (key === '_id') {
      continue;
    } // Explicitly skip version key


    if (this.$__schema.options.versionKey && key === this.$__schema.options.versionKey) {
      continue;
    }

    if (this.$__schema.options.discriminatorKey && key === this.$__schema.options.discriminatorKey) {
      continue;
    }

    this.$set(key, obj[key]);
  }

  return this;
};
/**
 * Alias for `set()`, used internally to avoid conflicts
 *
 * @param {String|Object} path path or object of key/vals to set
 * @param {Any} val the value to set
 * @param {Schema|String|Number|Buffer|*} [type] optionally specify a type for "on-the-fly" attributes
 * @param {Object} [options] optionally specify options that modify the behavior of the set
 * @param {Boolean} [options.merge=false] if true, setting a [nested path](/docs/subdocs.html#subdocuments-versus-nested-paths) will merge existing values rather than overwrite the whole object. So `doc.set('nested', { a: 1, b: 2 })` becomes `doc.set('nested.a', 1); doc.set('nested.b', 2);`
 * @method $set
 * @name $set
 * @memberOf Document
 * @instance
 * @api public
 */


Document.prototype.$set = function $set(path, val, type, options) {
  var _this3 = this;

  if (utils.isPOJO(type)) {
    options = type;
    type = undefined;
  }

  var merge = options && options.merge;
  var adhoc = type && type !== true;
  var constructing = type === true;
  var adhocs;
  var keys;
  var i = 0;
  var pathtype;
  var key;
  var prefix;
  var strict = options && 'strict' in options ? options.strict : this.$__.strictMode;

  if (adhoc) {
    adhocs = this.$__.adhocPaths || (this.$__.adhocPaths = {});
    adhocs[path] = this.$__schema.interpretAsType(path, type, this.$__schema.options);
  }

  if (path == null) {
    var _ref = [val, path];
    path = _ref[0];
    val = _ref[1];
  } else if (typeof path !== 'string') {
    // new Document({ key: val })
    if (path instanceof Document) {
      if (path.$__isNested) {
        path = path.toObject();
      } else {
        path = path._doc;
      }
    }

    if (path == null) {
      var _ref2 = [val, path];
      path = _ref2[0];
      val = _ref2[1];
    }

    prefix = val ? val + '.' : '';
    keys = getKeysInSchemaOrder(this.$__schema, path);
    var len = keys.length; // `_skipMinimizeTopLevel` is because we may have deleted the top-level
    // nested key to ensure key order.

    var _skipMinimizeTopLevel = options && options._skipMinimizeTopLevel || false;

    if (len === 0 && _skipMinimizeTopLevel) {
      delete options._skipMinimizeTopLevel;

      if (val) {
        this.$set(val, {});
      }

      return this;
    }

    for (var _i5 = 0; _i5 < len; ++_i5) {
      key = keys[_i5];
      var pathName = prefix + key;
      pathtype = this.$__schema.pathType(pathName);
      var valForKey = path[key]; // On initial set, delete any nested keys if we're going to overwrite
      // them to ensure we keep the user's key order.

      if (type === true && !prefix && valForKey != null && pathtype === 'nested' && this._doc[key] != null) {
        delete this._doc[key]; // Make sure we set `{}` back even if we minimize re: gh-8565

        options = Object.assign({}, options, {
          _skipMinimizeTopLevel: true
        });
      } else {
        // Make sure we set `{_skipMinimizeTopLevel: false}` if don't have overwrite: gh-10441
        options = Object.assign({}, options, {
          _skipMinimizeTopLevel: false
        });
      }

      if (utils.isNonBuiltinObject(valForKey) && pathtype === 'nested') {
        $applyDefaultsToNested(path[key], prefix + key, this);
        this.$set(prefix + key, path[key], constructing, Object.assign({}, options, {
          _skipMarkModified: true
        }));
        continue;
      } else if (strict) {
        // Don't overwrite defaults with undefined keys (gh-3981) (gh-9039)
        if (constructing && path[key] === void 0 && this.$get(pathName) !== void 0) {
          continue;
        }

        if (pathtype === 'adhocOrUndefined') {
          pathtype = getEmbeddedDiscriminatorPath(this, pathName, {
            typeOnly: true
          });
        }

        if (pathtype === 'real' || pathtype === 'virtual') {
          var p = path[key];
          this.$set(prefix + key, p, constructing, options);
        } else if (pathtype === 'nested' && path[key] instanceof Document) {
          this.$set(prefix + key, path[key].toObject({
            transform: false
          }), constructing, options);
        } else if (strict === 'throw') {
          if (pathtype === 'nested') {
            throw new ObjectExpectedError(key, path[key]);
          } else {
            throw new StrictModeError(key);
          }
        }
      } else if (path[key] !== void 0) {
        this.$set(prefix + key, path[key], constructing, options);
      }
    } // Ensure all properties are in correct order


    var orderedDoc = {};
    var orderedKeys = Object.keys(this.$__schema.tree);

    for (var _i6 = 0, _len = orderedKeys.length; _i6 < _len; ++_i6) {
      (key = orderedKeys[_i6]) && this._doc.hasOwnProperty(key) && (orderedDoc[key] = undefined);
    }

    this._doc = Object.assign(orderedDoc, this._doc);
    return this;
  }

  var pathType = this.$__schema.pathType(path);

  if (pathType === 'adhocOrUndefined') {
    pathType = getEmbeddedDiscriminatorPath(this, path, {
      typeOnly: true
    });
  } // Assume this is a Mongoose document that was copied into a POJO using
  // `Object.assign()` or `{...doc}`


  val = handleSpreadDoc(val); // if this doc is being constructed we should not trigger getters

  var priorVal = function () {
    if (_this3.$__.priorDoc != null) {
      return _this3.$__.priorDoc.$__getValue(path);
    }

    if (constructing) {
      return void 0;
    }

    return _this3.$__getValue(path);
  }();

  if (pathType === 'nested' && val) {
    if (_typeof(val) === 'object' && val != null) {
      if (val.$__ != null) {
        val = val.toObject(internalToObjectOptions);
      }

      if (val == null) {
        this.invalidate(path, new MongooseError.CastError('Object', val, path));
        return this;
      }

      var hasInitialVal = this.$__.savedState != null && this.$__.savedState.hasOwnProperty(path);

      if (this.$__.savedState != null && !this.$isNew && !this.$__.savedState.hasOwnProperty(path)) {
        var initialVal = this.$__getValue(path);
        this.$__.savedState[path] = initialVal;

        var _keys3 = Object.keys(initialVal || {});

        for (var _i7 = 0, _keys4 = _keys3; _i7 < _keys4.length; _i7++) {
          var _key = _keys4[_i7];
          this.$__.savedState[path + '.' + _key] = initialVal[_key];
        }
      }

      if (!merge) {
        this.$__setValue(path, null);
        cleanModifiedSubpaths(this, path);
      } else {
        return this.$set(val, path, constructing);
      }

      var _keys2 = getKeysInSchemaOrder(this.$__schema, val, path);

      this.$__setValue(path, {});

      var _iterator5 = _createForOfIteratorHelper(_keys2),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var _key2 = _step5.value;
          this.$set(path + '.' + _key2, val[_key2], constructing, options);
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }

      if (priorVal != null && utils.deepEqual(hasInitialVal ? this.$__.savedState[path] : priorVal, val)) {
        this.unmarkModified(path);
      } else {
        this.markModified(path);
      }

      return this;
    }

    this.invalidate(path, new MongooseError.CastError('Object', val, path));
    return this;
  }

  var schema;
  var parts = path.indexOf('.') === -1 ? [path] : path.split('.'); // Might need to change path for top-level alias

  if (typeof this.$__schema.aliases[parts[0]] === 'string') {
    parts[0] = this.$__schema.aliases[parts[0]];
  }

  if (pathType === 'adhocOrUndefined' && strict) {
    // check for roots that are Mixed types
    var mixed;

    for (i = 0; i < parts.length; ++i) {
      var subpath = parts.slice(0, i + 1).join('.'); // If path is underneath a virtual, bypass everything and just set it.

      if (i + 1 < parts.length && this.$__schema.pathType(subpath) === 'virtual') {
        mpath.set(path, val, this);
        return this;
      }

      schema = this.$__schema.path(subpath);

      if (schema == null) {
        continue;
      }

      if (schema instanceof MixedSchema) {
        // allow changes to sub paths of mixed types
        mixed = true;
        break;
      }
    }

    if (schema == null) {
      // Check for embedded discriminators
      schema = getEmbeddedDiscriminatorPath(this, path);
    }

    if (!mixed && !schema) {
      if (strict === 'throw') {
        throw new StrictModeError(path);
      }

      return this;
    }
  } else if (pathType === 'virtual') {
    schema = this.$__schema.virtualpath(path);
    schema.applySetters(val, this);
    return this;
  } else {
    schema = this.$__path(path);
  } // gh-4578, if setting a deeply nested path that doesn't exist yet, create it


  var cur = this._doc;
  var curPath = '';

  for (i = 0; i < parts.length - 1; ++i) {
    cur = cur[parts[i]];
    curPath += (curPath.length !== 0 ? '.' : '') + parts[i];

    if (!cur) {
      this.$set(curPath, {}); // Hack re: gh-5800. If nested field is not selected, it probably exists
      // so `MongoServerError: cannot use the part (nested of nested.num) to
      // traverse the element ({nested: null})` is not likely. If user gets
      // that error, its their fault for now. We should reconsider disallowing
      // modifying not selected paths for 6.x

      if (!this.$__isSelected(curPath)) {
        this.unmarkModified(curPath);
      }

      cur = this.$__getValue(curPath);
    }
  }

  var pathToMark; // When using the $set operator the path to the field must already exist.
  // Else mongodb throws: "LEFT_SUBFIELD only supports Object"

  if (parts.length <= 1) {
    pathToMark = path;
  } else {
    var _len2 = parts.length;

    for (i = 0; i < _len2; ++i) {
      var _subpath = parts.slice(0, i + 1).join('.');

      if (this.$get(_subpath, null, {
        getters: false
      }) === null) {
        pathToMark = _subpath;
        break;
      }
    }

    if (!pathToMark) {
      pathToMark = path;
    }
  }

  if (!schema) {
    this.$__set(pathToMark, path, options, constructing, parts, schema, val, priorVal);

    if (pathType === 'nested' && val == null) {
      cleanModifiedSubpaths(this, path);
    }

    return this;
  } // If overwriting a subdocument path, make sure to clear out
  // any errors _before_ setting, so new errors that happen
  // get persisted. Re: #9080


  if (schema.$isSingleNested || schema.$isMongooseArray) {
    _markValidSubpaths(this, path);
  }

  if (val != null && merge && schema.$isSingleNested) {
    if (val instanceof Document) {
      val = val.toObject({
        virtuals: false,
        transform: false
      });
    }

    var _keys5 = Object.keys(val);

    for (var _i8 = 0, _keys6 = _keys5; _i8 < _keys6.length; _i8++) {
      var _key3 = _keys6[_i8];
      this.$set(path + '.' + _key3, val[_key3], constructing, options);
    }

    return this;
  }

  var shouldSet = true;

  try {
    // If the user is trying to set a ref path to a document with
    // the correct model name, treat it as populated
    var refMatches = function () {
      if (schema.options == null) {
        return false;
      }

      if (!(val instanceof Document)) {
        return false;
      }

      var model = val.constructor; // Check ref

      var ref = schema.options.ref;

      if (ref != null && (ref === model.modelName || ref === model.baseModelName)) {
        return true;
      } // Check refPath


      var refPath = schema.options.refPath;

      if (refPath == null) {
        return false;
      }

      var modelName = val.get(refPath);
      return modelName === model.modelName || modelName === model.baseModelName;
    }();

    var didPopulate = false;

    if (refMatches && val instanceof Document && (!val.$__.wasPopulated || utils.deepEqual(val.$__.wasPopulated.value, val._id))) {
      var unpopulatedValue = schema && schema.$isSingleNested ? schema.cast(val, this) : val._id;
      this.$populated(path, unpopulatedValue, _defineProperty({}, populateModelSymbol, val.constructor));
      val.$__.wasPopulated = {
        value: unpopulatedValue
      };
      didPopulate = true;
    }

    var popOpts;
    var typeKey = this.$__schema.options.typeKey;

    if (schema.options && Array.isArray(schema.options[typeKey]) && schema.options[typeKey].length && schema.options[typeKey][0].ref && _isManuallyPopulatedArray(val, schema.options[typeKey][0].ref)) {
      popOpts = _defineProperty({}, populateModelSymbol, val[0].constructor);
      this.$populated(path, val.map(function (v) {
        return v._id;
      }), popOpts);

      var _iterator6 = _createForOfIteratorHelper(val),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var doc = _step6.value;
          doc.$__.wasPopulated = {
            value: doc._id
          };
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      didPopulate = true;
    }

    if (this.$__schema.singleNestedPaths[path] == null && (!refMatches || !schema.$isSingleNested || !val.$__)) {
      // If this path is underneath a single nested schema, we'll call the setter
      // later in `$__set()` because we don't take `_doc` when we iterate through
      // a single nested doc. That's to make sure we get the correct context.
      // Otherwise we would double-call the setter, see gh-7196.
      val = schema.applySetters(val, this, false, priorVal, options);
    }

    if (Array.isArray(val) && !Array.isArray(schema) && schema.$isMongooseDocumentArray && val.length !== 0 && val[0] != null && val[0].$__ != null && val[0].$__.populated != null) {
      var populatedPaths = Object.keys(val[0].$__.populated);

      var _loop = function _loop() {
        var populatedPath = _populatedPaths[_i9];

        _this3.$populated(path + '.' + populatedPath, val.map(function (v) {
          return v.$populated(populatedPath);
        }), val[0].$__.populated[populatedPath].options);
      };

      for (var _i9 = 0, _populatedPaths = populatedPaths; _i9 < _populatedPaths.length; _i9++) {
        _loop();
      }

      didPopulate = true;
    }

    if (!didPopulate && this.$__.populated) {
      // If this array partially contains populated documents, convert them
      // all to ObjectIds re: #8443
      if (Array.isArray(val) && this.$__.populated[path]) {
        for (var _i10 = 0; _i10 < val.length; ++_i10) {
          if (val[_i10] instanceof Document) {
            val.set(_i10, val[_i10]._id, true);
          }
        }
      }

      delete this.$__.populated[path];
    }

    if (val != null && schema.$isSingleNested) {
      _checkImmutableSubpaths(val, schema, priorVal);
    }

    this.$markValid(path);
  } catch (e) {
    if (e instanceof MongooseError.StrictModeError && e.isImmutableError) {
      this.invalidate(path, e);
    } else if (e instanceof MongooseError.CastError) {
      this.invalidate(e.path, e);

      if (e.$originalErrorPath) {
        this.invalidate(path, new MongooseError.CastError(schema.instance, val, path, e.$originalErrorPath));
      }
    } else {
      this.invalidate(path, new MongooseError.CastError(schema.instance, val, path, e));
    }

    shouldSet = false;
  }

  if (shouldSet) {
    var savedState = null;
    var savedStatePath = null;

    if (!constructing) {
      var _doc = this.$isSubdocument ? this.ownerDocument() : this;

      savedState = _doc.$__.savedState;
      savedStatePath = this.$isSubdocument ? this.$__.fullPath + '.' + path : path;

      if (savedState != null) {
        var firstDot = savedStatePath.indexOf('.');
        var topLevelPath = firstDot === -1 ? savedStatePath : savedStatePath.slice(0, firstDot);

        if (!savedState.hasOwnProperty(topLevelPath)) {
          savedState[topLevelPath] = utils.clone(_doc.$__getValue(topLevelPath));
        }
      }
    }

    this.$__set(pathToMark, path, options, constructing, parts, schema, val, priorVal);

    if (savedState != null && savedState.hasOwnProperty(savedStatePath) && utils.deepEqual(val, savedState[savedStatePath])) {
      this.unmarkModified(path);
    }
  }

  if (schema.$isSingleNested && (this.isDirectModified(path) || val == null)) {
    cleanModifiedSubpaths(this, path);
  }

  return this;
};
/*!
 * ignore
 */


function _isManuallyPopulatedArray(val, ref) {
  if (!Array.isArray(val)) {
    return false;
  }

  if (val.length === 0) {
    return false;
  }

  var _iterator7 = _createForOfIteratorHelper(val),
      _step7;

  try {
    for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
      var el = _step7.value;

      if (!(el instanceof Document)) {
        return false;
      }

      var modelName = el.constructor.modelName;

      if (modelName == null) {
        return false;
      }

      if (el.constructor.modelName != ref && el.constructor.baseModelName != ref) {
        return false;
      }
    }
  } catch (err) {
    _iterator7.e(err);
  } finally {
    _iterator7.f();
  }

  return true;
}
/**
 * Sets the value of a path, or many paths.
 *
 * #### Example:
 *
 *     // path, value
 *     doc.set(path, value)
 *
 *     // object
 *     doc.set({
 *         path  : value
 *       , path2 : {
 *            path  : value
 *         }
 *     })
 *
 *     // on-the-fly cast to number
 *     doc.set(path, value, Number)
 *
 *     // on-the-fly cast to string
 *     doc.set(path, value, String)
 *
 *     // changing strict mode behavior
 *     doc.set(path, value, { strict: false });
 *
 * @param {String|Object} path path or object of key/vals to set
 * @param {Any} val the value to set
 * @param {Schema|String|Number|Buffer|*} [type] optionally specify a type for "on-the-fly" attributes
 * @param {Object} [options] optionally specify options that modify the behavior of the set
 * @api public
 * @method set
 * @memberOf Document
 * @instance
 */


Document.prototype.set = Document.prototype.$set;
/**
 * Determine if we should mark this change as modified.
 *
 * @return {Boolean}
 * @api private
 * @method $__shouldModify
 * @memberOf Document
 * @instance
 */

Document.prototype.$__shouldModify = function (pathToMark, path, options, constructing, parts, schema, val, priorVal) {
  if (options && options._skipMarkModified) {
    return false;
  }

  if (this.$isNew) {
    return true;
  } // Re: the note about gh-7196, `val` is the raw value without casting or
  // setters if the full path is under a single nested subdoc because we don't
  // want to double run setters. So don't set it as modified. See gh-7264.


  if (this.$__schema.singleNestedPaths[path] != null) {
    return false;
  }

  if (val === void 0 && !this.$__isSelected(path)) {
    // when a path is not selected in a query, its initial
    // value will be undefined.
    return true;
  }

  if (val === void 0 && path in this.$__.activePaths.states["default"]) {
    // we're just unsetting the default value which was never saved
    return false;
  } // gh-3992: if setting a populated field to a doc, don't mark modified
  // if they have the same _id


  if (this.$populated(path) && val instanceof Document && deepEqual(val._id, priorVal)) {
    return false;
  }

  if (!deepEqual(val, priorVal || utils.getValue(path, this))) {
    return true;
  }

  if (!constructing && val !== null && val !== undefined && path in this.$__.activePaths.states["default"] && deepEqual(val, schema.getDefault(this, constructing))) {
    // a path with a default was $unset on the server
    // and the user is setting it to the same value again
    return true;
  }

  return false;
};
/**
 * Handles the actual setting of the value and marking the path modified if appropriate.
 *
 * @api private
 * @method $__set
 * @memberOf Document
 * @instance
 */


Document.prototype.$__set = function (pathToMark, path, options, constructing, parts, schema, val, priorVal) {
  Embedded = Embedded || __webpack_require__(1568);
  var shouldModify = this.$__shouldModify(pathToMark, path, options, constructing, parts, schema, val, priorVal);

  if (shouldModify) {
    this.markModified(pathToMark); // handle directly setting arrays (gh-1126)

    MongooseArray || (MongooseArray = __webpack_require__(1362));

    if (val && utils.isMongooseArray(val)) {
      val._registerAtomic('$set', val); // Update embedded document parent references (gh-5189)


      if (utils.isMongooseDocumentArray(val)) {
        val.forEach(function (item) {
          item && item.__parentArray && (item.__parentArray = val);
        });
      }
    }
  } else if (Array.isArray(val) && Array.isArray(priorVal) && utils.isMongooseArray(val) && utils.isMongooseArray(priorVal)) {
    val[arrayAtomicsSymbol] = priorVal[arrayAtomicsSymbol];
    val[arrayAtomicsBackupSymbol] = priorVal[arrayAtomicsBackupSymbol];

    if (utils.isMongooseDocumentArray(val)) {
      val.forEach(function (doc) {
        doc.isNew = false;
      });
    }
  }

  var obj = this._doc;
  var i = 0;
  var l = parts.length;
  var cur = '';

  for (; i < l; i++) {
    var next = i + 1;
    var last = next === l;
    cur += cur ? '.' + parts[i] : parts[i];

    if (specialProperties.has(parts[i])) {
      return;
    }

    if (last) {
      if (obj instanceof Map) {
        obj.set(parts[i], val);
      } else {
        obj[parts[i]] = val;
      }
    } else {
      if (utils.isPOJO(obj[parts[i]])) {
        obj = obj[parts[i]];
      } else if (obj[parts[i]] && obj[parts[i]] instanceof Embedded) {
        obj = obj[parts[i]];
      } else if (obj[parts[i]] && !Array.isArray(obj[parts[i]]) && obj[parts[i]].$isSingleNested) {
        obj = obj[parts[i]];
      } else if (obj[parts[i]] && Array.isArray(obj[parts[i]])) {
        obj = obj[parts[i]];
      } else {
        obj[parts[i]] = obj[parts[i]] || {};
        obj = obj[parts[i]];
      }
    }
  }
};
/**
 * Gets a raw value from a path (no getters)
 *
 * @param {String} path
 * @api private
 */


Document.prototype.$__getValue = function (path) {
  return utils.getValue(path, this._doc);
};
/**
 * Sets a raw value for a path (no casting, setters, transformations)
 *
 * @param {String} path
 * @param {Object} value
 * @api private
 */


Document.prototype.$__setValue = function (path, val) {
  utils.setValue(path, val, this._doc);
  return this;
};
/**
 * Returns the value of a path.
 *
 * #### Example
 *
 *     // path
 *     doc.get('age') // 47
 *
 *     // dynamic casting to a string
 *     doc.get('age', String) // "47"
 *
 * @param {String} path
 * @param {Schema|String|Number|Buffer|*} [type] optionally specify a type for on-the-fly attributes
 * @param {Object} [options]
 * @param {Boolean} [options.virtuals=false] Apply virtuals before getting this path
 * @param {Boolean} [options.getters=true] If false, skip applying getters and just get the raw value
 * @api public
 */


Document.prototype.get = function (path, type, options) {
  var adhoc;
  options = options || {};

  if (type) {
    adhoc = this.$__schema.interpretAsType(path, type, this.$__schema.options);
  }

  var schema = this.$__path(path);

  if (schema == null) {
    schema = this.$__schema.virtualpath(path);
  }

  if (schema instanceof MixedSchema) {
    var virtual = this.$__schema.virtualpath(path);

    if (virtual != null) {
      schema = virtual;
    }
  }

  var pieces = path.indexOf('.') === -1 ? [path] : path.split('.');
  var obj = this._doc;

  if (schema instanceof VirtualType) {
    return schema.applyGetters(void 0, this);
  } // Might need to change path for top-level alias


  if (typeof this.$__schema.aliases[pieces[0]] === 'string') {
    pieces[0] = this.$__schema.aliases[pieces[0]];
  }

  for (var _i11 = 0, l = pieces.length; _i11 < l; _i11++) {
    if (obj && obj._doc) {
      obj = obj._doc;
    }

    if (obj == null) {
      obj = void 0;
    } else if (obj instanceof Map) {
      obj = obj.get(pieces[_i11], {
        getters: false
      });
    } else if (_i11 === l - 1) {
      obj = utils.getValue(pieces[_i11], obj);
    } else {
      obj = obj[pieces[_i11]];
    }
  }

  if (adhoc) {
    obj = adhoc.cast(obj);
  }

  if (schema != null && options.getters !== false) {
    obj = schema.applyGetters(obj, this);
  } else if (this.$__schema.nested[path] && options.virtuals) {
    // Might need to apply virtuals if this is a nested path
    return applyVirtuals(this, utils.clone(obj) || {}, {
      path: path
    });
  }

  return obj;
};
/*!
 * ignore
 */


Document.prototype[getSymbol] = Document.prototype.get;
Document.prototype.$get = Document.prototype.get;
/**
 * Returns the schematype for the given `path`.
 *
 * @param {String} path
 * @api private
 * @method $__path
 * @memberOf Document
 * @instance
 */

Document.prototype.$__path = function (path) {
  var adhocs = this.$__.adhocPaths;
  var adhocType = adhocs && adhocs.hasOwnProperty(path) ? adhocs[path] : null;

  if (adhocType) {
    return adhocType;
  }

  return this.$__schema.path(path);
};
/**
 * Marks the path as having pending changes to write to the db.
 *
 * _Very helpful when using [Mixed](https://mongoosejs.com/docs/schematypes.html#mixed) types._
 *
 * #### Example:
 *
 *     doc.mixed.type = 'changed';
 *     doc.markModified('mixed.type');
 *     doc.save() // changes to mixed.type are now persisted
 *
 * @param {String} path the path to mark modified
 * @param {Document} [scope] the scope to run validators with
 * @api public
 */


Document.prototype.markModified = function (path, scope) {
  this.$__.activePaths.modify(path);

  if (scope != null && !this.$isSubdocument) {
    this.$__.pathsToScopes = this.$__pathsToScopes || {};
    this.$__.pathsToScopes[path] = scope;
  }
};
/**
 * Clears the modified state on the specified path.
 *
 * #### Example:
 *
 *     doc.foo = 'bar';
 *     doc.unmarkModified('foo');
 *     doc.save(); // changes to foo will not be persisted
 *
 * @param {String} path the path to unmark modified
 * @api public
 */


Document.prototype.unmarkModified = function (path) {
  this.$__.activePaths.init(path);

  if (this.$__.pathsToScopes != null) {
    delete this.$__.pathsToScopes[path];
  }
};
/**
 * Don't run validation on this path or persist changes to this path.
 *
 * #### Example:
 *
 *     doc.foo = null;
 *     doc.$ignore('foo');
 *     doc.save(); // changes to foo will not be persisted and validators won't be run
 *
 * @memberOf Document
 * @instance
 * @method $ignore
 * @param {String} path the path to ignore
 * @api public
 */


Document.prototype.$ignore = function (path) {
  this.$__.activePaths.ignore(path);
};
/**
 * Returns the list of paths that have been directly modified. A direct
 * modified path is a path that you explicitly set, whether via `doc.foo = 'bar'`,
 * `Object.assign(doc, { foo: 'bar' })`, or `doc.set('foo', 'bar')`.
 *
 * A path `a` may be in `modifiedPaths()` but not in `directModifiedPaths()`
 * because a child of `a` was directly modified.
 *
 * #### Example
 *     const schema = new Schema({ foo: String, nested: { bar: String } });
 *     const Model = mongoose.model('Test', schema);
 *     await Model.create({ foo: 'original', nested: { bar: 'original' } });
 *
 *     const doc = await Model.findOne();
 *     doc.nested.bar = 'modified';
 *     doc.directModifiedPaths(); // ['nested.bar']
 *     doc.modifiedPaths(); // ['nested', 'nested.bar']
 *
 * @return {Array}
 * @api public
 */


Document.prototype.directModifiedPaths = function () {
  return Object.keys(this.$__.activePaths.states.modify);
};
/**
 * Returns true if the given path is nullish or only contains empty objects.
 * Useful for determining whether this subdoc will get stripped out by the
 * [minimize option](/docs/guide.html#minimize).
 *
 * #### Example:
 *     const schema = new Schema({ nested: { foo: String } });
 *     const Model = mongoose.model('Test', schema);
 *     const doc = new Model({});
 *     doc.$isEmpty('nested'); // true
 *     doc.nested.$isEmpty(); // true
 *
 *     doc.nested.foo = 'bar';
 *     doc.$isEmpty('nested'); // false
 *     doc.nested.$isEmpty(); // false
 *
 * @memberOf Document
 * @instance
 * @api public
 * @method $isEmpty
 * @return {Boolean}
 */


Document.prototype.$isEmpty = function (path) {
  var isEmptyOptions = {
    minimize: true,
    virtuals: false,
    getters: false,
    transform: false
  };

  if (arguments.length !== 0) {
    var v = this.$get(path);

    if (v == null) {
      return true;
    }

    if (_typeof(v) !== 'object') {
      return false;
    }

    if (utils.isPOJO(v)) {
      return _isEmpty(v);
    }

    return Object.keys(v.toObject(isEmptyOptions)).length === 0;
  }

  return Object.keys(this.toObject(isEmptyOptions)).length === 0;
};

function _isEmpty(v) {
  if (v == null) {
    return true;
  }

  if (_typeof(v) !== 'object' || Array.isArray(v)) {
    return false;
  }

  for (var _i12 = 0, _Object$keys = Object.keys(v); _i12 < _Object$keys.length; _i12++) {
    var key = _Object$keys[_i12];

    if (!_isEmpty(v[key])) {
      return false;
    }
  }

  return true;
}
/**
 * Returns the list of paths that have been modified.
 *
 * @param {Object} [options]
 * @param {Boolean} [options.includeChildren=false] if true, returns children of modified paths as well. For example, if false, the list of modified paths for `doc.colors = { primary: 'blue' };` will **not** contain `colors.primary`. If true, `modifiedPaths()` will return an array that contains `colors.primary`.
 * @return {Array}
 * @api public
 */


Document.prototype.modifiedPaths = function (options) {
  options = options || {};
  var directModifiedPaths = Object.keys(this.$__.activePaths.states.modify);
  var result = new Set();
  var i = 0;
  var j = 0;
  var len = directModifiedPaths.length;

  for (i = 0; i < len; ++i) {
    var path = directModifiedPaths[i];
    var parts = parentPaths(path);
    var pLen = parts.length;

    for (j = 0; j < pLen; ++j) {
      result.add(parts[j]);
    }

    if (!options.includeChildren) {
      continue;
    }

    var ii = 0;
    var cur = this.$get(path);

    if (_typeof(cur) === 'object' && cur !== null) {
      if (cur._doc) {
        cur = cur._doc;
      }

      var _len3 = cur.length;

      if (Array.isArray(cur)) {
        for (ii = 0; ii < _len3; ++ii) {
          var subPath = path + '.' + ii;

          if (!result.has(subPath)) {
            result.add(subPath);

            if (cur[ii] != null && cur[ii].$__) {
              var modified = cur[ii].modifiedPaths();
              var iii = 0;
              var iiiLen = modified.length;

              for (iii = 0; iii < iiiLen; ++iii) {
                result.add(subPath + '.' + modified[iii]);
              }
            }
          }
        }
      } else {
        var keys = Object.keys(cur);
        var _ii = 0;
        var _len4 = keys.length;

        for (_ii = 0; _ii < _len4; ++_ii) {
          result.add(path + '.' + keys[_ii]);
        }
      }
    }
  }

  return Array.from(result);
};

Document.prototype[documentModifiedPaths] = Document.prototype.modifiedPaths;
/**
 * Returns true if any of the given paths is modified, else false. If no arguments, returns `true` if any path
 * in this document is modified.
 *
 * If `path` is given, checks if a path or any full path containing `path` as part of its path chain has been modified.
 *
 * #### Example
 *
 *     doc.set('documents.0.title', 'changed');
 *     doc.isModified()                      // true
 *     doc.isModified('documents')           // true
 *     doc.isModified('documents.0.title')   // true
 *     doc.isModified('documents otherProp') // true
 *     doc.isDirectModified('documents')     // false
 *
 * @param {String} [path] optional
 * @return {Boolean}
 * @api public
 */

Document.prototype.isModified = function (paths, modifiedPaths) {
  if (paths) {
    var directModifiedPaths = Object.keys(this.$__.activePaths.states.modify);

    if (directModifiedPaths.length === 0) {
      return false;
    }

    if (!Array.isArray(paths)) {
      paths = paths.indexOf(' ') === -1 ? [paths] : paths.split(' ');
    }

    var modified = modifiedPaths || this[documentModifiedPaths]();
    var isModifiedChild = paths.some(function (path) {
      return !!~modified.indexOf(path);
    });
    return isModifiedChild || paths.some(function (path) {
      return directModifiedPaths.some(function (mod) {
        return mod === path || path.startsWith(mod + '.');
      });
    });
  }

  return this.$__.activePaths.some('modify');
};

Document.prototype.$isModified = Document.prototype.isModified;
Document.prototype[documentIsModified] = Document.prototype.isModified;
/**
 * Checks if a path is set to its default.
 *
 * #### Example
 *
 *     MyModel = mongoose.model('test', { name: { type: String, default: 'Val '} });
 *     const m = new MyModel();
 *     m.$isDefault('name'); // true
 *
 * @memberOf Document
 * @instance
 * @method $isDefault
 * @param {String} [path]
 * @return {Boolean}
 * @api public
 */

Document.prototype.$isDefault = function (path) {
  var _this4 = this;

  if (path == null) {
    return this.$__.activePaths.some('default');
  }

  if (typeof path === 'string' && path.indexOf(' ') === -1) {
    return this.$__.activePaths.states["default"].hasOwnProperty(path);
  }

  var paths = path;

  if (!Array.isArray(paths)) {
    paths = paths.split(' ');
  }

  return paths.some(function (path) {
    return _this4.$__.activePaths.states["default"].hasOwnProperty(path);
  });
};
/**
 * Getter/setter, determines whether the document was removed or not.
 *
 * #### Example:
 *     const product = await product.remove();
 *     product.$isDeleted(); // true
 *     product.remove(); // no-op, doesn't send anything to the db
 *
 *     product.$isDeleted(false);
 *     product.$isDeleted(); // false
 *     product.remove(); // will execute a remove against the db
 *
 *
 * @param {Boolean} [val] optional, overrides whether mongoose thinks the doc is deleted
 * @return {Boolean} whether mongoose thinks this doc is deleted.
 * @method $isDeleted
 * @memberOf Document
 * @instance
 * @api public
 */


Document.prototype.$isDeleted = function (val) {
  if (arguments.length === 0) {
    return !!this.$__.isDeleted;
  }

  this.$__.isDeleted = !!val;
  return this;
};
/**
 * Returns true if `path` was directly set and modified, else false.
 *
 * #### Example
 *
 *     doc.set('documents.0.title', 'changed');
 *     doc.isDirectModified('documents.0.title') // true
 *     doc.isDirectModified('documents') // false
 *
 * @param {String|Array<String>} path
 * @return {Boolean}
 * @api public
 */


Document.prototype.isDirectModified = function (path) {
  var _this5 = this;

  if (path == null) {
    return this.$__.activePaths.some('modify');
  }

  if (typeof path === 'string' && path.indexOf(' ') === -1) {
    return this.$__.activePaths.states.modify.hasOwnProperty(path);
  }

  var paths = path;

  if (!Array.isArray(paths)) {
    paths = paths.split(' ');
  }

  return paths.some(function (path) {
    return _this5.$__.activePaths.states.modify.hasOwnProperty(path);
  });
};
/**
 * Checks if `path` is in the `init` state, that is, it was set by `Document#init()` and not modified since.
 *
 * @param {String} path
 * @return {Boolean}
 * @api public
 */


Document.prototype.isInit = function (path) {
  var _this6 = this;

  if (path == null) {
    return this.$__.activePaths.some('init');
  }

  if (typeof path === 'string' && path.indexOf(' ') === -1) {
    return this.$__.activePaths.states.init.hasOwnProperty(path);
  }

  var paths = path;

  if (!Array.isArray(paths)) {
    paths = paths.split(' ');
  }

  return paths.some(function (path) {
    return _this6.$__.activePaths.states.init.hasOwnProperty(path);
  });
};
/**
 * Checks if `path` was selected in the source query which initialized this document.
 *
 * #### Example
 *
 *     const doc = await Thing.findOne().select('name');
 *     doc.isSelected('name') // true
 *     doc.isSelected('age')  // false
 *
 * @param {String|Array<String>} path
 * @return {Boolean}
 * @api public
 */


Document.prototype.isSelected = function isSelected(path) {
  var _this7 = this;

  if (this.$__.selected == null) {
    return true;
  }

  if (!path) {
    return false;
  }

  if (path === '_id') {
    return this.$__.selected._id !== 0;
  }

  if (path.indexOf(' ') !== -1) {
    path = path.split(' ');
  }

  if (Array.isArray(path)) {
    return path.some(function (p) {
      return _this7.$__isSelected(p);
    });
  }

  var paths = Object.keys(this.$__.selected);
  var inclusive = null;

  if (paths.length === 1 && paths[0] === '_id') {
    // only _id was selected.
    return this.$__.selected._id === 0;
  }

  for (var _i13 = 0, _paths = paths; _i13 < _paths.length; _i13++) {
    var cur = _paths[_i13];

    if (cur === '_id') {
      continue;
    }

    if (!isDefiningProjection(this.$__.selected[cur])) {
      continue;
    }

    inclusive = !!this.$__.selected[cur];
    break;
  }

  if (inclusive === null) {
    return true;
  }

  if (path in this.$__.selected) {
    return inclusive;
  }

  var pathDot = path + '.';

  for (var _i14 = 0, _paths2 = paths; _i14 < _paths2.length; _i14++) {
    var _cur = _paths2[_i14];

    if (_cur === '_id') {
      continue;
    }

    if (_cur.startsWith(pathDot)) {
      return inclusive || _cur !== pathDot;
    }

    if (pathDot.startsWith(_cur + '.')) {
      return inclusive;
    }
  }

  return !inclusive;
};

Document.prototype.$__isSelected = Document.prototype.isSelected;
/**
 * Checks if `path` was explicitly selected. If no projection, always returns
 * true.
 *
 * #### Example
 *
 *     Thing.findOne().select('nested.name').exec(function (err, doc) {
 *        doc.isDirectSelected('nested.name') // true
 *        doc.isDirectSelected('nested.otherName') // false
 *        doc.isDirectSelected('nested')  // false
 *     })
 *
 * @param {String} path
 * @return {Boolean}
 * @api public
 */

Document.prototype.isDirectSelected = function isDirectSelected(path) {
  var _this8 = this;

  if (this.$__.selected == null) {
    return true;
  }

  if (path === '_id') {
    return this.$__.selected._id !== 0;
  }

  if (path.indexOf(' ') !== -1) {
    path = path.split(' ');
  }

  if (Array.isArray(path)) {
    return path.some(function (p) {
      return _this8.isDirectSelected(p);
    });
  }

  var paths = Object.keys(this.$__.selected);
  var inclusive = null;

  if (paths.length === 1 && paths[0] === '_id') {
    // only _id was selected.
    return this.$__.selected._id === 0;
  }

  for (var _i15 = 0, _paths3 = paths; _i15 < _paths3.length; _i15++) {
    var cur = _paths3[_i15];

    if (cur === '_id') {
      continue;
    }

    if (!isDefiningProjection(this.$__.selected[cur])) {
      continue;
    }

    inclusive = !!this.$__.selected[cur];
    break;
  }

  if (inclusive === null) {
    return true;
  }

  if (this.$__.selected.hasOwnProperty(path)) {
    return inclusive;
  }

  return !inclusive;
};
/**
 * Executes registered validation rules for this document.
 *
 * #### Note:
 *
 * This method is called `pre` save and if a validation rule is violated, [save](#model_Model-save) is aborted and the error is returned to your `callback`.
 *
 * #### Example:
 *
 *     doc.validate(function (err) {
 *       if (err) handleError(err);
 *       else // validation passed
 *     });
 *
 * @param {Array|String} [pathsToValidate] list of paths to validate. If set, Mongoose will validate only the modified paths that are in the given list.
 * @param {Object} [options] internal options
 * @param {Boolean} [options.validateModifiedOnly=false] if `true` mongoose validates only modified paths.
 * @param {Array|string} [options.pathsToSkip] list of paths to skip. If set, Mongoose will validate every modified path that is not in this list.
 * @param {Function} [callback] optional callback called after validation completes, passing an error if one occurred
 * @return {Promise} Promise
 * @api public
 */


Document.prototype.validate = function (pathsToValidate, options, callback) {
  var _this9 = this;

  var parallelValidate;
  this.$op = 'validate';

  if (this.$isSubdocument != null) {// Skip parallel validate check for subdocuments
  } else if (this.$__.validating) {
    parallelValidate = new ParallelValidateError(this, {
      parentStack: options && options.parentStack,
      conflictStack: this.$__.validating.stack
    });
  } else {
    this.$__.validating = new ParallelValidateError(this, {
      parentStack: options && options.parentStack
    });
  }

  if (arguments.length === 1) {
    if (_typeof(arguments[0]) === 'object' && !Array.isArray(arguments[0])) {
      options = arguments[0];
      callback = null;
      pathsToValidate = null;
    } else if (typeof arguments[0] === 'function') {
      callback = arguments[0];
      options = null;
      pathsToValidate = null;
    }
  } else if (typeof pathsToValidate === 'function') {
    callback = pathsToValidate;
    options = null;
    pathsToValidate = null;
  } else if (typeof options === 'function') {
    callback = options;
    options = pathsToValidate;
    pathsToValidate = null;
  }

  if (options && typeof options.pathsToSkip === 'string') {
    var isOnePathOnly = options.pathsToSkip.indexOf(' ') === -1;
    options.pathsToSkip = isOnePathOnly ? [options.pathsToSkip] : options.pathsToSkip.split(' ');
  }

  return promiseOrCallback(callback, function (cb) {
    if (parallelValidate != null) {
      return cb(parallelValidate);
    }

    _this9.$__validate(pathsToValidate, options, function (error) {
      _this9.$op = null;
      _this9.$__.validating = null;
      cb(error);
    });
  }, this.constructor.events);
};

Document.prototype.$validate = Document.prototype.validate;
/*!
 * ignore
 */

function _evaluateRequiredFunctions(doc) {
  var requiredFields = Object.keys(doc.$__.activePaths.states.require);
  var i = 0;
  var len = requiredFields.length;

  for (i = 0; i < len; ++i) {
    var path = requiredFields[i];
    var p = doc.$__schema.path(path);

    if (p != null && typeof p.originalRequiredValue === 'function') {
      doc.$__.cachedRequired = doc.$__.cachedRequired || {};

      try {
        doc.$__.cachedRequired[path] = p.originalRequiredValue.call(doc, doc);
      } catch (err) {
        doc.invalidate(path, err);
      }
    }
  }
}
/*!
 * ignore
 */


function _getPathsToValidate(doc) {
  var skipSchemaValidators = {};

  _evaluateRequiredFunctions(doc); // only validate required fields when necessary


  var paths = new Set(Object.keys(doc.$__.activePaths.states.require).filter(function (path) {
    if (!doc.$__isSelected(path) && !doc.$isModified(path)) {
      return false;
    }

    if (doc.$__.cachedRequired != null && path in doc.$__.cachedRequired) {
      return doc.$__.cachedRequired[path];
    }

    return true;
  }));
  Object.keys(doc.$__.activePaths.states.init).forEach(addToPaths);
  Object.keys(doc.$__.activePaths.states.modify).forEach(addToPaths);
  Object.keys(doc.$__.activePaths.states["default"]).forEach(addToPaths);

  function addToPaths(p) {
    paths.add(p);
  }

  var subdocs = doc.$getAllSubdocs();
  var modifiedPaths = doc.modifiedPaths();

  var _iterator8 = _createForOfIteratorHelper(subdocs),
      _step8;

  try {
    for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
      var subdoc = _step8.value;

      if (subdoc.$basePath) {
        // Remove child paths for now, because we'll be validating the whole
        // subdoc
        var fullPathToSubdoc = subdoc.$__fullPathWithIndexes();

        var _iterator13 = _createForOfIteratorHelper(paths),
            _step13;

        try {
          for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
            var p = _step13.value;

            if (p == null || p.startsWith(fullPathToSubdoc + '.')) {
              paths["delete"](p);
            }
          }
        } catch (err) {
          _iterator13.e(err);
        } finally {
          _iterator13.f();
        }

        if (doc.$isModified(fullPathToSubdoc, modifiedPaths) && !doc.isDirectModified(fullPathToSubdoc) && !doc.$isDefault(fullPathToSubdoc)) {
          paths.add(fullPathToSubdoc);
          skipSchemaValidators[fullPathToSubdoc] = true;
        }
      }
    }
  } catch (err) {
    _iterator8.e(err);
  } finally {
    _iterator8.f();
  }

  var _iterator9 = _createForOfIteratorHelper(paths),
      _step9;

  try {
    for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
      var path = _step9.value;

      var _pathType = doc.$__schema.path(path);

      if (!_pathType) {
        continue;
      }

      if (_pathType.$isMongooseDocumentArray) {
        var _iterator14 = _createForOfIteratorHelper(paths),
            _step14;

        try {
          for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
            var _p = _step14.value;

            if (_p == null || _p.startsWith(_pathType.path + '.')) {
              paths["delete"](_p);
            }
          }
        } catch (err) {
          _iterator14.e(err);
        } finally {
          _iterator14.f();
        }
      } // Optimization: if primitive path with no validators, or array of primitives
      // with no validators, skip validating this path entirely.


      if (!_pathType.caster && _pathType.validators.length === 0) {
        paths["delete"](path);
      } else if (_pathType.$isMongooseArray && !_pathType.$isMongooseDocumentArray && // Skip document arrays...
      !_pathType.$embeddedSchemaType.$isMongooseArray && // and arrays of arrays
      _pathType.validators.length === 0 && // and arrays with top-level validators
      _pathType.$embeddedSchemaType.validators.length === 0) {
        paths["delete"](path);
      }
    } // from here on we're not removing items from paths
    // gh-661: if a whole array is modified, make sure to run validation on all
    // the children as well

  } catch (err) {
    _iterator9.e(err);
  } finally {
    _iterator9.f();
  }

  var _iterator10 = _createForOfIteratorHelper(paths),
      _step10;

  try {
    for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
      var _path2 = _step10.value;

      var _pathType2 = doc.$__schema.path(_path2);

      if (!_pathType2) {
        continue;
      }

      if (!_pathType2.$isMongooseArray || // To avoid potential performance issues, skip doc arrays whose children
      // are not required. `getPositionalPathType()` may be slow, so avoid
      // it unless we have a case of #6364
      !Array.isArray(_pathType2) && _pathType2.$isMongooseDocumentArray && !(_pathType2 && _pathType2.schemaOptions && _pathType2.schemaOptions.required)) {
        continue;
      } // gh-11380: optimization. If the array isn't a document array and there's no validators
      // on the array type, there's no need to run validation on the individual array elements.


      if (_pathType2.$isMongooseArray && !_pathType2.$isMongooseDocumentArray && // Skip document arrays...
      !_pathType2.$embeddedSchemaType.$isMongooseArray && // and arrays of arrays
      _pathType2.$embeddedSchemaType.validators.length === 0) {
        continue;
      }

      var val = doc.$__getValue(_path2);

      _pushNestedArrayPaths(val, paths, _path2);
    }
  } catch (err) {
    _iterator10.e(err);
  } finally {
    _iterator10.f();
  }

  function _pushNestedArrayPaths(val, paths, path) {
    if (val != null) {
      var numElements = val.length;

      for (var j = 0; j < numElements; ++j) {
        if (Array.isArray(val[j])) {
          _pushNestedArrayPaths(val[j], paths, path + '.' + j);
        } else {
          paths.add(path + '.' + j);
        }
      }
    }
  }

  var flattenOptions = {
    skipArrays: true
  };

  var _iterator11 = _createForOfIteratorHelper(paths),
      _step11;

  try {
    for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
      var pathToCheck = _step11.value;

      if (doc.$__schema.nested[pathToCheck]) {
        var _v = doc.$__getValue(pathToCheck);

        if (isMongooseObject(_v)) {
          _v = _v.toObject({
            transform: false
          });
        }

        var flat = flatten(_v, pathToCheck, flattenOptions, doc.$__schema);
        Object.keys(flat).forEach(addToPaths);
      }
    }
  } catch (err) {
    _iterator11.e(err);
  } finally {
    _iterator11.f();
  }

  var _iterator12 = _createForOfIteratorHelper(paths),
      _step12;

  try {
    for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
      var _path3 = _step12.value;

      // Single nested paths (paths embedded under single nested subdocs) will
      // be validated on their own when we call `validate()` on the subdoc itself.
      // Re: gh-8468
      if (doc.$__schema.singleNestedPaths.hasOwnProperty(_path3)) {
        paths["delete"](_path3);
        continue;
      }

      var _pathType3 = doc.$__schema.path(_path3);

      if (!_pathType3 || !_pathType3.$isSchemaMap) {
        continue;
      }

      var _val = doc.$__getValue(_path3);

      if (_val == null) {
        continue;
      }

      var _iterator15 = _createForOfIteratorHelper(_val.keys()),
          _step15;

      try {
        for (_iterator15.s(); !(_step15 = _iterator15.n()).done;) {
          var key = _step15.value;
          paths.add(_path3 + '.' + key);
        }
      } catch (err) {
        _iterator15.e(err);
      } finally {
        _iterator15.f();
      }
    }
  } catch (err) {
    _iterator12.e(err);
  } finally {
    _iterator12.f();
  }

  paths = Array.from(paths);
  return [paths, skipSchemaValidators];
}
/*!
 * ignore
 */


Document.prototype.$__validate = function (pathsToValidate, options, callback) {
  var _this10 = this;

  if (typeof pathsToValidate === 'function') {
    callback = pathsToValidate;
    options = null;
    pathsToValidate = null;
  } else if (typeof options === 'function') {
    callback = options;
    options = null;
  }

  var hasValidateModifiedOnlyOption = options && _typeof(options) === 'object' && 'validateModifiedOnly' in options;
  var pathsToSkip = options && options.pathsToSkip || null;
  var shouldValidateModifiedOnly;

  if (hasValidateModifiedOnlyOption) {
    shouldValidateModifiedOnly = !!options.validateModifiedOnly;
  } else {
    shouldValidateModifiedOnly = this.$__schema.options.validateModifiedOnly;
  }

  var _this = this;

  var _complete = function _complete() {
    var validationError = _this10.$__.validationError;
    _this10.$__.validationError = null;
    _this10.$__.validating = null;

    if (shouldValidateModifiedOnly && validationError != null) {
      // Remove any validation errors that aren't from modified paths
      var errors = Object.keys(validationError.errors);

      for (var _i16 = 0, _errors = errors; _i16 < _errors.length; _i16++) {
        var errPath = _errors[_i16];

        if (!_this10.$isModified(errPath)) {
          delete validationError.errors[errPath];
        }
      }

      if (Object.keys(validationError.errors).length === 0) {
        validationError = void 0;
      }
    }

    _this10.$__.cachedRequired = {};

    _this10.$emit('validate', _this);

    _this10.constructor.emit('validate', _this);

    if (validationError) {
      for (var key in validationError.errors) {
        // Make sure cast errors persist
        if (!_this10[documentArrayParent] && validationError.errors[key] instanceof MongooseError.CastError) {
          _this10.invalidate(key, validationError.errors[key]);
        }
      }

      return validationError;
    }
  }; // only validate required fields when necessary


  var pathDetails = _getPathsToValidate(this);

  var paths = shouldValidateModifiedOnly ? pathDetails[0].filter(function (path) {
    return _this10.$isModified(path);
  }) : pathDetails[0];
  var skipSchemaValidators = pathDetails[1];

  if (typeof pathsToValidate === 'string') {
    pathsToValidate = pathsToValidate.split(' ');
  }

  if (Array.isArray(pathsToValidate)) {
    paths = _handlePathsToValidate(paths, pathsToValidate);
  } else if (pathsToSkip) {
    paths = _handlePathsToSkip(paths, pathsToSkip);
  }

  if (paths.length === 0) {
    return immediate(function () {
      var error = _complete();

      if (error) {
        return _this.$__schema.s.hooks.execPost('validate:error', _this, [_this], {
          error: error
        }, function (error) {
          callback(error);
        });
      }

      callback(null, _this);
    });
  }

  var validated = {};
  var total = 0;

  var _iterator16 = _createForOfIteratorHelper(paths),
      _step16;

  try {
    for (_iterator16.s(); !(_step16 = _iterator16.n()).done;) {
      var path = _step16.value;
      validatePath(path);
    }
  } catch (err) {
    _iterator16.e(err);
  } finally {
    _iterator16.f();
  }

  function validatePath(path) {
    if (path == null || validated[path]) {
      return;
    }

    validated[path] = true;
    total++;
    immediate(function () {
      var schemaType = _this.$__schema.path(path);

      if (!schemaType) {
        return --total || complete();
      } // If user marked as invalid or there was a cast error, don't validate


      if (!_this.$isValid(path)) {
        --total || complete();
        return;
      } // If setting a path under a mixed path, avoid using the mixed path validator (gh-10141)


      if (schemaType[schemaMixedSymbol] != null && path !== schemaType.path) {
        return --total || complete();
      }

      var val = _this.$__getValue(path); // If you `populate()` and get back a null value, required validators
      // shouldn't fail (gh-8018). We should always fall back to the populated
      // value.


      var pop;

      if (pop = _this.$populated(path)) {
        val = pop;
      } else if (val != null && val.$__ != null && val.$__.wasPopulated) {
        // Array paths, like `somearray.1`, do not show up as populated with `$populated()`,
        // so in that case pull out the document's id
        val = val._id;
      }

      var scope = _this.$__.pathsToScopes != null && path in _this.$__.pathsToScopes ? _this.$__.pathsToScopes[path] : _this;
      var doValidateOptions = {
        skipSchemaValidators: skipSchemaValidators[path],
        path: path,
        validateModifiedOnly: shouldValidateModifiedOnly
      };
      schemaType.doValidate(val, function (err) {
        if (err) {
          var isSubdoc = schemaType.$isSingleNested || schemaType.$isArraySubdocument || schemaType.$isMongooseDocumentArray;

          if (isSubdoc && err instanceof ValidationError) {
            return --total || complete();
          }

          _this.invalidate(path, err, undefined, true);
        }

        --total || complete();
      }, scope, doValidateOptions);
    });
  }

  function complete() {
    var error = _complete();

    if (error) {
      return _this.$__schema.s.hooks.execPost('validate:error', _this, [_this], {
        error: error
      }, function (error) {
        callback(error);
      });
    }

    callback(null, _this);
  }
};
/*!
 * ignore
 */


function _handlePathsToValidate(paths, pathsToValidate) {
  var _pathsToValidate = new Set(pathsToValidate);

  var parentPaths = new Map([]);

  var _iterator17 = _createForOfIteratorHelper(pathsToValidate),
      _step17;

  try {
    for (_iterator17.s(); !(_step17 = _iterator17.n()).done;) {
      var path = _step17.value;

      if (path.indexOf('.') === -1) {
        continue;
      }

      var pieces = path.split('.');
      var cur = pieces[0];

      for (var _i17 = 1; _i17 < pieces.length; ++_i17) {
        // Since we skip subpaths under single nested subdocs to
        // avoid double validation, we need to add back the
        // single nested subpath if the user asked for it (gh-8626)
        parentPaths.set(cur, path);
        cur = cur + '.' + pieces[_i17];
      }
    }
  } catch (err) {
    _iterator17.e(err);
  } finally {
    _iterator17.f();
  }

  var ret = [];

  var _iterator18 = _createForOfIteratorHelper(paths),
      _step18;

  try {
    for (_iterator18.s(); !(_step18 = _iterator18.n()).done;) {
      var _path4 = _step18.value;

      if (_pathsToValidate.has(_path4)) {
        ret.push(_path4);
      } else if (parentPaths.has(_path4)) {
        ret.push(parentPaths.get(_path4));
      }
    }
  } catch (err) {
    _iterator18.e(err);
  } finally {
    _iterator18.f();
  }

  return ret;
}
/*!
 * ignore
 */


function _handlePathsToSkip(paths, pathsToSkip) {
  pathsToSkip = new Set(pathsToSkip);
  paths = paths.filter(function (p) {
    return !pathsToSkip.has(p);
  });
  return paths;
}
/**
 * Executes registered validation rules (skipping asynchronous validators) for this document.
 *
 * #### Note:
 *
 * This method is useful if you need synchronous validation.
 *
 * #### Example:
 *
 *     const err = doc.validateSync();
 *     if (err) {
 *       handleError(err);
 *     } else {
 *       // validation passed
 *     }
 *
 * @param {Array|string} pathsToValidate only validate the given paths
 * @param {Object} [options] options for validation
 * @param {Boolean} [options.validateModifiedOnly=false] If `true`, Mongoose will only validate modified paths, as opposed to modified paths and `required` paths.
 * @param {Array|string} [options.pathsToSkip] list of paths to skip. If set, Mongoose will validate every modified path that is not in this list.
 * @return {ValidationError|undefined} ValidationError if there are errors during validation, or undefined if there is no error.
 * @api public
 */


Document.prototype.validateSync = function (pathsToValidate, options) {
  var _this11 = this;

  var _this = this;

  if (arguments.length === 1 && _typeof(arguments[0]) === 'object' && !Array.isArray(arguments[0])) {
    options = arguments[0];
    pathsToValidate = null;
  }

  var hasValidateModifiedOnlyOption = options && _typeof(options) === 'object' && 'validateModifiedOnly' in options;
  var shouldValidateModifiedOnly;

  if (hasValidateModifiedOnlyOption) {
    shouldValidateModifiedOnly = !!options.validateModifiedOnly;
  } else {
    shouldValidateModifiedOnly = this.$__schema.options.validateModifiedOnly;
  }

  var pathsToSkip = options && options.pathsToSkip;

  if (typeof pathsToValidate === 'string') {
    var isOnePathOnly = pathsToValidate.indexOf(' ') === -1;
    pathsToValidate = isOnePathOnly ? [pathsToValidate] : pathsToValidate.split(' ');
  } else if (typeof pathsToSkip === 'string' && pathsToSkip.indexOf(' ') !== -1) {
    pathsToSkip = pathsToSkip.split(' ');
  } // only validate required fields when necessary


  var pathDetails = _getPathsToValidate(this);

  var paths = shouldValidateModifiedOnly ? pathDetails[0].filter(function (path) {
    return _this11.$isModified(path);
  }) : pathDetails[0];
  var skipSchemaValidators = pathDetails[1];

  if (Array.isArray(pathsToValidate)) {
    paths = _handlePathsToValidate(paths, pathsToValidate);
  } else if (Array.isArray(pathsToSkip)) {
    paths = _handlePathsToSkip(paths, pathsToSkip);
  }

  var validating = {};

  for (var _i18 = 0, len = paths.length; _i18 < len; ++_i18) {
    var path = paths[_i18];

    if (validating[path]) {
      continue;
    }

    validating[path] = true;

    var p = _this.$__schema.path(path);

    if (!p) {
      continue;
    }

    if (!_this.$isValid(path)) {
      continue;
    }

    var val = _this.$__getValue(path);

    var _err = p.doValidateSync(val, _this, {
      skipSchemaValidators: skipSchemaValidators[path],
      path: path,
      validateModifiedOnly: shouldValidateModifiedOnly
    });

    if (_err) {
      var isSubdoc = p.$isSingleNested || p.$isArraySubdocument || p.$isMongooseDocumentArray;

      if (isSubdoc && _err instanceof ValidationError) {
        continue;
      }

      _this.invalidate(path, _err, undefined, true);
    }
  }

  var err = _this.$__.validationError;
  _this.$__.validationError = undefined;

  _this.$emit('validate', _this);

  _this.constructor.emit('validate', _this);

  if (err) {
    for (var key in err.errors) {
      // Make sure cast errors persist
      if (err.errors[key] instanceof MongooseError.CastError) {
        _this.invalidate(key, err.errors[key]);
      }
    }
  }

  return err;
};
/**
 * Marks a path as invalid, causing validation to fail.
 *
 * The `errorMsg` argument will become the message of the `ValidationError`.
 *
 * The `value` argument (if passed) will be available through the `ValidationError.value` property.
 *
 *     doc.invalidate('size', 'must be less than 20', 14);

 *     doc.validate(function (err) {
 *       console.log(err)
 *       // prints
 *       { message: 'Validation failed',
 *         name: 'ValidationError',
 *         errors:
 *          { size:
 *             { message: 'must be less than 20',
 *               name: 'ValidatorError',
 *               path: 'size',
 *               type: 'user defined',
 *               value: 14 } } }
 *     })
 *
 * @param {String} path the field to invalidate. For array elements, use the `array.i.field` syntax, where `i` is the 0-based index in the array.
 * @param {String|Error} errorMsg the error which states the reason `path` was invalid
 * @param {Object|String|Number|any} value optional invalid value
 * @param {String} [kind] optional `kind` property for the error
 * @return {ValidationError} the current ValidationError, with all currently invalidated paths
 * @api public
 */


Document.prototype.invalidate = function (path, err, val, kind) {
  if (!this.$__.validationError) {
    this.$__.validationError = new ValidationError(this);
  }

  if (this.$__.validationError.errors[path]) {
    return;
  }

  if (!err || typeof err === 'string') {
    err = new ValidatorError({
      path: path,
      message: err,
      type: kind || 'user defined',
      value: val
    });
  }

  if (this.$__.validationError === err) {
    return this.$__.validationError;
  }

  this.$__.validationError.addError(path, err);
  return this.$__.validationError;
};
/**
 * Marks a path as valid, removing existing validation errors.
 *
 * @param {String} path the field to mark as valid
 * @api public
 * @memberOf Document
 * @instance
 * @method $markValid
 */


Document.prototype.$markValid = function (path) {
  if (!this.$__.validationError || !this.$__.validationError.errors[path]) {
    return;
  }

  delete this.$__.validationError.errors[path];

  if (Object.keys(this.$__.validationError.errors).length === 0) {
    this.$__.validationError = null;
  }
};
/*!
 * ignore
 */


function _markValidSubpaths(doc, path) {
  if (!doc.$__.validationError) {
    return;
  }

  var keys = Object.keys(doc.$__.validationError.errors);

  for (var _i19 = 0, _keys7 = keys; _i19 < _keys7.length; _i19++) {
    var key = _keys7[_i19];

    if (key.startsWith(path + '.')) {
      delete doc.$__.validationError.errors[key];
    }
  }

  if (Object.keys(doc.$__.validationError.errors).length === 0) {
    doc.$__.validationError = null;
  }
}
/*!
 * ignore
 */


function _checkImmutableSubpaths(subdoc, schematype, priorVal) {
  var schema = schematype.schema;

  if (schema == null) {
    return;
  }

  for (var _i20 = 0, _Object$keys2 = Object.keys(schema.paths); _i20 < _Object$keys2.length; _i20++) {
    var key = _Object$keys2[_i20];
    var path = schema.paths[key];

    if (path.$immutableSetter == null) {
      continue;
    }

    var oldVal = priorVal == null ? void 0 : priorVal.$__getValue(key); // Calling immutableSetter with `oldVal` even though it expects `newVal`
    // is intentional. That's because `$immutableSetter` compares its param
    // to the current value.

    path.$immutableSetter.call(subdoc, oldVal);
  }
}
/**
 * Saves this document by inserting a new document into the database if [document.isNew](/docs/api.html#document_Document-isNew) is `true`,
 * or sends an [updateOne](/docs/api.html#document_Document-updateOne) operation **only** with the modifications to the database, it does not replace the whole document in the latter case.
 *
 * #### Example:
 *
 *     product.sold = Date.now();
 *     product = await product.save();
 *
 * If save is successful, the returned promise will fulfill with the document
 * saved.
 *
 * #### Example:
 *
 *     const newProduct = await product.save();
 *     newProduct === product; // true
 *
 * @param {Object} [options] options optional options
 * @param {Session} [options.session=null] the [session](https://docs.mongodb.com/manual/reference/server-sessions/) associated with this save operation. If not specified, defaults to the [document's associated session](api.html#document_Document-$session).
 * @param {Object} [options.safe] (DEPRECATED) overrides [schema's safe option](https://mongoosejs.com//docs/guide.html#safe). Use the `w` option instead.
 * @param {Boolean} [options.validateBeforeSave] set to false to save without validating.
 * @param {Boolean} [options.validateModifiedOnly=false] If `true`, Mongoose will only validate modified paths, as opposed to modified paths and `required` paths.
 * @param {Number|String} [options.w] set the [write concern](https://docs.mongodb.com/manual/reference/write-concern/#w-option). Overrides the [schema-level `writeConcern` option](/docs/guide.html#writeConcern)
 * @param {Boolean} [options.j] set to true for MongoDB to wait until this `save()` has been [journaled before resolving the returned promise](https://docs.mongodb.com/manual/reference/write-concern/#j-option). Overrides the [schema-level `writeConcern` option](/docs/guide.html#writeConcern)
 * @param {Number} [options.wtimeout] sets a [timeout for the write concern](https://docs.mongodb.com/manual/reference/write-concern/#wtimeout). Overrides the [schema-level `writeConcern` option](/docs/guide.html#writeConcern).
 * @param {Boolean} [options.checkKeys=true] the MongoDB driver prevents you from saving keys that start with '$' or contain '.' by default. Set this option to `false` to skip that check. See [restrictions on field names](https://docs.mongodb.com/manual/reference/limits/#Restrictions-on-Field-Names)
 * @param {Boolean} [options.timestamps=true] if `false` and [timestamps](./guide.html#timestamps) are enabled, skip timestamps for this `save()`.
 * @param {Function} [fn] optional callback
 * @method save
 * @memberOf Document
 * @instance
 * @throws {DocumentNotFoundError} if this [save updates an existing document](api.html#document_Document-isNew) but the document doesn't exist in the database. For example, you will get this error if the document is [deleted between when you retrieved the document and when you saved it](documents.html#updating).
 * @return {Promise|undefined} Returns undefined if used with callback or a Promise otherwise.
 * @api public
 * @see middleware https://mongoosejs.com/docs/middleware.html
 */

/**
 * Checks if a path is invalid
 *
 * @param {String|Array<String>} path the field to check
 * @method $isValid
 * @memberOf Document
 * @instance
 * @api private
 */


Document.prototype.$isValid = function (path) {
  var _this12 = this;

  if (this.$__.validationError == null || Object.keys(this.$__.validationError.errors).length === 0) {
    return true;
  }

  if (path == null) {
    return false;
  }

  if (path.indexOf(' ') !== -1) {
    path = path.split(' ');
  }

  if (Array.isArray(path)) {
    return path.some(function (p) {
      return _this12.$__.validationError.errors[p] == null;
    });
  }

  return this.$__.validationError.errors[path] == null;
};
/**
 * Resets the internal modified state of this document.
 *
 * @api private
 * @return {Document}
 * @method $__reset
 * @memberOf Document
 * @instance
 */


Document.prototype.$__reset = function reset() {
  var _this = this; // Skip for subdocuments


  var subdocs = this.$parent() === this ? this.$getAllSubdocs() : [];
  var resetArrays = new Set();

  var _iterator19 = _createForOfIteratorHelper(subdocs),
      _step19;

  try {
    for (_iterator19.s(); !(_step19 = _iterator19.n()).done;) {
      var subdoc = _step19.value;
      var fullPathWithIndexes = subdoc.$__fullPathWithIndexes();

      if (this.isModified(fullPathWithIndexes) || isParentInit(fullPathWithIndexes)) {
        subdoc.$__reset();

        if (subdoc.$isDocumentArrayElement) {
          if (!resetArrays.has(subdoc.parentArray())) {
            var array = subdoc.parentArray();
            this.$__.activePaths.clearPath(fullPathWithIndexes.replace(/\.\d+$/, '').slice(-subdoc.$basePath - 1));
            array[arrayAtomicsBackupSymbol] = array[arrayAtomicsSymbol];
            array[arrayAtomicsSymbol] = {};
            resetArrays.add(array);
          }
        } else {
          if (subdoc.$parent() === this) {
            this.$__.activePaths.clearPath(subdoc.$basePath);
          } else if (subdoc.$parent() != null && subdoc.$parent().$isSubdocument) {
            // If map path underneath subdocument, may end up with a case where
            // map path is modified but parent still needs to be reset. See gh-10295
            subdoc.$parent().$__reset();
          }
        }
      }
    }
  } catch (err) {
    _iterator19.e(err);
  } finally {
    _iterator19.f();
  }

  function isParentInit(path) {
    path = path.indexOf('.') === -1 ? [path] : path.split('.');
    var cur = '';

    for (var _i21 = 0; _i21 < path.length; ++_i21) {
      cur += (cur.length ? '.' : '') + path[_i21];

      if (_this.$__.activePaths[cur] === 'init') {
        return true;
      }
    }

    return false;
  } // clear atomics


  this.$__dirty().forEach(function (dirt) {
    var type = dirt.value;

    if (type && type[arrayAtomicsSymbol]) {
      type[arrayAtomicsBackupSymbol] = type[arrayAtomicsSymbol];
      type[arrayAtomicsSymbol] = {};
    }
  });
  this.$__.backup = {};
  this.$__.backup.activePaths = {
    modify: Object.assign({}, this.$__.activePaths.states.modify),
    "default": Object.assign({}, this.$__.activePaths.states["default"])
  };
  this.$__.backup.validationError = this.$__.validationError;
  this.$__.backup.errors = this.$errors; // Clear 'dirty' cache

  this.$__.activePaths.clear('modify');
  this.$__.activePaths.clear('default');
  this.$__.validationError = undefined;
  this.$errors = undefined;
  _this = this;
  this.$__schema.requiredPaths().forEach(function (path) {
    _this.$__.activePaths.require(path);
  });
  return this;
};
/*!
 * ignore
 */


Document.prototype.$__undoReset = function $__undoReset() {
  if (this.$__.backup == null || this.$__.backup.activePaths == null) {
    return;
  }

  this.$__.activePaths.states.modify = this.$__.backup.activePaths.modify;
  this.$__.activePaths.states["default"] = this.$__.backup.activePaths["default"];
  this.$__.validationError = this.$__.backup.validationError;
  this.$errors = this.$__.backup.errors;

  var _iterator20 = _createForOfIteratorHelper(this.$__dirty()),
      _step20;

  try {
    for (_iterator20.s(); !(_step20 = _iterator20.n()).done;) {
      var dirt = _step20.value;
      var type = dirt.value;

      if (type && type[arrayAtomicsSymbol] && type[arrayAtomicsBackupSymbol]) {
        type[arrayAtomicsSymbol] = type[arrayAtomicsBackupSymbol];
      }
    }
  } catch (err) {
    _iterator20.e(err);
  } finally {
    _iterator20.f();
  }

  var _iterator21 = _createForOfIteratorHelper(this.$getAllSubdocs()),
      _step21;

  try {
    for (_iterator21.s(); !(_step21 = _iterator21.n()).done;) {
      var subdoc = _step21.value;
      subdoc.$__undoReset();
    }
  } catch (err) {
    _iterator21.e(err);
  } finally {
    _iterator21.f();
  }
};
/**
 * Returns this documents dirty paths / vals.
 *
 * @api private
 * @method $__dirty
 * @memberOf Document
 * @instance
 */


Document.prototype.$__dirty = function () {
  var _this = this;

  var all = this.$__.activePaths.map('modify', function (path) {
    return {
      path: path,
      value: _this.$__getValue(path),
      schema: _this.$__path(path)
    };
  }); // gh-2558: if we had to set a default and the value is not undefined,
  // we have to save as well

  all = all.concat(this.$__.activePaths.map('default', function (path) {
    if (path === '_id' || _this.$__getValue(path) == null) {
      return;
    }

    return {
      path: path,
      value: _this.$__getValue(path),
      schema: _this.$__path(path)
    };
  }));
  var allPaths = new Map(all.filter(function (el) {
    return el != null;
  }).map(function (el) {
    return [el.path, el.value];
  })); // Ignore "foo.a" if "foo" is dirty already.

  var minimal = [];
  all.forEach(function (item) {
    if (!item) {
      return;
    }

    var top = null;
    var array = parentPaths(item.path);

    for (var _i22 = 0; _i22 < array.length - 1; _i22++) {
      if (allPaths.has(array[_i22])) {
        top = allPaths.get(array[_i22]);
        break;
      }
    }

    if (top == null) {
      minimal.push(item);
    } else if (top != null && top[arrayAtomicsSymbol] != null && top.hasAtomics()) {
      // special case for top level MongooseArrays
      // the `top` array itself and a sub path of `top` are being set.
      // the only way to honor all of both modifications is through a $set
      // of entire array.
      top[arrayAtomicsSymbol] = {};
      top[arrayAtomicsSymbol].$set = top;
    }
  });
  return minimal;
};
/**
 * Assigns/compiles `schema` into this documents prototype.
 *
 * @param {Schema} schema
 * @api private
 * @method $__setSchema
 * @memberOf Document
 * @instance
 */


Document.prototype.$__setSchema = function (schema) {
  compile(schema.tree, this, undefined, schema.options); // Apply default getters if virtual doesn't have any (gh-6262)

  for (var _i23 = 0, _Object$keys3 = Object.keys(schema.virtuals); _i23 < _Object$keys3.length; _i23++) {
    var key = _Object$keys3[_i23];

    schema.virtuals[key]._applyDefaultGetters();
  }

  if (schema.path('schema') == null) {
    this.schema = schema;
  }

  this.$__schema = schema;
  this[documentSchemaSymbol] = schema;
};
/**
 * Get active path that were changed and are arrays
 *
 * @api private
 * @method $__getArrayPathsToValidate
 * @memberOf Document
 * @instance
 */


Document.prototype.$__getArrayPathsToValidate = function () {
  DocumentArray || (DocumentArray = __webpack_require__(6077)); // validate all document arrays.

  return this.$__.activePaths.map('init', 'modify', function (i) {
    return this.$__getValue(i);
  }.bind(this)).filter(function (val) {
    return val && Array.isArray(val) && utils.isMongooseDocumentArray(val) && val.length;
  }).reduce(function (seed, array) {
    return seed.concat(array);
  }, []).filter(function (doc) {
    return doc;
  });
};
/**
 * Get all subdocs (by bfs)
 *
 * @api public
 * @method $getAllSubdocs
 * @memberOf Document
 * @instance
 */


Document.prototype.$getAllSubdocs = function () {
  DocumentArray || (DocumentArray = __webpack_require__(6077));
  Embedded = Embedded || __webpack_require__(1568);

  function docReducer(doc, seed, path) {
    var val = doc;
    var isNested = false;

    if (path) {
      if (doc instanceof Document && doc[documentSchemaSymbol].paths[path]) {
        val = doc._doc[path];
      } else if (doc instanceof Document && doc[documentSchemaSymbol].nested[path]) {
        val = doc._doc[path];
        isNested = true;
      } else {
        val = doc[path];
      }
    }

    if (val instanceof Embedded) {
      seed.push(val);
    } else if (val instanceof Map) {
      seed = Array.from(val.keys()).reduce(function (seed, path) {
        return docReducer(val.get(path), seed, null);
      }, seed);
    } else if (val && !Array.isArray(val) && val.$isSingleNested) {
      seed = Object.keys(val._doc).reduce(function (seed, path) {
        return docReducer(val, seed, path);
      }, seed);
      seed.push(val);
    } else if (val && utils.isMongooseDocumentArray(val)) {
      val.forEach(function _docReduce(doc) {
        if (!doc || !doc._doc) {
          return;
        }

        seed = Object.keys(doc._doc).reduce(function (seed, path) {
          return docReducer(doc._doc, seed, path);
        }, seed);

        if (doc instanceof Embedded) {
          seed.push(doc);
        }
      });
    } else if (isNested && val != null) {
      for (var _i24 = 0, _Object$keys4 = Object.keys(val); _i24 < _Object$keys4.length; _i24++) {
        var _path5 = _Object$keys4[_i24];
        docReducer(val, seed, _path5);
      }
    }

    return seed;
  }

  var subDocs = [];

  for (var _i25 = 0, _Object$keys5 = Object.keys(this._doc); _i25 < _Object$keys5.length; _i25++) {
    var path = _Object$keys5[_i25];
    docReducer(this, subDocs, path);
  }

  return subDocs;
};
/*!
 * Runs queued functions
 */


function applyQueue(doc) {
  var q = doc.$__schema && doc.$__schema.callQueue;

  if (!q.length) {
    return;
  }

  var _iterator22 = _createForOfIteratorHelper(q),
      _step22;

  try {
    for (_iterator22.s(); !(_step22 = _iterator22.n()).done;) {
      var pair = _step22.value;

      if (pair[0] !== 'pre' && pair[0] !== 'post' && pair[0] !== 'on') {
        doc[pair[0]].apply(doc, pair[1]);
      }
    }
  } catch (err) {
    _iterator22.e(err);
  } finally {
    _iterator22.f();
  }
}
/*!
 * ignore
 */


Document.prototype.$__handleReject = function handleReject(err) {
  // emit on the Model if listening
  if (this.$listeners('error').length) {
    this.$emit('error', err);
  } else if (this.constructor.listeners && this.constructor.listeners('error').length) {
    this.constructor.emit('error', err);
  }
};
/**
 * Internal helper for toObject() and toJSON() that doesn't manipulate options
 *
 * @api private
 * @method $toObject
 * @memberOf Document
 * @instance
 */


Document.prototype.$toObject = function (options, json) {
  var defaultOptions = {
    transform: true,
    flattenDecimals: true
  };
  var path = json ? 'toJSON' : 'toObject';
  var baseOptions = this.constructor && this.constructor.base && this.constructor.base.options && get(this.constructor.base.options, path) || {};
  var schemaOptions = this.$__schema && this.$__schema.options || {}; // merge base default options with Schema's set default options if available.
  // `clone` is necessary here because `utils.options` directly modifies the second input.

  defaultOptions = utils.options(defaultOptions, clone(baseOptions));
  defaultOptions = utils.options(defaultOptions, clone(schemaOptions[path] || {})); // If options do not exist or is not an object, set it to empty object

  options = utils.isPOJO(options) ? _objectSpread({}, options) : {};
  options._calledWithOptions = options._calledWithOptions || _objectSpread({}, options);

  var _minimize;

  if (options._calledWithOptions.minimize != null) {
    _minimize = options.minimize;
  } else if (defaultOptions.minimize != null) {
    _minimize = defaultOptions.minimize;
  } else {
    _minimize = schemaOptions.minimize;
  }

  var flattenMaps;

  if (options._calledWithOptions.flattenMaps != null) {
    flattenMaps = options.flattenMaps;
  } else if (defaultOptions.flattenMaps != null) {
    flattenMaps = defaultOptions.flattenMaps;
  } else {
    flattenMaps = schemaOptions.flattenMaps;
  } // The original options that will be passed to `clone()`. Important because
  // `clone()` will recursively call `$toObject()` on embedded docs, so we
  // need the original options the user passed in, plus `_isNested` and
  // `_parentOptions` for checking whether we need to depopulate.


  var cloneOptions = Object.assign({}, options, {
    _isNested: true,
    json: json,
    minimize: _minimize,
    flattenMaps: flattenMaps,
    _seen: options && options._seen || new Map()
  });

  if (utils.hasUserDefinedProperty(options, 'getters')) {
    cloneOptions.getters = options.getters;
  }

  if (utils.hasUserDefinedProperty(options, 'virtuals')) {
    cloneOptions.virtuals = options.virtuals;
  }

  var depopulate = options.depopulate || options._parentOptions && options._parentOptions.depopulate || false; // _isNested will only be true if this is not the top level document, we
  // should never depopulate the top-level document

  if (depopulate && options._isNested && this.$__.wasPopulated) {
    return clone(this.$__.wasPopulated.value || this._id, cloneOptions);
  } // merge default options with input options.


  options = utils.options(defaultOptions, options);
  options._isNested = true;
  options.json = json;
  options.minimize = _minimize;
  cloneOptions._parentOptions = options;
  cloneOptions._skipSingleNestedGetters = true;
  var gettersOptions = Object.assign({}, cloneOptions);
  gettersOptions._skipSingleNestedGetters = false; // remember the root transform function
  // to save it from being overwritten by sub-transform functions

  var originalTransform = options.transform;
  var ret = clone(this._doc, cloneOptions) || {};

  if (options.getters) {
    applyGetters(this, ret, gettersOptions);

    if (options.minimize) {
      ret = minimize(ret) || {};
    }
  }

  if (options.virtuals || options.getters && options.virtuals !== false) {
    applyVirtuals(this, ret, gettersOptions, options);
  }

  if (options.versionKey === false && this.$__schema.options.versionKey) {
    delete ret[this.$__schema.options.versionKey];
  }

  var transform = options.transform; // In the case where a subdocument has its own transform function, we need to
  // check and see if the parent has a transform (options.transform) and if the
  // child schema has a transform (this.schema.options.toObject) In this case,
  // we need to adjust options.transform to be the child schema's transform and
  // not the parent schema's

  if (transform) {
    applySchemaTypeTransforms(this, ret);
  }

  if (options.useProjection) {
    omitDeselectedFields(this, ret);
  }

  if (transform === true || schemaOptions.toObject && transform) {
    var opts = options.json ? schemaOptions.toJSON : schemaOptions.toObject;

    if (opts) {
      transform = typeof options.transform === 'function' ? options.transform : opts.transform;
    }
  } else {
    options.transform = originalTransform;
  }

  if (typeof transform === 'function') {
    var xformed = transform(this, ret, options);

    if (typeof xformed !== 'undefined') {
      ret = xformed;
    }
  }

  return ret;
};
/**
 * Converts this document into a plain-old JavaScript object ([POJO](https://masteringjs.io/tutorials/fundamentals/pojo)).
 *
 * Buffers are converted to instances of [mongodb.Binary](https://mongodb.github.com/node-mongodb-native/api-bson-generated/binary.html) for proper storage.
 *
 * #### Options:
 *
 * - `getters` apply all getters (path and virtual getters), defaults to false
 * - `aliases` apply all aliases if `virtuals=true`, defaults to true
 * - `virtuals` apply virtual getters (can override `getters` option), defaults to false
 * - `minimize` remove empty objects, defaults to true
 * - `transform` a transform function to apply to the resulting document before returning
 * - `depopulate` depopulate any populated paths, replacing them with their original refs, defaults to false
 * - `versionKey` whether to include the version key, defaults to true
 * - `flattenMaps` convert Maps to POJOs. Useful if you want to JSON.stringify() the result of toObject(), defaults to false
 * - `useProjection` set to `true` to omit fields that are excluded in this document's projection. Unless you specified a projection, this will omit any field that has `select: false` in the schema.
 *
 * #### Getters/Virtuals
 *
 * Example of only applying path getters
 *
 *     doc.toObject({ getters: true, virtuals: false })
 *
 * Example of only applying virtual getters
 *
 *     doc.toObject({ virtuals: true })
 *
 * Example of applying both path and virtual getters
 *
 *     doc.toObject({ getters: true })
 *
 * To apply these options to every document of your schema by default, set your [schemas](#schema_Schema) `toObject` option to the same argument.
 *
 *     schema.set('toObject', { virtuals: true })
 *
 * #### Transform
 *
 * We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional `transform` function.
 *
 * Transform functions receive three arguments
 *
 *     function (doc, ret, options) {}
 *
 * - `doc` The mongoose document which is being converted
 * - `ret` The plain object representation which has been converted
 * - `options` The options in use (either schema options or the options passed inline)
 *
 * #### Example
 *
 *     // specify the transform schema option
 *     if (!schema.options.toObject) schema.options.toObject = {};
 *     schema.options.toObject.transform = function (doc, ret, options) {
 *       // remove the _id of every document before returning the result
 *       delete ret._id;
 *       return ret;
 *     }
 *
 *     // without the transformation in the schema
 *     doc.toObject(); // { _id: 'anId', name: 'Wreck-it Ralph' }
 *
 *     // with the transformation
 *     doc.toObject(); // { name: 'Wreck-it Ralph' }
 *
 * With transformations we can do a lot more than remove properties. We can even return completely new customized objects:
 *
 *     if (!schema.options.toObject) schema.options.toObject = {};
 *     schema.options.toObject.transform = function (doc, ret, options) {
 *       return { movie: ret.name }
 *     }
 *
 *     // without the transformation in the schema
 *     doc.toObject(); // { _id: 'anId', name: 'Wreck-it Ralph' }
 *
 *     // with the transformation
 *     doc.toObject(); // { movie: 'Wreck-it Ralph' }
 *
 * _Note: if a transform function returns `undefined`, the return value will be ignored._
 *
 * Transformations may also be applied inline, overridding any transform set in the options:
 *
 *     function xform (doc, ret, options) {
 *       return { inline: ret.name, custom: true }
 *     }
 *
 *     // pass the transform as an inline option
 *     doc.toObject({ transform: xform }); // { inline: 'Wreck-it Ralph', custom: true }
 *
 * If you want to skip transformations, use `transform: false`:
 *
 *     schema.options.toObject.hide = '_id';
 *     schema.options.toObject.transform = function (doc, ret, options) {
 *       if (options.hide) {
 *         options.hide.split(' ').forEach(function (prop) {
 *           delete ret[prop];
 *         });
 *       }
 *       return ret;
 *     }
 *
 *     const doc = new Doc({ _id: 'anId', secret: 47, name: 'Wreck-it Ralph' });
 *     doc.toObject();                                        // { secret: 47, name: 'Wreck-it Ralph' }
 *     doc.toObject({ hide: 'secret _id', transform: false });// { _id: 'anId', secret: 47, name: 'Wreck-it Ralph' }
 *     doc.toObject({ hide: 'secret _id', transform: true }); // { name: 'Wreck-it Ralph' }
 *
 * If you pass a transform in `toObject()` options, Mongoose will apply the transform
 * to [subdocuments](/docs/subdocs.html) in addition to the top-level document.
 * Similarly, `transform: false` skips transforms for all subdocuments.
 * Note that this behavior is different for transforms defined in the schema:
 * if you define a transform in `schema.options.toObject.transform`, that transform
 * will **not** apply to subdocuments.
 *
 *     const memberSchema = new Schema({ name: String, email: String });
 *     const groupSchema = new Schema({ members: [memberSchema], name: String, email });
 *     const Group = mongoose.model('Group', groupSchema);
 *
 *     const doc = new Group({
 *       name: 'Engineering',
 *       email: 'dev@mongoosejs.io',
 *       members: [{ name: 'Val', email: 'val@mongoosejs.io' }]
 *     });
 *
 *     // Removes `email` from both top-level document **and** array elements
 *     // { name: 'Engineering', members: [{ name: 'Val' }] }
 *     doc.toObject({ transform: (doc, ret) => { delete ret.email; return ret; } });
 *
 * Transforms, like all of these options, are also available for `toJSON`. See [this guide to `JSON.stringify()`](https://thecodebarbarian.com/the-80-20-guide-to-json-stringify-in-javascript.html) to learn why `toJSON()` and `toObject()` are separate functions.
 *
 * See [schema options](/docs/guide.html#toObject) for some more details.
 *
 * _During save, no custom options are applied to the document before being sent to the database._
 *
 * @param {Object} [options]
 * @param {Boolean} [options.getters=false] if true, apply all getters, including virtuals
 * @param {Boolean} [options.virtuals=false] if true, apply virtuals, including aliases. Use `{ getters: true, virtuals: false }` to just apply getters, not virtuals
 * @param {Boolean} [options.aliases=true] if `options.virtuals = true`, you can set `options.aliases = false` to skip applying aliases. This option is a no-op if `options.virtuals = false`.
 * @param {Boolean} [options.minimize=true] if true, omit any empty objects from the output
 * @param {Function|null} [options.transform=null] if set, mongoose will call this function to allow you to transform the returned object
 * @param {Boolean} [options.depopulate=false] if true, replace any conventionally populated paths with the original id in the output. Has no affect on virtual populated paths.
 * @param {Boolean} [options.versionKey=true] if false, exclude the version key (`__v` by default) from the output
 * @param {Boolean} [options.flattenMaps=false] if true, convert Maps to POJOs. Useful if you want to `JSON.stringify()` the result of `toObject()`.
 * @param {Boolean} [options.useProjection=false] - If true, omits fields that are excluded in this document's projection. Unless you specified a projection, this will omit any field that has `select: false` in the schema.
 * @return {Object} js object
 * @see mongodb.Binary https://mongodb.github.com/node-mongodb-native/api-bson-generated/binary.html
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.toObject = function (options) {
  return this.$toObject(options);
};
/*!
 * Minimizes an object, removing undefined values and empty objects
 *
 * @param {Object} object to minimize
 * @return {Object}
 */


function minimize(obj) {
  var keys = Object.keys(obj);
  var i = keys.length;
  var hasKeys;
  var key;
  var val;

  while (i--) {
    key = keys[i];
    val = obj[key];

    if (utils.isPOJO(val)) {
      obj[key] = minimize(val);
    }

    if (undefined === obj[key]) {
      delete obj[key];
      continue;
    }

    hasKeys = true;
  }

  return hasKeys ? obj : undefined;
}
/*!
 * Applies virtuals properties to `json`.
 */


function applyVirtuals(self, json, options, toObjectOptions) {
  var schema = self.$__schema;
  var paths = Object.keys(schema.virtuals);
  var i = paths.length;
  var numPaths = i;
  var path;
  var assignPath;
  var cur = self._doc;
  var v;
  var aliases = typeof (toObjectOptions && toObjectOptions.aliases) === 'boolean' ? toObjectOptions.aliases : true;
  var virtualsToApply = null;

  if (Array.isArray(options.virtuals)) {
    virtualsToApply = new Set(options.virtuals);
  } else if (options.virtuals && options.virtuals.pathsToSkip) {
    virtualsToApply = new Set(paths);

    for (var _i26 = 0; _i26 < options.virtuals.pathsToSkip.length; _i26++) {
      if (virtualsToApply.has(options.virtuals.pathsToSkip[_i26])) {
        virtualsToApply["delete"](options.virtuals.pathsToSkip[_i26]);
      }
    }
  }

  if (!cur) {
    return json;
  }

  options = options || {};

  for (i = 0; i < numPaths; ++i) {
    path = paths[i];

    if (virtualsToApply != null && !virtualsToApply.has(path)) {
      continue;
    } // Allow skipping aliases with `toObject({ virtuals: true, aliases: false })`


    if (!aliases && schema.aliases.hasOwnProperty(path)) {
      continue;
    } // We may be applying virtuals to a nested object, for example if calling
    // `doc.nestedProp.toJSON()`. If so, the path we assign to, `assignPath`,
    // will be a trailing substring of the `path`.


    assignPath = path;

    if (options.path != null) {
      if (!path.startsWith(options.path + '.')) {
        continue;
      }

      assignPath = path.substring(options.path.length + 1);
    }

    var parts = assignPath.split('.');
    v = clone(self.get(path), options);

    if (v === void 0) {
      continue;
    }

    var plen = parts.length;
    cur = json;

    for (var j = 0; j < plen - 1; ++j) {
      cur[parts[j]] = cur[parts[j]] || {};
      cur = cur[parts[j]];
    }

    cur[parts[plen - 1]] = v;
  }

  return json;
}
/*!
 * Applies virtuals properties to `json`.
 *
 * @param {Document} self
 * @param {Object} json
 * @return {Object} `json`
 */


function applyGetters(self, json, options) {
  var schema = self.$__schema;
  var paths = Object.keys(schema.paths);
  var i = paths.length;
  var path;
  var cur = self._doc;
  var v;

  if (!cur) {
    return json;
  }

  while (i--) {
    path = paths[i];
    var parts = path.split('.');
    var plen = parts.length;
    var last = plen - 1;
    var branch = json;
    var part = void 0;
    cur = self._doc;

    if (!self.$__isSelected(path)) {
      continue;
    }

    for (var ii = 0; ii < plen; ++ii) {
      part = parts[ii];
      v = cur[part];

      if (ii === last) {
        var val = self.$get(path);
        branch[part] = clone(val, options);
      } else if (v == null) {
        if (part in cur) {
          branch[part] = v;
        }

        break;
      } else {
        branch = branch[part] || (branch[part] = {});
      }

      cur = v;
    }
  }

  return json;
}
/*!
 * Applies schema type transforms to `json`.
 *
 * @param {Document} self
 * @param {Object} json
 * @return {Object} `json`
 */


function applySchemaTypeTransforms(self, json) {
  var schema = self.$__schema;
  var paths = Object.keys(schema.paths || {});
  var cur = self._doc;

  if (!cur) {
    return json;
  }

  for (var _i27 = 0, _paths4 = paths; _i27 < _paths4.length; _i27++) {
    var path = _paths4[_i27];
    var schematype = schema.paths[path];

    if (typeof schematype.options.transform === 'function') {
      var val = self.$get(path);

      if (val === undefined) {
        continue;
      }

      var transformedValue = schematype.options.transform.call(self, val);
      throwErrorIfPromise(path, transformedValue);
      utils.setValue(path, transformedValue, json);
    } else if (schematype.$embeddedSchemaType != null && typeof schematype.$embeddedSchemaType.options.transform === 'function') {
      var _val2 = self.$get(path);

      if (_val2 === undefined) {
        continue;
      }

      var vals = [].concat(_val2);
      var transform = schematype.$embeddedSchemaType.options.transform;

      for (var _i28 = 0; _i28 < vals.length; ++_i28) {
        var _transformedValue = transform.call(self, vals[_i28]);

        vals[_i28] = _transformedValue;
        throwErrorIfPromise(path, _transformedValue);
      }

      json[path] = vals;
    }
  }

  return json;
}

function throwErrorIfPromise(path, transformedValue) {
  if (isPromise(transformedValue)) {
    throw new Error('`transform` function must be synchronous, but the transform on path `' + path + '` returned a promise.');
  }
}
/*!
 * ignore
 */


function omitDeselectedFields(self, json) {
  var schema = self.$__schema;
  var paths = Object.keys(schema.paths || {});
  var cur = self._doc;

  if (!cur) {
    return json;
  }

  var selected = self.$__.selected;

  if (selected === void 0) {
    selected = {};
    queryhelpers.applyPaths(selected, schema);
  }

  if (selected == null || Object.keys(selected).length === 0) {
    return json;
  }

  for (var _i29 = 0, _paths5 = paths; _i29 < _paths5.length; _i29++) {
    var path = _paths5[_i29];

    if (selected[path] != null && !selected[path]) {
      delete json[path];
    }
  }

  return json;
}
/**
 * The return value of this method is used in calls to [`JSON.stringify(doc)`](https://thecodebarbarian.com/the-80-20-guide-to-json-stringify-in-javascript#the-tojson-function).
 *
 * This method accepts the same options as [Document#toObject](#document_Document-toObject). To apply the options to every document of your schema by default, set your [schemas](#schema_Schema) `toJSON` option to the same argument.
 *
 *     schema.set('toJSON', { virtuals: true });
 *
 * There is one difference between `toJSON()` and `toObject()` options.
 * When you call `toJSON()`, the [`flattenMaps` option](./document.html#document_Document-toObject) defaults to `true`, because `JSON.stringify()` doesn't convert maps to objects by default.
 * When you call `toObject()`, the `flattenMaps` option is `false` by default.
 *
 * See [schema options](/docs/guide.html#toJSON) for more information on setting `toJSON` option defaults.
 *
 * @param {Object} options
 * @param {Boolean} [options.flattenMaps=true] if true, convert Maps to [POJOs](https://masteringjs.io/tutorials/fundamentals/pojo). Useful if you want to `JSON.stringify()` the result.
 * @return {Object}
 * @see Document#toObject #document_Document-toObject
 * @see JSON.stringify() in JavaScript https://thecodebarbarian.com/the-80-20-guide-to-json-stringify-in-javascript.html
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.toJSON = function (options) {
  return this.$toObject(options, true);
};

Document.prototype.ownerDocument = function () {
  return this;
};
/**
 * If this document is a subdocument or populated document, returns the document's
 * parent. Returns the original document if there is no parent.
 *
 * @api public
 * @method parent
 * @memberOf Document
 * @instance
 */


Document.prototype.parent = function () {
  if (this.$isSubdocument || this.$__.wasPopulated) {
    return this.$__.parent;
  }

  return this;
};
/**
 * Alias for `parent()`. If this document is a subdocument or populated
 * document, returns the document's parent. Returns `undefined` otherwise.
 *
 * @api public
 * @method $parent
 * @memberOf Document
 * @instance
 */


Document.prototype.$parent = Document.prototype.parent;
/**
 * Helper for console.log
 *
 * @api public
 * @method inspect
 * @memberOf Document
 * @instance
 */

Document.prototype.inspect = function (options) {
  var isPOJO = utils.isPOJO(options);
  var opts;

  if (isPOJO) {
    opts = options;
    opts.minimize = false;
  }

  var ret = this.toObject(opts);

  if (ret == null) {
    // If `toObject()` returns null, `this` is still an object, so if `inspect()`
    // prints out null this can cause some serious confusion. See gh-7942.
    return 'MongooseDocument { ' + ret + ' }';
  }

  return ret;
};

if (inspect.custom) {
  /*!
  * Avoid Node deprecation warning DEP0079
  */
  Document.prototype[inspect.custom] = Document.prototype.inspect;
}
/**
 * Helper for console.log
 *
 * @api public
 * @method toString
 * @memberOf Document
 * @instance
 */


Document.prototype.toString = function () {
  var ret = this.inspect();

  if (typeof ret === 'string') {
    return ret;
  }

  return inspect(ret);
};
/**
 * Returns true if this document is equal to another document.
 *
 * Documents are considered equal when they have matching `_id`s, unless neither
 * document has an `_id`, in which case this function falls back to using
 * `deepEqual()`.
 *
 * @param {Document} doc a document to compare
 * @return {Boolean}
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.equals = function (doc) {
  if (!doc) {
    return false;
  }

  var tid = this.$__getValue('_id');
  var docid = doc.$__ != null ? doc.$__getValue('_id') : doc;

  if (!tid && !docid) {
    return deepEqual(this, doc);
  }

  return tid && tid.equals ? tid.equals(docid) : tid === docid;
};
/**
 * Populates paths on an existing document.
 *
 * #### Example:
 *
 *     await doc.populate([
 *       'stories',
 *       { path: 'fans', sort: { name: -1 } }
 *     ]);
 *     doc.populated('stories'); // Array of ObjectIds
 *     doc.stories[0].title; // 'Casino Royale'
 *     doc.populated('fans'); // Array of ObjectIds
 *
 *     await doc.populate('fans', '-email');
 *     doc.fans[0].email // not populated
 *
 *     await doc.populate('author fans', '-email');
 *     doc.author.email // not populated
 *     doc.fans[0].email // not populated
 *
 * @param {String|Object|Array} path either the path to populate or an object specifying all parameters, or either an array of those
 * @param {Object|String} [select] Field selection for the population query
 * @param {Model} [model] The model you wish to use for population. If not specified, populate will look up the model by the name in the Schema's `ref` field.
 * @param {Object} [match] Conditions for the population query
 * @param {Object} [options] Options for the population query (sort, etc)
 * @param {String} [options.path=null] The path to populate.
 * @param {string|PopulateOptions} [options.populate=null] Recursively populate paths in the populated documents. See [deep populate docs](/docs/populate.html#deep-populate).
 * @param {boolean} [options.retainNullValues=false] by default, Mongoose removes null and undefined values from populated arrays. Use this option to make `populate()` retain `null` and `undefined` array entries.
 * @param {boolean} [options.getters=false] if true, Mongoose will call any getters defined on the `localField`. By default, Mongoose gets the raw value of `localField`. For example, you would need to set this option to `true` if you wanted to [add a `lowercase` getter to your `localField`](/docs/schematypes.html#schematype-options).
 * @param {boolean} [options.clone=false] When you do `BlogPost.find().populate('author')`, blog posts with the same author will share 1 copy of an `author` doc. Enable this option to make Mongoose clone populated docs before assigning them.
 * @param {Object|Function} [options.match=null] Add an additional filter to the populate query. Can be a filter object containing [MongoDB query syntax](https://docs.mongodb.com/manual/tutorial/query-documents/), or a function that returns a filter object.
 * @param {Function} [options.transform=null] Function that Mongoose will call on every populated document that allows you to transform the populated document.
 * @param {Object} [options.options=null] Additional options like `limit` and `lean`.
 * @param {Function} [callback] Callback
 * @see population ./populate.html
 * @see Query#select #query_Query-select
 * @see Model.populate #model_Model.populate
 * @memberOf Document
 * @instance
 * @return {Promise|null}
 * @api public
 */


Document.prototype.populate = function populate() {
  var pop = {};
  var args = Array.prototype.slice.call(arguments);
  var fn;

  if (args.length !== 0) {
    if (typeof args[args.length - 1] === 'function') {
      fn = args.pop();
    } // use hash to remove duplicate paths


    var res = utils.populate.apply(null, args);

    var _iterator23 = _createForOfIteratorHelper(res),
        _step23;

    try {
      for (_iterator23.s(); !(_step23 = _iterator23.n()).done;) {
        var populateOptions = _step23.value;
        pop[populateOptions.path] = populateOptions;
      }
    } catch (err) {
      _iterator23.e(err);
    } finally {
      _iterator23.f();
    }
  }

  var paths = utils.object.vals(pop);
  var topLevelModel = this.constructor;

  if (this.$__isNested) {
    topLevelModel = this.$__[scopeSymbol].constructor;
    var nestedPath = this.$__.nestedPath;
    paths.forEach(function (populateOptions) {
      populateOptions.path = nestedPath + '.' + populateOptions.path;
    });
  } // Use `$session()` by default if the document has an associated session
  // See gh-6754


  if (this.$session() != null) {
    var session = this.$session();
    paths.forEach(function (path) {
      if (path.options == null) {
        path.options = {
          session: session
        };
        return;
      }

      if (!('session' in path.options)) {
        path.options.session = session;
      }
    });
  }

  paths.forEach(function (p) {
    p._localModel = topLevelModel;
  });
  return topLevelModel.populate(this, paths, fn);
};
/**
 * Gets all populated documents associated with this document.
 *
 * @api public
 * @return {Array<Document>} array of populated documents. Empty array if there are no populated documents associated with this document.
 * @memberOf Document
 * @method $getPopulatedDocs
 * @instance
 */


Document.prototype.$getPopulatedDocs = function $getPopulatedDocs() {
  var keys = [];

  if (this.$__.populated != null) {
    keys = keys.concat(Object.keys(this.$__.populated));
  }

  var result = [];

  var _iterator24 = _createForOfIteratorHelper(keys),
      _step24;

  try {
    for (_iterator24.s(); !(_step24 = _iterator24.n()).done;) {
      var key = _step24.value;
      var value = this.$get(key);

      if (Array.isArray(value)) {
        result = result.concat(value);
      } else if (value instanceof Document) {
        result.push(value);
      }
    }
  } catch (err) {
    _iterator24.e(err);
  } finally {
    _iterator24.f();
  }

  return result;
};
/**
 * Gets _id(s) used during population of the given `path`.
 *
 * #### Example:
 *
 *     const doc = await Model.findOne().populate('author');
 *
 *     console.log(doc.author.name); // Dr.Seuss
 *     console.log(doc.populated('author')); // '5144cf8050f071d979c118a7'
 *
 * If the path was not populated, returns `undefined`.
 *
 * @param {String} path
 * @return {Array|ObjectId|Number|Buffer|String|undefined}
 * @memberOf Document
 * @instance
 * @api public
 */


Document.prototype.populated = function (path, val, options) {
  // val and options are internal
  if (val == null || val === true) {
    if (!this.$__.populated) {
      return undefined;
    }

    if (typeof path !== 'string') {
      return undefined;
    } // Map paths can be populated with either `path.$*` or just `path`


    var _path = path.endsWith('.$*') ? path.replace(/\.\$\*$/, '') : path;

    var v = this.$__.populated[_path];

    if (v) {
      return val === true ? v : v.value;
    }

    return undefined;
  }

  this.$__.populated || (this.$__.populated = {});
  this.$__.populated[path] = {
    value: val,
    options: options
  }; // If this was a nested populate, make sure each populated doc knows
  // about its populated children (gh-7685)

  var pieces = path.split('.');

  for (var _i30 = 0; _i30 < pieces.length - 1; ++_i30) {
    var subpath = pieces.slice(0, _i30 + 1).join('.');
    var subdoc = this.$get(subpath);

    if (subdoc != null && subdoc.$__ != null && this.$populated(subpath)) {
      var rest = pieces.slice(_i30 + 1).join('.');
      subdoc.$populated(rest, val, options); // No need to continue because the above recursion should take care of
      // marking the rest of the docs as populated

      break;
    }
  }

  return val;
};

Document.prototype.$populated = Document.prototype.populated;
/**
 * Throws an error if a given path is not populated
 *
 * #### Example:
 *
 *     const doc = await Model.findOne().populate('author');
 *
 *     doc.$assertPopulated('author'); // does not throw
 *     doc.$assertPopulated('other path'); // throws an error
 *
 *
 * @param {String|Array<String>} path
 * @return {Document} this
 * @memberOf Document
 * @method $assertPopulated
 * @instance
 * @api public
 */

Document.prototype.$assertPopulated = function $assertPopulated(paths) {
  var _this13 = this;

  if (Array.isArray(paths)) {
    paths.forEach(function (path) {
      return _this13.$assertPopulated(path);
    });
    return this;
  }

  if (!this.$populated(paths)) {
    throw new MongooseError("Expected path \"".concat(paths, "\" to be populated"));
  }

  return this;
};
/**
 * Takes a populated field and returns it to its unpopulated state.
 *
 * #### Example:
 *
 *     Model.findOne().populate('author').exec(function (err, doc) {
 *       console.log(doc.author.name); // Dr.Seuss
 *       console.log(doc.depopulate('author'));
 *       console.log(doc.author); // '5144cf8050f071d979c118a7'
 *     })
 *
 * If the path was not provided, then all populated fields are returned to their unpopulated state.
 *
 * @param {String} path
 * @return {Document} this
 * @see Document.populate #document_Document-populate
 * @api public
 * @memberOf Document
 * @instance
 */


Document.prototype.depopulate = function (path) {
  if (typeof path === 'string') {
    path = path.indexOf(' ') === -1 ? [path] : path.split(' ');
  }

  var populatedIds;
  var virtualKeys = this.$$populatedVirtuals ? Object.keys(this.$$populatedVirtuals) : [];
  var populated = this.$__ && this.$__.populated || {};

  if (arguments.length === 0) {
    // Depopulate all
    var _iterator25 = _createForOfIteratorHelper(virtualKeys),
        _step25;

    try {
      for (_iterator25.s(); !(_step25 = _iterator25.n()).done;) {
        var virtualKey = _step25.value;
        delete this.$$populatedVirtuals[virtualKey];
        delete this._doc[virtualKey];
        delete populated[virtualKey];
      }
    } catch (err) {
      _iterator25.e(err);
    } finally {
      _iterator25.f();
    }

    var keys = Object.keys(populated);

    for (var _i31 = 0, _keys8 = keys; _i31 < _keys8.length; _i31++) {
      var key = _keys8[_i31];
      populatedIds = this.$populated(key);

      if (!populatedIds) {
        continue;
      }

      delete populated[key];
      utils.setValue(key, populatedIds, this._doc);
    }

    return this;
  }

  var _iterator26 = _createForOfIteratorHelper(path),
      _step26;

  try {
    for (_iterator26.s(); !(_step26 = _iterator26.n()).done;) {
      var singlePath = _step26.value;
      populatedIds = this.$populated(singlePath);
      delete populated[singlePath];

      if (virtualKeys.indexOf(singlePath) !== -1) {
        delete this.$$populatedVirtuals[singlePath];
        delete this._doc[singlePath];
      } else if (populatedIds) {
        utils.setValue(singlePath, populatedIds, this._doc);
      }
    }
  } catch (err) {
    _iterator26.e(err);
  } finally {
    _iterator26.f();
  }

  return this;
};
/**
 * Returns the full path to this document.
 *
 * @param {String} [path]
 * @return {String}
 * @api private
 * @method $__fullPath
 * @memberOf Document
 * @instance
 */


Document.prototype.$__fullPath = function (path) {
  // overridden in SubDocuments
  return path || '';
};
/**
 * Returns the changes that happened to the document
 * in the format that will be sent to MongoDB.
 *
 * #### Example:
 *
 *     const userSchema = new Schema({
 *       name: String,
 *       age: Number,
 *       country: String
 *     });
 *     const User = mongoose.model('User', userSchema);
 *     const user = await User.create({
 *       name: 'Hafez',
 *       age: 25,
 *       country: 'Egypt'
 *     });
 *
 *     // returns an empty object, no changes happened yet
 *     user.getChanges(); // { }
 *
 *     user.country = undefined;
 *     user.age = 26;
 *
 *     user.getChanges(); // { $set: { age: 26 }, { $unset: { country: 1 } } }
 *
 *     await user.save();
 *
 *     user.getChanges(); // { }
 *
 * Modifying the object that `getChanges()` returns does not affect the document's
 * change tracking state. Even if you `delete user.getChanges().$set`, Mongoose
 * will still send a `$set` to the server.
 *
 * @return {Object}
 * @api public
 * @method getChanges
 * @memberOf Document
 * @instance
 */


Document.prototype.getChanges = function () {
  var delta = this.$__delta();
  var changes = delta ? delta[1] : {};
  return changes;
};
/*!
 * Module exports.
 */


Document.ValidationError = ValidationError;
module.exports = exports = Document;

/***/ }),

/***/ 4304:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-env browser */

/*!
 * Module dependencies.
 */

var Document = __webpack_require__(8727);

var BrowserDocument = __webpack_require__(3434);

var isBrowser = false;
/**
 * Returns the Document constructor for the current context
 *
 * @api private
 */

module.exports = function () {
  if (isBrowser) {
    return BrowserDocument;
  }

  return Document;
};
/*!
 * ignore
 */


module.exports.setBrowser = function (flag) {
  isBrowser = flag;
};

/***/ }),

/***/ 9906:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

var driver = null;

module.exports.get = function () {
  return driver;
};

module.exports.set = function (v) {
  driver = v;
};

/***/ }),

/***/ 5427:
/***/ ((module) => {

"use strict";
/*!
 * ignore
 */


module.exports = function () {};

/***/ }),

/***/ 655:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var Binary = (__webpack_require__(3873)/* .Binary */ .Kb);
/*!
 * Module exports.
 */


module.exports = exports = Binary;

/***/ }),

/***/ 4267:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * ignore
 */


module.exports = __webpack_require__(3873).Decimal128;

/***/ }),

/***/ 6333:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module exports.
 */


exports.Binary = __webpack_require__(655);

exports.Collection = function () {
  throw new Error('Cannot create a collection from browser library');
};

exports.getConnection = function () {
  return function () {
    throw new Error('Cannot create a connection from browser library');
  };
};

exports.Decimal128 = __webpack_require__(4267);
exports.ObjectId = __webpack_require__(7906);
exports.ReadPreference = __webpack_require__(5427);

/***/ }),

/***/ 7906:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * [node-mongodb-native](https://github.com/mongodb/node-mongodb-native) ObjectId
 * @constructor NodeMongoDbObjectId
 * @see ObjectId
 */


var ObjectId = (__webpack_require__(3873)/* .ObjectID */ .t4);
/*!
 * Getter for convenience with populate, see gh-6115
 */


Object.defineProperty(ObjectId.prototype, '_id', {
  enumerable: false,
  configurable: true,
  get: function get() {
    return this;
  }
});
/*!
 * ignore
 */

module.exports = exports = ObjectId;

/***/ }),

/***/ 1795:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(5202);

var util = __webpack_require__(161);
/**
 * Casting Error constructor.
 *
 * @param {String} type
 * @param {String} value
 * @inherits MongooseError
 * @api private
 */


var CastError = /*#__PURE__*/function (_MongooseError) {
  _inherits(CastError, _MongooseError);

  var _super = _createSuper(CastError);

  function CastError(type, value, path, reason, schemaType) {
    var _this;

    _classCallCheck(this, CastError);

    // If no args, assume we'll `init()` later.
    if (arguments.length > 0) {
      var stringValue = getStringValue(value);
      var valueType = getValueType(value);
      var messageFormat = getMessageFormat(schemaType);
      var msg = formatMessage(null, type, stringValue, path, messageFormat, valueType, reason);
      _this = _super.call(this, msg);

      _this.init(type, value, path, reason, schemaType);
    } else {
      _this = _super.call(this, formatMessage());
    }

    return _possibleConstructorReturn(_this);
  }

  _createClass(CastError, [{
    key: "toJSON",
    value: function toJSON() {
      return {
        stringValue: this.stringValue,
        valueType: this.valueType,
        kind: this.kind,
        value: this.value,
        path: this.path,
        reason: this.reason,
        name: this.name,
        message: this.message
      };
    }
    /*!
     * ignore
     */

  }, {
    key: "init",
    value: function init(type, value, path, reason, schemaType) {
      this.stringValue = getStringValue(value);
      this.messageFormat = getMessageFormat(schemaType);
      this.kind = type;
      this.value = value;
      this.path = path;
      this.reason = reason;
      this.valueType = getValueType(value);
    }
    /*!
     * ignore
     * @param {Readonly<CastError>} other
     */

  }, {
    key: "copy",
    value: function copy(other) {
      this.messageFormat = other.messageFormat;
      this.stringValue = other.stringValue;
      this.kind = other.kind;
      this.value = other.value;
      this.path = other.path;
      this.reason = other.reason;
      this.message = other.message;
      this.valueType = other.valueType;
    }
    /*!
     * ignore
     */

  }, {
    key: "setModel",
    value: function setModel(model) {
      this.model = model;
      this.message = formatMessage(model, this.kind, this.stringValue, this.path, this.messageFormat, this.valueType);
    }
  }]);

  return CastError;
}(MongooseError);

Object.defineProperty(CastError.prototype, 'name', {
  value: 'CastError'
});

function getStringValue(value) {
  var stringValue = util.inspect(value);
  stringValue = stringValue.replace(/^'|'$/g, '"');

  if (!stringValue.startsWith('"')) {
    stringValue = '"' + stringValue + '"';
  }

  return stringValue;
}

function getValueType(value) {
  if (value == null) {
    return '' + value;
  }

  var t = _typeof(value);

  if (t !== 'object') {
    return t;
  }

  if (typeof value.constructor !== 'function') {
    return t;
  }

  return value.constructor.name;
}

function getMessageFormat(schemaType) {
  var messageFormat = schemaType && schemaType.options && schemaType.options.cast || null;

  if (typeof messageFormat === 'string') {
    return messageFormat;
  }
}
/*!
 * ignore
 */


function formatMessage(model, kind, stringValue, path, messageFormat, valueType, reason) {
  if (messageFormat != null) {
    var ret = messageFormat.replace('{KIND}', kind).replace('{VALUE}', stringValue).replace('{PATH}', path);

    if (model != null) {
      ret = ret.replace('{MODEL}', model.modelName);
    }

    return ret;
  } else {
    var valueTypeMsg = valueType ? ' (type ' + valueType + ')' : '';

    var _ret = 'Cast to ' + kind + ' failed for value ' + stringValue + valueTypeMsg + ' at path "' + path + '"';

    if (model != null) {
      _ret += ' for model "' + model.modelName + '"';
    }

    if (reason != null && typeof reason.constructor === 'function' && reason.constructor.name !== 'AssertionError' && reason.constructor.name !== 'Error') {
      _ret += ' because of "' + reason.constructor.name + '"';
    }

    return _ret;
  }
}
/*!
 * exports
 */


module.exports = CastError;

/***/ }),

/***/ 6067:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var DivergentArrayError = /*#__PURE__*/function (_MongooseError) {
  _inherits(DivergentArrayError, _MongooseError);

  var _super = _createSuper(DivergentArrayError);

  /*!
   * DivergentArrayError constructor.
   * @param {Array<String>} paths
   */
  function DivergentArrayError(paths) {
    _classCallCheck(this, DivergentArrayError);

    var msg = 'For your own good, using `document.save()` to update an array ' + 'which was selected using an $elemMatch projection OR ' + 'populated using skip, limit, query conditions, or exclusion of ' + 'the _id field when the operation results in a $pop or $set of ' + 'the entire array is not supported. The following ' + 'path(s) would have been modified unsafely:\n' + '  ' + paths.join('\n  ') + '\n' + 'Use Model.update() to update these arrays instead.'; // TODO write up a docs page (FAQ) and link to it

    return _super.call(this, msg);
  }

  return _createClass(DivergentArrayError);
}(MongooseError);

Object.defineProperty(DivergentArrayError.prototype, 'name', {
  value: 'DivergentArrayError'
});
/*!
 * exports
 */

module.exports = DivergentArrayError;

/***/ }),

/***/ 4888:
/***/ ((module, exports, __webpack_require__) => {

"use strict";

/**
 * MongooseError constructor. MongooseError is the base class for all
 * Mongoose-specific errors.
 *
 * #### Example:
 *     const Model = mongoose.model('Test', new mongoose.Schema({ answer: Number }));
 *     const doc = new Model({ answer: 'not a number' });
 *     const err = doc.validateSync();
 *
 *     err instanceof mongoose.Error.ValidationError; // true
 *
 * @constructor Error
 * @param {String} msg Error message
 * @inherits Error https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Error
 */

var MongooseError = __webpack_require__(5202);
/**
 * The name of the error. The name uniquely identifies this Mongoose error. The
 * possible values are:
 *
 * - `MongooseError`: general Mongoose error
 * - `CastError`: Mongoose could not convert a value to the type defined in the schema path. May be in a `ValidationError` class' `errors` property.
 * - `DisconnectedError`: This [connection](connections.html) timed out in trying to reconnect to MongoDB and will not successfully reconnect to MongoDB unless you explicitly reconnect.
 * - `DivergentArrayError`: You attempted to `save()` an array that was modified after you loaded it with a `$elemMatch` or similar projection
 * - `MissingSchemaError`: You tried to access a model with [`mongoose.model()`](api.html#mongoose_Mongoose-model) that was not defined
 * - `DocumentNotFoundError`: The document you tried to [`save()`](api.html#document_Document-save) was not found
 * - `ValidatorError`: error from an individual schema path's validator
 * - `ValidationError`: error returned from [`validate()`](api.html#document_Document-validate) or [`validateSync()`](api.html#document_Document-validateSync). Contains zero or more `ValidatorError` instances in `.errors` property.
 * - `MissingSchemaError`: You called `mongoose.Document()` without a schema
 * - `ObjectExpectedError`: Thrown when you set a nested path to a non-object value with [strict mode set](guide.html#strict).
 * - `ObjectParameterError`: Thrown when you pass a non-object value to a function which expects an object as a paramter
 * - `OverwriteModelError`: Thrown when you call [`mongoose.model()`](api.html#mongoose_Mongoose-model) to re-define a model that was already defined.
 * - `ParallelSaveError`: Thrown when you call [`save()`](api.html#model_Model-save) on a document when the same document instance is already saving.
 * - `StrictModeError`: Thrown when you set a path that isn't the schema and [strict mode](guide.html#strict) is set to `throw`.
 * - `VersionError`: Thrown when the [document is out of sync](guide.html#versionKey)
 *
 * @api public
 * @property {String} name
 * @memberOf Error
 * @instance
 */

/*!
 * Module exports.
 */


module.exports = exports = MongooseError;
/**
 * The default built-in validator error messages.
 *
 * @see Error.messages #error_messages_MongooseError-messages
 * @api public
 * @memberOf Error
 * @static messages
 */

MongooseError.messages = __webpack_require__(983); // backward compat

MongooseError.Messages = MongooseError.messages;
/**
 * An instance of this error class will be returned when `save()` fails
 * because the underlying
 * document was not found. The constructor takes one parameter, the
 * conditions that mongoose passed to `update()` when trying to update
 * the document.
 *
 * @api public
 * @memberOf Error
 * @static DocumentNotFoundError
 */

MongooseError.DocumentNotFoundError = __webpack_require__(3640);
/**
 * An instance of this error class will be returned when mongoose failed to
 * cast a value.
 *
 * @api public
 * @memberOf Error
 * @static CastError
 */

MongooseError.CastError = __webpack_require__(1795);
/**
 * An instance of this error class will be returned when [validation](/docs/validation.html) failed.
 * The `errors` property contains an object whose keys are the paths that failed and whose values are
 * instances of CastError or ValidationError.
 *
 * @api public
 * @memberOf Error
 * @static ValidationError
 */

MongooseError.ValidationError = __webpack_require__(122);
/**
 * A `ValidationError` has a hash of `errors` that contain individual
 * `ValidatorError` instances.
 *
 * #### Example:
 *
 *     const schema = Schema({ name: { type: String, required: true } });
 *     const Model = mongoose.model('Test', schema);
 *     const doc = new Model({});
 *
 *     // Top-level error is a ValidationError, **not** a ValidatorError
 *     const err = doc.validateSync();
 *     err instanceof mongoose.Error.ValidationError; // true
 *
 *     // A ValidationError `err` has 0 or more ValidatorErrors keyed by the
 *     // path in the `err.errors` property.
 *     err.errors['name'] instanceof mongoose.Error.ValidatorError;
 *
 *     err.errors['name'].kind; // 'required'
 *     err.errors['name'].path; // 'name'
 *     err.errors['name'].value; // undefined
 *
 * Instances of `ValidatorError` have the following properties:
 *
 * - `kind`: The validator's `type`, like `'required'` or `'regexp'`
 * - `path`: The path that failed validation
 * - `value`: The value that failed validation
 *
 * @api public
 * @memberOf Error
 * @static ValidatorError
 */

MongooseError.ValidatorError = __webpack_require__(2037);
/**
 * An instance of this error class will be returned when you call `save()` after
 * the document in the database was changed in a potentially unsafe way. See
 * the [`versionKey` option](/docs/guide.html#versionKey) for more information.
 *
 * @api public
 * @memberOf Error
 * @static VersionError
 */

MongooseError.VersionError = __webpack_require__(8809);
/**
 * An instance of this error class will be returned when you call `save()` multiple
 * times on the same document in parallel. See the [FAQ](/docs/faq.html) for more
 * information.
 *
 * @api public
 * @memberOf Error
 * @static ParallelSaveError
 */

MongooseError.ParallelSaveError = __webpack_require__(5007);
/**
 * Thrown when a model with the given name was already registered on the connection.
 * See [the FAQ about `OverwriteModelError`](/docs/faq.html#overwrite-model-error).
 *
 * @api public
 * @memberOf Error
 * @static OverwriteModelError
 */

MongooseError.OverwriteModelError = __webpack_require__(5676);
/**
 * Thrown when you try to access a model that has not been registered yet
 *
 * @api public
 * @memberOf Error
 * @static MissingSchemaError
 */

MongooseError.MissingSchemaError = __webpack_require__(1511);
/**
 * Thrown when the MongoDB Node driver can't connect to a valid server
 * to send an operation to.
 *
 * @api public
 * @memberOf Error
 * @static MongooseServerSelectionError
 */

MongooseError.MongooseServerSelectionError = __webpack_require__(1870);
/**
 * An instance of this error will be returned if you used an array projection
 * and then modified the array in an unsafe way.
 *
 * @api public
 * @memberOf Error
 * @static DivergentArrayError
 */

MongooseError.DivergentArrayError = __webpack_require__(6067);
/**
 * Thrown when your try to pass values to model contrtuctor that
 * were not specified in schema or change immutable properties when
 * `strict` mode is `"throw"`
 *
 * @api public
 * @memberOf Error
 * @static StrictModeError
 */

MongooseError.StrictModeError = __webpack_require__(3328);

/***/ }),

/***/ 983:
/***/ ((module, exports) => {

"use strict";
/**
 * The default built-in validator error messages. These may be customized.
 *
 *     // customize within each schema or globally like so
 *     const mongoose = require('mongoose');
 *     mongoose.Error.messages.String.enum  = "Your custom message for {PATH}.";
 *
 * As you might have noticed, error messages support basic templating
 *
 * - `{PATH}` is replaced with the invalid document path
 * - `{VALUE}` is replaced with the invalid value
 * - `{TYPE}` is replaced with the validator type such as "regexp", "min", or "user defined"
 * - `{MIN}` is replaced with the declared min value for the Number.min validator
 * - `{MAX}` is replaced with the declared max value for the Number.max validator
 *
 * Click the "show code" link below to see all defaults.
 *
 * @static messages
 * @receiver MongooseError
 * @api public
 */


var msg = module.exports = exports = {};
msg.DocumentNotFoundError = null;
msg.general = {};
msg.general["default"] = 'Validator failed for path `{PATH}` with value `{VALUE}`';
msg.general.required = 'Path `{PATH}` is required.';
msg.Number = {};
msg.Number.min = 'Path `{PATH}` ({VALUE}) is less than minimum allowed value ({MIN}).';
msg.Number.max = 'Path `{PATH}` ({VALUE}) is more than maximum allowed value ({MAX}).';
msg.Number["enum"] = '`{VALUE}` is not a valid enum value for path `{PATH}`.';
msg.Date = {};
msg.Date.min = 'Path `{PATH}` ({VALUE}) is before minimum allowed value ({MIN}).';
msg.Date.max = 'Path `{PATH}` ({VALUE}) is after maximum allowed value ({MAX}).';
msg.String = {};
msg.String["enum"] = '`{VALUE}` is not a valid enum value for path `{PATH}`.';
msg.String.match = 'Path `{PATH}` is invalid ({VALUE}).';
msg.String.minlength = 'Path `{PATH}` (`{VALUE}`) is shorter than the minimum allowed length ({MINLENGTH}).';
msg.String.maxlength = 'Path `{PATH}` (`{VALUE}`) is longer than the maximum allowed length ({MAXLENGTH}).';

/***/ }),

/***/ 1511:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var MissingSchemaError = /*#__PURE__*/function (_MongooseError) {
  _inherits(MissingSchemaError, _MongooseError);

  var _super = _createSuper(MissingSchemaError);

  /*!
   * MissingSchema Error constructor.
   * @param {String} name
   */
  function MissingSchemaError(name) {
    _classCallCheck(this, MissingSchemaError);

    var msg = 'Schema hasn\'t been registered for model "' + name + '".\n' + 'Use mongoose.model(name, schema)';
    return _super.call(this, msg);
  }

  return _createClass(MissingSchemaError);
}(MongooseError);

Object.defineProperty(MissingSchemaError.prototype, 'name', {
  value: 'MissingSchemaError'
});
/*!
 * exports
 */

module.exports = MissingSchemaError;

/***/ }),

/***/ 5202:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = /*#__PURE__*/function (_Error) {
  _inherits(MongooseError, _Error);

  var _super = _createSuper(MongooseError);

  function MongooseError() {
    _classCallCheck(this, MongooseError);

    return _super.apply(this, arguments);
  }

  return _createClass(MongooseError);
}( /*#__PURE__*/_wrapNativeSuper(Error));

Object.defineProperty(MongooseError.prototype, 'name', {
  value: 'MongooseError'
});
module.exports = MongooseError;

/***/ }),

/***/ 3640:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var util = __webpack_require__(161);

var DocumentNotFoundError = /*#__PURE__*/function (_MongooseError) {
  _inherits(DocumentNotFoundError, _MongooseError);

  var _super = _createSuper(DocumentNotFoundError);

  /*!
   * OverwriteModel Error constructor.
   */
  function DocumentNotFoundError(filter, model, numAffected, result) {
    var _this;

    _classCallCheck(this, DocumentNotFoundError);

    var msg;
    var messages = MongooseError.messages;

    if (messages.DocumentNotFoundError != null) {
      msg = typeof messages.DocumentNotFoundError === 'function' ? messages.DocumentNotFoundError(filter, model) : messages.DocumentNotFoundError;
    } else {
      msg = 'No document found for query "' + util.inspect(filter) + '" on model "' + model + '"';
    }

    _this = _super.call(this, msg);
    _this.result = result;
    _this.numAffected = numAffected;
    _this.filter = filter; // Backwards compat

    _this.query = filter;
    return _this;
  }

  return _createClass(DocumentNotFoundError);
}(MongooseError);

Object.defineProperty(DocumentNotFoundError.prototype, 'name', {
  value: 'DocumentNotFoundError'
});
/*!
 * exports
 */

module.exports = DocumentNotFoundError;

/***/ }),

/***/ 4107:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var ObjectExpectedError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ObjectExpectedError, _MongooseError);

  var _super = _createSuper(ObjectExpectedError);

  /**
   * Strict mode error constructor
   *
   * @param {string} type
   * @param {string} value
   * @api private
   */
  function ObjectExpectedError(path, val) {
    var _this;

    _classCallCheck(this, ObjectExpectedError);

    var typeDescription = Array.isArray(val) ? 'array' : 'primitive value';
    _this = _super.call(this, 'Tried to set nested object field `' + path + "` to ".concat(typeDescription, " `") + val + '`');
    _this.path = path;
    return _this;
  }

  return _createClass(ObjectExpectedError);
}(MongooseError);

Object.defineProperty(ObjectExpectedError.prototype, 'name', {
  value: 'ObjectExpectedError'
});
module.exports = ObjectExpectedError;

/***/ }),

/***/ 900:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var ObjectParameterError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ObjectParameterError, _MongooseError);

  var _super = _createSuper(ObjectParameterError);

  /**
   * Constructor for errors that happen when a parameter that's expected to be
   * an object isn't an object
   *
   * @param {Any} value
   * @param {String} paramName
   * @param {String} fnName
   * @api private
   */
  function ObjectParameterError(value, paramName, fnName) {
    _classCallCheck(this, ObjectParameterError);

    return _super.call(this, 'Parameter "' + paramName + '" to ' + fnName + '() must be an object, got ' + value.toString());
  }

  return _createClass(ObjectParameterError);
}(MongooseError);

Object.defineProperty(ObjectParameterError.prototype, 'name', {
  value: 'ObjectParameterError'
});
module.exports = ObjectParameterError;

/***/ }),

/***/ 5676:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var OverwriteModelError = /*#__PURE__*/function (_MongooseError) {
  _inherits(OverwriteModelError, _MongooseError);

  var _super = _createSuper(OverwriteModelError);

  /*!
   * OverwriteModel Error constructor.
   * @param {String} name
   */
  function OverwriteModelError(name) {
    _classCallCheck(this, OverwriteModelError);

    return _super.call(this, 'Cannot overwrite `' + name + '` model once compiled.');
  }

  return _createClass(OverwriteModelError);
}(MongooseError);

Object.defineProperty(OverwriteModelError.prototype, 'name', {
  value: 'OverwriteModelError'
});
/*!
 * exports
 */

module.exports = OverwriteModelError;

/***/ }),

/***/ 5007:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var ParallelSaveError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ParallelSaveError, _MongooseError);

  var _super = _createSuper(ParallelSaveError);

  /**
   * ParallelSave Error constructor.
   *
   * @param {Document} doc
   * @api private
   */
  function ParallelSaveError(doc) {
    _classCallCheck(this, ParallelSaveError);

    var msg = 'Can\'t save() the same doc multiple times in parallel. Document: ';
    return _super.call(this, msg + doc._id);
  }

  return _createClass(ParallelSaveError);
}(MongooseError);

Object.defineProperty(ParallelSaveError.prototype, 'name', {
  value: 'ParallelSaveError'
});
/*!
 * exports
 */

module.exports = ParallelSaveError;

/***/ }),

/***/ 7962:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(5202);

var ParallelValidateError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ParallelValidateError, _MongooseError);

  var _super = _createSuper(ParallelValidateError);

  /**
   * ParallelValidate Error constructor.
   *
   * @param {Document} doc
   * @api private
   */
  function ParallelValidateError(doc) {
    _classCallCheck(this, ParallelValidateError);

    var msg = 'Can\'t validate() the same doc multiple times in parallel. Document: ';
    return _super.call(this, msg + doc._id);
  }

  return _createClass(ParallelValidateError);
}(MongooseError);

Object.defineProperty(ParallelValidateError.prototype, 'name', {
  value: 'ParallelValidateError'
});
/*!
 * exports
 */

module.exports = ParallelValidateError;

/***/ }),

/***/ 1870:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(5202);

var allServersUnknown = __webpack_require__(5285);

var isAtlas = __webpack_require__(2082);

var isSSLError = __webpack_require__(3871);
/*!
 * ignore
 */


var atlasMessage = 'Could not connect to any servers in your MongoDB Atlas cluster. ' + 'One common reason is that you\'re trying to access the database from ' + 'an IP that isn\'t whitelisted. Make sure your current IP address is on your Atlas ' + 'cluster\'s IP whitelist: https://docs.atlas.mongodb.com/security-whitelist/';
var sslMessage = 'Mongoose is connecting with SSL enabled, but the server is ' + 'not accepting SSL connections. Please ensure that the MongoDB server you are ' + 'connecting to is configured to accept SSL connections. Learn more: ' + 'https://mongoosejs.com/docs/tutorials/ssl.html';

var MongooseServerSelectionError = /*#__PURE__*/function (_MongooseError) {
  _inherits(MongooseServerSelectionError, _MongooseError);

  var _super = _createSuper(MongooseServerSelectionError);

  function MongooseServerSelectionError() {
    _classCallCheck(this, MongooseServerSelectionError);

    return _super.apply(this, arguments);
  }

  _createClass(MongooseServerSelectionError, [{
    key: "assimilateError",
    value:
    /**
     * MongooseServerSelectionError constructor
     *
     * @api private
     */
    function assimilateError(err) {
      var reason = err.reason; // Special message for a case that is likely due to IP whitelisting issues.

      var isAtlasWhitelistError = isAtlas(reason) && allServersUnknown(reason) && err.message.indexOf('bad auth') === -1 && err.message.indexOf('Authentication failed') === -1;

      if (isAtlasWhitelistError) {
        this.message = atlasMessage;
      } else if (isSSLError(reason)) {
        this.message = sslMessage;
      } else {
        this.message = err.message;
      }

      for (var key in err) {
        if (key !== 'name') {
          this[key] = err[key];
        }
      }

      return this;
    }
  }]);

  return MongooseServerSelectionError;
}(MongooseError);

Object.defineProperty(MongooseServerSelectionError.prototype, 'name', {
  value: 'MongooseServerSelectionError'
});
module.exports = MongooseServerSelectionError;

/***/ }),

/***/ 3328:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var StrictModeError = /*#__PURE__*/function (_MongooseError) {
  _inherits(StrictModeError, _MongooseError);

  var _super = _createSuper(StrictModeError);

  /**
   * Strict mode error constructor
   *
   * @param {String} path
   * @param {String} [msg]
   * @param {Boolean} [immutable]
   * @inherits MongooseError
   * @api private
   */
  function StrictModeError(path, msg, immutable) {
    var _this;

    _classCallCheck(this, StrictModeError);

    msg = msg || 'Field `' + path + '` is not in schema and strict ' + 'mode is set to throw.';
    _this = _super.call(this, msg);
    _this.isImmutableError = !!immutable;
    _this.path = path;
    return _this;
  }

  return _createClass(StrictModeError);
}(MongooseError);

Object.defineProperty(StrictModeError.prototype, 'name', {
  value: 'StrictModeError'
});
module.exports = StrictModeError;

/***/ }),

/***/ 122:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module requirements
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(5202);

var getConstructorName = __webpack_require__(1981);

var util = __webpack_require__(161);

var ValidationError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ValidationError, _MongooseError);

  var _super = _createSuper(ValidationError);

  /**
   * Document Validation Error
   *
   * @api private
   * @param {Document} [instance]
   * @inherits MongooseError
   */
  function ValidationError(instance) {
    var _this;

    _classCallCheck(this, ValidationError);

    var _message;

    if (getConstructorName(instance) === 'model') {
      _message = instance.constructor.modelName + ' validation failed';
    } else {
      _message = 'Validation failed';
    }

    _this = _super.call(this, _message);
    _this.errors = {};
    _this._message = _message;

    if (instance) {
      instance.$errors = _this.errors;
    }

    return _this;
  }
  /**
   * Console.log helper
   */


  _createClass(ValidationError, [{
    key: "toString",
    value: function toString() {
      return this.name + ': ' + _generateMessage(this);
    }
    /*!
     * inspect helper
     */

  }, {
    key: "inspect",
    value: function inspect() {
      return Object.assign(new Error(this.message), this);
    }
    /*!
    * add message
    */

  }, {
    key: "addError",
    value: function addError(path, error) {
      this.errors[path] = error;
      this.message = this._message + ': ' + _generateMessage(this);
    }
  }]);

  return ValidationError;
}(MongooseError);

if (util.inspect.custom) {
  /*!
  * Avoid Node deprecation warning DEP0079
  */
  ValidationError.prototype[util.inspect.custom] = ValidationError.prototype.inspect;
}
/*!
 * Helper for JSON.stringify
 * Ensure `name` and `message` show up in toJSON output re: gh-9847
 */


Object.defineProperty(ValidationError.prototype, 'toJSON', {
  enumerable: false,
  writable: false,
  configurable: true,
  value: function value() {
    return Object.assign({}, this, {
      name: this.name,
      message: this.message
    });
  }
});
Object.defineProperty(ValidationError.prototype, 'name', {
  value: 'ValidationError'
});
/*!
 * ignore
 */

function _generateMessage(err) {
  var keys = Object.keys(err.errors || {});
  var len = keys.length;
  var msgs = [];
  var key;

  for (var i = 0; i < len; ++i) {
    key = keys[i];

    if (err === err.errors[key]) {
      continue;
    }

    msgs.push(key + ': ' + err.errors[key].message);
  }

  return msgs.join(', ');
}
/*!
 * Module exports
 */


module.exports = ValidationError;

/***/ }),

/***/ 2037:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var ValidatorError = /*#__PURE__*/function (_MongooseError) {
  _inherits(ValidatorError, _MongooseError);

  var _super = _createSuper(ValidatorError);

  /**
   * Schema validator error
   *
   * @param {Object} properties
   * @api private
   */
  function ValidatorError(properties) {
    var _this;

    _classCallCheck(this, ValidatorError);

    var msg = properties.message;

    if (!msg) {
      msg = MongooseError.messages.general["default"];
    }

    var message = formatMessage(msg, properties);
    _this = _super.call(this, message);
    properties = Object.assign({}, properties, {
      message: message
    });
    _this.properties = properties;
    _this.kind = properties.type;
    _this.path = properties.path;
    _this.value = properties.value;
    _this.reason = properties.reason;
    return _this;
  }
  /*!
   * toString helper
   * TODO remove? This defaults to `${this.name}: ${this.message}`
   */


  _createClass(ValidatorError, [{
    key: "toString",
    value: function toString() {
      return this.message;
    }
    /*!
     * Ensure `name` and `message` show up in toJSON output re: gh-9296
     */

  }, {
    key: "toJSON",
    value: function toJSON() {
      return Object.assign({
        name: this.name,
        message: this.message
      }, this);
    }
  }]);

  return ValidatorError;
}(MongooseError);

Object.defineProperty(ValidatorError.prototype, 'name', {
  value: 'ValidatorError'
});
/*!
 * The object used to define this validator. Not enumerable to hide
 * it from `require('util').inspect()` output re: gh-3925
 */

Object.defineProperty(ValidatorError.prototype, 'properties', {
  enumerable: false,
  writable: true,
  value: null
}); // Exposed for testing

ValidatorError.prototype.formatMessage = formatMessage;
/*!
 * Formats error messages
 */

function formatMessage(msg, properties) {
  if (typeof msg === 'function') {
    return msg(properties);
  }

  var propertyNames = Object.keys(properties);

  for (var _i = 0, _propertyNames = propertyNames; _i < _propertyNames.length; _i++) {
    var propertyName = _propertyNames[_i];

    if (propertyName === 'message') {
      continue;
    }

    msg = msg.replace('{' + propertyName.toUpperCase() + '}', properties[propertyName]);
  }

  return msg;
}
/*!
 * exports
 */


module.exports = ValidatorError;

/***/ }),

/***/ 8809:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseError = __webpack_require__(4888);

var VersionError = /*#__PURE__*/function (_MongooseError) {
  _inherits(VersionError, _MongooseError);

  var _super = _createSuper(VersionError);

  /**
   * Version Error constructor.
   *
   * @param {Document} doc
   * @param {Number} currentVersion
   * @param {Array<String>} modifiedPaths
   * @api private
   */
  function VersionError(doc, currentVersion, modifiedPaths) {
    var _this;

    _classCallCheck(this, VersionError);

    var modifiedPathsStr = modifiedPaths.join(', ');
    _this = _super.call(this, 'No matching document found for id "' + doc._id + '" version ' + currentVersion + ' modifiedPaths "' + modifiedPathsStr + '"');
    _this.version = currentVersion;
    _this.modifiedPaths = modifiedPaths;
    return _this;
  }

  return _createClass(VersionError);
}(MongooseError);

Object.defineProperty(VersionError.prototype, 'name', {
  value: 'VersionError'
});
/*!
 * exports
 */

module.exports = VersionError;

/***/ }),

/***/ 6069:
/***/ ((module) => {

"use strict";


module.exports = arrayDepth;

function arrayDepth(arr) {
  if (!Array.isArray(arr)) {
    return {
      min: 0,
      max: 0,
      containsNonArrayItem: true
    };
  }

  if (arr.length === 0) {
    return {
      min: 1,
      max: 1,
      containsNonArrayItem: false
    };
  }

  if (arr.length === 1 && !Array.isArray(arr[0])) {
    return {
      min: 1,
      max: 1,
      containsNonArrayItem: false
    };
  }

  var res = arrayDepth(arr[0]);

  for (var i = 1; i < arr.length; ++i) {
    var _res = arrayDepth(arr[i]);

    if (_res.min < res.min) {
      res.min = _res.min;
    }

    if (_res.max > res.max) {
      res.max = _res.max;
    }

    res.containsNonArrayItem = res.containsNonArrayItem || _res.containsNonArrayItem;
  }

  res.min = res.min + 1;
  res.max = res.max + 1;
  return res;
}

/***/ }),

/***/ 1973:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var Decimal = __webpack_require__(5003);

var ObjectId = __webpack_require__(6079);

var specialProperties = __webpack_require__(2862);

var isMongooseObject = __webpack_require__(6584);

var getFunctionName = __webpack_require__(6749);

var isBsonType = __webpack_require__(1563);

var isObject = __webpack_require__(5721);

var symbols = __webpack_require__(8770);

var trustedSymbol = (__webpack_require__(3636).trustedSymbol);

var utils = __webpack_require__(6872);
/*!
 * Object clone with Mongoose natives support.
 *
 * If options.minimize is true, creates a minimal data object. Empty objects and undefined values will not be cloned. This makes the data payload sent to MongoDB as small as possible.
 *
 * Functions are never cloned.
 *
 * @param {Object} obj the object to clone
 * @param {Object} options
 * @param {Boolean} isArrayChild true if cloning immediately underneath an array. Special case for minimize.
 * @return {Object} the cloned object
 * @api private
 */


function clone(obj, options, isArrayChild) {
  if (obj == null) {
    return obj;
  }

  if (Array.isArray(obj)) {
    return cloneArray(utils.isMongooseArray(obj) ? obj.__array : obj, options);
  }

  if (isMongooseObject(obj)) {
    // Single nested subdocs should apply getters later in `applyGetters()`
    // when calling `toObject()`. See gh-7442, gh-8295
    if (options && options._skipSingleNestedGetters && obj.$isSingleNested) {
      options = Object.assign({}, options, {
        getters: false
      });
    }

    var isSingleNested = obj.$isSingleNested;

    if (utils.isPOJO(obj) && obj.$__ != null && obj._doc != null) {
      return obj._doc;
    }

    var ret;

    if (options && options.json && typeof obj.toJSON === 'function') {
      ret = obj.toJSON(options);
    } else {
      ret = obj.toObject(options);
    }

    if (options && options.minimize && isSingleNested && Object.keys(ret).length === 0) {
      return undefined;
    }

    return ret;
  }

  var objConstructor = obj.constructor;

  if (objConstructor) {
    switch (getFunctionName(objConstructor)) {
      case 'Object':
        return cloneObject(obj, options, isArrayChild);

      case 'Date':
        return new objConstructor(+obj);

      case 'RegExp':
        return cloneRegExp(obj);

      default:
        // ignore
        break;
    }
  }

  if (isBsonType(obj, 'ObjectID')) {
    return new ObjectId(obj.id);
  }

  if (isBsonType(obj, 'Decimal128')) {
    if (options && options.flattenDecimals) {
      return obj.toJSON();
    }

    return Decimal.fromString(obj.toString());
  } // object created with Object.create(null)


  if (!objConstructor && isObject(obj)) {
    return cloneObject(obj, options, isArrayChild);
  }

  if (_typeof(obj) === 'object' && obj[symbols.schemaTypeSymbol]) {
    return obj.clone();
  } // If we're cloning this object to go into a MongoDB command,
  // and there's a `toBSON()` function, assume this object will be
  // stored as a primitive in MongoDB and doesn't need to be cloned.


  if (options && options.bson && typeof obj.toBSON === 'function') {
    return obj;
  }

  if (typeof obj.valueOf === 'function') {
    return obj.valueOf();
  }

  return cloneObject(obj, options, isArrayChild);
}

module.exports = clone;
/*!
 * ignore
 */

function cloneObject(obj, options, isArrayChild) {
  var minimize = options && options.minimize;
  var omitUndefined = options && options.omitUndefined;
  var seen = options && options._seen;
  var ret = {};
  var hasKeys;

  if (seen && seen.has(obj)) {
    return seen.get(obj);
  } else if (seen) {
    seen.set(obj, ret);
  }

  if (trustedSymbol in obj) {
    ret[trustedSymbol] = obj[trustedSymbol];
  }

  var i = 0;
  var key = '';
  var keys = Object.keys(obj);
  var len = keys.length;

  for (i = 0; i < len; ++i) {
    if (specialProperties.has(key = keys[i])) {
      continue;
    } // Don't pass `isArrayChild` down


    var val = clone(obj[key], options, false);

    if ((minimize === false || omitUndefined) && typeof val === 'undefined') {
      delete ret[key];
    } else if (minimize !== true || typeof val !== 'undefined') {
      hasKeys || (hasKeys = true);
      ret[key] = val;
    }
  }

  return minimize && !isArrayChild ? hasKeys && ret : ret;
}

function cloneArray(arr, options) {
  var i = 0;
  var len = arr.length;
  var ret = new Array(len);

  for (i = 0; i < len; ++i) {
    ret[i] = clone(arr[i], options, true);
  }

  return ret;
}

function cloneRegExp(regexp) {
  var ret = new RegExp(regexp.source, regexp.flags);

  if (ret.lastIndex !== regexp.lastIndex) {
    ret.lastIndex = regexp.lastIndex;
  }

  return ret;
}

/***/ }),

/***/ 2829:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var Binary = (__webpack_require__(9906).get)().Binary;

var isBsonType = __webpack_require__(1563);

var isMongooseObject = __webpack_require__(6584);

exports.x = flatten;
__webpack_unused_export__ = modifiedPaths;
/*!
 * ignore
 */

function flatten(update, path, options, schema) {
  var keys;

  if (update && isMongooseObject(update) && !Buffer.isBuffer(update)) {
    keys = Object.keys(update.toObject({
      transform: false,
      virtuals: false
    }) || {});
  } else {
    keys = Object.keys(update || {});
  }

  var numKeys = keys.length;
  var result = {};
  path = path ? path + '.' : '';

  for (var i = 0; i < numKeys; ++i) {
    var key = keys[i];
    var val = update[key];
    result[path + key] = val; // Avoid going into mixed paths if schema is specified

    var keySchema = schema && schema.path && schema.path(path + key);
    var isNested = schema && schema.nested && schema.nested[path + key];
    if (keySchema && keySchema.instance === 'Mixed') continue;

    if (shouldFlatten(val)) {
      if (options && options.skipArrays && Array.isArray(val)) {
        continue;
      }

      var flat = flatten(val, path + key, options, schema);

      for (var k in flat) {
        result[k] = flat[k];
      }

      if (Array.isArray(val)) {
        result[path + key] = val;
      }
    }

    if (isNested) {
      var paths = Object.keys(schema.paths);

      for (var _i = 0, _paths = paths; _i < _paths.length; _i++) {
        var p = _paths[_i];

        if (p.startsWith(path + key + '.') && !result.hasOwnProperty(p)) {
          result[p] = void 0;
        }
      }
    }
  }

  return result;
}
/*!
 * ignore
 */


function modifiedPaths(update, path, result) {
  var keys = Object.keys(update || {});
  var numKeys = keys.length;
  result = result || {};
  path = path ? path + '.' : '';

  for (var i = 0; i < numKeys; ++i) {
    var key = keys[i];
    var val = update[key];

    var _path = path + key;

    result[_path] = true;

    if (!Buffer.isBuffer(val) && isMongooseObject(val)) {
      val = val.toObject({
        transform: false,
        virtuals: false
      });
    }

    if (shouldFlatten(val)) {
      modifiedPaths(val, path + key, result);
    }
  }

  return result;
}
/*!
 * ignore
 */


function shouldFlatten(val) {
  return val && _typeof(val) === 'object' && !(val instanceof Date) && !isBsonType(val, 'ObjectID') && (!Array.isArray(val) || val.length !== 0) && !(val instanceof Buffer) && !isBsonType(val, 'Decimal128') && !(val instanceof Binary);
}

/***/ }),

/***/ 2794:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isBsonType = __webpack_require__(1563);

module.exports = function areDiscriminatorValuesEqual(a, b) {
  if (typeof a === 'string' && typeof b === 'string') {
    return a === b;
  }

  if (typeof a === 'number' && typeof b === 'number') {
    return a === b;
  }

  if (isBsonType(a, 'ObjectID') && isBsonType(b, 'ObjectID')) {
    return a.toString() === b.toString();
  }

  return false;
};

/***/ }),

/***/ 4531:
/***/ ((module) => {

"use strict";


module.exports = function checkEmbeddedDiscriminatorKeyProjection(userProjection, path, schema, selected, addedPaths) {
  var userProjectedInPath = Object.keys(userProjection).reduce(function (cur, key) {
    return cur || key.startsWith(path + '.');
  }, false);

  var _discriminatorKey = path + '.' + schema.options.discriminatorKey;

  if (!userProjectedInPath && addedPaths.length === 1 && addedPaths[0] === _discriminatorKey) {
    selected.splice(selected.indexOf(_discriminatorKey), 1);
  }
};

/***/ }),

/***/ 8413:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getDiscriminatorByValue = __webpack_require__(7291);
/*!
 * Find the correct constructor, taking into account discriminators
 */


module.exports = function getConstructor(Constructor, value) {
  var discriminatorKey = Constructor.schema.options.discriminatorKey;

  if (value != null && Constructor.discriminators && value[discriminatorKey] != null) {
    if (Constructor.discriminators[value[discriminatorKey]]) {
      Constructor = Constructor.discriminators[value[discriminatorKey]];
    } else {
      var constructorByValue = getDiscriminatorByValue(Constructor.discriminators, value[discriminatorKey]);

      if (constructorByValue) {
        Constructor = constructorByValue;
      }
    }
  }

  return Constructor;
};

/***/ }),

/***/ 7291:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var areDiscriminatorValuesEqual = __webpack_require__(2794);
/*!
* returns discriminator by discriminatorMapping.value
*
* @param {Model} model
* @param {string} value
*/


module.exports = function getDiscriminatorByValue(discriminators, value) {
  if (discriminators == null) {
    return null;
  }

  for (var _i = 0, _Object$keys = Object.keys(discriminators); _i < _Object$keys.length; _i++) {
    var name = _Object$keys[_i];
    var it = discriminators[name];

    if (it.schema && it.schema.discriminatorMapping && areDiscriminatorValuesEqual(it.schema.discriminatorMapping.value, value)) {
      return it;
    }
  }

  return null;
};

/***/ }),

/***/ 2392:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var areDiscriminatorValuesEqual = __webpack_require__(2794);
/*!
* returns discriminator by discriminatorMapping.value
*
* @param {Schema} schema
* @param {string} value
*/


module.exports = function getSchemaDiscriminatorByValue(schema, value) {
  if (schema == null || schema.discriminators == null) {
    return null;
  }

  for (var _i = 0, _Object$keys = Object.keys(schema.discriminators); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    var discriminatorSchema = schema.discriminators[key];

    if (discriminatorSchema.discriminatorMapping == null) {
      continue;
    }

    if (areDiscriminatorValuesEqual(discriminatorSchema.discriminatorMapping.value, value)) {
      return discriminatorSchema;
    }
  }

  return null;
};

/***/ }),

/***/ 4134:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

module.exports = function cleanModifiedSubpaths(doc, path, options) {
  options = options || {};
  var skipDocArrays = options.skipDocArrays;
  var deleted = 0;

  if (!doc) {
    return deleted;
  }

  for (var _i = 0, _Object$keys = Object.keys(doc.$__.activePaths.states.modify); _i < _Object$keys.length; _i++) {
    var modifiedPath = _Object$keys[_i];

    if (skipDocArrays) {
      var schemaType = doc.$__schema.path(modifiedPath);

      if (schemaType && schemaType.$isMongooseDocumentArray) {
        continue;
      }
    }

    if (modifiedPath.startsWith(path + '.')) {
      delete doc.$__.activePaths.states.modify[modifiedPath];
      ++deleted;

      if (doc.$isSubdocument) {
        var owner = doc.ownerDocument();
        var fullPath = doc.$__fullPath(modifiedPath);
        delete owner.$__.activePaths.states.modify[fullPath];
      }
    }
  }

  return deleted;
};

/***/ }),

/***/ 8724:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var documentSchemaSymbol = (__webpack_require__(8770).documentSchemaSymbol);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var utils = __webpack_require__(6872);

var Document;

var getSymbol = (__webpack_require__(8770).getSymbol);

var scopeSymbol = (__webpack_require__(8770).scopeSymbol);

var isPOJO = utils.isPOJO;
/*!
 * exports
 */

exports.M = compile;
exports.c = defineKey;
/*!
 * Compiles schemas.
 */

function compile(tree, proto, prefix, options) {
  Document = Document || __webpack_require__(8727);
  var typeKey = options.typeKey;

  for (var _i = 0, _Object$keys = Object.keys(tree); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    var limb = tree[key];
    var hasSubprops = isPOJO(limb) && Object.keys(limb).length > 0 && (!limb[typeKey] || typeKey === 'type' && isPOJO(limb.type) && limb.type.type);
    var subprops = hasSubprops ? limb : null;
    defineKey({
      prop: key,
      subprops: subprops,
      prototype: proto,
      prefix: prefix,
      options: options
    });
  }
}
/*!
 * Defines the accessor named prop on the incoming prototype.
 */


function defineKey(_ref) {
  var prop = _ref.prop,
      subprops = _ref.subprops,
      prototype = _ref.prototype,
      prefix = _ref.prefix,
      options = _ref.options;
  Document = Document || __webpack_require__(8727);
  var path = (prefix ? prefix + '.' : '') + prop;
  prefix = prefix || '';

  if (subprops) {
    Object.defineProperty(prototype, prop, {
      enumerable: true,
      configurable: true,
      get: function get() {
        var _this = this;

        if (!this.$__.getters) {
          this.$__.getters = {};
        }

        if (!this.$__.getters[path]) {
          var nested = Object.create(Document.prototype, getOwnPropertyDescriptors(this)); // save scope for nested getters/setters

          if (!prefix) {
            nested.$__[scopeSymbol] = this;
          }

          nested.$__.nestedPath = path;
          Object.defineProperty(nested, 'schema', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: prototype.schema
          });
          Object.defineProperty(nested, '$__schema', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: prototype.schema
          });
          Object.defineProperty(nested, documentSchemaSymbol, {
            enumerable: false,
            configurable: true,
            writable: false,
            value: prototype.schema
          });
          Object.defineProperty(nested, 'toObject', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: function value() {
              return utils.clone(_this.get(path, null, {
                virtuals: this && this.schema && this.schema.options && this.schema.options.toObject && this.schema.options.toObject.virtuals || null
              }));
            }
          });
          Object.defineProperty(nested, '$__get', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: function value() {
              return _this.get(path, null, {
                virtuals: this && this.schema && this.schema.options && this.schema.options.toObject && this.schema.options.toObject.virtuals || null
              });
            }
          });
          Object.defineProperty(nested, 'toJSON', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: function value() {
              return _this.get(path, null, {
                virtuals: this && this.schema && this.schema.options && this.schema.options.toJSON && this.schema.options.toJSON.virtuals || null
              });
            }
          });
          Object.defineProperty(nested, '$__isNested', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: true
          });

          var _isEmptyOptions = Object.freeze({
            minimize: true,
            virtuals: false,
            getters: false,
            transform: false
          });

          Object.defineProperty(nested, '$isEmpty', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: function value() {
              return Object.keys(this.get(path, null, _isEmptyOptions) || {}).length === 0;
            }
          });
          Object.defineProperty(nested, '$__parent', {
            enumerable: false,
            configurable: true,
            writable: false,
            value: this
          });
          compile(subprops, nested, path, options);
          this.$__.getters[path] = nested;
        }

        return this.$__.getters[path];
      },
      set: function set(v) {
        if (v != null && v.$__isNested) {
          // Convert top-level to POJO, but leave subdocs hydrated so `$set`
          // can handle them. See gh-9293.
          v = v.$__get();
        } else if (v instanceof Document && !v.$__isNested) {
          v = v.$toObject(internalToObjectOptions);
        }

        var doc = this.$__[scopeSymbol] || this;
        doc.$set(path, v);
      }
    });
  } else {
    Object.defineProperty(prototype, prop, {
      enumerable: true,
      configurable: true,
      get: function get() {
        return this[getSymbol].call(this.$__[scopeSymbol] || this, path);
      },
      set: function set(v) {
        this.$set.call(this.$__[scopeSymbol] || this, path, v);
      }
    });
  }
} // gets descriptors for all properties of `object`
// makes all properties non-enumerable to match previous behavior to #2211


function getOwnPropertyDescriptors(object) {
  var result = {};
  Object.getOwnPropertyNames(object).forEach(function (key) {
    var skip = ['isNew', '$__', '$errors', 'errors', '_doc', '$locals', '$op', '__parentArray', '__index', '$isDocumentArrayElement'].indexOf(key) === -1;

    if (skip) {
      return;
    }

    result[key] = Object.getOwnPropertyDescriptor(object, key);
    result[key].enumerable = false;
  });
  return result;
}

/***/ }),

/***/ 111:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var get = __webpack_require__(9981);

var getSchemaDiscriminatorByValue = __webpack_require__(2392);
/*!
 * Like `schema.path()`, except with a document, because impossible to
 * determine path type without knowing the embedded discriminator key.
 */


module.exports = function getEmbeddedDiscriminatorPath(doc, path, options) {
  options = options || {};
  var typeOnly = options.typeOnly;
  var parts = path.indexOf('.') === -1 ? [path] : path.split('.');
  var schemaType = null;
  var type = 'adhocOrUndefined';
  var schema = getSchemaDiscriminatorByValue(doc.schema, doc.get(doc.schema.options.discriminatorKey)) || doc.schema;

  for (var i = 0; i < parts.length; ++i) {
    var subpath = parts.slice(0, i + 1).join('.');
    schemaType = schema.path(subpath);

    if (schemaType == null) {
      type = 'adhocOrUndefined';
      continue;
    }

    if (schemaType.instance === 'Mixed') {
      return typeOnly ? 'real' : schemaType;
    }

    type = schema.pathType(subpath);

    if ((schemaType.$isSingleNested || schemaType.$isMongooseDocumentArrayElement) && schemaType.schema.discriminators != null) {
      var discriminators = schemaType.schema.discriminators;
      var discriminatorKey = doc.get(subpath + '.' + get(schemaType, 'schema.options.discriminatorKey'));

      if (discriminatorKey == null || discriminators[discriminatorKey] == null) {
        continue;
      }

      var rest = parts.slice(i + 1).join('.');
      return getEmbeddedDiscriminatorPath(doc.get(subpath), rest, options);
    }
  } // Are we getting the whole schema or just the type, 'real', 'nested', etc.


  return typeOnly ? type : schemaType;
};

/***/ }),

/***/ 719:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var utils = __webpack_require__(6872);

var keysToSkip = new Set(['__index', '__parentArray', '_doc']);
/**
 * Using spread operator on a Mongoose document gives you a
 * POJO that has a tendency to cause infinite recursion. So
 * we use this function on `set()` to prevent that.
 */

module.exports = function handleSpreadDoc(v, includeExtraKeys) {
  if (utils.isPOJO(v) && v.$__ != null && v._doc != null) {
    if (includeExtraKeys) {
      var extraKeys = {};

      for (var _i = 0, _Object$keys = Object.keys(v); _i < _Object$keys.length; _i++) {
        var key = _Object$keys[_i];

        if (_typeof(key) === 'symbol') {
          continue;
        }

        if (key[0] === '$') {
          continue;
        }

        if (keysToSkip.has(key)) {
          continue;
        }

        extraKeys[key] = v[key];
      }

      return _objectSpread(_objectSpread({}, v._doc), extraKeys);
    }

    return v._doc;
  }

  return v;
};

/***/ }),

/***/ 9981:
/***/ ((module) => {

"use strict";

/*!
 * Simplified lodash.get to work around the annoying null quirk. See:
 * https://github.com/lodash/lodash/issues/3659
 */

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

module.exports = function get(obj, path, def) {
  var parts;
  var isPathArray = false;

  if (typeof path === 'string') {
    if (path.indexOf('.') === -1) {
      var _v = getProperty(obj, path);

      if (_v == null) {
        return def;
      }

      return _v;
    }

    parts = path.split('.');
  } else {
    isPathArray = true;
    parts = path;

    if (parts.length === 1) {
      var _v2 = getProperty(obj, parts[0]);

      if (_v2 == null) {
        return def;
      }

      return _v2;
    }
  }

  var rest = path;
  var cur = obj;

  var _iterator = _createForOfIteratorHelper(parts),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var part = _step.value;

      if (cur == null) {
        return def;
      } // `lib/cast.js` depends on being able to get dotted paths in updates,
      // like `{ $set: { 'a.b': 42 } }`


      if (!isPathArray && cur[rest] != null) {
        return cur[rest];
      }

      cur = getProperty(cur, part);

      if (!isPathArray) {
        rest = rest.substr(part.length + 1);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return cur == null ? def : cur;
};

function getProperty(obj, prop) {
  if (obj == null) {
    return obj;
  }

  if (obj instanceof Map) {
    return obj.get(prop);
  }

  return obj[prop];
}

/***/ }),

/***/ 1981:
/***/ ((module) => {

"use strict";

/*!
 * If `val` is an object, returns constructor name, if possible. Otherwise returns undefined.
 */

module.exports = function getConstructorName(val) {
  if (val == null) {
    return void 0;
  }

  if (typeof val.constructor !== 'function') {
    return void 0;
  }

  return val.constructor.name;
};

/***/ }),

/***/ 6749:
/***/ ((module) => {

"use strict";


var functionNameRE = /^function\s*([^\s(]+)/;

module.exports = function (fn) {
  return fn.name || (fn.toString().trim().match(functionNameRE) || [])[1];
};

/***/ }),

/***/ 1490:
/***/ ((module) => {

"use strict";
/*!
 * Centralize this so we can more easily work around issues with people
 * stubbing out `process.nextTick()` in tests using sinon:
 * https://github.com/sinonjs/lolex#automatically-incrementing-mocked-time
 * See gh-6074
 */


var nextTick = typeof ({env:{}}) !== 'undefined' && typeof ({env:{}}).nextTick === 'function' ? ({env:{}}).nextTick.bind(({env:{}})) : function (cb) {
  return setTimeout(cb, 0);
}; // Fallback for browser build

module.exports = function immediate(cb) {
  return nextTick(cb);
};

/***/ }),

/***/ 1605:
/***/ ((module) => {

"use strict";


module.exports = function decorateDiscriminatorIndexOptions(schema, indexOptions) {
  // If the model is a discriminator and has an index, add a
  // partialFilterExpression by default so the index will only apply
  // to that discriminator.
  var discriminatorName = schema.discriminatorMapping && schema.discriminatorMapping.value;

  if (discriminatorName && !('sparse' in indexOptions)) {
    var discriminatorKey = schema.options.discriminatorKey;
    indexOptions.partialFilterExpression = indexOptions.partialFilterExpression || {};
    indexOptions.partialFilterExpression[discriminatorKey] = discriminatorName;
  }

  return indexOptions;
};

/***/ }),

/***/ 8857:
/***/ ((module) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var asyncFunctionPrototype = null; // try/catch for Babel compatibility, because Babel preset-env requires
// regenerator-runtime for async/await and we don't want to include that
// for a simple check.

try {
  asyncFunctionPrototype = Object.getPrototypeOf( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
} catch (err) {}

if (asyncFunctionPrototype == null) {
  module.exports = function isAsyncFunction() {
    return false;
  };
} else {
  module.exports = function isAsyncFunction(v) {
    return typeof v === 'function' && Object.getPrototypeOf(v) === asyncFunctionPrototype;
  };
}

/***/ }),

/***/ 1563:
/***/ ((module) => {

"use strict";

/*!
 * Get the bson type, if it exists
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function isBsonType(obj, typename) {
  return _typeof(obj) === 'object' && obj !== null && obj._bsontype === typename;
}

module.exports = isBsonType;

/***/ }),

/***/ 6584:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isMongooseArray = (__webpack_require__(7339).isMongooseArray);
/*!
 * Returns if `v` is a mongoose object that has a `toObject()` method we can use.
 *
 * This is for compatibility with libs like Date.js which do foolish things to Natives.
 *
 * @param {any} v
 * @api private
 */


module.exports = function (v) {
  return v != null && (isMongooseArray(v) || // Array or Document Array
  v.$__ != null || // Document
  v.isMongooseBuffer || // Buffer
  v.$isMongooseMap // Map
  );
};

/***/ }),

/***/ 5721:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];

/*!
 * Determines if `arg` is an object.
 *
 * @param {Object|Array|String|Function|RegExp|any} arg
 * @api private
 * @return {Boolean}
 */

module.exports = function (arg) {
  return Buffer.isBuffer(arg) || Object.prototype.toString.call(arg) === '[object Object]';
};

/***/ }),

/***/ 5543:
/***/ ((module) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function isPromise(val) {
  return !!val && (_typeof(val) === 'object' || typeof val === 'function') && typeof val.then === 'function';
}

module.exports = isPromise;

/***/ }),

/***/ 9130:
/***/ ((module) => {

"use strict";

/*!
 * Determines if `arg` is a flat object.
 *
 * @param {Object|Array|String|Function|RegExp|any} arg
 * @api private
 * @return {Boolean}
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

module.exports = function isSimpleValidator(obj) {
  var keys = Object.keys(obj);
  var result = true;

  for (var i = 0, len = keys.length; i < len; ++i) {
    if (_typeof(obj[keys[i]]) === 'object' && obj[keys[i]] !== null) {
      result = false;
      break;
    }
  }

  return result;
};

/***/ }),

/***/ 8859:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var symbols = __webpack_require__(8107);

var promiseOrCallback = __webpack_require__(8486);
/*!
 * ignore
 */


module.exports = applyHooks;
/*!
 * ignore
 */

applyHooks.middlewareFunctions = ['deleteOne', 'save', 'validate', 'remove', 'updateOne', 'init'];
/*!
 * Register hooks for this model
 *
 * @param {Model} model
 * @param {Schema} schema
 */

function applyHooks(model, schema, options) {
  options = options || {};
  var kareemOptions = {
    useErrorHandlers: true,
    numCallbackParams: 1,
    nullResultByDefault: true,
    contextParameter: true
  };
  var objToDecorate = options.decorateDoc ? model : model.prototype;
  model.$appliedHooks = true;

  for (var _i = 0, _Object$keys = Object.keys(schema.paths); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    var type = schema.paths[key];
    var childModel = null;

    if (type.$isSingleNested) {
      childModel = type.caster;
    } else if (type.$isMongooseDocumentArray) {
      childModel = type.Constructor;
    } else {
      continue;
    }

    if (childModel.$appliedHooks) {
      continue;
    }

    applyHooks(childModel, type.schema, options);

    if (childModel.discriminators != null) {
      var keys = Object.keys(childModel.discriminators);

      for (var _i2 = 0, _keys = keys; _i2 < _keys.length; _i2++) {
        var _key = _keys[_i2];
        applyHooks(childModel.discriminators[_key], childModel.discriminators[_key].schema, options);
      }
    }
  } // Built-in hooks rely on hooking internal functions in order to support
  // promises and make it so that `doc.save.toString()` provides meaningful
  // information.


  var middleware = schema.s.hooks.filter(function (hook) {
    if (hook.name === 'updateOne' || hook.name === 'deleteOne') {
      return !!hook['document'];
    }

    if (hook.name === 'remove' || hook.name === 'init') {
      return hook['document'] == null || !!hook['document'];
    }

    if (hook.query != null || hook.document != null) {
      return hook.document !== false;
    }

    return true;
  }).filter(function (hook) {
    // If user has overwritten the method, don't apply built-in middleware
    if (schema.methods[hook.name]) {
      return !hook.fn[symbols.builtInMiddleware];
    }

    return true;
  });
  model._middleware = middleware;
  objToDecorate.$__originalValidate = objToDecorate.$__originalValidate || objToDecorate.$__validate;

  for (var _i3 = 0, _arr = ['save', 'validate', 'remove', 'deleteOne']; _i3 < _arr.length; _i3++) {
    var method = _arr[_i3];
    var toWrap = method === 'validate' ? '$__originalValidate' : "$__".concat(method);
    var wrapped = middleware.createWrapper(method, objToDecorate[toWrap], null, kareemOptions);
    objToDecorate["$__".concat(method)] = wrapped;
  }

  objToDecorate.$__init = middleware.createWrapperSync('init', objToDecorate.$__init, null, kareemOptions); // Support hooks for custom methods

  var customMethods = Object.keys(schema.methods);
  var customMethodOptions = Object.assign({}, kareemOptions, {
    // Only use `checkForPromise` for custom methods, because mongoose
    // query thunks are not as consistent as I would like about returning
    // a nullish value rather than the query. If a query thunk returns
    // a query, `checkForPromise` causes infinite recursion
    checkForPromise: true
  });

  var _loop = function _loop() {
    var method = _customMethods[_i4];

    if (!middleware.hasHooks(method)) {
      // Don't wrap if there are no hooks for the custom method to avoid
      // surprises. Also, `createWrapper()` enforces consistent async,
      // so wrapping a sync method would break it.
      return "continue";
    }

    var originalMethod = objToDecorate[method];

    objToDecorate[method] = function () {
      var _this = this;

      var args = Array.prototype.slice.call(arguments);
      var cb = args.slice(-1).pop();
      var argsWithoutCallback = typeof cb === 'function' ? args.slice(0, args.length - 1) : args;
      return promiseOrCallback(cb, function (callback) {
        return _this["$__".concat(method)].apply(_this, argsWithoutCallback.concat([callback]));
      }, model.events);
    };

    objToDecorate["$__".concat(method)] = middleware.createWrapper(method, originalMethod, null, customMethodOptions);
  };

  for (var _i4 = 0, _customMethods = customMethods; _i4 < _customMethods.length; _i4++) {
    var _ret = _loop();

    if (_ret === "continue") continue;
  }
}

/***/ }),

/***/ 9181:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var Mixed = __webpack_require__(3861);

var defineKey = (__webpack_require__(8724)/* .defineKey */ .c);

var get = __webpack_require__(9981);

var utils = __webpack_require__(6872);

var CUSTOMIZABLE_DISCRIMINATOR_OPTIONS = {
  toJSON: true,
  toObject: true,
  _id: true,
  id: true
};
/*!
 * ignore
 */

module.exports = function discriminator(model, name, schema, tiedValue, applyPlugins) {
  if (!(schema && schema.instanceOfSchema)) {
    throw new Error('You must pass a valid discriminator Schema');
  }

  if (model.schema.discriminatorMapping && !model.schema.discriminatorMapping.isRoot) {
    throw new Error('Discriminator "' + name + '" can only be a discriminator of the root model');
  }

  if (applyPlugins) {
    var applyPluginsToDiscriminators = get(model.base, 'options.applyPluginsToDiscriminators', false); // Even if `applyPluginsToDiscriminators` isn't set, we should still apply
    // global plugins to schemas embedded in the discriminator schema (gh-7370)

    model.base._applyPlugins(schema, {
      skipTopLevel: !applyPluginsToDiscriminators
    });
  }

  var key = model.schema.options.discriminatorKey;
  var existingPath = model.schema.path(key);

  if (existingPath != null) {
    if (!utils.hasUserDefinedProperty(existingPath.options, 'select')) {
      existingPath.options.select = true;
    }

    existingPath.options.$skipDiscriminatorCheck = true;
  } else {
    var baseSchemaAddition = {};
    baseSchemaAddition[key] = {
      "default": void 0,
      select: true,
      $skipDiscriminatorCheck: true
    };
    baseSchemaAddition[key][model.schema.options.typeKey] = String;
    model.schema.add(baseSchemaAddition);
    defineKey({
      prop: key,
      prototype: model.prototype,
      options: model.schema.options
    });
  }

  if (schema.path(key) && schema.path(key).options.$skipDiscriminatorCheck !== true) {
    throw new Error('Discriminator "' + name + '" cannot have field with name "' + key + '"');
  }

  var value = name;

  if (typeof tiedValue === 'string' && tiedValue.length || tiedValue != null) {
    value = tiedValue;
  }

  function merge(schema, baseSchema) {
    // Retain original schema before merging base schema
    schema._baseSchema = baseSchema;

    if (baseSchema.paths._id && baseSchema.paths._id.options && !baseSchema.paths._id.options.auto) {
      schema.remove('_id');
    } // Find conflicting paths: if something is a path in the base schema
    // and a nested path in the child schema, overwrite the base schema path.
    // See gh-6076


    var baseSchemaPaths = Object.keys(baseSchema.paths);
    var conflictingPaths = [];

    for (var _i = 0, _baseSchemaPaths = baseSchemaPaths; _i < _baseSchemaPaths.length; _i++) {
      var path = _baseSchemaPaths[_i];

      if (schema.nested[path]) {
        conflictingPaths.push(path);
        continue;
      }

      if (path.indexOf('.') === -1) {
        continue;
      }

      var sp = path.split('.').slice(0, -1);
      var cur = '';

      var _iterator = _createForOfIteratorHelper(sp),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var piece = _step.value;
          cur += (cur.length ? '.' : '') + piece;

          if (schema.paths[cur] instanceof Mixed || schema.singleNestedPaths[cur] instanceof Mixed) {
            conflictingPaths.push(path);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    utils.merge(schema, baseSchema, {
      isDiscriminatorSchemaMerge: true,
      omit: {
        discriminators: true,
        base: true,
        _applyDiscriminators: true
      },
      omitNested: conflictingPaths.reduce(function (cur, path) {
        cur['tree.' + path] = true;
        return cur;
      }, {})
    }); // Clean up conflicting paths _after_ merging re: gh-6076

    for (var _i2 = 0, _conflictingPaths = conflictingPaths; _i2 < _conflictingPaths.length; _i2++) {
      var conflictingPath = _conflictingPaths[_i2];
      delete schema.paths[conflictingPath];
    } // Rebuild schema models because schemas may have been merged re: #7884


    schema.childSchemas.forEach(function (obj) {
      obj.model.prototype.$__setSchema(obj.schema);
    });
    var obj = {};
    obj[key] = {
      "default": value,
      select: true,
      set: function set(newName) {
        if (newName === value || Array.isArray(value) && utils.deepEqual(newName, value)) {
          return value;
        }

        throw new Error('Can\'t set discriminator key "' + key + '"');
      },
      $skipDiscriminatorCheck: true
    };
    obj[key][schema.options.typeKey] = existingPath ? existingPath.options[schema.options.typeKey] : String;
    schema.add(obj);
    schema.discriminatorMapping = {
      key: key,
      value: value,
      isRoot: false
    };

    if (baseSchema.options.collection) {
      schema.options.collection = baseSchema.options.collection;
    }

    var toJSON = schema.options.toJSON;
    var toObject = schema.options.toObject;
    var _id = schema.options._id;
    var id = schema.options.id;
    var keys = Object.keys(schema.options);
    schema.options.discriminatorKey = baseSchema.options.discriminatorKey;

    for (var _i3 = 0, _keys = keys; _i3 < _keys.length; _i3++) {
      var _key = _keys[_i3];

      if (!CUSTOMIZABLE_DISCRIMINATOR_OPTIONS[_key]) {
        // Special case: compiling a model sets `pluralization = true` by default. Avoid throwing an error
        // for that case. See gh-9238
        if (_key === 'pluralization' && schema.options[_key] == true && baseSchema.options[_key] == null) {
          continue;
        }

        if (!utils.deepEqual(schema.options[_key], baseSchema.options[_key])) {
          throw new Error('Can\'t customize discriminator option ' + _key + ' (can only modify ' + Object.keys(CUSTOMIZABLE_DISCRIMINATOR_OPTIONS).join(', ') + ')');
        }
      }
    }

    schema.options = utils.clone(baseSchema.options);
    if (toJSON) schema.options.toJSON = toJSON;
    if (toObject) schema.options.toObject = toObject;

    if (typeof _id !== 'undefined') {
      schema.options._id = _id;
    }

    schema.options.id = id;
    schema.s.hooks = model.schema.s.hooks.merge(schema.s.hooks);
    schema.plugins = Array.prototype.slice.call(baseSchema.plugins);
    schema.callQueue = baseSchema.callQueue.concat(schema.callQueue);
    delete schema._requiredpaths; // reset just in case Schema#requiredPaths() was called on either schema
  } // merges base schema into new discriminator schema and sets new type field.


  merge(schema, model.schema);

  if (!model.discriminators) {
    model.discriminators = {};
  }

  if (!model.schema.discriminatorMapping) {
    model.schema.discriminatorMapping = {
      key: key,
      value: null,
      isRoot: true
    };
  }

  if (!model.schema.discriminators) {
    model.schema.discriminators = {};
  }

  model.schema.discriminators[name] = schema;

  if (model.discriminators[name] && !schema.options.overwriteModels) {
    throw new Error('Discriminator with name "' + name + '" already exists');
  }

  return schema;
};

/***/ }),

/***/ 207:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var MongooseError = __webpack_require__(5202);

var setDottedPath = __webpack_require__(2736);

var util = __webpack_require__(161);
/**
 * Given an object that may contain dotted paths, flatten the paths out.
 * For example: `flattenObjectWithDottedPaths({ a: { 'b.c': 42 } })` => `{ a: { b: { c: 42 } } }`
 */


module.exports = function flattenObjectWithDottedPaths(obj) {
  if (obj == null || _typeof(obj) !== 'object' || Array.isArray(obj)) {
    return;
  } // Avoid Mongoose docs


  if (obj.$__) {
    return;
  }

  var keys = Object.keys(obj);

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];
    var val = obj[key];

    if (key.indexOf('.') !== -1) {
      try {
        delete obj[key];
        setDottedPath(obj, key, val);
      } catch (err) {
        if (!(err instanceof TypeError)) {
          throw err;
        }

        throw new MongooseError("Conflicting dotted paths when setting document path, key: \"".concat(key, "\", value: ").concat(util.inspect(val)));
      }

      continue;
    }

    flattenObjectWithDottedPaths(obj[key]);
  }
};

/***/ }),

/***/ 251:
/***/ ((module) => {

"use strict";


var dotRE = /\./g;

module.exports = function parentPaths(path) {
  if (path.indexOf('.') === -1) {
    return [path];
  }

  var pieces = path.split(dotRE);
  var len = pieces.length;
  var ret = new Array(len);
  var cur = '';

  for (var i = 0; i < len; ++i) {
    cur += cur.length !== 0 ? '.' + pieces[i] : pieces[i];
    ret[i] = cur;
  }

  return ret;
};

/***/ }),

/***/ 2736:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var specialProperties = __webpack_require__(2862);

module.exports = function setDottedPath(obj, path, val) {
  if (path.indexOf('.') === -1) {
    if (specialProperties.has(path)) {
      return;
    }

    obj[path] = val;
    return;
  }

  var parts = path.split('.');
  var last = parts.pop();
  var cur = obj;

  var _iterator = _createForOfIteratorHelper(parts),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var part = _step.value;

      if (specialProperties.has(part)) {
        continue;
      }

      if (cur[part] == null) {
        cur[part] = {};
      }

      cur = cur[part];
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  if (!specialProperties.has(last)) {
    cur[last] = val;
  }
};

/***/ }),

/***/ 5837:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var utils = __webpack_require__(6872);
/*!
 * If populating a path within a document array, make sure each
 * subdoc within the array knows its subpaths are populated.
 *
 * #### Example:
 *     const doc = await Article.findOne().populate('comments.author');
 *     doc.comments[0].populated('author'); // Should be set
 */


module.exports = function markArraySubdocsPopulated(doc, populated) {
  if (doc._id == null || populated == null || populated.length === 0) {
    return;
  }

  var id = String(doc._id);

  var _iterator = _createForOfIteratorHelper(populated),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var item = _step.value;

      if (item.isVirtual) {
        continue;
      }

      var path = item.path;
      var pieces = path.split('.');

      for (var i = 0; i < pieces.length - 1; ++i) {
        var subpath = pieces.slice(0, i + 1).join('.');
        var rest = pieces.slice(i + 1).join('.');
        var val = doc.get(subpath);

        if (val == null) {
          continue;
        }

        if (utils.isMongooseDocumentArray(val)) {
          for (var j = 0; j < val.length; ++j) {
            val[j].populated(rest, item._docs[id] == null ? void 0 : item._docs[id][j], item);
          }

          break;
        }
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
};

/***/ }),

/***/ 6870:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var MongooseError = __webpack_require__(5202);

var util = __webpack_require__(161);

module.exports = validateRef;

function validateRef(ref, path) {
  if (typeof ref === 'string') {
    return;
  }

  if (typeof ref === 'function') {
    return;
  }

  throw new MongooseError('Invalid ref at path "' + path + '". Got ' + util.inspect(ref, {
    depth: 0
  }));
}

/***/ }),

/***/ 7427:
/***/ ((module) => {

"use strict";

/*!
 * Creates an object that precomputes whether a given path has child fields in
 * the projection.
 *
 * #### Example:
 *     const res = hasIncludedChildren({ 'a.b.c': 0 });
 *     res.a; // 1
 *     res['a.b']; // 1
 *     res['a.b.c']; // 1
 *     res['a.c']; // undefined
 */

module.exports = function hasIncludedChildren(fields) {
  var hasIncludedChildren = {};
  var keys = Object.keys(fields);

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];

    if (key.indexOf('.') === -1) {
      hasIncludedChildren[key] = 1;
      continue;
    }

    var parts = key.split('.');
    var c = parts[0];

    for (var i = 0; i < parts.length; ++i) {
      hasIncludedChildren[c] = 1;

      if (i + 1 < parts.length) {
        c = c + '.' + parts[i + 1];
      }
    }
  }

  return hasIncludedChildren;
};

/***/ }),

/***/ 2183:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

module.exports = function isDefiningProjection(val) {
  if (val == null) {
    // `undefined` or `null` become exclusive projections
    return true;
  }

  if (_typeof(val) === 'object') {
    // Only cases where a value does **not** define whether the whole projection
    // is inclusive or exclusive are `$meta` and `$slice`.
    return !('$meta' in val) && !('$slice' in val);
  }

  return true;
};

/***/ }),

/***/ 9098:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var isDefiningProjection = __webpack_require__(2183);
/*!
 * ignore
 */


module.exports = function isExclusive(projection) {
  if (projection == null) {
    return null;
  }

  var keys = Object.keys(projection);
  var ki = keys.length;
  var exclude = null;

  if (ki === 1 && keys[0] === '_id') {
    exclude = !projection._id;
  } else {
    while (ki--) {
      // Does this projection explicitly define inclusion/exclusion?
      // Explicitly avoid `$meta` and `$slice`
      var key = keys[ki];

      if (key !== '_id' && isDefiningProjection(projection[key])) {
        exclude = projection[key] != null && _typeof(projection[key]) === 'object' ? isExclusive(projection[key]) : !projection[key];
        break;
      }
    }
  }

  return exclude;
};

/***/ }),

/***/ 8486:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var PromiseProvider = __webpack_require__(6755);

var immediate = __webpack_require__(1490);

var emittedSymbol = Symbol('mongoose:emitted');

module.exports = function promiseOrCallback(callback, fn, ee, Promise) {
  if (typeof callback === 'function') {
    return fn(function (error) {
      if (error != null) {
        if (ee != null && ee.listeners != null && ee.listeners('error').length > 0 && !error[emittedSymbol]) {
          error[emittedSymbol] = true;
          ee.emit('error', error);
        }

        try {
          callback(error);
        } catch (error) {
          return immediate(function () {
            throw error;
          });
        }

        return;
      }

      callback.apply(this, arguments);
    });
  }

  Promise = Promise || PromiseProvider.get();
  return new Promise(function (resolve, reject) {
    fn(function (error, res) {
      if (error != null) {
        if (ee != null && ee.listeners != null && ee.listeners('error').length > 0 && !error[emittedSymbol]) {
          error[emittedSymbol] = true;
          ee.emit('error', error);
        }

        return reject(error);
      }

      if (arguments.length > 2) {
        return resolve(Array.prototype.slice.call(arguments, 1));
      }

      resolve(res);
    });
  });
};

/***/ }),

/***/ 5130:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * ignore
 */

module.exports = applyQueryMiddleware;

var validOps = __webpack_require__(9853);
/*!
 * ignore
 */


applyQueryMiddleware.middlewareFunctions = validOps.concat(['validate']);
/*!
 * Apply query middleware
 *
 * @param {Query} query constructor
 * @param {Model} model
 */

function applyQueryMiddleware(Query, model) {
  var kareemOptions = {
    useErrorHandlers: true,
    numCallbackParams: 1,
    nullResultByDefault: true
  };
  var middleware = model.hooks.filter(function (hook) {
    var contexts = _getContexts(hook);

    if (hook.name === 'updateOne') {
      return contexts.query == null || !!contexts.query;
    }

    if (hook.name === 'deleteOne') {
      return !!contexts.query || Object.keys(contexts).length === 0;
    }

    if (hook.name === 'validate' || hook.name === 'remove') {
      return !!contexts.query;
    }

    if (hook.query != null || hook.document != null) {
      return !!hook.query;
    }

    return true;
  }); // `update()` thunk has a different name because `_update` was already taken

  Query.prototype._execUpdate = middleware.createWrapper('update', Query.prototype._execUpdate, null, kareemOptions); // `distinct()` thunk has a different name because `_distinct` was already taken

  Query.prototype.__distinct = middleware.createWrapper('distinct', Query.prototype.__distinct, null, kareemOptions); // `validate()` doesn't have a thunk because it doesn't execute a query.

  Query.prototype.validate = middleware.createWrapper('validate', Query.prototype.validate, null, kareemOptions);
  applyQueryMiddleware.middlewareFunctions.filter(function (v) {
    return v !== 'update' && v !== 'distinct' && v !== 'validate';
  }).forEach(function (fn) {
    Query.prototype["_".concat(fn)] = middleware.createWrapper(fn, Query.prototype["_".concat(fn)], null, kareemOptions);
  });
}

function _getContexts(hook) {
  var ret = {};

  if (hook.hasOwnProperty('query')) {
    ret.query = hook.query;
  }

  if (hook.hasOwnProperty('document')) {
    ret.document = hook.document;
  }

  return ret;
}

/***/ }),

/***/ 9739:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var CastError = __webpack_require__(1795);

var StrictModeError = __webpack_require__(3328);

var castNumber = __webpack_require__(3065);

var booleanComparison = new Set(['$and', '$or']);
var comparisonOperator = new Set(['$cmp', '$eq', '$lt', '$lte', '$gt', '$gte']);
var arithmeticOperatorArray = new Set([// avoid casting '$add' or '$subtract', because expressions can be either number or date,
// and we don't have a good way of inferring which arguments should be numbers and which should
// be dates.
'$multiply', '$divide', '$log', '$mod', '$trunc', '$avg', '$max', '$min', '$stdDevPop', '$stdDevSamp', '$sum']);
var arithmeticOperatorNumber = new Set(['$abs', '$exp', '$ceil', '$floor', '$ln', '$log10', '$round', '$sqrt', '$sin', '$cos', '$tan', '$asin', '$acos', '$atan', '$atan2', '$asinh', '$acosh', '$atanh', '$sinh', '$cosh', '$tanh', '$degreesToRadians', '$radiansToDegrees']);
var arrayElementOperators = new Set(['$arrayElemAt', '$first', '$last']);
var dateOperators = new Set(['$year', '$month', '$week', '$dayOfMonth', '$dayOfYear', '$hour', '$minute', '$second', '$isoDayOfWeek', '$isoWeekYear', '$isoWeek', '$millisecond']);
var expressionOperator = new Set(['$not']);

module.exports = function cast$expr(val, schema, strictQuery) {
  if (_typeof(val) !== 'object' || val === null) {
    throw new Error('`$expr` must be an object');
  }

  return _castExpression(val, schema, strictQuery);
};

function _castExpression(val, schema, strictQuery) {
  if (isPath(val)) {
    // Assume path
    return val;
  }

  if (val.$cond != null) {
    if (Array.isArray(val.$cond)) {
      val.$cond = val.$cond.map(function (expr) {
        return _castExpression(expr, schema, strictQuery);
      });
    } else {
      val.$cond["if"] = _castExpression(val.$cond["if"], schema, strictQuery);
      val.$cond.then = _castExpression(val.$cond.then, schema, strictQuery);
      val.$cond["else"] = _castExpression(val.$cond["else"], schema, strictQuery);
    }
  } else if (val.$ifNull != null) {
    val.$ifNull.map(function (v) {
      return _castExpression(v, schema, strictQuery);
    });
  } else if (val.$switch != null) {
    val.branches.map(function (v) {
      return _castExpression(v, schema, strictQuery);
    });
    val["default"] = _castExpression(val["default"], schema, strictQuery);
  }

  var keys = Object.keys(val);

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];

    if (booleanComparison.has(key)) {
      val[key] = val[key].map(function (v) {
        return _castExpression(v, schema, strictQuery);
      });
    } else if (comparisonOperator.has(key)) {
      val[key] = castComparison(val[key], schema, strictQuery);
    } else if (arithmeticOperatorArray.has(key)) {
      val[key] = castArithmetic(val[key], schema, strictQuery);
    } else if (arithmeticOperatorNumber.has(key)) {
      val[key] = castNumberOperator(val[key], schema, strictQuery);
    } else if (expressionOperator.has(key)) {
      val[key] = _castExpression(val[key], schema, strictQuery);
    }
  }

  if (val.$in) {
    val.$in = castIn(val.$in, schema, strictQuery);
  }

  if (val.$size) {
    val.$size = castNumberOperator(val.$size, schema, strictQuery);
  }

  _omitUndefined(val);

  return val;
}

function _omitUndefined(val) {
  var keys = Object.keys(val);

  for (var i = 0, len = keys.length; i < len; ++i) {
    val[keys[i]] === void 0 && delete val[keys[i]];
  }
} // { $op: <number> }


function castNumberOperator(val) {
  if (!isLiteral(val)) {
    return val;
  }

  try {
    return castNumber(val);
  } catch (err) {
    throw new CastError('Number', val);
  }
}

function castIn(val, schema, strictQuery) {
  var path = val[1];

  if (!isPath(path)) {
    return val;
  }

  var search = val[0];
  var schematype = schema.path(path.slice(1));

  if (schematype === null) {
    if (strictQuery === false) {
      return val;
    } else if (strictQuery === 'throw') {
      throw new StrictModeError('$in');
    }

    return void 0;
  }

  if (!schematype.$isMongooseArray) {
    throw new Error('Path must be an array for $in');
  }

  return [schematype.$isMongooseDocumentArray ? schematype.$embeddedSchemaType.cast(search) : schematype.caster.cast(search), path];
} // { $op: [<number>, <number>] }


function castArithmetic(val) {
  if (!Array.isArray(val)) {
    if (!isLiteral(val)) {
      return val;
    }

    try {
      return castNumber(val);
    } catch (err) {
      throw new CastError('Number', val);
    }
  }

  return val.map(function (v) {
    if (!isLiteral(v)) {
      return v;
    }

    try {
      return castNumber(v);
    } catch (err) {
      throw new CastError('Number', v);
    }
  });
} // { $op: [expression, expression] }


function castComparison(val, schema, strictQuery) {
  if (!Array.isArray(val) || val.length !== 2) {
    throw new Error('Comparison operator must be an array of length 2');
  }

  val[0] = _castExpression(val[0], schema, strictQuery);
  var lhs = val[0];

  if (isLiteral(val[1])) {
    var path = null;
    var schematype = null;
    var caster = null;

    if (isPath(lhs)) {
      path = lhs.slice(1);
      schematype = schema.path(path);
    } else if (_typeof(lhs) === 'object' && lhs != null) {
      for (var _i2 = 0, _Object$keys = Object.keys(lhs); _i2 < _Object$keys.length; _i2++) {
        var key = _Object$keys[_i2];

        if (dateOperators.has(key) && isPath(lhs[key])) {
          path = lhs[key].slice(1) + '.' + key;
          caster = castNumber;
        } else if (arrayElementOperators.has(key) && isPath(lhs[key])) {
          path = lhs[key].slice(1) + '.' + key;
          schematype = schema.path(lhs[key].slice(1));

          if (schematype != null) {
            if (schematype.$isMongooseDocumentArray) {
              schematype = schematype.$embeddedSchemaType;
            } else if (schematype.$isMongooseArray) {
              schematype = schematype.caster;
            }
          }
        }
      }
    }

    var is$literal = _typeof(val[1]) === 'object' && val[1] != null && val[1].$literal != null;

    if (schematype != null) {
      if (is$literal) {
        val[1] = {
          $literal: schematype.cast(val[1].$literal)
        };
      } else {
        val[1] = schematype.cast(val[1]);
      }
    } else if (caster != null) {
      if (is$literal) {
        try {
          val[1] = {
            $literal: caster(val[1].$literal)
          };
        } catch (err) {
          throw new CastError(caster.name.replace(/^cast/, ''), val[1], path + '.$literal');
        }
      } else {
        try {
          val[1] = caster(val[1]);
        } catch (err) {
          throw new CastError(caster.name.replace(/^cast/, ''), val[1], path);
        }
      }
    } else if (path != null && strictQuery === true) {
      return void 0;
    } else if (path != null && strictQuery === 'throw') {
      throw new StrictModeError(path);
    }
  } else {
    val[1] = _castExpression(val[1]);
  }

  return val;
}

function isPath(val) {
  return typeof val === 'string' && val[0] === '$';
}

function isLiteral(val) {
  if (typeof val === 'string' && val[0] === '$') {
    return false;
  }

  if (_typeof(val) === 'object' && val !== null && Object.keys(val).find(function (key) {
    return key[0] === '$';
  })) {
    // The `$literal` expression can make an object a literal
    // https://docs.mongodb.com/manual/reference/operator/aggregation/literal/#mongodb-expression-exp.-literal
    return val.$literal != null;
  }

  return true;
}

/***/ }),

/***/ 9627:
/***/ ((module) => {

"use strict";


var specialKeys = new Set(['$ref', '$id', '$db']);

module.exports = function isOperator(path) {
  return path[0] === '$' && !specialKeys.has(path);
};

/***/ }),

/***/ 3636:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var trustedSymbol = Symbol('mongoose#trustedSymbol');
exports.trustedSymbol = trustedSymbol;

exports.trusted = function trusted(obj) {
  if (obj == null || _typeof(obj) !== 'object') {
    return obj;
  }

  obj[trustedSymbol] = true;
  return obj;
};

/***/ }),

/***/ 9853:
/***/ ((module) => {

"use strict";


module.exports = Object.freeze([// Read
'count', 'countDocuments', 'distinct', 'estimatedDocumentCount', 'find', 'findOne', // Update
'findOneAndReplace', 'findOneAndUpdate', 'replaceOne', 'update', 'updateMany', 'updateOne', // Delete
'deleteMany', 'deleteOne', 'findOneAndDelete', 'findOneAndRemove', 'remove']);

/***/ }),

/***/ 4133:
/***/ ((module) => {

"use strict";


module.exports = function addAutoId(schema) {
  var _obj = {
    _id: {
      auto: true
    }
  };
  _obj._id[schema.options.typeKey] = 'ObjectId';
  schema.add(_obj);
};

/***/ }),

/***/ 7658:
/***/ ((module) => {

"use strict";

/**
 * For consistency's sake, we replace positional operator `$` and array filters
 * `$[]` and `$[foo]` with `0` when looking up schema paths.
 */

module.exports = function cleanPositionalOperators(path) {
  return path.replace(/\.\$(\[[^\]]*\])?(?=\.)/g, '.0').replace(/\.\$(\[[^\]]*\])?$/g, '.0');
};

/***/ }),

/***/ 5379:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var get = __webpack_require__(9981);

var helperIsObject = __webpack_require__(5721);

var decorateDiscriminatorIndexOptions = __webpack_require__(1605);
/*!
 * Gather all indexes defined in the schema, including single nested,
 * document arrays, and embedded discriminators.
 */


module.exports = function getIndexes(schema) {
  var indexes = [];
  var schemaStack = new WeakMap();
  var indexTypes = schema.constructor.indexTypes;
  var indexByName = new Map();
  collectIndexes(schema);
  return indexes;

  function collectIndexes(schema, prefix, baseSchema) {
    // Ignore infinitely nested schemas, if we've already seen this schema
    // along this path there must be a cycle
    if (schemaStack.has(schema)) {
      return;
    }

    schemaStack.set(schema, true);
    prefix = prefix || '';
    var keys = Object.keys(schema.paths);

    for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
      var key = _keys[_i];
      var path = schema.paths[key];

      if (baseSchema != null && baseSchema.paths[key]) {
        // If looking at an embedded discriminator schema, don't look at paths
        // that the
        continue;
      }

      if (path.$isMongooseDocumentArray || path.$isSingleNested) {
        if (get(path, 'options.excludeIndexes') !== true && get(path, 'schemaOptions.excludeIndexes') !== true && get(path, 'schema.options.excludeIndexes') !== true) {
          collectIndexes(path.schema, prefix + key + '.');
        }

        if (path.schema.discriminators != null) {
          var discriminators = path.schema.discriminators;
          var discriminatorKeys = Object.keys(discriminators);

          for (var _i2 = 0, _discriminatorKeys = discriminatorKeys; _i2 < _discriminatorKeys.length; _i2++) {
            var discriminatorKey = _discriminatorKeys[_i2];
            collectIndexes(discriminators[discriminatorKey], prefix + key + '.', path.schema);
          }
        } // Retained to minimize risk of backwards breaking changes due to
        // gh-6113


        if (path.$isMongooseDocumentArray) {
          continue;
        }
      }

      var index = path._index || path.caster && path.caster._index;

      if (index !== false && index !== null && index !== undefined) {
        var field = {};
        var isObject = helperIsObject(index);
        var options = isObject ? index : {};
        var type = typeof index === 'string' ? index : isObject ? index.type : false;

        if (type && indexTypes.indexOf(type) !== -1) {
          field[prefix + key] = type;
        } else if (options.text) {
          field[prefix + key] = 'text';
          delete options.text;
        } else {
          var isDescendingIndex = Number(index) === -1;
          field[prefix + key] = isDescendingIndex ? -1 : 1;
        }

        delete options.type;

        if (!('background' in options)) {
          options.background = true;
        }

        if (schema.options.autoIndex != null) {
          options._autoIndex = schema.options.autoIndex;
        }

        var indexName = options && options.name;

        if (typeof indexName === 'string') {
          if (indexByName.has(indexName)) {
            Object.assign(indexByName.get(indexName), field);
          } else {
            indexes.push([field, options]);
            indexByName.set(indexName, field);
          }
        } else {
          indexes.push([field, options]);
          indexByName.set(indexName, field);
        }
      }
    }

    schemaStack["delete"](schema);

    if (prefix) {
      fixSubIndexPaths(schema, prefix);
    } else {
      schema._indexes.forEach(function (index) {
        var options = index[1];

        if (!('background' in options)) {
          options.background = true;
        }

        decorateDiscriminatorIndexOptions(schema, options);
      });

      indexes = indexes.concat(schema._indexes);
    }
  }
  /*!
   * Checks for indexes added to subdocs using Schema.index().
   * These indexes need their paths prefixed properly.
   *
   * schema._indexes = [ [indexObj, options], [indexObj, options] ..]
   */


  function fixSubIndexPaths(schema, prefix) {
    var subindexes = schema._indexes;
    var len = subindexes.length;

    for (var i = 0; i < len; ++i) {
      var indexObj = subindexes[i][0];
      var indexOptions = subindexes[i][1];
      var keys = Object.keys(indexObj);
      var klen = keys.length;
      var newindex = {}; // use forward iteration, order matters

      for (var j = 0; j < klen; ++j) {
        var key = keys[j];
        newindex[prefix + key] = indexObj[key];
      }

      var newIndexOptions = Object.assign({}, indexOptions);

      if (indexOptions != null && indexOptions.partialFilterExpression != null) {
        newIndexOptions.partialFilterExpression = {};
        var partialFilterExpression = indexOptions.partialFilterExpression;

        for (var _i3 = 0, _Object$keys = Object.keys(partialFilterExpression); _i3 < _Object$keys.length; _i3++) {
          var _key = _Object$keys[_i3];
          newIndexOptions.partialFilterExpression[prefix + _key] = partialFilterExpression[_key];
        }
      }

      indexes.push([newindex, newIndexOptions]);
    }
  }
};

/***/ }),

/***/ 37:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var get = __webpack_require__(9981);

module.exports = function getKeysInSchemaOrder(schema, val, path) {
  var schemaKeys = path != null ? Object.keys(get(schema.tree, path, {})) : Object.keys(schema.tree);
  var valKeys = new Set(Object.keys(val));
  var keys;

  if (valKeys.size > 1) {
    keys = new Set();

    var _iterator = _createForOfIteratorHelper(schemaKeys),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var key = _step.value;

        if (valKeys.has(key)) {
          keys.add(key);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var _iterator2 = _createForOfIteratorHelper(valKeys),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var _key = _step2.value;

        if (!keys.has(_key)) {
          keys.add(_key);
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    keys = Array.from(keys);
  } else {
    keys = Array.from(valKeys);
  }

  return keys;
};

/***/ }),

/***/ 9691:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var addAutoId = __webpack_require__(4133);

module.exports = function handleIdOption(schema, options) {
  if (options == null || options._id == null) {
    return schema;
  }

  schema = schema.clone();

  if (!options._id) {
    schema.remove('_id');
    schema.options._id = false;
  } else if (!schema.paths['_id']) {
    addAutoId(schema);
    schema.options._id = true;
  }

  return schema;
};

/***/ }),

/***/ 6370:
/***/ ((module) => {

"use strict";


module.exports = handleTimestampOption;
/*!
 * ignore
 */

function handleTimestampOption(arg, prop) {
  if (arg == null) {
    return null;
  }

  if (typeof arg === 'boolean') {
    return prop;
  }

  if (typeof arg[prop] === 'boolean') {
    return arg[prop] ? prop : null;
  }

  if (!(prop in arg)) {
    return prop;
  }

  return arg[prop];
}

/***/ }),

/***/ 1879:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

module.exports = function addIdGetter(schema) {
  // ensure the documents receive an id getter unless disabled
  var autoIdGetter = !schema.paths['id'] && schema.paths['_id'] && schema.options.id;

  if (!autoIdGetter) {
    return schema;
  }

  schema.virtual('id').get(idGetter);
  return schema;
};
/*!
 * Returns this documents _id cast to a string.
 */


function idGetter() {
  if (this._id != null) {
    return String(this._id);
  }

  return null;
}

/***/ }),

/***/ 4913:
/***/ ((module) => {

"use strict";


module.exports = function merge(s1, s2, skipConflictingPaths) {
  var paths = Object.keys(s2.tree);
  var pathsToAdd = {};

  for (var _i = 0, _paths = paths; _i < _paths.length; _i++) {
    var key = _paths[_i];

    if (skipConflictingPaths && (s1.paths[key] || s1.nested[key] || s1.singleNestedPaths[key])) {
      continue;
    }

    pathsToAdd[key] = s2.tree[key];
  }

  s1.add(pathsToAdd);
  s1.callQueue = s1.callQueue.concat(s2.callQueue);
  s1.method(s2.methods);
  s1["static"](s2.statics);

  for (var query in s2.query) {
    s1.query[query] = s2.query[query];
  }

  for (var virtual in s2.virtuals) {
    s1.virtuals[virtual] = s2.virtuals[virtual].clone();
  }

  s1.s.hooks.merge(s2.s.hooks, false);
};

/***/ }),

/***/ 8828:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var StrictModeError = __webpack_require__(3328);
/*!
 * ignore
 */


module.exports = function (schematype) {
  if (schematype.$immutable) {
    schematype.$immutableSetter = createImmutableSetter(schematype.path, schematype.options.immutable);
    schematype.set(schematype.$immutableSetter);
  } else if (schematype.$immutableSetter) {
    schematype.setters = schematype.setters.filter(function (fn) {
      return fn !== schematype.$immutableSetter;
    });
    delete schematype.$immutableSetter;
  }
};

function createImmutableSetter(path, immutable) {
  return function immutableSetter(v, _priorVal, _doc, options) {
    if (this == null || this.$__ == null) {
      return v;
    }

    if (this.isNew) {
      return v;
    }

    if (options && options.overwriteImmutable) {
      return v;
    }

    var _immutable = typeof immutable === 'function' ? immutable.call(this, this) : immutable;

    if (!_immutable) {
      return v;
    }

    var _value = this.$__.priorDoc != null ? this.$__.priorDoc.$__getValue(path) : this.$__getValue(path);

    if (this.$__.strictMode === 'throw' && v !== _value) {
      throw new StrictModeError(path, 'Path `' + path + '` is immutable ' + 'and strict mode is set to throw.', true);
    }

    return _value;
  };
}

/***/ }),

/***/ 2862:
/***/ ((module) => {

"use strict";


module.exports = new Set(['__proto__', 'constructor', 'prototype']);

/***/ }),

/***/ 8770:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.arrayAtomicsBackupSymbol = Symbol('mongoose#Array#atomicsBackup');
exports.arrayAtomicsSymbol = Symbol('mongoose#Array#_atomics');
exports.arrayParentSymbol = Symbol('mongoose#Array#_parent');
exports.arrayPathSymbol = Symbol('mongoose#Array#_path');
exports.arraySchemaSymbol = Symbol('mongoose#Array#_schema');
exports.documentArrayParent = Symbol('mongoose:documentArrayParent');
exports.documentIsSelected = Symbol('mongoose#Document#isSelected');
exports.documentIsModified = Symbol('mongoose#Document#isModified');
exports.documentModifiedPaths = Symbol('mongoose#Document#modifiedPaths');
exports.documentSchemaSymbol = Symbol('mongoose#Document#schema');
exports.getSymbol = Symbol('mongoose#Document#get');
exports.modelSymbol = Symbol('mongoose#Model');
exports.objectIdSymbol = Symbol('mongoose#ObjectId');
exports.populateModelSymbol = Symbol('mongoose.PopulateOptions#Model');
exports.schemaTypeSymbol = Symbol('mongoose#schemaType');
exports.sessionNewDocuments = Symbol('mongoose:ClientSession#newDocuments');
exports.scopeSymbol = Symbol('mongoose#Document#scope');
exports.validatorErrorSymbol = Symbol('mongoose:validatorError');

/***/ }),

/***/ 3767:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var applyTimestampsToChildren = __webpack_require__(4843);

var applyTimestampsToUpdate = __webpack_require__(6434);

var get = __webpack_require__(9981);

var handleTimestampOption = __webpack_require__(6370);

var symbols = __webpack_require__(8107);

module.exports = function setupTimestamps(schema, timestamps) {
  var childHasTimestamp = schema.childSchemas.find(withTimestamp);

  function withTimestamp(s) {
    var ts = s.schema.options.timestamps;
    return !!ts;
  }

  if (!timestamps && !childHasTimestamp) {
    return;
  }

  var createdAt = handleTimestampOption(timestamps, 'createdAt');
  var updatedAt = handleTimestampOption(timestamps, 'updatedAt');
  var currentTime = timestamps != null && timestamps.hasOwnProperty('currentTime') ? timestamps.currentTime : null;
  var schemaAdditions = {};
  schema.$timestamps = {
    createdAt: createdAt,
    updatedAt: updatedAt
  };

  if (updatedAt && !schema.paths[updatedAt]) {
    schemaAdditions[updatedAt] = Date;
  }

  if (createdAt && !schema.paths[createdAt]) {
    var _schemaAdditions$crea;

    var baseImmutableCreatedAt = schema.base.get('timestamps.createdAt.immutable');
    var immutable = baseImmutableCreatedAt != null ? baseImmutableCreatedAt : true;
    schemaAdditions[createdAt] = (_schemaAdditions$crea = {}, _defineProperty(_schemaAdditions$crea, schema.options.typeKey || 'type', Date), _defineProperty(_schemaAdditions$crea, "immutable", immutable), _schemaAdditions$crea);
  }

  schema.add(schemaAdditions);
  schema.pre('save', function (next) {
    var timestampOption = get(this, '$__.saveOptions.timestamps');

    if (timestampOption === false) {
      return next();
    }

    var skipUpdatedAt = timestampOption != null && timestampOption.updatedAt === false;
    var skipCreatedAt = timestampOption != null && timestampOption.createdAt === false;
    var defaultTimestamp = currentTime != null ? currentTime() : this.ownerDocument().constructor.base.now();

    if (!skipCreatedAt && (this.isNew || this.$isSubdocument) && createdAt && !this.$__getValue(createdAt) && this.$__isSelected(createdAt)) {
      this.$set(createdAt, defaultTimestamp, undefined, {
        overwriteImmutable: true
      });
    }

    if (!skipUpdatedAt && updatedAt && (this.isNew || this.$isModified())) {
      var ts = defaultTimestamp;

      if (this.isNew && createdAt != null) {
        ts = this.$__getValue(createdAt);
      }

      this.$set(updatedAt, ts);
    }

    next();
  });

  schema.methods.initializeTimestamps = function () {
    var ts = currentTime != null ? currentTime() : this.constructor.base.now();

    if (createdAt && !this.get(createdAt)) {
      this.$set(createdAt, ts);
    }

    if (updatedAt && !this.get(updatedAt)) {
      this.$set(updatedAt, ts);
    }

    return this;
  };

  _setTimestampsOnUpdate[symbols.builtInMiddleware] = true;
  var opts = {
    query: true,
    model: false
  };
  schema.pre('findOneAndReplace', opts, _setTimestampsOnUpdate);
  schema.pre('findOneAndUpdate', opts, _setTimestampsOnUpdate);
  schema.pre('replaceOne', opts, _setTimestampsOnUpdate);
  schema.pre('update', opts, _setTimestampsOnUpdate);
  schema.pre('updateOne', opts, _setTimestampsOnUpdate);
  schema.pre('updateMany', opts, _setTimestampsOnUpdate);

  function _setTimestampsOnUpdate(next) {
    var now = currentTime != null ? currentTime() : this.model.base.now(); // Replacing with null update should still trigger timestamps

    if (this.op === 'findOneAndReplace' && this.getUpdate() == null) {
      this.setUpdate({});
    }

    applyTimestampsToUpdate(now, createdAt, updatedAt, this.getUpdate(), this.options, this.schema);
    applyTimestampsToChildren(now, this.getUpdate(), this.model.schema);
    next();
  }
};

/***/ }),

/***/ 5285:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getConstructorName = __webpack_require__(1981);

module.exports = function allServersUnknown(topologyDescription) {
  if (getConstructorName(topologyDescription) !== 'TopologyDescription') {
    return false;
  }

  var servers = Array.from(topologyDescription.servers.values());
  return servers.length > 0 && servers.every(function (server) {
    return server.type === 'Unknown';
  });
};

/***/ }),

/***/ 2082:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getConstructorName = __webpack_require__(1981);

module.exports = function isAtlas(topologyDescription) {
  if (getConstructorName(topologyDescription) !== 'TopologyDescription') {
    return false;
  }

  var hostnames = Array.from(topologyDescription.servers.keys());

  if (hostnames.length === 0) {
    return false;
  }

  for (var i = 0, il = hostnames.length; i < il; ++i) {
    var url = new URL(hostnames[i]);

    if (url.hostname.endsWith('.mongodb.net') === false || url.port !== '27017') {
      return false;
    }
  }

  return true;
};

/***/ }),

/***/ 3871:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getConstructorName = __webpack_require__(1981);

var nonSSLMessage = 'Client network socket disconnected before secure TLS ' + 'connection was established';

module.exports = function isSSLError(topologyDescription) {
  if (getConstructorName(topologyDescription) !== 'TopologyDescription') {
    return false;
  }

  var descriptions = Array.from(topologyDescription.servers.values());
  return descriptions.length > 0 && descriptions.every(function (descr) {
    return descr.error && descr.error.message.indexOf(nonSSLMessage) !== -1;
  });
};

/***/ }),

/***/ 4843:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var cleanPositionalOperators = __webpack_require__(7658);

var handleTimestampOption = __webpack_require__(6370);

module.exports = applyTimestampsToChildren;
/*!
 * ignore
 */

function applyTimestampsToChildren(now, update, schema) {
  if (update == null) {
    return;
  }

  var keys = Object.keys(update);
  var hasDollarKey = keys.some(function (key) {
    return key[0] === '$';
  });

  if (hasDollarKey) {
    if (update.$push) {
      _applyTimestampToUpdateOperator(update.$push);
    }

    if (update.$addToSet) {
      _applyTimestampToUpdateOperator(update.$addToSet);
    }

    if (update.$set != null) {
      var _keys = Object.keys(update.$set);

      for (var _i = 0, _keys2 = _keys; _i < _keys2.length; _i++) {
        var key = _keys2[_i];
        applyTimestampsToUpdateKey(schema, key, update.$set, now);
      }
    }

    if (update.$setOnInsert != null) {
      var _keys3 = Object.keys(update.$setOnInsert);

      for (var _i2 = 0, _keys4 = _keys3; _i2 < _keys4.length; _i2++) {
        var _key = _keys4[_i2];
        applyTimestampsToUpdateKey(schema, _key, update.$setOnInsert, now);
      }
    }
  }

  var updateKeys = Object.keys(update).filter(function (key) {
    return key[0] !== '$';
  });

  var _iterator = _createForOfIteratorHelper(updateKeys),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _key2 = _step.value;
      applyTimestampsToUpdateKey(schema, _key2, update, now);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  function _applyTimestampToUpdateOperator(op) {
    var _loop = function _loop() {
      var key = _Object$keys[_i3];
      var $path = schema.path(key.replace(/\.\$\./i, '.').replace(/.\$$/, ''));

      if (op[key] && $path && $path.$isMongooseDocumentArray && $path.schema.options.timestamps) {
        var timestamps = $path.schema.options.timestamps;
        var createdAt = handleTimestampOption(timestamps, 'createdAt');
        var updatedAt = handleTimestampOption(timestamps, 'updatedAt');

        if (op[key].$each) {
          op[key].$each.forEach(function (subdoc) {
            if (updatedAt != null) {
              subdoc[updatedAt] = now;
            }

            if (createdAt != null) {
              subdoc[createdAt] = now;
            }

            applyTimestampsToChildren(now, subdoc, $path.schema);
          });
        } else {
          if (updatedAt != null) {
            op[key][updatedAt] = now;
          }

          if (createdAt != null) {
            op[key][createdAt] = now;
          }

          applyTimestampsToChildren(now, op[key], $path.schema);
        }
      }
    };

    for (var _i3 = 0, _Object$keys = Object.keys(op); _i3 < _Object$keys.length; _i3++) {
      _loop();
    }
  }
}

function applyTimestampsToDocumentArray(arr, schematype, now) {
  var timestamps = schematype.schema.options.timestamps;

  if (!timestamps) {
    return;
  }

  var len = arr.length;
  var createdAt = handleTimestampOption(timestamps, 'createdAt');
  var updatedAt = handleTimestampOption(timestamps, 'updatedAt');

  for (var i = 0; i < len; ++i) {
    if (updatedAt != null) {
      arr[i][updatedAt] = now;
    }

    if (createdAt != null) {
      arr[i][createdAt] = now;
    }

    applyTimestampsToChildren(now, arr[i], schematype.schema);
  }
}

function applyTimestampsToSingleNested(subdoc, schematype, now) {
  var timestamps = schematype.schema.options.timestamps;

  if (!timestamps) {
    return;
  }

  var createdAt = handleTimestampOption(timestamps, 'createdAt');
  var updatedAt = handleTimestampOption(timestamps, 'updatedAt');

  if (updatedAt != null) {
    subdoc[updatedAt] = now;
  }

  if (createdAt != null) {
    subdoc[createdAt] = now;
  }

  applyTimestampsToChildren(now, subdoc, schematype.schema);
}

function applyTimestampsToUpdateKey(schema, key, update, now) {
  // Replace positional operator `$` and array filters `$[]` and `$[.*]`
  var keyToSearch = cleanPositionalOperators(key);
  var path = schema.path(keyToSearch);

  if (!path) {
    return;
  }

  var parentSchemaTypes = [];
  var pieces = keyToSearch.split('.');

  for (var i = pieces.length - 1; i > 0; --i) {
    var s = schema.path(pieces.slice(0, i).join('.'));

    if (s != null && (s.$isMongooseDocumentArray || s.$isSingleNested)) {
      parentSchemaTypes.push({
        parentPath: key.split('.').slice(0, i).join('.'),
        parentSchemaType: s
      });
    }
  }

  if (Array.isArray(update[key]) && path.$isMongooseDocumentArray) {
    applyTimestampsToDocumentArray(update[key], path, now);
  } else if (update[key] && path.$isSingleNested) {
    applyTimestampsToSingleNested(update[key], path, now);
  } else if (parentSchemaTypes.length > 0) {
    var _iterator2 = _createForOfIteratorHelper(parentSchemaTypes),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var item = _step2.value;
        var parentPath = item.parentPath;
        var parentSchemaType = item.parentSchemaType;
        var timestamps = parentSchemaType.schema.options.timestamps;
        var updatedAt = handleTimestampOption(timestamps, 'updatedAt');

        if (!timestamps || updatedAt == null) {
          continue;
        }

        if (parentSchemaType.$isSingleNested) {
          // Single nested is easy
          update[parentPath + '.' + updatedAt] = now;
        } else if (parentSchemaType.$isMongooseDocumentArray) {
          var childPath = key.substring(parentPath.length + 1);

          if (/^\d+$/.test(childPath)) {
            update[parentPath + '.' + childPath][updatedAt] = now;
            continue;
          }

          var firstDot = childPath.indexOf('.');
          childPath = firstDot !== -1 ? childPath.substring(0, firstDot) : childPath;
          update[parentPath + '.' + childPath + '.' + updatedAt] = now;
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  } else if (path.schema != null && path.schema != schema && update[key]) {
    var _timestamps = path.schema.options.timestamps;
    var createdAt = handleTimestampOption(_timestamps, 'createdAt');

    var _updatedAt = handleTimestampOption(_timestamps, 'updatedAt');

    if (!_timestamps) {
      return;
    }

    if (_updatedAt != null) {
      update[key][_updatedAt] = now;
    }

    if (createdAt != null) {
      update[key][createdAt] = now;
    }
  }
}

/***/ }),

/***/ 6434:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * ignore
 */

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var get = __webpack_require__(9981);

module.exports = applyTimestampsToUpdate;
/*!
 * ignore
 */

function applyTimestampsToUpdate(now, createdAt, updatedAt, currentUpdate, options) {
  var updates = currentUpdate;
  var _updates = updates;
  var overwrite = get(options, 'overwrite', false);
  var timestamps = get(options, 'timestamps', true); // Support skipping timestamps at the query level, see gh-6980

  if (!timestamps || updates == null) {
    return currentUpdate;
  }

  var skipCreatedAt = timestamps != null && timestamps.createdAt === false;
  var skipUpdatedAt = timestamps != null && timestamps.updatedAt === false;

  if (overwrite) {
    if (currentUpdate && currentUpdate.$set) {
      currentUpdate = currentUpdate.$set;
      updates.$set = {};
      _updates = updates.$set;
    }

    if (!skipUpdatedAt && updatedAt && !currentUpdate[updatedAt]) {
      _updates[updatedAt] = now;
    }

    if (!skipCreatedAt && createdAt && !currentUpdate[createdAt]) {
      _updates[createdAt] = now;
    }

    return updates;
  }

  currentUpdate = currentUpdate || {};

  if (Array.isArray(updates)) {
    // Update with aggregation pipeline
    updates.push({
      $set: _defineProperty({}, updatedAt, now)
    });
    return updates;
  }

  updates.$set = updates.$set || {};

  if (!skipUpdatedAt && updatedAt && (!currentUpdate.$currentDate || !currentUpdate.$currentDate[updatedAt])) {
    var timestampSet = false;

    if (updatedAt.indexOf('.') !== -1) {
      var pieces = updatedAt.split('.');

      for (var i = 1; i < pieces.length; ++i) {
        var remnant = pieces.slice(-i).join('.');
        var start = pieces.slice(0, -i).join('.');

        if (currentUpdate[start] != null) {
          currentUpdate[start][remnant] = now;
          timestampSet = true;
          break;
        } else if (currentUpdate.$set && currentUpdate.$set[start]) {
          currentUpdate.$set[start][remnant] = now;
          timestampSet = true;
          break;
        }
      }
    }

    if (!timestampSet) {
      updates.$set[updatedAt] = now;
    }

    if (updates.hasOwnProperty(updatedAt)) {
      delete updates[updatedAt];
    }
  }

  if (!skipCreatedAt && createdAt) {
    if (currentUpdate[createdAt]) {
      delete currentUpdate[createdAt];
    }

    if (currentUpdate.$set && currentUpdate.$set[createdAt]) {
      delete currentUpdate.$set[createdAt];
    }

    var _timestampSet = false;

    if (createdAt.indexOf('.') !== -1) {
      var _pieces = createdAt.split('.');

      for (var _i = 1; _i < _pieces.length; ++_i) {
        var _remnant = _pieces.slice(-_i).join('.');

        var _start = _pieces.slice(0, -_i).join('.');

        if (currentUpdate[_start] != null) {
          currentUpdate[_start][_remnant] = now;
          _timestampSet = true;
          break;
        } else if (currentUpdate.$set && currentUpdate.$set[_start]) {
          currentUpdate.$set[_start][_remnant] = now;
          _timestampSet = true;
          break;
        }
      }
    }

    if (!_timestampSet) {
      updates.$setOnInsert = updates.$setOnInsert || {};
      updates.$setOnInsert[createdAt] = now;
    }
  }

  if (Object.keys(updates.$set).length === 0) {
    delete updates.$set;
  }

  return updates;
}

/***/ }),

/***/ 6379:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * Dependencies
 */


var StateMachine = __webpack_require__(489);

var ActiveRoster = StateMachine.ctor('require', 'modify', 'init', 'default', 'ignore');
module.exports = exports = InternalCache;

function InternalCache() {
  this.activePaths = new ActiveRoster();
}

InternalCache.prototype.fullPath = undefined;
InternalCache.prototype.strictMode = undefined;
InternalCache.prototype.selected = undefined;
InternalCache.prototype.shardval = undefined;
InternalCache.prototype.saveError = undefined;
InternalCache.prototype.validationError = undefined;
InternalCache.prototype.adhocPaths = undefined;
InternalCache.prototype.removing = undefined;
InternalCache.prototype.inserting = undefined;
InternalCache.prototype.saving = undefined;
InternalCache.prototype.version = undefined;
InternalCache.prototype._id = undefined;
InternalCache.prototype.ownerDocument = undefined;
InternalCache.prototype.populate = undefined; // what we want to populate in this doc

InternalCache.prototype.populated = undefined; // the _ids that have been populated

/**
 * If `false`, this document was not the result of population.
 * If `true`, this document is a populated doc underneath another doc
 * If an object, this document is a populated doc and the `value` property of the
 * object contains the original depopulated value.
 */

InternalCache.prototype.wasPopulated = false;
InternalCache.prototype.scope = undefined;
InternalCache.prototype.session = null;
InternalCache.prototype.pathsToScopes = null;
InternalCache.prototype.cachedRequired = null;

/***/ }),

/***/ 4962:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * ignore
 */

exports.h = {
  transform: false,
  virtuals: false,
  getters: false,
  _skipDepopulateTopLevel: true,
  depopulate: true,
  flattenDecimals: false,
  useProjection: false
};

/***/ }),

/***/ 4034:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var clone = __webpack_require__(1973);

var PopulateOptions = /*#__PURE__*/_createClass(function PopulateOptions(obj) {
  _classCallCheck(this, PopulateOptions);

  this._docs = {};
  this._childDocs = [];

  if (obj == null) {
    return;
  }

  obj = clone(obj);
  Object.assign(this, obj);

  if (_typeof(obj.subPopulate) === 'object') {
    this.populate = obj.subPopulate;
  }

  if (obj.perDocumentLimit != null && obj.limit != null) {
    throw new Error('Can not use `limit` and `perDocumentLimit` at the same time. Path: `' + obj.path + '`.');
  }
});
/**
 * The connection used to look up models by name. If not specified, Mongoose
 * will default to using the connection associated with the model in
 * `PopulateOptions#model`.
 *
 * @memberOf PopulateOptions
 * @property {Connection} connection
 * @api public
 */


module.exports = PopulateOptions;

/***/ }),

/***/ 4756:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on an Array schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ tags: [String] });
 *     schema.path('tags').options; // SchemaArrayOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaArrayOptions
 */


var SchemaArrayOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaArrayOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaArrayOptions);

  function SchemaArrayOptions() {
    _classCallCheck(this, SchemaArrayOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaArrayOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If this is an array of strings, an array of allowed values for this path.
 * Throws an error if this array isn't an array of strings.
 *
 * @api public
 * @property enum
 * @memberOf SchemaArrayOptions
 * @type Array
 * @instance
 */


Object.defineProperty(SchemaArrayOptions.prototype, 'enum', opts);
/**
 * If set, specifies the type of this array's values. Equivalent to setting
 * `type` to an array whose first element is `of`.
 *
 * #### Example:
 *
 *     // `arr` is an array of numbers.
 *     new Schema({ arr: [Number] });
 *     // Equivalent way to define `arr` as an array of numbers
 *     new Schema({ arr: { type: Array, of: Number } });
 *
 * @api public
 * @property of
 * @memberOf SchemaArrayOptions
 * @type Function|String
 * @instance
 */

Object.defineProperty(SchemaArrayOptions.prototype, 'of', opts);
/*!
 * ignore
 */

module.exports = SchemaArrayOptions;

/***/ }),

/***/ 9586:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a Buffer schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ bitmap: Buffer });
 *     schema.path('bitmap').options; // SchemaBufferOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaBufferOptions
 */


var SchemaBufferOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaBufferOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaBufferOptions);

  function SchemaBufferOptions() {
    _classCallCheck(this, SchemaBufferOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaBufferOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * Set the default subtype for this buffer.
 *
 * @api public
 * @property subtype
 * @memberOf SchemaBufferOptions
 * @type Number
 * @instance
 */


Object.defineProperty(SchemaBufferOptions.prototype, 'subtype', opts);
/*!
 * ignore
 */

module.exports = SchemaBufferOptions;

/***/ }),

/***/ 2869:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a Date schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ startedAt: Date });
 *     schema.path('startedAt').options; // SchemaDateOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaDateOptions
 */


var SchemaDateOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaDateOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaDateOptions);

  function SchemaDateOptions() {
    _classCallCheck(this, SchemaDateOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaDateOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If set, Mongoose adds a validator that checks that this path is after the
 * given `min`.
 *
 * @api public
 * @property min
 * @memberOf SchemaDateOptions
 * @type Date
 * @instance
 */


Object.defineProperty(SchemaDateOptions.prototype, 'min', opts);
/**
 * If set, Mongoose adds a validator that checks that this path is before the
 * given `max`.
 *
 * @api public
 * @property max
 * @memberOf SchemaDateOptions
 * @type Date
 * @instance
 */

Object.defineProperty(SchemaDateOptions.prototype, 'max', opts);
/**
 * If set, Mongoose creates a TTL index on this path.
 *
 * mongo TTL index `expireAfterSeconds` value will take 'expires' value expressed in seconds.
 *
 * #### Example:
 *
 *     const schema = new Schema({ "expireAt": { type: Date,  expires: 11 } });
 *     // if 'expireAt' is set, then document expires at expireAt + 11 seconds
 *
 * @api public
 * @property expires
 * @memberOf SchemaDateOptions
 * @type Date
 * @instance
 */

Object.defineProperty(SchemaDateOptions.prototype, 'expires', opts);
/*!
 * ignore
 */

module.exports = SchemaDateOptions;

/***/ }),

/***/ 887:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on an Document Array schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ users: [{ name: string }] });
 *     schema.path('users').options; // SchemaDocumentArrayOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaDocumentOptions
 */


var SchemaDocumentArrayOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaDocumentArrayOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaDocumentArrayOptions);

  function SchemaDocumentArrayOptions() {
    _classCallCheck(this, SchemaDocumentArrayOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaDocumentArrayOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If `true`, Mongoose will skip building any indexes defined in this array's schema.
 * If not set, Mongoose will build all indexes defined in this array's schema.
 *
 * #### Example:
 *
 *     const childSchema = Schema({ name: { type: String, index: true } });
 *     // If `excludeIndexes` is `true`, Mongoose will skip building an index
 *     // on `arr.name`. Otherwise, Mongoose will build an index on `arr.name`.
 *     const parentSchema = Schema({
 *       arr: { type: [childSchema], excludeIndexes: true }
 *     });
 *
 * @api public
 * @property excludeIndexes
 * @memberOf SchemaDocumentArrayOptions
 * @type Array
 * @instance
 */


Object.defineProperty(SchemaDocumentArrayOptions.prototype, 'excludeIndexes', opts);
/**
 * If set, overwrites the child schema's `_id` option.
 *
 * #### Example:
 *
 *     const childSchema = Schema({ name: String });
 *     const parentSchema = Schema({
 *       child: { type: childSchema, _id: false }
 *     });
 *     parentSchema.path('child').schema.options._id; // false
 *
 * @api public
 * @property _id
 * @memberOf SchemaDocumentArrayOptions
 * @type Array
 * @instance
 */

Object.defineProperty(SchemaDocumentArrayOptions.prototype, '_id', opts);
/*!
 * ignore
 */

module.exports = SchemaDocumentArrayOptions;

/***/ }),

/***/ 8227:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a Map schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ socialMediaHandles: { type: Map, of: String } });
 *     schema.path('socialMediaHandles').options; // SchemaMapOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaMapOptions
 */


var SchemaMapOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaMapOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaMapOptions);

  function SchemaMapOptions() {
    _classCallCheck(this, SchemaMapOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaMapOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If set, specifies the type of this map's values. Mongoose will cast
 * this map's values to the given type.
 *
 * If not set, Mongoose will not cast the map's values.
 *
 * #### Example:
 *
 *     // Mongoose will cast `socialMediaHandles` values to strings
 *     const schema = new Schema({ socialMediaHandles: { type: Map, of: String } });
 *     schema.path('socialMediaHandles').options.of; // String
 *
 * @api public
 * @property of
 * @memberOf SchemaMapOptions
 * @type Function|string
 * @instance
 */


Object.defineProperty(SchemaMapOptions.prototype, 'of', opts);
module.exports = SchemaMapOptions;

/***/ }),

/***/ 8491:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a Number schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ count: Number });
 *     schema.path('count').options; // SchemaNumberOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaNumberOptions
 */


var SchemaNumberOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaNumberOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaNumberOptions);

  function SchemaNumberOptions() {
    _classCallCheck(this, SchemaNumberOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaNumberOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If set, Mongoose adds a validator that checks that this path is at least the
 * given `min`.
 *
 * @api public
 * @property min
 * @memberOf SchemaNumberOptions
 * @type Number
 * @instance
 */


Object.defineProperty(SchemaNumberOptions.prototype, 'min', opts);
/**
 * If set, Mongoose adds a validator that checks that this path is less than the
 * given `max`.
 *
 * @api public
 * @property max
 * @memberOf SchemaNumberOptions
 * @type Number
 * @instance
 */

Object.defineProperty(SchemaNumberOptions.prototype, 'max', opts);
/**
 * If set, Mongoose adds a validator that checks that this path is strictly
 * equal to one of the given values.
 *
 * #### Example:
 *     const schema = new Schema({
 *       favoritePrime: {
 *         type: Number,
 *         enum: [3, 5, 7]
 *       }
 *     });
 *     schema.path('favoritePrime').options.enum; // [3, 5, 7]
 *
 * @api public
 * @property enum
 * @memberOf SchemaNumberOptions
 * @type Array
 * @instance
 */

Object.defineProperty(SchemaNumberOptions.prototype, 'enum', opts);
/**
 * Sets default [populate options](/docs/populate.html#query-conditions).
 *
 * #### Example:
 *     const schema = new Schema({
 *       child: {
 *         type: Number,
 *         ref: 'Child',
 *         populate: { select: 'name' }
 *       }
 *     });
 *     const Parent = mongoose.model('Parent', schema);
 *
 *     // Automatically adds `.select('name')`
 *     Parent.findOne().populate('child');
 *
 * @api public
 * @property populate
 * @memberOf SchemaNumberOptions
 * @type Object
 * @instance
 */

Object.defineProperty(SchemaNumberOptions.prototype, 'populate', opts);
/*!
 * ignore
 */

module.exports = SchemaNumberOptions;

/***/ }),

/***/ 8172:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on an ObjectId schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ testId: mongoose.ObjectId });
 *     schema.path('testId').options; // SchemaObjectIdOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaObjectIdOptions
 */


var SchemaObjectIdOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaObjectIdOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaObjectIdOptions);

  function SchemaObjectIdOptions() {
    _classCallCheck(this, SchemaObjectIdOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaObjectIdOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If truthy, uses Mongoose's default built-in ObjectId path.
 *
 * @api public
 * @property auto
 * @memberOf SchemaObjectIdOptions
 * @type Boolean
 * @instance
 */


Object.defineProperty(SchemaObjectIdOptions.prototype, 'auto', opts);
/**
 * Sets default [populate options](/docs/populate.html#query-conditions).
 *
 * #### Example:
 *     const schema = new Schema({
 *       child: {
 *         type: 'ObjectId',
 *         ref: 'Child',
 *         populate: { select: 'name' }
 *       }
 *     });
 *     const Parent = mongoose.model('Parent', schema);
 *
 *     // Automatically adds `.select('name')`
 *     Parent.findOne().populate('child');
 *
 * @api public
 * @property populate
 * @memberOf SchemaObjectIdOptions
 * @type Object
 * @instance
 */

Object.defineProperty(SchemaObjectIdOptions.prototype, 'populate', opts);
/*!
 * ignore
 */

module.exports = SchemaObjectIdOptions;

/***/ }),

/***/ 3209:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a string schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ name: String });
 *     schema.path('name').options; // SchemaStringOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaStringOptions
 */


var SchemaStringOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaStringOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaStringOptions);

  function SchemaStringOptions() {
    _classCallCheck(this, SchemaStringOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaStringOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * Array of allowed values for this path
 *
 * @api public
 * @property enum
 * @memberOf SchemaStringOptions
 * @type Array
 * @instance
 */


Object.defineProperty(SchemaStringOptions.prototype, 'enum', opts);
/**
 * Attach a validator that succeeds if the data string matches the given regular
 * expression, and fails otherwise.
 *
 * @api public
 * @property match
 * @memberOf SchemaStringOptions
 * @type RegExp
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'match', opts);
/**
 * If truthy, Mongoose will add a custom setter that lowercases this string
 * using JavaScript's built-in `String#toLowerCase()`.
 *
 * @api public
 * @property lowercase
 * @memberOf SchemaStringOptions
 * @type Boolean
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'lowercase', opts);
/**
 * If truthy, Mongoose will add a custom setter that removes leading and trailing
 * whitespace using [JavaScript's built-in `String#trim()`](https://masteringjs.io/tutorials/fundamentals/trim-string).
 *
 * @api public
 * @property trim
 * @memberOf SchemaStringOptions
 * @type Boolean
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'trim', opts);
/**
 * If truthy, Mongoose will add a custom setter that uppercases this string
 * using JavaScript's built-in [`String#toUpperCase()`](https://masteringjs.io/tutorials/fundamentals/uppercase).
 *
 * @api public
 * @property uppercase
 * @memberOf SchemaStringOptions
 * @type Boolean
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'uppercase', opts);
/**
 * If set, Mongoose will add a custom validator that ensures the given
 * string's `length` is at least the given number.
 *
 * Mongoose supports two different spellings for this option: `minLength` and `minlength`.
 * `minLength` is the recommended way to specify this option, but Mongoose also supports
 * `minlength` (lowercase "l").
 *
 * @api public
 * @property minLength
 * @memberOf SchemaStringOptions
 * @type Number
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'minLength', opts);
Object.defineProperty(SchemaStringOptions.prototype, 'minlength', opts);
/**
 * If set, Mongoose will add a custom validator that ensures the given
 * string's `length` is at most the given number.
 *
 * Mongoose supports two different spellings for this option: `maxLength` and `maxlength`.
 * `maxLength` is the recommended way to specify this option, but Mongoose also supports
 * `maxlength` (lowercase "l").
 *
 * @api public
 * @property maxLength
 * @memberOf SchemaStringOptions
 * @type Number
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'maxLength', opts);
Object.defineProperty(SchemaStringOptions.prototype, 'maxlength', opts);
/**
 * Sets default [populate options](/docs/populate.html#query-conditions).
 *
 * @api public
 * @property populate
 * @memberOf SchemaStringOptions
 * @type Object
 * @instance
 */

Object.defineProperty(SchemaStringOptions.prototype, 'populate', opts);
/*!
 * ignore
 */

module.exports = SchemaStringOptions;

/***/ }),

/***/ 5446:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SchemaTypeOptions = __webpack_require__(1764);
/**
 * The options defined on a single nested schematype.
 *
 * #### Example:
 *
 *     const schema = Schema({ child: Schema({ name: String }) });
 *     schema.path('child').options; // SchemaSubdocumentOptions instance
 *
 * @api public
 * @inherits SchemaTypeOptions
 * @constructor SchemaSubdocumentOptions
 */


var SchemaSubdocumentOptions = /*#__PURE__*/function (_SchemaTypeOptions) {
  _inherits(SchemaSubdocumentOptions, _SchemaTypeOptions);

  var _super = _createSuper(SchemaSubdocumentOptions);

  function SchemaSubdocumentOptions() {
    _classCallCheck(this, SchemaSubdocumentOptions);

    return _super.apply(this, arguments);
  }

  return _createClass(SchemaSubdocumentOptions);
}(SchemaTypeOptions);

var opts = __webpack_require__(3439);
/**
 * If set, overwrites the child schema's `_id` option.
 *
 * #### Example:
 *
 *     const childSchema = Schema({ name: String });
 *     const parentSchema = Schema({
 *       child: { type: childSchema, _id: false }
 *     });
 *     parentSchema.path('child').schema.options._id; // false
 *
 * @api public
 * @property of
 * @memberOf SchemaSubdocumentOptions
 * @type Function|string
 * @instance
 */


Object.defineProperty(SchemaSubdocumentOptions.prototype, '_id', opts);
module.exports = SchemaSubdocumentOptions;

/***/ }),

/***/ 1764:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var clone = __webpack_require__(1973);
/**
 * The options defined on a schematype.
 *
 * #### Example:
 *
 *     const schema = new Schema({ name: String });
 *     schema.path('name').options instanceof mongoose.SchemaTypeOptions; // true
 *
 * @api public
 * @constructor SchemaTypeOptions
 */


var SchemaTypeOptions = /*#__PURE__*/_createClass(function SchemaTypeOptions(obj) {
  _classCallCheck(this, SchemaTypeOptions);

  if (obj == null) {
    return this;
  }

  Object.assign(this, clone(obj));
});

var opts = __webpack_require__(3439);
/**
 * The type to cast this path to.
 *
 * @api public
 * @property type
 * @memberOf SchemaTypeOptions
 * @type Function|String|Object
 * @instance
 */


Object.defineProperty(SchemaTypeOptions.prototype, 'type', opts);
/**
 * Function or object describing how to validate this schematype.
 *
 * @api public
 * @property validate
 * @memberOf SchemaTypeOptions
 * @type Function|Object
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'validate', opts);
/**
 * Allows overriding casting logic for this individual path. If a string, the
 * given string overwrites Mongoose's default cast error message.
 *
 * #### Example:
 *
 *     const schema = new Schema({
 *       num: {
 *         type: Number,
 *         cast: '{VALUE} is not a valid number'
 *       }
 *     });
 *
 *     // Throws 'CastError: "bad" is not a valid number'
 *     schema.path('num').cast('bad');
 *
 *     const Model = mongoose.model('Test', schema);
 *     const doc = new Model({ num: 'fail' });
 *     const err = doc.validateSync();
 *
 *     err.errors['num']; // 'CastError: "fail" is not a valid number'
 *
 * @api public
 * @property cast
 * @memberOf SchemaTypeOptions
 * @type String
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'cast', opts);
/**
 * If true, attach a required validator to this path, which ensures this path
 * cannot be set to a nullish value. If a function, Mongoose calls the
 * function and only checks for nullish values if the function returns a truthy value.
 *
 * @api public
 * @property required
 * @memberOf SchemaTypeOptions
 * @type Function|Boolean
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'required', opts);
/**
 * The default value for this path. If a function, Mongoose executes the function
 * and uses the return value as the default.
 *
 * @api public
 * @property default
 * @memberOf SchemaTypeOptions
 * @type Function|Any
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'default', opts);
/**
 * The model that `populate()` should use if populating this path.
 *
 * @api public
 * @property ref
 * @memberOf SchemaTypeOptions
 * @type Function|String
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'ref', opts);
/**
 * The path in the document that `populate()` should use to find the model
 * to use.
 *
 * @api public
 * @property ref
 * @memberOf SchemaTypeOptions
 * @type Function|String
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'refPath', opts);
/**
 * Whether to include or exclude this path by default when loading documents
 * using `find()`, `findOne()`, etc.
 *
 * @api public
 * @property select
 * @memberOf SchemaTypeOptions
 * @type Boolean|Number
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'select', opts);
/**
 * If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), Mongoose will
 * build an index on this path when the model is compiled.
 *
 * @api public
 * @property index
 * @memberOf SchemaTypeOptions
 * @type Boolean|Number|Object
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'index', opts);
/**
 * If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), Mongoose
 * will build a unique index on this path when the
 * model is compiled. [The `unique` option is **not** a validator](/docs/validation.html#the-unique-option-is-not-a-validator).
 *
 * @api public
 * @property unique
 * @memberOf SchemaTypeOptions
 * @type Boolean|Number
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'unique', opts);
/**
 * If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), Mongoose will
 * disallow changes to this path once the document
 * is saved to the database for the first time. Read more about [immutability in Mongoose here](https://thecodebarbarian.com/whats-new-in-mongoose-5-6-immutable-properties.html).
 *
 * @api public
 * @property immutable
 * @memberOf SchemaTypeOptions
 * @type Function|Boolean
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'immutable', opts);
/**
 * If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), Mongoose will
 * build a sparse index on this path.
 *
 * @api public
 * @property sparse
 * @memberOf SchemaTypeOptions
 * @type Boolean|Number
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'sparse', opts);
/**
 * If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), Mongoose
 * will build a text index on this path.
 *
 * @api public
 * @property text
 * @memberOf SchemaTypeOptions
 * @type Boolean|Number|Object
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'text', opts);
/**
 * Define a transform function for this individual schema type.
 * Only called when calling `toJSON()` or `toObject()`.
 *
 * #### Example:
 *
 *     const schema = Schema({
 *       myDate: {
 *         type: Date,
 *         transform: v => v.getFullYear()
 *       }
 *     });
 *     const Model = mongoose.model('Test', schema);
 *
 *     const doc = new Model({ myDate: new Date('2019/06/01') });
 *     doc.myDate instanceof Date; // true
 *
 *     const res = doc.toObject({ transform: true });
 *     res.myDate; // 2019
 *
 * @api public
 * @property transform
 * @memberOf SchemaTypeOptions
 * @type Function
 * @instance
 */

Object.defineProperty(SchemaTypeOptions.prototype, 'transform', opts);
module.exports = SchemaTypeOptions;

/***/ }),

/***/ 1902:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var opts = __webpack_require__(3439);

var VirtualOptions = /*#__PURE__*/_createClass(function VirtualOptions(obj) {
  _classCallCheck(this, VirtualOptions);

  Object.assign(this, obj);

  if (obj != null && obj.options != null) {
    this.options = Object.assign({}, obj.options);
  }
});
/**
 * Marks this virtual as a populate virtual, and specifies the model to
 * use for populate.
 *
 * @api public
 * @property ref
 * @memberOf VirtualOptions
 * @type String|Model|Function
 * @instance
 */


Object.defineProperty(VirtualOptions.prototype, 'ref', opts);
/**
 * Marks this virtual as a populate virtual, and specifies the path that
 * contains the name of the model to populate
 *
 * @api public
 * @property refPath
 * @memberOf VirtualOptions
 * @type String|Function
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'refPath', opts);
/**
 * The name of the property in the local model to match to `foreignField`
 * in the foreign model.
 *
 * @api public
 * @property localField
 * @memberOf VirtualOptions
 * @type String|Function
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'localField', opts);
/**
 * The name of the property in the foreign model to match to `localField`
 * in the local model.
 *
 * @api public
 * @property foreignField
 * @memberOf VirtualOptions
 * @type String|Function
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'foreignField', opts);
/**
 * Whether to populate this virtual as a single document (true) or an
 * array of documents (false).
 *
 * @api public
 * @property justOne
 * @memberOf VirtualOptions
 * @type Boolean
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'justOne', opts);
/**
 * If true, populate just the number of documents where `localField`
 * matches `foreignField`, as opposed to the documents themselves.
 *
 * If `count` is set, it overrides `justOne`.
 *
 * @api public
 * @property count
 * @memberOf VirtualOptions
 * @type Boolean
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'count', opts);
/**
 * Add an additional filter to populate, in addition to `localField`
 * matches `foreignField`.
 *
 * @api public
 * @property match
 * @memberOf VirtualOptions
 * @type Object|Function
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'match', opts);
/**
 * Additional options to pass to the query used to `populate()`:
 *
 * - `sort`
 * - `skip`
 * - `limit`
 *
 * @api public
 * @property options
 * @memberOf VirtualOptions
 * @type Object
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'options', opts);
/**
 * If true, add a `skip` to the query used to `populate()`.
 *
 * @api public
 * @property skip
 * @memberOf VirtualOptions
 * @type Number
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'skip', opts);
/**
 * If true, add a `limit` to the query used to `populate()`.
 *
 * @api public
 * @property limit
 * @memberOf VirtualOptions
 * @type Number
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'limit', opts);
/**
 * The `limit` option for `populate()` has [some unfortunate edge cases](/docs/populate.html#query-conditions)
 * when working with multiple documents, like `.find().populate()`. The
 * `perDocumentLimit` option makes `populate()` execute a separate query
 * for each document returned from `find()` to ensure each document
 * gets up to `perDocumentLimit` populated docs if possible.
 *
 * @api public
 * @property perDocumentLimit
 * @memberOf VirtualOptions
 * @type Number
 * @instance
 */

Object.defineProperty(VirtualOptions.prototype, 'perDocumentLimit', opts);
module.exports = VirtualOptions;

/***/ }),

/***/ 3439:
/***/ ((module) => {

"use strict";


module.exports = Object.freeze({
  enumerable: true,
  configurable: true,
  writable: true,
  value: void 0
});

/***/ }),

/***/ 6755:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * ignore
 */


var assert = __webpack_require__(9373);

var mquery = __webpack_require__(5417);
/**
 * Helper for multiplexing promise implementations
 *
 * @api private
 */


var store = {
  _promise: null
};
/**
 * Get the current promise constructor
 *
 * @api private
 */

store.get = function () {
  return store._promise;
};
/**
 * Set the current promise constructor
 *
 * @api private
 */


store.set = function (lib) {
  assert.ok(typeof lib === 'function', "mongoose.Promise must be a function, got ".concat(lib));
  store._promise = lib;
  mquery.Promise = lib;
};
/*!
 * Use native promises by default
 */


store.set(__webpack_require__.g.Promise);
module.exports = store;

/***/ }),

/***/ 2888:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var checkEmbeddedDiscriminatorKeyProjection = __webpack_require__(4531);

var get = __webpack_require__(9981);

var getDiscriminatorByValue = __webpack_require__(7291);

var isDefiningProjection = __webpack_require__(2183);

var clone = __webpack_require__(1973);
/*!
 * Prepare a set of path options for query population.
 *
 * @param {Query} query
 * @param {Object} options
 * @return {Array}
 */


exports.preparePopulationOptions = function preparePopulationOptions(query, options) {
  var _populate = query.options.populate;
  var pop = Object.keys(_populate).reduce(function (vals, key) {
    return vals.concat([_populate[key]]);
  }, []); // lean options should trickle through all queries

  if (options.lean != null) {
    pop.filter(function (p) {
      return (p && p.options && p.options.lean) == null;
    }).forEach(makeLean(options.lean));
  }

  pop.forEach(function (opts) {
    opts._localModel = query.model;
  });
  return pop;
};
/*!
 * Prepare a set of path options for query population. This is the MongooseQuery
 * version
 *
 * @param {Query} query
 * @param {Object} options
 * @return {Array}
 */


exports.preparePopulationOptionsMQ = function preparePopulationOptionsMQ(query, options) {
  var _populate = query._mongooseOptions.populate;
  var pop = Object.keys(_populate).reduce(function (vals, key) {
    return vals.concat([_populate[key]]);
  }, []); // lean options should trickle through all queries

  if (options.lean != null) {
    pop.filter(function (p) {
      return (p && p.options && p.options.lean) == null;
    }).forEach(makeLean(options.lean));
  }

  var session = query && query.options && query.options.session || null;

  if (session != null) {
    pop.forEach(function (path) {
      if (path.options == null) {
        path.options = {
          session: session
        };
        return;
      }

      if (!('session' in path.options)) {
        path.options.session = session;
      }
    });
  }

  var projection = query._fieldsForExec();

  pop.forEach(function (p) {
    p._queryProjection = projection;
  });
  pop.forEach(function (opts) {
    opts._localModel = query.model;
  });
  return pop;
};
/*!
 * If the document is a mapped discriminator type, it returns a model instance for that type, otherwise,
 * it returns an instance of the given model.
 *
 * @param {Model}  model
 * @param {Object} doc
 * @param {Object} fields
 *
 * @return {Document}
 */


exports.createModel = function createModel(model, doc, fields, userProvidedFields, options) {
  model.hooks.execPreSync('createModel', doc);
  var discriminatorMapping = model.schema ? model.schema.discriminatorMapping : null;
  var key = discriminatorMapping && discriminatorMapping.isRoot ? discriminatorMapping.key : null;
  var value = doc[key];

  if (key && value && model.discriminators) {
    var discriminator = model.discriminators[value] || getDiscriminatorByValue(model.discriminators, value);

    if (discriminator) {
      var _fields = clone(userProvidedFields);

      exports.applyPaths(_fields, discriminator.schema);
      return new discriminator(undefined, _fields, true);
    }
  }

  var _opts = {
    skipId: true,
    isNew: false,
    willInit: true
  };

  if (options != null && 'defaults' in options) {
    _opts.defaults = options.defaults;
  }

  return new model(undefined, fields, _opts);
};
/*!
 * ignore
 */


exports.createModelAndInit = function createModelAndInit(model, doc, fields, userProvidedFields, options, populatedIds, callback) {
  var initOpts = populatedIds ? {
    populated: populatedIds
  } : undefined;
  var casted = exports.createModel(model, doc, fields, userProvidedFields, options);

  try {
    casted.$init(doc, initOpts, callback);
  } catch (error) {
    callback(error, casted);
  }
};
/*!
 * ignore
 */


exports.applyPaths = function applyPaths(fields, schema) {
  // determine if query is selecting or excluding fields
  var exclude;
  var keys;
  var keyIndex;

  if (fields) {
    keys = Object.keys(fields);
    keyIndex = keys.length;

    while (keyIndex--) {
      if (keys[keyIndex][0] === '+') {
        continue;
      }

      var field = fields[keys[keyIndex]]; // Skip `$meta` and `$slice`

      if (!isDefiningProjection(field)) {
        continue;
      }

      exclude = !field;
      break;
    }
  } // if selecting, apply default schematype select:true fields
  // if excluding, apply schematype select:false fields


  var selected = [];
  var excluded = [];
  var stack = [];
  analyzeSchema(schema);

  switch (exclude) {
    case true:
      var _iterator = _createForOfIteratorHelper(excluded),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var fieldName = _step.value;
          fields[fieldName] = 0;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      break;

    case false:
      if (schema && schema.paths['_id'] && schema.paths['_id'].options && schema.paths['_id'].options.select === false) {
        fields._id = 0;
      }

      var _iterator2 = _createForOfIteratorHelper(selected),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _fieldName = _step2.value;
          fields[_fieldName] = fields[_fieldName] || 1;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      break;

    case undefined:
      if (fields == null) {
        break;
      } // Any leftover plus paths must in the schema, so delete them (gh-7017)


      for (var _i = 0, _Object$keys = Object.keys(fields || {}); _i < _Object$keys.length; _i++) {
        var key = _Object$keys[_i];

        if (key.startsWith('+')) {
          delete fields[key];
        }
      } // user didn't specify fields, implies returning all fields.
      // only need to apply excluded fields and delete any plus paths


      var _iterator3 = _createForOfIteratorHelper(excluded),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _fieldName2 = _step3.value;

          if (fields[_fieldName2] != null) {
            // Skip applying default projections to fields with non-defining
            // projections, like `$slice`
            continue;
          }

          fields[_fieldName2] = 0;
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      break;
  }

  function analyzeSchema(schema, prefix) {
    prefix || (prefix = ''); // avoid recursion

    if (stack.indexOf(schema) !== -1) {
      return [];
    }

    stack.push(schema);
    var addedPaths = [];
    schema.eachPath(function (path, type) {
      if (prefix) path = prefix + '.' + path;

      if (type.$isSchemaMap || path.endsWith('.$*')) {
        return;
      }

      var addedPath = analyzePath(path, type); // arrays

      if (addedPath == null && !Array.isArray(type) && type.$isMongooseArray && !type.$isMongooseDocumentArray) {
        addedPath = analyzePath(path, type.caster);
      }

      if (addedPath != null) {
        addedPaths.push(addedPath);
      } // nested schemas


      if (type.schema) {
        var _addedPaths = analyzeSchema(type.schema, path); // Special case: if discriminator key is the only field that would
        // be projected in, remove it.


        if (exclude === false) {
          checkEmbeddedDiscriminatorKeyProjection(fields, path, type.schema, selected, _addedPaths);
        }
      }
    });
    stack.pop();
    return addedPaths;
  }

  function analyzePath(path, type) {
    var plusPath = '+' + path;
    var hasPlusPath = fields && plusPath in fields;

    if (hasPlusPath) {
      // forced inclusion
      delete fields[plusPath];
    }

    if (typeof type.selected !== 'boolean') {
      return;
    } // If set to 0, we're explicitly excluding the discriminator key. Can't do this for all fields,
    // because we have tests that assert that using `-path` to exclude schema-level `select: true`
    // fields counts as an exclusive projection. See gh-11546


    if (exclude && type.selected && path === schema.options.discriminatorKey && fields[path] != null && !fields[path]) {
      delete fields[path];
      return;
    }

    if (hasPlusPath) {
      // forced inclusion
      delete fields[plusPath]; // if there are other fields being included, add this one
      // if no other included fields, leave this out (implied inclusion)

      if (exclude === false && keys.length > 1 && !~keys.indexOf(path)) {
        fields[path] = 1;
      }

      return;
    } // check for parent exclusions


    var pieces = path.split('.');
    var cur = '';

    for (var i = 0; i < pieces.length; ++i) {
      cur += cur.length ? '.' + pieces[i] : pieces[i];

      if (excluded.indexOf(cur) !== -1) {
        return;
      }
    } // Special case: if user has included a parent path of a discriminator key,
    // don't explicitly project in the discriminator key because that will
    // project out everything else under the parent path


    if (!exclude && (type && type.options && type.options.$skipDiscriminatorCheck || false)) {
      var _cur = '';

      for (var _i2 = 0; _i2 < pieces.length; ++_i2) {
        _cur += (_cur.length === 0 ? '' : '.') + pieces[_i2];
        var projection = get(fields, _cur, false) || get(fields, _cur + '.$', false);

        if (projection && _typeof(projection) !== 'object') {
          return;
        }
      }
    }

    (type.selected ? selected : excluded).push(path);
    return path;
  }
};
/*!
 * Set each path query option to lean
 *
 * @param {Object} option
 */


function makeLean(val) {
  return function (option) {
    option.options || (option.options = {});

    if (val != null && Array.isArray(val.virtuals)) {
      val = Object.assign({}, val);
      val.virtuals = val.virtuals.filter(function (path) {
        return typeof path === 'string' && path.startsWith(option.path + '.');
      }).map(function (path) {
        return path.slice(option.path.length + 1);
      });
    }

    option.options.lean = val;
  };
}

/***/ }),

/***/ 5506:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];

/*!
 * Module dependencies.
 */

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var EventEmitter = (__webpack_require__(9620).EventEmitter);

var Kareem = __webpack_require__(3138);

var MongooseError = __webpack_require__(5202);

var SchemaType = __webpack_require__(4289);

var SchemaTypeOptions = __webpack_require__(1764);

var VirtualOptions = __webpack_require__(1902);

var VirtualType = __webpack_require__(459);

var addAutoId = __webpack_require__(4133);

var get = __webpack_require__(9981);

var getConstructorName = __webpack_require__(1981);

var getIndexes = __webpack_require__(5379);

var idGetter = __webpack_require__(1879);

var merge = __webpack_require__(4913);

var mpath = __webpack_require__(3564);

var readPref = (__webpack_require__(9906).get)().ReadPreference;

var setupTimestamps = __webpack_require__(3767);

var utils = __webpack_require__(6872);

var validateRef = __webpack_require__(6870);

var util = __webpack_require__(161);

var MongooseTypes;

var queryHooks = (__webpack_require__(5130).middlewareFunctions);

var documentHooks = (__webpack_require__(8859).middlewareFunctions);

var hookNames = queryHooks.concat(documentHooks).reduce(function (s, hook) {
  return s.add(hook);
}, new Set());
var isPOJO = utils.isPOJO;
var id = 0;
/**
 * Schema constructor.
 *
 * #### Example:
 *
 *     const child = new Schema({ name: String });
 *     const schema = new Schema({ name: String, age: Number, children: [child] });
 *     const Tree = mongoose.model('Tree', schema);
 *
 *     // setting schema options
 *     new Schema({ name: String }, { _id: false, autoIndex: false })
 *
 * #### Options:
 *
 * - [autoIndex](/docs/guide.html#autoIndex): bool - defaults to null (which means use the connection's autoIndex option)
 * - [autoCreate](/docs/guide.html#autoCreate): bool - defaults to null (which means use the connection's autoCreate option)
 * - [bufferCommands](/docs/guide.html#bufferCommands): bool - defaults to true
 * - [bufferTimeoutMS](/docs/guide.html#bufferTimeoutMS): number - defaults to 10000 (10 seconds). If `bufferCommands` is enabled, the amount of time Mongoose will wait for connectivity to be restablished before erroring out.
 * - [capped](/docs/guide.html#capped): bool | number | object - defaults to false
 * - [collection](/docs/guide.html#collection): string - no default
 * - [discriminatorKey](/docs/guide.html#discriminatorKey): string - defaults to `__t`
 * - [id](/docs/guide.html#id): bool - defaults to true
 * - [_id](/docs/guide.html#_id): bool - defaults to true
 * - [minimize](/docs/guide.html#minimize): bool - controls [document#toObject](#document_Document-toObject) behavior when called manually - defaults to true
 * - [read](/docs/guide.html#read): string
 * - [writeConcern](/docs/guide.html#writeConcern): object - defaults to null, use to override [the MongoDB server's default write concern settings](https://docs.mongodb.com/manual/reference/write-concern/)
 * - [shardKey](/docs/guide.html#shardKey): object - defaults to `null`
 * - [strict](/docs/guide.html#strict): bool - defaults to true
 * - [strictQuery](/docs/guide.html#strictQuery): bool - defaults to false
 * - [toJSON](/docs/guide.html#toJSON) - object - no default
 * - [toObject](/docs/guide.html#toObject) - object - no default
 * - [typeKey](/docs/guide.html#typeKey) - string - defaults to 'type'
 * - [validateBeforeSave](/docs/guide.html#validateBeforeSave) - bool - defaults to `true`
 * - [versionKey](/docs/guide.html#versionKey): string or object - defaults to "__v"
 * - [optimisticConcurrency](/docs/guide.html#optimisticConcurrency): bool - defaults to false. Set to true to enable [optimistic concurrency](https://thecodebarbarian.com/whats-new-in-mongoose-5-10-optimistic-concurrency.html).
 * - [collation](/docs/guide.html#collation): object - defaults to null (which means use no collation)
 * - [timeseries](/docs/guide.html#timeseries): object - defaults to null (which means this schema's collection won't be a timeseries collection)
 * - [selectPopulatedPaths](/docs/guide.html#selectPopulatedPaths): boolean - defaults to `true`
 * - [skipVersioning](/docs/guide.html#skipVersioning): object - paths to exclude from versioning
 * - [timestamps](/docs/guide.html#timestamps): object or boolean - defaults to `false`. If true, Mongoose adds `createdAt` and `updatedAt` properties to your schema and manages those properties for you.
 * - [pluginTags](/docs/guide.html#pluginTags): array of strings - defaults to `undefined`. If set and plugin called with `tags` option, will only apply that plugin to schemas with a matching tag.
 *
 * #### Options for Nested Schemas:
 * - `excludeIndexes`: bool - defaults to `false`. If `true`, skip building indexes on this schema's paths.
 *
 * #### Note:
 *
 * _When nesting schemas, (`children` in the example above), always declare the child schema first before passing it into its parent._
 *
 * @param {Object|Schema|Array} [definition] Can be one of: object describing schema paths, or schema to copy, or array of objects and schemas
 * @param {Object} [options]
 * @inherits NodeJS EventEmitter https://nodejs.org/api/events.html#events_class_events_eventemitter
 * @event `init`: Emitted after the schema is compiled into a `Model`.
 * @api public
 */

function Schema(obj, options) {
  if (!(this instanceof Schema)) {
    return new Schema(obj, options);
  }

  this.obj = obj;
  this.paths = {};
  this.aliases = {};
  this.subpaths = {};
  this.virtuals = {};
  this.singleNestedPaths = {};
  this.nested = {};
  this.inherits = {};
  this.callQueue = [];
  this._indexes = [];
  this.methods = options && options.methods || {};
  this.methodOptions = {};
  this.statics = options && options.statics || {};
  this.tree = {};
  this.query = options && options.query || {};
  this.childSchemas = [];
  this.plugins = []; // For internal debugging. Do not use this to try to save a schema in MDB.

  this.$id = ++id;
  this.mapPaths = [];
  this.s = {
    hooks: new Kareem()
  };
  this.options = this.defaultOptions(options); // build paths

  if (Array.isArray(obj)) {
    var _iterator = _createForOfIteratorHelper(obj),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var definition = _step.value;
        this.add(definition);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  } else if (obj) {
    this.add(obj);
  } // check if _id's value is a subdocument (gh-2276)


  var _idSubDoc = obj && obj._id && utils.isObject(obj._id); // ensure the documents get an auto _id unless disabled


  var auto_id = !this.paths['_id'] && this.options._id && !_idSubDoc;

  if (auto_id) {
    addAutoId(this);
  }

  this.setupTimestamp(this.options.timestamps);
}
/*!
 * Create virtual properties with alias field
 */


function aliasFields(schema, paths) {
  paths = paths || Object.keys(schema.paths);

  var _iterator2 = _createForOfIteratorHelper(paths),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var path = _step2.value;
      var options = get(schema.paths[path], 'options');

      if (options == null) {
        continue;
      }

      var prop = schema.paths[path].path;
      var alias = options.alias;

      if (!alias) {
        continue;
      }

      if (typeof alias !== 'string') {
        throw new Error('Invalid value for alias option on ' + prop + ', got ' + alias);
      }

      schema.aliases[alias] = prop;
      schema.virtual(alias).get(function (p) {
        return function () {
          if (typeof this.get === 'function') {
            return this.get(p);
          }

          return this[p];
        };
      }(prop)).set(function (p) {
        return function (v) {
          return this.$set(p, v);
        };
      }(prop));
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
}
/*!
 * Inherit from EventEmitter.
 */


Schema.prototype = Object.create(EventEmitter.prototype);
Schema.prototype.constructor = Schema;
Schema.prototype.instanceOfSchema = true;
/*!
 * ignore
 */

Object.defineProperty(Schema.prototype, '$schemaType', {
  configurable: false,
  enumerable: false,
  writable: true
});
/**
 * Array of child schemas (from document arrays and single nested subdocs)
 * and their corresponding compiled models. Each element of the array is
 * an object with 2 properties: `schema` and `model`.
 *
 * This property is typically only useful for plugin authors and advanced users.
 * You do not need to interact with this property at all to use mongoose.
 *
 * @api public
 * @property childSchemas
 * @memberOf Schema
 * @instance
 */

Object.defineProperty(Schema.prototype, 'childSchemas', {
  configurable: false,
  enumerable: true,
  writable: true
});
/**
 * Object containing all virtuals defined on this schema.
 * The objects' keys are the virtual paths and values are instances of `VirtualType`.
 *
 * This property is typically only useful for plugin authors and advanced users.
 * You do not need to interact with this property at all to use mongoose.
 *
 * #### Example:
 *     const schema = new Schema({});
 *     schema.virtual('answer').get(() => 42);
 *
 *     console.log(schema.virtuals); // { answer: VirtualType { path: 'answer', ... } }
 *     console.log(schema.virtuals['answer'].getters[0].call()); // 42
 *
 * @api public
 * @property virtuals
 * @memberOf Schema
 * @instance
 */

Object.defineProperty(Schema.prototype, 'virtuals', {
  configurable: false,
  enumerable: true,
  writable: true
});
/**
 * The original object passed to the schema constructor
 *
 * #### Example:
 *
 *     const schema = new Schema({ a: String }).add({ b: String });
 *     schema.obj; // { a: String }
 *
 * @api public
 * @property obj
 * @memberOf Schema
 * @instance
 */

Schema.prototype.obj;
/**
 * The paths defined on this schema. The keys are the top-level paths
 * in this schema, and the values are instances of the SchemaType class.
 *
 * #### Example:
 *     const schema = new Schema({ name: String }, { _id: false });
 *     schema.paths; // { name: SchemaString { ... } }
 *
 *     schema.add({ age: Number });
 *     schema.paths; // { name: SchemaString { ... }, age: SchemaNumber { ... } }
 *
 * @api public
 * @property paths
 * @memberOf Schema
 * @instance
 */

Schema.prototype.paths;
/**
 * Schema as a tree
 *
 * #### Example:
 *     {
 *         '_id'     : ObjectId
 *       , 'nested'  : {
 *             'key' : String
 *         }
 *     }
 *
 * @api private
 * @property tree
 * @memberOf Schema
 * @instance
 */

Schema.prototype.tree;
/**
 * Returns a deep copy of the schema
 *
 * #### Example:
 *
 *     const schema = new Schema({ name: String });
 *     const clone = schema.clone();
 *     clone === schema; // false
 *     clone.path('name'); // SchemaString { ... }
 *
 * @return {Schema} the cloned schema
 * @api public
 * @memberOf Schema
 * @instance
 */

Schema.prototype.clone = function () {
  var _this2 = this;

  var s = this._clone(); // Bubble up `init` for backwards compat


  s.on('init', function (v) {
    return _this2.emit('init', v);
  });
  return s;
};
/*!
 * ignore
 */


Schema.prototype._clone = function _clone(Constructor) {
  Constructor = Constructor || (this.base == null ? Schema : this.base.Schema);
  var s = new Constructor({}, this._userProvidedOptions);
  s.base = this.base;
  s.obj = this.obj;
  s.options = utils.clone(this.options);
  s.callQueue = this.callQueue.map(function (f) {
    return f;
  });
  s.methods = utils.clone(this.methods);
  s.methodOptions = utils.clone(this.methodOptions);
  s.statics = utils.clone(this.statics);
  s.query = utils.clone(this.query);
  s.plugins = Array.prototype.slice.call(this.plugins);
  s._indexes = utils.clone(this._indexes);
  s.s.hooks = this.s.hooks.clone();
  s.tree = utils.clone(this.tree);
  s.paths = utils.clone(this.paths);
  s.nested = utils.clone(this.nested);
  s.subpaths = utils.clone(this.subpaths);
  s.singleNestedPaths = utils.clone(this.singleNestedPaths);
  s.childSchemas = gatherChildSchemas(s);
  s.virtuals = utils.clone(this.virtuals);
  s.$globalPluginsApplied = this.$globalPluginsApplied;
  s.$isRootDiscriminator = this.$isRootDiscriminator;
  s.$implicitlyCreated = this.$implicitlyCreated;
  s.$id = ++id;
  s.$originalSchemaId = this.$id;
  s.mapPaths = [].concat(this.mapPaths);

  if (this.discriminatorMapping != null) {
    s.discriminatorMapping = Object.assign({}, this.discriminatorMapping);
  }

  if (this.discriminators != null) {
    s.discriminators = Object.assign({}, this.discriminators);
  }

  if (this._applyDiscriminators != null) {
    s._applyDiscriminators = Object.assign({}, this._applyDiscriminators);
  }

  s.aliases = Object.assign({}, this.aliases);
  return s;
};
/**
 * Returns a new schema that has the picked `paths` from this schema.
 *
 * This method is analagous to [Lodash's `pick()` function](https://lodash.com/docs/4.17.15#pick) for Mongoose schemas.
 *
 * #### Example:
 *
 *     const schema = Schema({ name: String, age: Number });
 *     // Creates a new schema with the same `name` path as `schema`,
 *     // but no `age` path.
 *     const newSchema = schema.pick(['name']);
 *
 *     newSchema.path('name'); // SchemaString { ... }
 *     newSchema.path('age'); // undefined
 *
 * @param {Array} paths list of paths to pick
 * @param {Object} [options] options to pass to the schema constructor. Defaults to `this.options` if not set.
 * @return {Schema}
 * @api public
 */


Schema.prototype.pick = function (paths, options) {
  var newSchema = new Schema({}, options || this.options);

  if (!Array.isArray(paths)) {
    throw new MongooseError('Schema#pick() only accepts an array argument, ' + 'got "' + _typeof(paths) + '"');
  }

  var _iterator3 = _createForOfIteratorHelper(paths),
      _step3;

  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var path = _step3.value;

      if (this.nested[path]) {
        newSchema.add(_defineProperty({}, path, get(this.tree, path)));
      } else {
        var schematype = this.path(path);

        if (schematype == null) {
          throw new MongooseError('Path `' + path + '` is not in the schema');
        }

        newSchema.add(_defineProperty({}, path, schematype));
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }

  return newSchema;
};
/**
 * Returns default options for this schema, merged with `options`.
 *
 * @param {Object} options
 * @return {Object}
 * @api private
 */


Schema.prototype.defaultOptions = function (options) {
  this._userProvidedOptions = options == null ? {} : utils.clone(options);
  var baseOptions = this.base && this.base.options || {};
  var strict = 'strict' in baseOptions ? baseOptions.strict : true;
  options = utils.options({
    strict: strict,
    strictQuery: 'strict' in this._userProvidedOptions ? this._userProvidedOptions.strict : 'strictQuery' in baseOptions ? baseOptions.strictQuery : strict,
    bufferCommands: true,
    capped: false,
    // { size, max, autoIndexId }
    versionKey: '__v',
    optimisticConcurrency: false,
    minimize: true,
    autoIndex: null,
    discriminatorKey: '__t',
    shardKey: null,
    read: null,
    validateBeforeSave: true,
    // the following are only applied at construction time
    _id: true,
    id: true,
    typeKey: 'type'
  }, utils.clone(options));

  if (options.read) {
    options.read = readPref(options.read);
  }

  if (options.versionKey && typeof options.versionKey !== 'string') {
    throw new MongooseError('`versionKey` must be falsy or string, got `' + _typeof(options.versionKey) + '`');
  }

  if (options.optimisticConcurrency && !options.versionKey) {
    throw new MongooseError('Must set `versionKey` if using `optimisticConcurrency`');
  }

  return options;
};
/**
 * Inherit a Schema by applying a discriminator on an existing Schema.
 *
 *
 * ####Example:
 *
 *     const options = { discriminatorKey: 'kind' };
 *
 *     const eventSchema = new mongoose.Schema({ time: Date }, options);
 *     const Event = mongoose.model('Event', eventSchema);
 *
 *     // ClickedLinkEvent is a special type of Event that has
 *     // a URL.
 *     const ClickedLinkEvent = Event.discriminator('ClickedLink',
 *     new mongoose.Schema({ url: String }, options));
 *
 *     // When you create a generic event, it can't have a URL field...
 *     const genericEvent = new Event({ time: Date.now(), url: 'google.com' });
 *     assert.ok(!genericEvent.url);
 *     // But a ClickedLinkEvent can
 *     const clickedEvent = new ClickedLinkEvent({ time: Date.now(), url: 'google.com' });
 *     assert.ok(clickedEvent.url);
 *
 * @param {String} name the name of the discriminator
 * @param {Schema} schema the Schema of the discriminated Schema
 * @return {Schema} the Schema instance
 * @api public
 */


Schema.prototype.discriminator = function (name, schema) {
  this._applyDiscriminators = Object.assign(this._applyDiscriminators || {}, _defineProperty({}, name, schema));
  return this;
};
/**
 * Adds key path / schema type pairs to this schema.
 *
 * #### Example:
 *
 *     const ToySchema = new Schema();
 *     ToySchema.add({ name: 'string', color: 'string', price: 'number' });
 *
 *     const TurboManSchema = new Schema();
 *     // You can also `add()` another schema and copy over all paths, virtuals,
 *     // getters, setters, indexes, methods, and statics.
 *     TurboManSchema.add(ToySchema).add({ year: Number });
 *
 * @param {Object|Schema} obj plain object with paths to add, or another schema
 * @param {String} [prefix] path to prefix the newly added paths with
 * @return {Schema} the Schema instance
 * @api public
 */


Schema.prototype.add = function add(obj, prefix) {
  if (obj instanceof Schema || obj != null && obj.instanceOfSchema) {
    merge(this, obj);
    return this;
  } // Special case: setting top-level `_id` to false should convert to disabling
  // the `_id` option. This behavior never worked before 5.4.11 but numerous
  // codebases use it (see gh-7516, gh-7512).


  if (obj._id === false && prefix == null) {
    this.options._id = false;
  }

  prefix = prefix || ''; // avoid prototype pollution

  if (prefix === '__proto__.' || prefix === 'constructor.' || prefix === 'prototype.') {
    return this;
  }

  var keys = Object.keys(obj);
  var typeKey = this.options.typeKey;

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];
    var fullPath = prefix + key;
    var val = obj[key];

    if (val == null) {
      throw new TypeError('Invalid value for schema path `' + fullPath + '`, got value "' + val + '"');
    } // Retain `_id: false` but don't set it as a path, re: gh-8274.


    if (key === '_id' && val === false) {
      continue;
    }

    if (val instanceof VirtualType || (val.constructor && val.constructor.name || null) === 'VirtualType') {
      this.virtual(val);
      continue;
    }

    if (Array.isArray(val) && val.length === 1 && val[0] == null) {
      throw new TypeError('Invalid value for schema Array path `' + fullPath + '`, got value "' + val[0] + '"');
    }

    if (!(isPOJO(val) || val instanceof SchemaTypeOptions)) {
      // Special-case: Non-options definitely a path so leaf at this node
      // Examples: Schema instances, SchemaType instances
      if (prefix) {
        this.nested[prefix.substring(0, prefix.length - 1)] = true;
      }

      this.path(prefix + key, val);

      if (val[0] != null && !val[0].instanceOfSchema && utils.isPOJO(val[0].discriminators)) {
        var schemaType = this.path(prefix + key);

        for (var _key in val[0].discriminators) {
          schemaType.discriminator(_key, val[0].discriminators[_key]);
        }
      } else if (val[0] != null && val[0].instanceOfSchema && utils.isPOJO(val[0]._applyDiscriminators)) {
        var applyDiscriminators = val[0]._applyDiscriminators || [];

        var _schemaType2 = this.path(prefix + key);

        for (var disc in applyDiscriminators) {
          _schemaType2.discriminator(disc, applyDiscriminators[disc]);
        }
      } else if (val != null && val.instanceOfSchema && utils.isPOJO(val._applyDiscriminators)) {
        var _applyDiscriminators = val._applyDiscriminators || [];

        var _schemaType3 = this.path(prefix + key);

        for (var _disc in _applyDiscriminators) {
          _schemaType3.discriminator(_disc, _applyDiscriminators[_disc]);
        }
      }
    } else if (Object.keys(val).length < 1) {
      // Special-case: {} always interpreted as Mixed path so leaf at this node
      if (prefix) {
        this.nested[prefix.substring(0, prefix.length - 1)] = true;
      }

      this.path(fullPath, val); // mixed type
    } else if (!val[typeKey] || typeKey === 'type' && isPOJO(val.type) && val.type.type) {
      // Special-case: POJO with no bona-fide type key - interpret as tree of deep paths so recurse
      // nested object `{ last: { name: String } }`. Avoid functions with `.type` re: #10807 because
      // NestJS sometimes adds `Date.type`.
      this.nested[fullPath] = true;
      this.add(val, fullPath + '.');
    } else {
      // There IS a bona-fide type key that may also be a POJO
      var _typeDef = val[typeKey];

      if (isPOJO(_typeDef) && Object.keys(_typeDef).length > 0) {
        // If a POJO is the value of a type key, make it a subdocument
        if (prefix) {
          this.nested[prefix.substring(0, prefix.length - 1)] = true;
        }

        var _schema = new Schema(_typeDef);

        var schemaWrappedPath = Object.assign({}, val, {
          type: _schema
        });
        this.path(prefix + key, schemaWrappedPath);
      } else {
        // Either the type is non-POJO or we interpret it as Mixed anyway
        if (prefix) {
          this.nested[prefix.substring(0, prefix.length - 1)] = true;
        }

        this.path(prefix + key, val);

        if (val != null && !val.instanceOfSchema && utils.isPOJO(val.discriminators)) {
          var _schemaType4 = this.path(prefix + key);

          for (var _key2 in val.discriminators) {
            _schemaType4.discriminator(_key2, val.discriminators[_key2]);
          }
        }
      }
    }
  }

  var addedKeys = Object.keys(obj).map(function (key) {
    return prefix ? prefix + key : key;
  });
  aliasFields(this, addedKeys);
  return this;
};
/**
 * Remove an index by name or index specification.
 *
 * removeIndex only removes indexes from your schema object. Does **not** affect the indexes
 * in MongoDB.
 *
 * ####Example:
 *
 *     const ToySchema = new Schema({ name: String, color: String, price: Number });
 *
 *     // Add a new index on { name, color }
 *     ToySchema.index({ name: 1, color: 1 });
 *
 *     // Remove index on { name, color }
 *     // Keep in mind that order matters! `removeIndex({ color: 1, name: 1 })` won't remove the index
 *     ToySchema.removeIndex({ name: 1, color: 1 });
 *
 *     // Add an index with a custom name
 *     ToySchema.index({ color: 1 }, { name: 'my custom index name' });
 *     // Remove index by name
 *     ToySchema.removeIndex('my custom index name');
 *
 * @param {Object|string} index name or index specification
 * @return {Schema} the Schema instance
 * @api public
 */


Schema.prototype.removeIndex = function removeIndex(index) {
  if (arguments.length > 1) {
    throw new Error('removeIndex() takes only 1 argument');
  }

  if (_typeof(index) !== 'object' && typeof index !== 'string') {
    throw new Error('removeIndex() may only take either an object or a string as an argument');
  }

  if (_typeof(index) === 'object') {
    for (var i = this._indexes.length - 1; i >= 0; --i) {
      if (util.isDeepStrictEqual(this._indexes[i][0], index)) {
        this._indexes.splice(i, 1);
      }
    }
  } else {
    for (var _i2 = this._indexes.length - 1; _i2 >= 0; --_i2) {
      if (this._indexes[_i2][1] != null && this._indexes[_i2][1].name === index) {
        this._indexes.splice(_i2, 1);
      }
    }
  }

  return this;
};
/**
 * Remove all indexes from this schema.
 *
 * clearIndexes only removes indexes from your schema object. Does **not** affect the indexes
 * in MongoDB.
 *
 * ####Example:
 *
 *     const ToySchema = new Schema({ name: String, color: String, price: Number });
 *     ToySchema.index({ name: 1 });
 *     ToySchema.index({ color: 1 });
 *
 *     // Remove all indexes on this schema
 *     ToySchema.clearIndexes();
 *
 *     ToySchema.indexes(); // []
 *
 * @return {Schema} the Schema instance
 * @api public
 */


Schema.prototype.clearIndexes = function clearIndexes() {
  this._indexes.length = 0;
  return this;
};
/**
 * Reserved document keys.
 *
 * Keys in this object are names that are warned in schema declarations
 * because they have the potential to break Mongoose/ Mongoose plugins functionality. If you create a schema
 * using `new Schema()` with one of these property names, Mongoose will log a warning.
 *
 * - _posts
 * - _pres
 * - collection
  * - emit
 * - errors
 * - get
 * - init
 * - isModified
 * - isNew
 * - listeners
 * - modelName
 * - on
 * - once
 * - populated
 * - prototype
 * - remove
 * - removeListener
 * - save
 * - schema
 * - toObject
 * - validate
 *
 * _NOTE:_ Use of these terms as method names is permitted, but play at your own risk, as they may be existing mongoose document methods you are stomping on.
 *
 *      const schema = new Schema(..);
 *      schema.methods.init = function () {} // potentially breaking
 */


Schema.reserved = Object.create(null);
Schema.prototype.reserved = Schema.reserved;
var reserved = Schema.reserved; // Core object

reserved['prototype'] = // EventEmitter
reserved.emit = reserved.listeners = reserved.removeListener = // document properties and functions
reserved.collection = reserved.errors = reserved.get = reserved.init = reserved.isModified = reserved.isNew = reserved.populated = reserved.remove = reserved.save = reserved.toObject = reserved.validate = 1;
reserved.collection = 1;
/**
 * Gets/sets schema paths.
 *
 * Sets a path (if arity 2)
 * Gets a path (if arity 1)
 *
 * #### Example
 *
 *     schema.path('name') // returns a SchemaType
 *     schema.path('name', Number) // changes the schemaType of `name` to Number
 *
 * @param {String} path
 * @param {Object} constructor
 * @api public
 */

Schema.prototype.path = function (path, obj) {
  // Convert to '.$' to check subpaths re: gh-6405
  var cleanPath = _pathToPositionalSyntax(path);

  if (obj === undefined) {
    var schematype = _getPath(this, path, cleanPath);

    if (schematype != null) {
      return schematype;
    } // Look for maps


    var mapPath = getMapPath(this, path);

    if (mapPath != null) {
      return mapPath;
    } // Look if a parent of this path is mixed


    schematype = this.hasMixedParent(cleanPath);

    if (schematype != null) {
      return schematype;
    } // subpaths?


    return /\.\d+\.?.*$/.test(path) ? getPositionalPath(this, path) : undefined;
  } // some path names conflict with document methods


  var firstPieceOfPath = path.split('.')[0];

  if (reserved[firstPieceOfPath] && !this.options.supressReservedKeysWarning) {
    var errorMessage = "`".concat(firstPieceOfPath, "` is a reserved schema pathname and may break some functionality. ") + 'You are allowed to use it, but use at your own risk. ' + 'To disable this warning pass `supressReservedKeysWarning` as a schema option.';
    utils.warn(errorMessage);
  }

  if (_typeof(obj) === 'object' && utils.hasUserDefinedProperty(obj, 'ref')) {
    validateRef(obj.ref, path);
  } // update the tree


  var subpaths = path.split(/\./);
  var last = subpaths.pop();
  var branch = this.tree;
  var fullPath = '';

  var _iterator4 = _createForOfIteratorHelper(subpaths),
      _step4;

  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var sub = _step4.value;
      fullPath = fullPath += (fullPath.length > 0 ? '.' : '') + sub;

      if (!branch[sub]) {
        this.nested[fullPath] = true;
        branch[sub] = {};
      }

      if (_typeof(branch[sub]) !== 'object') {
        var msg = 'Cannot set nested path `' + path + '`. ' + 'Parent path `' + fullPath + '` already set to type ' + branch[sub].name + '.';
        throw new Error(msg);
      }

      branch = branch[sub];
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }

  branch[last] = utils.clone(obj);
  this.paths[path] = this.interpretAsType(path, obj, this.options);
  var schemaType = this.paths[path];

  if (schemaType.$isSchemaMap) {
    // Maps can have arbitrary keys, so `$*` is internal shorthand for "any key"
    // The '$' is to imply this path should never be stored in MongoDB so we
    // can easily build a regexp out of this path, and '*' to imply "any key."
    var _mapPath = path + '.$*';

    this.paths[_mapPath] = schemaType.$__schemaType;
    this.mapPaths.push(this.paths[_mapPath]);
  }

  if (schemaType.$isSingleNested) {
    for (var _i3 = 0, _Object$keys = Object.keys(schemaType.schema.paths); _i3 < _Object$keys.length; _i3++) {
      var key = _Object$keys[_i3];
      this.singleNestedPaths[path + '.' + key] = schemaType.schema.paths[key];
    }

    for (var _i4 = 0, _Object$keys2 = Object.keys(schemaType.schema.singleNestedPaths); _i4 < _Object$keys2.length; _i4++) {
      var _key3 = _Object$keys2[_i4];
      this.singleNestedPaths[path + '.' + _key3] = schemaType.schema.singleNestedPaths[_key3];
    }

    for (var _i5 = 0, _Object$keys3 = Object.keys(schemaType.schema.subpaths); _i5 < _Object$keys3.length; _i5++) {
      var _key4 = _Object$keys3[_i5];
      this.singleNestedPaths[path + '.' + _key4] = schemaType.schema.subpaths[_key4];
    }

    for (var _i6 = 0, _Object$keys4 = Object.keys(schemaType.schema.nested); _i6 < _Object$keys4.length; _i6++) {
      var _key5 = _Object$keys4[_i6];
      this.singleNestedPaths[path + '.' + _key5] = 'nested';
    }

    Object.defineProperty(schemaType.schema, 'base', {
      configurable: true,
      enumerable: false,
      writable: false,
      value: this.base
    });
    schemaType.caster.base = this.base;
    this.childSchemas.push({
      schema: schemaType.schema,
      model: schemaType.caster
    });
  } else if (schemaType.$isMongooseDocumentArray) {
    Object.defineProperty(schemaType.schema, 'base', {
      configurable: true,
      enumerable: false,
      writable: false,
      value: this.base
    });
    schemaType.casterConstructor.base = this.base;
    this.childSchemas.push({
      schema: schemaType.schema,
      model: schemaType.casterConstructor
    });
  }

  if (schemaType.$isMongooseArray && schemaType.caster instanceof SchemaType) {
    var arrayPath = path;
    var _schemaType = schemaType;
    var toAdd = [];

    while (_schemaType.$isMongooseArray) {
      arrayPath = arrayPath + '.$'; // Skip arrays of document arrays

      if (_schemaType.$isMongooseDocumentArray) {
        _schemaType.$embeddedSchemaType._arrayPath = arrayPath;
        _schemaType.$embeddedSchemaType._arrayParentPath = path;
        _schemaType = _schemaType.$embeddedSchemaType.clone();
      } else {
        _schemaType.caster._arrayPath = arrayPath;
        _schemaType.caster._arrayParentPath = path;
        _schemaType = _schemaType.caster.clone();
      }

      _schemaType.path = arrayPath;
      toAdd.push(_schemaType);
    }

    for (var _i7 = 0, _toAdd = toAdd; _i7 < _toAdd.length; _i7++) {
      var _schemaType5 = _toAdd[_i7];
      this.subpaths[_schemaType5.path] = _schemaType5;
    }
  }

  if (schemaType.$isMongooseDocumentArray) {
    for (var _i8 = 0, _Object$keys5 = Object.keys(schemaType.schema.paths); _i8 < _Object$keys5.length; _i8++) {
      var _key6 = _Object$keys5[_i8];
      var _schemaType6 = schemaType.schema.paths[_key6];
      this.subpaths[path + '.' + _key6] = _schemaType6;

      if (_typeof(_schemaType6) === 'object' && _schemaType6 != null) {
        _schemaType6.$isUnderneathDocArray = true;
      }
    }

    for (var _i9 = 0, _Object$keys6 = Object.keys(schemaType.schema.subpaths); _i9 < _Object$keys6.length; _i9++) {
      var _key7 = _Object$keys6[_i9];
      var _schemaType7 = schemaType.schema.subpaths[_key7];
      this.subpaths[path + '.' + _key7] = _schemaType7;

      if (_typeof(_schemaType7) === 'object' && _schemaType7 != null) {
        _schemaType7.$isUnderneathDocArray = true;
      }
    }

    for (var _i10 = 0, _Object$keys7 = Object.keys(schemaType.schema.singleNestedPaths); _i10 < _Object$keys7.length; _i10++) {
      var _key8 = _Object$keys7[_i10];
      var _schemaType8 = schemaType.schema.singleNestedPaths[_key8];
      this.subpaths[path + '.' + _key8] = _schemaType8;

      if (_typeof(_schemaType8) === 'object' && _schemaType8 != null) {
        _schemaType8.$isUnderneathDocArray = true;
      }
    }
  }

  return this;
};
/*!
 * ignore
 */


function gatherChildSchemas(schema) {
  var childSchemas = [];

  for (var _i11 = 0, _Object$keys8 = Object.keys(schema.paths); _i11 < _Object$keys8.length; _i11++) {
    var path = _Object$keys8[_i11];
    var schematype = schema.paths[path];

    if (schematype.$isMongooseDocumentArray || schematype.$isSingleNested) {
      childSchemas.push({
        schema: schematype.schema,
        model: schematype.caster
      });
    }
  }

  return childSchemas;
}
/*!
 * ignore
 */


function _getPath(schema, path, cleanPath) {
  if (schema.paths.hasOwnProperty(path)) {
    return schema.paths[path];
  }

  if (schema.subpaths.hasOwnProperty(cleanPath)) {
    return schema.subpaths[cleanPath];
  }

  if (schema.singleNestedPaths.hasOwnProperty(cleanPath) && _typeof(schema.singleNestedPaths[cleanPath]) === 'object') {
    return schema.singleNestedPaths[cleanPath];
  }

  return null;
}
/*!
 * ignore
 */


function _pathToPositionalSyntax(path) {
  if (!/\.\d+/.test(path)) {
    return path;
  }

  return path.replace(/\.\d+\./g, '.$.').replace(/\.\d+$/, '.$');
}
/*!
 * ignore
 */


function getMapPath(schema, path) {
  if (schema.mapPaths.length === 0) {
    return null;
  }

  var _iterator5 = _createForOfIteratorHelper(schema.mapPaths),
      _step5;

  try {
    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
      var val = _step5.value;
      var _path = val.path;
      var re = new RegExp('^' + _path.replace(/\.\$\*/g, '\\.[^.]+') + '$');

      if (re.test(path)) {
        return schema.paths[_path];
      }
    }
  } catch (err) {
    _iterator5.e(err);
  } finally {
    _iterator5.f();
  }

  return null;
}
/**
 * The Mongoose instance this schema is associated with
 *
 * @property base
 * @api private
 */


Object.defineProperty(Schema.prototype, 'base', {
  configurable: true,
  enumerable: false,
  writable: true,
  value: null
});
/**
 * Converts type arguments into Mongoose Types.
 *
 * @param {String} path
 * @param {Object} obj constructor
 * @api private
 */

Schema.prototype.interpretAsType = function (path, obj, options) {
  if (obj instanceof SchemaType) {
    if (obj.path === path) {
      return obj;
    }

    var clone = obj.clone();
    clone.path = path;
    return clone;
  } // If this schema has an associated Mongoose object, use the Mongoose object's
  // copy of SchemaTypes re: gh-7158 gh-6933


  var MongooseTypes = this.base != null ? this.base.Schema.Types : Schema.Types;

  if (!utils.isPOJO(obj) && !(obj instanceof SchemaTypeOptions)) {
    var constructorName = utils.getFunctionName(obj.constructor);

    if (constructorName !== 'Object') {
      var oldObj = obj;
      obj = {};
      obj[options.typeKey] = oldObj;
    }
  } // Get the type making sure to allow keys named "type"
  // and default to mixed if not specified.
  // { type: { type: String, default: 'freshcut' } }


  var type = obj[options.typeKey] && (obj[options.typeKey] instanceof Function || options.typeKey !== 'type' || !obj.type.type) ? obj[options.typeKey] : {};
  var name;

  if (utils.isPOJO(type) || type === 'mixed') {
    return new MongooseTypes.Mixed(path, obj);
  }

  if (Array.isArray(type) || type === Array || type === 'array' || type === MongooseTypes.Array) {
    // if it was specified through { type } look for `cast`
    var cast = type === Array || type === 'array' ? obj.cast || obj.of : type[0]; // new Schema({ path: [new Schema({ ... })] })

    if (cast && cast.instanceOfSchema) {
      if (!(cast instanceof Schema)) {
        throw new TypeError('Schema for array path `' + path + '` is from a different copy of the Mongoose module. ' + 'Please make sure you\'re using the same version ' + 'of Mongoose everywhere with `npm list mongoose`. If you are still ' + 'getting this error, please add `new Schema()` around the path: ' + "".concat(path, ": new Schema(...)"));
      }

      return new MongooseTypes.DocumentArray(path, cast, obj);
    }

    if (cast && cast[options.typeKey] && cast[options.typeKey].instanceOfSchema) {
      if (!(cast[options.typeKey] instanceof Schema)) {
        throw new TypeError('Schema for array path `' + path + '` is from a different copy of the Mongoose module. ' + 'Please make sure you\'re using the same version ' + 'of Mongoose everywhere with `npm list mongoose`. If you are still ' + 'getting this error, please add `new Schema()` around the path: ' + "".concat(path, ": new Schema(...)"));
      }

      return new MongooseTypes.DocumentArray(path, cast[options.typeKey], obj, cast);
    }

    if (Array.isArray(cast)) {
      return new MongooseTypes.Array(path, this.interpretAsType(path, cast, options), obj);
    } // Handle both `new Schema({ arr: [{ subpath: String }] })` and `new Schema({ arr: [{ type: { subpath: string } }] })`


    var castFromTypeKey = cast != null && cast[options.typeKey] && (options.typeKey !== 'type' || !cast.type.type) ? cast[options.typeKey] : cast;

    if (typeof cast === 'string') {
      cast = MongooseTypes[cast.charAt(0).toUpperCase() + cast.substring(1)];
    } else if (utils.isPOJO(castFromTypeKey)) {
      if (Object.keys(castFromTypeKey).length) {
        // The `minimize` and `typeKey` options propagate to child schemas
        // declared inline, like `{ arr: [{ val: { $type: String } }] }`.
        // See gh-3560
        var childSchemaOptions = {
          minimize: options.minimize
        };

        if (options.typeKey) {
          childSchemaOptions.typeKey = options.typeKey;
        } // propagate 'strict' option to child schema


        if (options.hasOwnProperty('strict')) {
          childSchemaOptions.strict = options.strict;
        }

        if (this._userProvidedOptions.hasOwnProperty('_id')) {
          childSchemaOptions._id = this._userProvidedOptions._id;
        } else if (Schema.Types.DocumentArray.defaultOptions._id != null) {
          childSchemaOptions._id = Schema.Types.DocumentArray.defaultOptions._id;
        }

        var childSchema = new Schema(castFromTypeKey, childSchemaOptions);
        childSchema.$implicitlyCreated = true;
        return new MongooseTypes.DocumentArray(path, childSchema, obj);
      } else {
        // Special case: empty object becomes mixed
        return new MongooseTypes.Array(path, MongooseTypes.Mixed, obj);
      }
    }

    if (cast) {
      type = cast[options.typeKey] && (options.typeKey !== 'type' || !cast.type.type) ? cast[options.typeKey] : cast;

      if (Array.isArray(type)) {
        return new MongooseTypes.Array(path, this.interpretAsType(path, type, options), obj);
      }

      name = typeof type === 'string' ? type : type.schemaName || utils.getFunctionName(type); // For Jest 26+, see #10296

      if (name === 'ClockDate') {
        name = 'Date';
      }

      if (name === void 0) {
        throw new TypeError('Invalid schema configuration: ' + "Could not determine the embedded type for array `".concat(path, "`. ") + 'See https://mongoosejs.com/docs/guide.html#definition for more info on supported schema syntaxes.');
      }

      if (!MongooseTypes.hasOwnProperty(name)) {
        throw new TypeError('Invalid schema configuration: ' + "`".concat(name, "` is not a valid type within the array `").concat(path, "`.") + 'See https://bit.ly/mongoose-schematypes for a list of valid schema types.');
      }
    }

    return new MongooseTypes.Array(path, cast || MongooseTypes.Mixed, obj, options);
  }

  if (type && type.instanceOfSchema) {
    return new MongooseTypes.Subdocument(type, path, obj);
  }

  if (Buffer.isBuffer(type)) {
    name = 'Buffer';
  } else if (typeof type === 'function' || _typeof(type) === 'object') {
    name = type.schemaName || utils.getFunctionName(type);
  } else {
    name = type == null ? '' + type : type.toString();
  }

  if (name) {
    name = name.charAt(0).toUpperCase() + name.substring(1);
  } // Special case re: gh-7049 because the bson `ObjectID` class' capitalization
  // doesn't line up with Mongoose's.


  if (name === 'ObjectID') {
    name = 'ObjectId';
  } // For Jest 26+, see #10296


  if (name === 'ClockDate') {
    name = 'Date';
  }

  if (name === void 0) {
    throw new TypeError("Invalid schema configuration: `".concat(path, "` schematype definition is ") + 'invalid. See ' + 'https://mongoosejs.com/docs/guide.html#definition for more info on supported schema syntaxes.');
  }

  if (MongooseTypes[name] == null) {
    throw new TypeError("Invalid schema configuration: `".concat(name, "` is not ") + "a valid type at path `".concat(path, "`. See ") + 'https://bit.ly/mongoose-schematypes for a list of valid schema types.');
  }

  var schemaType = new MongooseTypes[name](path, obj);

  if (schemaType.$isSchemaMap) {
    createMapNestedSchemaType(this, schemaType, path, obj, options);
  }

  return schemaType;
};
/*!
 * ignore
 */


function createMapNestedSchemaType(schema, schemaType, path, obj, options) {
  var mapPath = path + '.$*';
  var _mapType = {
    type: {}
  };

  if (utils.hasUserDefinedProperty(obj, 'of')) {
    var isInlineSchema = utils.isPOJO(obj.of) && Object.keys(obj.of).length > 0 && !utils.hasUserDefinedProperty(obj.of, schema.options.typeKey);

    if (isInlineSchema) {
      _mapType = _defineProperty({}, schema.options.typeKey, new Schema(obj.of));
    } else if (utils.isPOJO(obj.of)) {
      _mapType = Object.assign({}, obj.of);
    } else {
      _mapType = _defineProperty({}, schema.options.typeKey, obj.of);
    }

    if (_mapType[schema.options.typeKey] && _mapType[schema.options.typeKey].instanceOfSchema) {
      var subdocumentSchema = _mapType[schema.options.typeKey];
      subdocumentSchema.eachPath(function (subpath, type) {
        if (type.options.select === true || type.options.select === false) {
          throw new MongooseError('Cannot use schema-level projections (`select: true` or `select: false`) within maps at path "' + path + '.' + subpath + '"');
        }
      });
    }

    if (utils.hasUserDefinedProperty(obj, 'ref')) {
      _mapType.ref = obj.ref;
    }
  }

  schemaType.$__schemaType = schema.interpretAsType(mapPath, _mapType, options);
}
/**
 * Iterates the schemas paths similar to Array#forEach.
 *
 * The callback is passed the pathname and the schemaType instance.
 *
 * #### Example:
 *
 *     const userSchema = new Schema({ name: String, registeredAt: Date });
 *     userSchema.eachPath((pathname, schematype) => {
 *       // Prints twice:
 *       // name SchemaString { ... }
 *       // registeredAt SchemaDate { ... }
 *       console.log(pathname, schematype);
 *     });
 *
 * @param {Function} fn callback function
 * @return {Schema} this
 * @api public
 */


Schema.prototype.eachPath = function (fn) {
  var keys = Object.keys(this.paths);
  var len = keys.length;

  for (var i = 0; i < len; ++i) {
    fn(keys[i], this.paths[keys[i]]);
  }

  return this;
};
/**
 * Returns an Array of path strings that are required by this schema.
 *
 * #### Example:
 *     const s = new Schema({
 *       name: { type: String, required: true },
 *       age: { type: String, required: true },
 *       notes: String
 *     });
 *     s.requiredPaths(); // [ 'age', 'name' ]
 *
 * @api public
 * @param {Boolean} invalidate refresh the cache
 * @return {Array}
 */


Schema.prototype.requiredPaths = function requiredPaths(invalidate) {
  if (this._requiredpaths && !invalidate) {
    return this._requiredpaths;
  }

  var paths = Object.keys(this.paths);
  var i = paths.length;
  var ret = [];

  while (i--) {
    var path = paths[i];

    if (this.paths[path].isRequired) {
      ret.push(path);
    }
  }

  this._requiredpaths = ret;
  return this._requiredpaths;
};
/**
 * Returns indexes from fields and schema-level indexes (cached).
 *
 * @api private
 * @return {Array}
 */


Schema.prototype.indexedPaths = function indexedPaths() {
  if (this._indexedpaths) {
    return this._indexedpaths;
  }

  this._indexedpaths = this.indexes();
  return this._indexedpaths;
};
/**
 * Returns the pathType of `path` for this schema.
 *
 * Given a path, returns whether it is a real, virtual, nested, or ad-hoc/undefined path.
 *
 * #### Example:
 *     const s = new Schema({ name: String, nested: { foo: String } });
 *     s.virtual('foo').get(() => 42);
 *     s.pathType('name'); // "real"
 *     s.pathType('nested'); // "nested"
 *     s.pathType('foo'); // "virtual"
 *     s.pathType('fail'); // "adhocOrUndefined"
 *
 * @param {String} path
 * @return {String}
 * @api public
 */


Schema.prototype.pathType = function (path) {
  // Convert to '.$' to check subpaths re: gh-6405
  var cleanPath = _pathToPositionalSyntax(path);

  if (this.paths.hasOwnProperty(path)) {
    return 'real';
  }

  if (this.virtuals.hasOwnProperty(path)) {
    return 'virtual';
  }

  if (this.nested.hasOwnProperty(path)) {
    return 'nested';
  }

  if (this.subpaths.hasOwnProperty(cleanPath) || this.subpaths.hasOwnProperty(path)) {
    return 'real';
  }

  var singleNestedPath = this.singleNestedPaths.hasOwnProperty(cleanPath) || this.singleNestedPaths.hasOwnProperty(path);

  if (singleNestedPath) {
    return singleNestedPath === 'nested' ? 'nested' : 'real';
  } // Look for maps


  var mapPath = getMapPath(this, path);

  if (mapPath != null) {
    return 'real';
  }

  if (/\.\d+\.|\.\d+$/.test(path)) {
    return getPositionalPathType(this, path);
  }

  return 'adhocOrUndefined';
};
/**
 * Returns true iff this path is a child of a mixed schema.
 *
 * @param {String} path
 * @return {Boolean}
 * @api private
 */


Schema.prototype.hasMixedParent = function (path) {
  var subpaths = path.split(/\./g);
  path = '';

  for (var i = 0; i < subpaths.length; ++i) {
    path = i > 0 ? path + '.' + subpaths[i] : subpaths[i];

    if (this.paths.hasOwnProperty(path) && this.paths[path] instanceof MongooseTypes.Mixed) {
      return this.paths[path];
    }
  }

  return null;
};
/**
 * Setup updatedAt and createdAt timestamps to documents if enabled
 *
 * @param {Boolean|Object} timestamps timestamps options
 * @api private
 */


Schema.prototype.setupTimestamp = function (timestamps) {
  return setupTimestamps(this, timestamps);
};
/*!
 * ignore. Deprecated re: #6405
 */


function getPositionalPathType(self, path) {
  var subpaths = path.split(/\.(\d+)\.|\.(\d+)$/).filter(Boolean);

  if (subpaths.length < 2) {
    return self.paths.hasOwnProperty(subpaths[0]) ? self.paths[subpaths[0]] : 'adhocOrUndefined';
  }

  var val = self.path(subpaths[0]);
  var isNested = false;

  if (!val) {
    return 'adhocOrUndefined';
  }

  var last = subpaths.length - 1;

  for (var i = 1; i < subpaths.length; ++i) {
    isNested = false;
    var subpath = subpaths[i];

    if (i === last && val && !/\D/.test(subpath)) {
      if (val.$isMongooseDocumentArray) {
        val = val.$embeddedSchemaType;
      } else if (val instanceof MongooseTypes.Array) {
        // StringSchema, NumberSchema, etc
        val = val.caster;
      } else {
        val = undefined;
      }

      break;
    } // ignore if its just a position segment: path.0.subpath


    if (!/\D/.test(subpath)) {
      // Nested array
      if (val instanceof MongooseTypes.Array && i !== last) {
        val = val.caster;
      }

      continue;
    }

    if (!(val && val.schema)) {
      val = undefined;
      break;
    }

    var type = val.schema.pathType(subpath);
    isNested = type === 'nested';
    val = val.schema.path(subpath);
  }

  self.subpaths[path] = val;

  if (val) {
    return 'real';
  }

  if (isNested) {
    return 'nested';
  }

  return 'adhocOrUndefined';
}
/*!
 * ignore
 */


function getPositionalPath(self, path) {
  getPositionalPathType(self, path);
  return self.subpaths[path];
}
/**
 * Adds a method call to the queue.
 *
 * #### Example:
 *
 *     schema.methods.print = function() { console.log(this); };
 *     schema.queue('print', []); // Print the doc every one is instantiated
 *
 *     const Model = mongoose.model('Test', schema);
 *     new Model({ name: 'test' }); // Prints '{"_id": ..., "name": "test" }'
 *
 * @param {String} name name of the document method to call later
 * @param {Array} args arguments to pass to the method
 * @api public
 */


Schema.prototype.queue = function (name, args) {
  this.callQueue.push([name, args]);
  return this;
};
/**
 * Defines a pre hook for the model.
 *
 * #### Example
 *
 *     const toySchema = new Schema({ name: String, created: Date });
 *
 *     toySchema.pre('save', function(next) {
 *       if (!this.created) this.created = new Date;
 *       next();
 *     });
 *
 *     toySchema.pre('validate', function(next) {
 *       if (this.name !== 'Woody') this.name = 'Woody';
 *       next();
 *     });
 *
 *     // Equivalent to calling `pre()` on `find`, `findOne`, `findOneAndUpdate`.
 *     toySchema.pre(/^find/, function(next) {
 *       console.log(this.getFilter());
 *     });
 *
 *     // Equivalent to calling `pre()` on `updateOne`, `findOneAndUpdate`.
 *     toySchema.pre(['updateOne', 'findOneAndUpdate'], function(next) {
 *       console.log(this.getFilter());
 *     });
 *
 *     toySchema.pre('deleteOne', function() {
 *       // Runs when you call `Toy.deleteOne()`
 *     });
 *
 *     toySchema.pre('deleteOne', { document: true }, function() {
 *       // Runs when you call `doc.deleteOne()`
 *     });
 *
 * @param {String|RegExp} The method name or regular expression to match method name
 * @param {Object} [options]
 * @param {Boolean} [options.document] If `name` is a hook for both document and query middleware, set to `true` to run on document middleware. For example, set `options.document` to `true` to apply this hook to `Document#deleteOne()` rather than `Query#deleteOne()`.
 * @param {Boolean} [options.query] If `name` is a hook for both document and query middleware, set to `true` to run on query middleware.
 * @param {Function} callback
 * @api public
 */


Schema.prototype.pre = function (name) {
  if (name instanceof RegExp) {
    var remainingArgs = Array.prototype.slice.call(arguments, 1);

    var _iterator6 = _createForOfIteratorHelper(hookNames),
        _step6;

    try {
      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
        var fn = _step6.value;

        if (name.test(fn)) {
          this.pre.apply(this, [fn].concat(remainingArgs));
        }
      }
    } catch (err) {
      _iterator6.e(err);
    } finally {
      _iterator6.f();
    }

    return this;
  }

  if (Array.isArray(name)) {
    var _remainingArgs = Array.prototype.slice.call(arguments, 1);

    var _iterator7 = _createForOfIteratorHelper(name),
        _step7;

    try {
      for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
        var el = _step7.value;
        this.pre.apply(this, [el].concat(_remainingArgs));
      }
    } catch (err) {
      _iterator7.e(err);
    } finally {
      _iterator7.f();
    }

    return this;
  }

  this.s.hooks.pre.apply(this.s.hooks, arguments);
  return this;
};
/**
 * Defines a post hook for the document
 *
 *     const schema = new Schema(..);
 *     schema.post('save', function (doc) {
 *       console.log('this fired after a document was saved');
 *     });
 *
 *     schema.post('find', function(docs) {
 *       console.log('this fired after you ran a find query');
 *     });
 *
 *     schema.post(/Many$/, function(res) {
 *       console.log('this fired after you ran `updateMany()` or `deleteMany()`');
 *     });
 *
 *     const Model = mongoose.model('Model', schema);
 *
 *     const m = new Model(..);
 *     m.save(function(err) {
 *       console.log('this fires after the `post` hook');
 *     });
 *
 *     m.find(function(err, docs) {
 *       console.log('this fires after the post find hook');
 *     });
 *
 * @param {String|RegExp} The method name or regular expression to match method name
 * @param {Object} [options]
 * @param {Boolean} [options.document] If `name` is a hook for both document and query middleware, set to `true` to run on document middleware.
 * @param {Boolean} [options.query] If `name` is a hook for both document and query middleware, set to `true` to run on query middleware.
 * @param {Function} fn callback
 * @see middleware https://mongoosejs.com/docs/middleware.html
 * @see kareem https://npmjs.org/package/kareem
 * @api public
 */


Schema.prototype.post = function (name) {
  if (name instanceof RegExp) {
    var remainingArgs = Array.prototype.slice.call(arguments, 1);

    var _iterator8 = _createForOfIteratorHelper(hookNames),
        _step8;

    try {
      for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
        var fn = _step8.value;

        if (name.test(fn)) {
          this.post.apply(this, [fn].concat(remainingArgs));
        }
      }
    } catch (err) {
      _iterator8.e(err);
    } finally {
      _iterator8.f();
    }

    return this;
  }

  if (Array.isArray(name)) {
    var _remainingArgs2 = Array.prototype.slice.call(arguments, 1);

    var _iterator9 = _createForOfIteratorHelper(name),
        _step9;

    try {
      for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
        var el = _step9.value;
        this.post.apply(this, [el].concat(_remainingArgs2));
      }
    } catch (err) {
      _iterator9.e(err);
    } finally {
      _iterator9.f();
    }

    return this;
  }

  this.s.hooks.post.apply(this.s.hooks, arguments);
  return this;
};
/**
 * Registers a plugin for this schema.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: String });
 *     s.plugin(schema => console.log(schema.path('name').path));
 *     mongoose.model('Test', s); // Prints 'name'
 *
 * @param {Function} plugin callback
 * @param {Object} [opts]
 * @see plugins
 * @api public
 */


Schema.prototype.plugin = function (fn, opts) {
  if (typeof fn !== 'function') {
    throw new Error('First param to `schema.plugin()` must be a function, ' + 'got "' + _typeof(fn) + '"');
  }

  if (opts && opts.deduplicate) {
    var _iterator10 = _createForOfIteratorHelper(this.plugins),
        _step10;

    try {
      for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
        var plugin = _step10.value;

        if (plugin.fn === fn) {
          return this;
        }
      }
    } catch (err) {
      _iterator10.e(err);
    } finally {
      _iterator10.f();
    }
  }

  this.plugins.push({
    fn: fn,
    opts: opts
  });
  fn(this, opts);
  return this;
};
/**
 * Adds an instance method to documents constructed from Models compiled from this schema.
 *
 * #### Example
 *
 *     const schema = kittySchema = new Schema(..);
 *
 *     schema.method('meow', function () {
 *       console.log('meeeeeoooooooooooow');
 *     })
 *
 *     const Kitty = mongoose.model('Kitty', schema);
 *
 *     const fizz = new Kitty;
 *     fizz.meow(); // meeeeeooooooooooooow
 *
 * If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.
 *
 *     schema.method({
 *         purr: function () {}
 *       , scratch: function () {}
 *     });
 *
 *     // later
 *     fizz.purr();
 *     fizz.scratch();
 *
 * NOTE: `Schema.method()` adds instance methods to the `Schema.methods` object. You can also add instance methods directly to the `Schema.methods` object as seen in the [guide](/docs/guide.html#methods)
 *
 * @param {String|Object} method name
 * @param {Function} [fn]
 * @api public
 */


Schema.prototype.method = function (name, fn, options) {
  if (typeof name !== 'string') {
    for (var i in name) {
      this.methods[i] = name[i];
      this.methodOptions[i] = utils.clone(options);
    }
  } else {
    this.methods[name] = fn;
    this.methodOptions[name] = utils.clone(options);
  }

  return this;
};
/**
 * Adds static "class" methods to Models compiled from this schema.
 *
 * #### Example
 *
 *     const schema = new Schema(..);
 *     // Equivalent to `schema.statics.findByName = function(name) {}`;
 *     schema.static('findByName', function(name) {
 *       return this.find({ name: name });
 *     });
 *
 *     const Drink = mongoose.model('Drink', schema);
 *     await Drink.findByName('LaCroix');
 *
 * If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as statics.
 *
 * @param {String|Object} name
 * @param {Function} [fn]
 * @api public
 * @see Statics /docs/guide.html#statics
 */


Schema.prototype["static"] = function (name, fn) {
  if (typeof name !== 'string') {
    for (var i in name) {
      this.statics[i] = name[i];
    }
  } else {
    this.statics[name] = fn;
  }

  return this;
};
/**
 * Defines an index (most likely compound) for this schema.
 *
 * #### Example
 *
 *     schema.index({ first: 1, last: -1 })
 *
 * @param {Object} fields
 * @param {Object} [options] Options to pass to [MongoDB driver's `createIndex()` function](https://mongodb.github.io/node-mongodb-native/2.0/api/Collection.html#createIndex)
 * @param {String | number} [options.expires=null] Mongoose-specific syntactic sugar, uses [ms](https://www.npmjs.com/package/ms) to convert `expires` option into seconds for the `expireAfterSeconds` in the above link.
 * @api public
 */


Schema.prototype.index = function (fields, options) {
  fields || (fields = {});
  options || (options = {});

  if (options.expires) {
    utils.expires(options);
  }

  this._indexes.push([fields, options]);

  return this;
};
/**
 * Sets a schema option.
 *
 * #### Example
 *
 *     schema.set('strict'); // 'true' by default
 *     schema.set('strict', false); // Sets 'strict' to false
 *     schema.set('strict'); // 'false'
 *
 * @param {String} key option name
 * @param {Object} [value] if not passed, the current option value is returned
 * @see Schema ./
 * @api public
 */


Schema.prototype.set = function (key, value, _tags) {
  if (arguments.length === 1) {
    return this.options[key];
  }

  switch (key) {
    case 'read':
      this.options[key] = readPref(value, _tags);
      this._userProvidedOptions[key] = this.options[key];
      break;

    case 'timestamps':
      this.setupTimestamp(value);
      this.options[key] = value;
      this._userProvidedOptions[key] = this.options[key];
      break;

    case '_id':
      this.options[key] = value;
      this._userProvidedOptions[key] = this.options[key];

      if (value && !this.paths['_id']) {
        addAutoId(this);
      } else if (!value && this.paths['_id'] != null && this.paths['_id'].auto) {
        this.remove('_id');
      }

      break;

    default:
      this.options[key] = value;
      this._userProvidedOptions[key] = this.options[key];
      break;
  }

  return this;
};
/**
 * Gets a schema option.
 *
 * #### Example:
 *
 *     schema.get('strict'); // true
 *     schema.set('strict', false);
 *     schema.get('strict'); // false
 *
 * @param {String} key option name
 * @api public
 * @return {Any} the option's value
 */


Schema.prototype.get = function (key) {
  return this.options[key];
};
/**
 * The allowed index types
 *
 * @receiver Schema
 * @static indexTypes
 * @api public
 */


var indexTypes = '2d 2dsphere hashed text'.split(' ');
Object.defineProperty(Schema, 'indexTypes', {
  get: function get() {
    return indexTypes;
  },
  set: function set() {
    throw new Error('Cannot overwrite Schema.indexTypes');
  }
});
/**
 * Returns a list of indexes that this schema declares, via `schema.index()` or by `index: true` in a path's options.
 * Indexes are expressed as an array `[spec, options]`.
 *
 * #### Example:
 *
 *     const userSchema = new Schema({
 *       email: { type: String, required: true, unique: true },
 *       registeredAt: { type: Date, index: true }
 *     });
 *
 *     // [ [ { email: 1 }, { unique: true, background: true } ],
 *     //   [ { registeredAt: 1 }, { background: true } ] ]
 *     userSchema.indexes();
 *
 * [Plugins](/docs/plugins.html) can use the return value of this function to modify a schema's indexes.
 * For example, the below plugin makes every index unique by default.
 *
 *     function myPlugin(schema) {
 *       for (const index of schema.indexes()) {
 *         if (index[1].unique === undefined) {
 *           index[1].unique = true;
 *         }
 *       }
 *     }
 *
 * @api public
 * @return {Array} list of indexes defined in the schema
 */

Schema.prototype.indexes = function () {
  return getIndexes(this);
};
/**
 * Creates a virtual type with the given name.
 *
 * @param {String} name
 * @param {Object} [options]
 * @param {String|Model} [options.ref] model name or model instance. Marks this as a [populate virtual](/docs/populate.html#populate-virtuals).
 * @param {String|Function} [options.localField] Required for populate virtuals. See [populate virtual docs](/docs/populate.html#populate-virtuals) for more information.
 * @param {String|Function} [options.foreignField] Required for populate virtuals. See [populate virtual docs](/docs/populate.html#populate-virtuals) for more information.
 * @param {Boolean|Function} [options.justOne=false] Only works with populate virtuals. If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), will be a single doc or `null`. Otherwise, the populate virtual will be an array.
 * @param {Boolean} [options.count=false] Only works with populate virtuals. If [truthy](https://masteringjs.io/tutorials/fundamentals/truthy), this populate virtual will contain the number of documents rather than the documents themselves when you `populate()`.
 * @param {Function|null} [options.get=null] Adds a [getter](/docs/tutorials/getters-setters.html) to this virtual to transform the populated doc.
 * @return {VirtualType}
 */


Schema.prototype.virtual = function (name, options) {
  if (name instanceof VirtualType || getConstructorName(name) === 'VirtualType') {
    return this.virtual(name.path, name.options);
  }

  options = new VirtualOptions(options);

  if (utils.hasUserDefinedProperty(options, ['ref', 'refPath'])) {
    if (options.localField == null) {
      throw new Error('Reference virtuals require `localField` option');
    }

    if (options.foreignField == null) {
      throw new Error('Reference virtuals require `foreignField` option');
    }

    this.pre('init', function (obj) {
      if (mpath.has(name, obj)) {
        var _v = mpath.get(name, obj);

        if (!this.$$populatedVirtuals) {
          this.$$populatedVirtuals = {};
        }

        if (options.justOne || options.count) {
          this.$$populatedVirtuals[name] = Array.isArray(_v) ? _v[0] : _v;
        } else {
          this.$$populatedVirtuals[name] = Array.isArray(_v) ? _v : _v == null ? [] : [_v];
        }

        mpath.unset(name, obj);
      }
    });
    var virtual = this.virtual(name);
    virtual.options = options;
    virtual.set(function (_v) {
      if (!this.$$populatedVirtuals) {
        this.$$populatedVirtuals = {};
      }

      if (options.justOne || options.count) {
        this.$$populatedVirtuals[name] = Array.isArray(_v) ? _v[0] : _v;

        if (_typeof(this.$$populatedVirtuals[name]) !== 'object') {
          this.$$populatedVirtuals[name] = options.count ? _v : null;
        }
      } else {
        this.$$populatedVirtuals[name] = Array.isArray(_v) ? _v : _v == null ? [] : [_v];
        this.$$populatedVirtuals[name] = this.$$populatedVirtuals[name].filter(function (doc) {
          return doc && _typeof(doc) === 'object';
        });
      }
    });

    if (typeof options.get === 'function') {
      virtual.get(options.get);
    } // Workaround for gh-8198: if virtual is under document array, make a fake
    // virtual. See gh-8210


    var _parts = name.split('.');

    var cur = _parts[0];

    for (var i = 0; i < _parts.length - 1; ++i) {
      if (this.paths[cur] != null && this.paths[cur].$isMongooseDocumentArray) {
        var remnant = _parts.slice(i + 1).join('.');

        this.paths[cur].schema.virtual(remnant, options);
        break;
      }

      cur += '.' + _parts[i + 1];
    }

    return virtual;
  }

  var virtuals = this.virtuals;
  var parts = name.split('.');

  if (this.pathType(name) === 'real') {
    throw new Error('Virtual path "' + name + '"' + ' conflicts with a real path in the schema');
  }

  virtuals[name] = parts.reduce(function (mem, part, i) {
    mem[part] || (mem[part] = i === parts.length - 1 ? new VirtualType(options, name) : {});
    return mem[part];
  }, this.tree);
  return virtuals[name];
};
/**
 * Returns the virtual type with the given `name`.
 *
 * @param {String} name
 * @return {VirtualType}
 */


Schema.prototype.virtualpath = function (name) {
  return this.virtuals.hasOwnProperty(name) ? this.virtuals[name] : null;
};
/**
 * Removes the given `path` (or [`paths`]).
 *
 * #### Example:
 *
 *     const schema = new Schema({ name: String, age: Number });
 *     schema.remove('name');
 *     schema.path('name'); // Undefined
 *     schema.path('age'); // SchemaNumber { ... }
 *
 * @param {String|Array} path
 * @return {Schema} the Schema instance
 * @api public
 */


Schema.prototype.remove = function (path) {
  if (typeof path === 'string') {
    path = [path];
  }

  if (Array.isArray(path)) {
    path.forEach(function (name) {
      if (this.path(name) == null && !this.nested[name]) {
        return;
      }

      if (this.nested[name]) {
        var allKeys = Object.keys(this.paths).concat(Object.keys(this.nested));

        var _iterator11 = _createForOfIteratorHelper(allKeys),
            _step11;

        try {
          for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
            var _path2 = _step11.value;

            if (_path2.startsWith(name + '.')) {
              delete this.paths[_path2];
              delete this.nested[_path2];

              _deletePath(this, _path2);
            }
          }
        } catch (err) {
          _iterator11.e(err);
        } finally {
          _iterator11.f();
        }

        delete this.nested[name];

        _deletePath(this, name);

        return;
      }

      delete this.paths[name];

      _deletePath(this, name);
    }, this);
  }

  return this;
};
/*!
 * ignore
 */


function _deletePath(schema, name) {
  var pieces = name.split('.');
  var last = pieces.pop();
  var branch = schema.tree;

  var _iterator12 = _createForOfIteratorHelper(pieces),
      _step12;

  try {
    for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
      var piece = _step12.value;
      branch = branch[piece];
    }
  } catch (err) {
    _iterator12.e(err);
  } finally {
    _iterator12.f();
  }

  delete branch[last];
}
/**
 * Loads an ES6 class into a schema. Maps [setters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set) + [getters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get), [static methods](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/static),
 * and [instance methods](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes#Class_body_and_method_definitions)
 * to schema [virtuals](/docs/guide.html#virtuals),
 * [statics](/docs/guide.html#statics), and
 * [methods](/docs/guide.html#methods).
 *
 * #### Example:
 *
 * ```javascript
 * const md5 = require('md5');
 * const userSchema = new Schema({ email: String });
 * class UserClass {
 *   // `gravatarImage` becomes a virtual
 *   get gravatarImage() {
 *     const hash = md5(this.email.toLowerCase());
 *     return `https://www.gravatar.com/avatar/${hash}`;
 *   }
 *
 *   // `getProfileUrl()` becomes a document method
 *   getProfileUrl() {
 *     return `https://mysite.com/${this.email}`;
 *   }
 *
 *   // `findByEmail()` becomes a static
 *   static findByEmail(email) {
 *     return this.findOne({ email });
 *   }
 * }
 *
 * // `schema` will now have a `gravatarImage` virtual, a `getProfileUrl()` method,
 * // and a `findByEmail()` static
 * userSchema.loadClass(UserClass);
 * ```
 *
 * @param {Function} model
 * @param {Boolean} [virtualsOnly] if truthy, only pulls virtuals from the class, not methods or statics
 */


Schema.prototype.loadClass = function (model, virtualsOnly) {
  if (model === Object.prototype || model === Function.prototype || model.prototype.hasOwnProperty('$isMongooseModelPrototype')) {
    return this;
  }

  this.loadClass(Object.getPrototypeOf(model), virtualsOnly); // Add static methods

  if (!virtualsOnly) {
    Object.getOwnPropertyNames(model).forEach(function (name) {
      if (name.match(/^(length|name|prototype|constructor|__proto__)$/)) {
        return;
      }

      var prop = Object.getOwnPropertyDescriptor(model, name);

      if (prop.hasOwnProperty('value')) {
        this["static"](name, prop.value);
      }
    }, this);
  } // Add methods and virtuals


  Object.getOwnPropertyNames(model.prototype).forEach(function (name) {
    if (name.match(/^(constructor)$/)) {
      return;
    }

    var method = Object.getOwnPropertyDescriptor(model.prototype, name);

    if (!virtualsOnly) {
      if (typeof method.value === 'function') {
        this.method(name, method.value);
      }
    }

    if (typeof method.get === 'function') {
      if (this.virtuals[name]) {
        this.virtuals[name].getters = [];
      }

      this.virtual(name).get(method.get);
    }

    if (typeof method.set === 'function') {
      if (this.virtuals[name]) {
        this.virtuals[name].setters = [];
      }

      this.virtual(name).set(method.set);
    }
  }, this);
  return this;
};
/*!
 * ignore
 */


Schema.prototype._getSchema = function (path) {
  var _this = this;

  var pathschema = _this.path(path);

  var resultPath = [];

  if (pathschema) {
    pathschema.$fullPath = path;
    return pathschema;
  }

  function search(parts, schema) {
    var p = parts.length + 1;
    var foundschema;
    var trypath;

    while (p--) {
      trypath = parts.slice(0, p).join('.');
      foundschema = schema.path(trypath);

      if (foundschema) {
        resultPath.push(trypath);

        if (foundschema.caster) {
          // array of Mixed?
          if (foundschema.caster instanceof MongooseTypes.Mixed) {
            foundschema.caster.$fullPath = resultPath.join('.');
            return foundschema.caster;
          } // Now that we found the array, we need to check if there
          // are remaining document paths to look up for casting.
          // Also we need to handle array.$.path since schema.path
          // doesn't work for that.
          // If there is no foundschema.schema we are dealing with
          // a path like array.$


          if (p !== parts.length) {
            if (foundschema.schema) {
              var ret = void 0;

              if (parts[p] === '$' || isArrayFilter(parts[p])) {
                if (p + 1 === parts.length) {
                  // comments.$
                  return foundschema;
                } // comments.$.comments.$.title


                ret = search(parts.slice(p + 1), foundschema.schema);

                if (ret) {
                  ret.$isUnderneathDocArray = ret.$isUnderneathDocArray || !foundschema.schema.$isSingleNested;
                }

                return ret;
              } // this is the last path of the selector


              ret = search(parts.slice(p), foundschema.schema);

              if (ret) {
                ret.$isUnderneathDocArray = ret.$isUnderneathDocArray || !foundschema.schema.$isSingleNested;
              }

              return ret;
            }
          }
        } else if (foundschema.$isSchemaMap) {
          if (p >= parts.length) {
            return foundschema;
          } // Any path in the map will be an instance of the map's embedded schematype


          if (p + 1 >= parts.length) {
            return foundschema.$__schemaType;
          }

          var _ret = search(parts.slice(p + 1), foundschema.$__schemaType.schema);

          return _ret;
        }

        foundschema.$fullPath = resultPath.join('.');
        return foundschema;
      }
    }
  } // look for arrays


  var parts = path.split('.');

  for (var i = 0; i < parts.length; ++i) {
    if (parts[i] === '$' || isArrayFilter(parts[i])) {
      // Re: gh-5628, because `schema.path()` doesn't take $ into account.
      parts[i] = '0';
    }
  }

  return search(parts, _this);
};
/*!
 * ignore
 */


Schema.prototype._getPathType = function (path) {
  var _this = this;

  var pathschema = _this.path(path);

  if (pathschema) {
    return 'real';
  }

  function search(parts, schema) {
    var p = parts.length + 1,
        foundschema,
        trypath;

    while (p--) {
      trypath = parts.slice(0, p).join('.');
      foundschema = schema.path(trypath);

      if (foundschema) {
        if (foundschema.caster) {
          // array of Mixed?
          if (foundschema.caster instanceof MongooseTypes.Mixed) {
            return {
              schema: foundschema,
              pathType: 'mixed'
            };
          } // Now that we found the array, we need to check if there
          // are remaining document paths to look up for casting.
          // Also we need to handle array.$.path since schema.path
          // doesn't work for that.
          // If there is no foundschema.schema we are dealing with
          // a path like array.$


          if (p !== parts.length && foundschema.schema) {
            if (parts[p] === '$' || isArrayFilter(parts[p])) {
              if (p === parts.length - 1) {
                return {
                  schema: foundschema,
                  pathType: 'nested'
                };
              } // comments.$.comments.$.title


              return search(parts.slice(p + 1), foundschema.schema);
            } // this is the last path of the selector


            return search(parts.slice(p), foundschema.schema);
          }

          return {
            schema: foundschema,
            pathType: foundschema.$isSingleNested ? 'nested' : 'array'
          };
        }

        return {
          schema: foundschema,
          pathType: 'real'
        };
      } else if (p === parts.length && schema.nested[trypath]) {
        return {
          schema: schema,
          pathType: 'nested'
        };
      }
    }

    return {
      schema: foundschema || schema,
      pathType: 'undefined'
    };
  } // look for arrays


  return search(path.split('.'), _this);
};
/*!
 * ignore
 */


function isArrayFilter(piece) {
  return piece.startsWith('$[') && piece.endsWith(']');
}
/*!
 * Called by `compile()` _right before_ compiling. Good for making any changes to
 * the schema that should respect options set by plugins, like `id`
 */


Schema.prototype._preCompile = function _preCompile() {
  idGetter(this);
};
/*!
 * Module exports.
 */


module.exports = exports = Schema; // require down here because of reference issues

/**
 * The various built-in Mongoose Schema Types.
 *
 * #### Example:
 *
 *     const mongoose = require('mongoose');
 *     const ObjectId = mongoose.Schema.Types.ObjectId;
 *
 * #### Types:
 *
 * - [String](/docs/schematypes.html#strings)
 * - [Number](/docs/schematypes.html#numbers)
 * - [Boolean](/docs/schematypes.html#booleans) | Bool
 * - [Array](/docs/schematypes.html#arrays)
 * - [Buffer](/docs/schematypes.html#buffers)
 * - [Date](/docs/schematypes.html#dates)
 * - [ObjectId](/docs/schematypes.html#objectids) | Oid
 * - [Mixed](/docs/schematypes.html#mixed)
 *
 * Using this exposed access to the `Mixed` SchemaType, we can use them in our schema.
 *
 *     const Mixed = mongoose.Schema.Types.Mixed;
 *     new mongoose.Schema({ _user: Mixed })
 *
 * @api public
 */

Schema.Types = MongooseTypes = __webpack_require__(5251);
/*!
 * ignore
 */

exports.ObjectId = MongooseTypes.ObjectId;

/***/ }),

/***/ 3617:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var CastError = __webpack_require__(1795);

var EventEmitter = (__webpack_require__(9620).EventEmitter);

var ObjectExpectedError = __webpack_require__(4107);

var SchemaSubdocumentOptions = __webpack_require__(5446);

var SchemaType = __webpack_require__(4289);

var $exists = __webpack_require__(8702);

var castToNumber = (__webpack_require__(1521)/* .castToNumber */ .W);

var discriminator = __webpack_require__(9181);

var geospatial = __webpack_require__(5008);

var getConstructor = __webpack_require__(8413);

var handleIdOption = __webpack_require__(9691);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var utils = __webpack_require__(6872);

var Subdocument;
module.exports = SubdocumentPath;
/**
 * Single nested subdocument SchemaType constructor.
 *
 * @param {Schema} schema
 * @param {String} path
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function SubdocumentPath(schema, path, options) {
  var schemaTypeIdOption = SubdocumentPath.defaultOptions && SubdocumentPath.defaultOptions._id;

  if (schemaTypeIdOption != null) {
    options = options || {};
    options._id = schemaTypeIdOption;
  }

  schema = handleIdOption(schema, options);
  this.caster = _createConstructor(schema);
  this.caster.path = path;
  this.caster.prototype.$basePath = path;
  this.schema = schema;
  this.$isSingleNested = true;
  SchemaType.call(this, path, options, 'Embedded');
}
/*!
 * ignore
 */


SubdocumentPath.prototype = Object.create(SchemaType.prototype);
SubdocumentPath.prototype.constructor = SubdocumentPath;
SubdocumentPath.prototype.OptionsConstructor = SchemaSubdocumentOptions;
/*!
 * ignore
 */

function _createConstructor(schema, baseClass) {
  // lazy load
  Subdocument || (Subdocument = __webpack_require__(2591));

  var _embedded = function SingleNested(value, path, parent) {
    this.$__parent = parent;
    Subdocument.apply(this, arguments);

    if (parent == null) {
      return;
    }

    this.$session(parent.$session());
  };

  schema._preCompile();

  var proto = baseClass != null ? baseClass.prototype : Subdocument.prototype;
  _embedded.prototype = Object.create(proto);

  _embedded.prototype.$__setSchema(schema);

  _embedded.prototype.constructor = _embedded;
  _embedded.schema = schema;
  _embedded.$isSingleNested = true;
  _embedded.events = new EventEmitter();

  _embedded.prototype.toBSON = function () {
    return this.toObject(internalToObjectOptions);
  }; // apply methods


  for (var i in schema.methods) {
    _embedded.prototype[i] = schema.methods[i];
  } // apply statics


  for (var _i in schema.statics) {
    _embedded[_i] = schema.statics[_i];
  }

  for (var _i2 in EventEmitter.prototype) {
    _embedded[_i2] = EventEmitter.prototype[_i2];
  }

  return _embedded;
}
/*!
 * Special case for when users use a common location schema to represent
 * locations for use with $geoWithin.
 * https://docs.mongodb.org/manual/reference/operator/query/geoWithin/
 *
 * @param {Object} val
 * @api private
 */


SubdocumentPath.prototype.$conditionalHandlers.$geoWithin = function handle$geoWithin(val) {
  return {
    $geometry: this.castForQuery(val.$geometry)
  };
};
/*!
 * ignore
 */


SubdocumentPath.prototype.$conditionalHandlers.$near = SubdocumentPath.prototype.$conditionalHandlers.$nearSphere = geospatial.cast$near;
SubdocumentPath.prototype.$conditionalHandlers.$within = SubdocumentPath.prototype.$conditionalHandlers.$geoWithin = geospatial.cast$within;
SubdocumentPath.prototype.$conditionalHandlers.$geoIntersects = geospatial.cast$geoIntersects;
SubdocumentPath.prototype.$conditionalHandlers.$minDistance = castToNumber;
SubdocumentPath.prototype.$conditionalHandlers.$maxDistance = castToNumber;
SubdocumentPath.prototype.$conditionalHandlers.$exists = $exists;
/**
 * Casts contents
 *
 * @param {Object} value
 * @api private
 */

SubdocumentPath.prototype.cast = function (val, doc, init, priorVal, options) {
  if (val && val.$isSingleNested && val.parent === doc) {
    return val;
  }

  if (val != null && (_typeof(val) !== 'object' || Array.isArray(val))) {
    throw new ObjectExpectedError(this.path, val);
  }

  var Constructor = getConstructor(this.caster, val);
  var subdoc; // Only pull relevant selected paths and pull out the base path

  var parentSelected = doc && doc.$__ && doc.$__.selected || {};
  var path = this.path;
  var selected = Object.keys(parentSelected).reduce(function (obj, key) {
    if (key.startsWith(path + '.')) {
      obj = obj || {};
      obj[key.substring(path.length + 1)] = parentSelected[key];
    }

    return obj;
  }, null);
  options = Object.assign({}, options, {
    priorDoc: priorVal
  });

  if (init) {
    subdoc = new Constructor(void 0, selected, doc);
    subdoc.$init(val);
  } else {
    if (Object.keys(val).length === 0) {
      return new Constructor({}, selected, doc, undefined, options);
    }

    return new Constructor(val, selected, doc, undefined, options);
  }

  return subdoc;
};
/**
 * Casts contents for query
 *
 * @param {string} [$conditional] optional query operator (like `$eq` or `$in`)
 * @param {any} value
 * @api private
 */


SubdocumentPath.prototype.castForQuery = function ($conditional, val, options) {
  var handler;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new Error('Can\'t use ' + $conditional);
    }

    return handler.call(this, val);
  }

  val = $conditional;

  if (val == null) {
    return val;
  }

  if (this.options.runSetters) {
    val = this._applySetters(val);
  }

  var Constructor = getConstructor(this.caster, val);
  var overrideStrict = options != null && options.strict != null ? options.strict : void 0;

  try {
    val = new Constructor(val, overrideStrict);
  } catch (error) {
    // Make sure we always wrap in a CastError (gh-6803)
    if (!(error instanceof CastError)) {
      throw new CastError('Embedded', val, this.path, error, this);
    }

    throw error;
  }

  return val;
};
/**
 * Async validation on this single nested doc.
 *
 * @api private
 */


SubdocumentPath.prototype.doValidate = function (value, fn, scope, options) {
  var Constructor = getConstructor(this.caster, value);

  if (value && !(value instanceof Constructor)) {
    value = new Constructor(value, null, scope != null && scope.$__ != null ? scope : null);
  }

  if (options && options.skipSchemaValidators) {
    if (!value) {
      return fn(null);
    }

    return value.validate(fn);
  }

  SchemaType.prototype.doValidate.call(this, value, function (error) {
    if (error) {
      return fn(error);
    }

    if (!value) {
      return fn(null);
    }

    value.validate(fn);
  }, scope, options);
};
/**
 * Synchronously validate this single nested doc
 *
 * @api private
 */


SubdocumentPath.prototype.doValidateSync = function (value, scope, options) {
  if (!options || !options.skipSchemaValidators) {
    var schemaTypeError = SchemaType.prototype.doValidateSync.call(this, value, scope);

    if (schemaTypeError) {
      return schemaTypeError;
    }
  }

  if (!value) {
    return;
  }

  return value.validateSync();
};
/**
 * Adds a discriminator to this single nested subdocument.
 *
 * #### Example:
 *     const shapeSchema = Schema({ name: String }, { discriminatorKey: 'kind' });
 *     const schema = Schema({ shape: shapeSchema });
 *
 *     const singleNestedPath = parentSchema.path('shape');
 *     singleNestedPath.discriminator('Circle', Schema({ radius: Number }));
 *
 * @param {String} name
 * @param {Schema} schema fields to add to the schema for instances of this sub-class
 * @param {Object|string} [options] If string, same as `options.value`.
 * @param {String} [options.value] the string stored in the `discriminatorKey` property. If not specified, Mongoose uses the `name` parameter.
 * @param {Boolean} [options.clone=true] By default, `discriminator()` clones the given `schema`. Set to `false` to skip cloning.
 * @return {Function} the constructor Mongoose will use for creating instances of this discriminator model
 * @see discriminators /docs/discriminators.html
 * @api public
 */


SubdocumentPath.prototype.discriminator = function (name, schema, options) {
  options = options || {};
  var value = utils.isPOJO(options) ? options.value : options;
  var clone = typeof options.clone === 'boolean' ? options.clone : true;

  if (schema.instanceOfSchema && clone) {
    schema = schema.clone();
  }

  schema = discriminator(this.caster, name, schema, value);
  this.caster.discriminators[name] = _createConstructor(schema, this.caster);
  return this.caster.discriminators[name];
};
/**
 * Sets a default option for all SubdocumentPath instances.
 *
 * #### Example:
 *
 *     // Make all numbers have option `min` equal to 0.
 *     mongoose.Schema.Embedded.set('required', true);
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */


SubdocumentPath.defaultOptions = {};
SubdocumentPath.set = SchemaType.set;
/*!
 * ignore
 */

SubdocumentPath.prototype.clone = function () {
  var options = Object.assign({}, this.options);
  var schematype = new this.constructor(this.schema, this.path, options);
  schematype.validators = this.validators.slice();

  if (this.requiredValidator !== undefined) {
    schematype.requiredValidator = this.requiredValidator;
  }

  schematype.caster.discriminators = Object.assign({}, this.caster.discriminators);
  return schematype;
};

/***/ }),

/***/ 94:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var $exists = __webpack_require__(8702);

var $type = __webpack_require__(3053);

var MongooseError = __webpack_require__(5202);

var SchemaArrayOptions = __webpack_require__(4756);

var SchemaType = __webpack_require__(4289);

var CastError = SchemaType.CastError;

var Mixed = __webpack_require__(3861);

var arrayDepth = __webpack_require__(6069);

var cast = __webpack_require__(6787);

var isOperator = __webpack_require__(9627);

var util = __webpack_require__(161);

var utils = __webpack_require__(6872);

var castToNumber = (__webpack_require__(1521)/* .castToNumber */ .W);

var geospatial = __webpack_require__(5008);

var getDiscriminatorByValue = __webpack_require__(7291);

var MongooseArray;
var EmbeddedDoc;
var isNestedArraySymbol = Symbol('mongoose#isNestedArray');
var emptyOpts = Object.freeze({});
/**
 * Array SchemaType constructor
 *
 * @param {String} key
 * @param {SchemaType} cast
 * @param {Object} options
 * @param {Object} schemaOptions
 * @inherits SchemaType
 * @api public
 */

function SchemaArray(key, cast, options, schemaOptions) {
  // lazy load
  EmbeddedDoc || (EmbeddedDoc = (__webpack_require__(8941).Embedded));
  var typeKey = 'type';

  if (schemaOptions && schemaOptions.typeKey) {
    typeKey = schemaOptions.typeKey;
  }

  this.schemaOptions = schemaOptions;

  if (cast) {
    var castOptions = {};

    if (utils.isPOJO(cast)) {
      if (cast[typeKey]) {
        // support { type: Woot }
        castOptions = utils.clone(cast); // do not alter user arguments

        delete castOptions[typeKey];
        cast = cast[typeKey];
      } else {
        cast = Mixed;
      }
    }

    if (options != null && options.ref != null && castOptions.ref == null) {
      castOptions.ref = options.ref;
    }

    if (cast === Object) {
      cast = Mixed;
    } // support { type: 'String' }


    var name = typeof cast === 'string' ? cast : utils.getFunctionName(cast);

    var Types = __webpack_require__(5251);

    var caster = Types.hasOwnProperty(name) ? Types[name] : cast;
    this.casterConstructor = caster;

    if (this.casterConstructor instanceof SchemaArray) {
      this.casterConstructor[isNestedArraySymbol] = true;
    }

    if (typeof caster === 'function' && !caster.$isArraySubdocument && !caster.$isSchemaMap) {
      var path = this.caster instanceof EmbeddedDoc ? null : key;
      this.caster = new caster(path, castOptions);
    } else {
      this.caster = caster;

      if (!(this.caster instanceof EmbeddedDoc)) {
        this.caster.path = key;
      }
    }

    this.$embeddedSchemaType = this.caster;
  }

  this.$isMongooseArray = true;
  SchemaType.call(this, key, options, 'Array');
  var defaultArr;
  var fn;

  if (this.defaultValue != null) {
    defaultArr = this.defaultValue;
    fn = typeof defaultArr === 'function';
  }

  if (!('defaultValue' in this) || this.defaultValue !== void 0) {
    var defaultFn = function defaultFn() {
      // Leave it up to `cast()` to convert the array
      return fn ? defaultArr.call(this) : defaultArr != null ? [].concat(defaultArr) : [];
    };

    defaultFn.$runBeforeSetters = !fn;
    this["default"](defaultFn);
  }
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaArray.schemaName = 'Array';
/**
 * Options for all arrays.
 *
 * - `castNonArrays`: `true` by default. If `false`, Mongoose will throw a CastError when a value isn't an array. If `true`, Mongoose will wrap the provided value in an array before casting.
 *
 * @static options
 * @api public
 */

SchemaArray.options = {
  castNonArrays: true
};
/*!
 * ignore
 */

SchemaArray.defaultOptions = {};
/**
 * Sets a default option for all Array instances.
 *
 * #### Example:
 *
 *     // Make all Array instances have `required` of true by default.
 *     mongoose.Schema.Array.set('required', true);
 *
 *     const User = mongoose.model('User', new Schema({ test: Array }));
 *     new User({ }).validateSync().errors.test.message; // Path `test` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @api public
 */

SchemaArray.set = SchemaType.set;
/*!
 * Inherits from SchemaType.
 */

SchemaArray.prototype = Object.create(SchemaType.prototype);
SchemaArray.prototype.constructor = SchemaArray;
SchemaArray.prototype.OptionsConstructor = SchemaArrayOptions;
/*!
 * ignore
 */

SchemaArray._checkRequired = SchemaType.prototype.checkRequired;
/**
 * Override the function the required validator uses to check whether an array
 * passes the `required` check.
 *
 * #### Example:
 *
 *     // Require non-empty array to pass `required` check
 *     mongoose.Schema.Types.Array.checkRequired(v => Array.isArray(v) && v.length);
 *
 *     const M = mongoose.model({ arr: { type: Array, required: true } });
 *     new M({ arr: [] }).validateSync(); // `null`, validation fails!
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @api public
 */

SchemaArray.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies the `required` validator.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

SchemaArray.prototype.checkRequired = function checkRequired(value, doc) {
  if (_typeof(value) === 'object' && SchemaType._isRef(this, value, doc, true)) {
    return !!value;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : SchemaArray.checkRequired();

  return _checkRequired(value);
};
/**
 * Adds an enum validator if this is an array of strings or numbers. Equivalent to
 * `SchemaString.prototype.enum()` or `SchemaNumber.prototype.enum()`
 *
 * @param {String|Object} [args...] enumeration values
 * @return {SchemaArray} this
 */


SchemaArray.prototype["enum"] = function () {
  var arr = this;

  while (true) {
    var instance = arr && arr.caster && arr.caster.instance;

    if (instance === 'Array') {
      arr = arr.caster;
      continue;
    }

    if (instance !== 'String' && instance !== 'Number') {
      throw new Error('`enum` can only be set on an array of strings or numbers ' + ', not ' + instance);
    }

    break;
  }

  var enumArray = arguments;

  if (!Array.isArray(arguments) && utils.isObject(arguments)) {
    enumArray = utils.object.vals(enumArray);
  }

  arr.caster["enum"].apply(arr.caster, enumArray);
  return this;
};
/**
 * Overrides the getters application for the population special-case
 *
 * @param {Object} value
 * @param {Object} scope
 * @api private
 */


SchemaArray.prototype.applyGetters = function (value, scope) {
  if (scope != null && scope.$__ != null && scope.$populated(this.path)) {
    // means the object id was populated
    return value;
  }

  var ret = SchemaType.prototype.applyGetters.call(this, value, scope);

  if (Array.isArray(ret)) {
    var rawValue = utils.isMongooseArray(ret) ? ret.__array : ret;
    var len = rawValue.length;

    for (var i = 0; i < len; ++i) {
      rawValue[i] = this.caster.applyGetters(rawValue[i], scope);
    }
  }

  return ret;
};

SchemaArray.prototype._applySetters = function (value, scope, init, priorVal) {
  if (this.casterConstructor.$isMongooseArray && SchemaArray.options.castNonArrays && !this[isNestedArraySymbol]) {
    // Check nesting levels and wrap in array if necessary
    var depth = 0;
    var arr = this;

    while (arr != null && arr.$isMongooseArray && !arr.$isMongooseDocumentArray) {
      ++depth;
      arr = arr.casterConstructor;
    } // No need to wrap empty arrays


    if (value != null && value.length !== 0) {
      var valueDepth = arrayDepth(value);

      if (valueDepth.min === valueDepth.max && valueDepth.max < depth && valueDepth.containsNonArrayItem) {
        for (var i = valueDepth.max; i < depth; ++i) {
          value = [value];
        }
      }
    }
  }

  return SchemaType.prototype._applySetters.call(this, value, scope, init, priorVal);
};
/**
 * Casts values for set().
 *
 * @param {Object} value
 * @param {Document} doc document that triggers the casting
 * @param {Boolean} init whether this is an initialization cast
 * @api private
 */


SchemaArray.prototype.cast = function (value, doc, init, prev, options) {
  // lazy load
  MongooseArray || (MongooseArray = (__webpack_require__(8941).Array));
  var i;
  var l;

  if (Array.isArray(value)) {
    var len = value.length;

    if (!len && doc) {
      var indexes = doc.schema.indexedPaths();
      var arrayPath = this.path;

      for (i = 0, l = indexes.length; i < l; ++i) {
        var pathIndex = indexes[i][0][arrayPath];

        if (pathIndex === '2dsphere' || pathIndex === '2d') {
          return;
        }
      } // Special case: if this index is on the parent of what looks like
      // GeoJSON, skip setting the default to empty array re: #1668, #3233


      var arrayGeojsonPath = this.path.endsWith('.coordinates') ? this.path.substring(0, this.path.lastIndexOf('.')) : null;

      if (arrayGeojsonPath != null) {
        for (i = 0, l = indexes.length; i < l; ++i) {
          var _pathIndex = indexes[i][0][arrayGeojsonPath];

          if (_pathIndex === '2dsphere') {
            return;
          }
        }
      }
    }

    options = options || emptyOpts;
    var rawValue = utils.isMongooseArray(value) ? value.__array : value;
    value = MongooseArray(rawValue, options.path || this._arrayPath || this.path, doc, this);
    rawValue = value.__array;

    if (init && doc != null && doc.$__ != null && doc.$populated(this.path)) {
      return value;
    }

    var caster = this.caster;
    var isMongooseArray = caster.$isMongooseArray;

    if (caster && this.casterConstructor !== Mixed) {
      try {
        var _len = rawValue.length;

        for (i = 0; i < _len; i++) {
          var opts = {}; // Perf: creating `arrayPath` is expensive for large arrays.
          // We only need `arrayPath` if this is a nested array, so
          // skip if possible.

          if (isMongooseArray) {
            if (options.arrayPath != null) {
              opts.arrayPathIndex = i;
            } else if (caster._arrayParentPath != null) {
              opts.arrayPathIndex = i;
            }
          }

          rawValue[i] = caster.applySetters(rawValue[i], doc, init, void 0, opts);
        }
      } catch (e) {
        // rethrow
        throw new CastError('[' + e.kind + ']', util.inspect(value), this.path + '.' + i, e, this);
      }
    }

    return value;
  }

  if (init || SchemaArray.options.castNonArrays) {
    // gh-2442: if we're loading this from the db and its not an array, mark
    // the whole array as modified.
    if (!!doc && !!init) {
      doc.markModified(this.path);
    }

    return this.cast([value], doc, init);
  }

  throw new CastError('Array', util.inspect(value), this.path, null, this);
};
/*!
 * ignore
 */


SchemaArray.prototype._castForPopulate = function _castForPopulate(value, doc) {
  // lazy load
  MongooseArray || (MongooseArray = (__webpack_require__(8941).Array));

  if (Array.isArray(value)) {
    var i;
    var rawValue = value.__array ? value.__array : value;
    var len = rawValue.length;
    var caster = this.caster;

    if (caster && this.casterConstructor !== Mixed) {
      try {
        for (i = 0; i < len; i++) {
          var opts = {}; // Perf: creating `arrayPath` is expensive for large arrays.
          // We only need `arrayPath` if this is a nested array, so
          // skip if possible.

          if (caster.$isMongooseArray && caster._arrayParentPath != null) {
            opts.arrayPathIndex = i;
          }

          rawValue[i] = caster.cast(rawValue[i], doc, false, void 0, opts);
        }
      } catch (e) {
        // rethrow
        throw new CastError('[' + e.kind + ']', util.inspect(value), this.path + '.' + i, e, this);
      }
    }

    return value;
  }

  throw new CastError('Array', util.inspect(value), this.path, null, this);
};

SchemaArray.prototype.$toObject = SchemaArray.prototype.toObject;
/*!
 * Ignore
 */

SchemaArray.prototype.discriminator = function (name, schema) {
  var arr = this;

  while (arr.$isMongooseArray && !arr.$isMongooseDocumentArray) {
    arr = arr.casterConstructor;

    if (arr == null || typeof arr === 'function') {
      throw new MongooseError('You can only add an embedded discriminator on ' + 'a document array, ' + this.path + ' is a plain array');
    }
  }

  return arr.discriminator(name, schema);
};
/*!
 * ignore
 */


SchemaArray.prototype.clone = function () {
  var options = Object.assign({}, this.options);
  var schematype = new this.constructor(this.path, this.caster, options, this.schemaOptions);
  schematype.validators = this.validators.slice();

  if (this.requiredValidator !== undefined) {
    schematype.requiredValidator = this.requiredValidator;
  }

  return schematype;
};
/**
 * Casts values for queries.
 *
 * @param {String} $conditional
 * @param {any} [value]
 * @api private
 */


SchemaArray.prototype.castForQuery = function ($conditional, value) {
  var _this = this;

  var handler;
  var val;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new Error('Can\'t use ' + $conditional + ' with Array.');
    }

    val = handler.call(this, value);
  } else {
    val = $conditional;
    var Constructor = this.casterConstructor;

    if (val && Constructor.discriminators && Constructor.schema && Constructor.schema.options && Constructor.schema.options.discriminatorKey) {
      if (typeof val[Constructor.schema.options.discriminatorKey] === 'string' && Constructor.discriminators[val[Constructor.schema.options.discriminatorKey]]) {
        Constructor = Constructor.discriminators[val[Constructor.schema.options.discriminatorKey]];
      } else {
        var constructorByValue = getDiscriminatorByValue(Constructor.discriminators, val[Constructor.schema.options.discriminatorKey]);

        if (constructorByValue) {
          Constructor = constructorByValue;
        }
      }
    }

    var proto = this.casterConstructor.prototype;
    var method = proto && (proto.castForQuery || proto.cast);

    if (!method && Constructor.castForQuery) {
      method = Constructor.castForQuery;
    }

    var caster = this.caster;

    if (Array.isArray(val)) {
      this.setters.reverse().forEach(function (setter) {
        val = setter.call(_this, val, _this);
      });
      val = val.map(function (v) {
        if (utils.isObject(v) && v.$elemMatch) {
          return v;
        }

        if (method) {
          v = method.call(caster, v);
          return v;
        }

        if (v != null) {
          v = new Constructor(v);
          return v;
        }

        return v;
      });
    } else if (method) {
      val = method.call(caster, val);
    } else if (val != null) {
      val = new Constructor(val);
    }
  }

  return val;
};

function cast$all(val) {
  if (!Array.isArray(val)) {
    val = [val];
  }

  val = val.map(function (v) {
    if (!utils.isObject(v)) {
      return v;
    }

    if (v.$elemMatch != null) {
      return {
        $elemMatch: cast(this.casterConstructor.schema, v.$elemMatch)
      };
    }

    var o = {};
    o[this.path] = v;
    return cast(this.casterConstructor.schema, o)[this.path];
  }, this);
  return this.castForQuery(val);
}

function cast$elemMatch(val) {
  var keys = Object.keys(val);
  var numKeys = keys.length;

  for (var i = 0; i < numKeys; ++i) {
    var key = keys[i];
    var value = val[key];

    if (isOperator(key) && value != null) {
      val[key] = this.castForQuery(key, value);
    }
  } // Is this an embedded discriminator and is the discriminator key set?
  // If so, use the discriminator schema. See gh-7449


  var discriminatorKey = this && this.casterConstructor && this.casterConstructor.schema && this.casterConstructor.schema.options && this.casterConstructor.schema.options.discriminatorKey;
  var discriminators = this && this.casterConstructor && this.casterConstructor.schema && this.casterConstructor.schema.discriminators || {};

  if (discriminatorKey != null && val[discriminatorKey] != null && discriminators[val[discriminatorKey]] != null) {
    return cast(discriminators[val[discriminatorKey]], val);
  }

  return cast(this.casterConstructor.schema, val);
}

var handle = SchemaArray.prototype.$conditionalHandlers = {};
handle.$all = cast$all;
handle.$options = String;
handle.$elemMatch = cast$elemMatch;
handle.$geoIntersects = geospatial.cast$geoIntersects;
handle.$or = createLogicalQueryOperatorHandler('$or');
handle.$and = createLogicalQueryOperatorHandler('$and');
handle.$nor = createLogicalQueryOperatorHandler('$nor');

function createLogicalQueryOperatorHandler(op) {
  return function logicalQueryOperatorHandler(val) {
    if (!Array.isArray(val)) {
      throw new TypeError('conditional ' + op + ' requires an array');
    }

    var ret = [];

    var _iterator = _createForOfIteratorHelper(val),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var obj = _step.value;
        ret.push(cast(this.casterConstructor.schema, obj));
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return ret;
  };
}

handle.$near = handle.$nearSphere = geospatial.cast$near;
handle.$within = handle.$geoWithin = geospatial.cast$within;
handle.$size = handle.$minDistance = handle.$maxDistance = castToNumber;
handle.$exists = $exists;
handle.$type = $type;
handle.$eq = handle.$gt = handle.$gte = handle.$lt = handle.$lte = handle.$ne = handle.$not = handle.$regex = SchemaArray.prototype.castForQuery; // `$in` is special because you can also include an empty array in the query
// like `$in: [1, []]`, see gh-5913

handle.$nin = SchemaType.prototype.$conditionalHandlers.$nin;
handle.$in = SchemaType.prototype.$conditionalHandlers.$in;
/*!
 * Module exports.
 */

module.exports = SchemaArray;

/***/ }),

/***/ 6470:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

var CastError = __webpack_require__(1795);

var SchemaType = __webpack_require__(4289);

var castBoolean = __webpack_require__(6670);

var utils = __webpack_require__(6872);
/**
 * Boolean SchemaType constructor.
 *
 * @param {String} path
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */


function SchemaBoolean(path, options) {
  SchemaType.call(this, path, options, 'Boolean');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaBoolean.schemaName = 'Boolean';
SchemaBoolean.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

SchemaBoolean.prototype = Object.create(SchemaType.prototype);
SchemaBoolean.prototype.constructor = SchemaBoolean;
/*!
 * ignore
 */

SchemaBoolean._cast = castBoolean;
/**
 * Sets a default option for all Boolean instances.
 *
 * #### Example:
 *
 *     // Make all booleans have `default` of false.
 *     mongoose.Schema.Boolean.set('default', false);
 *
 *     const Order = mongoose.model('Order', new Schema({ isPaid: Boolean }));
 *     new Order({ }).isPaid; // false
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

SchemaBoolean.set = SchemaType.set;
/**
 * Get/set the function used to cast arbitrary values to booleans.
 *
 * #### Example:
 *
 *     // Make Mongoose cast empty string '' to false.
 *     const original = mongoose.Schema.Boolean.cast();
 *     mongoose.Schema.Boolean.cast(v => {
 *       if (v === '') {
 *         return false;
 *       }
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.Schema.Boolean.cast(false);
 *
 * @param {Function} caster
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

SchemaBoolean.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


SchemaBoolean._defaultCaster = function (v) {
  if (v != null && typeof v !== 'boolean') {
    throw new Error();
  }

  return v;
};
/*!
 * ignore
 */


SchemaBoolean._checkRequired = function (v) {
  return v === true || v === false;
};
/**
 * Override the function the required validator uses to check whether a boolean
 * passes the `required` check.
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


SchemaBoolean.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator. For a boolean
 * to satisfy a required validator, it must be strictly equal to true or to
 * false.
 *
 * @param {Any} value
 * @return {Boolean}
 * @api public
 */

SchemaBoolean.prototype.checkRequired = function (value) {
  return this.constructor._checkRequired(value);
};
/**
 * Configure which values get casted to `true`.
 *
 * #### Example:
 *
 *     const M = mongoose.model('Test', new Schema({ b: Boolean }));
 *     new M({ b: 'affirmative' }).b; // undefined
 *     mongoose.Schema.Boolean.convertToTrue.add('affirmative');
 *     new M({ b: 'affirmative' }).b; // true
 *
 * @property convertToTrue
 * @type Set
 * @api public
 */


Object.defineProperty(SchemaBoolean, 'convertToTrue', {
  get: function get() {
    return castBoolean.convertToTrue;
  },
  set: function set(v) {
    castBoolean.convertToTrue = v;
  }
});
/**
 * Configure which values get casted to `false`.
 *
 * #### Example:
 *
 *     const M = mongoose.model('Test', new Schema({ b: Boolean }));
 *     new M({ b: 'nay' }).b; // undefined
 *     mongoose.Schema.Types.Boolean.convertToFalse.add('nay');
 *     new M({ b: 'nay' }).b; // false
 *
 * @property convertToFalse
 * @type Set
 * @api public
 */

Object.defineProperty(SchemaBoolean, 'convertToFalse', {
  get: function get() {
    return castBoolean.convertToFalse;
  },
  set: function set(v) {
    castBoolean.convertToFalse = v;
  }
});
/**
 * Casts to boolean
 *
 * @param {Object} value
 * @param {Object} model - this value is optional
 * @api private
 */

SchemaBoolean.prototype.cast = function (value) {
  var castBoolean;

  if (typeof this._castFunction === 'function') {
    castBoolean = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castBoolean = this.constructor.cast();
  } else {
    castBoolean = SchemaBoolean.cast();
  }

  try {
    return castBoolean(value);
  } catch (error) {
    throw new CastError('Boolean', value, this.path, error, this);
  }
};

SchemaBoolean.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {});
/**
 * Casts contents for queries.
 *
 * @param {String} $conditional
 * @param {any} val
 * @api private
 */

SchemaBoolean.prototype.castForQuery = function ($conditional, val) {
  var handler;

  if (arguments.length === 2) {
    handler = SchemaBoolean.$conditionalHandlers[$conditional];

    if (handler) {
      return handler.call(this, val);
    }

    return this._castForQuery(val);
  }

  return this._castForQuery($conditional);
};
/**
 *
 * @api private
 */


SchemaBoolean.prototype._castNullish = function _castNullish(v) {
  if (typeof v === 'undefined') {
    return v;
  }

  var castBoolean = typeof this.constructor.cast === 'function' ? this.constructor.cast() : SchemaBoolean.cast();

  if (castBoolean == null) {
    return v;
  }

  if (castBoolean.convertToFalse instanceof Set && castBoolean.convertToFalse.has(v)) {
    return false;
  }

  if (castBoolean.convertToTrue instanceof Set && castBoolean.convertToTrue.has(v)) {
    return true;
  }

  return v;
};
/*!
 * Module exports.
 */


module.exports = SchemaBoolean;

/***/ }),

/***/ 8800:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];
/*!
 * Module dependencies.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var MongooseBuffer = __webpack_require__(4051);

var SchemaBufferOptions = __webpack_require__(9586);

var SchemaType = __webpack_require__(4289);

var handleBitwiseOperator = __webpack_require__(4282);

var utils = __webpack_require__(6872);

var Binary = MongooseBuffer.Binary;
var CastError = SchemaType.CastError;
/**
 * Buffer SchemaType constructor
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function SchemaBuffer(key, options) {
  SchemaType.call(this, key, options, 'Buffer');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaBuffer.schemaName = 'Buffer';
SchemaBuffer.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

SchemaBuffer.prototype = Object.create(SchemaType.prototype);
SchemaBuffer.prototype.constructor = SchemaBuffer;
SchemaBuffer.prototype.OptionsConstructor = SchemaBufferOptions;
/*!
 * ignore
 */

SchemaBuffer._checkRequired = function (v) {
  return !!(v && v.length);
};
/**
 * Sets a default option for all Buffer instances.
 *
 * #### Example:
 *
 *     // Make all buffers have `required` of true by default.
 *     mongoose.Schema.Buffer.set('required', true);
 *
 *     const User = mongoose.model('User', new Schema({ test: Buffer }));
 *     new User({ }).validateSync().errors.test.message; // Path `test` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */


SchemaBuffer.set = SchemaType.set;
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * #### Example:
 *
 *     // Allow empty strings to pass `required` check
 *     mongoose.Schema.Types.String.checkRequired(v => v != null);
 *
 *     const M = mongoose.model({ buf: { type: Buffer, required: true } });
 *     new M({ buf: Buffer.from('') }).validateSync(); // validation passes!
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */

SchemaBuffer.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator. To satisfy a
 * required validator, a buffer must not be null or undefined and have
 * non-zero length.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

SchemaBuffer.prototype.checkRequired = function (value, doc) {
  if (SchemaType._isRef(this, value, doc, true)) {
    return !!value;
  }

  return this.constructor._checkRequired(value);
};
/**
 * Casts contents
 *
 * @param {Object} value
 * @param {Document} doc document that triggers the casting
 * @param {Boolean} init
 * @api private
 */


SchemaBuffer.prototype.cast = function (value, doc, init) {
  var ret;

  if (SchemaType._isRef(this, value, doc, init)) {
    if (value && value.isMongooseBuffer) {
      return value;
    }

    if (Buffer.isBuffer(value)) {
      if (!value || !value.isMongooseBuffer) {
        value = new MongooseBuffer(value, [this.path, doc]);

        if (this.options.subtype != null) {
          value._subtype = this.options.subtype;
        }
      }

      return value;
    }

    if (value instanceof Binary) {
      ret = new MongooseBuffer(value.value(true), [this.path, doc]);

      if (typeof value.sub_type !== 'number') {
        throw new CastError('Buffer', value, this.path, null, this);
      }

      ret._subtype = value.sub_type;
      return ret;
    }

    if (value == null || utils.isNonBuiltinObject(value)) {
      return this._castRef(value, doc, init);
    }
  } // documents


  if (value && value._id) {
    value = value._id;
  }

  if (value && value.isMongooseBuffer) {
    return value;
  }

  if (Buffer.isBuffer(value)) {
    if (!value || !value.isMongooseBuffer) {
      value = new MongooseBuffer(value, [this.path, doc]);

      if (this.options.subtype != null) {
        value._subtype = this.options.subtype;
      }
    }

    return value;
  }

  if (value instanceof Binary) {
    ret = new MongooseBuffer(value.value(true), [this.path, doc]);

    if (typeof value.sub_type !== 'number') {
      throw new CastError('Buffer', value, this.path, null, this);
    }

    ret._subtype = value.sub_type;
    return ret;
  }

  if (value === null) {
    return value;
  }

  var type = _typeof(value);

  if (type === 'string' || type === 'number' || Array.isArray(value) || type === 'object' && value.type === 'Buffer' && Array.isArray(value.data) // gh-6863
  ) {
    if (type === 'number') {
      value = [value];
    }

    ret = new MongooseBuffer(value, [this.path, doc]);

    if (this.options.subtype != null) {
      ret._subtype = this.options.subtype;
    }

    return ret;
  }

  throw new CastError('Buffer', value, this.path, null, this);
};
/**
 * Sets the default [subtype](https://studio3t.com/whats-new/best-practices-uuid-mongodb/)
 * for this buffer. You can find a [list of allowed subtypes here](https://api.mongodb.com/python/current/api/bson/binary.html).
 *
 * #### Example:
 *
 *     const s = new Schema({ uuid: { type: Buffer, subtype: 4 });
 *     const M = db.model('M', s);
 *     const m = new M({ uuid: 'test string' });
 *     m.uuid._subtype; // 4
 *
 * @param {Number} subtype the default subtype
 * @return {SchemaType} this
 * @api public
 */


SchemaBuffer.prototype.subtype = function (subtype) {
  this.options.subtype = subtype;
  return this;
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.castForQuery(val);
}

SchemaBuffer.prototype.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $bitsAllClear: handleBitwiseOperator,
  $bitsAnyClear: handleBitwiseOperator,
  $bitsAllSet: handleBitwiseOperator,
  $bitsAnySet: handleBitwiseOperator,
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle
});
/**
 * Casts contents for queries.
 *
 * @param {String} $conditional
 * @param {any} [value]
 * @api private
 */

SchemaBuffer.prototype.castForQuery = function ($conditional, val) {
  var handler;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new Error('Can\'t use ' + $conditional + ' with Buffer.');
    }

    return handler.call(this, val);
  }

  val = $conditional;

  var casted = this._castForQuery(val);

  return casted ? casted.toObject({
    transform: false,
    virtuals: false
  }) : casted;
};
/*!
 * Module exports.
 */


module.exports = SchemaBuffer;

/***/ }),

/***/ 6535:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module requirements.
 */


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var MongooseError = __webpack_require__(4888);

var SchemaDateOptions = __webpack_require__(2869);

var SchemaType = __webpack_require__(4289);

var castDate = __webpack_require__(195);

var getConstructorName = __webpack_require__(1981);

var utils = __webpack_require__(6872);

var CastError = SchemaType.CastError;
/**
 * Date SchemaType constructor.
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function SchemaDate(key, options) {
  SchemaType.call(this, key, options, 'Date');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaDate.schemaName = 'Date';
SchemaDate.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

SchemaDate.prototype = Object.create(SchemaType.prototype);
SchemaDate.prototype.constructor = SchemaDate;
SchemaDate.prototype.OptionsConstructor = SchemaDateOptions;
/*!
 * ignore
 */

SchemaDate._cast = castDate;
/**
 * Sets a default option for all Date instances.
 *
 * #### Example:
 *
 *     // Make all dates have `required` of true by default.
 *     mongoose.Schema.Date.set('required', true);
 *
 *     const User = mongoose.model('User', new Schema({ test: Date }));
 *     new User({ }).validateSync().errors.test.message; // Path `test` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

SchemaDate.set = SchemaType.set;
/**
 * Get/set the function used to cast arbitrary values to dates.
 *
 * #### Example:
 *
 *     // Mongoose converts empty string '' into `null` for date types. You
 *     // can create a custom caster to disable it.
 *     const original = mongoose.Schema.Types.Date.cast();
 *     mongoose.Schema.Types.Date.cast(v => {
 *       assert.ok(v !== '');
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.Schema.Types.Date.cast(false);
 *
 * @param {Function} caster
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

SchemaDate.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


SchemaDate._defaultCaster = function (v) {
  if (v != null && !(v instanceof Date)) {
    throw new Error();
  }

  return v;
};
/**
 * Declares a TTL index (rounded to the nearest second) for _Date_ types only.
 *
 * This sets the `expireAfterSeconds` index option available in MongoDB >= 2.1.2.
 * This index type is only compatible with Date types.
 *
 * #### Example:
 *
 *     // expire in 24 hours
 *     new Schema({ createdAt: { type: Date, expires: 60*60*24 }});
 *
 * `expires` utilizes the `ms` module from [guille](https://github.com/guille/) allowing us to use a friendlier syntax:
 *
 * #### Example:
 *
 *     // expire in 24 hours
 *     new Schema({ createdAt: { type: Date, expires: '24h' }});
 *
 *     // expire in 1.5 hours
 *     new Schema({ createdAt: { type: Date, expires: '1.5h' }});
 *
 *     // expire in 7 days
 *     const schema = new Schema({ createdAt: Date });
 *     schema.path('createdAt').expires('7d');
 *
 * @param {Number|String} when
 * @added 3.0.0
 * @return {SchemaType} this
 * @api public
 */


SchemaDate.prototype.expires = function (when) {
  if (getConstructorName(this._index) !== 'Object') {
    this._index = {};
  }

  this._index.expires = when;
  utils.expires(this._index);
  return this;
};
/*!
 * ignore
 */


SchemaDate._checkRequired = function (v) {
  return v instanceof Date;
};
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * #### Example:
 *
 *     // Allow empty strings to pass `required` check
 *     mongoose.Schema.Types.String.checkRequired(v => v != null);
 *
 *     const M = mongoose.model({ str: { type: String, required: true } });
 *     new M({ str: '' }).validateSync(); // `null`, validation passes!
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


SchemaDate.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator. To satisfy
 * a required validator, the given value must be an instance of `Date`.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

SchemaDate.prototype.checkRequired = function (value, doc) {
  if (_typeof(value) === 'object' && SchemaType._isRef(this, value, doc, true)) {
    return value != null;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : SchemaDate.checkRequired();

  return _checkRequired(value);
};
/**
 * Sets a minimum date validator.
 *
 * #### Example:
 *
 *     const s = new Schema({ d: { type: Date, min: Date('1970-01-01') })
 *     const M = db.model('M', s)
 *     const m = new M({ d: Date('1969-12-31') })
 *     m.save(function (err) {
 *       console.error(err) // validator error
 *       m.d = Date('2014-12-08');
 *       m.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MIN} token which will be replaced with the invalid value
 *     const min = [Date('1970-01-01'), 'The value of path `{PATH}` ({VALUE}) is beneath the limit ({MIN}).'];
 *     const schema = new Schema({ d: { type: Date, min: min })
 *     const M = mongoose.model('M', schema);
 *     const s= new M({ d: Date('1969-12-31') });
 *     s.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `d` (1969-12-31) is before the limit (1970-01-01).
 *     })
 *
 * @param {Date} value minimum date
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaDate.prototype.min = function (value, message) {
  if (this.minValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.minValidator;
    }, this);
  }

  if (value) {
    var msg = message || MongooseError.messages.Date.min;

    if (typeof msg === 'string') {
      msg = msg.replace(/{MIN}/, value === Date.now ? 'Date.now()' : value.toString());
    }

    var _this = this;

    this.validators.push({
      validator: this.minValidator = function (val) {
        var _value = value;

        if (typeof value === 'function' && value !== Date.now) {
          _value = _value.call(this);
        }

        var min = _value === Date.now ? _value() : _this.cast(_value);
        return val === null || val.valueOf() >= min.valueOf();
      },
      message: msg,
      type: 'min',
      min: value
    });
  }

  return this;
};
/**
 * Sets a maximum date validator.
 *
 * #### Example:
 *
 *     const s = new Schema({ d: { type: Date, max: Date('2014-01-01') })
 *     const M = db.model('M', s)
 *     const m = new M({ d: Date('2014-12-08') })
 *     m.save(function (err) {
 *       console.error(err) // validator error
 *       m.d = Date('2013-12-31');
 *       m.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MAX} token which will be replaced with the invalid value
 *     const max = [Date('2014-01-01'), 'The value of path `{PATH}` ({VALUE}) exceeds the limit ({MAX}).'];
 *     const schema = new Schema({ d: { type: Date, max: max })
 *     const M = mongoose.model('M', schema);
 *     const s= new M({ d: Date('2014-12-08') });
 *     s.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `d` (2014-12-08) exceeds the limit (2014-01-01).
 *     })
 *
 * @param {Date} maximum date
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaDate.prototype.max = function (value, message) {
  if (this.maxValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.maxValidator;
    }, this);
  }

  if (value) {
    var msg = message || MongooseError.messages.Date.max;

    if (typeof msg === 'string') {
      msg = msg.replace(/{MAX}/, value === Date.now ? 'Date.now()' : value.toString());
    }

    var _this = this;

    this.validators.push({
      validator: this.maxValidator = function (val) {
        var _value = value;

        if (typeof _value === 'function' && _value !== Date.now) {
          _value = _value.call(this);
        }

        var max = _value === Date.now ? _value() : _this.cast(_value);
        return val === null || val.valueOf() <= max.valueOf();
      },
      message: msg,
      type: 'max',
      max: value
    });
  }

  return this;
};
/**
 * Casts to date
 *
 * @param {Object} value to cast
 * @api private
 */


SchemaDate.prototype.cast = function (value) {
  var castDate;

  if (typeof this._castFunction === 'function') {
    castDate = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castDate = this.constructor.cast();
  } else {
    castDate = SchemaDate.cast();
  }

  try {
    return castDate(value);
  } catch (error) {
    throw new CastError('date', value, this.path, error, this);
  }
};
/*!
 * Date Query casting.
 *
 * @api private
 */


function handleSingle(val) {
  return this.cast(val);
}

SchemaDate.prototype.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle
});
/**
 * Casts contents for queries.
 *
 * @param {String} $conditional
 * @param {any} [value]
 * @api private
 */

SchemaDate.prototype.castForQuery = function ($conditional, val) {
  if (arguments.length !== 2) {
    return this._castForQuery($conditional);
  }

  var handler = this.$conditionalHandlers[$conditional];

  if (!handler) {
    throw new Error('Can\'t use ' + $conditional + ' with Date.');
  }

  return handler.call(this, val);
};
/*!
 * Module exports.
 */


module.exports = SchemaDate;

/***/ }),

/***/ 6621:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var SchemaType = __webpack_require__(4289);

var CastError = SchemaType.CastError;

var castDecimal128 = __webpack_require__(6209);

var utils = __webpack_require__(6872);

var isBsonType = __webpack_require__(1563);
/**
 * Decimal128 SchemaType constructor.
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */


function Decimal128(key, options) {
  SchemaType.call(this, key, options, 'Decimal128');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


Decimal128.schemaName = 'Decimal128';
Decimal128.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

Decimal128.prototype = Object.create(SchemaType.prototype);
Decimal128.prototype.constructor = Decimal128;
/*!
 * ignore
 */

Decimal128._cast = castDecimal128;
/**
 * Sets a default option for all Decimal128 instances.
 *
 * #### Example:
 *
 *     // Make all decimal 128s have `required` of true by default.
 *     mongoose.Schema.Decimal128.set('required', true);
 *
 *     const User = mongoose.model('User', new Schema({ test: mongoose.Decimal128 }));
 *     new User({ }).validateSync().errors.test.message; // Path `test` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

Decimal128.set = SchemaType.set;
/**
 * Get/set the function used to cast arbitrary values to decimals.
 *
 * #### Example:
 *
 *     // Make Mongoose only refuse to cast numbers as decimal128
 *     const original = mongoose.Schema.Types.Decimal128.cast();
 *     mongoose.Decimal128.cast(v => {
 *       assert.ok(typeof v !== 'number');
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.Decimal128.cast(false);
 *
 * @param {Function} [caster]
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

Decimal128.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


Decimal128._defaultCaster = function (v) {
  if (v != null && !isBsonType(v, 'Decimal128')) {
    throw new Error();
  }

  return v;
};
/*!
 * ignore
 */


Decimal128._checkRequired = function (v) {
  return isBsonType(v, 'Decimal128');
};
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


Decimal128.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

Decimal128.prototype.checkRequired = function checkRequired(value, doc) {
  if (SchemaType._isRef(this, value, doc, true)) {
    return !!value;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : Decimal128.checkRequired();

  return _checkRequired(value);
};
/**
 * Casts to Decimal128
 *
 * @param {Object} value
 * @param {Object} doc
 * @param {Boolean} init whether this is an initialization cast
 * @api private
 */


Decimal128.prototype.cast = function (value, doc, init) {
  if (SchemaType._isRef(this, value, doc, init)) {
    if (isBsonType(value, 'Decimal128')) {
      return value;
    }

    return this._castRef(value, doc, init);
  }

  var castDecimal128;

  if (typeof this._castFunction === 'function') {
    castDecimal128 = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castDecimal128 = this.constructor.cast();
  } else {
    castDecimal128 = Decimal128.cast();
  }

  try {
    return castDecimal128(value);
  } catch (error) {
    throw new CastError('Decimal128', value, this.path, error, this);
  }
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.cast(val);
}

Decimal128.prototype.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle
});
/*!
 * Module exports.
 */

module.exports = Decimal128;

/***/ }),

/***/ 4504:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

var ArrayType = __webpack_require__(94);

var CastError = __webpack_require__(1795);

var EventEmitter = (__webpack_require__(9620).EventEmitter);

var SchemaDocumentArrayOptions = __webpack_require__(887);

var SchemaType = __webpack_require__(4289);

var SubdocumentPath = __webpack_require__(3617);

var discriminator = __webpack_require__(9181);

var handleIdOption = __webpack_require__(9691);

var handleSpreadDoc = __webpack_require__(719);

var utils = __webpack_require__(6872);

var getConstructor = __webpack_require__(8413);

var arrayAtomicsSymbol = (__webpack_require__(8770).arrayAtomicsSymbol);

var arrayPathSymbol = (__webpack_require__(8770).arrayPathSymbol);

var documentArrayParent = (__webpack_require__(8770).documentArrayParent);

var MongooseDocumentArray;
var Subdocument;
/**
 * SubdocsArray SchemaType constructor
 *
 * @param {String} key
 * @param {Schema} schema
 * @param {Object} options
 * @param {Object} schemaOptions
 * @inherits SchemaArray
 * @api public
 */

function DocumentArrayPath(key, schema, options, schemaOptions) {
  if (schemaOptions != null && schemaOptions._id != null) {
    schema = handleIdOption(schema, schemaOptions);
  } else if (options != null && options._id != null) {
    schema = handleIdOption(schema, options);
  }

  var EmbeddedDocument = _createConstructor(schema, options);

  EmbeddedDocument.prototype.$basePath = key;
  ArrayType.call(this, key, EmbeddedDocument, options);
  this.schema = schema;
  this.schemaOptions = schemaOptions || {};
  this.$isMongooseDocumentArray = true;
  this.Constructor = EmbeddedDocument;
  EmbeddedDocument.base = schema.base;
  var fn = this.defaultValue;

  if (!('defaultValue' in this) || fn !== void 0) {
    this["default"](function () {
      var arr = fn.call(this);

      if (arr != null && !Array.isArray(arr)) {
        arr = [arr];
      } // Leave it up to `cast()` to convert this to a documentarray


      return arr;
    });
  }

  var parentSchemaType = this;
  this.$embeddedSchemaType = new SchemaType(key + '.$', {
    required: this && this.schemaOptions && this.schemaOptions.required || false
  });

  this.$embeddedSchemaType.cast = function (value, doc, init) {
    return parentSchemaType.cast(value, doc, init)[0];
  };

  this.$embeddedSchemaType.doValidate = function (value, fn, scope, options) {
    var Constructor = getConstructor(this.caster, value);

    if (value && !(value instanceof Constructor)) {
      value = new Constructor(value, scope, null, null, options && options.index != null ? options.index : null);
    }

    return SubdocumentPath.prototype.doValidate.call(this, value, fn, scope, options);
  };

  this.$embeddedSchemaType.$isMongooseDocumentArrayElement = true;
  this.$embeddedSchemaType.caster = this.Constructor;
  this.$embeddedSchemaType.schema = this.schema;
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


DocumentArrayPath.schemaName = 'DocumentArray';
/**
 * Options for all document arrays.
 *
 * - `castNonArrays`: `true` by default. If `false`, Mongoose will throw a CastError when a value isn't an array. If `true`, Mongoose will wrap the provided value in an array before casting.
 *
 * @api public
 */

DocumentArrayPath.options = {
  castNonArrays: true
};
/*!
 * Inherits from ArrayType.
 */

DocumentArrayPath.prototype = Object.create(ArrayType.prototype);
DocumentArrayPath.prototype.constructor = DocumentArrayPath;
DocumentArrayPath.prototype.OptionsConstructor = SchemaDocumentArrayOptions;
/*!
 * Ignore
 */

function _createConstructor(schema, options, baseClass) {
  Subdocument || (Subdocument = __webpack_require__(1568)); // compile an embedded document for this schema

  function EmbeddedDocument(_value, parentArray) {
    Subdocument.apply(this, arguments);

    if (parentArray == null || parentArray.getArrayParent() == null) {
      return;
    }

    this.$session(parentArray.getArrayParent().$session());
  }

  schema._preCompile();

  var proto = baseClass != null ? baseClass.prototype : Subdocument.prototype;
  EmbeddedDocument.prototype = Object.create(proto);
  EmbeddedDocument.prototype.$__setSchema(schema);
  EmbeddedDocument.schema = schema;
  EmbeddedDocument.prototype.constructor = EmbeddedDocument;
  EmbeddedDocument.$isArraySubdocument = true;
  EmbeddedDocument.events = new EventEmitter(); // apply methods

  for (var i in schema.methods) {
    EmbeddedDocument.prototype[i] = schema.methods[i];
  } // apply statics


  for (var _i in schema.statics) {
    EmbeddedDocument[_i] = schema.statics[_i];
  }

  for (var _i2 in EventEmitter.prototype) {
    EmbeddedDocument[_i2] = EventEmitter.prototype[_i2];
  }

  EmbeddedDocument.options = options;
  return EmbeddedDocument;
}
/**
 * Adds a discriminator to this document array.
 *
 * #### Example:
 *     const shapeSchema = Schema({ name: String }, { discriminatorKey: 'kind' });
 *     const schema = Schema({ shapes: [shapeSchema] });
 *
 *     const docArrayPath = parentSchema.path('shapes');
 *     docArrayPath.discriminator('Circle', Schema({ radius: Number }));
 *
 * @param {String} name
 * @param {Schema} schema fields to add to the schema for instances of this sub-class
 * @param {Object|string} [options] If string, same as `options.value`.
 * @param {String} [options.value] the string stored in the `discriminatorKey` property. If not specified, Mongoose uses the `name` parameter.
 * @param {Boolean} [options.clone=true] By default, `discriminator()` clones the given `schema`. Set to `false` to skip cloning.
 * @see discriminators /docs/discriminators.html
 * @return {Function} the constructor Mongoose will use for creating instances of this discriminator model
 * @api public
 */


DocumentArrayPath.prototype.discriminator = function (name, schema, options) {
  if (typeof name === 'function') {
    name = utils.getFunctionName(name);
  }

  options = options || {};
  var tiedValue = utils.isPOJO(options) ? options.value : options;
  var clone = typeof options.clone === 'boolean' ? options.clone : true;

  if (schema.instanceOfSchema && clone) {
    schema = schema.clone();
  }

  schema = discriminator(this.casterConstructor, name, schema, tiedValue);

  var EmbeddedDocument = _createConstructor(schema, null, this.casterConstructor);

  EmbeddedDocument.baseCasterConstructor = this.casterConstructor;

  try {
    Object.defineProperty(EmbeddedDocument, 'name', {
      value: name
    });
  } catch (error) {// Ignore error, only happens on old versions of node
  }

  this.casterConstructor.discriminators[name] = EmbeddedDocument;
  return this.casterConstructor.discriminators[name];
};
/**
 * Performs local validations first, then validations on each embedded doc
 *
 * @api private
 */


DocumentArrayPath.prototype.doValidate = function (array, fn, scope, options) {
  // lazy load
  MongooseDocumentArray || (MongooseDocumentArray = __webpack_require__(6077));

  var _this = this;

  try {
    SchemaType.prototype.doValidate.call(this, array, cb, scope);
  } catch (err) {
    return fn(err);
  }

  function cb(err) {
    if (err) {
      return fn(err);
    }

    var count = array && array.length;
    var error;

    if (!count) {
      return fn();
    }

    if (options && options.updateValidator) {
      return fn();
    }

    if (!utils.isMongooseDocumentArray(array)) {
      array = new MongooseDocumentArray(array, _this.path, scope);
    } // handle sparse arrays, do not use array.forEach which does not
    // iterate over sparse elements yet reports array.length including
    // them :(


    function callback(err) {
      if (err != null) {
        error = err;
      }

      --count || fn(error);
    }

    for (var i = 0, len = count; i < len; ++i) {
      // sidestep sparse entries
      var doc = array[i];

      if (doc == null) {
        --count || fn(error);
        continue;
      } // If you set the array index directly, the doc might not yet be
      // a full fledged mongoose subdoc, so make it into one.


      if (!(doc instanceof Subdocument)) {
        var Constructor = getConstructor(_this.casterConstructor, array[i]);
        doc = array[i] = new Constructor(doc, array, undefined, undefined, i);
      }

      if (options != null && options.validateModifiedOnly && !doc.$isModified()) {
        --count || fn(error);
        continue;
      }

      doc.$__validate(callback);
    }
  }
};
/**
 * Performs local validations first, then validations on each embedded doc.
 *
 * #### Note:
 *
 * This method ignores the asynchronous validators.
 *
 * @return {MongooseError|undefined}
 * @api private
 */


DocumentArrayPath.prototype.doValidateSync = function (array, scope, options) {
  var schemaTypeError = SchemaType.prototype.doValidateSync.call(this, array, scope);

  if (schemaTypeError != null) {
    return schemaTypeError;
  }

  var count = array && array.length;
  var resultError = null;

  if (!count) {
    return;
  } // handle sparse arrays, do not use array.forEach which does not
  // iterate over sparse elements yet reports array.length including
  // them :(


  for (var i = 0, len = count; i < len; ++i) {
    // sidestep sparse entries
    var doc = array[i];

    if (!doc) {
      continue;
    } // If you set the array index directly, the doc might not yet be
    // a full fledged mongoose subdoc, so make it into one.


    if (!(doc instanceof Subdocument)) {
      var Constructor = getConstructor(this.casterConstructor, array[i]);
      doc = array[i] = new Constructor(doc, array, undefined, undefined, i);
    }

    if (options != null && options.validateModifiedOnly && !doc.$isModified()) {
      continue;
    }

    var subdocValidateError = doc.validateSync();

    if (subdocValidateError && resultError == null) {
      resultError = subdocValidateError;
    }
  }

  return resultError;
};
/*!
 * ignore
 */


DocumentArrayPath.prototype.getDefault = function (scope) {
  var ret = typeof this.defaultValue === 'function' ? this.defaultValue.call(scope) : this.defaultValue;

  if (ret == null) {
    return ret;
  } // lazy load


  MongooseDocumentArray || (MongooseDocumentArray = __webpack_require__(6077));

  if (!Array.isArray(ret)) {
    ret = [ret];
  }

  ret = new MongooseDocumentArray(ret, this.path, scope);

  for (var i = 0; i < ret.length; ++i) {
    var Constructor = getConstructor(this.casterConstructor, ret[i]);

    var _subdoc = new Constructor({}, ret, undefined, undefined, i);

    _subdoc.$init(ret[i]);

    _subdoc.isNew = true; // Make sure all paths in the subdoc are set to `default` instead
    // of `init` since we used `init`.

    Object.assign(_subdoc.$__.activePaths["default"], _subdoc.$__.activePaths.init);
    _subdoc.$__.activePaths.init = {};
    ret[i] = _subdoc;
  }

  return ret;
};

var _toObjectOptions = Object.freeze({
  transform: false,
  virtuals: false
});

var initDocumentOptions = Object.freeze({
  skipId: true,
  willInit: true
});
/**
 * Casts contents
 *
 * @param {Object} value
 * @param {Document} document that triggers the casting
 * @api private
 */

DocumentArrayPath.prototype.cast = function (value, doc, init, prev, options) {
  // lazy load
  MongooseDocumentArray || (MongooseDocumentArray = __webpack_require__(6077)); // Skip casting if `value` is the same as the previous value, no need to cast. See gh-9266

  if (value != null && value[arrayPathSymbol] != null && value === prev) {
    return value;
  }

  var selected;
  var subdoc;
  options = options || {};

  if (!Array.isArray(value)) {
    if (!init && !DocumentArrayPath.options.castNonArrays) {
      throw new CastError('DocumentArray', value, this.path, null, this);
    } // gh-2442 mark whole array as modified if we're initializing a doc from
    // the db and the path isn't an array in the document


    if (!!doc && init) {
      doc.markModified(this.path);
    }

    return this.cast([value], doc, init, prev, options);
  } // We need to create a new array, otherwise change tracking will
  // update the old doc (gh-4449)


  if (!options.skipDocumentArrayCast || utils.isMongooseDocumentArray(value)) {
    value = new MongooseDocumentArray(value, this.path, doc);
  }

  if (prev != null) {
    value[arrayAtomicsSymbol] = prev[arrayAtomicsSymbol] || {};
  }

  if (options.arrayPathIndex != null) {
    value[arrayPathSymbol] = this.path + '.' + options.arrayPathIndex;
  }

  var rawArray = utils.isMongooseDocumentArray(value) ? value.__array : value;
  var len = rawArray.length;

  for (var i = 0; i < len; ++i) {
    if (!rawArray[i]) {
      continue;
    }

    var Constructor = getConstructor(this.casterConstructor, rawArray[i]); // Check if the document has a different schema (re gh-3701)

    if (rawArray[i].$__ != null && !(rawArray[i] instanceof Constructor)) {
      var spreadDoc = handleSpreadDoc(rawArray[i], true);

      if (rawArray[i] !== spreadDoc) {
        rawArray[i] = spreadDoc;
      } else {
        rawArray[i] = rawArray[i].toObject({
          transform: false,
          // Special case: if different model, but same schema, apply virtuals
          // re: gh-7898
          virtuals: rawArray[i].schema === Constructor.schema
        });
      }
    }

    if (rawArray[i] instanceof Subdocument) {
      if (rawArray[i][documentArrayParent] !== doc) {
        if (init) {
          var _subdoc2 = new Constructor(null, value, initDocumentOptions, selected, i);

          rawArray[i] = _subdoc2.$init(rawArray[i]);
        } else {
          var _subdoc3 = new Constructor(rawArray[i], value, undefined, undefined, i);

          rawArray[i] = _subdoc3;
        }
      } // Might not have the correct index yet, so ensure it does.


      if (rawArray[i].__index == null) {
        rawArray[i].$setIndex(i);
      }
    } else if (rawArray[i] != null) {
      if (init) {
        if (doc) {
          selected || (selected = scopePaths(this, doc.$__.selected, init));
        } else {
          selected = true;
        }

        subdoc = new Constructor(null, value, initDocumentOptions, selected, i);
        rawArray[i] = subdoc.$init(rawArray[i]);
      } else {
        if (prev && typeof prev.id === 'function') {
          subdoc = prev.id(rawArray[i]._id);
        }

        if (prev && subdoc && utils.deepEqual(subdoc.toObject(_toObjectOptions), rawArray[i])) {
          // handle resetting doc with existing id and same data
          subdoc.set(rawArray[i]); // if set() is hooked it will have no return value
          // see gh-746

          rawArray[i] = subdoc;
        } else {
          try {
            subdoc = new Constructor(rawArray[i], value, undefined, undefined, i); // if set() is hooked it will have no return value
            // see gh-746

            rawArray[i] = subdoc;
          } catch (error) {
            throw new CastError('embedded', rawArray[i], value[arrayPathSymbol], error, this);
          }
        }
      }
    }
  }

  return value;
};
/*!
 * ignore
 */


DocumentArrayPath.prototype.clone = function () {
  var options = Object.assign({}, this.options);
  var schematype = new this.constructor(this.path, this.schema, options, this.schemaOptions);
  schematype.validators = this.validators.slice();

  if (this.requiredValidator !== undefined) {
    schematype.requiredValidator = this.requiredValidator;
  }

  schematype.Constructor.discriminators = Object.assign({}, this.Constructor.discriminators);
  return schematype;
};
/*!
 * ignore
 */


DocumentArrayPath.prototype.applyGetters = function (value, scope) {
  return SchemaType.prototype.applyGetters.call(this, value, scope);
};
/*!
 * Scopes paths selected in a query to this array.
 * Necessary for proper default application of subdocument values.
 *
 * @param {DocumentArrayPath} array - the array to scope `fields` paths
 * @param {Object|undefined} fields - the root fields selected in the query
 * @param {Boolean|undefined} init - if we are being created part of a query result
 */


function scopePaths(array, fields, init) {
  if (!(init && fields)) {
    return undefined;
  }

  var path = array.path + '.';
  var keys = Object.keys(fields);
  var i = keys.length;
  var selected = {};
  var hasKeys;
  var key;
  var sub;

  while (i--) {
    key = keys[i];

    if (key.startsWith(path)) {
      sub = key.substring(path.length);

      if (sub === '$') {
        continue;
      }

      if (sub.startsWith('$.')) {
        sub = sub.substring(2);
      }

      hasKeys || (hasKeys = true);
      selected[sub] = fields[key];
    }
  }

  return hasKeys && selected || undefined;
}
/**
 * Sets a default option for all DocumentArray instances.
 *
 * #### Example:
 *
 *     // Make all numbers have option `min` equal to 0.
 *     mongoose.Schema.DocumentArray.set('_id', false);
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */


DocumentArrayPath.defaultOptions = {};
DocumentArrayPath.set = SchemaType.set;
/*!
 * Module exports.
 */

module.exports = DocumentArrayPath;

/***/ }),

/***/ 5251:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module exports.
 */


exports.String = __webpack_require__(6542);
exports.Number = __webpack_require__(1751);
exports.Boolean = __webpack_require__(6470);
exports.DocumentArray = __webpack_require__(4504);
exports.Subdocument = __webpack_require__(3617);
exports.Array = __webpack_require__(94);
exports.Buffer = __webpack_require__(8800);
exports.Date = __webpack_require__(6535);
exports.ObjectId = __webpack_require__(7116);
exports.Mixed = __webpack_require__(3861);
exports.Decimal128 = exports.Decimal = __webpack_require__(6621);
exports.Map = __webpack_require__(71); // alias

exports.Oid = exports.ObjectId;
exports.Object = exports.Mixed;
exports.Bool = exports.Boolean;
exports.ObjectID = exports.ObjectId;

/***/ }),

/***/ 71:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * ignore
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var MongooseMap = __webpack_require__(3828);

var SchemaMapOptions = __webpack_require__(8227);

var SchemaType = __webpack_require__(4289);
/*!
 * ignore
 */


var Map = /*#__PURE__*/function (_SchemaType) {
  _inherits(Map, _SchemaType);

  var _super = _createSuper(Map);

  function Map(key, options) {
    var _this;

    _classCallCheck(this, Map);

    _this = _super.call(this, key, options, 'Map');
    _this.$isSchemaMap = true;
    return _this;
  }

  _createClass(Map, [{
    key: "set",
    value: function set(option, value) {
      return SchemaType.set(option, value);
    }
  }, {
    key: "cast",
    value: function cast(val, doc, init) {
      if (val instanceof MongooseMap) {
        return val;
      }

      var path = this.path;

      if (init) {
        var map = new MongooseMap({}, path, doc, this.$__schemaType);

        if (val instanceof __webpack_require__.g.Map) {
          var _iterator = _createForOfIteratorHelper(val.keys()),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var key = _step.value;

              var _val = val.get(key);

              if (_val == null) {
                _val = map.$__schemaType._castNullish(_val);
              } else {
                _val = map.$__schemaType.cast(_val, doc, true, null, {
                  path: path + '.' + key
                });
              }

              map.$init(key, _val);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        } else {
          for (var _i = 0, _Object$keys = Object.keys(val); _i < _Object$keys.length; _i++) {
            var _key = _Object$keys[_i];
            var _val2 = val[_key];

            if (_val2 == null) {
              _val2 = map.$__schemaType._castNullish(_val2);
            } else {
              _val2 = map.$__schemaType.cast(_val2, doc, true, null, {
                path: path + '.' + _key
              });
            }

            map.$init(_key, _val2);
          }
        }

        return map;
      }

      return new MongooseMap(val, path, doc, this.$__schemaType);
    }
  }, {
    key: "clone",
    value: function clone() {
      var schematype = _get(_getPrototypeOf(Map.prototype), "clone", this).call(this);

      if (this.$__schemaType != null) {
        schematype.$__schemaType = this.$__schemaType.clone();
      }

      return schematype;
    }
  }]);

  return Map;
}(SchemaType);
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


Map.schemaName = 'Map';
Map.prototype.OptionsConstructor = SchemaMapOptions;
Map.defaultOptions = {};
module.exports = Map;

/***/ }),

/***/ 3861:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var SchemaType = __webpack_require__(4289);

var symbols = __webpack_require__(8107);

var isObject = __webpack_require__(5721);

var utils = __webpack_require__(6872);
/**
 * Mixed SchemaType constructor.
 *
 * @param {String} path
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */


function Mixed(path, options) {
  if (options && options["default"]) {
    var def = options["default"];

    if (Array.isArray(def) && def.length === 0) {
      // make sure empty array defaults are handled
      options["default"] = Array;
    } else if (!options.shared && isObject(def) && Object.keys(def).length === 0) {
      // prevent odd "shared" objects between documents
      options["default"] = function () {
        return {};
      };
    }
  }

  SchemaType.call(this, path, options, 'Mixed');
  this[symbols.schemaMixedSymbol] = true;
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


Mixed.schemaName = 'Mixed';
Mixed.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

Mixed.prototype = Object.create(SchemaType.prototype);
Mixed.prototype.constructor = Mixed;
/**
 * Attaches a getter for all Mixed paths.
 *
 * #### Example:
 *
 *     // Hide the 'hidden' path
 *     mongoose.Schema.Mixed.get(v => Object.assign({}, v, { hidden: null }));
 *
 *     const Model = mongoose.model('Test', new Schema({ test: {} }));
 *     new Model({ test: { hidden: 'Secret!' } }).test.hidden; // null
 *
 * @param {Function} getter
 * @return {this}
 * @function get
 * @static
 * @api public
 */

Mixed.get = SchemaType.get;
/**
 * Sets a default option for all Mixed instances.
 *
 * #### Example:
 *
 *     // Make all mixed instances have `required` of true by default.
 *     mongoose.Schema.Mixed.set('required', true);
 *
 *     const User = mongoose.model('User', new Schema({ test: mongoose.Mixed }));
 *     new User({ }).validateSync().errors.test.message; // Path `test` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

Mixed.set = SchemaType.set;
/**
 * Casts `val` for Mixed.
 *
 * _this is a no-op_
 *
 * @param {Object} value to cast
 * @api private
 */

Mixed.prototype.cast = function (val) {
  if (val instanceof Error) {
    return utils.errorToPOJO(val);
  }

  return val;
};
/**
 * Casts contents for queries.
 *
 * @param {String} $cond
 * @param {any} [val]
 * @api private
 */


Mixed.prototype.castForQuery = function ($cond, val) {
  if (arguments.length === 2) {
    return val;
  }

  return $cond;
};
/*!
 * Module exports.
 */


module.exports = Mixed;

/***/ }),

/***/ 1751:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module requirements.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var MongooseError = __webpack_require__(4888);

var SchemaNumberOptions = __webpack_require__(8491);

var SchemaType = __webpack_require__(4289);

var castNumber = __webpack_require__(3065);

var handleBitwiseOperator = __webpack_require__(4282);

var utils = __webpack_require__(6872);

var CastError = SchemaType.CastError;
/**
 * Number SchemaType constructor.
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function SchemaNumber(key, options) {
  SchemaType.call(this, key, options, 'Number');
}
/**
 * Attaches a getter for all Number instances.
 *
 * #### Example:
 *
 *     // Make all numbers round down
 *     mongoose.Number.get(function(v) { return Math.floor(v); });
 *
 *     const Model = mongoose.model('Test', new Schema({ test: Number }));
 *     new Model({ test: 3.14 }).test; // 3
 *
 * @param {Function} getter
 * @return {this}
 * @function get
 * @static
 * @api public
 */


SchemaNumber.get = SchemaType.get;
/**
 * Sets a default option for all Number instances.
 *
 * #### Example:
 *
 *     // Make all numbers have option `min` equal to 0.
 *     mongoose.Schema.Number.set('min', 0);
 *
 *     const Order = mongoose.model('Order', new Schema({ amount: Number }));
 *     new Order({ amount: -10 }).validateSync().errors.amount.message; // Path `amount` must be larger than 0.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

SchemaNumber.set = SchemaType.set;
/*!
 * ignore
 */

SchemaNumber._cast = castNumber;
/**
 * Get/set the function used to cast arbitrary values to numbers.
 *
 * #### Example:
 *
 *     // Make Mongoose cast empty strings '' to 0 for paths declared as numbers
 *     const original = mongoose.Number.cast();
 *     mongoose.Number.cast(v => {
 *       if (v === '') { return 0; }
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.Number.cast(false);
 *
 * @param {Function} caster
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

SchemaNumber.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


SchemaNumber._defaultCaster = function (v) {
  if (typeof v !== 'number') {
    throw new Error();
  }

  return v;
};
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaNumber.schemaName = 'Number';
SchemaNumber.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

SchemaNumber.prototype = Object.create(SchemaType.prototype);
SchemaNumber.prototype.constructor = SchemaNumber;
SchemaNumber.prototype.OptionsConstructor = SchemaNumberOptions;
/*!
 * ignore
 */

SchemaNumber._checkRequired = function (v) {
  return typeof v === 'number' || v instanceof Number;
};
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


SchemaNumber.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

SchemaNumber.prototype.checkRequired = function checkRequired(value, doc) {
  if (_typeof(value) === 'object' && SchemaType._isRef(this, value, doc, true)) {
    return value != null;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : SchemaNumber.checkRequired();

  return _checkRequired(value);
};
/**
 * Sets a minimum number validator.
 *
 * #### Example:
 *
 *     const s = new Schema({ n: { type: Number, min: 10 })
 *     const M = db.model('M', s)
 *     const m = new M({ n: 9 })
 *     m.save(function (err) {
 *       console.error(err) // validator error
 *       m.n = 10;
 *       m.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MIN} token which will be replaced with the invalid value
 *     const min = [10, 'The value of path `{PATH}` ({VALUE}) is beneath the limit ({MIN}).'];
 *     const schema = new Schema({ n: { type: Number, min: min })
 *     const M = mongoose.model('Measurement', schema);
 *     const s= new M({ n: 4 });
 *     s.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `n` (4) is beneath the limit (10).
 *     })
 *
 * @param {Number} value minimum number
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaNumber.prototype.min = function (value, message) {
  if (this.minValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.minValidator;
    }, this);
  }

  if (value !== null && value !== undefined) {
    var msg = message || MongooseError.messages.Number.min;
    msg = msg.replace(/{MIN}/, value);
    this.validators.push({
      validator: this.minValidator = function (v) {
        return v == null || v >= value;
      },
      message: msg,
      type: 'min',
      min: value
    });
  }

  return this;
};
/**
 * Sets a maximum number validator.
 *
 * #### Example:
 *
 *     const s = new Schema({ n: { type: Number, max: 10 })
 *     const M = db.model('M', s)
 *     const m = new M({ n: 11 })
 *     m.save(function (err) {
 *       console.error(err) // validator error
 *       m.n = 10;
 *       m.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MAX} token which will be replaced with the invalid value
 *     const max = [10, 'The value of path `{PATH}` ({VALUE}) exceeds the limit ({MAX}).'];
 *     const schema = new Schema({ n: { type: Number, max: max })
 *     const M = mongoose.model('Measurement', schema);
 *     const s= new M({ n: 4 });
 *     s.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `n` (4) exceeds the limit (10).
 *     })
 *
 * @param {Number} maximum number
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaNumber.prototype.max = function (value, message) {
  if (this.maxValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.maxValidator;
    }, this);
  }

  if (value !== null && value !== undefined) {
    var msg = message || MongooseError.messages.Number.max;
    msg = msg.replace(/{MAX}/, value);
    this.validators.push({
      validator: this.maxValidator = function (v) {
        return v == null || v <= value;
      },
      message: msg,
      type: 'max',
      max: value
    });
  }

  return this;
};
/**
 * Sets a enum validator
 *
 * #### Example:
 *
 *     const s = new Schema({ n: { type: Number, enum: [1, 2, 3] });
 *     const M = db.model('M', s);
 *
 *     const m = new M({ n: 4 });
 *     await m.save(); // throws validation error
 *
 *     m.n = 3;
 *     await m.save(); // succeeds
 *
 * @param {Array} values allowed values
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaNumber.prototype["enum"] = function (values, message) {
  if (this.enumValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.enumValidator;
    }, this);
  }

  if (!Array.isArray(values)) {
    var isObjectSyntax = utils.isPOJO(values) && values.values != null;

    if (isObjectSyntax) {
      message = values.message;
      values = values.values;
    } else if (typeof values === 'number') {
      values = Array.prototype.slice.call(arguments);
      message = null;
    }

    if (utils.isPOJO(values)) {
      values = Object.values(values);
    }

    message = message || MongooseError.messages.Number["enum"];
  }

  message = message == null ? MongooseError.messages.Number["enum"] : message;

  this.enumValidator = function (v) {
    return v == null || values.indexOf(v) !== -1;
  };

  this.validators.push({
    validator: this.enumValidator,
    message: message,
    type: 'enum',
    enumValues: values
  });
  return this;
};
/**
 * Casts to number
 *
 * @param {Object} value value to cast
 * @param {Document} doc document that triggers the casting
 * @param {Boolean} init
 * @api private
 */


SchemaNumber.prototype.cast = function (value, doc, init) {
  if (typeof value !== 'number' && SchemaType._isRef(this, value, doc, init)) {
    if (value == null || utils.isNonBuiltinObject(value)) {
      return this._castRef(value, doc, init);
    }
  }

  var val = value && typeof value._id !== 'undefined' ? value._id : // documents
  value;
  var castNumber;

  if (typeof this._castFunction === 'function') {
    castNumber = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castNumber = this.constructor.cast();
  } else {
    castNumber = SchemaNumber.cast();
  }

  try {
    return castNumber(val);
  } catch (err) {
    throw new CastError('Number', val, this.path, err, this);
  }
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.cast(val);
}

function handleArray(val) {
  var _this = this;

  if (!Array.isArray(val)) {
    return [this.cast(val)];
  }

  return val.map(function (m) {
    return _this.cast(m);
  });
}

SchemaNumber.prototype.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $bitsAllClear: handleBitwiseOperator,
  $bitsAnyClear: handleBitwiseOperator,
  $bitsAllSet: handleBitwiseOperator,
  $bitsAnySet: handleBitwiseOperator,
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle,
  $mod: handleArray
});
/**
 * Casts contents for queries.
 *
 * @param {String} $conditional
 * @param {any} [value]
 * @api private
 */

SchemaNumber.prototype.castForQuery = function ($conditional, val) {
  var handler;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new CastError('number', val, this.path, null, this);
    }

    return handler.call(this, val);
  }

  val = this._castForQuery($conditional);
  return val;
};
/*!
 * Module exports.
 */


module.exports = SchemaNumber;

/***/ }),

/***/ 7116:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var SchemaObjectIdOptions = __webpack_require__(8172);

var SchemaType = __webpack_require__(4289);

var castObjectId = __webpack_require__(4731);

var getConstructorName = __webpack_require__(1981);

var oid = __webpack_require__(6079);

var isBsonType = __webpack_require__(1563);

var utils = __webpack_require__(6872);

var CastError = SchemaType.CastError;
var Document;
/**
 * ObjectId SchemaType constructor.
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function ObjectId(key, options) {
  var isKeyHexStr = typeof key === 'string' && key.length === 24 && /^[a-f0-9]+$/i.test(key);
  var suppressWarning = options && options.suppressWarning;

  if ((isKeyHexStr || typeof key === 'undefined') && !suppressWarning) {
    utils.warn('mongoose: To create a new ObjectId please try ' + '`Mongoose.Types.ObjectId` instead of using ' + '`Mongoose.Schema.ObjectId`. Set the `suppressWarning` option if ' + 'you\'re trying to create a hex char path in your schema.');
  }

  SchemaType.call(this, key, options, 'ObjectID');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


ObjectId.schemaName = 'ObjectId';
ObjectId.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

ObjectId.prototype = Object.create(SchemaType.prototype);
ObjectId.prototype.constructor = ObjectId;
ObjectId.prototype.OptionsConstructor = SchemaObjectIdOptions;
/**
 * Attaches a getter for all ObjectId instances
 *
 * #### Example:
 *
 *     // Always convert to string when getting an ObjectId
 *     mongoose.ObjectId.get(v => v.toString());
 *
 *     const Model = mongoose.model('Test', new Schema({}));
 *     typeof (new Model({})._id); // 'string'
 *
 * @param {Function} getter
 * @return {this}
 * @function get
 * @static
 * @api public
 */

ObjectId.get = SchemaType.get;
/**
 * Sets a default option for all ObjectId instances.
 *
 * #### Example:
 *
 *     // Make all object ids have option `required` equal to true.
 *     mongoose.Schema.ObjectId.set('required', true);
 *
 *     const Order = mongoose.model('Order', new Schema({ userId: ObjectId }));
 *     new Order({ }).validateSync().errors.userId.message; // Path `userId` is required.
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

ObjectId.set = SchemaType.set;
/**
 * Adds an auto-generated ObjectId default if turnOn is true.
 * @param {Boolean} turnOn auto generated ObjectId defaults
 * @api public
 * @return {SchemaType} this
 */

ObjectId.prototype.auto = function (turnOn) {
  if (turnOn) {
    this["default"](defaultId);
    this.set(resetId);
  }

  return this;
};
/*!
 * ignore
 */


ObjectId._checkRequired = function (v) {
  return isBsonType(v, 'ObjectID');
};
/*!
 * ignore
 */


ObjectId._cast = castObjectId;
/**
 * Get/set the function used to cast arbitrary values to objectids.
 *
 * #### Example:
 *
 *     // Make Mongoose only try to cast length 24 strings. By default, any 12
 *     // char string is a valid ObjectId.
 *     const original = mongoose.ObjectId.cast();
 *     mongoose.ObjectId.cast(v => {
 *       assert.ok(typeof v !== 'string' || v.length === 24);
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.ObjectId.cast(false);
 *
 * @param {Function} caster
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

ObjectId.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


ObjectId._defaultCaster = function (v) {
  if (!isBsonType(v, 'ObjectID')) {
    throw new Error(v + ' is not an instance of ObjectId');
  }

  return v;
};
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * #### Example:
 *
 *     // Allow empty strings to pass `required` check
 *     mongoose.Schema.Types.String.checkRequired(v => v != null);
 *
 *     const M = mongoose.model({ str: { type: String, required: true } });
 *     new M({ str: '' }).validateSync(); // `null`, validation passes!
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


ObjectId.checkRequired = SchemaType.checkRequired;
/**
 * Check if the given value satisfies a required validator.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */

ObjectId.prototype.checkRequired = function checkRequired(value, doc) {
  if (SchemaType._isRef(this, value, doc, true)) {
    return !!value;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : ObjectId.checkRequired();

  return _checkRequired(value);
};
/**
 * Casts to ObjectId
 *
 * @param {Object} value
 * @param {Object} doc
 * @param {Boolean} init whether this is an initialization cast
 * @api private
 */


ObjectId.prototype.cast = function (value, doc, init) {
  if (!isBsonType(value, 'ObjectID') && SchemaType._isRef(this, value, doc, init)) {
    // wait! we may need to cast this to a document
    if ((getConstructorName(value) || '').toLowerCase() === 'objectid') {
      return new oid(value.toHexString());
    }

    if (value == null || utils.isNonBuiltinObject(value)) {
      return this._castRef(value, doc, init);
    }
  }

  var castObjectId;

  if (typeof this._castFunction === 'function') {
    castObjectId = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castObjectId = this.constructor.cast();
  } else {
    castObjectId = ObjectId.cast();
  }

  try {
    return castObjectId(value);
  } catch (error) {
    throw new CastError('ObjectId', value, this.path, error, this);
  }
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.cast(val);
}

ObjectId.prototype.$conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle
});
/*!
 * ignore
 */

function defaultId() {
  return new oid();
}

defaultId.$runBeforeSetters = true;

function resetId(v) {
  Document || (Document = __webpack_require__(8727));

  if (this instanceof Document) {
    if (v === void 0) {
      var _v = new oid();

      return _v;
    }
  }

  return v;
}
/*!
 * Module exports.
 */


module.exports = ObjectId;

/***/ }),

/***/ 4282:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];
/*!
 * Module requirements.
 */


var CastError = __webpack_require__(1795);
/*!
 * ignore
 */


function handleBitwiseOperator(val) {
  var _this = this;

  if (Array.isArray(val)) {
    return val.map(function (v) {
      return _castNumber(_this.path, v);
    });
  } else if (Buffer.isBuffer(val)) {
    return val;
  } // Assume trying to cast to number


  return _castNumber(_this.path, val);
}
/*!
 * ignore
 */


function _castNumber(path, num) {
  var v = Number(num);

  if (isNaN(v)) {
    throw new CastError('number', num, path);
  }

  return v;
}

module.exports = handleBitwiseOperator;

/***/ }),

/***/ 8702:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var castBoolean = __webpack_require__(6670);
/*!
 * ignore
 */


module.exports = function (val) {
  var path = this != null ? this.path : null;
  return castBoolean(val, path);
};

/***/ }),

/***/ 5008:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module requirements.
 */


var castArraysOfNumbers = (__webpack_require__(1521)/* .castArraysOfNumbers */ .i);

var castToNumber = (__webpack_require__(1521)/* .castToNumber */ .W);
/*!
 * ignore
 */


exports.cast$geoIntersects = cast$geoIntersects;
exports.cast$near = cast$near;
exports.cast$within = cast$within;

function cast$near(val) {
  var SchemaArray = __webpack_require__(94);

  if (Array.isArray(val)) {
    castArraysOfNumbers(val, this);
    return val;
  }

  _castMinMaxDistance(this, val);

  if (val && val.$geometry) {
    return cast$geometry(val, this);
  }

  if (!Array.isArray(val)) {
    throw new TypeError('$near must be either an array or an object ' + 'with a $geometry property');
  }

  return SchemaArray.prototype.castForQuery.call(this, val);
}

function cast$geometry(val, self) {
  switch (val.$geometry.type) {
    case 'Polygon':
    case 'LineString':
    case 'Point':
      castArraysOfNumbers(val.$geometry.coordinates, self);
      break;

    default:
      // ignore unknowns
      break;
  }

  _castMinMaxDistance(self, val);

  return val;
}

function cast$within(val) {
  var _this = this;

  _castMinMaxDistance(this, val);

  if (val.$box || val.$polygon) {
    var type = val.$box ? '$box' : '$polygon';
    val[type].forEach(function (arr) {
      if (!Array.isArray(arr)) {
        var msg = 'Invalid $within $box argument. ' + 'Expected an array, received ' + arr;
        throw new TypeError(msg);
      }

      arr.forEach(function (v, i) {
        arr[i] = castToNumber.call(_this, v);
      });
    });
  } else if (val.$center || val.$centerSphere) {
    var _type = val.$center ? '$center' : '$centerSphere';

    val[_type].forEach(function (item, i) {
      if (Array.isArray(item)) {
        item.forEach(function (v, j) {
          item[j] = castToNumber.call(_this, v);
        });
      } else {
        val[_type][i] = castToNumber.call(_this, item);
      }
    });
  } else if (val.$geometry) {
    cast$geometry(val, this);
  }

  return val;
}

function cast$geoIntersects(val) {
  var geo = val.$geometry;

  if (!geo) {
    return;
  }

  cast$geometry(val, this);
  return val;
}

function _castMinMaxDistance(self, val) {
  if (val.$maxDistance) {
    val.$maxDistance = castToNumber.call(self, val.$maxDistance);
  }

  if (val.$minDistance) {
    val.$minDistance = castToNumber.call(self, val.$minDistance);
  }
}

/***/ }),

/***/ 1521:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Module requirements.
 */

var SchemaNumber = __webpack_require__(1751);
/*!
 * @ignore
 */


exports.W = castToNumber;
exports.i = castArraysOfNumbers;
/*!
 * @ignore
 */

function castToNumber(val) {
  return SchemaNumber.cast()(val);
}

function castArraysOfNumbers(arr, self) {
  arr.forEach(function (v, i) {
    if (Array.isArray(v)) {
      castArraysOfNumbers(v, self);
    } else {
      arr[i] = castToNumber.call(self, v);
    }
  });
}

/***/ }),

/***/ 6495:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var CastError = __webpack_require__(1795);

var castBoolean = __webpack_require__(6670);

var castString = __webpack_require__(2417);
/*!
 * Casts val to an object suitable for `$text`. Throws an error if the object
 * can't be casted.
 *
 * @param {Any} val value to cast
 * @param {String} [path] path to associate with any errors that occured
 * @return {Object} casted object
 * @see https://docs.mongodb.com/manual/reference/operator/query/text/
 * @api private
 */


module.exports = function (val, path) {
  if (val == null || _typeof(val) !== 'object') {
    throw new CastError('$text', val, path);
  }

  if (val.$search != null) {
    val.$search = castString(val.$search, path + '.$search');
  }

  if (val.$language != null) {
    val.$language = castString(val.$language, path + '.$language');
  }

  if (val.$caseSensitive != null) {
    val.$caseSensitive = castBoolean(val.$caseSensitive, path + '.$castSensitive');
  }

  if (val.$diacriticSensitive != null) {
    val.$diacriticSensitive = castBoolean(val.$diacriticSensitive, path + '.$diacriticSensitive');
  }

  return val;
};

/***/ }),

/***/ 3053:
/***/ ((module) => {

"use strict";

/*!
 * ignore
 */

module.exports = function (val) {
  if (Array.isArray(val)) {
    if (!val.every(function (v) {
      return typeof v === 'number' || typeof v === 'string';
    })) {
      throw new Error('$type array values must be strings or numbers');
    }

    return val;
  }

  if (typeof val !== 'number' && typeof val !== 'string') {
    throw new Error('$type parameter must be number, string, or array of numbers and strings');
  }

  return val;
};

/***/ }),

/***/ 6542:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var SchemaType = __webpack_require__(4289);

var MongooseError = __webpack_require__(4888);

var SchemaStringOptions = __webpack_require__(3209);

var castString = __webpack_require__(2417);

var utils = __webpack_require__(6872);

var isBsonType = __webpack_require__(1563);

var CastError = SchemaType.CastError;
/**
 * String SchemaType constructor.
 *
 * @param {String} key
 * @param {Object} options
 * @inherits SchemaType
 * @api public
 */

function SchemaString(key, options) {
  this.enumValues = [];
  this.regExp = null;
  SchemaType.call(this, key, options, 'String');
}
/**
 * This schema type's name, to defend against minifiers that mangle
 * function names.
 *
 * @api public
 */


SchemaString.schemaName = 'String';
SchemaString.defaultOptions = {};
/*!
 * Inherits from SchemaType.
 */

SchemaString.prototype = Object.create(SchemaType.prototype);
SchemaString.prototype.constructor = SchemaString;
Object.defineProperty(SchemaString.prototype, 'OptionsConstructor', {
  configurable: false,
  enumerable: false,
  writable: false,
  value: SchemaStringOptions
});
/*!
 * ignore
 */

SchemaString._cast = castString;
/**
 * Get/set the function used to cast arbitrary values to strings.
 *
 * #### Example:
 *
 *     // Throw an error if you pass in an object. Normally, Mongoose allows
 *     // objects with custom `toString()` functions.
 *     const original = mongoose.Schema.Types.String.cast();
 *     mongoose.Schema.Types.String.cast(v => {
 *       assert.ok(v == null || typeof v !== 'object');
 *       return original(v);
 *     });
 *
 *     // Or disable casting entirely
 *     mongoose.Schema.Types.String.cast(false);
 *
 * @param {Function} caster
 * @return {Function}
 * @function get
 * @static
 * @api public
 */

SchemaString.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = this._defaultCaster;
  }

  this._cast = caster;
  return this._cast;
};
/*!
 * ignore
 */


SchemaString._defaultCaster = function (v) {
  if (v != null && typeof v !== 'string') {
    throw new Error();
  }

  return v;
};
/**
 * Attaches a getter for all String instances.
 *
 * #### Example:
 *
 *     // Make all numbers round down
 *     mongoose.Schema.String.get(v => v.toLowerCase());
 *
 *     const Model = mongoose.model('Test', new Schema({ test: String }));
 *     new Model({ test: 'FOO' }).test; // 'foo'
 *
 * @param {Function} getter
 * @return {this}
 * @function get
 * @static
 * @api public
 */


SchemaString.get = SchemaType.get;
/**
 * Sets a default option for all String instances.
 *
 * #### Example:
 *
 *     // Make all strings have option `trim` equal to true.
 *     mongoose.Schema.String.set('trim', true);
 *
 *     const User = mongoose.model('User', new Schema({ name: String }));
 *     new User({ name: '   John Doe   ' }).name; // 'John Doe'
 *
 * @param {String} option - The option you'd like to set the value for
 * @param {*} value - value for option
 * @return {undefined}
 * @function set
 * @static
 * @api public
 */

SchemaString.set = SchemaType.set;
/*!
 * ignore
 */

SchemaString._checkRequired = function (v) {
  return (v instanceof String || typeof v === 'string') && v.length;
};
/**
 * Override the function the required validator uses to check whether a string
 * passes the `required` check.
 *
 * #### Example:
 *
 *     // Allow empty strings to pass `required` check
 *     mongoose.Schema.Types.String.checkRequired(v => v != null);
 *
 *     const M = mongoose.model({ str: { type: String, required: true } });
 *     new M({ str: '' }).validateSync(); // `null`, validation passes!
 *
 * @param {Function} fn
 * @return {Function}
 * @function checkRequired
 * @static
 * @api public
 */


SchemaString.checkRequired = SchemaType.checkRequired;
/**
 * Adds an enum validator
 *
 * #### Example:
 *
 *     const states = ['opening', 'open', 'closing', 'closed']
 *     const s = new Schema({ state: { type: String, enum: states }})
 *     const M = db.model('M', s)
 *     const m = new M({ state: 'invalid' })
 *     m.save(function (err) {
 *       console.error(String(err)) // ValidationError: `invalid` is not a valid enum value for path `state`.
 *       m.state = 'open'
 *       m.save(callback) // success
 *     })
 *
 *     // or with custom error messages
 *     const enum = {
 *       values: ['opening', 'open', 'closing', 'closed'],
 *       message: 'enum validator failed for path `{PATH}` with value `{VALUE}`'
 *     }
 *     const s = new Schema({ state: { type: String, enum: enum })
 *     const M = db.model('M', s)
 *     const m = new M({ state: 'invalid' })
 *     m.save(function (err) {
 *       console.error(String(err)) // ValidationError: enum validator failed for path `state` with value `invalid`
 *       m.state = 'open'
 *       m.save(callback) // success
 *     })
 *
 * @param {String|Object} [args...] enumeration values
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */

SchemaString.prototype["enum"] = function () {
  if (this.enumValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.enumValidator;
    }, this);
    this.enumValidator = false;
  }

  if (arguments[0] === void 0 || arguments[0] === false) {
    return this;
  }

  var values;
  var errorMessage;

  if (utils.isObject(arguments[0])) {
    if (Array.isArray(arguments[0].values)) {
      values = arguments[0].values;
      errorMessage = arguments[0].message;
    } else {
      values = utils.object.vals(arguments[0]);
      errorMessage = MongooseError.messages.String["enum"];
    }
  } else {
    values = arguments;
    errorMessage = MongooseError.messages.String["enum"];
  }

  var _iterator = _createForOfIteratorHelper(values),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var value = _step.value;

      if (value !== undefined) {
        this.enumValues.push(this.cast(value));
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var vals = this.enumValues;

  this.enumValidator = function (v) {
    return undefined === v || ~vals.indexOf(v);
  };

  this.validators.push({
    validator: this.enumValidator,
    message: errorMessage,
    type: 'enum',
    enumValues: vals
  });
  return this;
};
/**
 * Adds a lowercase [setter](https://mongoosejs.com/docs/api.html#schematype_SchemaType-set).
 *
 * #### Example:
 *
 *     const s = new Schema({ email: { type: String, lowercase: true }})
 *     const M = db.model('M', s);
 *     const m = new M({ email: 'SomeEmail@example.COM' });
 *     console.log(m.email) // someemail@example.com
 *     M.find({ email: 'SomeEmail@example.com' }); // Queries by 'someemail@example.com'
 *
 * Note that `lowercase` does **not** affect regular expression queries:
 *
 * #### Example:
 *     // Still queries for documents whose `email` matches the regular
 *     // expression /SomeEmail/. Mongoose does **not** convert the RegExp
 *     // to lowercase.
 *     M.find({ email: /SomeEmail/ });
 *
 * @api public
 * @return {SchemaType} this
 */


SchemaString.prototype.lowercase = function (shouldApply) {
  var _this2 = this;

  if (arguments.length > 0 && !shouldApply) {
    return this;
  }

  return this.set(function (v) {
    if (typeof v !== 'string') {
      v = _this2.cast(v);
    }

    if (v) {
      return v.toLowerCase();
    }

    return v;
  });
};
/**
 * Adds an uppercase [setter](https://mongoosejs.com/docs/api.html#schematype_SchemaType-set).
 *
 * #### Example:
 *
 *     const s = new Schema({ caps: { type: String, uppercase: true }})
 *     const M = db.model('M', s);
 *     const m = new M({ caps: 'an example' });
 *     console.log(m.caps) // AN EXAMPLE
 *     M.find({ caps: 'an example' }) // Matches documents where caps = 'AN EXAMPLE'
 *
 * Note that `uppercase` does **not** affect regular expression queries:
 *
 * #### Example:
 *     // Mongoose does **not** convert the RegExp to uppercase.
 *     M.find({ email: /an example/ });
 *
 * @api public
 * @return {SchemaType} this
 */


SchemaString.prototype.uppercase = function (shouldApply) {
  var _this3 = this;

  if (arguments.length > 0 && !shouldApply) {
    return this;
  }

  return this.set(function (v) {
    if (typeof v !== 'string') {
      v = _this3.cast(v);
    }

    if (v) {
      return v.toUpperCase();
    }

    return v;
  });
};
/**
 * Adds a trim [setter](https://mongoosejs.com/docs/api.html#schematype_SchemaType-set).
 *
 * The string value will be [trimmed](https://masteringjs.io/tutorials/fundamentals/trim-string) when set.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: { type: String, trim: true }});
 *     const M = db.model('M', s);
 *     const string = ' some name ';
 *     console.log(string.length); // 11
 *     const m = new M({ name: string });
 *     console.log(m.name.length); // 9
 *
 *     // Equivalent to `findOne({ name: string.trim() })`
 *     M.findOne({ name: string });
 *
 * Note that `trim` does **not** affect regular expression queries:
 *
 * #### Example:
 *     // Mongoose does **not** trim whitespace from the RegExp.
 *     M.find({ name: / some name / });
 *
 * @api public
 * @return {SchemaType} this
 */


SchemaString.prototype.trim = function (shouldTrim) {
  var _this4 = this;

  if (arguments.length > 0 && !shouldTrim) {
    return this;
  }

  return this.set(function (v) {
    if (typeof v !== 'string') {
      v = _this4.cast(v);
    }

    if (v) {
      return v.trim();
    }

    return v;
  });
};
/**
 * Sets a minimum length validator.
 *
 * #### Example:
 *
 *     const schema = new Schema({ postalCode: { type: String, minlength: 5 })
 *     const Address = db.model('Address', schema)
 *     const address = new Address({ postalCode: '9512' })
 *     address.save(function (err) {
 *       console.error(err) // validator error
 *       address.postalCode = '95125';
 *       address.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MINLENGTH} token which will be replaced with the minimum allowed length
 *     const minlength = [5, 'The value of path `{PATH}` (`{VALUE}`) is shorter than the minimum allowed length ({MINLENGTH}).'];
 *     const schema = new Schema({ postalCode: { type: String, minlength: minlength })
 *     const Address = mongoose.model('Address', schema);
 *     const address = new Address({ postalCode: '9512' });
 *     address.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `postalCode` (`9512`) is shorter than the minimum length (5).
 *     })
 *
 * @param {Number} value minimum string length
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */


SchemaString.prototype.minlength = function (value, message) {
  if (this.minlengthValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.minlengthValidator;
    }, this);
  }

  if (value !== null && value !== undefined) {
    var msg = message || MongooseError.messages.String.minlength;
    msg = msg.replace(/{MINLENGTH}/, value);
    this.validators.push({
      validator: this.minlengthValidator = function (v) {
        return v === null || v.length >= value;
      },
      message: msg,
      type: 'minlength',
      minlength: value
    });
  }

  return this;
};

SchemaString.prototype.minLength = SchemaString.prototype.minlength;
/**
 * Sets a maximum length validator.
 *
 * #### Example:
 *
 *     const schema = new Schema({ postalCode: { type: String, maxlength: 9 })
 *     const Address = db.model('Address', schema)
 *     const address = new Address({ postalCode: '9512512345' })
 *     address.save(function (err) {
 *       console.error(err) // validator error
 *       address.postalCode = '95125';
 *       address.save() // success
 *     })
 *
 *     // custom error messages
 *     // We can also use the special {MAXLENGTH} token which will be replaced with the maximum allowed length
 *     const maxlength = [9, 'The value of path `{PATH}` (`{VALUE}`) exceeds the maximum allowed length ({MAXLENGTH}).'];
 *     const schema = new Schema({ postalCode: { type: String, maxlength: maxlength })
 *     const Address = mongoose.model('Address', schema);
 *     const address = new Address({ postalCode: '9512512345' });
 *     address.validate(function (err) {
 *       console.log(String(err)) // ValidationError: The value of path `postalCode` (`9512512345`) exceeds the maximum allowed length (9).
 *     })
 *
 * @param {Number} value maximum string length
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */

SchemaString.prototype.maxlength = function (value, message) {
  if (this.maxlengthValidator) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.maxlengthValidator;
    }, this);
  }

  if (value !== null && value !== undefined) {
    var msg = message || MongooseError.messages.String.maxlength;
    msg = msg.replace(/{MAXLENGTH}/, value);
    this.validators.push({
      validator: this.maxlengthValidator = function (v) {
        return v === null || v.length <= value;
      },
      message: msg,
      type: 'maxlength',
      maxlength: value
    });
  }

  return this;
};

SchemaString.prototype.maxLength = SchemaString.prototype.maxlength;
/**
 * Sets a regexp validator.
 *
 * Any value that does not pass `regExp`.test(val) will fail validation.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: { type: String, match: /^a/ }})
 *     const M = db.model('M', s)
 *     const m = new M({ name: 'I am invalid' })
 *     m.validate(function (err) {
 *       console.error(String(err)) // "ValidationError: Path `name` is invalid (I am invalid)."
 *       m.name = 'apples'
 *       m.validate(function (err) {
 *         assert.ok(err) // success
 *       })
 *     })
 *
 *     // using a custom error message
 *     const match = [ /\.html$/, "That file doesn't end in .html ({VALUE})" ];
 *     const s = new Schema({ file: { type: String, match: match }})
 *     const M = db.model('M', s);
 *     const m = new M({ file: 'invalid' });
 *     m.validate(function (err) {
 *       console.log(String(err)) // "ValidationError: That file doesn't end in .html (invalid)"
 *     })
 *
 * Empty strings, `undefined`, and `null` values always pass the match validator. If you require these values, enable the `required` validator also.
 *
 *     const s = new Schema({ name: { type: String, match: /^a/, required: true }})
 *
 * @param {RegExp} regExp regular expression to test against
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @api public
 */

SchemaString.prototype.match = function match(regExp, message) {
  // yes, we allow multiple match validators
  var msg = message || MongooseError.messages.String.match;

  var matchValidator = function matchValidator(v) {
    if (!regExp) {
      return false;
    } // In case RegExp happens to have `/g` flag set, we need to reset the
    // `lastIndex`, otherwise `match` will intermittently fail.


    regExp.lastIndex = 0;
    var ret = v != null && v !== '' ? regExp.test(v) : true;
    return ret;
  };

  this.validators.push({
    validator: matchValidator,
    message: msg,
    type: 'regexp',
    regexp: regExp
  });
  return this;
};
/**
 * Check if the given value satisfies the `required` validator. The value is
 * considered valid if it is a string (that is, not `null` or `undefined`) and
 * has positive length. The `required` validator **will** fail for empty
 * strings.
 *
 * @param {Any} value
 * @param {Document} doc
 * @return {Boolean}
 * @api public
 */


SchemaString.prototype.checkRequired = function checkRequired(value, doc) {
  if (_typeof(value) === 'object' && SchemaType._isRef(this, value, doc, true)) {
    return value != null;
  } // `require('util').inherits()` does **not** copy static properties, and
  // plugins like mongoose-float use `inherits()` for pre-ES6.


  var _checkRequired = typeof this.constructor.checkRequired === 'function' ? this.constructor.checkRequired() : SchemaString.checkRequired();

  return _checkRequired(value);
};
/**
 * Casts to String
 *
 * @api private
 */


SchemaString.prototype.cast = function (value, doc, init) {
  if (typeof value !== 'string' && SchemaType._isRef(this, value, doc, init)) {
    return this._castRef(value, doc, init);
  }

  var castString;

  if (typeof this._castFunction === 'function') {
    castString = this._castFunction;
  } else if (typeof this.constructor.cast === 'function') {
    castString = this.constructor.cast();
  } else {
    castString = SchemaString.cast();
  }

  try {
    return castString(value);
  } catch (error) {
    throw new CastError('string', value, this.path, null, this);
  }
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.castForQuery(val);
}
/*!
 * ignore
 */


function handleArray(val) {
  var _this = this;

  if (!Array.isArray(val)) {
    return [this.castForQuery(val)];
  }

  return val.map(function (m) {
    return _this.castForQuery(m);
  });
}
/*!
 * ignore
 */


function handleSingleNoSetters(val) {
  if (val == null) {
    return this._castNullish(val);
  }

  return this.cast(val, this);
}

var $conditionalHandlers = utils.options(SchemaType.prototype.$conditionalHandlers, {
  $all: handleArray,
  $gt: handleSingle,
  $gte: handleSingle,
  $lt: handleSingle,
  $lte: handleSingle,
  $options: handleSingleNoSetters,
  $regex: function handle$regex(val) {
    if (Object.prototype.toString.call(val) === '[object RegExp]') {
      return val;
    }

    return handleSingleNoSetters.call(this, val);
  },
  $not: handleSingle
});
Object.defineProperty(SchemaString.prototype, '$conditionalHandlers', {
  configurable: false,
  enumerable: false,
  writable: false,
  value: Object.freeze($conditionalHandlers)
});
/**
 * Casts contents for queries.
 *
 * @param {String} $conditional
 * @param {any} [val]
 * @api private
 */

SchemaString.prototype.castForQuery = function ($conditional, val) {
  var handler;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new Error('Can\'t use ' + $conditional + ' with String.');
    }

    return handler.call(this, val);
  }

  val = $conditional;

  if (Object.prototype.toString.call(val) === '[object RegExp]' || isBsonType(val, 'BSONRegExp')) {
    return val;
  }

  return this._castForQuery(val);
};
/*!
 * Module exports.
 */


module.exports = SchemaString;

/***/ }),

/***/ 8107:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.schemaMixedSymbol = Symbol["for"]('mongoose:schema_mixed');
exports.builtInMiddleware = Symbol["for"]('mongoose:built-in-middleware');

/***/ }),

/***/ 4289:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];

/*!
 * Module dependencies.
 */

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var MongooseError = __webpack_require__(4888);

var SchemaTypeOptions = __webpack_require__(1764);

var $exists = __webpack_require__(8702);

var $type = __webpack_require__(3053);

var handleImmutable = __webpack_require__(8828);

var isAsyncFunction = __webpack_require__(8857);

var isSimpleValidator = __webpack_require__(9130);

var immediate = __webpack_require__(1490);

var schemaTypeSymbol = (__webpack_require__(8770).schemaTypeSymbol);

var utils = __webpack_require__(6872);

var validatorErrorSymbol = (__webpack_require__(8770).validatorErrorSymbol);

var documentIsModified = (__webpack_require__(8770).documentIsModified);

var populateModelSymbol = (__webpack_require__(8770).populateModelSymbol);

var CastError = MongooseError.CastError;
var ValidatorError = MongooseError.ValidatorError;
var setOptionsForDefaults = {
  _skipMarkModified: true
};
/**
 * SchemaType constructor. Do **not** instantiate `SchemaType` directly.
 * Mongoose converts your schema paths into SchemaTypes automatically.
 *
 * #### Example:
 *
 *     const schema = new Schema({ name: String });
 *     schema.path('name') instanceof SchemaType; // true
 *
 * @param {String} path
 * @param {SchemaTypeOptions} [options] See [SchemaTypeOptions docs](/docs/api/schematypeoptions.html)
 * @param {String} [instance]
 * @api public
 */

function SchemaType(path, options, instance) {
  this[schemaTypeSymbol] = true;
  this.path = path;
  this.instance = instance;
  this.validators = [];
  this.getters = this.constructor.hasOwnProperty('getters') ? this.constructor.getters.slice() : [];
  this.setters = [];
  this.splitPath();
  options = options || {};
  var defaultOptions = this.constructor.defaultOptions || {};
  var defaultOptionsKeys = Object.keys(defaultOptions);

  for (var _i = 0, _defaultOptionsKeys = defaultOptionsKeys; _i < _defaultOptionsKeys.length; _i++) {
    var option = _defaultOptionsKeys[_i];

    if (defaultOptions.hasOwnProperty(option) && !options.hasOwnProperty(option)) {
      options[option] = defaultOptions[option];
    }
  }

  if (options.select == null) {
    delete options.select;
  }

  var Options = this.OptionsConstructor || SchemaTypeOptions;
  this.options = new Options(options);
  this._index = null;

  if (utils.hasUserDefinedProperty(this.options, 'immutable')) {
    this.$immutable = this.options.immutable;
    handleImmutable(this);
  }

  var keys = Object.keys(this.options);

  for (var _i2 = 0, _keys = keys; _i2 < _keys.length; _i2++) {
    var prop = _keys[_i2];

    if (prop === 'cast') {
      this.castFunction(this.options[prop]);
      continue;
    }

    if (utils.hasUserDefinedProperty(this.options, prop) && typeof this[prop] === 'function') {
      // { unique: true, index: true }
      if (prop === 'index' && this._index) {
        if (options.index === false) {
          var index = this._index;

          if (_typeof(index) === 'object' && index != null) {
            if (index.unique) {
              throw new Error('Path "' + this.path + '" may not have `index` ' + 'set to false and `unique` set to true');
            }

            if (index.sparse) {
              throw new Error('Path "' + this.path + '" may not have `index` ' + 'set to false and `sparse` set to true');
            }
          }

          this._index = false;
        }

        continue;
      }

      var val = options[prop]; // Special case so we don't screw up array defaults, see gh-5780

      if (prop === 'default') {
        this["default"](val);
        continue;
      }

      var opts = Array.isArray(val) ? val : [val];
      this[prop].apply(this, opts);
    }
  }

  Object.defineProperty(this, '$$context', {
    enumerable: false,
    configurable: false,
    writable: true,
    value: null
  });
}
/*!
 * The class that Mongoose uses internally to instantiate this SchemaType's `options` property.
 */


SchemaType.prototype.OptionsConstructor = SchemaTypeOptions;
/**
 * The path to this SchemaType in a Schema.
 *
 * #### Example:
 *     const schema = new Schema({ name: String });
 *     schema.path('name').path; // 'name'
 *
 * @property path
 * @api public
 * @memberOf SchemaType
 */

SchemaType.prototype.path;
/**
 * The validators that Mongoose should run to validate properties at this SchemaType's path.
 *
 * #### Example:
 *     const schema = new Schema({ name: { type: String, required: true } });
 *     schema.path('name').validators.length; // 1, the `required` validator
 *
 * @property validators
 * @api public
 * @memberOf SchemaType
 */

SchemaType.prototype.validators;
/**
 * True if this SchemaType has a required validator. False otherwise.
 *
 * #### Example:
 *     const schema = new Schema({ name: { type: String, required: true } });
 *     schema.path('name').isRequired; // true
 *
 *     schema.path('name').required(false);
 *     schema.path('name').isRequired; // false
 *
 * @property isRequired
 * @api public
 * @memberOf SchemaType
 */

SchemaType.prototype.validators;
/*!
 * ignore
 */

SchemaType.prototype.splitPath = function () {
  if (this._presplitPath != null) {
    return this._presplitPath;
  }

  if (this.path == null) {
    return undefined;
  }

  this._presplitPath = this.path.indexOf('.') === -1 ? [this.path] : this.path.split('.');
  return this._presplitPath;
};
/**
 * Get/set the function used to cast arbitrary values to this type.
 *
 * #### Example:
 *
 *     // Disallow `null` for numbers, and don't try to cast any values to
 *     // numbers, so even strings like '123' will cause a CastError.
 *     mongoose.Number.cast(function(v) {
 *       assert.ok(v === undefined || typeof v === 'number');
 *       return v;
 *     });
 *
 * @param {Function|false} caster Function that casts arbitrary values to this type, or throws an error if casting failed
 * @return {Function}
 * @static
 * @receiver SchemaType
 * @function cast
 * @api public
 */


SchemaType.cast = function cast(caster) {
  if (arguments.length === 0) {
    return this._cast;
  }

  if (caster === false) {
    caster = function caster(v) {
      return v;
    };
  }

  this._cast = caster;
  return this._cast;
};
/**
 * Get/set the function used to cast arbitrary values to this particular schematype instance.
 * Overrides `SchemaType.cast()`.
 *
 * #### Example:
 *
 *     // Disallow `null` for numbers, and don't try to cast any values to
 *     // numbers, so even strings like '123' will cause a CastError.
 *     const number = new mongoose.Number('mypath', {});
 *     number.cast(function(v) {
 *       assert.ok(v === undefined || typeof v === 'number');
 *       return v;
 *     });
 *
 * @param {Function|false} caster Function that casts arbitrary values to this type, or throws an error if casting failed
 * @return {Function}
 * @static
 * @receiver SchemaType
 * @function cast
 * @api public
 */


SchemaType.prototype.castFunction = function castFunction(caster) {
  if (arguments.length === 0) {
    return this._castFunction;
  }

  if (caster === false) {
    caster = this.constructor._defaultCaster || function (v) {
      return v;
    };
  }

  this._castFunction = caster;
  return this._castFunction;
};
/**
 * The function that Mongoose calls to cast arbitrary values to this SchemaType.
 *
 * @param {Object} value value to cast
 * @param {Document} doc document that triggers the casting
 * @param {Boolean} init
 * @api public
 */


SchemaType.prototype.cast = function cast() {
  throw new Error('Base SchemaType class does not implement a `cast()` function');
};
/**
 * Sets a default option for this schema type.
 *
 * #### Example:
 *
 *     // Make all strings be trimmed by default
 *     mongoose.SchemaTypes.String.set('trim', true);
 *
 * @param {String} option The name of the option you'd like to set (e.g. trim, lowercase, etc...)
 * @param {*} value The value of the option you'd like to set.
 * @return {void}
 * @static
 * @receiver SchemaType
 * @function set
 * @api public
 */


SchemaType.set = function set(option, value) {
  if (!this.hasOwnProperty('defaultOptions')) {
    this.defaultOptions = Object.assign({}, this.defaultOptions);
  }

  this.defaultOptions[option] = value;
};
/**
 * Attaches a getter for all instances of this schema type.
 *
 * #### Example:
 *
 *     // Make all numbers round down
 *     mongoose.Number.get(function(v) { return Math.floor(v); });
 *
 * @param {Function} getter
 * @return {this}
 * @static
 * @receiver SchemaType
 * @function get
 * @api public
 */


SchemaType.get = function (getter) {
  this.getters = this.hasOwnProperty('getters') ? this.getters : [];
  this.getters.push(getter);
};
/**
 * Sets a default value for this SchemaType.
 *
 * #### Example:
 *
 *     const schema = new Schema({ n: { type: Number, default: 10 })
 *     const M = db.model('M', schema)
 *     const m = new M;
 *     console.log(m.n) // 10
 *
 * Defaults can be either `functions` which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.
 *
 * #### Example:
 *
 *     // values are cast:
 *     const schema = new Schema({ aNumber: { type: Number, default: 4.815162342 }})
 *     const M = db.model('M', schema)
 *     const m = new M;
 *     console.log(m.aNumber) // 4.815162342
 *
 *     // default unique objects for Mixed types:
 *     const schema = new Schema({ mixed: Schema.Types.Mixed });
 *     schema.path('mixed').default(function () {
 *       return {};
 *     });
 *
 *     // if we don't use a function to return object literals for Mixed defaults,
 *     // each document will receive a reference to the same object literal creating
 *     // a "shared" object instance:
 *     const schema = new Schema({ mixed: Schema.Types.Mixed });
 *     schema.path('mixed').default({});
 *     const M = db.model('M', schema);
 *     const m1 = new M;
 *     m1.mixed.added = 1;
 *     console.log(m1.mixed); // { added: 1 }
 *     const m2 = new M;
 *     console.log(m2.mixed); // { added: 1 }
 *
 * @param {Function|any} val the default value
 * @return {defaultValue}
 * @api public
 */


SchemaType.prototype["default"] = function (val) {
  if (arguments.length === 1) {
    if (val === void 0) {
      this.defaultValue = void 0;
      return void 0;
    }

    if (val != null && val.instanceOfSchema) {
      throw new MongooseError('Cannot set default value of path `' + this.path + '` to a mongoose Schema instance.');
    }

    this.defaultValue = val;
    return this.defaultValue;
  } else if (arguments.length > 1) {
    this.defaultValue = Array.prototype.slice.call(arguments);
  }

  return this.defaultValue;
};
/**
 * Declares the index options for this schematype.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: { type: String, index: true })
 *     const s = new Schema({ loc: { type: [Number], index: 'hashed' })
 *     const s = new Schema({ loc: { type: [Number], index: '2d', sparse: true })
 *     const s = new Schema({ loc: { type: [Number], index: { type: '2dsphere', sparse: true }})
 *     const s = new Schema({ date: { type: Date, index: { unique: true, expires: '1d' }})
 *     s.path('my.path').index(true);
 *     s.path('my.date').index({ expires: 60 });
 *     s.path('my.path').index({ unique: true, sparse: true });
 *
 * #### Note:
 *
 * _Indexes are created [in the background](https://docs.mongodb.com/manual/core/index-creation/#index-creation-background)
 * by default. If `background` is set to `false`, MongoDB will not execute any
 * read/write operations you send until the index build.
 * Specify `background: false` to override Mongoose's default._
 *
 * @param {Object|Boolean|String} options
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.index = function (options) {
  this._index = options;
  utils.expires(this._index);
  return this;
};
/**
 * Declares an unique index.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: { type: String, unique: true }});
 *     s.path('name').index({ unique: true });
 *
 * _NOTE: violating the constraint returns an `E11000` error from MongoDB when saving, not a Mongoose validation error._
 *
 * @param {Boolean} bool
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.unique = function (bool) {
  if (this._index === false) {
    if (!bool) {
      return;
    }

    throw new Error('Path "' + this.path + '" may not have `index` set to ' + 'false and `unique` set to true');
  }

  if (!this.options.hasOwnProperty('index') && bool === false) {
    return this;
  }

  if (this._index == null || this._index === true) {
    this._index = {};
  } else if (typeof this._index === 'string') {
    this._index = {
      type: this._index
    };
  }

  this._index.unique = bool;
  return this;
};
/**
 * Declares a full text index.
 *
 * ### Example:
 *
 *      const s = new Schema({name : {type: String, text : true })
 *      s.path('name').index({text : true});
 * @param {Boolean} bool
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.text = function (bool) {
  if (this._index === false) {
    if (!bool) {
      return;
    }

    throw new Error('Path "' + this.path + '" may not have `index` set to ' + 'false and `text` set to true');
  }

  if (!this.options.hasOwnProperty('index') && bool === false) {
    return this;
  }

  if (this._index === null || this._index === undefined || typeof this._index === 'boolean') {
    this._index = {};
  } else if (typeof this._index === 'string') {
    this._index = {
      type: this._index
    };
  }

  this._index.text = bool;
  return this;
};
/**
 * Declares a sparse index.
 *
 * #### Example:
 *
 *     const s = new Schema({ name: { type: String, sparse: true } });
 *     s.path('name').index({ sparse: true });
 *
 * @param {Boolean} bool
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.sparse = function (bool) {
  if (this._index === false) {
    if (!bool) {
      return;
    }

    throw new Error('Path "' + this.path + '" may not have `index` set to ' + 'false and `sparse` set to true');
  }

  if (!this.options.hasOwnProperty('index') && bool === false) {
    return this;
  }

  if (this._index == null || typeof this._index === 'boolean') {
    this._index = {};
  } else if (typeof this._index === 'string') {
    this._index = {
      type: this._index
    };
  }

  this._index.sparse = bool;
  return this;
};
/**
 * Defines this path as immutable. Mongoose prevents you from changing
 * immutable paths unless the parent document has [`isNew: true`](/docs/api.html#document_Document-isNew).
 *
 * #### Example:
 *
 *     const schema = new Schema({
 *       name: { type: String, immutable: true },
 *       age: Number
 *     });
 *     const Model = mongoose.model('Test', schema);
 *
 *     await Model.create({ name: 'test' });
 *     const doc = await Model.findOne();
 *
 *     doc.isNew; // false
 *     doc.name = 'new name';
 *     doc.name; // 'test', because `name` is immutable
 *
 * Mongoose also prevents changing immutable properties using `updateOne()`
 * and `updateMany()` based on [strict mode](/docs/guide.html#strict).
 *
 * #### Example:
 *
 *     // Mongoose will strip out the `name` update, because `name` is immutable
 *     Model.updateOne({}, { $set: { name: 'test2' }, $inc: { age: 1 } });
 *
 *     // If `strict` is set to 'throw', Mongoose will throw an error if you
 *     // update `name`
 *     const err = await Model.updateOne({}, { name: 'test2' }, { strict: 'throw' }).
 *       then(() => null, err => err);
 *     err.name; // StrictModeError
 *
 *     // If `strict` is `false`, Mongoose allows updating `name` even though
 *     // the property is immutable.
 *     Model.updateOne({}, { name: 'test2' }, { strict: false });
 *
 * @param {Boolean} bool
 * @return {SchemaType} this
 * @see isNew /docs/api.html#document_Document-isNew
 * @api public
 */


SchemaType.prototype.immutable = function (bool) {
  this.$immutable = bool;
  handleImmutable(this);
  return this;
};
/**
 * Defines a custom function for transforming this path when converting a document to JSON.
 *
 * Mongoose calls this function with one parameter: the current `value` of the path. Mongoose
 * then uses the return value in the JSON output.
 *
 * #### Example:
 *
 *     const schema = new Schema({
 *       date: { type: Date, transform: v => v.getFullYear() }
 *     });
 *     const Model = mongoose.model('Test', schema);
 *
 *     await Model.create({ date: new Date('2016-06-01') });
 *     const doc = await Model.findOne();
 *
 *     doc.date instanceof Date; // true
 *
 *     doc.toJSON().date; // 2016 as a number
 *     JSON.stringify(doc); // '{"_id":...,"date":2016}'
 *
 * @param {Function} fn
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.transform = function (fn) {
  this.options.transform = fn;
  return this;
};
/**
 * Adds a setter to this schematype.
 *
 * #### Example:
 *
 * ```javascript
 * function capitalize (val) {
 *   if (typeof val !== 'string') val = '';
 *   return val.charAt(0).toUpperCase() + val.substring(1);
 * }
 *
 * // defining within the schema
 * const s = new Schema({ name: { type: String, set: capitalize }});
 *
 * // or with the SchemaType
 * const s = new Schema({ name: String })
 * s.path('name').set(capitalize);
 * ```
 *
 * Setters allow you to transform the data before it gets to the raw mongodb
 * document or query.
 *
 * Suppose you are implementing user registration for a website. Users provide
 * an email and password, which gets saved to mongodb. The email is a string
 * that you will want to normalize to lower case, in order to avoid one email
 * having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.
 *
 * You can set up email lower case normalization easily via a Mongoose setter.
 *
 * ```javascript
 * function toLower(v) {
 *   return v.toLowerCase();
 * }
 *
 * const UserSchema = new Schema({
 *   email: { type: String, set: toLower }
 * });
 *
 * const User = db.model('User', UserSchema);
 *
 * const user = new User({email: 'AVENUE@Q.COM'});
 * console.log(user.email); // 'avenue@q.com'
 *
 * // or
 * const user = new User();
 * user.email = 'Avenue@Q.com';
 * console.log(user.email); // 'avenue@q.com'
 * User.updateOne({ _id: _id }, { $set: { email: 'AVENUE@Q.COM' } }); // update to 'avenue@q.com'
 * ```
 *
 * As you can see above, setters allow you to transform the data before it
 * stored in MongoDB, or before executing a query.
 *
 * _NOTE: we could have also just used the built-in `lowercase: true` SchemaType option instead of defining our own function._
 *
 * ```javascript
 * new Schema({ email: { type: String, lowercase: true }})
 * ```
 *
 * Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.
 *
 * ```javascript
 * function inspector (val, priorValue, schematype) {
 *   if (schematype.options.required) {
 *     return schematype.path + ' is required';
 *   } else {
 *     return val;
 *   }
 * }
 *
 * const VirusSchema = new Schema({
 *   name: { type: String, required: true, set: inspector },
 *   taxonomy: { type: String, set: inspector }
 * })
 *
 * const Virus = db.model('Virus', VirusSchema);
 * const v = new Virus({ name: 'Parvoviridae', taxonomy: 'Parvovirinae' });
 *
 * console.log(v.name);     // name is required
 * console.log(v.taxonomy); // Parvovirinae
 * ```
 *
 * You can also use setters to modify other properties on the document. If
 * you're setting a property `name` on a document, the setter will run with
 * `this` as the document. Be careful, in mongoose 5 setters will also run
 * when querying by `name` with `this` as the query.
 *
 * ```javascript
 * const nameSchema = new Schema({ name: String, keywords: [String] });
 * nameSchema.path('name').set(function(v) {
 *   // Need to check if `this` is a document, because in mongoose 5
 *   // setters will also run on queries, in which case `this` will be a
 *   // mongoose query object.
 *   if (this instanceof Document && v != null) {
 *     this.keywords = v.split(' ');
 *   }
 *   return v;
 * });
 * ```
 *
 * @param {Function} fn
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.set = function (fn) {
  if (typeof fn !== 'function') {
    throw new TypeError('A setter must be a function.');
  }

  this.setters.push(fn);
  return this;
};
/**
 * Adds a getter to this schematype.
 *
 * #### Example:
 *
 *     function dob (val) {
 *       if (!val) return val;
 *       return (val.getMonth() + 1) + "/" + val.getDate() + "/" + val.getFullYear();
 *     }
 *
 *     // defining within the schema
 *     const s = new Schema({ born: { type: Date, get: dob })
 *
 *     // or by retreiving its SchemaType
 *     const s = new Schema({ born: Date })
 *     s.path('born').get(dob)
 *
 * Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.
 *
 * Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:
 *
 *     function obfuscate (cc) {
 *       return '****-****-****-' + cc.slice(cc.length-4, cc.length);
 *     }
 *
 *     const AccountSchema = new Schema({
 *       creditCardNumber: { type: String, get: obfuscate }
 *     });
 *
 *     const Account = db.model('Account', AccountSchema);
 *
 *     Account.findById(id, function (err, found) {
 *       console.log(found.creditCardNumber); // '****-****-****-1234'
 *     });
 *
 * Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.
 *
 *     function inspector (val, priorValue, schematype) {
 *       if (schematype.options.required) {
 *         return schematype.path + ' is required';
 *       } else {
 *         return schematype.path + ' is not';
 *       }
 *     }
 *
 *     const VirusSchema = new Schema({
 *       name: { type: String, required: true, get: inspector },
 *       taxonomy: { type: String, get: inspector }
 *     })
 *
 *     const Virus = db.model('Virus', VirusSchema);
 *
 *     Virus.findById(id, function (err, virus) {
 *       console.log(virus.name);     // name is required
 *       console.log(virus.taxonomy); // taxonomy is not
 *     })
 *
 * @param {Function} fn
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.get = function (fn) {
  if (typeof fn !== 'function') {
    throw new TypeError('A getter must be a function.');
  }

  this.getters.push(fn);
  return this;
};
/**
 * Adds validator(s) for this document path.
 *
 * Validators always receive the value to validate as their first argument and
 * must return `Boolean`. Returning `false` or throwing an error means
 * validation failed.
 *
 * The error message argument is optional. If not passed, the [default generic error message template](#error_messages_MongooseError-messages) will be used.
 *
 * #### Examples:
 *
 *     // make sure every value is equal to "something"
 *     function validator (val) {
 *       return val === 'something';
 *     }
 *     new Schema({ name: { type: String, validate: validator }});
 *
 *     // with a custom error message
 *
 *     const custom = [validator, 'Uh oh, {PATH} does not equal "something".']
 *     new Schema({ name: { type: String, validate: custom }});
 *
 *     // adding many validators at a time
 *
 *     const many = [
 *         { validator: validator, msg: 'uh oh' }
 *       , { validator: anotherValidator, msg: 'failed' }
 *     ]
 *     new Schema({ name: { type: String, validate: many }});
 *
 *     // or utilizing SchemaType methods directly:
 *
 *     const schema = new Schema({ name: 'string' });
 *     schema.path('name').validate(validator, 'validation of `{PATH}` failed with value `{VALUE}`');
 *
 * #### Error message templates:
 *
 * From the examples above, you may have noticed that error messages support
 * basic templating. There are a few other template keywords besides `{PATH}`
 * and `{VALUE}` too. To find out more, details are available
 * [here](#error_messages_MongooseError.messages).
 *
 * If Mongoose's built-in error message templating isn't enough, Mongoose
 * supports setting the `message` property to a function.
 *
 *     schema.path('name').validate({
 *       validator: function(v) { return v.length > 5; },
 *       // `errors['name']` will be "name must have length 5, got 'foo'"
 *       message: function(props) {
 *         return `${props.path} must have length 5, got '${props.value}'`;
 *       }
 *     });
 *
 * To bypass Mongoose's error messages and just copy the error message that
 * the validator throws, do this:
 *
 *     schema.path('name').validate({
 *       validator: function() { throw new Error('Oops!'); },
 *       // `errors['name']` will be "Oops!"
 *       message: function(props) { return props.reason.message; }
 *     });
 *
 * #### Asynchronous validation:
 *
 * Mongoose supports validators that return a promise. A validator that returns
 * a promise is called an _async validator_. Async validators run in
 * parallel, and `validate()` will wait until all async validators have settled.
 *
 *     schema.path('name').validate({
 *       validator: function (value) {
 *         return new Promise(function (resolve, reject) {
 *           resolve(false); // validation failed
 *         });
 *       }
 *     });
 *
 * You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.
 *
 * Validation occurs `pre('save')` or whenever you manually execute [document#validate](#document_Document-validate).
 *
 * If validation fails during `pre('save')` and no callback was passed to receive the error, an `error` event will be emitted on your Models associated db [connection](#connection_Connection), passing the validation error object along.
 *
 *     const conn = mongoose.createConnection(..);
 *     conn.on('error', handleError);
 *
 *     const Product = conn.model('Product', yourSchema);
 *     const dvd = new Product(..);
 *     dvd.save(); // emits error on the `conn` above
 *
 * If you want to handle these errors at the Model level, add an `error`
 * listener to your Model as shown below.
 *
 *     // registering an error listener on the Model lets us handle errors more locally
 *     Product.on('error', handleError);
 *
 * @param {RegExp|Function|Object} obj validator function, or hash describing options
 * @param {Function} [obj.validator] validator function. If the validator function returns `undefined` or a truthy value, validation succeeds. If it returns [falsy](https://masteringjs.io/tutorials/fundamentals/falsy) (except `undefined`) or throws an error, validation fails.
 * @param {String|Function} [obj.message] optional error message. If function, should return the error message as a string
 * @param {Boolean} [obj.propsParameter=false] If true, Mongoose will pass the validator properties object (with the `validator` function, `message`, etc.) as the 2nd arg to the validator function. This is disabled by default because many validators [rely on positional args](https://github.com/chriso/validator.js#validators), so turning this on may cause unpredictable behavior in external validators.
 * @param {String|Function} [errorMsg] optional error message. If function, should return the error message as a string
 * @param {String} [type] optional validator type
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.validate = function (obj, message, type) {
  if (typeof obj === 'function' || obj && utils.getFunctionName(obj.constructor) === 'RegExp') {
    var properties;

    if (typeof message === 'function') {
      properties = {
        validator: obj,
        message: message
      };
      properties.type = type || 'user defined';
    } else if (message instanceof Object && !type) {
      properties = isSimpleValidator(message) ? Object.assign({}, message) : utils.clone(message);

      if (!properties.message) {
        properties.message = properties.msg;
      }

      properties.validator = obj;
      properties.type = properties.type || 'user defined';
    } else {
      if (message == null) {
        message = MongooseError.messages.general["default"];
      }

      if (!type) {
        type = 'user defined';
      }

      properties = {
        message: message,
        type: type,
        validator: obj
      };
    }

    this.validators.push(properties);
    return this;
  }

  var i;
  var length;
  var arg;

  for (i = 0, length = arguments.length; i < length; i++) {
    arg = arguments[i];

    if (!utils.isPOJO(arg)) {
      var msg = 'Invalid validator. Received (' + _typeof(arg) + ') ' + arg + '. See https://mongoosejs.com/docs/api.html#schematype_SchemaType-validate';
      throw new Error(msg);
    }

    this.validate(arg.validator, arg);
  }

  return this;
};
/**
 * Adds a required validator to this SchemaType. The validator gets added
 * to the front of this SchemaType's validators array using `unshift()`.
 *
 * #### Example:
 *
 *     const s = new Schema({ born: { type: Date, required: true })
 *
 *     // or with custom error message
 *
 *     const s = new Schema({ born: { type: Date, required: '{PATH} is required!' })
 *
 *     // or with a function
 *
 *     const s = new Schema({
 *       userId: ObjectId,
 *       username: {
 *         type: String,
 *         required: function() { return this.userId != null; }
 *       }
 *     })
 *
 *     // or with a function and a custom message
 *     const s = new Schema({
 *       userId: ObjectId,
 *       username: {
 *         type: String,
 *         required: [
 *           function() { return this.userId != null; },
 *           'username is required if id is specified'
 *         ]
 *       }
 *     })
 *
 *     // or through the path API
 *
 *     s.path('name').required(true);
 *
 *     // with custom error messaging
 *
 *     s.path('name').required(true, 'grrr :( ');
 *
 *     // or make a path conditionally required based on a function
 *     const isOver18 = function() { return this.age >= 18; };
 *     s.path('voterRegistrationId').required(isOver18);
 *
 * The required validator uses the SchemaType's `checkRequired` function to
 * determine whether a given value satisfies the required validator. By default,
 * a value satisfies the required validator if `val != null` (that is, if
 * the value is not null nor undefined). However, most built-in mongoose schema
 * types override the default `checkRequired` function:
 *
 * @param {Boolean|Function|Object} required enable/disable the validator, or function that returns required boolean, or options object
 * @param {Boolean|Function} [options.isRequired] enable/disable the validator, or function that returns required boolean
 * @param {Function} [options.ErrorConstructor] custom error constructor. The constructor receives 1 parameter, an object containing the validator properties.
 * @param {String} [message] optional custom error message
 * @return {SchemaType} this
 * @see Customized Error Messages #error_messages_MongooseError-messages
 * @see SchemaArray#checkRequired #schema_array_SchemaArray.checkRequired
 * @see SchemaBoolean#checkRequired #schema_boolean_SchemaBoolean-checkRequired
 * @see SchemaBuffer#checkRequired #schema_buffer_SchemaBuffer.schemaName
 * @see SchemaNumber#checkRequired #schema_number_SchemaNumber-min
 * @see SchemaObjectId#checkRequired #schema_objectid_ObjectId-auto
 * @see SchemaString#checkRequired #schema_string_SchemaString-checkRequired
 * @api public
 */


SchemaType.prototype.required = function (required, message) {
  var customOptions = {};

  if (arguments.length > 0 && required == null) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.requiredValidator;
    }, this);
    this.isRequired = false;
    delete this.originalRequiredValue;
    return this;
  }

  if (_typeof(required) === 'object') {
    customOptions = required;
    message = customOptions.message || message;
    required = required.isRequired;
  }

  if (required === false) {
    this.validators = this.validators.filter(function (v) {
      return v.validator !== this.requiredValidator;
    }, this);
    this.isRequired = false;
    delete this.originalRequiredValue;
    return this;
  }

  var _this = this;

  this.isRequired = true;

  this.requiredValidator = function (v) {
    var cachedRequired = this && this.$__ && this.$__.cachedRequired; // no validation when this path wasn't selected in the query.

    if (cachedRequired != null && !this.$__isSelected(_this.path) && !this[documentIsModified](_this.path)) {
      return true;
    } // `$cachedRequired` gets set in `_evaluateRequiredFunctions()` so we
    // don't call required functions multiple times in one validate call
    // See gh-6801


    if (cachedRequired != null && _this.path in cachedRequired) {
      var res = cachedRequired[_this.path] ? _this.checkRequired(v, this) : true;
      delete cachedRequired[_this.path];
      return res;
    } else if (typeof required === 'function') {
      return required.apply(this) ? _this.checkRequired(v, this) : true;
    }

    return _this.checkRequired(v, this);
  };

  this.originalRequiredValue = required;

  if (typeof required === 'string') {
    message = required;
    required = undefined;
  }

  var msg = message || MongooseError.messages.general.required;
  this.validators.unshift(Object.assign({}, customOptions, {
    validator: this.requiredValidator,
    message: msg,
    type: 'required'
  }));
  return this;
};
/**
 * Set the model that this path refers to. This is the option that [populate](https://mongoosejs.com/docs/populate.html)
 * looks at to determine the foreign collection it should query.
 *
 * #### Example:
 *     const userSchema = new Schema({ name: String });
 *     const User = mongoose.model('User', userSchema);
 *
 *     const postSchema = new Schema({ user: mongoose.ObjectId });
 *     postSchema.path('user').ref('User'); // Can set ref to a model name
 *     postSchema.path('user').ref(User); // Or a model class
 *     postSchema.path('user').ref(() => 'User'); // Or a function that returns the model name
 *     postSchema.path('user').ref(() => User); // Or a function that returns the model class
 *
 *     // Or you can just declare the `ref` inline in your schema
 *     const postSchema2 = new Schema({
 *       user: { type: mongoose.ObjectId, ref: User }
 *     });
 *
 * @param {String|Model|Function} ref either a model name, a [Model](https://mongoosejs.com/docs/models.html), or a function that returns a model name or model.
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.ref = function (ref) {
  this.options.ref = ref;
  return this;
};
/**
 * Gets the default value
 *
 * @param {Object} scope the scope which callback are executed
 * @param {Boolean} init
 * @api private
 */


SchemaType.prototype.getDefault = function (scope, init) {
  var ret;

  if (typeof this.defaultValue === 'function') {
    if (this.defaultValue === Date.now || this.defaultValue === Array || this.defaultValue.name.toLowerCase() === 'objectid') {
      ret = this.defaultValue.call(scope);
    } else {
      ret = this.defaultValue.call(scope, scope);
    }
  } else {
    ret = this.defaultValue;
  }

  if (ret !== null && ret !== undefined) {
    if (_typeof(ret) === 'object' && (!this.options || !this.options.shared)) {
      ret = utils.clone(ret);
    }

    var casted = this.applySetters(ret, scope, init, undefined, setOptionsForDefaults);

    if (casted && !Array.isArray(casted) && casted.$isSingleNested) {
      casted.$__parent = scope;
    }

    return casted;
  }

  return ret;
};
/*!
 * Applies setters without casting
 *
 * @api private
 */


SchemaType.prototype._applySetters = function (value, scope, init, priorVal, options) {
  var v = value;

  if (init) {
    return v;
  }

  var setters = this.setters;

  for (var i = setters.length - 1; i >= 0; i--) {
    v = setters[i].call(scope, v, priorVal, this, options);
  }

  return v;
};
/*!
 * ignore
 */


SchemaType.prototype._castNullish = function _castNullish(v) {
  return v;
};
/**
 * Applies setters
 *
 * @param {Object} value
 * @param {Object} scope
 * @param {Boolean} init
 * @api private
 */


SchemaType.prototype.applySetters = function (value, scope, init, priorVal, options) {
  var v = this._applySetters(value, scope, init, priorVal, options);

  if (v == null) {
    return this._castNullish(v);
  } // do not cast until all setters are applied #665


  v = this.cast(v, scope, init, priorVal, options);
  return v;
};
/**
 * Applies getters to a value
 *
 * @param {Object} value
 * @param {Object} scope
 * @api private
 */


SchemaType.prototype.applyGetters = function (value, scope) {
  var v = value;
  var getters = this.getters;
  var len = getters.length;

  if (len === 0) {
    return v;
  }

  for (var i = 0; i < len; ++i) {
    v = getters[i].call(scope, v, this);
  }

  return v;
};
/**
 * Sets default `select()` behavior for this path.
 *
 * Set to `true` if this path should always be included in the results, `false` if it should be excluded by default. This setting can be overridden at the query level.
 *
 * #### Example:
 *
 *     T = db.model('T', new Schema({ x: { type: String, select: true }}));
 *     T.find(..); // field x will always be selected ..
 *     // .. unless overridden;
 *     T.find().select('-x').exec(callback);
 *
 * @param {Boolean} val
 * @return {SchemaType} this
 * @api public
 */


SchemaType.prototype.select = function select(val) {
  this.selected = !!val;
  return this;
};
/**
 * Performs a validation of `value` using the validators declared for this SchemaType.
 *
 * @param {any} value
 * @param {Function} callback
 * @param {Object} scope
 * @api private
 */


SchemaType.prototype.doValidate = function (value, fn, scope, options) {
  var _this2 = this;

  var err = false;
  var path = this.path; // Avoid non-object `validators`

  var validators = this.validators.filter(function (v) {
    return _typeof(v) === 'object' && v !== null;
  });
  var count = validators.length;

  if (!count) {
    return fn(null);
  }

  var _loop = function _loop(i, len) {
    if (err) {
      return "break";
    }

    var v = validators[i];
    var validator = v.validator;
    var ok = void 0;
    var validatorProperties = isSimpleValidator(v) ? Object.assign({}, v) : utils.clone(v);
    validatorProperties.path = options && options.path ? options.path : path;
    validatorProperties.value = value;

    if (validator instanceof RegExp) {
      validate(validator.test(value), validatorProperties);
      return "continue";
    }

    if (typeof validator !== 'function') {
      return "continue";
    }

    if (value === undefined && validator !== _this2.requiredValidator) {
      validate(true, validatorProperties);
      return "continue";
    }

    try {
      if (validatorProperties.propsParameter) {
        ok = validator.call(scope, value, validatorProperties);
      } else {
        ok = validator.call(scope, value);
      }
    } catch (error) {
      ok = false;
      validatorProperties.reason = error;

      if (error.message) {
        validatorProperties.message = error.message;
      }
    }

    if (ok != null && typeof ok.then === 'function') {
      ok.then(function (ok) {
        validate(ok, validatorProperties);
      }, function (error) {
        validatorProperties.reason = error;
        validatorProperties.message = error.message;
        ok = false;
        validate(ok, validatorProperties);
      });
    } else {
      validate(ok, validatorProperties);
    }
  };

  for (var i = 0, len = validators.length; i < len; ++i) {
    var _ret = _loop(i, len);

    if (_ret === "break") break;
    if (_ret === "continue") continue;
  }

  function validate(ok, validatorProperties) {
    if (err) {
      return;
    }

    if (ok === undefined || ok) {
      if (--count <= 0) {
        immediate(function () {
          fn(null);
        });
      }
    } else {
      var ErrorConstructor = validatorProperties.ErrorConstructor || ValidatorError;
      err = new ErrorConstructor(validatorProperties);
      err[validatorErrorSymbol] = true;
      immediate(function () {
        fn(err);
      });
    }
  }
};

function _validate(ok, validatorProperties) {
  if (ok !== undefined && !ok) {
    var ErrorConstructor = validatorProperties.ErrorConstructor || ValidatorError;
    var err = new ErrorConstructor(validatorProperties);
    err[validatorErrorSymbol] = true;
    return err;
  }
}
/**
 * Performs a validation of `value` using the validators declared for this SchemaType.
 *
 * #### Note:
 *
 * This method ignores the asynchronous validators.
 *
 * @param {any} value
 * @param {Object} scope
 * @return {MongooseError|undefined}
 * @api private
 */


SchemaType.prototype.doValidateSync = function (value, scope, options) {
  var path = this.path;
  var count = this.validators.length;

  if (!count) {
    return null;
  }

  var validators = this.validators;

  if (value === void 0) {
    if (this.validators.length !== 0 && this.validators[0].type === 'required') {
      validators = [this.validators[0]];
    } else {
      return null;
    }
  }

  var err = null;
  var i = 0;
  var len = validators.length;

  for (i = 0; i < len; ++i) {
    var v = validators[i];

    if (v === null || _typeof(v) !== 'object') {
      continue;
    }

    var validator = v.validator;
    var validatorProperties = isSimpleValidator(v) ? Object.assign({}, v) : utils.clone(v);
    validatorProperties.path = options && options.path ? options.path : path;
    validatorProperties.value = value;
    var ok = false; // Skip any explicit async validators. Validators that return a promise
    // will still run, but won't trigger any errors.

    if (isAsyncFunction(validator)) {
      continue;
    }

    if (validator instanceof RegExp) {
      err = _validate(validator.test(value), validatorProperties);
      continue;
    }

    if (typeof validator !== 'function') {
      continue;
    }

    try {
      if (validatorProperties.propsParameter) {
        ok = validator.call(scope, value, validatorProperties);
      } else {
        ok = validator.call(scope, value);
      }
    } catch (error) {
      ok = false;
      validatorProperties.reason = error;
    } // Skip any validators that return a promise, we can't handle those
    // synchronously


    if (ok != null && typeof ok.then === 'function') {
      continue;
    }

    err = _validate(ok, validatorProperties);

    if (err) {
      break;
    }
  }

  return err;
};
/**
 * Determines if value is a valid Reference.
 *
 * @param {SchemaType} self
 * @param {Object} value
 * @param {Document} doc
 * @param {Boolean} init
 * @return {Boolean}
 * @api private
 */


SchemaType._isRef = function (self, value, doc, init) {
  // fast path
  var ref = init && self.options && (self.options.ref || self.options.refPath);

  if (!ref && doc && doc.$__ != null) {
    // checks for
    // - this populated with adhoc model and no ref was set in schema OR
    // - setting / pushing values after population
    var path = doc.$__fullPath(self.path, true);
    var owner = doc.ownerDocument();
    ref = path != null && owner.$populated(path) || doc.$populated(self.path);
  }

  if (ref) {
    if (value == null) {
      return true;
    }

    if (!Buffer.isBuffer(value) && // buffers are objects too
    value._bsontype !== 'Binary' // raw binary value from the db
    && utils.isObject(value) // might have deselected _id in population query
    ) {
      return true;
    }

    return init;
  }

  return false;
};
/*!
 * ignore
 */


SchemaType.prototype._castRef = function _castRef(value, doc, init) {
  if (value == null) {
    return value;
  }

  if (value.$__ != null) {
    value.$__.wasPopulated = value.$__.wasPopulated || true;
    return value;
  } // setting a populated path


  if (Buffer.isBuffer(value) || !utils.isObject(value)) {
    if (init) {
      return value;
    }

    throw new CastError(this.instance, value, this.path, null, this);
  } // Handle the case where user directly sets a populated
  // path to a plain object; cast to the Model used in
  // the population query.


  var path = doc.$__fullPath(this.path, true);
  var owner = doc.ownerDocument();
  var pop = owner.$populated(path, true);
  var ret = value;

  if (!doc.$__.populated || !doc.$__.populated[path] || !doc.$__.populated[path].options || !doc.$__.populated[path].options.options || !doc.$__.populated[path].options.options.lean) {
    ret = new pop.options[populateModelSymbol](value);
    ret.$__.wasPopulated = true;
  }

  return ret;
};
/*!
 * ignore
 */


function handleSingle(val) {
  return this.castForQuery(val);
}
/*!
 * ignore
 */


function handleArray(val) {
  var _this = this;

  if (!Array.isArray(val)) {
    return [this.castForQuery(val)];
  }

  return val.map(function (m) {
    return _this.castForQuery(m);
  });
}
/*!
 * Just like handleArray, except also allows `[]` because surprisingly
 * `$in: [1, []]` works fine
 */


function handle$in(val) {
  var _this = this;

  if (!Array.isArray(val)) {
    return [this.castForQuery(val)];
  }

  return val.map(function (m) {
    if (Array.isArray(m) && m.length === 0) {
      return m;
    }

    return _this.castForQuery(m);
  });
}
/*!
 * ignore
 */


SchemaType.prototype.$conditionalHandlers = {
  $all: handleArray,
  $eq: handleSingle,
  $in: handle$in,
  $ne: handleSingle,
  $nin: handle$in,
  $exists: $exists,
  $type: $type
};
/*!
 * Wraps `castForQuery` to handle context
 */

SchemaType.prototype.castForQueryWrapper = function (params) {
  this.$$context = params.context;

  if ('$conditional' in params) {
    var _ret2 = this.castForQuery(params.$conditional, params.val);

    this.$$context = null;
    return _ret2;
  }

  if (params.$skipQueryCastForUpdate || params.$applySetters) {
    var _ret3 = this._castForQuery(params.val);

    this.$$context = null;
    return _ret3;
  }

  var ret = this.castForQuery(params.val);
  this.$$context = null;
  return ret;
};
/**
 * Cast the given value with the given optional query operator.
 *
 * @param {String} [$conditional] query operator, like `$eq` or `$in`
 * @param {any} val
 * @api private
 */


SchemaType.prototype.castForQuery = function ($conditional, val) {
  var handler;

  if (arguments.length === 2) {
    handler = this.$conditionalHandlers[$conditional];

    if (!handler) {
      throw new Error('Can\'t use ' + $conditional);
    }

    return handler.call(this, val);
  }

  val = $conditional;
  return this._castForQuery(val);
};
/*!
 * Internal switch for runSetters
 *
 * @api private
 */


SchemaType.prototype._castForQuery = function (val) {
  return this.applySetters(val, this.$$context);
};
/**
 * Override the function the required validator uses to check whether a value
 * passes the `required` check. Override this on the individual SchemaType.
 *
 * #### Example:
 *
 *     // Use this to allow empty strings to pass the `required` validator
 *     mongoose.Schema.Types.String.checkRequired(v => typeof v === 'string');
 *
 * @param {Function} fn
 * @return {Function}
 * @static
 * @receiver SchemaType
 * @function checkRequired
 * @api public
 */


SchemaType.checkRequired = function (fn) {
  if (arguments.length !== 0) {
    this._checkRequired = fn;
  }

  return this._checkRequired;
};
/**
 * Default check for if this path satisfies the `required` validator.
 *
 * @param {any} val
 * @api private
 */


SchemaType.prototype.checkRequired = function (val) {
  return val != null;
};
/*!
 * ignore
 */


SchemaType.prototype.clone = function () {
  var options = Object.assign({}, this.options);
  var schematype = new this.constructor(this.path, options, this.instance);
  schematype.validators = this.validators.slice();
  if (this.requiredValidator !== undefined) schematype.requiredValidator = this.requiredValidator;
  if (this.defaultValue !== undefined) schematype.defaultValue = this.defaultValue;

  if (this.$immutable !== undefined && this.options.immutable === undefined) {
    schematype.$immutable = this.$immutable;
    handleImmutable(schematype);
  }

  if (this._index !== undefined) schematype._index = this._index;
  if (this.selected !== undefined) schematype.selected = this.selected;
  if (this.isRequired !== undefined) schematype.isRequired = this.isRequired;
  if (this.originalRequiredValue !== undefined) schematype.originalRequiredValue = this.originalRequiredValue;
  schematype.getters = this.getters.slice();
  schematype.setters = this.setters.slice();
  return schematype;
};
/*!
 * Module exports.
 */


module.exports = exports = SchemaType;
exports.CastError = CastError;
exports.ValidatorError = ValidatorError;

/***/ }),

/***/ 489:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var utils = __webpack_require__(6872); // eslint-disable-line no-unused-vars

/*!
 * StateMachine represents a minimal `interface` for the
 * constructors it builds via StateMachine.ctor(...).
 *
 * @api private
 */


var StateMachine = module.exports = exports = function StateMachine() {};
/*!
 * StateMachine.ctor('state1', 'state2', ...)
 * A factory method for subclassing StateMachine.
 * The arguments are a list of states. For each state,
 * the constructor's prototype gets state transition
 * methods named after each state. These transition methods
 * place their path argument into the given state.
 *
 * @param {String} state
 * @param {String} [state]
 * @return {Function} subclass constructor
 * @private
 */


StateMachine.ctor = function () {
  var states = Array.prototype.slice.call(arguments);

  var ctor = function ctor() {
    StateMachine.apply(this, arguments);
    this.paths = {};
    this.states = {};
    this.stateNames = states;
    var i = states.length,
        state;

    while (i--) {
      state = states[i];
      this.states[state] = {};
    }
  };

  ctor.prototype = new StateMachine();
  states.forEach(function (state) {
    // Changes the `path`'s state to `state`.
    ctor.prototype[state] = function (path) {
      this._changeState(path, state);
    };
  });
  return ctor;
};
/*!
 * This function is wrapped by the state change functions:
 *
 * - `require(path)`
 * - `modify(path)`
 * - `init(path)`
 *
 * @api private
 */


StateMachine.prototype._changeState = function _changeState(path, nextState) {
  var prevBucket = this.states[this.paths[path]];
  if (prevBucket) delete prevBucket[path];
  this.paths[path] = nextState;
  this.states[nextState][path] = true;
};
/*!
 * ignore
 */


StateMachine.prototype.clear = function clear(state) {
  var keys = Object.keys(this.states[state]);
  var i = keys.length;
  var path;

  while (i--) {
    path = keys[i];
    delete this.states[state][path];
    delete this.paths[path];
  }
};
/*!
 * ignore
 */


StateMachine.prototype.clearPath = function clearPath(path) {
  var state = this.paths[path];

  if (!state) {
    return;
  }

  delete this.paths[path];
  delete this.states[state][path];
};
/*!
 * Checks to see if at least one path is in the states passed in via `arguments`
 * e.g., this.some('required', 'inited')
 *
 * @param {String} state that we want to check for.
 * @private
 */


StateMachine.prototype.some = function some() {
  var _this = this;

  var what = arguments.length ? arguments : this.stateNames;
  return Array.prototype.some.call(what, function (state) {
    return Object.keys(_this.states[state]).length;
  });
};
/*!
 * This function builds the functions that get assigned to `forEach` and `map`,
 * since both of those methods share a lot of the same logic.
 *
 * @param {String} iterMethod is either 'forEach' or 'map'
 * @return {Function}
 * @api private
 */


StateMachine.prototype._iter = function _iter(iterMethod) {
  return function () {
    var states = Array.prototype.slice.call(arguments);
    var callback = states.pop();
    if (!states.length) states = this.stateNames;

    var _this = this;

    var paths = states.reduce(function (paths, state) {
      return paths.concat(Object.keys(_this.states[state]));
    }, []);
    return paths[iterMethod](function (path, i, paths) {
      return callback(path, i, paths);
    });
  };
};
/*!
 * Iterates over the paths that belong to one of the parameter states.
 *
 * The function profile can look like:
 * this.forEach(state1, fn);         // iterates over all paths in state1
 * this.forEach(state1, state2, fn); // iterates over all paths in state1 or state2
 * this.forEach(fn);                 // iterates over all paths in all states
 *
 * @param {String} [state]
 * @param {String} [state]
 * @param {Function} callback
 * @private
 */


StateMachine.prototype.forEach = function forEach() {
  this.forEach = this._iter('forEach');
  return this.forEach.apply(this, arguments);
};
/*!
 * Maps over the paths that belong to one of the parameter states.
 *
 * The function profile can look like:
 * this.forEach(state1, fn);         // iterates over all paths in state1
 * this.forEach(state1, state2, fn); // iterates over all paths in state1 or state2
 * this.forEach(fn);                 // iterates over all paths in all states
 *
 * @param {String} [state]
 * @param {String} [state]
 * @param {Function} callback
 * @return {Array}
 * @private
 */


StateMachine.prototype.map = function map() {
  this.map = this._iter('map');
  return this.map.apply(this, arguments);
};

/***/ }),

/***/ 1568:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


var EventEmitter = (__webpack_require__(9620).EventEmitter);

var Subdocument = __webpack_require__(2591);

var utils = __webpack_require__(6872);

var documentArrayParent = (__webpack_require__(8770).documentArrayParent);
/*!
 * A constructor.
 *
 * @param {Object} obj js object returned from the db
 * @param {MongooseDocumentArray} parentArr the parent array of this document
 * @param {Boolean} skipId
 * @inherits Document
 * @api private
 */


function ArraySubdocument(obj, parentArr, skipId, fields, index) {
  if (utils.isMongooseDocumentArray(parentArr)) {
    this.__parentArray = parentArr;
    this[documentArrayParent] = parentArr.$parent();
  } else {
    this.__parentArray = undefined;
    this[documentArrayParent] = undefined;
  }

  this.$setIndex(index);
  this.$__parent = this[documentArrayParent];
  Subdocument.call(this, obj, fields, this[documentArrayParent], skipId, {
    isNew: true
  });
}
/*!
 * Inherit from Subdocument
 */


ArraySubdocument.prototype = Object.create(Subdocument.prototype);
ArraySubdocument.prototype.constructor = ArraySubdocument;
Object.defineProperty(ArraySubdocument.prototype, '$isSingleNested', {
  configurable: false,
  writable: false,
  value: false
});
Object.defineProperty(ArraySubdocument.prototype, '$isDocumentArrayElement', {
  configurable: false,
  writable: false,
  value: true
});

for (var i in EventEmitter.prototype) {
  ArraySubdocument[i] = EventEmitter.prototype[i];
}
/*!
 * ignore
 */


ArraySubdocument.prototype.$setIndex = function (index) {
  this.__index = index;

  if (this.$__ != null && this.$__.validationError != null) {
    var keys = Object.keys(this.$__.validationError.errors);

    for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
      var key = _keys[_i];
      this.invalidate(key, this.$__.validationError.errors[key]);
    }
  }
};
/*!
 * ignore
 */


ArraySubdocument.prototype.populate = function () {
  throw new Error('Mongoose does not support calling populate() on nested ' + 'docs. Instead of `doc.arr[0].populate("path")`, use ' + '`doc.populate("arr.0.path")`');
};
/*!
 * ignore
 */


ArraySubdocument.prototype.$__removeFromParent = function () {
  var _id = this._doc._id;

  if (!_id) {
    throw new Error('For your own good, Mongoose does not know ' + 'how to remove an ArraySubdocument that has no _id');
  }

  this.__parentArray.pull({
    _id: _id
  });
};
/**
 * Returns the full path to this document. If optional `path` is passed, it is appended to the full path.
 *
 * @param {String} [path]
 * @param {Boolean} [skipIndex] Skip adding the array index. For example `arr.foo` instead of `arr.0.foo`.
 * @return {String}
 * @api private
 * @method $__fullPath
 * @memberOf ArraySubdocument
 * @instance
 */


ArraySubdocument.prototype.$__fullPath = function (path, skipIndex) {
  if (this.__index == null) {
    return null;
  }

  if (!this.$__.fullPath) {
    this.ownerDocument();
  }

  if (skipIndex) {
    return path ? this.$__.fullPath + '.' + path : this.$__.fullPath;
  }

  return path ? this.$__.fullPath + '.' + this.__index + '.' + path : this.$__.fullPath + '.' + this.__index;
};
/*!
 * Given a path relative to this document, return the path relative
 * to the top-level document.
 */


ArraySubdocument.prototype.$__pathRelativeToParent = function (path, skipIndex) {
  if (this.__index == null) {
    return null;
  }

  if (skipIndex) {
    return path == null ? this.__parentArray.$path() : this.__parentArray.$path() + '.' + path;
  }

  if (path == null) {
    return this.__parentArray.$path() + '.' + this.__index;
  }

  return this.__parentArray.$path() + '.' + this.__index + '.' + path;
};
/*!
 * Returns this sub-documents parent document.
 */


ArraySubdocument.prototype.$parent = function () {
  return this[documentArrayParent];
};
/**
 * Returns this subdocument's parent array.
 *
 * #### Example:
 *
 *     const Test = mongoose.model('Test', new Schema({
 *       docArr: [{ name: String }]
 *     }));
 *     const doc = new Test({ docArr: [{ name: 'test subdoc' }] });
 *
 *     doc.docArr[0].parentArray() === doc.docArr; // true
 *
 * @api public
 * @method parentArray
 * @returns DocumentArray
 */


ArraySubdocument.prototype.parentArray = function () {
  return this.__parentArray;
};
/*!
 * Module exports.
 */


module.exports = ArraySubdocument;

/***/ }),

/***/ 6077:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/*!
 * Module dependencies.
 */

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var ArrayMethods = __webpack_require__(8075);

var DocumentArrayMethods = __webpack_require__(9261);

var Document = __webpack_require__(8727);

var arrayAtomicsSymbol = (__webpack_require__(8770).arrayAtomicsSymbol);

var arrayAtomicsBackupSymbol = (__webpack_require__(8770).arrayAtomicsBackupSymbol);

var arrayParentSymbol = (__webpack_require__(8770).arrayParentSymbol);

var arrayPathSymbol = (__webpack_require__(8770).arrayPathSymbol);

var arraySchemaSymbol = (__webpack_require__(8770).arraySchemaSymbol);

var _basePush = Array.prototype.push;
var numberRE = /^\d+$/;
/**
 * DocumentArray constructor
 *
 * @param {Array} values
 * @param {String} path the path to this array
 * @param {Document} doc parent document
 * @api private
 * @return {MongooseDocumentArray}
 * @inherits MongooseArray
 * @see https://bit.ly/f6CnZU
 */

function MongooseDocumentArray(values, path, doc) {
  var _internals;

  var __array = [];
  var internals = (_internals = {}, _defineProperty(_internals, arrayAtomicsSymbol, {}), _defineProperty(_internals, arrayAtomicsBackupSymbol, void 0), _defineProperty(_internals, arrayPathSymbol, path), _defineProperty(_internals, arraySchemaSymbol, void 0), _defineProperty(_internals, arrayParentSymbol, void 0), _internals);

  if (Array.isArray(values)) {
    if (values[arrayPathSymbol] === path && values[arrayParentSymbol] === doc) {
      internals[arrayAtomicsSymbol] = Object.assign({}, values[arrayAtomicsSymbol]);
    }

    values.forEach(function (v) {
      _basePush.call(__array, v);
    });
  }

  internals[arrayPathSymbol] = path;
  internals.__array = __array; // Because doc comes from the context of another function, doc === global
  // can happen if there was a null somewhere up the chain (see #3020 && #3034)
  // RB Jun 17, 2015 updated to check for presence of expected paths instead
  // to make more proof against unusual node environments

  if (doc && doc instanceof Document) {
    internals[arrayParentSymbol] = doc;
    internals[arraySchemaSymbol] = doc.schema.path(path); // `schema.path()` doesn't drill into nested arrays properly yet, see
    // gh-6398, gh-6602. This is a workaround because nested arrays are
    // always plain non-document arrays, so once you get to a document array
    // nesting is done. Matryoshka code.

    while (internals[arraySchemaSymbol] != null && internals[arraySchemaSymbol].$isMongooseArray && !internals[arraySchemaSymbol].$isMongooseDocumentArray) {
      internals[arraySchemaSymbol] = internals[arraySchemaSymbol].casterConstructor;
    }
  }

  var proxy = new Proxy(__array, {
    get: function get(target, prop) {
      if (prop === 'isMongooseArray' || prop === 'isMongooseArrayProxy' || prop === 'isMongooseDocumentArray' || prop === 'isMongooseDocumentArrayProxy') {
        return true;
      }

      if (internals.hasOwnProperty(prop)) {
        return internals[prop];
      }

      if (DocumentArrayMethods.hasOwnProperty(prop)) {
        return DocumentArrayMethods[prop];
      }

      if (ArrayMethods.hasOwnProperty(prop)) {
        return ArrayMethods[prop];
      }

      return __array[prop];
    },
    set: function set(target, prop, value) {
      if (typeof prop === 'string' && numberRE.test(prop)) {
        DocumentArrayMethods.set.call(proxy, prop, value, false);
      } else if (internals.hasOwnProperty(prop)) {
        internals[prop] = value;
      } else {
        __array[prop] = value;
      }

      return true;
    }
  });
  return proxy;
}
/*!
 * Module exports.
 */


module.exports = MongooseDocumentArray;

/***/ }),

/***/ 1255:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.isMongooseDocumentArray = function (mongooseDocumentArray) {
  return Array.isArray(mongooseDocumentArray) && mongooseDocumentArray.isMongooseDocumentArray;
};

/***/ }),

/***/ 9261:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var ArrayMethods = __webpack_require__(8075);

var Document = __webpack_require__(8727);

var castObjectId = __webpack_require__(4731);

var getDiscriminatorByValue = __webpack_require__(7291);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var utils = __webpack_require__(6872);

var isBsonType = __webpack_require__(1563);

var arrayParentSymbol = (__webpack_require__(8770).arrayParentSymbol);

var arrayPathSymbol = (__webpack_require__(8770).arrayPathSymbol);

var arraySchemaSymbol = (__webpack_require__(8770).arraySchemaSymbol);

var documentArrayParent = (__webpack_require__(8770).documentArrayParent);

var methods = {
  /*!
   * ignore
   */
  toBSON: function toBSON() {
    return this.toObject(internalToObjectOptions);
  },

  /*!
   * ignore
   */
  getArrayParent: function getArrayParent() {
    return this[arrayParentSymbol];
  },

  /**
   * Overrides MongooseArray#cast
   *
   * @method _cast
   * @api private
   * @receiver MongooseDocumentArray
   */
  _cast: function _cast(value, index) {
    if (this[arraySchemaSymbol] == null) {
      return value;
    }

    var Constructor = this[arraySchemaSymbol].casterConstructor;
    var isInstance = Constructor.$isMongooseDocumentArray ? utils.isMongooseDocumentArray(value) : value instanceof Constructor;

    if (isInstance || // Hack re: #5001, see #5005
    value && value.constructor && value.constructor.baseCasterConstructor === Constructor) {
      if (!(value[documentArrayParent] && value.__parentArray)) {
        // value may have been created using array.create()
        value[documentArrayParent] = this[arrayParentSymbol];
        value.__parentArray = this;
      }

      value.$setIndex(index);
      return value;
    }

    if (value === undefined || value === null) {
      return null;
    } // handle cast('string') or cast(ObjectId) etc.
    // only objects are permitted so we can safely assume that
    // non-objects are to be interpreted as _id


    if (Buffer.isBuffer(value) || isBsonType(value, 'ObjectID') || !utils.isObject(value)) {
      value = {
        _id: value
      };
    }

    if (value && Constructor.discriminators && Constructor.schema && Constructor.schema.options && Constructor.schema.options.discriminatorKey) {
      if (typeof value[Constructor.schema.options.discriminatorKey] === 'string' && Constructor.discriminators[value[Constructor.schema.options.discriminatorKey]]) {
        Constructor = Constructor.discriminators[value[Constructor.schema.options.discriminatorKey]];
      } else {
        var constructorByValue = getDiscriminatorByValue(Constructor.discriminators, value[Constructor.schema.options.discriminatorKey]);

        if (constructorByValue) {
          Constructor = constructorByValue;
        }
      }
    }

    if (Constructor.$isMongooseDocumentArray) {
      return Constructor.cast(value, this, undefined, undefined, index);
    }

    var ret = new Constructor(value, this, undefined, undefined, index);
    ret.isNew = true;
    return ret;
  },

  /**
   * Searches array items for the first document with a matching _id.
   *
   * #### Example:
   *
   *     const embeddedDoc = m.array.id(some_id);
   *
   * @return {EmbeddedDocument|null} the subdocument or null if not found.
   * @param {ObjectId|String|Number|Buffer} id
   * @TODO cast to the _id based on schema for proper comparison
   * @method id
   * @api public
   * @memberOf MongooseDocumentArray
   */
  id: function id(_id2) {
    var casted;
    var sid;

    var _id;

    try {
      casted = castObjectId(_id2).toString();
    } catch (e) {
      casted = null;
    }

    var _iterator = _createForOfIteratorHelper(this),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var val = _step.value;

        if (!val) {
          continue;
        }

        _id = val.get('_id');

        if (_id === null || typeof _id === 'undefined') {
          continue;
        } else if (_id instanceof Document) {
          sid || (sid = String(_id2));

          if (sid == _id._id) {
            return val;
          }
        } else if (!isBsonType(_id2, 'ObjectID') && !isBsonType(_id, 'ObjectID')) {
          if (_id2 == _id || utils.deepEqual(_id2, _id)) {
            return val;
          }
        } else if (casted == _id) {
          return val;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return null;
  },

  /**
   * Returns a native js Array of plain js objects
   *
   * #### Note:
   *
   * _Each sub-document is converted to a plain object by calling its `#toObject` method._
   *
   * @param {Object} [options] optional options to pass to each documents `toObject` method call during conversion
   * @return {Array}
   * @method toObject
   * @api public
   * @memberOf MongooseDocumentArray
   */
  toObject: function toObject(options) {
    // `[].concat` coerces the return value into a vanilla JS array, rather
    // than a Mongoose array.
    return [].concat(this.map(function (doc) {
      if (doc == null) {
        return null;
      }

      if (typeof doc.toObject !== 'function') {
        return doc;
      }

      return doc.toObject(options);
    }));
  },
  $toObject: function $toObject() {
    return this.constructor.prototype.toObject.apply(this, arguments);
  },

  /**
   * Wraps [`Array#push`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/push) with proper change tracking.
   *
   * @param {Object} [args...]
   * @api public
   * @method push
   * @memberOf MongooseDocumentArray
   */
  push: function push() {
    var ret = ArrayMethods.push.apply(this, arguments);

    _updateParentPopulated(this);

    return ret;
  },

  /**
   * Pulls items from the array atomically.
   *
   * @param {Object} [args...]
   * @api public
   * @method pull
   * @memberOf MongooseDocumentArray
   */
  pull: function pull() {
    var ret = ArrayMethods.pull.apply(this, arguments);

    _updateParentPopulated(this);

    return ret;
  },

  /*!
   * Wraps [`Array#shift`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/unshift) with proper change tracking.
   */
  shift: function shift() {
    var ret = ArrayMethods.shift.apply(this, arguments);

    _updateParentPopulated(this);

    return ret;
  },

  /*!
   * Wraps [`Array#splice`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/splice) with proper change tracking and casting.
   */
  splice: function splice() {
    var ret = ArrayMethods.splice.apply(this, arguments);

    _updateParentPopulated(this);

    return ret;
  },

  /**
   * Helper for console.log
   *
   * @method inspect
   * @api public
   * @memberOf MongooseDocumentArray
   */
  inspect: function inspect() {
    return this.toObject();
  },

  /**
   * Creates a subdocument casted to this schema.
   *
   * This is the same subdocument constructor used for casting.
   *
   * @param {Object} obj the value to cast to this arrays SubDocument schema
   * @method create
   * @api public
   * @memberOf MongooseDocumentArray
   */
  create: function create(obj) {
    var Constructor = this[arraySchemaSymbol].casterConstructor;

    if (obj && Constructor.discriminators && Constructor.schema && Constructor.schema.options && Constructor.schema.options.discriminatorKey) {
      if (typeof obj[Constructor.schema.options.discriminatorKey] === 'string' && Constructor.discriminators[obj[Constructor.schema.options.discriminatorKey]]) {
        Constructor = Constructor.discriminators[obj[Constructor.schema.options.discriminatorKey]];
      } else {
        var constructorByValue = getDiscriminatorByValue(Constructor.discriminators, obj[Constructor.schema.options.discriminatorKey]);

        if (constructorByValue) {
          Constructor = constructorByValue;
        }
      }
    }

    return new Constructor(obj, this);
  },

  /*!
   * ignore
   */
  notify: function notify(event) {
    var _this = this;

    return function notify(val, _arr) {
      _arr = _arr || _this;
      var i = _arr.length;

      while (i--) {
        if (_arr[i] == null) {
          continue;
        }

        switch (event) {
          // only swap for save event for now, we may change this to all event types later
          case 'save':
            val = _this[i];
            break;

          default:
            // NO-OP
            break;
        }

        if (utils.isMongooseArray(_arr[i])) {
          notify(val, _arr[i]);
        } else if (_arr[i]) {
          _arr[i].emit(event, val);
        }
      }
    };
  },
  set: function set(i, val, skipModified) {
    var arr = this.__array;

    if (skipModified) {
      arr[i] = val;
      return this;
    }

    var value = methods._cast.call(this, val, i);

    methods._markModified.call(this, i);

    arr[i] = value;
    return this;
  },
  _markModified: function _markModified(elem, embeddedPath) {
    var parent = this[arrayParentSymbol];
    var dirtyPath;

    if (parent) {
      dirtyPath = this[arrayPathSymbol];

      if (arguments.length) {
        if (embeddedPath != null) {
          // an embedded doc bubbled up the change
          var index = elem.__index;
          dirtyPath = dirtyPath + '.' + index + '.' + embeddedPath;
        } else {
          // directly set an index
          dirtyPath = dirtyPath + '.' + elem;
        }
      }

      if (dirtyPath != null && dirtyPath.endsWith('.$')) {
        return this;
      }

      parent.markModified(dirtyPath, arguments.length !== 0 ? elem : parent);
    }

    return this;
  }
};
module.exports = methods;
/*!
 * If this is a document array, each element may contain single
 * populated paths, so we need to modify the top-level document's
 * populated cache. See gh-8247, gh-8265.
 */

function _updateParentPopulated(arr) {
  var parent = arr[arrayParentSymbol];
  if (!parent || parent.$__.populated == null) return;
  var populatedPaths = Object.keys(parent.$__.populated).filter(function (p) {
    return p.startsWith(arr[arrayPathSymbol] + '.');
  });

  var _iterator2 = _createForOfIteratorHelper(populatedPaths),
      _step2;

  try {
    var _loop = function _loop() {
      var path = _step2.value;
      var remnant = path.slice((arr[arrayPathSymbol] + '.').length);

      if (!Array.isArray(parent.$__.populated[path].value)) {
        return "continue";
      }

      parent.$__.populated[path].value = arr.map(function (val) {
        return val.$populated(remnant);
      });
    };

    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var _ret = _loop();

      if (_ret === "continue") continue;
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
}

/***/ }),

/***/ 1362:
/***/ ((module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module dependencies.
 */


function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Document = __webpack_require__(8727);

var mongooseArrayMethods = __webpack_require__(8075);

var arrayAtomicsSymbol = (__webpack_require__(8770).arrayAtomicsSymbol);

var arrayAtomicsBackupSymbol = (__webpack_require__(8770).arrayAtomicsBackupSymbol);

var arrayParentSymbol = (__webpack_require__(8770).arrayParentSymbol);

var arrayPathSymbol = (__webpack_require__(8770).arrayPathSymbol);

var arraySchemaSymbol = (__webpack_require__(8770).arraySchemaSymbol);
/**
 * Mongoose Array constructor.
 *
 * #### Note:
 *
 * _Values always have to be passed to the constructor to initialize, otherwise `MongooseArray#push` will mark the array as modified._
 *
 * @param {Array} values
 * @param {String} path
 * @param {Document} doc parent document
 * @api private
 * @inherits Array
 * @see https://bit.ly/f6CnZU
 */


var _basePush = Array.prototype.push;
var numberRE = /^\d+$/;

function MongooseArray(values, path, doc, schematype) {
  var _internals;

  var __array;

  if (Array.isArray(values)) {
    var len = values.length; // Perf optimizations for small arrays: much faster to use `...` than `for` + `push`,
    // but large arrays may cause stack overflows. And for arrays of length 0/1, just
    // modifying the array is faster. Seems small, but adds up when you have a document
    // with thousands of nested arrays.

    if (len === 0) {
      __array = new Array();
    } else if (len === 1) {
      __array = new Array(1);
      __array[0] = values[0];
    } else if (len < 10000) {
      __array = new Array();

      _basePush.apply(__array, values);
    } else {
      __array = new Array();

      for (var i = 0; i < len; ++i) {
        _basePush.call(__array, values[i]);
      }
    }
  } else {
    __array = [];
  }

  var internals = (_internals = {}, _defineProperty(_internals, arrayAtomicsSymbol, {}), _defineProperty(_internals, arrayAtomicsBackupSymbol, void 0), _defineProperty(_internals, arrayPathSymbol, path), _defineProperty(_internals, arraySchemaSymbol, schematype), _defineProperty(_internals, arrayParentSymbol, void 0), _defineProperty(_internals, "isMongooseArray", true), _defineProperty(_internals, "isMongooseArrayProxy", true), _defineProperty(_internals, "__array", __array), _internals);

  if (values && values[arrayAtomicsSymbol] != null) {
    internals[arrayAtomicsSymbol] = values[arrayAtomicsSymbol];
  } // Because doc comes from the context of another function, doc === global
  // can happen if there was a null somewhere up the chain (see #3020)
  // RB Jun 17, 2015 updated to check for presence of expected paths instead
  // to make more proof against unusual node environments


  if (doc != null && doc instanceof Document) {
    internals[arrayParentSymbol] = doc;
    internals[arraySchemaSymbol] = schematype || doc.schema.path(path);
  }

  var proxy = new Proxy(__array, {
    get: function get(target, prop) {
      if (internals.hasOwnProperty(prop)) {
        return internals[prop];
      }

      if (mongooseArrayMethods.hasOwnProperty(prop)) {
        return mongooseArrayMethods[prop];
      }

      return __array[prop];
    },
    set: function set(target, prop, value) {
      if (typeof prop === 'string' && numberRE.test(prop)) {
        mongooseArrayMethods.set.call(proxy, prop, value, false);
      } else if (internals.hasOwnProperty(prop)) {
        internals[prop] = value;
      } else {
        __array[prop] = value;
      }

      return true;
    }
  });
  return proxy;
}
/*!
 * Module exports.
 */


module.exports = exports = MongooseArray;

/***/ }),

/***/ 7339:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.isMongooseArray = function (mongooseArray) {
  return Array.isArray(mongooseArray) && mongooseArray.isMongooseArray;
};

/***/ }),

/***/ 8075:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];


function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var Document = __webpack_require__(8727);

var ArraySubdocument = __webpack_require__(1568);

var MongooseError = __webpack_require__(5202);

var cleanModifiedSubpaths = __webpack_require__(4134);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var utils = __webpack_require__(6872);

var isBsonType = __webpack_require__(1563);

var arrayAtomicsSymbol = (__webpack_require__(8770).arrayAtomicsSymbol);

var arrayParentSymbol = (__webpack_require__(8770).arrayParentSymbol);

var arrayPathSymbol = (__webpack_require__(8770).arrayPathSymbol);

var arraySchemaSymbol = (__webpack_require__(8770).arraySchemaSymbol);

var populateModelSymbol = (__webpack_require__(8770).populateModelSymbol);

var slicedSymbol = Symbol('mongoose#Array#sliced');
var _basePush = Array.prototype.push;
/*!
 * ignore
 */

var methods = {
  /**
   * Depopulates stored atomic operation values as necessary for direct insertion to MongoDB.
   *
   * If no atomics exist, we return all array values after conversion.
   *
   * @return {Array}
   * @method $__getAtomics
   * @memberOf MongooseArray
   * @instance
   * @api private
   */
  $__getAtomics: function $__getAtomics() {
    var ret = [];
    var keys = Object.keys(this[arrayAtomicsSymbol] || {});
    var i = keys.length;
    var opts = Object.assign({}, internalToObjectOptions, {
      _isNested: true
    });

    if (i === 0) {
      ret[0] = ['$set', this.toObject(opts)];
      return ret;
    }

    while (i--) {
      var op = keys[i];
      var val = this[arrayAtomicsSymbol][op]; // the atomic values which are arrays are not MongooseArrays. we
      // need to convert their elements as if they were MongooseArrays
      // to handle populated arrays versus DocumentArrays properly.

      if (utils.isMongooseObject(val)) {
        val = val.toObject(opts);
      } else if (Array.isArray(val)) {
        val = this.toObject.call(val, opts);
      } else if (val != null && Array.isArray(val.$each)) {
        val.$each = this.toObject.call(val.$each, opts);
      } else if (val != null && typeof val.valueOf === 'function') {
        val = val.valueOf();
      }

      if (op === '$addToSet') {
        val = {
          $each: val
        };
      }

      ret.push([op, val]);
    }

    return ret;
  },

  /*!
   * ignore
   */
  $atomics: function $atomics() {
    return this[arrayAtomicsSymbol];
  },

  /*!
   * ignore
   */
  $parent: function $parent() {
    return this[arrayParentSymbol];
  },

  /*!
   * ignore
   */
  $path: function $path() {
    return this[arrayPathSymbol];
  },

  /**
   * Atomically shifts the array at most one time per document `save()`.
   *
   * #### Note:
   *
   * _Calling this multiple times on an array before saving sends the same command as calling it once._
   * _This update is implemented using the MongoDB [$pop](https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pop) method which enforces this restriction._
   *
   *      doc.array = [1,2,3];
   *
   *      const shifted = doc.array.$shift();
   *      console.log(shifted); // 1
   *      console.log(doc.array); // [2,3]
   *
   *      // no affect
   *      shifted = doc.array.$shift();
   *      console.log(doc.array); // [2,3]
   *
   *      doc.save(function (err) {
   *        if (err) return handleError(err);
   *
   *        // we saved, now $shift works again
   *        shifted = doc.array.$shift();
   *        console.log(shifted ); // 2
   *        console.log(doc.array); // [3]
   *      })
   *
   * @api public
   * @memberOf MongooseArray
   * @instance
   * @method $shift
   * @see mongodb https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pop
   */
  $shift: function $shift() {
    this._registerAtomic('$pop', -1);

    this._markModified(); // only allow shifting once


    if (this._shifted) {
      return;
    }

    this._shifted = true;
    return [].shift.call(this);
  },

  /**
   * Pops the array atomically at most one time per document `save()`.
   *
   * #### NOTE:
   *
   * _Calling this multiple times on an array before saving sends the same command as calling it once._
   * _This update is implemented using the MongoDB [$pop](https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pop) method which enforces this restriction._
   *
   *      doc.array = [1,2,3];
   *
   *      const popped = doc.array.$pop();
   *      console.log(popped); // 3
   *      console.log(doc.array); // [1,2]
   *
   *      // no affect
   *      popped = doc.array.$pop();
   *      console.log(doc.array); // [1,2]
   *
   *      doc.save(function (err) {
   *        if (err) return handleError(err);
   *
   *        // we saved, now $pop works again
   *        popped = doc.array.$pop();
   *        console.log(popped); // 2
   *        console.log(doc.array); // [1]
   *      })
   *
   * @api public
   * @method $pop
   * @memberOf MongooseArray
   * @instance
   * @see mongodb https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pop
   * @method $pop
   * @memberOf MongooseArray
   */
  $pop: function $pop() {
    this._registerAtomic('$pop', 1);

    this._markModified(); // only allow popping once


    if (this._popped) {
      return;
    }

    this._popped = true;
    return [].pop.call(this);
  },

  /*!
   * ignore
   */
  $schema: function $schema() {
    return this[arraySchemaSymbol];
  },

  /**
   * Casts a member based on this arrays schema.
   *
   * @param {any} value
   * @return value the casted value
   * @method _cast
   * @api private
   * @memberOf MongooseArray
   */
  _cast: function _cast(value) {
    var populated = false;
    var Model;
    var parent = this[arrayParentSymbol];

    if (parent) {
      populated = parent.$populated(this[arrayPathSymbol], true);
    }

    if (populated && value !== null && value !== undefined) {
      // cast to the populated Models schema
      Model = populated.options[populateModelSymbol]; // only objects are permitted so we can safely assume that
      // non-objects are to be interpreted as _id

      if (Buffer.isBuffer(value) || isBsonType(value, 'ObjectID') || !utils.isObject(value)) {
        value = {
          _id: value
        };
      } // gh-2399
      // we should cast model only when it's not a discriminator


      var isDisc = value.schema && value.schema.discriminatorMapping && value.schema.discriminatorMapping.key !== undefined;

      if (!isDisc) {
        value = new Model(value);
      }

      return this[arraySchemaSymbol].caster.applySetters(value, parent, true);
    }

    return this[arraySchemaSymbol].caster.applySetters(value, parent, false);
  },

  /**
   * Internal helper for .map()
   *
   * @api private
   * @return {Number}
   * @method _mapCast
   * @memberOf MongooseArray
   */
  _mapCast: function _mapCast(val, index) {
    return this._cast(val, this.length + index);
  },

  /**
   * Marks this array as modified.
   *
   * If it bubbles up from an embedded document change, then it takes the following arguments (otherwise, takes 0 arguments)
   *
   * @param {ArraySubdocument} subdoc the embedded doc that invoked this method on the Array
   * @param {String} embeddedPath the path which changed in the subdoc
   * @method _markModified
   * @api private
   * @memberOf MongooseArray
   */
  _markModified: function _markModified(elem) {
    var parent = this[arrayParentSymbol];
    var dirtyPath;

    if (parent) {
      dirtyPath = this[arrayPathSymbol];

      if (arguments.length) {
        dirtyPath = dirtyPath + '.' + elem;
      }

      if (dirtyPath != null && dirtyPath.endsWith('.$')) {
        return this;
      }

      parent.markModified(dirtyPath, arguments.length !== 0 ? elem : parent);
    }

    return this;
  },

  /**
   * Register an atomic operation with the parent.
   *
   * @param {Array} op operation
   * @param {any} val
   * @method _registerAtomic
   * @api private
   * @memberOf MongooseArray
   */
  _registerAtomic: function _registerAtomic(op, val) {
    if (this[slicedSymbol]) {
      return;
    }

    if (op === '$set') {
      // $set takes precedence over all other ops.
      // mark entire array modified.
      this[arrayAtomicsSymbol] = {
        $set: val
      };
      cleanModifiedSubpaths(this[arrayParentSymbol], this[arrayPathSymbol]);

      this._markModified();

      return this;
    }

    var atomics = this[arrayAtomicsSymbol]; // reset pop/shift after save

    if (op === '$pop' && !('$pop' in atomics)) {
      var _this = this;

      this[arrayParentSymbol].once('save', function () {
        _this._popped = _this._shifted = null;
      });
    } // check for impossible $atomic combos (Mongo denies more than one
    // $atomic op on a single path


    if (atomics.$set || Object.keys(atomics).length && !(op in atomics)) {
      // a different op was previously registered.
      // save the entire thing.
      this[arrayAtomicsSymbol] = {
        $set: this
      };
      return this;
    }

    var selector;

    if (op === '$pullAll' || op === '$addToSet') {
      atomics[op] || (atomics[op] = []);
      atomics[op] = atomics[op].concat(val);
    } else if (op === '$pullDocs') {
      var pullOp = atomics['$pull'] || (atomics['$pull'] = {});

      if (val[0] instanceof ArraySubdocument) {
        selector = pullOp['$or'] || (pullOp['$or'] = []);
        Array.prototype.push.apply(selector, val.map(function (v) {
          return v.toObject({
            transform: false,
            virtuals: false
          });
        }));
      } else {
        selector = pullOp['_id'] || (pullOp['_id'] = {
          $in: []
        });
        selector['$in'] = selector['$in'].concat(val);
      }
    } else if (op === '$push') {
      atomics.$push = atomics.$push || {
        $each: []
      };

      if (val != null && utils.hasUserDefinedProperty(val, '$each')) {
        atomics.$push = val;
      } else {
        atomics.$push.$each = atomics.$push.$each.concat(val);
      }
    } else {
      atomics[op] = val;
    }

    return this;
  },

  /**
   * Adds values to the array if not already present.
   *
   * #### Example:
   *
   *     console.log(doc.array) // [2,3,4]
   *     const added = doc.array.addToSet(4,5);
   *     console.log(doc.array) // [2,3,4,5]
   *     console.log(added)     // [5]
   *
   * @param {any} [args...]
   * @return {Array} the values that were added
   * @memberOf MongooseArray
   * @api public
   * @method addToSet
   */
  addToSet: function addToSet() {
    _checkManualPopulation(this, arguments);

    var values = [].map.call(arguments, this._mapCast, this);
    values = this[arraySchemaSymbol].applySetters(values, this[arrayParentSymbol]);
    var added = [];
    var type = '';

    if (values[0] instanceof ArraySubdocument) {
      type = 'doc';
    } else if (values[0] instanceof Date) {
      type = 'date';
    }

    var rawValues = utils.isMongooseArray(values) ? values.__array : this;
    var rawArray = utils.isMongooseArray(this) ? this.__array : this;
    rawValues.forEach(function (v) {
      var found;
      var val = +v;

      switch (type) {
        case 'doc':
          found = this.some(function (doc) {
            return doc.equals(v);
          });
          break;

        case 'date':
          found = this.some(function (d) {
            return +d === val;
          });
          break;

        default:
          found = ~this.indexOf(v);
      }

      if (!found) {
        this._markModified();

        rawArray.push(v);

        this._registerAtomic('$addToSet', v);

        [].push.call(added, v);
      }
    }, this);
    return added;
  },

  /**
   * Returns the number of pending atomic operations to send to the db for this array.
   *
   * @api private
   * @return {Number}
   * @method hasAtomics
   * @memberOf MongooseArray
   */
  hasAtomics: function hasAtomics() {
    if (!utils.isPOJO(this[arrayAtomicsSymbol])) {
      return 0;
    }

    return Object.keys(this[arrayAtomicsSymbol]).length;
  },

  /**
   * Return whether or not the `obj` is included in the array.
   *
   * @param {Object} obj the item to check
   * @param {Number} fromIndex
   * @return {Boolean}
   * @api public
   * @method includes
   * @memberOf MongooseArray
   */
  includes: function includes(obj, fromIndex) {
    var ret = this.indexOf(obj, fromIndex);
    return ret !== -1;
  },

  /**
   * Return the index of `obj` or `-1` if not found.
   *
   * @param {Object} obj the item to look for
   * @param {Number} fromIndex
   * @return {Number}
   * @api public
   * @method indexOf
   * @memberOf MongooseArray
   */
  indexOf: function indexOf(obj, fromIndex) {
    if (isBsonType(obj, 'ObjectID')) {
      obj = obj.toString();
    }

    fromIndex = fromIndex == null ? 0 : fromIndex;
    var len = this.length;

    for (var i = fromIndex; i < len; ++i) {
      if (obj == this[i]) {
        return i;
      }
    }

    return -1;
  },

  /**
   * Helper for console.log
   *
   * @api public
   * @method inspect
   * @memberOf MongooseArray
   */
  inspect: function inspect() {
    return JSON.stringify(this);
  },

  /**
   * Pushes items to the array non-atomically.
   *
   * #### Note:
   *
   * _marks the entire array as modified, which if saved, will store it as a `$set` operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it._
   *
   * @param {any} [args...]
   * @api public
   * @method nonAtomicPush
   * @memberOf MongooseArray
   */
  nonAtomicPush: function nonAtomicPush() {
    var values = [].map.call(arguments, this._mapCast, this);

    this._markModified();

    var ret = [].push.apply(this, values);

    this._registerAtomic('$set', this);

    return ret;
  },

  /**
   * Wraps [`Array#pop`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/pop) with proper change tracking.
   *
   * #### Note:
   *
   * _marks the entire array as modified which will pass the entire thing to $set potentially overwriting any changes that happen between when you retrieved the object and when you save it._
   *
   * @see MongooseArray#$pop #types_array_MongooseArray-%24pop
   * @api public
   * @method pop
   * @memberOf MongooseArray
   */
  pop: function pop() {
    this._markModified();

    var ret = [].pop.call(this);

    this._registerAtomic('$set', this);

    return ret;
  },

  /**
   * Pulls items from the array atomically. Equality is determined by casting
   * the provided value to an embedded document and comparing using
   * [the `Document.equals()` function.](/docs/api.html#document_Document-equals)
   *
   * #### Examples:
   *
   *     doc.array.pull(ObjectId)
   *     doc.array.pull({ _id: 'someId' })
   *     doc.array.pull(36)
   *     doc.array.pull('tag 1', 'tag 2')
   *
   * To remove a document from a subdocument array we may pass an object with a matching `_id`.
   *
   *     doc.subdocs.push({ _id: 4815162342 })
   *     doc.subdocs.pull({ _id: 4815162342 }) // removed
   *
   * Or we may passing the _id directly and let mongoose take care of it.
   *
   *     doc.subdocs.push({ _id: 4815162342 })
   *     doc.subdocs.pull(4815162342); // works
   *
   * The first pull call will result in a atomic operation on the database, if pull is called repeatedly without saving the document, a $set operation is used on the complete array instead, overwriting possible changes that happened on the database in the meantime.
   *
   * @param {any} [args...]
   * @see mongodb https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pull
   * @api public
   * @method pull
   * @memberOf MongooseArray
   */
  pull: function pull() {
    var values = [].map.call(arguments, this._cast, this);
    var cur = this[arrayParentSymbol].get(this[arrayPathSymbol]);
    var i = cur.length;
    var mem;

    this._markModified();

    while (i--) {
      mem = cur[i];

      if (mem instanceof Document) {
        var some = values.some(function (v) {
          return mem.equals(v);
        });

        if (some) {
          [].splice.call(cur, i, 1);
        }
      } else if (~cur.indexOf.call(values, mem)) {
        [].splice.call(cur, i, 1);
      }
    }

    if (values[0] instanceof ArraySubdocument) {
      this._registerAtomic('$pullDocs', values.map(function (v) {
        return v.$__getValue('_id') || v;
      }));
    } else {
      this._registerAtomic('$pullAll', values);
    } // Might have modified child paths and then pulled, like
    // `doc.children[1].name = 'test';` followed by
    // `doc.children.remove(doc.children[0]);`. In this case we fall back
    // to a `$set` on the whole array. See #3511


    if (cleanModifiedSubpaths(this[arrayParentSymbol], this[arrayPathSymbol]) > 0) {
      this._registerAtomic('$set', this);
    }

    return this;
  },

  /**
   * Wraps [`Array#push`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/push) with proper change tracking.
   *
   * #### Example:
   *
   *     const schema = Schema({ nums: [Number] });
   *     const Model = mongoose.model('Test', schema);
   *
   *     const doc = await Model.create({ nums: [3, 4] });
   *     doc.nums.push(5); // Add 5 to the end of the array
   *     await doc.save();
   *
   *     // You can also pass an object with `$each` as the
   *     // first parameter to use MongoDB's `$position`
   *     doc.nums.push({
   *       $each: [1, 2],
   *       $position: 0
   *     });
   *     doc.nums; // [1, 2, 3, 4, 5]
   *
   * @param {Object} [args...]
   * @api public
   * @method push
   * @memberOf MongooseArray
   */
  push: function push() {
    var values = arguments;
    var atomic = values;
    var isOverwrite = values[0] != null && utils.hasUserDefinedProperty(values[0], '$each');
    var arr = utils.isMongooseArray(this) ? this.__array : this;

    if (isOverwrite) {
      atomic = values[0];
      values = values[0].$each;
    }

    if (this[arraySchemaSymbol] == null) {
      return _basePush.apply(this, values);
    }

    _checkManualPopulation(this, values);

    var parent = this[arrayParentSymbol];
    values = [].map.call(values, this._mapCast, this);
    values = this[arraySchemaSymbol].applySetters(values, parent, undefined, undefined, {
      skipDocumentArrayCast: true
    });
    var ret;
    var atomics = this[arrayAtomicsSymbol];

    this._markModified();

    if (isOverwrite) {
      atomic.$each = values;

      if ((atomics.$push && atomics.$push.$each && atomics.$push.$each.length || 0) !== 0 && atomics.$push.$position != atomic.$position) {
        throw new MongooseError('Cannot call `Array#push()` multiple times ' + 'with different `$position`');
      }

      if (atomic.$position != null) {
        [].splice.apply(arr, [atomic.$position, 0].concat(values));
        ret = this.length;
      } else {
        ret = [].push.apply(arr, values);
      }
    } else {
      if ((atomics.$push && atomics.$push.$each && atomics.$push.$each.length || 0) !== 0 && atomics.$push.$position != null) {
        throw new MongooseError('Cannot call `Array#push()` multiple times ' + 'with different `$position`');
      }

      atomic = values;
      ret = [].push.apply(arr, values);
    }

    this._registerAtomic('$push', atomic);

    return ret;
  },

  /**
   * Alias of [pull](#mongoosearray_MongooseArray-pull)
   *
   * @see MongooseArray#pull #types_array_MongooseArray-pull
   * @see mongodb https://www.mongodb.org/display/DOCS/Updating/#Updating-%24pull
   * @api public
   * @memberOf MongooseArray
   * @instance
   * @method remove
   */
  remove: function remove() {
    return this.pull.apply(this, arguments);
  },

  /**
   * Sets the casted `val` at index `i` and marks the array modified.
   *
   * #### Example:
   *
   *     // given documents based on the following
   *     const Doc = mongoose.model('Doc', new Schema({ array: [Number] }));
   *
   *     const doc = new Doc({ array: [2,3,4] })
   *
   *     console.log(doc.array) // [2,3,4]
   *
   *     doc.array.set(1,"5");
   *     console.log(doc.array); // [2,5,4] // properly cast to number
   *     doc.save() // the change is saved
   *
   *     // VS not using array#set
   *     doc.array[1] = "5";
   *     console.log(doc.array); // [2,"5",4] // no casting
   *     doc.save() // change is not saved
   *
   * @return {Array} this
   * @api public
   * @method set
   * @memberOf MongooseArray
   */
  set: function set(i, val, skipModified) {
    var arr = this.__array;

    if (skipModified) {
      arr[i] = val;
      return this;
    }

    var value = methods._cast.call(this, val, i);

    methods._markModified.call(this, i);

    arr[i] = value;
    return this;
  },

  /**
   * Wraps [`Array#shift`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/unshift) with proper change tracking.
   *
   * #### Example:
   *
   *     doc.array = [2,3];
   *     const res = doc.array.shift();
   *     console.log(res) // 2
   *     console.log(doc.array) // [3]
   *
   * #### Note:
   *
   * _marks the entire array as modified, which if saved, will store it as a `$set` operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it._
   *
   * @api public
   * @method shift
   * @memberOf MongooseArray
   */
  shift: function shift() {
    var arr = utils.isMongooseArray(this) ? this.__array : this;

    this._markModified();

    var ret = [].shift.call(arr);

    this._registerAtomic('$set', this);

    return ret;
  },

  /**
   * Wraps [`Array#sort`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/sort) with proper change tracking.
   *
   * #### Note:
   *
   * _marks the entire array as modified, which if saved, will store it as a `$set` operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it._
   *
   * @api public
   * @method sort
   * @memberOf MongooseArray
   * @see https://masteringjs.io/tutorials/fundamentals/array-sort
   */
  sort: function sort() {
    var arr = utils.isMongooseArray(this) ? this.__array : this;
    var ret = [].sort.apply(arr, arguments);

    this._registerAtomic('$set', this);

    return ret;
  },

  /**
   * Wraps [`Array#splice`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/splice) with proper change tracking and casting.
   *
   * #### Note:
   *
   * _marks the entire array as modified, which if saved, will store it as a `$set` operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it._
   *
   * @api public
   * @method splice
   * @memberOf MongooseArray
   * @see https://masteringjs.io/tutorials/fundamentals/array-splice
   */
  splice: function splice() {
    var ret;
    var arr = utils.isMongooseArray(this) ? this.__array : this;

    _checkManualPopulation(this, Array.prototype.slice.call(arguments, 2));

    if (arguments.length) {
      var vals;

      if (this[arraySchemaSymbol] == null) {
        vals = arguments;
      } else {
        vals = [];

        for (var i = 0; i < arguments.length; ++i) {
          vals[i] = i < 2 ? arguments[i] : this._cast(arguments[i], arguments[0] + (i - 2));
        }
      }

      ret = [].splice.apply(arr, vals);

      this._registerAtomic('$set', this);
    }

    return ret;
  },

  /*!
   * ignore
   */
  toBSON: function toBSON() {
    return this.toObject(internalToObjectOptions);
  },

  /**
   * Returns a native js Array.
   *
   * @param {Object} options
   * @return {Array}
   * @api public
   * @method toObject
   * @memberOf MongooseArray
   */
  toObject: function toObject(options) {
    var arr = utils.isMongooseArray(this) ? this.__array : this;

    if (options && options.depopulate) {
      options = utils.clone(options);
      options._isNested = true; // Ensure return value is a vanilla array, because in Node.js 6+ `map()`
      // is smart enough to use the inherited array's constructor.

      return [].concat(arr).map(function (doc) {
        return doc instanceof Document ? doc.toObject(options) : doc;
      });
    }

    return [].concat(arr);
  },
  $toObject: function $toObject() {
    return this.constructor.prototype.toObject.apply(this, arguments);
  },

  /**
   * Wraps [`Array#unshift`](https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/unshift) with proper change tracking.
   *
   * #### Note:
   *
   * _marks the entire array as modified, which if saved, will store it as a `$set` operation, potentially overwriting any changes that happen between when you retrieved the object and when you save it._
   *
   * @api public
   * @method unshift
   * @memberOf MongooseArray
   */
  unshift: function unshift() {
    _checkManualPopulation(this, arguments);

    var values;

    if (this[arraySchemaSymbol] == null) {
      values = arguments;
    } else {
      values = [].map.call(arguments, this._cast, this);
      values = this[arraySchemaSymbol].applySetters(values, this[arrayParentSymbol]);
    }

    var arr = utils.isMongooseArray(this) ? this.__array : this;

    this._markModified();

    [].unshift.apply(arr, values);

    this._registerAtomic('$set', this);

    return this.length;
  }
};
/*!
 * ignore
 */

function _isAllSubdocs(docs, ref) {
  if (!ref) {
    return false;
  }

  var _iterator = _createForOfIteratorHelper(docs),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var arg = _step.value;

      if (arg == null) {
        return false;
      }

      var model = arg.constructor;

      if (!(arg instanceof Document) || model.modelName !== ref && model.baseModelName !== ref) {
        return false;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return true;
}
/*!
 * ignore
 */


function _checkManualPopulation(arr, docs) {
  var ref = arr == null ? null : arr[arraySchemaSymbol] && arr[arraySchemaSymbol].caster && arr[arraySchemaSymbol].caster.options && arr[arraySchemaSymbol].caster.options.ref || null;

  if (arr.length === 0 && docs.length !== 0) {
    if (_isAllSubdocs(docs, ref)) {
      arr[arrayParentSymbol].$populated(arr[arrayPathSymbol], [], _defineProperty({}, populateModelSymbol, docs[0].constructor));
    }
  }
}

var returnVanillaArrayMethods = ['filter', 'flat', 'flatMap', 'map', 'slice'];

var _loop = function _loop() {
  var method = _returnVanillaArrayMe[_i];

  if (Array.prototype[method] == null) {
    return "continue";
  }

  methods[method] = function () {
    var _arr = utils.isMongooseArray(this) ? this.__array : this;

    var arr = [].concat(_arr);
    return arr[method].apply(arr, arguments);
  };
};

for (var _i = 0, _returnVanillaArrayMe = returnVanillaArrayMethods; _i < _returnVanillaArrayMe.length; _i++) {
  var _ret = _loop();

  if (_ret === "continue") continue;
}

module.exports = methods;

/***/ }),

/***/ 4051:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];
/*!
 * Module dependencies.
 */


var Binary = (__webpack_require__(9906).get)().Binary;

var utils = __webpack_require__(6872);
/**
 * Mongoose Buffer constructor.
 *
 * Values always have to be passed to the constructor to initialize.
 *
 * @param {Buffer} value
 * @param {String} encode
 * @param {Number} offset
 * @api private
 * @inherits Buffer
 * @see https://bit.ly/f6CnZU
 */


function MongooseBuffer(value, encode, offset) {
  var val = value;

  if (value == null) {
    val = 0;
  }

  var encoding;
  var path;
  var doc;

  if (Array.isArray(encode)) {
    // internal casting
    path = encode[0];
    doc = encode[1];
  } else {
    encoding = encode;
  }

  var buf;

  if (typeof val === 'number' || val instanceof Number) {
    buf = Buffer.alloc(val);
  } else {
    // string, array or object { type: 'Buffer', data: [...] }
    buf = Buffer.from(val, encoding, offset);
  }

  utils.decorate(buf, MongooseBuffer.mixin);
  buf.isMongooseBuffer = true; // make sure these internal props don't show up in Object.keys()

  buf[MongooseBuffer.pathSymbol] = path;
  buf[parentSymbol] = doc;
  buf._subtype = 0;
  return buf;
}

var pathSymbol = Symbol["for"]('mongoose#Buffer#_path');
var parentSymbol = Symbol["for"]('mongoose#Buffer#_parent');
MongooseBuffer.pathSymbol = pathSymbol;
/*!
 * Inherit from Buffer.
 */

MongooseBuffer.mixin = {
  /**
   * Default subtype for the Binary representing this Buffer
   *
   * @api private
   * @property _subtype
   * @receiver MongooseBuffer
   */
  _subtype: undefined,

  /**
   * Marks this buffer as modified.
   *
   * @api private
   * @method _markModified
   * @receiver MongooseBuffer
   */
  _markModified: function _markModified() {
    var parent = this[parentSymbol];

    if (parent) {
      parent.markModified(this[MongooseBuffer.pathSymbol]);
    }

    return this;
  },

  /**
   * Writes the buffer.
   *
   * @api public
   * @method write
   * @receiver MongooseBuffer
   */
  write: function write() {
    var written = Buffer.prototype.write.apply(this, arguments);

    if (written > 0) {
      this._markModified();
    }

    return written;
  },

  /**
   * Copies the buffer.
   *
   * #### Note:
   *
   * `Buffer#copy` does not mark `target` as modified so you must copy from a `MongooseBuffer` for it to work as expected. This is a work around since `copy` modifies the target, not this.
   *
   * @return {Number} The number of bytes copied.
   * @param {Buffer} target
   * @method copy
   * @receiver MongooseBuffer
   */
  copy: function copy(target) {
    var ret = Buffer.prototype.copy.apply(this, arguments);

    if (target && target.isMongooseBuffer) {
      target._markModified();
    }

    return ret;
  }
};
/*!
 * Compile other Buffer methods marking this buffer as modified.
 */

( // node < 0.5
'writeUInt8 writeUInt16 writeUInt32 writeInt8 writeInt16 writeInt32 ' + 'writeFloat writeDouble fill ' + 'utf8Write binaryWrite asciiWrite set ' + // node >= 0.5
'writeUInt16LE writeUInt16BE writeUInt32LE writeUInt32BE ' + 'writeInt16LE writeInt16BE writeInt32LE writeInt32BE ' + 'writeFloatLE writeFloatBE writeDoubleLE writeDoubleBE').split(' ').forEach(function (method) {
  if (!Buffer.prototype[method]) {
    return;
  }

  MongooseBuffer.mixin[method] = function () {
    var ret = Buffer.prototype[method].apply(this, arguments);

    this._markModified();

    return ret;
  };
});
/**
 * Converts this buffer to its Binary type representation.
 *
 * ####SubTypes:
 *
 *   const bson = require('bson')
 *   bson.BSON_BINARY_SUBTYPE_DEFAULT
 *   bson.BSON_BINARY_SUBTYPE_FUNCTION
 *   bson.BSON_BINARY_SUBTYPE_BYTE_ARRAY
 *   bson.BSON_BINARY_SUBTYPE_UUID
 *   bson.BSON_BINARY_SUBTYPE_MD5
 *   bson.BSON_BINARY_SUBTYPE_USER_DEFINED
 *
 *   doc.buffer.toObject(bson.BSON_BINARY_SUBTYPE_USER_DEFINED);
 *
 * @see https://bsonspec.org/#/specification
 * @param {Hex} [subtype]
 * @return {Binary}
 * @api public
 * @method toObject
 * @receiver MongooseBuffer
 */

MongooseBuffer.mixin.toObject = function (options) {
  var subtype = typeof options === 'number' ? options : this._subtype || 0;
  return new Binary(Buffer.from(this), subtype);
};

MongooseBuffer.mixin.$toObject = MongooseBuffer.mixin.toObject;
/**
 * Converts this buffer for storage in MongoDB, including subtype
 *
 * @return {Binary}
 * @api public
 * @method toBSON
 * @receiver MongooseBuffer
 */

MongooseBuffer.mixin.toBSON = function () {
  return new Binary(this, this._subtype || 0);
};
/**
 * Determines if this buffer is equals to `other` buffer
 *
 * @param {Buffer} other
 * @return {Boolean}
 * @method equals
 * @receiver MongooseBuffer
 */


MongooseBuffer.mixin.equals = function (other) {
  if (!Buffer.isBuffer(other)) {
    return false;
  }

  if (this.length !== other.length) {
    return false;
  }

  for (var i = 0; i < this.length; ++i) {
    if (this[i] !== other[i]) {
      return false;
    }
  }

  return true;
};
/**
 * Sets the subtype option and marks the buffer modified.
 *
 * ####SubTypes:
 *
 *   const bson = require('bson')
 *   bson.BSON_BINARY_SUBTYPE_DEFAULT
 *   bson.BSON_BINARY_SUBTYPE_FUNCTION
 *   bson.BSON_BINARY_SUBTYPE_BYTE_ARRAY
 *   bson.BSON_BINARY_SUBTYPE_UUID
 *   bson.BSON_BINARY_SUBTYPE_MD5
 *   bson.BSON_BINARY_SUBTYPE_USER_DEFINED
 *
 *   doc.buffer.subtype(bson.BSON_BINARY_SUBTYPE_UUID);
 *
 * @see https://bsonspec.org/#/specification
 * @param {Hex} subtype
 * @api public
 * @method subtype
 * @receiver MongooseBuffer
 */


MongooseBuffer.mixin.subtype = function (subtype) {
  if (typeof subtype !== 'number') {
    throw new TypeError('Invalid subtype. Expected a number');
  }

  if (this._subtype !== subtype) {
    this._markModified();
  }

  this._subtype = subtype;
};
/*!
 * Module exports.
 */


MongooseBuffer.Binary = Binary;
module.exports = MongooseBuffer;

/***/ }),

/***/ 5003:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * ObjectId type constructor
 *
 * #### Example
 *
 *     const id = new mongoose.Types.ObjectId;
 *
 * @constructor ObjectId
 */


module.exports = (__webpack_require__(9906).get)().Decimal128;

/***/ }),

/***/ 8941:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/*!
 * Module exports.
 */


exports.Array = __webpack_require__(1362);
exports.Buffer = __webpack_require__(4051);
exports.Document = // @deprecate
exports.Embedded = __webpack_require__(1568);
exports.DocumentArray = __webpack_require__(6077);
exports.Decimal128 = __webpack_require__(5003);
exports.ObjectId = __webpack_require__(6079);
exports.Map = __webpack_require__(3828);
exports.Subdocument = __webpack_require__(2591);

/***/ }),

/***/ 3828:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Mixed = __webpack_require__(3861);

var clone = __webpack_require__(1973);

var deepEqual = (__webpack_require__(6872).deepEqual);

var getConstructorName = __webpack_require__(1981);

var handleSpreadDoc = __webpack_require__(719);

var util = __webpack_require__(161);

var specialProperties = __webpack_require__(2862);

var isBsonType = __webpack_require__(1563);

var populateModelSymbol = (__webpack_require__(8770).populateModelSymbol);
/*!
 * ignore
 */


var MongooseMap = /*#__PURE__*/function (_Map) {
  _inherits(MongooseMap, _Map);

  var _super = _createSuper(MongooseMap);

  function MongooseMap(v, path, doc, schemaType) {
    var _this;

    _classCallCheck(this, MongooseMap);

    if (getConstructorName(v) === 'Object') {
      v = Object.keys(v).reduce(function (arr, key) {
        return arr.concat([[key, v[key]]]);
      }, []);
    }

    _this = _super.call(this, v);
    _this.$__parent = doc != null && doc.$__ != null ? doc : null;
    _this.$__path = path;
    _this.$__schemaType = schemaType == null ? new Mixed(path) : schemaType;

    _this.$__runDeferred();

    return _this;
  }

  _createClass(MongooseMap, [{
    key: "$init",
    value: function $init(key, value) {
      checkValidKey(key);

      _get(_getPrototypeOf(MongooseMap.prototype), "set", this).call(this, key, value);

      if (value != null && value.$isSingleNested) {
        value.$basePath = this.$__path + '.' + key;
      }
    }
  }, {
    key: "$__set",
    value: function $__set(key, value) {
      _get(_getPrototypeOf(MongooseMap.prototype), "set", this).call(this, key, value);
    }
  }, {
    key: "get",
    value: function get(key, options) {
      if (isBsonType(key, 'ObjectID')) {
        key = key.toString();
      }

      options = options || {};

      if (options.getters === false) {
        return _get(_getPrototypeOf(MongooseMap.prototype), "get", this).call(this, key);
      }

      return this.$__schemaType.applyGetters(_get(_getPrototypeOf(MongooseMap.prototype), "get", this).call(this, key), this.$__parent);
    }
  }, {
    key: "set",
    value: function set(key, value) {
      if (isBsonType(key, 'ObjectID')) {
        key = key.toString();
      }

      checkValidKey(key);
      value = handleSpreadDoc(value); // Weird, but because you can't assign to `this` before calling `super()`
      // you can't get access to `$__schemaType` to cast in the initial call to
      // `set()` from the `super()` constructor.

      if (this.$__schemaType == null) {
        this.$__deferred = this.$__deferred || [];
        this.$__deferred.push({
          key: key,
          value: value
        });
        return;
      }

      var fullPath = this.$__path + '.' + key;
      var populated = this.$__parent != null && this.$__parent.$__ ? this.$__parent.$populated(fullPath) || this.$__parent.$populated(this.$__path) : null;
      var priorVal = this.get(key);

      if (populated != null) {
        if (value.$__ == null) {
          value = new populated.options[populateModelSymbol](value);
        }

        value.$__.wasPopulated = {
          value: populated.value
        };
      } else {
        try {
          value = this.$__schemaType.applySetters(value, this.$__parent, false, this.get(key), {
            path: fullPath
          });
        } catch (error) {
          if (this.$__parent != null && this.$__parent.$__ != null) {
            this.$__parent.invalidate(fullPath, error);
            return;
          }

          throw error;
        }
      }

      _get(_getPrototypeOf(MongooseMap.prototype), "set", this).call(this, key, value);

      if (value != null && value.$isSingleNested) {
        value.$basePath = this.$__path + '.' + key;
      }

      var parent = this.$__parent;

      if (parent != null && parent.$__ != null && !deepEqual(value, priorVal)) {
        parent.markModified(this.$__path + '.' + key);
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      _get(_getPrototypeOf(MongooseMap.prototype), "clear", this).call(this);

      var parent = this.$__parent;

      if (parent != null) {
        parent.markModified(this.$__path);
      }
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      if (isBsonType(key, 'ObjectID')) {
        key = key.toString();
      }

      this.set(key, undefined);

      _get(_getPrototypeOf(MongooseMap.prototype), "delete", this).call(this, key);
    }
  }, {
    key: "toBSON",
    value: function toBSON() {
      return new Map(this);
    }
  }, {
    key: "toObject",
    value: function toObject(options) {
      if (options && options.flattenMaps) {
        var ret = {};
        var keys = this.keys();

        var _iterator = _createForOfIteratorHelper(keys),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var key = _step.value;
            ret[key] = clone(this.get(key), options);
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        return ret;
      }

      return new Map(this);
    }
  }, {
    key: "$toObject",
    value: function $toObject() {
      return this.constructor.prototype.toObject.apply(this, arguments);
    }
  }, {
    key: "toJSON",
    value: function toJSON(options) {
      if (typeof (options && options.flattenMaps) === 'boolean' ? options.flattenMaps : true) {
        var ret = {};
        var keys = this.keys();

        var _iterator2 = _createForOfIteratorHelper(keys),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var key = _step2.value;
            ret[key] = clone(this.get(key), options);
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return ret;
      }

      return new Map(this);
    }
  }, {
    key: "inspect",
    value: function inspect() {
      return new Map(this);
    }
  }, {
    key: "$__runDeferred",
    value: function $__runDeferred() {
      if (!this.$__deferred) {
        return;
      }

      var _iterator3 = _createForOfIteratorHelper(this.$__deferred),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var keyValueObject = _step3.value;
          this.set(keyValueObject.key, keyValueObject.value);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      this.$__deferred = null;
    }
  }]);

  return MongooseMap;
}( /*#__PURE__*/_wrapNativeSuper(Map));

if (util.inspect.custom) {
  Object.defineProperty(MongooseMap.prototype, util.inspect.custom, {
    enumerable: false,
    writable: false,
    configurable: false,
    value: MongooseMap.prototype.inspect
  });
}

Object.defineProperty(MongooseMap.prototype, '$__set', {
  enumerable: false,
  writable: true,
  configurable: false
});
Object.defineProperty(MongooseMap.prototype, '$__parent', {
  enumerable: false,
  writable: true,
  configurable: false
});
Object.defineProperty(MongooseMap.prototype, '$__path', {
  enumerable: false,
  writable: true,
  configurable: false
});
Object.defineProperty(MongooseMap.prototype, '$__schemaType', {
  enumerable: false,
  writable: true,
  configurable: false
});
Object.defineProperty(MongooseMap.prototype, '$isMongooseMap', {
  enumerable: false,
  writable: false,
  configurable: false,
  value: true
});
Object.defineProperty(MongooseMap.prototype, '$__deferredCalls', {
  enumerable: false,
  writable: false,
  configurable: false,
  value: true
});
/*!
 * Since maps are stored as objects under the hood, keys must be strings
 * and can't contain any invalid characters
 */

function checkValidKey(key) {
  var keyType = _typeof(key);

  if (keyType !== 'string') {
    throw new TypeError("Mongoose maps only support string keys, got ".concat(keyType));
  }

  if (key.startsWith('$')) {
    throw new Error("Mongoose maps do not support keys that start with \"$\", got \"".concat(key, "\""));
  }

  if (key.includes('.')) {
    throw new Error("Mongoose maps do not support keys that contain \".\", got \"".concat(key, "\""));
  }

  if (specialProperties.has(key)) {
    throw new Error("Mongoose maps do not support reserved key name \"".concat(key, "\""));
  }
}

module.exports = MongooseMap;

/***/ }),

/***/ 6079:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * ObjectId type constructor
 *
 * #### Example
 *
 *     const id = new mongoose.Types.ObjectId;
 *
 * @constructor ObjectId
 */


var ObjectId = (__webpack_require__(9906).get)().ObjectId;

var objectIdSymbol = (__webpack_require__(8770).objectIdSymbol);
/*!
 * Getter for convenience with populate, see gh-6115
 */


Object.defineProperty(ObjectId.prototype, '_id', {
  enumerable: false,
  configurable: true,
  get: function get() {
    return this;
  }
});
/*!
 * Convenience `valueOf()` to allow comparing ObjectIds using double equals re: gh-7299
 */

if (!ObjectId.prototype.hasOwnProperty('valueOf')) {
  ObjectId.prototype.valueOf = function objectIdValueOf() {
    return this.toString();
  };
}

ObjectId.prototype[objectIdSymbol] = true;
module.exports = ObjectId;

/***/ }),

/***/ 2591:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Document = __webpack_require__(8727);

var immediate = __webpack_require__(1490);

var internalToObjectOptions = (__webpack_require__(4962)/* .internalToObjectOptions */ .h);

var promiseOrCallback = __webpack_require__(8486);

var util = __webpack_require__(161);

var utils = __webpack_require__(6872);

module.exports = Subdocument;
/**
 * Subdocument constructor.
 *
 * @inherits Document
 * @api private
 */

function Subdocument(value, fields, parent, skipId, options) {
  if (parent != null) {
    // If setting a nested path, should copy isNew from parent re: gh-7048
    var parentOptions = {
      isNew: parent.isNew
    };

    if ('defaults' in parent.$__) {
      parentOptions.defaults = parent.$__.defaults;
    }

    options = Object.assign(parentOptions, options);
  }

  if (options != null && options.path != null) {
    this.$basePath = options.path;
  }

  Document.call(this, value, fields, skipId, options);
  delete this.$__.priorDoc;
}

Subdocument.prototype = Object.create(Document.prototype);
Object.defineProperty(Subdocument.prototype, '$isSubdocument', {
  configurable: false,
  writable: false,
  value: true
});
Object.defineProperty(Subdocument.prototype, '$isSingleNested', {
  configurable: false,
  writable: false,
  value: true
});
/*!
 * ignore
 */

Subdocument.prototype.toBSON = function () {
  return this.toObject(internalToObjectOptions);
};
/**
 * Used as a stub for middleware
 *
 * #### Note:
 *
 * _This is a no-op. Does not actually save the doc to the db._
 *
 * @param {Function} [fn]
 * @return {Promise} resolved Promise
 * @api private
 */


Subdocument.prototype.save = function (options, fn) {
  var _this = this;

  if (typeof options === 'function') {
    fn = options;
    options = {};
  }

  options = options || {};

  if (!options.suppressWarning) {
    utils.warn('mongoose: calling `save()` on a subdoc does **not** save ' + 'the document to MongoDB, it only runs save middleware. ' + 'Use `subdoc.save({ suppressWarning: true })` to hide this warning ' + 'if you\'re sure this behavior is right for your app.');
  }

  return promiseOrCallback(fn, function (cb) {
    _this.$__save(cb);
  });
};
/*!
 * Given a path relative to this document, return the path relative
 * to the top-level document.
 */


Subdocument.prototype.$__fullPath = function (path) {
  if (!this.$__.fullPath) {
    this.ownerDocument();
  }

  return path ? this.$__.fullPath + '.' + path : this.$__.fullPath;
};
/*!
 * Given a path relative to this document, return the path relative
 * to the top-level document.
 */


Subdocument.prototype.$__pathRelativeToParent = function (p) {
  if (p == null) {
    return this.$basePath;
  }

  return [this.$basePath, p].join('.');
};
/**
 * Used as a stub for middleware
 *
 * #### Note:
 *
 * _This is a no-op. Does not actually save the doc to the db._
 *
 * @param {Function} [fn]
 * @method $__save
 * @api private
 */


Subdocument.prototype.$__save = function (fn) {
  var _this2 = this;

  return immediate(function () {
    return fn(null, _this2);
  });
};
/*!
 * ignore
 */


Subdocument.prototype.$isValid = function (path) {
  var parent = this.$parent();
  var fullPath = this.$__pathRelativeToParent(path);

  if (parent != null && fullPath != null) {
    return parent.$isValid(fullPath);
  }

  return Document.prototype.$isValid.call(this, path);
};
/*!
 * ignore
 */


Subdocument.prototype.markModified = function (path) {
  Document.prototype.markModified.call(this, path);
  var parent = this.$parent();
  var fullPath = this.$__pathRelativeToParent(path);

  if (parent == null || fullPath == null) {
    return;
  }

  var myPath = this.$__pathRelativeToParent().replace(/\.$/, '');

  if (parent.isDirectModified(myPath) || this.isNew) {
    return;
  }

  this.$__parent.markModified(fullPath, this);
};
/*!
 * ignore
 */


Subdocument.prototype.isModified = function (paths, modifiedPaths) {
  var _this3 = this;

  var parent = this.$parent();

  if (parent != null) {
    if (Array.isArray(paths) || typeof paths === 'string') {
      paths = Array.isArray(paths) ? paths : paths.split(' ');
      paths = paths.map(function (p) {
        return _this3.$__pathRelativeToParent(p);
      }).filter(function (p) {
        return p != null;
      });
    } else if (!paths) {
      paths = this.$__pathRelativeToParent();
    }

    return parent.$isModified(paths, modifiedPaths);
  }

  return Document.prototype.isModified.call(this, paths, modifiedPaths);
};
/**
 * Marks a path as valid, removing existing validation errors.
 *
 * @param {String} path the field to mark as valid
 * @api private
 * @method $markValid
 * @receiver Subdocument
 */


Subdocument.prototype.$markValid = function (path) {
  Document.prototype.$markValid.call(this, path);
  var parent = this.$parent();
  var fullPath = this.$__pathRelativeToParent(path);

  if (parent != null && fullPath != null) {
    parent.$markValid(fullPath);
  }
};
/*!
 * ignore
 */


Subdocument.prototype.invalidate = function (path, err, val) {
  Document.prototype.invalidate.call(this, path, err, val);
  var parent = this.$parent();
  var fullPath = this.$__pathRelativeToParent(path);

  if (parent != null && fullPath != null) {
    parent.invalidate(fullPath, err, val);
  } else if (err.kind === 'cast' || err.name === 'CastError' || fullPath == null) {
    throw err;
  }

  return this.ownerDocument().$__.validationError;
};
/*!
 * ignore
 */


Subdocument.prototype.$ignore = function (path) {
  Document.prototype.$ignore.call(this, path);
  var parent = this.$parent();
  var fullPath = this.$__pathRelativeToParent(path);

  if (parent != null && fullPath != null) {
    parent.$ignore(fullPath);
  }
};
/**
 * Returns the top level document of this sub-document.
 *
 * @return {Document}
 */


Subdocument.prototype.ownerDocument = function () {
  if (this.$__.ownerDocument) {
    return this.$__.ownerDocument;
  }

  var parent = this; // eslint-disable-line consistent-this

  var paths = [];
  var seenDocs = new Set([parent]);

  while (true) {
    if (typeof parent.$__pathRelativeToParent !== 'function') {
      break;
    }

    paths.unshift(parent.$__pathRelativeToParent(void 0, true));

    var _parent = parent.$parent();

    if (_parent == null) {
      break;
    }

    parent = _parent;

    if (seenDocs.has(parent)) {
      throw new Error('Infinite subdocument loop: subdoc with _id ' + parent._id + ' is a parent of itself');
    }

    seenDocs.add(parent);
  }

  this.$__.fullPath = paths.join('.');
  this.$__.ownerDocument = parent;
  return this.$__.ownerDocument;
};
/*!
 * ignore
 */


Subdocument.prototype.$__fullPathWithIndexes = function () {
  var parent = this; // eslint-disable-line consistent-this

  var paths = [];
  var seenDocs = new Set([parent]);

  while (true) {
    if (typeof parent.$__pathRelativeToParent !== 'function') {
      break;
    }

    paths.unshift(parent.$__pathRelativeToParent(void 0, false));

    var _parent = parent.$parent();

    if (_parent == null) {
      break;
    }

    parent = _parent;

    if (seenDocs.has(parent)) {
      throw new Error('Infinite subdocument loop: subdoc with _id ' + parent._id + ' is a parent of itself');
    }

    seenDocs.add(parent);
  }

  return paths.join('.');
};
/**
 * Returns this sub-documents parent document.
 *
 * @api public
 */


Subdocument.prototype.parent = function () {
  return this.$__parent;
};
/**
 * Returns this sub-documents parent document.
 *
 * @api public
 * @method $parent
 */


Subdocument.prototype.$parent = Subdocument.prototype.parent;
/*!
 * no-op for hooks
 */

Subdocument.prototype.$__remove = function (cb) {
  if (cb == null) {
    return;
  }

  return cb(null, this);
};

Subdocument.prototype.$__removeFromParent = function () {
  this.$__parent.set(this.$basePath, null);
};
/**
 * Null-out this subdoc
 *
 * @param {Object} [options]
 * @param {Function} [callback] optional callback for compatibility with Document.prototype.remove
 */


Subdocument.prototype.remove = function (options, callback) {
  if (typeof options === 'function') {
    callback = options;
    options = null;
  }

  registerRemoveListener(this); // If removing entire doc, no need to remove subdoc

  if (!options || !options.noop) {
    this.$__removeFromParent();
  }

  return this.$__remove(callback);
};
/*!
 * ignore
 */


Subdocument.prototype.populate = function () {
  throw new Error('Mongoose does not support calling populate() on nested ' + 'docs. Instead of `doc.nested.populate("path")`, use ' + '`doc.populate("nested.path")`');
};
/**
 * Helper for console.log
 *
 * @api public
 */


Subdocument.prototype.inspect = function () {
  return this.toObject({
    transform: false,
    virtuals: false,
    flattenDecimals: false
  });
};

if (util.inspect.custom) {
  /*!
  * Avoid Node deprecation warning DEP0079
  */
  Subdocument.prototype[util.inspect.custom] = Subdocument.prototype.inspect;
}
/*!
 * Registers remove event listeners for triggering
 * on subdocuments.
 *
 * @param {Subdocument} sub
 * @api private
 */


function registerRemoveListener(sub) {
  var owner = sub.ownerDocument();

  function emitRemove() {
    owner.$removeListener('save', emitRemove);
    owner.$removeListener('remove', emitRemove);
    sub.emit('remove', sub);
    sub.constructor.emit('remove', sub);
    owner = sub = null;
  }

  owner.$on('save', emitRemove);
  owner.$on('remove', emitRemove);
}

/***/ }),

/***/ 6872:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(365)["Buffer"];

/*!
 * Module dependencies.
 */

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var ms = __webpack_require__(2068);

var mpath = __webpack_require__(3564);

var ObjectId = __webpack_require__(6079);

var PopulateOptions = __webpack_require__(4034);

var clone = __webpack_require__(1973);

var immediate = __webpack_require__(1490);

var isObject = __webpack_require__(5721);

var isMongooseArray = __webpack_require__(7339);

var isMongooseDocumentArray = __webpack_require__(1255);

var isBsonType = __webpack_require__(1563);

var getFunctionName = __webpack_require__(6749);

var isMongooseObject = __webpack_require__(6584);

var promiseOrCallback = __webpack_require__(8486);

var schemaMerge = __webpack_require__(4913);

var specialProperties = __webpack_require__(2862);

var _require = __webpack_require__(3636),
    trustedSymbol = _require.trustedSymbol;

var Document;
exports.specialProperties = specialProperties;
exports.isMongooseArray = isMongooseArray.isMongooseArray;
exports.isMongooseDocumentArray = isMongooseDocumentArray.isMongooseDocumentArray;
exports.registerMongooseArray = isMongooseArray.registerMongooseArray;
exports.registerMongooseDocumentArray = isMongooseDocumentArray.registerMongooseDocumentArray;
/*!
 * Produces a collection name from model `name`. By default, just returns
 * the model name
 *
 * @param {String} name a model name
 * @param {Function} pluralize function that pluralizes the collection name
 * @return {String} a collection name
 * @api private
 */

exports.toCollectionName = function (name, pluralize) {
  if (name === 'system.profile') {
    return name;
  }

  if (name === 'system.indexes') {
    return name;
  }

  if (typeof pluralize === 'function') {
    return pluralize(name);
  }

  return name;
};
/*!
 * Determines if `a` and `b` are deep equal.
 *
 * Modified from node/lib/assert.js
 *
 * @param {any} a a value to compare to `b`
 * @param {any} b a value to compare to `a`
 * @return {Boolean}
 * @api private
 */


exports.deepEqual = function deepEqual(a, b) {
  if (a === b) {
    return true;
  }

  if (_typeof(a) !== 'object' || _typeof(b) !== 'object') {
    return a === b;
  }

  if (a instanceof Date && b instanceof Date) {
    return a.getTime() === b.getTime();
  }

  if (isBsonType(a, 'ObjectID') && isBsonType(b, 'ObjectID') || isBsonType(a, 'Decimal128') && isBsonType(b, 'Decimal128')) {
    return a.toString() === b.toString();
  }

  if (a instanceof RegExp && b instanceof RegExp) {
    return a.source === b.source && a.ignoreCase === b.ignoreCase && a.multiline === b.multiline && a.global === b.global && a.dotAll === b.dotAll && a.unicode === b.unicode && a.sticky === b.sticky && a.hasIndices === b.hasIndices;
  }

  if (a == null || b == null) {
    return false;
  }

  if (a.prototype !== b.prototype) {
    return false;
  }

  if (a instanceof Map || b instanceof Map) {
    if (!(a instanceof Map) || !(b instanceof Map)) {
      return false;
    }

    return deepEqual(Array.from(a.keys()), Array.from(b.keys())) && deepEqual(Array.from(a.values()), Array.from(b.values()));
  } // Handle MongooseNumbers


  if (a instanceof Number && b instanceof Number) {
    return a.valueOf() === b.valueOf();
  }

  if (Buffer.isBuffer(a)) {
    return exports.buffer.areEqual(a, b);
  }

  if (Array.isArray(a) || Array.isArray(b)) {
    if (!Array.isArray(a) || !Array.isArray(b)) {
      return false;
    }

    var len = a.length;

    if (len !== b.length) {
      return false;
    }

    for (var i = 0; i < len; ++i) {
      if (!deepEqual(a[i], b[i])) {
        return false;
      }
    }

    return true;
  }

  if (a.$__ != null) {
    a = a._doc;
  } else if (isMongooseObject(a)) {
    a = a.toObject();
  }

  if (b.$__ != null) {
    b = b._doc;
  } else if (isMongooseObject(b)) {
    b = b.toObject();
  }

  var ka = Object.keys(a);
  var kb = Object.keys(b);
  var kaLength = ka.length; // having the same number of owned properties (keys incorporates
  // hasOwnProperty)

  if (kaLength !== kb.length) {
    return false;
  } // ~~~cheap key test


  for (var _i = kaLength - 1; _i >= 0; _i--) {
    if (ka[_i] !== kb[_i]) {
      return false;
    }
  } // equivalent values for every corresponding key, and
  // ~~~possibly expensive deep test


  for (var _i2 = 0, _ka = ka; _i2 < _ka.length; _i2++) {
    var key = _ka[_i2];

    if (!deepEqual(a[key], b[key])) {
      return false;
    }
  }

  return true;
};
/*!
 * Get the last element of an array
 */


exports.last = function (arr) {
  if (arr.length > 0) {
    return arr[arr.length - 1];
  }

  return void 0;
};

exports.clone = clone;
/*!
 * ignore
 */

exports.promiseOrCallback = promiseOrCallback;
/*!
 * ignore
 */

exports.cloneArrays = function cloneArrays(arr) {
  if (!Array.isArray(arr)) {
    return arr;
  }

  return arr.map(function (el) {
    return exports.cloneArrays(el);
  });
};
/*!
 * ignore
 */


exports.omit = function omit(obj, keys) {
  if (keys == null) {
    return Object.assign({}, obj);
  }

  if (!Array.isArray(keys)) {
    keys = [keys];
  }

  var ret = Object.assign({}, obj);

  var _iterator = _createForOfIteratorHelper(keys),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var key = _step.value;
      delete ret[key];
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return ret;
};
/*!
 * Shallow copies defaults into options.
 *
 * @param {Object} defaults
 * @param {Object} options
 * @return {Object} the merged object
 * @api private
 */


exports.options = function (defaults, options) {
  var keys = Object.keys(defaults);
  var i = keys.length;
  var k;
  options = options || {};

  while (i--) {
    k = keys[i];

    if (!(k in options)) {
      options[k] = defaults[k];
    }
  }

  return options;
};
/*!
 * Merges `from` into `to` without overwriting existing properties.
 *
 * @param {Object} to
 * @param {Object} from
 * @api private
 */


exports.merge = function merge(to, from, options, path) {
  options = options || {};
  var keys = Object.keys(from);
  var i = 0;
  var len = keys.length;
  var key;

  if (from[trustedSymbol]) {
    to[trustedSymbol] = from[trustedSymbol];
  }

  path = path || '';
  var omitNested = options.omitNested || {};

  while (i < len) {
    key = keys[i++];

    if (options.omit && options.omit[key]) {
      continue;
    }

    if (omitNested[path]) {
      continue;
    }

    if (specialProperties.has(key)) {
      continue;
    }

    if (to[key] == null) {
      to[key] = from[key];
    } else if (exports.isObject(from[key])) {
      if (!exports.isObject(to[key])) {
        to[key] = {};
      }

      if (from[key] != null) {
        // Skip merging schemas if we're creating a discriminator schema and
        // base schema has a given path as a single nested but discriminator schema
        // has the path as a document array, or vice versa (gh-9534)
        if (options.isDiscriminatorSchemaMerge && from[key].$isSingleNested && to[key].$isMongooseDocumentArray || from[key].$isMongooseDocumentArray && to[key].$isSingleNested) {
          continue;
        } else if (from[key].instanceOfSchema) {
          if (to[key].instanceOfSchema) {
            schemaMerge(to[key], from[key].clone(), options.isDiscriminatorSchemaMerge);
          } else {
            to[key] = from[key].clone();
          }

          continue;
        } else if (isBsonType(from[key], 'ObjectID')) {
          to[key] = new ObjectId(from[key]);
          continue;
        }
      }

      merge(to[key], from[key], options, path ? path + '.' + key : key);
    } else if (options.overwrite) {
      to[key] = from[key];
    }
  }
};
/*!
 * Applies toObject recursively.
 *
 * @param {Document|Array|Object} obj
 * @return {Object}
 * @api private
 */


exports.toObject = function toObject(obj) {
  Document || (Document = __webpack_require__(8727));
  var ret;

  if (obj == null) {
    return obj;
  }

  if (obj instanceof Document) {
    return obj.toObject();
  }

  if (Array.isArray(obj)) {
    ret = [];

    var _iterator2 = _createForOfIteratorHelper(obj),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var doc = _step2.value;
        ret.push(toObject(doc));
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    return ret;
  }

  if (exports.isPOJO(obj)) {
    ret = {};

    if (obj[trustedSymbol]) {
      ret[trustedSymbol] = obj[trustedSymbol];
    }

    for (var _i3 = 0, _Object$keys = Object.keys(obj); _i3 < _Object$keys.length; _i3++) {
      var k = _Object$keys[_i3];

      if (specialProperties.has(k)) {
        continue;
      }

      ret[k] = toObject(obj[k]);
    }

    return ret;
  }

  return obj;
};

exports.isObject = isObject;
/*!
 * Determines if `arg` is a plain old JavaScript object (POJO). Specifically,
 * `arg` must be an object but not an instance of any special class, like String,
 * ObjectId, etc.
 *
 * `Object.getPrototypeOf()` is part of ES5: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/getPrototypeOf
 *
 * @param {Object|Array|String|Function|RegExp|any} arg
 * @api private
 * @return {Boolean}
 */

exports.isPOJO = function isPOJO(arg) {
  if (arg == null || _typeof(arg) !== 'object') {
    return false;
  }

  var proto = Object.getPrototypeOf(arg); // Prototype may be null if you used `Object.create(null)`
  // Checking `proto`'s constructor is safe because `getPrototypeOf()`
  // explicitly crosses the boundary from object data to object metadata

  return !proto || proto.constructor.name === 'Object';
};
/*!
 * Determines if `arg` is an object that isn't an instance of a built-in value
 * class, like Array, Buffer, ObjectId, etc.
 */


exports.isNonBuiltinObject = function isNonBuiltinObject(val) {
  return _typeof(val) === 'object' && !exports.isNativeObject(val) && !exports.isMongooseType(val) && val != null;
};
/*!
 * Determines if `obj` is a built-in object like an array, date, boolean,
 * etc.
 */


exports.isNativeObject = function (arg) {
  return Array.isArray(arg) || arg instanceof Date || arg instanceof Boolean || arg instanceof Number || arg instanceof String;
};
/*!
 * Determines if `val` is an object that has no own keys
 */


exports.isEmptyObject = function (val) {
  return val != null && _typeof(val) === 'object' && Object.keys(val).length === 0;
};
/*!
 * Search if `obj` or any POJOs nested underneath `obj` has a property named
 * `key`
 */


exports.hasKey = function hasKey(obj, key) {
  var props = Object.keys(obj);

  for (var _i4 = 0, _props = props; _i4 < _props.length; _i4++) {
    var prop = _props[_i4];

    if (prop === key) {
      return true;
    }

    if (exports.isPOJO(obj[prop]) && exports.hasKey(obj[prop], key)) {
      return true;
    }
  }

  return false;
};
/*!
 * process.nextTick helper.
 *
 * Wraps `callback` in a try/catch + nextTick.
 *
 * node-mongodb-native has a habit of state corruption when an error is immediately thrown from within a collection callback.
 *
 * @param {Function} callback
 * @api private
 */


exports.tick = function tick(callback) {
  if (typeof callback !== 'function') {
    return;
  }

  return function () {
    try {
      callback.apply(this, arguments);
    } catch (err) {
      // only nextTick on err to get out of
      // the event loop and avoid state corruption.
      immediate(function () {
        throw err;
      });
    }
  };
};
/*!
 * Returns true if `v` is an object that can be serialized as a primitive in
 * MongoDB
 */


exports.isMongooseType = function (v) {
  return isBsonType(v, 'ObjectID') || isBsonType(v, 'Decimal128') || v instanceof Buffer;
};

exports.isMongooseObject = isMongooseObject;
/*!
 * Converts `expires` options of index objects to `expiresAfterSeconds` options for MongoDB.
 *
 * @param {Object} object
 * @api private
 */

exports.expires = function expires(object) {
  if (!(object && object.constructor.name === 'Object')) {
    return;
  }

  if (!('expires' in object)) {
    return;
  }

  object.expireAfterSeconds = typeof object.expires !== 'string' ? object.expires : Math.round(ms(object.expires) / 1000);
  delete object.expires;
};
/*!
 * populate helper
 */


exports.populate = function populate(path, select, model, match, options, subPopulate, justOne, count) {
  // might have passed an object specifying all arguments
  var obj = null;

  if (arguments.length === 1) {
    if (path instanceof PopulateOptions) {
      // If reusing old populate docs, avoid reusing `_docs` because that may
      // lead to bugs and memory leaks. See gh-11641
      path._docs = [];
      path._childDocs = [];
      return [path];
    }

    if (Array.isArray(path)) {
      var singles = makeSingles(path);
      return singles.map(function (o) {
        return exports.populate(o)[0];
      });
    }

    if (exports.isObject(path)) {
      obj = Object.assign({}, path);
    } else {
      obj = {
        path: path
      };
    }
  } else if (_typeof(model) === 'object') {
    obj = {
      path: path,
      select: select,
      match: model,
      options: match
    };
  } else {
    obj = {
      path: path,
      select: select,
      model: model,
      match: match,
      options: options,
      populate: subPopulate,
      justOne: justOne,
      count: count
    };
  }

  if (typeof obj.path !== 'string') {
    throw new TypeError('utils.populate: invalid path. Expected string. Got typeof `' + _typeof(path) + '`');
  }

  return _populateObj(obj); // The order of select/conditions args is opposite Model.find but
  // necessary to keep backward compatibility (select could be
  // an array, string, or object literal).

  function makeSingles(arr) {
    var ret = [];
    arr.forEach(function (obj) {
      if (/[\s]/.test(obj.path)) {
        var paths = obj.path.split(' ');
        paths.forEach(function (p) {
          var copy = Object.assign({}, obj);
          copy.path = p;
          ret.push(copy);
        });
      } else {
        ret.push(obj);
      }
    });
    return ret;
  }
};

function _populateObj(obj) {
  if (Array.isArray(obj.populate)) {
    var _ret = [];
    obj.populate.forEach(function (obj) {
      if (/[\s]/.test(obj.path)) {
        var copy = Object.assign({}, obj);

        var _paths = copy.path.split(' ');

        _paths.forEach(function (p) {
          copy.path = p;

          _ret.push(exports.populate(copy)[0]);
        });
      } else {
        _ret.push(exports.populate(obj)[0]);
      }
    });
    obj.populate = exports.populate(_ret);
  } else if (obj.populate != null && _typeof(obj.populate) === 'object') {
    obj.populate = exports.populate(obj.populate);
  }

  var ret = [];
  var paths = obj.path.split(' ');

  if (obj.options != null) {
    obj.options = exports.clone(obj.options);
  }

  var _iterator3 = _createForOfIteratorHelper(paths),
      _step3;

  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var path = _step3.value;
      ret.push(new PopulateOptions(Object.assign({}, obj, {
        path: path
      })));
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }

  return ret;
}
/*!
 * Return the value of `obj` at the given `path`.
 *
 * @param {String} path
 * @param {Object} obj
 */


exports.getValue = function (path, obj, map) {
  return mpath.get(path, obj, '_doc', map);
};
/*!
 * Sets the value of `obj` at the given `path`.
 *
 * @param {String} path
 * @param {Anything} val
 * @param {Object} obj
 */


exports.setValue = function (path, val, obj, map, _copying) {
  mpath.set(path, val, obj, '_doc', map, _copying);
};
/*!
 * Returns an array of values from object `o`.
 *
 * @param {Object} o
 * @return {Array}
 * @private
 */


exports.object = {};

exports.object.vals = function vals(o) {
  var keys = Object.keys(o);
  var i = keys.length;
  var ret = [];

  while (i--) {
    ret.push(o[keys[i]]);
  }

  return ret;
};
/*!
 * @see exports.options
 */


exports.object.shallowCopy = exports.options;
/*!
 * Safer helper for hasOwnProperty checks
 *
 * @param {Object} obj
 * @param {String} prop
 */

var hop = Object.prototype.hasOwnProperty;

exports.object.hasOwnProperty = function (obj, prop) {
  return hop.call(obj, prop);
};
/*!
 * Determine if `val` is null or undefined
 *
 * @return {Boolean}
 */


exports.isNullOrUndefined = function (val) {
  return val === null || val === undefined;
};
/*!
 * ignore
 */


exports.array = {};
/*!
 * Flattens an array.
 *
 * [ 1, [ 2, 3, [4] ]] -> [1,2,3,4]
 *
 * @param {Array} arr
 * @param {Function} [filter] If passed, will be invoked with each item in the array. If `filter` returns a falsy value, the item will not be included in the results.
 * @return {Array}
 * @private
 */

exports.array.flatten = function flatten(arr, filter, ret) {
  ret || (ret = []);
  arr.forEach(function (item) {
    if (Array.isArray(item)) {
      flatten(item, filter, ret);
    } else {
      if (!filter || filter(item)) {
        ret.push(item);
      }
    }
  });
  return ret;
};
/*!
 * ignore
 */


var _hasOwnProperty = Object.prototype.hasOwnProperty;

exports.hasUserDefinedProperty = function (obj, key) {
  if (obj == null) {
    return false;
  }

  if (Array.isArray(key)) {
    var _iterator4 = _createForOfIteratorHelper(key),
        _step4;

    try {
      for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
        var k = _step4.value;

        if (exports.hasUserDefinedProperty(obj, k)) {
          return true;
        }
      }
    } catch (err) {
      _iterator4.e(err);
    } finally {
      _iterator4.f();
    }

    return false;
  }

  if (_hasOwnProperty.call(obj, key)) {
    return true;
  }

  if (_typeof(obj) === 'object' && key in obj) {
    var v = obj[key];
    return v !== Object.prototype[key] && v !== Array.prototype[key];
  }

  return false;
};
/*!
 * ignore
 */


var MAX_ARRAY_INDEX = Math.pow(2, 32) - 1;

exports.isArrayIndex = function (val) {
  if (typeof val === 'number') {
    return val >= 0 && val <= MAX_ARRAY_INDEX;
  }

  if (typeof val === 'string') {
    if (!/^\d+$/.test(val)) {
      return false;
    }

    val = +val;
    return val >= 0 && val <= MAX_ARRAY_INDEX;
  }

  return false;
};
/*!
 * Removes duplicate values from an array
 *
 * [1, 2, 3, 3, 5] => [1, 2, 3, 5]
 * [ ObjectId("550988ba0c19d57f697dc45e"), ObjectId("550988ba0c19d57f697dc45e") ]
 *    => [ObjectId("550988ba0c19d57f697dc45e")]
 *
 * @param {Array} arr
 * @return {Array}
 * @private
 */


exports.array.unique = function (arr) {
  var primitives = new Set();
  var ids = new Set();
  var ret = [];

  var _iterator5 = _createForOfIteratorHelper(arr),
      _step5;

  try {
    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
      var item = _step5.value;

      if (typeof item === 'number' || typeof item === 'string' || item == null) {
        if (primitives.has(item)) {
          continue;
        }

        ret.push(item);
        primitives.add(item);
      } else if (isBsonType(item, 'ObjectID')) {
        if (ids.has(item.toString())) {
          continue;
        }

        ret.push(item);
        ids.add(item.toString());
      } else {
        ret.push(item);
      }
    }
  } catch (err) {
    _iterator5.e(err);
  } finally {
    _iterator5.f();
  }

  return ret;
};
/*!
 * Determines if two buffers are equal.
 *
 * @param {Buffer} a
 * @param {Object} b
 */


exports.buffer = {};

exports.buffer.areEqual = function (a, b) {
  if (!Buffer.isBuffer(a)) {
    return false;
  }

  if (!Buffer.isBuffer(b)) {
    return false;
  }

  if (a.length !== b.length) {
    return false;
  }

  for (var i = 0, len = a.length; i < len; ++i) {
    if (a[i] !== b[i]) {
      return false;
    }
  }

  return true;
};

exports.getFunctionName = getFunctionName;
/*!
 * Decorate buffers
 */

exports.decorate = function (destination, source) {
  for (var key in source) {
    if (specialProperties.has(key)) {
      continue;
    }

    destination[key] = source[key];
  }
};
/**
 * merges to with a copy of from
 *
 * @param {Object} to
 * @param {Object} fromObj
 * @api private
 */


exports.mergeClone = function (to, fromObj) {
  if (isMongooseObject(fromObj)) {
    fromObj = fromObj.toObject({
      transform: false,
      virtuals: false,
      depopulate: true,
      getters: false,
      flattenDecimals: false
    });
  }

  var keys = Object.keys(fromObj);
  var len = keys.length;
  var i = 0;
  var key;

  while (i < len) {
    key = keys[i++];

    if (specialProperties.has(key)) {
      continue;
    }

    if (typeof to[key] === 'undefined') {
      to[key] = exports.clone(fromObj[key], {
        transform: false,
        virtuals: false,
        depopulate: true,
        getters: false,
        flattenDecimals: false
      });
    } else {
      var val = fromObj[key];

      if (val != null && val.valueOf && !(val instanceof Date)) {
        val = val.valueOf();
      }

      if (exports.isObject(val)) {
        var obj = val;

        if (isMongooseObject(val) && !val.isMongooseBuffer) {
          obj = obj.toObject({
            transform: false,
            virtuals: false,
            depopulate: true,
            getters: false,
            flattenDecimals: false
          });
        }

        if (val.isMongooseBuffer) {
          obj = Buffer.from(obj);
        }

        exports.mergeClone(to[key], obj);
      } else {
        to[key] = exports.clone(val, {
          flattenDecimals: false
        });
      }
    }
  }
};
/**
 * Executes a function on each element of an array (like _.each)
 *
 * @param {Array} arr
 * @param {Function} fn
 * @api private
 */


exports.each = function (arr, fn) {
  var _iterator6 = _createForOfIteratorHelper(arr),
      _step6;

  try {
    for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
      var item = _step6.value;
      fn(item);
    }
  } catch (err) {
    _iterator6.e(err);
  } finally {
    _iterator6.f();
  }
};
/*!
 * ignore
 */


exports.getOption = function (name) {
  var sources = Array.prototype.slice.call(arguments, 1);

  var _iterator7 = _createForOfIteratorHelper(sources),
      _step7;

  try {
    for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
      var source = _step7.value;

      if (source == null) {
        continue;
      }

      if (source[name] != null) {
        return source[name];
      }
    }
  } catch (err) {
    _iterator7.e(err);
  } finally {
    _iterator7.f();
  }

  return null;
};
/*!
 * ignore
 */


exports.noop = function () {};

exports.errorToPOJO = function errorToPOJO(error) {
  var isError = error instanceof Error;

  if (!isError) {
    throw new Error('`error` must be `instanceof Error`.');
  }

  var ret = {};

  var _iterator8 = _createForOfIteratorHelper(Object.getOwnPropertyNames(error)),
      _step8;

  try {
    for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
      var properyName = _step8.value;
      ret[properyName] = error[properyName];
    }
  } catch (err) {
    _iterator8.e(err);
  } finally {
    _iterator8.f();
  }

  return ret;
};
/*!
 * ignore
 */


exports.warn = function warn(message) {
  return ({env:{}}).emitWarning(message, {
    code: 'MONGOOSE'
  });
};

/***/ }),

/***/ 459:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var utils = __webpack_require__(6872);
/**
 * VirtualType constructor
 *
 * This is what mongoose uses to define virtual attributes via `Schema.prototype.virtual`.
 *
 * #### Example:
 *
 *     const fullname = schema.virtual('fullname');
 *     fullname instanceof mongoose.VirtualType // true
 *
 * @param {Object} options
 * @param {string|function} [options.ref] if `ref` is not nullish, this becomes a [populated virtual](/docs/populate.html#populate-virtuals)
 * @param {string|function} [options.localField] the local field to populate on if this is a populated virtual.
 * @param {string|function} [options.foreignField] the foreign field to populate on if this is a populated virtual.
 * @param {boolean} [options.justOne=false] by default, a populated virtual is an array. If you set `justOne`, the populated virtual will be a single doc or `null`.
 * @param {boolean} [options.getters=false] if you set this to `true`, Mongoose will call any custom getters you defined on this virtual
 * @param {boolean} [options.count=false] if you set this to `true`, `populate()` will set this virtual to the number of populated documents, as opposed to the documents themselves, using [`Query#countDocuments()`](./api.html#query_Query-countDocuments)
 * @param {Object|Function} [options.match=null] add an extra match condition to `populate()`
 * @param {Number} [options.limit=null] add a default `limit` to the `populate()` query
 * @param {Number} [options.skip=null] add a default `skip` to the `populate()` query
 * @param {Number} [options.perDocumentLimit=null] For legacy reasons, `limit` with `populate()` may give incorrect results because it only executes a single query for every document being populated. If you set `perDocumentLimit`, Mongoose will ensure correct `limit` per document by executing a separate query for each document to `populate()`. For example, `.find().populate({ path: 'test', perDocumentLimit: 2 })` will execute 2 additional queries if `.find()` returns 2 documents.
 * @param {Object} [options.options=null] Additional options like `limit` and `lean`.
 * @param {string} name
 * @api public
 */


function VirtualType(options, name) {
  this.path = name;
  this.getters = [];
  this.setters = [];
  this.options = Object.assign({}, options);
}
/**
 * If no getters/getters, add a default
 *
 * @param {Function} fn
 * @return {VirtualType} this
 * @api private
 */


VirtualType.prototype._applyDefaultGetters = function () {
  if (this.getters.length > 0 || this.setters.length > 0) {
    return;
  }

  var path = this.path;
  var internalProperty = '$' + path;
  this.getters.push(function () {
    return this[internalProperty];
  });
  this.setters.push(function (v) {
    this[internalProperty] = v;
  });
};
/*!
 * ignore
 */


VirtualType.prototype.clone = function () {
  var clone = new VirtualType(this.options, this.path);
  clone.getters = [].concat(this.getters);
  clone.setters = [].concat(this.setters);
  return clone;
};
/**
 * Adds a custom getter to this virtual.
 *
 * Mongoose calls the getter function with the below 3 parameters.
 *
 * - `value`: the value returned by the previous getter. If there is only one getter, `value` will be `undefined`.
 * - `virtual`: the virtual object you called `.get()` on
 * - `doc`: the document this virtual is attached to. Equivalent to `this`.
 *
 * #### Example:
 *
 *     const virtual = schema.virtual('fullname');
 *     virtual.get(function(value, virtual, doc) {
 *       return this.name.first + ' ' + this.name.last;
 *     });
 *
 * @param {Function(Any, VirtualType, Document)} fn
 * @return {VirtualType} this
 * @api public
 */


VirtualType.prototype.get = function (fn) {
  this.getters.push(fn);
  return this;
};
/**
 * Adds a custom setter to this virtual.
 *
 * Mongoose calls the setter function with the below 3 parameters.
 *
 * - `value`: the value being set
 * - `virtual`: the virtual object you're calling `.set()` on
 * - `doc`: the document this virtual is attached to. Equivalent to `this`.
 *
 * #### Example:
 *
 *     const virtual = schema.virtual('fullname');
 *     virtual.set(function(value, virtual, doc) {
 *       const parts = value.split(' ');
 *       this.name.first = parts[0];
 *       this.name.last = parts[1];
 *     });
 *
 *     const Model = mongoose.model('Test', schema);
 *     const doc = new Model();
 *     // Calls the setter with `value = 'Jean-Luc Picard'`
 *     doc.fullname = 'Jean-Luc Picard';
 *     doc.name.first; // 'Jean-Luc'
 *     doc.name.last; // 'Picard'
 *
 * @param {Function(Any, VirtualType, Document)} fn
 * @return {VirtualType} this
 * @api public
 */


VirtualType.prototype.set = function (fn) {
  this.setters.push(fn);
  return this;
};
/**
 * Applies getters to `value`.
 *
 * @param {Object} value
 * @param {Document} doc The document this virtual is attached to
 * @return {any} the value after applying all getters
 * @api public
 */


VirtualType.prototype.applyGetters = function (value, doc) {
  if (utils.hasUserDefinedProperty(this.options, ['ref', 'refPath']) && doc.$$populatedVirtuals && doc.$$populatedVirtuals.hasOwnProperty(this.path)) {
    value = doc.$$populatedVirtuals[this.path];
  }

  var v = value;

  var _iterator = _createForOfIteratorHelper(this.getters),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var getter = _step.value;
      v = getter.call(doc, v, this, doc);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return v;
};
/**
 * Applies setters to `value`.
 *
 * @param {Object} value
 * @param {Document} doc
 * @return {any} the value after applying all setters
 * @api public
 */


VirtualType.prototype.applySetters = function (value, doc) {
  var v = value;

  var _iterator2 = _createForOfIteratorHelper(this.setters),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var setter = _step2.value;
      v = setter.call(doc, v, this, doc);
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  return v;
};
/*!
 * exports
 */


module.exports = VirtualType;

/***/ }),

/***/ 7406:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var asn1 = exports;
asn1.bignum = __webpack_require__(6781);
asn1.define = (__webpack_require__(8721).define);
asn1.base = __webpack_require__(6002);
asn1.constants = __webpack_require__(4319);
asn1.decoders = __webpack_require__(4049);
asn1.encoders = __webpack_require__(6860);

/***/ }),

/***/ 8721:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var encoders = __webpack_require__(6860);

var decoders = __webpack_require__(4049);

var inherits = __webpack_require__(376);

var api = exports;

api.define = function define(name, body) {
  return new Entity(name, body);
};

function Entity(name, body) {
  this.name = name;
  this.body = body;
  this.decoders = {};
  this.encoders = {};
}

Entity.prototype._createNamed = function createNamed(Base) {
  var name = this.name;

  function Generated(entity) {
    this._initNamed(entity, name);
  }

  inherits(Generated, Base);

  Generated.prototype._initNamed = function _initNamed(entity, name) {
    Base.call(this, entity, name);
  };

  return new Generated(this);
};

Entity.prototype._getDecoder = function _getDecoder(enc) {
  enc = enc || 'der'; // Lazily create decoder

  if (!this.decoders.hasOwnProperty(enc)) this.decoders[enc] = this._createNamed(decoders[enc]);
  return this.decoders[enc];
};

Entity.prototype.decode = function decode(data, enc, options) {
  return this._getDecoder(enc).decode(data, options);
};

Entity.prototype._getEncoder = function _getEncoder(enc) {
  enc = enc || 'der'; // Lazily create encoder

  if (!this.encoders.hasOwnProperty(enc)) this.encoders[enc] = this._createNamed(encoders[enc]);
  return this.encoders[enc];
};

Entity.prototype.encode = function encode(data, enc,
/* internal */
reporter) {
  return this._getEncoder(enc).encode(data, reporter);
};

/***/ }),

/***/ 4989:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var inherits = __webpack_require__(376);

var Reporter = (__webpack_require__(1269)/* .Reporter */ .b);

var Buffer = (__webpack_require__(8723).Buffer);

function DecoderBuffer(base, options) {
  Reporter.call(this, options);

  if (!Buffer.isBuffer(base)) {
    this.error('Input not Buffer');
    return;
  }

  this.base = base;
  this.offset = 0;
  this.length = base.length;
}

inherits(DecoderBuffer, Reporter);
exports.C = DecoderBuffer;

DecoderBuffer.isDecoderBuffer = function isDecoderBuffer(data) {
  if (data instanceof DecoderBuffer) {
    return true;
  } // Or accept compatible API


  var isCompatible = _typeof(data) === 'object' && Buffer.isBuffer(data.base) && data.constructor.name === 'DecoderBuffer' && typeof data.offset === 'number' && typeof data.length === 'number' && typeof data.save === 'function' && typeof data.restore === 'function' && typeof data.isEmpty === 'function' && typeof data.readUInt8 === 'function' && typeof data.skip === 'function' && typeof data.raw === 'function';
  return isCompatible;
};

DecoderBuffer.prototype.save = function save() {
  return {
    offset: this.offset,
    reporter: Reporter.prototype.save.call(this)
  };
};

DecoderBuffer.prototype.restore = function restore(save) {
  // Return skipped data
  var res = new DecoderBuffer(this.base);
  res.offset = save.offset;
  res.length = this.offset;
  this.offset = save.offset;
  Reporter.prototype.restore.call(this, save.reporter);
  return res;
};

DecoderBuffer.prototype.isEmpty = function isEmpty() {
  return this.offset === this.length;
};

DecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {
  if (this.offset + 1 <= this.length) return this.base.readUInt8(this.offset++, true);else return this.error(fail || 'DecoderBuffer overrun');
};

DecoderBuffer.prototype.skip = function skip(bytes, fail) {
  if (!(this.offset + bytes <= this.length)) return this.error(fail || 'DecoderBuffer overrun');
  var res = new DecoderBuffer(this.base); // Share reporter state

  res._reporterState = this._reporterState;
  res.offset = this.offset;
  res.length = this.offset + bytes;
  this.offset += bytes;
  return res;
};

DecoderBuffer.prototype.raw = function raw(save) {
  return this.base.slice(save ? save.offset : this.offset, this.length);
};

function EncoderBuffer(value, reporter) {
  if (Array.isArray(value)) {
    this.length = 0;
    this.value = value.map(function (item) {
      if (!EncoderBuffer.isEncoderBuffer(item)) item = new EncoderBuffer(item, reporter);
      this.length += item.length;
      return item;
    }, this);
  } else if (typeof value === 'number') {
    if (!(0 <= value && value <= 0xff)) return reporter.error('non-byte EncoderBuffer value');
    this.value = value;
    this.length = 1;
  } else if (typeof value === 'string') {
    this.value = value;
    this.length = Buffer.byteLength(value);
  } else if (Buffer.isBuffer(value)) {
    this.value = value;
    this.length = value.length;
  } else {
    return reporter.error('Unsupported type: ' + _typeof(value));
  }
}

exports.R = EncoderBuffer;

EncoderBuffer.isEncoderBuffer = function isEncoderBuffer(data) {
  if (data instanceof EncoderBuffer) {
    return true;
  } // Or accept compatible API


  var isCompatible = _typeof(data) === 'object' && data.constructor.name === 'EncoderBuffer' && typeof data.length === 'number' && typeof data.join === 'function';
  return isCompatible;
};

EncoderBuffer.prototype.join = function join(out, offset) {
  if (!out) out = Buffer.alloc(this.length);
  if (!offset) offset = 0;
  if (this.length === 0) return out;

  if (Array.isArray(this.value)) {
    this.value.forEach(function (item) {
      item.join(out, offset);
      offset += item.length;
    });
  } else {
    if (typeof this.value === 'number') out[offset] = this.value;else if (typeof this.value === 'string') out.write(this.value, offset);else if (Buffer.isBuffer(this.value)) this.value.copy(out, offset);
    offset += this.length;
  }

  return out;
};

/***/ }),

/***/ 6002:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var base = exports;
base.Reporter = (__webpack_require__(1269)/* .Reporter */ .b);
base.DecoderBuffer = (__webpack_require__(4989)/* .DecoderBuffer */ .C);
base.EncoderBuffer = (__webpack_require__(4989)/* .EncoderBuffer */ .R);
base.Node = __webpack_require__(3304);

/***/ }),

/***/ 3304:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var Reporter = (__webpack_require__(1269)/* .Reporter */ .b);

var EncoderBuffer = (__webpack_require__(4989)/* .EncoderBuffer */ .R);

var DecoderBuffer = (__webpack_require__(4989)/* .DecoderBuffer */ .C);

var assert = __webpack_require__(1130); // Supported tags


var tags = ['seq', 'seqof', 'set', 'setof', 'objid', 'bool', 'gentime', 'utctime', 'null_', 'enum', 'int', 'objDesc', 'bitstr', 'bmpstr', 'charstr', 'genstr', 'graphstr', 'ia5str', 'iso646str', 'numstr', 'octstr', 'printstr', 't61str', 'unistr', 'utf8str', 'videostr']; // Public methods list

var methods = ['key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice', 'any', 'contains'].concat(tags); // Overrided methods list

var overrided = ['_peekTag', '_decodeTag', '_use', '_decodeStr', '_decodeObjid', '_decodeTime', '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList', '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime', '_encodeNull', '_encodeInt', '_encodeBool'];

function Node(enc, parent, name) {
  var state = {};
  this._baseState = state;
  state.name = name;
  state.enc = enc;
  state.parent = parent || null;
  state.children = null; // State

  state.tag = null;
  state.args = null;
  state.reverseArgs = null;
  state.choice = null;
  state.optional = false;
  state.any = false;
  state.obj = false;
  state.use = null;
  state.useDecoder = null;
  state.key = null;
  state['default'] = null;
  state.explicit = null;
  state.implicit = null;
  state.contains = null; // Should create new instance on each method

  if (!state.parent) {
    state.children = [];

    this._wrap();
  }
}

module.exports = Node;
var stateProps = ['enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice', 'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit', 'implicit', 'contains'];

Node.prototype.clone = function clone() {
  var state = this._baseState;
  var cstate = {};
  stateProps.forEach(function (prop) {
    cstate[prop] = state[prop];
  });
  var res = new this.constructor(cstate.parent);
  res._baseState = cstate;
  return res;
};

Node.prototype._wrap = function wrap() {
  var state = this._baseState;
  methods.forEach(function (method) {
    this[method] = function _wrappedMethod() {
      var clone = new this.constructor(this);
      state.children.push(clone);
      return clone[method].apply(clone, arguments);
    };
  }, this);
};

Node.prototype._init = function init(body) {
  var state = this._baseState;
  assert(state.parent === null);
  body.call(this); // Filter children

  state.children = state.children.filter(function (child) {
    return child._baseState.parent === this;
  }, this);
  assert.equal(state.children.length, 1, 'Root node can have only one child');
};

Node.prototype._useArgs = function useArgs(args) {
  var state = this._baseState; // Filter children and args

  var children = args.filter(function (arg) {
    return arg instanceof this.constructor;
  }, this);
  args = args.filter(function (arg) {
    return !(arg instanceof this.constructor);
  }, this);

  if (children.length !== 0) {
    assert(state.children === null);
    state.children = children; // Replace parent to maintain backward link

    children.forEach(function (child) {
      child._baseState.parent = this;
    }, this);
  }

  if (args.length !== 0) {
    assert(state.args === null);
    state.args = args;
    state.reverseArgs = args.map(function (arg) {
      if (_typeof(arg) !== 'object' || arg.constructor !== Object) return arg;
      var res = {};
      Object.keys(arg).forEach(function (key) {
        if (key == (key | 0)) key |= 0;
        var value = arg[key];
        res[value] = key;
      });
      return res;
    });
  }
}; //
// Overrided methods
//


overrided.forEach(function (method) {
  Node.prototype[method] = function _overrided() {
    var state = this._baseState;
    throw new Error(method + ' not implemented for encoding: ' + state.enc);
  };
}); //
// Public methods
//

tags.forEach(function (tag) {
  Node.prototype[tag] = function _tagMethod() {
    var state = this._baseState;
    var args = Array.prototype.slice.call(arguments);
    assert(state.tag === null);
    state.tag = tag;

    this._useArgs(args);

    return this;
  };
});

Node.prototype.use = function use(item) {
  assert(item);
  var state = this._baseState;
  assert(state.use === null);
  state.use = item;
  return this;
};

Node.prototype.optional = function optional() {
  var state = this._baseState;
  state.optional = true;
  return this;
};

Node.prototype.def = function def(val) {
  var state = this._baseState;
  assert(state['default'] === null);
  state['default'] = val;
  state.optional = true;
  return this;
};

Node.prototype.explicit = function explicit(num) {
  var state = this._baseState;
  assert(state.explicit === null && state.implicit === null);
  state.explicit = num;
  return this;
};

Node.prototype.implicit = function implicit(num) {
  var state = this._baseState;
  assert(state.explicit === null && state.implicit === null);
  state.implicit = num;
  return this;
};

Node.prototype.obj = function obj() {
  var state = this._baseState;
  var args = Array.prototype.slice.call(arguments);
  state.obj = true;
  if (args.length !== 0) this._useArgs(args);
  return this;
};

Node.prototype.key = function key(newKey) {
  var state = this._baseState;
  assert(state.key === null);
  state.key = newKey;
  return this;
};

Node.prototype.any = function any() {
  var state = this._baseState;
  state.any = true;
  return this;
};

Node.prototype.choice = function choice(obj) {
  var state = this._baseState;
  assert(state.choice === null);
  state.choice = obj;

  this._useArgs(Object.keys(obj).map(function (key) {
    return obj[key];
  }));

  return this;
};

Node.prototype.contains = function contains(item) {
  var state = this._baseState;
  assert(state.use === null);
  state.contains = item;
  return this;
}; //
// Decoding
//


Node.prototype._decode = function decode(input, options) {
  var state = this._baseState; // Decode root node

  if (state.parent === null) return input.wrapResult(state.children[0]._decode(input, options));
  var result = state['default'];
  var present = true;
  var prevKey = null;
  if (state.key !== null) prevKey = input.enterKey(state.key); // Check if tag is there

  if (state.optional) {
    var tag = null;
    if (state.explicit !== null) tag = state.explicit;else if (state.implicit !== null) tag = state.implicit;else if (state.tag !== null) tag = state.tag;

    if (tag === null && !state.any) {
      // Trial and Error
      var save = input.save();

      try {
        if (state.choice === null) this._decodeGeneric(state.tag, input, options);else this._decodeChoice(input, options);
        present = true;
      } catch (e) {
        present = false;
      }

      input.restore(save);
    } else {
      present = this._peekTag(input, tag, state.any);
      if (input.isError(present)) return present;
    }
  } // Push object on stack


  var prevObj;
  if (state.obj && present) prevObj = input.enterObject();

  if (present) {
    // Unwrap explicit values
    if (state.explicit !== null) {
      var explicit = this._decodeTag(input, state.explicit);

      if (input.isError(explicit)) return explicit;
      input = explicit;
    }

    var start = input.offset; // Unwrap implicit and normal values

    if (state.use === null && state.choice === null) {
      var _save;

      if (state.any) _save = input.save();

      var body = this._decodeTag(input, state.implicit !== null ? state.implicit : state.tag, state.any);

      if (input.isError(body)) return body;
      if (state.any) result = input.raw(_save);else input = body;
    }

    if (options && options.track && state.tag !== null) options.track(input.path(), start, input.length, 'tagged');
    if (options && options.track && state.tag !== null) options.track(input.path(), input.offset, input.length, 'content'); // Select proper method for tag

    if (state.any) {// no-op
    } else if (state.choice === null) {
      result = this._decodeGeneric(state.tag, input, options);
    } else {
      result = this._decodeChoice(input, options);
    }

    if (input.isError(result)) return result; // Decode children

    if (!state.any && state.choice === null && state.children !== null) {
      state.children.forEach(function decodeChildren(child) {
        // NOTE: We are ignoring errors here, to let parser continue with other
        // parts of encoded data
        child._decode(input, options);
      });
    } // Decode contained/encoded by schema, only in bit or octet strings


    if (state.contains && (state.tag === 'octstr' || state.tag === 'bitstr')) {
      var data = new DecoderBuffer(result);
      result = this._getUse(state.contains, input._reporterState.obj)._decode(data, options);
    }
  } // Pop object


  if (state.obj && present) result = input.leaveObject(prevObj); // Set key

  if (state.key !== null && (result !== null || present === true)) input.leaveKey(prevKey, state.key, result);else if (prevKey !== null) input.exitKey(prevKey);
  return result;
};

Node.prototype._decodeGeneric = function decodeGeneric(tag, input, options) {
  var state = this._baseState;
  if (tag === 'seq' || tag === 'set') return null;
  if (tag === 'seqof' || tag === 'setof') return this._decodeList(input, tag, state.args[0], options);else if (/str$/.test(tag)) return this._decodeStr(input, tag, options);else if (tag === 'objid' && state.args) return this._decodeObjid(input, state.args[0], state.args[1], options);else if (tag === 'objid') return this._decodeObjid(input, null, null, options);else if (tag === 'gentime' || tag === 'utctime') return this._decodeTime(input, tag, options);else if (tag === 'null_') return this._decodeNull(input, options);else if (tag === 'bool') return this._decodeBool(input, options);else if (tag === 'objDesc') return this._decodeStr(input, tag, options);else if (tag === 'int' || tag === 'enum') return this._decodeInt(input, state.args && state.args[0], options);

  if (state.use !== null) {
    return this._getUse(state.use, input._reporterState.obj)._decode(input, options);
  } else {
    return input.error('unknown tag: ' + tag);
  }
};

Node.prototype._getUse = function _getUse(entity, obj) {
  var state = this._baseState; // Create altered use decoder if implicit is set

  state.useDecoder = this._use(entity, obj);
  assert(state.useDecoder._baseState.parent === null);
  state.useDecoder = state.useDecoder._baseState.children[0];

  if (state.implicit !== state.useDecoder._baseState.implicit) {
    state.useDecoder = state.useDecoder.clone();
    state.useDecoder._baseState.implicit = state.implicit;
  }

  return state.useDecoder;
};

Node.prototype._decodeChoice = function decodeChoice(input, options) {
  var state = this._baseState;
  var result = null;
  var match = false;
  Object.keys(state.choice).some(function (key) {
    var save = input.save();
    var node = state.choice[key];

    try {
      var value = node._decode(input, options);

      if (input.isError(value)) return false;
      result = {
        type: key,
        value: value
      };
      match = true;
    } catch (e) {
      input.restore(save);
      return false;
    }

    return true;
  }, this);
  if (!match) return input.error('Choice not matched');
  return result;
}; //
// Encoding
//


Node.prototype._createEncoderBuffer = function createEncoderBuffer(data) {
  return new EncoderBuffer(data, this.reporter);
};

Node.prototype._encode = function encode(data, reporter, parent) {
  var state = this._baseState;
  if (state['default'] !== null && state['default'] === data) return;

  var result = this._encodeValue(data, reporter, parent);

  if (result === undefined) return;
  if (this._skipDefault(result, reporter, parent)) return;
  return result;
};

Node.prototype._encodeValue = function encode(data, reporter, parent) {
  var state = this._baseState; // Decode root node

  if (state.parent === null) return state.children[0]._encode(data, reporter || new Reporter());
  var result = null; // Set reporter to share it with a child class

  this.reporter = reporter; // Check if data is there

  if (state.optional && data === undefined) {
    if (state['default'] !== null) data = state['default'];else return;
  } // Encode children first


  var content = null;
  var primitive = false;

  if (state.any) {
    // Anything that was given is translated to buffer
    result = this._createEncoderBuffer(data);
  } else if (state.choice) {
    result = this._encodeChoice(data, reporter);
  } else if (state.contains) {
    content = this._getUse(state.contains, parent)._encode(data, reporter);
    primitive = true;
  } else if (state.children) {
    content = state.children.map(function (child) {
      if (child._baseState.tag === 'null_') return child._encode(null, reporter, data);
      if (child._baseState.key === null) return reporter.error('Child should have a key');
      var prevKey = reporter.enterKey(child._baseState.key);
      if (_typeof(data) !== 'object') return reporter.error('Child expected, but input is not object');

      var res = child._encode(data[child._baseState.key], reporter, data);

      reporter.leaveKey(prevKey);
      return res;
    }, this).filter(function (child) {
      return child;
    });
    content = this._createEncoderBuffer(content);
  } else {
    if (state.tag === 'seqof' || state.tag === 'setof') {
      // TODO(indutny): this should be thrown on DSL level
      if (!(state.args && state.args.length === 1)) return reporter.error('Too many args for : ' + state.tag);
      if (!Array.isArray(data)) return reporter.error('seqof/setof, but data is not Array');
      var child = this.clone();
      child._baseState.implicit = null;
      content = this._createEncoderBuffer(data.map(function (item) {
        var state = this._baseState;
        return this._getUse(state.args[0], data)._encode(item, reporter);
      }, child));
    } else if (state.use !== null) {
      result = this._getUse(state.use, parent)._encode(data, reporter);
    } else {
      content = this._encodePrimitive(state.tag, data);
      primitive = true;
    }
  } // Encode data itself


  if (!state.any && state.choice === null) {
    var tag = state.implicit !== null ? state.implicit : state.tag;
    var cls = state.implicit === null ? 'universal' : 'context';

    if (tag === null) {
      if (state.use === null) reporter.error('Tag could be omitted only for .use()');
    } else {
      if (state.use === null) result = this._encodeComposite(tag, primitive, cls, content);
    }
  } // Wrap in explicit


  if (state.explicit !== null) result = this._encodeComposite(state.explicit, false, 'context', result);
  return result;
};

Node.prototype._encodeChoice = function encodeChoice(data, reporter) {
  var state = this._baseState;
  var node = state.choice[data.type];

  if (!node) {
    assert(false, data.type + ' not found in ' + JSON.stringify(Object.keys(state.choice)));
  }

  return node._encode(data.value, reporter);
};

Node.prototype._encodePrimitive = function encodePrimitive(tag, data) {
  var state = this._baseState;
  if (/str$/.test(tag)) return this._encodeStr(data, tag);else if (tag === 'objid' && state.args) return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);else if (tag === 'objid') return this._encodeObjid(data, null, null);else if (tag === 'gentime' || tag === 'utctime') return this._encodeTime(data, tag);else if (tag === 'null_') return this._encodeNull();else if (tag === 'int' || tag === 'enum') return this._encodeInt(data, state.args && state.reverseArgs[0]);else if (tag === 'bool') return this._encodeBool(data);else if (tag === 'objDesc') return this._encodeStr(data, tag);else throw new Error('Unsupported tag: ' + tag);
};

Node.prototype._isNumstr = function isNumstr(str) {
  return /^[0-9 ]*$/.test(str);
};

Node.prototype._isPrintstr = function isPrintstr(str) {
  return /^[A-Za-z0-9 '()+,-./:=?]*$/.test(str);
};

/***/ }),

/***/ 1269:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var inherits = __webpack_require__(376);

function Reporter(options) {
  this._reporterState = {
    obj: null,
    path: [],
    options: options || {},
    errors: []
  };
}

exports.b = Reporter;

Reporter.prototype.isError = function isError(obj) {
  return obj instanceof ReporterError;
};

Reporter.prototype.save = function save() {
  var state = this._reporterState;
  return {
    obj: state.obj,
    pathLen: state.path.length
  };
};

Reporter.prototype.restore = function restore(data) {
  var state = this._reporterState;
  state.obj = data.obj;
  state.path = state.path.slice(0, data.pathLen);
};

Reporter.prototype.enterKey = function enterKey(key) {
  return this._reporterState.path.push(key);
};

Reporter.prototype.exitKey = function exitKey(index) {
  var state = this._reporterState;
  state.path = state.path.slice(0, index - 1);
};

Reporter.prototype.leaveKey = function leaveKey(index, key, value) {
  var state = this._reporterState;
  this.exitKey(index);
  if (state.obj !== null) state.obj[key] = value;
};

Reporter.prototype.path = function path() {
  return this._reporterState.path.join('/');
};

Reporter.prototype.enterObject = function enterObject() {
  var state = this._reporterState;
  var prev = state.obj;
  state.obj = {};
  return prev;
};

Reporter.prototype.leaveObject = function leaveObject(prev) {
  var state = this._reporterState;
  var now = state.obj;
  state.obj = prev;
  return now;
};

Reporter.prototype.error = function error(msg) {
  var err;
  var state = this._reporterState;
  var inherited = msg instanceof ReporterError;

  if (inherited) {
    err = msg;
  } else {
    err = new ReporterError(state.path.map(function (elem) {
      return '[' + JSON.stringify(elem) + ']';
    }).join(''), msg.message || msg, msg.stack);
  }

  if (!state.options.partial) throw err;
  if (!inherited) state.errors.push(err);
  return err;
};

Reporter.prototype.wrapResult = function wrapResult(result) {
  var state = this._reporterState;
  if (!state.options.partial) return result;
  return {
    result: this.isError(result) ? null : result,
    errors: state.errors
  };
};

function ReporterError(path, msg) {
  this.path = path;
  this.rethrow(msg);
}

inherits(ReporterError, Error);

ReporterError.prototype.rethrow = function rethrow(msg) {
  this.message = msg + ' at: ' + (this.path || '(shallow)');
  if (Error.captureStackTrace) Error.captureStackTrace(this, ReporterError);

  if (!this.stack) {
    try {
      // IE only adds stack when thrown
      throw new Error(this.message);
    } catch (e) {
      this.stack = e.stack;
    }
  }

  return this;
};

/***/ }),

/***/ 2007:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
 // Helper

function reverse(map) {
  var res = {};
  Object.keys(map).forEach(function (key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key) key = key | 0;
    var value = map[key];
    res[value] = key;
  });
  return res;
}

exports.tagClass = {
  0: 'universal',
  1: 'application',
  2: 'context',
  3: 'private'
};
exports.tagClassByName = reverse(exports.tagClass);
exports.tag = {
  0x00: 'end',
  0x01: 'bool',
  0x02: 'int',
  0x03: 'bitstr',
  0x04: 'octstr',
  0x05: 'null_',
  0x06: 'objid',
  0x07: 'objDesc',
  0x08: 'external',
  0x09: 'real',
  0x0a: 'enum',
  0x0b: 'embed',
  0x0c: 'utf8str',
  0x0d: 'relativeOid',
  0x10: 'seq',
  0x11: 'set',
  0x12: 'numstr',
  0x13: 'printstr',
  0x14: 't61str',
  0x15: 'videostr',
  0x16: 'ia5str',
  0x17: 'utctime',
  0x18: 'gentime',
  0x19: 'graphstr',
  0x1a: 'iso646str',
  0x1b: 'genstr',
  0x1c: 'unistr',
  0x1d: 'charstr',
  0x1e: 'bmpstr'
};
exports.tagByName = reverse(exports.tag);

/***/ }),

/***/ 4319:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var constants = exports; // Helper

constants._reverse = function reverse(map) {
  var res = {};
  Object.keys(map).forEach(function (key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key) key = key | 0;
    var value = map[key];
    res[value] = key;
  });
  return res;
};

constants.der = __webpack_require__(2007);

/***/ }),

/***/ 4201:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var inherits = __webpack_require__(376);

var bignum = __webpack_require__(6781);

var DecoderBuffer = (__webpack_require__(4989)/* .DecoderBuffer */ .C);

var Node = __webpack_require__(3304); // Import DER constants


var der = __webpack_require__(2007);

function DERDecoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity; // Construct base tree

  this.tree = new DERNode();

  this.tree._init(entity.body);
}

module.exports = DERDecoder;

DERDecoder.prototype.decode = function decode(data, options) {
  if (!DecoderBuffer.isDecoderBuffer(data)) {
    data = new DecoderBuffer(data, options);
  }

  return this.tree._decode(data, options);
}; // Tree methods


function DERNode(parent) {
  Node.call(this, 'der', parent);
}

inherits(DERNode, Node);

DERNode.prototype._peekTag = function peekTag(buffer, tag, any) {
  if (buffer.isEmpty()) return false;
  var state = buffer.save();
  var decodedTag = derDecodeTag(buffer, 'Failed to peek tag: "' + tag + '"');
  if (buffer.isError(decodedTag)) return decodedTag;
  buffer.restore(state);
  return decodedTag.tag === tag || decodedTag.tagStr === tag || decodedTag.tagStr + 'of' === tag || any;
};

DERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {
  var decodedTag = derDecodeTag(buffer, 'Failed to decode tag of "' + tag + '"');
  if (buffer.isError(decodedTag)) return decodedTag;
  var len = derDecodeLen(buffer, decodedTag.primitive, 'Failed to get length of "' + tag + '"'); // Failure

  if (buffer.isError(len)) return len;

  if (!any && decodedTag.tag !== tag && decodedTag.tagStr !== tag && decodedTag.tagStr + 'of' !== tag) {
    return buffer.error('Failed to match tag: "' + tag + '"');
  }

  if (decodedTag.primitive || len !== null) return buffer.skip(len, 'Failed to match body of: "' + tag + '"'); // Indefinite length... find END tag

  var state = buffer.save();

  var res = this._skipUntilEnd(buffer, 'Failed to skip indefinite length body: "' + this.tag + '"');

  if (buffer.isError(res)) return res;
  len = buffer.offset - state.offset;
  buffer.restore(state);
  return buffer.skip(len, 'Failed to match body of: "' + tag + '"');
};

DERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {
  for (;;) {
    var tag = derDecodeTag(buffer, fail);
    if (buffer.isError(tag)) return tag;
    var len = derDecodeLen(buffer, tag.primitive, fail);
    if (buffer.isError(len)) return len;
    var res = void 0;
    if (tag.primitive || len !== null) res = buffer.skip(len);else res = this._skipUntilEnd(buffer, fail); // Failure

    if (buffer.isError(res)) return res;
    if (tag.tagStr === 'end') break;
  }
};

DERNode.prototype._decodeList = function decodeList(buffer, tag, decoder, options) {
  var result = [];

  while (!buffer.isEmpty()) {
    var possibleEnd = this._peekTag(buffer, 'end');

    if (buffer.isError(possibleEnd)) return possibleEnd;
    var res = decoder.decode(buffer, 'der', options);
    if (buffer.isError(res) && possibleEnd) break;
    result.push(res);
  }

  return result;
};

DERNode.prototype._decodeStr = function decodeStr(buffer, tag) {
  if (tag === 'bitstr') {
    var unused = buffer.readUInt8();
    if (buffer.isError(unused)) return unused;
    return {
      unused: unused,
      data: buffer.raw()
    };
  } else if (tag === 'bmpstr') {
    var raw = buffer.raw();
    if (raw.length % 2 === 1) return buffer.error('Decoding of string type: bmpstr length mismatch');
    var str = '';

    for (var i = 0; i < raw.length / 2; i++) {
      str += String.fromCharCode(raw.readUInt16BE(i * 2));
    }

    return str;
  } else if (tag === 'numstr') {
    var numstr = buffer.raw().toString('ascii');

    if (!this._isNumstr(numstr)) {
      return buffer.error('Decoding of string type: ' + 'numstr unsupported characters');
    }

    return numstr;
  } else if (tag === 'octstr') {
    return buffer.raw();
  } else if (tag === 'objDesc') {
    return buffer.raw();
  } else if (tag === 'printstr') {
    var printstr = buffer.raw().toString('ascii');

    if (!this._isPrintstr(printstr)) {
      return buffer.error('Decoding of string type: ' + 'printstr unsupported characters');
    }

    return printstr;
  } else if (/str$/.test(tag)) {
    return buffer.raw().toString();
  } else {
    return buffer.error('Decoding of string type: ' + tag + ' unsupported');
  }
};

DERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {
  var result;
  var identifiers = [];
  var ident = 0;
  var subident = 0;

  while (!buffer.isEmpty()) {
    subident = buffer.readUInt8();
    ident <<= 7;
    ident |= subident & 0x7f;

    if ((subident & 0x80) === 0) {
      identifiers.push(ident);
      ident = 0;
    }
  }

  if (subident & 0x80) identifiers.push(ident);
  var first = identifiers[0] / 40 | 0;
  var second = identifiers[0] % 40;
  if (relative) result = identifiers;else result = [first, second].concat(identifiers.slice(1));

  if (values) {
    var tmp = values[result.join(' ')];
    if (tmp === undefined) tmp = values[result.join('.')];
    if (tmp !== undefined) result = tmp;
  }

  return result;
};

DERNode.prototype._decodeTime = function decodeTime(buffer, tag) {
  var str = buffer.raw().toString();
  var year;
  var mon;
  var day;
  var hour;
  var min;
  var sec;

  if (tag === 'gentime') {
    year = str.slice(0, 4) | 0;
    mon = str.slice(4, 6) | 0;
    day = str.slice(6, 8) | 0;
    hour = str.slice(8, 10) | 0;
    min = str.slice(10, 12) | 0;
    sec = str.slice(12, 14) | 0;
  } else if (tag === 'utctime') {
    year = str.slice(0, 2) | 0;
    mon = str.slice(2, 4) | 0;
    day = str.slice(4, 6) | 0;
    hour = str.slice(6, 8) | 0;
    min = str.slice(8, 10) | 0;
    sec = str.slice(10, 12) | 0;
    if (year < 70) year = 2000 + year;else year = 1900 + year;
  } else {
    return buffer.error('Decoding ' + tag + ' time is not supported yet');
  }

  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);
};

DERNode.prototype._decodeNull = function decodeNull() {
  return null;
};

DERNode.prototype._decodeBool = function decodeBool(buffer) {
  var res = buffer.readUInt8();
  if (buffer.isError(res)) return res;else return res !== 0;
};

DERNode.prototype._decodeInt = function decodeInt(buffer, values) {
  // Bigint, return as it is (assume big endian)
  var raw = buffer.raw();
  var res = new bignum(raw);
  if (values) res = values[res.toString(10)] || res;
  return res;
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function') entity = entity(obj);
  return entity._getDecoder('der').tree;
}; // Utility methods


function derDecodeTag(buf, fail) {
  var tag = buf.readUInt8(fail);
  if (buf.isError(tag)) return tag;
  var cls = der.tagClass[tag >> 6];
  var primitive = (tag & 0x20) === 0; // Multi-octet tag - load

  if ((tag & 0x1f) === 0x1f) {
    var oct = tag;
    tag = 0;

    while ((oct & 0x80) === 0x80) {
      oct = buf.readUInt8(fail);
      if (buf.isError(oct)) return oct;
      tag <<= 7;
      tag |= oct & 0x7f;
    }
  } else {
    tag &= 0x1f;
  }

  var tagStr = der.tag[tag];
  return {
    cls: cls,
    primitive: primitive,
    tag: tag,
    tagStr: tagStr
  };
}

function derDecodeLen(buf, primitive, fail) {
  var len = buf.readUInt8(fail);
  if (buf.isError(len)) return len; // Indefinite form

  if (!primitive && len === 0x80) return null; // Definite form

  if ((len & 0x80) === 0) {
    // Short form
    return len;
  } // Long form


  var num = len & 0x7f;
  if (num > 4) return buf.error('length octect is too long');
  len = 0;

  for (var i = 0; i < num; i++) {
    len <<= 8;
    var j = buf.readUInt8(fail);
    if (buf.isError(j)) return j;
    len |= j;
  }

  return len;
}

/***/ }),

/***/ 4049:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var decoders = exports;
decoders.der = __webpack_require__(4201);
decoders.pem = __webpack_require__(618);

/***/ }),

/***/ 618:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var inherits = __webpack_require__(376);

var Buffer = (__webpack_require__(8723).Buffer);

var DERDecoder = __webpack_require__(4201);

function PEMDecoder(entity) {
  DERDecoder.call(this, entity);
  this.enc = 'pem';
}

inherits(PEMDecoder, DERDecoder);
module.exports = PEMDecoder;

PEMDecoder.prototype.decode = function decode(data, options) {
  var lines = data.toString().split(/[\r\n]+/g);
  var label = options.label.toUpperCase();
  var re = /^-----(BEGIN|END) ([^-]+)-----$/;
  var start = -1;
  var end = -1;

  for (var i = 0; i < lines.length; i++) {
    var match = lines[i].match(re);
    if (match === null) continue;
    if (match[2] !== label) continue;

    if (start === -1) {
      if (match[1] !== 'BEGIN') break;
      start = i;
    } else {
      if (match[1] !== 'END') break;
      end = i;
      break;
    }
  }

  if (start === -1 || end === -1) throw new Error('PEM section not found for: ' + label);
  var base64 = lines.slice(start + 1, end).join(''); // Remove excessive symbols

  base64.replace(/[^a-z0-9+/=]+/gi, '');
  var input = Buffer.from(base64, 'base64');
  return DERDecoder.prototype.decode.call(this, input, options);
};

/***/ }),

/***/ 1889:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var inherits = __webpack_require__(376);

var Buffer = (__webpack_require__(8723).Buffer);

var Node = __webpack_require__(3304); // Import DER constants


var der = __webpack_require__(2007);

function DEREncoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity; // Construct base tree

  this.tree = new DERNode();

  this.tree._init(entity.body);
}

module.exports = DEREncoder;

DEREncoder.prototype.encode = function encode(data, reporter) {
  return this.tree._encode(data, reporter).join();
}; // Tree methods


function DERNode(parent) {
  Node.call(this, 'der', parent);
}

inherits(DERNode, Node);

DERNode.prototype._encodeComposite = function encodeComposite(tag, primitive, cls, content) {
  var encodedTag = encodeTag(tag, primitive, cls, this.reporter); // Short form

  if (content.length < 0x80) {
    var _header = Buffer.alloc(2);

    _header[0] = encodedTag;
    _header[1] = content.length;
    return this._createEncoderBuffer([_header, content]);
  } // Long form
  // Count octets required to store length


  var lenOctets = 1;

  for (var i = content.length; i >= 0x100; i >>= 8) {
    lenOctets++;
  }

  var header = Buffer.alloc(1 + 1 + lenOctets);
  header[0] = encodedTag;
  header[1] = 0x80 | lenOctets;

  for (var _i = 1 + lenOctets, j = content.length; j > 0; _i--, j >>= 8) {
    header[_i] = j & 0xff;
  }

  return this._createEncoderBuffer([header, content]);
};

DERNode.prototype._encodeStr = function encodeStr(str, tag) {
  if (tag === 'bitstr') {
    return this._createEncoderBuffer([str.unused | 0, str.data]);
  } else if (tag === 'bmpstr') {
    var buf = Buffer.alloc(str.length * 2);

    for (var i = 0; i < str.length; i++) {
      buf.writeUInt16BE(str.charCodeAt(i), i * 2);
    }

    return this._createEncoderBuffer(buf);
  } else if (tag === 'numstr') {
    if (!this._isNumstr(str)) {
      return this.reporter.error('Encoding of string type: numstr supports ' + 'only digits and space');
    }

    return this._createEncoderBuffer(str);
  } else if (tag === 'printstr') {
    if (!this._isPrintstr(str)) {
      return this.reporter.error('Encoding of string type: printstr supports ' + 'only latin upper and lower case letters, ' + 'digits, space, apostrophe, left and rigth ' + 'parenthesis, plus sign, comma, hyphen, ' + 'dot, slash, colon, equal sign, ' + 'question mark');
    }

    return this._createEncoderBuffer(str);
  } else if (/str$/.test(tag)) {
    return this._createEncoderBuffer(str);
  } else if (tag === 'objDesc') {
    return this._createEncoderBuffer(str);
  } else {
    return this.reporter.error('Encoding of string type: ' + tag + ' unsupported');
  }
};

DERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {
  if (typeof id === 'string') {
    if (!values) return this.reporter.error('string objid given, but no values map found');
    if (!values.hasOwnProperty(id)) return this.reporter.error('objid not found in values map');
    id = values[id].split(/[\s.]+/g);

    for (var i = 0; i < id.length; i++) {
      id[i] |= 0;
    }
  } else if (Array.isArray(id)) {
    id = id.slice();

    for (var _i2 = 0; _i2 < id.length; _i2++) {
      id[_i2] |= 0;
    }
  }

  if (!Array.isArray(id)) {
    return this.reporter.error('objid() should be either array or string, ' + 'got: ' + JSON.stringify(id));
  }

  if (!relative) {
    if (id[1] >= 40) return this.reporter.error('Second objid identifier OOB');
    id.splice(0, 2, id[0] * 40 + id[1]);
  } // Count number of octets


  var size = 0;

  for (var _i3 = 0; _i3 < id.length; _i3++) {
    var ident = id[_i3];

    for (size++; ident >= 0x80; ident >>= 7) {
      size++;
    }
  }

  var objid = Buffer.alloc(size);
  var offset = objid.length - 1;

  for (var _i4 = id.length - 1; _i4 >= 0; _i4--) {
    var _ident = id[_i4];
    objid[offset--] = _ident & 0x7f;

    while ((_ident >>= 7) > 0) {
      objid[offset--] = 0x80 | _ident & 0x7f;
    }
  }

  return this._createEncoderBuffer(objid);
};

function two(num) {
  if (num < 10) return '0' + num;else return num;
}

DERNode.prototype._encodeTime = function encodeTime(time, tag) {
  var str;
  var date = new Date(time);

  if (tag === 'gentime') {
    str = [two(date.getUTCFullYear()), two(date.getUTCMonth() + 1), two(date.getUTCDate()), two(date.getUTCHours()), two(date.getUTCMinutes()), two(date.getUTCSeconds()), 'Z'].join('');
  } else if (tag === 'utctime') {
    str = [two(date.getUTCFullYear() % 100), two(date.getUTCMonth() + 1), two(date.getUTCDate()), two(date.getUTCHours()), two(date.getUTCMinutes()), two(date.getUTCSeconds()), 'Z'].join('');
  } else {
    this.reporter.error('Encoding ' + tag + ' time is not supported yet');
  }

  return this._encodeStr(str, 'octstr');
};

DERNode.prototype._encodeNull = function encodeNull() {
  return this._createEncoderBuffer('');
};

DERNode.prototype._encodeInt = function encodeInt(num, values) {
  if (typeof num === 'string') {
    if (!values) return this.reporter.error('String int or enum given, but no values map');

    if (!values.hasOwnProperty(num)) {
      return this.reporter.error('Values map doesn\'t contain: ' + JSON.stringify(num));
    }

    num = values[num];
  } // Bignum, assume big endian


  if (typeof num !== 'number' && !Buffer.isBuffer(num)) {
    var numArray = num.toArray();

    if (!num.sign && numArray[0] & 0x80) {
      numArray.unshift(0);
    }

    num = Buffer.from(numArray);
  }

  if (Buffer.isBuffer(num)) {
    var _size = num.length;
    if (num.length === 0) _size++;

    var _out = Buffer.alloc(_size);

    num.copy(_out);
    if (num.length === 0) _out[0] = 0;
    return this._createEncoderBuffer(_out);
  }

  if (num < 0x80) return this._createEncoderBuffer(num);
  if (num < 0x100) return this._createEncoderBuffer([0, num]);
  var size = 1;

  for (var i = num; i >= 0x100; i >>= 8) {
    size++;
  }

  var out = new Array(size);

  for (var _i5 = out.length - 1; _i5 >= 0; _i5--) {
    out[_i5] = num & 0xff;
    num >>= 8;
  }

  if (out[0] & 0x80) {
    out.unshift(0);
  }

  return this._createEncoderBuffer(Buffer.from(out));
};

DERNode.prototype._encodeBool = function encodeBool(value) {
  return this._createEncoderBuffer(value ? 0xff : 0);
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function') entity = entity(obj);
  return entity._getEncoder('der').tree;
};

DERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter, parent) {
  var state = this._baseState;
  var i;
  if (state['default'] === null) return false;
  var data = dataBuffer.join();
  if (state.defaultBuffer === undefined) state.defaultBuffer = this._encodeValue(state['default'], reporter, parent).join();
  if (data.length !== state.defaultBuffer.length) return false;

  for (i = 0; i < data.length; i++) {
    if (data[i] !== state.defaultBuffer[i]) return false;
  }

  return true;
}; // Utility methods


function encodeTag(tag, primitive, cls, reporter) {
  var res;
  if (tag === 'seqof') tag = 'seq';else if (tag === 'setof') tag = 'set';
  if (der.tagByName.hasOwnProperty(tag)) res = der.tagByName[tag];else if (typeof tag === 'number' && (tag | 0) === tag) res = tag;else return reporter.error('Unknown tag: ' + tag);
  if (res >= 0x1f) return reporter.error('Multi-octet tag encoding unsupported');
  if (!primitive) res |= 0x20;
  res |= der.tagClassByName[cls || 'universal'] << 6;
  return res;
}

/***/ }),

/***/ 6860:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var encoders = exports;
encoders.der = __webpack_require__(1889);
encoders.pem = __webpack_require__(1610);

/***/ }),

/***/ 1610:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var inherits = __webpack_require__(376);

var DEREncoder = __webpack_require__(1889);

function PEMEncoder(entity) {
  DEREncoder.call(this, entity);
  this.enc = 'pem';
}

inherits(PEMEncoder, DEREncoder);
module.exports = PEMEncoder;

PEMEncoder.prototype.encode = function encode(data, options) {
  var buf = DEREncoder.prototype.encode.call(this, data);
  var p = buf.toString('base64');
  var out = ['-----BEGIN ' + options.label + '-----'];

  for (var i = 0; i < p.length; i += 64) {
    out.push(p.slice(i, i + 64));
  }

  out.push('-----END ' + options.label + '-----');
  return out.join('\n');
};

/***/ }),

/***/ 9373:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/assert.js
// https://github.com/nodejs/node/commit/2a51ae424a513ec9a6aa3466baa0cc1d55dd4f3b
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


function _typeof2(obj) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof2(obj); }

function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var _require = __webpack_require__(9978),
    _require$codes = _require.codes,
    ERR_AMBIGUOUS_ARGUMENT = _require$codes.ERR_AMBIGUOUS_ARGUMENT,
    ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
    ERR_INVALID_ARG_VALUE = _require$codes.ERR_INVALID_ARG_VALUE,
    ERR_INVALID_RETURN_VALUE = _require$codes.ERR_INVALID_RETURN_VALUE,
    ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS;

var AssertionError = __webpack_require__(1935);

var _require2 = __webpack_require__(161),
    inspect = _require2.inspect;

var _require$types = (__webpack_require__(161).types),
    isPromise = _require$types.isPromise,
    isRegExp = _require$types.isRegExp;

var objectAssign = Object.assign ? Object.assign : (__webpack_require__(8028).assign);
var objectIs = Object.is ? Object.is : __webpack_require__(4710);
var errorCache = new Map();
var isDeepEqual;
var isDeepStrictEqual;
var parseExpressionAt;
var findNodeAround;
var decoder;

function lazyLoadComparison() {
  var comparison = __webpack_require__(9015);

  isDeepEqual = comparison.isDeepEqual;
  isDeepStrictEqual = comparison.isDeepStrictEqual;
} // Escape control characters but not \n and \t to keep the line breaks and
// indentation intact.
// eslint-disable-next-line no-control-regex


var escapeSequencesRegExp = /[\x00-\x08\x0b\x0c\x0e-\x1f]/g;
var meta = (/* unused pure expression or super */ null && (["\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", '\\b', '', '', "\\u000b", '\\f', '', "\\u000e", "\\u000f", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001a", "\\u001b", "\\u001c", "\\u001d", "\\u001e", "\\u001f"]));

var escapeFn = function escapeFn(str) {
  return meta[str.charCodeAt(0)];
};

var warned = false; // The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;
var NO_EXCEPTION_SENTINEL = {}; // All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided. All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function innerFail(obj) {
  if (obj.message instanceof Error) throw obj.message;
  throw new AssertionError(obj);
}

function fail(actual, expected, message, operator, stackStartFn) {
  var argsLen = arguments.length;
  var internalMessage;

  if (argsLen === 0) {
    internalMessage = 'Failed';
  } else if (argsLen === 1) {
    message = actual;
    actual = undefined;
  } else {
    if (warned === false) {
      warned = true;
      var warn = ({env:{}}).emitWarning ? ({env:{}}).emitWarning : console.warn.bind(console);
      warn('assert.fail() with more than one argument is deprecated. ' + 'Please use assert.strictEqual() instead or only pass a message.', 'DeprecationWarning', 'DEP0094');
    }

    if (argsLen === 2) operator = '!=';
  }

  if (message instanceof Error) throw message;
  var errArgs = {
    actual: actual,
    expected: expected,
    operator: operator === undefined ? 'fail' : operator,
    stackStartFn: stackStartFn || fail
  };

  if (message !== undefined) {
    errArgs.message = message;
  }

  var err = new AssertionError(errArgs);

  if (internalMessage) {
    err.message = internalMessage;
    err.generatedMessage = true;
  }

  throw err;
}

assert.fail = fail; // The AssertionError is defined in internal/error.

assert.AssertionError = AssertionError;

function innerOk(fn, argLen, value, message) {
  if (!value) {
    var generatedMessage = false;

    if (argLen === 0) {
      generatedMessage = true;
      message = 'No value argument passed to `assert.ok()`';
    } else if (message instanceof Error) {
      throw message;
    }

    var err = new AssertionError({
      actual: value,
      expected: true,
      message: message,
      operator: '==',
      stackStartFn: fn
    });
    err.generatedMessage = generatedMessage;
    throw err;
  }
} // Pure assertion tests whether a value is truthy, as determined
// by !!value.


function ok() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  innerOk.apply(void 0, [ok, args.length].concat(args));
}

assert.ok = ok; // The equality assertion tests shallow, coercive equality with ==.

/* eslint-disable no-restricted-properties */

assert.equal = function equal(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  } // eslint-disable-next-line eqeqeq


  if (actual != expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '==',
      stackStartFn: equal
    });
  }
}; // The non-equality assertion tests for whether two objects are not
// equal with !=.


assert.notEqual = function notEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  } // eslint-disable-next-line eqeqeq


  if (actual == expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '!=',
      stackStartFn: notEqual
    });
  }
}; // The equivalence assertion tests a deep equality relation.


assert.deepEqual = function deepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (isDeepEqual === undefined) lazyLoadComparison();

  if (!isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepEqual',
      stackStartFn: deepEqual
    });
  }
}; // The non-equivalence assertion tests for any deep inequality.


assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (isDeepEqual === undefined) lazyLoadComparison();

  if (isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepEqual',
      stackStartFn: notDeepEqual
    });
  }
};
/* eslint-enable */


assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (isDeepEqual === undefined) lazyLoadComparison();

  if (!isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepStrictEqual',
      stackStartFn: deepStrictEqual
    });
  }
};

assert.notDeepStrictEqual = notDeepStrictEqual;

function notDeepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (isDeepEqual === undefined) lazyLoadComparison();

  if (isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepStrictEqual',
      stackStartFn: notDeepStrictEqual
    });
  }
}

assert.strictEqual = function strictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (!objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'strictEqual',
      stackStartFn: strictEqual
    });
  }
};

assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }

  if (objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notStrictEqual',
      stackStartFn: notStrictEqual
    });
  }
};

var Comparison = function Comparison(obj, keys, actual) {
  var _this = this;

  _classCallCheck(this, Comparison);

  keys.forEach(function (key) {
    if (key in obj) {
      if (actual !== undefined && typeof actual[key] === 'string' && isRegExp(obj[key]) && obj[key].test(actual[key])) {
        _this[key] = actual[key];
      } else {
        _this[key] = obj[key];
      }
    }
  });
};

function compareExceptionKey(actual, expected, key, message, keys, fn) {
  if (!(key in actual) || !isDeepStrictEqual(actual[key], expected[key])) {
    if (!message) {
      // Create placeholder objects to create a nice output.
      var a = new Comparison(actual, keys);
      var b = new Comparison(expected, keys, actual);
      var err = new AssertionError({
        actual: a,
        expected: b,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.actual = actual;
      err.expected = expected;
      err.operator = fn.name;
      throw err;
    }

    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: fn.name,
      stackStartFn: fn
    });
  }
}

function expectedException(actual, expected, msg, fn) {
  if (typeof expected !== 'function') {
    if (isRegExp(expected)) return expected.test(actual); // assert.doesNotThrow does not accept objects.

    if (arguments.length === 2) {
      throw new ERR_INVALID_ARG_TYPE('expected', ['Function', 'RegExp'], expected);
    } // Handle primitives properly.


    if (_typeof(actual) !== 'object' || actual === null) {
      var err = new AssertionError({
        actual: actual,
        expected: expected,
        message: msg,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.operator = fn.name;
      throw err;
    }

    var keys = Object.keys(expected); // Special handle errors to make sure the name and the message are compared
    // as well.

    if (expected instanceof Error) {
      keys.push('name', 'message');
    } else if (keys.length === 0) {
      throw new ERR_INVALID_ARG_VALUE('error', expected, 'may not be an empty object');
    }

    if (isDeepEqual === undefined) lazyLoadComparison();
    keys.forEach(function (key) {
      if (typeof actual[key] === 'string' && isRegExp(expected[key]) && expected[key].test(actual[key])) {
        return;
      }

      compareExceptionKey(actual, expected, key, msg, keys, fn);
    });
    return true;
  } // Guard instanceof against arrow functions as they don't have a prototype.


  if (expected.prototype !== undefined && actual instanceof expected) {
    return true;
  }

  if (Error.isPrototypeOf(expected)) {
    return false;
  }

  return expected.call({}, actual) === true;
}

function getActual(fn) {
  if (typeof fn !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('fn', 'Function', fn);
  }

  try {
    fn();
  } catch (e) {
    return e;
  }

  return NO_EXCEPTION_SENTINEL;
}

function checkIsPromise(obj) {
  // Accept native ES6 promises and promises that are implemented in a similar
  // way. Do not accept thenables that use a function as `obj` and that have no
  // `catch` handler.
  // TODO: thenables are checked up until they have the correct methods,
  // but according to documentation, the `then` method should receive
  // the `fulfill` and `reject` arguments as well or it may be never resolved.
  return isPromise(obj) || obj !== null && _typeof(obj) === 'object' && typeof obj.then === 'function' && typeof obj["catch"] === 'function';
}

function waitForActual(promiseFn) {
  return Promise.resolve().then(function () {
    var resultPromise;

    if (typeof promiseFn === 'function') {
      // Return a rejected promise if `promiseFn` throws synchronously.
      resultPromise = promiseFn(); // Fail in case no promise is returned.

      if (!checkIsPromise(resultPromise)) {
        throw new ERR_INVALID_RETURN_VALUE('instance of Promise', 'promiseFn', resultPromise);
      }
    } else if (checkIsPromise(promiseFn)) {
      resultPromise = promiseFn;
    } else {
      throw new ERR_INVALID_ARG_TYPE('promiseFn', ['Function', 'Promise'], promiseFn);
    }

    return Promise.resolve().then(function () {
      return resultPromise;
    }).then(function () {
      return NO_EXCEPTION_SENTINEL;
    })["catch"](function (e) {
      return e;
    });
  });
}

function expectsError(stackStartFn, actual, error, message) {
  if (typeof error === 'string') {
    if (arguments.length === 4) {
      throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
    }

    if (_typeof(actual) === 'object' && actual !== null) {
      if (actual.message === error) {
        throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error message \"".concat(actual.message, "\" is identical to the message."));
      }
    } else if (actual === error) {
      throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error \"".concat(actual, "\" is identical to the message."));
    }

    message = error;
    error = undefined;
  } else if (error != null && _typeof(error) !== 'object' && typeof error !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
  }

  if (actual === NO_EXCEPTION_SENTINEL) {
    var details = '';

    if (error && error.name) {
      details += " (".concat(error.name, ")");
    }

    details += message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'rejects' ? 'rejection' : 'exception';
    innerFail({
      actual: undefined,
      expected: error,
      operator: stackStartFn.name,
      message: "Missing expected ".concat(fnType).concat(details),
      stackStartFn: stackStartFn
    });
  }

  if (error && !expectedException(actual, error, message, stackStartFn)) {
    throw actual;
  }
}

function expectsNoError(stackStartFn, actual, error, message) {
  if (actual === NO_EXCEPTION_SENTINEL) return;

  if (typeof error === 'string') {
    message = error;
    error = undefined;
  }

  if (!error || expectedException(actual, error)) {
    var details = message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'doesNotReject' ? 'rejection' : 'exception';
    innerFail({
      actual: actual,
      expected: error,
      operator: stackStartFn.name,
      message: "Got unwanted ".concat(fnType).concat(details, "\n") + "Actual message: \"".concat(actual && actual.message, "\""),
      stackStartFn: stackStartFn
    });
  }

  throw actual;
}

assert["throws"] = function _throws(promiseFn) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }

  expectsError.apply(void 0, [_throws, getActual(promiseFn)].concat(args));
};

assert.rejects = function rejects(promiseFn) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }

  return waitForActual(promiseFn).then(function (result) {
    return expectsError.apply(void 0, [rejects, result].concat(args));
  });
};

assert.doesNotThrow = function doesNotThrow(fn) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }

  expectsNoError.apply(void 0, [doesNotThrow, getActual(fn)].concat(args));
};

assert.doesNotReject = function doesNotReject(fn) {
  for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
    args[_key5 - 1] = arguments[_key5];
  }

  return waitForActual(fn).then(function (result) {
    return expectsNoError.apply(void 0, [doesNotReject, result].concat(args));
  });
};

assert.ifError = function ifError(err) {
  if (err !== null && err !== undefined) {
    var message = 'ifError got unwanted exception: ';

    if (_typeof(err) === 'object' && typeof err.message === 'string') {
      if (err.message.length === 0 && err.constructor) {
        message += err.constructor.name;
      } else {
        message += err.message;
      }
    } else {
      message += inspect(err);
    }

    var newErr = new AssertionError({
      actual: err,
      expected: null,
      operator: 'ifError',
      message: message,
      stackStartFn: ifError
    }); // Make sure we actually have a stack trace!

    var origStack = err.stack;

    if (typeof origStack === 'string') {
      // This will remove any duplicated frames from the error frames taken
      // from within `ifError` and add the original error frames to the newly
      // created ones.
      var tmp2 = origStack.split('\n');
      tmp2.shift(); // Filter all frames existing in err.stack.

      var tmp1 = newErr.stack.split('\n');

      for (var i = 0; i < tmp2.length; i++) {
        // Find the first occurrence of the frame.
        var pos = tmp1.indexOf(tmp2[i]);

        if (pos !== -1) {
          // Only keep new frames.
          tmp1 = tmp1.slice(0, pos);
          break;
        }
      }

      newErr.stack = "".concat(tmp1.join('\n'), "\n").concat(tmp2.join('\n'));
    }

    throw newErr;
  }
}; // Expose a strict only variant of assert


function strict() {
  for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
    args[_key6] = arguments[_key6];
  }

  innerOk.apply(void 0, [strict, args.length].concat(args));
}

assert.strict = objectAssign(strict, assert, {
  equal: assert.strictEqual,
  deepEqual: assert.deepStrictEqual,
  notEqual: assert.notStrictEqual,
  notDeepEqual: assert.notDeepStrictEqual
});
assert.strict.strict = assert.strict;

/***/ }),

/***/ 1935:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/assert/assertion_error.js
// https://github.com/nodejs/node/commit/0817840f775032169ddd70c85ac059f18ffcc81c


function _typeof2(obj) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof2(obj); }

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;

  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;

    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }

    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);

      _cache.set(Class, Wrapper);
    }

    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }

    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };

  return _wrapNativeSuper(Class);
}

function isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }

  return _typeof(obj);
}

var _require = __webpack_require__(161),
    inspect = _require.inspect;

var _require2 = __webpack_require__(9978),
    ERR_INVALID_ARG_TYPE = _require2.codes.ERR_INVALID_ARG_TYPE; // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith


function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }

  return str.substring(this_len - search.length, this_len) === search;
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat


function repeat(str, count) {
  count = Math.floor(count);
  if (str.length == 0 || count == 0) return '';
  var maxCount = str.length * count;
  count = Math.floor(Math.log(count) / Math.log(2));

  while (count) {
    str += str;
    count--;
  }

  str += str.substring(0, maxCount - str.length);
  return str;
}

var blue = '';
var green = '';
var red = '';
var white = '';
var kReadableOperator = {
  deepStrictEqual: 'Expected values to be strictly deep-equal:',
  strictEqual: 'Expected values to be strictly equal:',
  strictEqualObject: 'Expected "actual" to be reference-equal to "expected":',
  deepEqual: 'Expected values to be loosely deep-equal:',
  equal: 'Expected values to be loosely equal:',
  notDeepStrictEqual: 'Expected "actual" not to be strictly deep-equal to:',
  notStrictEqual: 'Expected "actual" to be strictly unequal to:',
  notStrictEqualObject: 'Expected "actual" not to be reference-equal to "expected":',
  notDeepEqual: 'Expected "actual" not to be loosely deep-equal to:',
  notEqual: 'Expected "actual" to be loosely unequal to:',
  notIdentical: 'Values identical but not reference-equal:'
}; // Comparing short primitives should just show === / !== instead of using the
// diff.

var kMaxShortLength = 10;

function copyError(source) {
  var keys = Object.keys(source);
  var target = Object.create(Object.getPrototypeOf(source));
  keys.forEach(function (key) {
    target[key] = source[key];
  });
  Object.defineProperty(target, 'message', {
    value: source.message
  });
  return target;
}

function inspectValue(val) {
  // The util.inspect default values could be changed. This makes sure the
  // error messages contain the necessary information nevertheless.
  return inspect(val, {
    compact: false,
    customInspect: false,
    depth: 1000,
    maxArrayLength: Infinity,
    // Assert compares only enumerable properties (with a few exceptions).
    showHidden: false,
    // Having a long line as error is better than wrapping the line for
    // comparison for now.
    // TODO(BridgeAR): `breakLength` should be limited as soon as soon as we
    // have meta information about the inspected properties (i.e., know where
    // in what line the property starts and ends).
    breakLength: Infinity,
    // Assert does not detect proxies currently.
    showProxy: false,
    sorted: true,
    // Inspect getters as we also check them when comparing entries.
    getters: true
  });
}

function createErrDiff(actual, expected, operator) {
  var other = '';
  var res = '';
  var lastPos = 0;
  var end = '';
  var skipped = false;
  var actualInspected = inspectValue(actual);
  var actualLines = actualInspected.split('\n');
  var expectedLines = inspectValue(expected).split('\n');
  var i = 0;
  var indicator = ''; // In case both values are objects explicitly mark them as not reference equal
  // for the `strictEqual` operator.

  if (operator === 'strictEqual' && _typeof(actual) === 'object' && _typeof(expected) === 'object' && actual !== null && expected !== null) {
    operator = 'strictEqualObject';
  } // If "actual" and "expected" fit on a single line and they are not strictly
  // equal, check further special handling.


  if (actualLines.length === 1 && expectedLines.length === 1 && actualLines[0] !== expectedLines[0]) {
    var inputLength = actualLines[0].length + expectedLines[0].length; // If the character length of "actual" and "expected" together is less than
    // kMaxShortLength and if neither is an object and at least one of them is
    // not `zero`, use the strict equal comparison to visualize the output.

    if (inputLength <= kMaxShortLength) {
      if ((_typeof(actual) !== 'object' || actual === null) && (_typeof(expected) !== 'object' || expected === null) && (actual !== 0 || expected !== 0)) {
        // -0 === +0
        return "".concat(kReadableOperator[operator], "\n\n") + "".concat(actualLines[0], " !== ").concat(expectedLines[0], "\n");
      }
    } else if (operator !== 'strictEqualObject') {
      // If the stderr is a tty and the input length is lower than the current
      // columns per line, add a mismatch indicator below the output. If it is
      // not a tty, use a default value of 80 characters.
      var maxLength = ({env:{}}).stderr && ({env:{}}).stderr.isTTY ? ({env:{}}).stderr.columns : 80;

      if (inputLength < maxLength) {
        while (actualLines[0][i] === expectedLines[0][i]) {
          i++;
        } // Ignore the first characters.


        if (i > 2) {
          // Add position indicator for the first mismatch in case it is a
          // single line and the input length is less than the column length.
          indicator = "\n  ".concat(repeat(' ', i), "^");
          i = 0;
        }
      }
    }
  } // Remove all ending lines that match (this optimizes the output for
  // readability by reducing the number of total changed lines).


  var a = actualLines[actualLines.length - 1];
  var b = expectedLines[expectedLines.length - 1];

  while (a === b) {
    if (i++ < 2) {
      end = "\n  ".concat(a).concat(end);
    } else {
      other = a;
    }

    actualLines.pop();
    expectedLines.pop();
    if (actualLines.length === 0 || expectedLines.length === 0) break;
    a = actualLines[actualLines.length - 1];
    b = expectedLines[expectedLines.length - 1];
  }

  var maxLines = Math.max(actualLines.length, expectedLines.length); // Strict equal with identical objects that are not identical by reference.
  // E.g., assert.deepStrictEqual({ a: Symbol() }, { a: Symbol() })

  if (maxLines === 0) {
    // We have to get the result again. The lines were all removed before.
    var _actualLines = actualInspected.split('\n'); // Only remove lines in case it makes sense to collapse those.
    // TODO: Accept env to always show the full error.


    if (_actualLines.length > 30) {
      _actualLines[26] = "".concat(blue, "...").concat(white);

      while (_actualLines.length > 27) {
        _actualLines.pop();
      }
    }

    return "".concat(kReadableOperator.notIdentical, "\n\n").concat(_actualLines.join('\n'), "\n");
  }

  if (i > 3) {
    end = "\n".concat(blue, "...").concat(white).concat(end);
    skipped = true;
  }

  if (other !== '') {
    end = "\n  ".concat(other).concat(end);
    other = '';
  }

  var printedLines = 0;
  var msg = kReadableOperator[operator] + "\n".concat(green, "+ actual").concat(white, " ").concat(red, "- expected").concat(white);
  var skippedMsg = " ".concat(blue, "...").concat(white, " Lines skipped");

  for (i = 0; i < maxLines; i++) {
    // Only extra expected lines exist
    var cur = i - lastPos;

    if (actualLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(expectedLines[i - 2]);
          printedLines++;
        }

        res += "\n  ".concat(expectedLines[i - 1]);
        printedLines++;
      } // Mark the current line as the last diverging one.


      lastPos = i; // Add the expected line to the cache.

      other += "\n".concat(red, "-").concat(white, " ").concat(expectedLines[i]);
      printedLines++; // Only extra actual lines exist
    } else if (expectedLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(actualLines[i - 2]);
          printedLines++;
        }

        res += "\n  ".concat(actualLines[i - 1]);
        printedLines++;
      } // Mark the current line as the last diverging one.


      lastPos = i; // Add the actual line to the result.

      res += "\n".concat(green, "+").concat(white, " ").concat(actualLines[i]);
      printedLines++; // Lines diverge
    } else {
      var expectedLine = expectedLines[i];
      var actualLine = actualLines[i]; // If the lines diverge, specifically check for lines that only diverge by
      // a trailing comma. In that case it is actually identical and we should
      // mark it as such.

      var divergingLines = actualLine !== expectedLine && (!endsWith(actualLine, ',') || actualLine.slice(0, -1) !== expectedLine); // If the expected line has a trailing comma but is otherwise identical,
      // add a comma at the end of the actual line. Otherwise the output could
      // look weird as in:
      //
      //   [
      //     1         // No comma at the end!
      // +   2
      //   ]
      //

      if (divergingLines && endsWith(expectedLine, ',') && expectedLine.slice(0, -1) === actualLine) {
        divergingLines = false;
        actualLine += ',';
      }

      if (divergingLines) {
        // If the last diverging line is more than one line above and the
        // current line is at least line three, add some of the former lines and
        // also add dots to indicate skipped entries.
        if (cur > 1 && i > 2) {
          if (cur > 4) {
            res += "\n".concat(blue, "...").concat(white);
            skipped = true;
          } else if (cur > 3) {
            res += "\n  ".concat(actualLines[i - 2]);
            printedLines++;
          }

          res += "\n  ".concat(actualLines[i - 1]);
          printedLines++;
        } // Mark the current line as the last diverging one.


        lastPos = i; // Add the actual line to the result and cache the expected diverging
        // line so consecutive diverging lines show up as +++--- and not +-+-+-.

        res += "\n".concat(green, "+").concat(white, " ").concat(actualLine);
        other += "\n".concat(red, "-").concat(white, " ").concat(expectedLine);
        printedLines += 2; // Lines are identical
      } else {
        // Add all cached information to the result before adding other things
        // and reset the cache.
        res += other;
        other = ''; // If the last diverging line is exactly one line above or if it is the
        // very first line, add the line to the result.

        if (cur === 1 || i === 0) {
          res += "\n  ".concat(actualLine);
          printedLines++;
        }
      }
    } // Inspected object to big (Show ~20 rows max)


    if (printedLines > 20 && i < maxLines - 2) {
      return "".concat(msg).concat(skippedMsg, "\n").concat(res, "\n").concat(blue, "...").concat(white).concat(other, "\n") + "".concat(blue, "...").concat(white);
    }
  }

  return "".concat(msg).concat(skipped ? skippedMsg : '', "\n").concat(res).concat(other).concat(end).concat(indicator);
}

var AssertionError = /*#__PURE__*/function (_Error) {
  _inherits(AssertionError, _Error);

  function AssertionError(options) {
    var _this;

    _classCallCheck(this, AssertionError);

    if (_typeof(options) !== 'object' || options === null) {
      throw new ERR_INVALID_ARG_TYPE('options', 'Object', options);
    }

    var message = options.message,
        operator = options.operator,
        stackStartFn = options.stackStartFn;
    var actual = options.actual,
        expected = options.expected;
    var limit = Error.stackTraceLimit;
    Error.stackTraceLimit = 0;

    if (message != null) {
      _this = _possibleConstructorReturn(this, _getPrototypeOf(AssertionError).call(this, String(message)));
    } else {
      if (({env:{}}).stderr && ({env:{}}).stderr.isTTY) {
        // Reset on each call to make sure we handle dynamically set environment
        // variables correct.
        if (({env:{}}).stderr && ({env:{}}).stderr.getColorDepth && ({env:{}}).stderr.getColorDepth() !== 1) {
          blue = "\x1B[34m";
          green = "\x1B[32m";
          white = "\x1B[39m";
          red = "\x1B[31m";
        } else {
          blue = '';
          green = '';
          white = '';
          red = '';
        }
      } // Prevent the error stack from being visible by duplicating the error
      // in a very close way to the original in case both sides are actually
      // instances of Error.


      if (_typeof(actual) === 'object' && actual !== null && _typeof(expected) === 'object' && expected !== null && 'stack' in actual && actual instanceof Error && 'stack' in expected && expected instanceof Error) {
        actual = copyError(actual);
        expected = copyError(expected);
      }

      if (operator === 'deepStrictEqual' || operator === 'strictEqual') {
        _this = _possibleConstructorReturn(this, _getPrototypeOf(AssertionError).call(this, createErrDiff(actual, expected, operator)));
      } else if (operator === 'notDeepStrictEqual' || operator === 'notStrictEqual') {
        // In case the objects are equal but the operator requires unequal, show
        // the first object and say A equals B
        var base = kReadableOperator[operator];
        var res = inspectValue(actual).split('\n'); // In case "actual" is an object, it should not be reference equal.

        if (operator === 'notStrictEqual' && _typeof(actual) === 'object' && actual !== null) {
          base = kReadableOperator.notStrictEqualObject;
        } // Only remove lines in case it makes sense to collapse those.
        // TODO: Accept env to always show the full error.


        if (res.length > 30) {
          res[26] = "".concat(blue, "...").concat(white);

          while (res.length > 27) {
            res.pop();
          }
        } // Only print a single input.


        if (res.length === 1) {
          _this = _possibleConstructorReturn(this, _getPrototypeOf(AssertionError).call(this, "".concat(base, " ").concat(res[0])));
        } else {
          _this = _possibleConstructorReturn(this, _getPrototypeOf(AssertionError).call(this, "".concat(base, "\n\n").concat(res.join('\n'), "\n")));
        }
      } else {
        var _res = inspectValue(actual);

        var other = '';
        var knownOperators = kReadableOperator[operator];

        if (operator === 'notDeepEqual' || operator === 'notEqual') {
          _res = "".concat(kReadableOperator[operator], "\n\n").concat(_res);

          if (_res.length > 1024) {
            _res = "".concat(_res.slice(0, 1021), "...");
          }
        } else {
          other = "".concat(inspectValue(expected));

          if (_res.length > 512) {
            _res = "".concat(_res.slice(0, 509), "...");
          }

          if (other.length > 512) {
            other = "".concat(other.slice(0, 509), "...");
          }

          if (operator === 'deepEqual' || operator === 'equal') {
            _res = "".concat(knownOperators, "\n\n").concat(_res, "\n\nshould equal\n\n");
          } else {
            other = " ".concat(operator, " ").concat(other);
          }
        }

        _this = _possibleConstructorReturn(this, _getPrototypeOf(AssertionError).call(this, "".concat(_res).concat(other)));
      }
    }

    Error.stackTraceLimit = limit;
    _this.generatedMessage = !message;
    Object.defineProperty(_assertThisInitialized(_this), 'name', {
      value: 'AssertionError [ERR_ASSERTION]',
      enumerable: false,
      writable: true,
      configurable: true
    });
    _this.code = 'ERR_ASSERTION';
    _this.actual = actual;
    _this.expected = expected;
    _this.operator = operator;

    if (Error.captureStackTrace) {
      // eslint-disable-next-line no-restricted-syntax
      Error.captureStackTrace(_assertThisInitialized(_this), stackStartFn);
    } // Create error message including the error code in the name.


    _this.stack; // Reset the name.

    _this.name = 'AssertionError';
    return _possibleConstructorReturn(_this);
  }

  _createClass(AssertionError, [{
    key: "toString",
    value: function toString() {
      return "".concat(this.name, " [").concat(this.code, "]: ").concat(this.message);
    }
  }, {
    key: inspect.custom,
    value: function value(recurseTimes, ctx) {
      // This limits the `actual` and `expected` property default inspection to
      // the minimum depth. Otherwise those values would be too verbose compared
      // to the actual error message which contains a combined view of these two
      // input values.
      return inspect(this, _objectSpread({}, ctx, {
        customInspect: false,
        depth: 0
      }));
    }
  }]);

  return AssertionError;
}(_wrapNativeSuper(Error));

module.exports = AssertionError;

/***/ }),

/***/ 9978:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/errors.js
// https://github.com/nodejs/node/commit/3b044962c48fe313905877a96b5d0894a5404f6f

/* eslint node-core/documented-errors: "error" */

/* eslint node-core/alphabetize-errors: "error" */

/* eslint node-core/prefer-util-format-errors: "error" */
 // The whole point behind this internal module is to allow Node.js to no
// longer be forced to treat every error message change as a semver-major
// change. The NodeError classes here all expose a `code` property whose
// value statically and permanently identifies the error. While the error
// message may change, the code should not.

function _typeof2(obj) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof2(obj); }

function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

var codes = {}; // Lazy loaded

var assert;
var util;

function createErrorType(code, message, Base) {
  if (!Base) {
    Base = Error;
  }

  function getMessage(arg1, arg2, arg3) {
    if (typeof message === 'string') {
      return message;
    } else {
      return message(arg1, arg2, arg3);
    }
  }

  var NodeError = /*#__PURE__*/function (_Base) {
    _inherits(NodeError, _Base);

    function NodeError(arg1, arg2, arg3) {
      var _this;

      _classCallCheck(this, NodeError);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(NodeError).call(this, getMessage(arg1, arg2, arg3)));
      _this.code = code;
      return _this;
    }

    return NodeError;
  }(Base);

  codes[code] = NodeError;
} // https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js


function oneOf(expected, thing) {
  if (Array.isArray(expected)) {
    var len = expected.length;
    expected = expected.map(function (i) {
      return String(i);
    });

    if (len > 2) {
      return "one of ".concat(thing, " ").concat(expected.slice(0, len - 1).join(', '), ", or ") + expected[len - 1];
    } else if (len === 2) {
      return "one of ".concat(thing, " ").concat(expected[0], " or ").concat(expected[1]);
    } else {
      return "of ".concat(thing, " ").concat(expected[0]);
    }
  } else {
    return "of ".concat(thing, " ").concat(String(expected));
  }
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith


function startsWith(str, search, pos) {
  return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith


function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }

  return str.substring(this_len - search.length, this_len) === search;
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes


function includes(str, search, start) {
  if (typeof start !== 'number') {
    start = 0;
  }

  if (start + search.length > str.length) {
    return false;
  } else {
    return str.indexOf(search, start) !== -1;
  }
}

createErrorType('ERR_AMBIGUOUS_ARGUMENT', 'The "%s" argument is ambiguous. %s', TypeError);
createErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {
  if (assert === undefined) assert = __webpack_require__(9373);
  assert(typeof name === 'string', "'name' must be a string"); // determiner: 'must be' or 'must not be'

  var determiner;

  if (typeof expected === 'string' && startsWith(expected, 'not ')) {
    determiner = 'must not be';
    expected = expected.replace(/^not /, '');
  } else {
    determiner = 'must be';
  }

  var msg;

  if (endsWith(name, ' argument')) {
    // For cases like 'first argument'
    msg = "The ".concat(name, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  } else {
    var type = includes(name, '.') ? 'property' : 'argument';
    msg = "The \"".concat(name, "\" ").concat(type, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  } // TODO(BridgeAR): Improve the output by showing `null` and similar.


  msg += ". Received type ".concat(_typeof(actual));
  return msg;
}, TypeError);
createErrorType('ERR_INVALID_ARG_VALUE', function (name, value) {
  var reason = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'is invalid';
  if (util === undefined) util = __webpack_require__(161);
  var inspected = util.inspect(value);

  if (inspected.length > 128) {
    inspected = "".concat(inspected.slice(0, 128), "...");
  }

  return "The argument '".concat(name, "' ").concat(reason, ". Received ").concat(inspected);
}, TypeError, RangeError);
createErrorType('ERR_INVALID_RETURN_VALUE', function (input, name, value) {
  var type;

  if (value && value.constructor && value.constructor.name) {
    type = "instance of ".concat(value.constructor.name);
  } else {
    type = "type ".concat(_typeof(value));
  }

  return "Expected ".concat(input, " to be returned from the \"").concat(name, "\"") + " function but got ".concat(type, ".");
}, TypeError);
createErrorType('ERR_MISSING_ARGS', function () {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (assert === undefined) assert = __webpack_require__(9373);
  assert(args.length > 0, 'At least one arg needs to be specified');
  var msg = 'The ';
  var len = args.length;
  args = args.map(function (a) {
    return "\"".concat(a, "\"");
  });

  switch (len) {
    case 1:
      msg += "".concat(args[0], " argument");
      break;

    case 2:
      msg += "".concat(args[0], " and ").concat(args[1], " arguments");
      break;

    default:
      msg += args.slice(0, len - 1).join(', ');
      msg += ", and ".concat(args[len - 1], " arguments");
      break;
  }

  return "".concat(msg, " must be specified");
}, TypeError);
module.exports.codes = codes;

/***/ }),

/***/ 9015:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/util/comparisons.js
// https://github.com/nodejs/node/commit/112cc7c27551254aa2b17098fb774867f05ed0d9


function _typeof2(obj) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof2(obj); }

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }

  return _typeof(obj);
}

var regexFlagsSupported = /a/g.flags !== undefined;

var arrayFromSet = function arrayFromSet(set) {
  var array = [];
  set.forEach(function (value) {
    return array.push(value);
  });
  return array;
};

var arrayFromMap = function arrayFromMap(map) {
  var array = [];
  map.forEach(function (value, key) {
    return array.push([key, value]);
  });
  return array;
};

var objectIs = Object.is ? Object.is : __webpack_require__(4710);
var objectGetOwnPropertySymbols = Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols : function () {
  return [];
};
var numberIsNaN = Number.isNaN ? Number.isNaN : __webpack_require__(2191);

function uncurryThis(f) {
  return f.call.bind(f);
}

var hasOwnProperty = uncurryThis(Object.prototype.hasOwnProperty);
var propertyIsEnumerable = uncurryThis(Object.prototype.propertyIsEnumerable);
var objectToString = uncurryThis(Object.prototype.toString);

var _require$types = (__webpack_require__(161).types),
    isAnyArrayBuffer = _require$types.isAnyArrayBuffer,
    isArrayBufferView = _require$types.isArrayBufferView,
    isDate = _require$types.isDate,
    isMap = _require$types.isMap,
    isRegExp = _require$types.isRegExp,
    isSet = _require$types.isSet,
    isNativeError = _require$types.isNativeError,
    isBoxedPrimitive = _require$types.isBoxedPrimitive,
    isNumberObject = _require$types.isNumberObject,
    isStringObject = _require$types.isStringObject,
    isBooleanObject = _require$types.isBooleanObject,
    isBigIntObject = _require$types.isBigIntObject,
    isSymbolObject = _require$types.isSymbolObject,
    isFloat32Array = _require$types.isFloat32Array,
    isFloat64Array = _require$types.isFloat64Array;

function isNonIndex(key) {
  if (key.length === 0 || key.length > 10) return true;

  for (var i = 0; i < key.length; i++) {
    var code = key.charCodeAt(i);
    if (code < 48 || code > 57) return true;
  } // The maximum size for an array is 2 ** 32 -1.


  return key.length === 10 && key >= Math.pow(2, 32);
}

function getOwnNonIndexProperties(value) {
  return Object.keys(value).filter(isNonIndex).concat(objectGetOwnPropertySymbols(value).filter(Object.prototype.propertyIsEnumerable.bind(value)));
} // Taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */


function compare(a, b) {
  if (a === b) {
    return 0;
  }

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }

  if (x < y) {
    return -1;
  }

  if (y < x) {
    return 1;
  }

  return 0;
}

var ONLY_ENUMERABLE = undefined;
var kStrict = true;
var kLoose = false;
var kNoIterator = 0;
var kIsArray = 1;
var kIsSet = 2;
var kIsMap = 3; // Check if they have the same source and flags

function areSimilarRegExps(a, b) {
  return regexFlagsSupported ? a.source === b.source && a.flags === b.flags : RegExp.prototype.toString.call(a) === RegExp.prototype.toString.call(b);
}

function areSimilarFloatArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }

  for (var offset = 0; offset < a.byteLength; offset++) {
    if (a[offset] !== b[offset]) {
      return false;
    }
  }

  return true;
}

function areSimilarTypedArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }

  return compare(new Uint8Array(a.buffer, a.byteOffset, a.byteLength), new Uint8Array(b.buffer, b.byteOffset, b.byteLength)) === 0;
}

function areEqualArrayBuffers(buf1, buf2) {
  return buf1.byteLength === buf2.byteLength && compare(new Uint8Array(buf1), new Uint8Array(buf2)) === 0;
}

function isEqualBoxedPrimitive(val1, val2) {
  if (isNumberObject(val1)) {
    return isNumberObject(val2) && objectIs(Number.prototype.valueOf.call(val1), Number.prototype.valueOf.call(val2));
  }

  if (isStringObject(val1)) {
    return isStringObject(val2) && String.prototype.valueOf.call(val1) === String.prototype.valueOf.call(val2);
  }

  if (isBooleanObject(val1)) {
    return isBooleanObject(val2) && Boolean.prototype.valueOf.call(val1) === Boolean.prototype.valueOf.call(val2);
  }

  if (isBigIntObject(val1)) {
    return isBigIntObject(val2) && BigInt.prototype.valueOf.call(val1) === BigInt.prototype.valueOf.call(val2);
  }

  return isSymbolObject(val2) && Symbol.prototype.valueOf.call(val1) === Symbol.prototype.valueOf.call(val2);
} // Notes: Type tags are historical [[Class]] properties that can be set by
// FunctionTemplate::SetClassName() in C++ or Symbol.toStringTag in JS
// and retrieved using Object.prototype.toString.call(obj) in JS
// See https://tc39.github.io/ecma262/#sec-object.prototype.tostring
// for a list of tags pre-defined in the spec.
// There are some unspecified tags in the wild too (e.g. typed array tags).
// Since tags can be altered, they only serve fast failures
//
// Typed arrays and buffers are checked by comparing the content in their
// underlying ArrayBuffer. This optimization requires that it's
// reasonable to interpret their underlying memory in the same way,
// which is checked by comparing their type tags.
// (e.g. a Uint8Array and a Uint16Array with the same memory content
// could still be different because they will be interpreted differently).
//
// For strict comparison, objects should have
// a) The same built-in type tags
// b) The same prototypes.


function innerDeepEqual(val1, val2, strict, memos) {
  // All identical values are equivalent, as determined by ===.
  if (val1 === val2) {
    if (val1 !== 0) return true;
    return strict ? objectIs(val1, val2) : true;
  } // Check more closely if val1 and val2 are equal.


  if (strict) {
    if (_typeof(val1) !== 'object') {
      return typeof val1 === 'number' && numberIsNaN(val1) && numberIsNaN(val2);
    }

    if (_typeof(val2) !== 'object' || val1 === null || val2 === null) {
      return false;
    }

    if (Object.getPrototypeOf(val1) !== Object.getPrototypeOf(val2)) {
      return false;
    }
  } else {
    if (val1 === null || _typeof(val1) !== 'object') {
      if (val2 === null || _typeof(val2) !== 'object') {
        // eslint-disable-next-line eqeqeq
        return val1 == val2;
      }

      return false;
    }

    if (val2 === null || _typeof(val2) !== 'object') {
      return false;
    }
  }

  var val1Tag = objectToString(val1);
  var val2Tag = objectToString(val2);

  if (val1Tag !== val2Tag) {
    return false;
  }

  if (Array.isArray(val1)) {
    // Check for sparse arrays and general fast path
    if (val1.length !== val2.length) {
      return false;
    }

    var keys1 = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);
    var keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);

    if (keys1.length !== keys2.length) {
      return false;
    }

    return keyCheck(val1, val2, strict, memos, kIsArray, keys1);
  } // [browserify] This triggers on certain types in IE (Map/Set) so we don't
  // wan't to early return out of the rest of the checks. However we can check
  // if the second value is one of these values and the first isn't.


  if (val1Tag === '[object Object]') {
    // return keyCheck(val1, val2, strict, memos, kNoIterator);
    if (!isMap(val1) && isMap(val2) || !isSet(val1) && isSet(val2)) {
      return false;
    }
  }

  if (isDate(val1)) {
    if (!isDate(val2) || Date.prototype.getTime.call(val1) !== Date.prototype.getTime.call(val2)) {
      return false;
    }
  } else if (isRegExp(val1)) {
    if (!isRegExp(val2) || !areSimilarRegExps(val1, val2)) {
      return false;
    }
  } else if (isNativeError(val1) || val1 instanceof Error) {
    // Do not compare the stack as it might differ even though the error itself
    // is otherwise identical.
    if (val1.message !== val2.message || val1.name !== val2.name) {
      return false;
    }
  } else if (isArrayBufferView(val1)) {
    if (!strict && (isFloat32Array(val1) || isFloat64Array(val1))) {
      if (!areSimilarFloatArrays(val1, val2)) {
        return false;
      }
    } else if (!areSimilarTypedArrays(val1, val2)) {
      return false;
    } // Buffer.compare returns true, so val1.length === val2.length. If they both
    // only contain numeric keys, we don't need to exam further than checking
    // the symbols.


    var _keys = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);

    var _keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);

    if (_keys.length !== _keys2.length) {
      return false;
    }

    return keyCheck(val1, val2, strict, memos, kNoIterator, _keys);
  } else if (isSet(val1)) {
    if (!isSet(val2) || val1.size !== val2.size) {
      return false;
    }

    return keyCheck(val1, val2, strict, memos, kIsSet);
  } else if (isMap(val1)) {
    if (!isMap(val2) || val1.size !== val2.size) {
      return false;
    }

    return keyCheck(val1, val2, strict, memos, kIsMap);
  } else if (isAnyArrayBuffer(val1)) {
    if (!areEqualArrayBuffers(val1, val2)) {
      return false;
    }
  } else if (isBoxedPrimitive(val1) && !isEqualBoxedPrimitive(val1, val2)) {
    return false;
  }

  return keyCheck(val1, val2, strict, memos, kNoIterator);
}

function getEnumerables(val, keys) {
  return keys.filter(function (k) {
    return propertyIsEnumerable(val, k);
  });
}

function keyCheck(val1, val2, strict, memos, iterationType, aKeys) {
  // For all remaining Object pairs, including Array, objects and Maps,
  // equivalence is determined by having:
  // a) The same number of owned enumerable properties
  // b) The same set of keys/indexes (although not necessarily the same order)
  // c) Equivalent values for every corresponding key/index
  // d) For Sets and Maps, equal contents
  // Note: this accounts for both named and indexed properties on Arrays.
  if (arguments.length === 5) {
    aKeys = Object.keys(val1);
    var bKeys = Object.keys(val2); // The pair must have the same number of owned properties.

    if (aKeys.length !== bKeys.length) {
      return false;
    }
  } // Cheap key test


  var i = 0;

  for (; i < aKeys.length; i++) {
    if (!hasOwnProperty(val2, aKeys[i])) {
      return false;
    }
  }

  if (strict && arguments.length === 5) {
    var symbolKeysA = objectGetOwnPropertySymbols(val1);

    if (symbolKeysA.length !== 0) {
      var count = 0;

      for (i = 0; i < symbolKeysA.length; i++) {
        var key = symbolKeysA[i];

        if (propertyIsEnumerable(val1, key)) {
          if (!propertyIsEnumerable(val2, key)) {
            return false;
          }

          aKeys.push(key);
          count++;
        } else if (propertyIsEnumerable(val2, key)) {
          return false;
        }
      }

      var symbolKeysB = objectGetOwnPropertySymbols(val2);

      if (symbolKeysA.length !== symbolKeysB.length && getEnumerables(val2, symbolKeysB).length !== count) {
        return false;
      }
    } else {
      var _symbolKeysB = objectGetOwnPropertySymbols(val2);

      if (_symbolKeysB.length !== 0 && getEnumerables(val2, _symbolKeysB).length !== 0) {
        return false;
      }
    }
  }

  if (aKeys.length === 0 && (iterationType === kNoIterator || iterationType === kIsArray && val1.length === 0 || val1.size === 0)) {
    return true;
  } // Use memos to handle cycles.


  if (memos === undefined) {
    memos = {
      val1: new Map(),
      val2: new Map(),
      position: 0
    };
  } else {
    // We prevent up to two map.has(x) calls by directly retrieving the value
    // and checking for undefined. The map can only contain numbers, so it is
    // safe to check for undefined only.
    var val2MemoA = memos.val1.get(val1);

    if (val2MemoA !== undefined) {
      var val2MemoB = memos.val2.get(val2);

      if (val2MemoB !== undefined) {
        return val2MemoA === val2MemoB;
      }
    }

    memos.position++;
  }

  memos.val1.set(val1, memos.position);
  memos.val2.set(val2, memos.position);
  var areEq = objEquiv(val1, val2, strict, aKeys, memos, iterationType);
  memos.val1["delete"](val1);
  memos.val2["delete"](val2);
  return areEq;
}

function setHasEqualElement(set, val1, strict, memo) {
  // Go looking.
  var setValues = arrayFromSet(set);

  for (var i = 0; i < setValues.length; i++) {
    var val2 = setValues[i];

    if (innerDeepEqual(val1, val2, strict, memo)) {
      // Remove the matching element to make sure we do not check that again.
      set["delete"](val2);
      return true;
    }
  }

  return false;
} // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness#Loose_equality_using
// Sadly it is not possible to detect corresponding values properly in case the
// type is a string, number, bigint or boolean. The reason is that those values
// can match lots of different string values (e.g., 1n == '+00001').


function findLooseMatchingPrimitives(prim) {
  switch (_typeof(prim)) {
    case 'undefined':
      return null;

    case 'object':
      // Only pass in null as object!
      return undefined;

    case 'symbol':
      return false;

    case 'string':
      prim = +prim;
    // Loose equal entries exist only if the string is possible to convert to
    // a regular number and not NaN.
    // Fall through

    case 'number':
      if (numberIsNaN(prim)) {
        return false;
      }

  }

  return true;
}

function setMightHaveLoosePrim(a, b, prim) {
  var altValue = findLooseMatchingPrimitives(prim);
  if (altValue != null) return altValue;
  return b.has(altValue) && !a.has(altValue);
}

function mapMightHaveLoosePrim(a, b, prim, item, memo) {
  var altValue = findLooseMatchingPrimitives(prim);

  if (altValue != null) {
    return altValue;
  }

  var curB = b.get(altValue);

  if (curB === undefined && !b.has(altValue) || !innerDeepEqual(item, curB, false, memo)) {
    return false;
  }

  return !a.has(altValue) && innerDeepEqual(item, curB, false, memo);
}

function setEquiv(a, b, strict, memo) {
  // This is a lazily initiated Set of entries which have to be compared
  // pairwise.
  var set = null;
  var aValues = arrayFromSet(a);

  for (var i = 0; i < aValues.length; i++) {
    var val = aValues[i]; // Note: Checking for the objects first improves the performance for object
    // heavy sets but it is a minor slow down for primitives. As they are fast
    // to check this improves the worst case scenario instead.

    if (_typeof(val) === 'object' && val !== null) {
      if (set === null) {
        set = new Set();
      } // If the specified value doesn't exist in the second set its an not null
      // object (or non strict only: a not matching primitive) we'll need to go
      // hunting for something thats deep-(strict-)equal to it. To make this
      // O(n log n) complexity we have to copy these values in a new set first.


      set.add(val);
    } else if (!b.has(val)) {
      if (strict) return false; // Fast path to detect missing string, symbol, undefined and null values.

      if (!setMightHaveLoosePrim(a, b, val)) {
        return false;
      }

      if (set === null) {
        set = new Set();
      }

      set.add(val);
    }
  }

  if (set !== null) {
    var bValues = arrayFromSet(b);

    for (var _i = 0; _i < bValues.length; _i++) {
      var _val = bValues[_i]; // We have to check if a primitive value is already
      // matching and only if it's not, go hunting for it.

      if (_typeof(_val) === 'object' && _val !== null) {
        if (!setHasEqualElement(set, _val, strict, memo)) return false;
      } else if (!strict && !a.has(_val) && !setHasEqualElement(set, _val, strict, memo)) {
        return false;
      }
    }

    return set.size === 0;
  }

  return true;
}

function mapHasEqualEntry(set, map, key1, item1, strict, memo) {
  // To be able to handle cases like:
  //   Map([[{}, 'a'], [{}, 'b']]) vs Map([[{}, 'b'], [{}, 'a']])
  // ... we need to consider *all* matching keys, not just the first we find.
  var setValues = arrayFromSet(set);

  for (var i = 0; i < setValues.length; i++) {
    var key2 = setValues[i];

    if (innerDeepEqual(key1, key2, strict, memo) && innerDeepEqual(item1, map.get(key2), strict, memo)) {
      set["delete"](key2);
      return true;
    }
  }

  return false;
}

function mapEquiv(a, b, strict, memo) {
  var set = null;
  var aEntries = arrayFromMap(a);

  for (var i = 0; i < aEntries.length; i++) {
    var _aEntries$i = _slicedToArray(aEntries[i], 2),
        key = _aEntries$i[0],
        item1 = _aEntries$i[1];

    if (_typeof(key) === 'object' && key !== null) {
      if (set === null) {
        set = new Set();
      }

      set.add(key);
    } else {
      // By directly retrieving the value we prevent another b.has(key) check in
      // almost all possible cases.
      var item2 = b.get(key);

      if (item2 === undefined && !b.has(key) || !innerDeepEqual(item1, item2, strict, memo)) {
        if (strict) return false; // Fast path to detect missing string, symbol, undefined and null
        // keys.

        if (!mapMightHaveLoosePrim(a, b, key, item1, memo)) return false;

        if (set === null) {
          set = new Set();
        }

        set.add(key);
      }
    }
  }

  if (set !== null) {
    var bEntries = arrayFromMap(b);

    for (var _i2 = 0; _i2 < bEntries.length; _i2++) {
      var _bEntries$_i = _slicedToArray(bEntries[_i2], 2),
          key = _bEntries$_i[0],
          item = _bEntries$_i[1];

      if (_typeof(key) === 'object' && key !== null) {
        if (!mapHasEqualEntry(set, a, key, item, strict, memo)) return false;
      } else if (!strict && (!a.has(key) || !innerDeepEqual(a.get(key), item, false, memo)) && !mapHasEqualEntry(set, a, key, item, false, memo)) {
        return false;
      }
    }

    return set.size === 0;
  }

  return true;
}

function objEquiv(a, b, strict, keys, memos, iterationType) {
  // Sets and maps don't have their entries accessible via normal object
  // properties.
  var i = 0;

  if (iterationType === kIsSet) {
    if (!setEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsMap) {
    if (!mapEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsArray) {
    for (; i < a.length; i++) {
      if (hasOwnProperty(a, i)) {
        if (!hasOwnProperty(b, i) || !innerDeepEqual(a[i], b[i], strict, memos)) {
          return false;
        }
      } else if (hasOwnProperty(b, i)) {
        return false;
      } else {
        // Array is sparse.
        var keysA = Object.keys(a);

        for (; i < keysA.length; i++) {
          var key = keysA[i];

          if (!hasOwnProperty(b, key) || !innerDeepEqual(a[key], b[key], strict, memos)) {
            return false;
          }
        }

        if (keysA.length !== Object.keys(b).length) {
          return false;
        }

        return true;
      }
    }
  } // The pair must have equivalent values for every corresponding key.
  // Possibly expensive deep test:


  for (i = 0; i < keys.length; i++) {
    var _key = keys[i];

    if (!innerDeepEqual(a[_key], b[_key], strict, memos)) {
      return false;
    }
  }

  return true;
}

function isDeepEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kLoose);
}

function isDeepStrictEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kStrict);
}

module.exports = {
  isDeepEqual: isDeepEqual,
  isDeepStrictEqual: isDeepStrictEqual
};

/***/ }),

/***/ 7943:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.byteLength = byteLength;
exports.toByteArray = toByteArray;
exports.fromByteArray = fromByteArray;
var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i];
  revLookup[code.charCodeAt(i)] = i;
} // Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications


revLookup['-'.charCodeAt(0)] = 62;
revLookup['_'.charCodeAt(0)] = 63;

function getLens(b64) {
  var len = b64.length;

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4');
  } // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42


  var validLen = b64.indexOf('=');
  if (validLen === -1) validLen = len;
  var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
  return [validLen, placeHoldersLen];
} // base64 is 4/3 + up to two characters of the original data


function byteLength(b64) {
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}

function _byteLength(b64, validLen, placeHoldersLen) {
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}

function toByteArray(b64) {
  var tmp;
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
  var curByte = 0; // if there are placeholders, only get up to the last complete 4 chars

  var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
  var i;

  for (i = 0; i < len; i += 4) {
    tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
    arr[curByte++] = tmp >> 16 & 0xFF;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }

  if (placeHoldersLen === 2) {
    tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
    arr[curByte++] = tmp & 0xFF;
  }

  if (placeHoldersLen === 1) {
    tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }

  return arr;
}

function tripletToBase64(num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
}

function encodeChunk(uint8, start, end) {
  var tmp;
  var output = [];

  for (var i = start; i < end; i += 3) {
    tmp = (uint8[i] << 16 & 0xFF0000) + (uint8[i + 1] << 8 & 0xFF00) + (uint8[i + 2] & 0xFF);
    output.push(tripletToBase64(tmp));
  }

  return output.join('');
}

function fromByteArray(uint8) {
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes

  var parts = [];
  var maxChunkLength = 16383; // must be multiple of 3
  // go through the array every three bytes, we'll deal with trailing stuff later

  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
  } // pad the end with zeros, but make sure to not forget the extra bytes


  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 0x3F] + '==');
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
    parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 0x3F] + lookup[tmp << 2 & 0x3F] + '=');
  }

  return parts.join('');
}

/***/ }),

/***/ 6781:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

(function (module, exports) {
  'use strict'; // Utils

  function assert(val, msg) {
    if (!val) throw new Error(msg || 'Assertion failed');
  } // Could use `inherits` module, but don't want to move from single file
  // architecture yet.


  function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;

    var TempCtor = function TempCtor() {};

    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  } // BN


  function BN(number, base, endian) {
    if (BN.isBN(number)) {
      return number;
    }

    this.negative = 0;
    this.words = null;
    this.length = 0; // Reduction context

    this.red = null;

    if (number !== null) {
      if (base === 'le' || base === 'be') {
        endian = base;
        base = 10;
      }

      this._init(number || 0, base || 10, endian || 'be');
    }
  }

  if (_typeof(module) === 'object') {
    module.exports = BN;
  } else {
    exports.BN = BN;
  }

  BN.BN = BN;
  BN.wordSize = 26;
  var Buffer;

  try {
    if (typeof window !== 'undefined' && typeof window.Buffer !== 'undefined') {
      Buffer = window.Buffer;
    } else {
      Buffer = (__webpack_require__(6601).Buffer);
    }
  } catch (e) {}

  BN.isBN = function isBN(num) {
    if (num instanceof BN) {
      return true;
    }

    return num !== null && _typeof(num) === 'object' && num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
  };

  BN.max = function max(left, right) {
    if (left.cmp(right) > 0) return left;
    return right;
  };

  BN.min = function min(left, right) {
    if (left.cmp(right) < 0) return left;
    return right;
  };

  BN.prototype._init = function init(number, base, endian) {
    if (typeof number === 'number') {
      return this._initNumber(number, base, endian);
    }

    if (_typeof(number) === 'object') {
      return this._initArray(number, base, endian);
    }

    if (base === 'hex') {
      base = 16;
    }

    assert(base === (base | 0) && base >= 2 && base <= 36);
    number = number.toString().replace(/\s+/g, '');
    var start = 0;

    if (number[0] === '-') {
      start++;
      this.negative = 1;
    }

    if (start < number.length) {
      if (base === 16) {
        this._parseHex(number, start, endian);
      } else {
        this._parseBase(number, base, start);

        if (endian === 'le') {
          this._initArray(this.toArray(), base, endian);
        }
      }
    }
  };

  BN.prototype._initNumber = function _initNumber(number, base, endian) {
    if (number < 0) {
      this.negative = 1;
      number = -number;
    }

    if (number < 0x4000000) {
      this.words = [number & 0x3ffffff];
      this.length = 1;
    } else if (number < 0x10000000000000) {
      this.words = [number & 0x3ffffff, number / 0x4000000 & 0x3ffffff];
      this.length = 2;
    } else {
      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)

      this.words = [number & 0x3ffffff, number / 0x4000000 & 0x3ffffff, 1];
      this.length = 3;
    }

    if (endian !== 'le') return; // Reverse the bytes

    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initArray = function _initArray(number, base, endian) {
    // Perhaps a Uint8Array
    assert(typeof number.length === 'number');

    if (number.length <= 0) {
      this.words = [0];
      this.length = 1;
      return this;
    }

    this.length = Math.ceil(number.length / 3);
    this.words = new Array(this.length);

    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    var off = 0;

    if (endian === 'be') {
      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
        w = number[i] | number[i - 1] << 8 | number[i - 2] << 16;
        this.words[j] |= w << off & 0x3ffffff;
        this.words[j + 1] = w >>> 26 - off & 0x3ffffff;
        off += 24;

        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    } else if (endian === 'le') {
      for (i = 0, j = 0; i < number.length; i += 3) {
        w = number[i] | number[i + 1] << 8 | number[i + 2] << 16;
        this.words[j] |= w << off & 0x3ffffff;
        this.words[j + 1] = w >>> 26 - off & 0x3ffffff;
        off += 24;

        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    }

    return this._strip();
  };

  function parseHex4Bits(string, index) {
    var c = string.charCodeAt(index); // '0' - '9'

    if (c >= 48 && c <= 57) {
      return c - 48; // 'A' - 'F'
    } else if (c >= 65 && c <= 70) {
      return c - 55; // 'a' - 'f'
    } else if (c >= 97 && c <= 102) {
      return c - 87;
    } else {
      assert(false, 'Invalid character in ' + string);
    }
  }

  function parseHexByte(string, lowerBound, index) {
    var r = parseHex4Bits(string, index);

    if (index - 1 >= lowerBound) {
      r |= parseHex4Bits(string, index - 1) << 4;
    }

    return r;
  }

  BN.prototype._parseHex = function _parseHex(number, start, endian) {
    // Create possibly bigger array to ensure that it fits the number
    this.length = Math.ceil((number.length - start) / 6);
    this.words = new Array(this.length);

    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    } // 24-bits chunks


    var off = 0;
    var j = 0;
    var w;

    if (endian === 'be') {
      for (i = number.length - 1; i >= start; i -= 2) {
        w = parseHexByte(number, start, i) << off;
        this.words[j] |= w & 0x3ffffff;

        if (off >= 18) {
          off -= 18;
          j += 1;
          this.words[j] |= w >>> 26;
        } else {
          off += 8;
        }
      }
    } else {
      var parseLength = number.length - start;

      for (i = parseLength % 2 === 0 ? start + 1 : start; i < number.length; i += 2) {
        w = parseHexByte(number, start, i) << off;
        this.words[j] |= w & 0x3ffffff;

        if (off >= 18) {
          off -= 18;
          j += 1;
          this.words[j] |= w >>> 26;
        } else {
          off += 8;
        }
      }
    }

    this._strip();
  };

  function parseBase(str, start, end, mul) {
    var r = 0;
    var b = 0;
    var len = Math.min(str.length, end);

    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;
      r *= mul; // 'a'

      if (c >= 49) {
        b = c - 49 + 0xa; // 'A'
      } else if (c >= 17) {
        b = c - 17 + 0xa; // '0' - '9'
      } else {
        b = c;
      }

      assert(c >= 0 && b < mul, 'Invalid character');
      r += b;
    }

    return r;
  }

  BN.prototype._parseBase = function _parseBase(number, base, start) {
    // Initialize as zero
    this.words = [0];
    this.length = 1; // Find length of limb in base

    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {
      limbLen++;
    }

    limbLen--;
    limbPow = limbPow / base | 0;
    var total = number.length - start;
    var mod = total % limbLen;
    var end = Math.min(total, total - mod) + start;
    var word = 0;

    for (var i = start; i < end; i += limbLen) {
      word = parseBase(number, i, i + limbLen, base);
      this.imuln(limbPow);

      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }

    if (mod !== 0) {
      var pow = 1;
      word = parseBase(number, i, number.length, base);

      for (i = 0; i < mod; i++) {
        pow *= base;
      }

      this.imuln(pow);

      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }

    this._strip();
  };

  BN.prototype.copy = function copy(dest) {
    dest.words = new Array(this.length);

    for (var i = 0; i < this.length; i++) {
      dest.words[i] = this.words[i];
    }

    dest.length = this.length;
    dest.negative = this.negative;
    dest.red = this.red;
  };

  function move(dest, src) {
    dest.words = src.words;
    dest.length = src.length;
    dest.negative = src.negative;
    dest.red = src.red;
  }

  BN.prototype._move = function _move(dest) {
    move(dest, this);
  };

  BN.prototype.clone = function clone() {
    var r = new BN(null);
    this.copy(r);
    return r;
  };

  BN.prototype._expand = function _expand(size) {
    while (this.length < size) {
      this.words[this.length++] = 0;
    }

    return this;
  }; // Remove leading `0` from `this`


  BN.prototype._strip = function strip() {
    while (this.length > 1 && this.words[this.length - 1] === 0) {
      this.length--;
    }

    return this._normSign();
  };

  BN.prototype._normSign = function _normSign() {
    // -0 = 0
    if (this.length === 1 && this.words[0] === 0) {
      this.negative = 0;
    }

    return this;
  }; // Check Symbol.for because not everywhere where Symbol defined
  // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol#Browser_compatibility


  if (typeof Symbol !== 'undefined' && typeof Symbol["for"] === 'function') {
    try {
      BN.prototype[Symbol["for"]('nodejs.util.inspect.custom')] = inspect;
    } catch (e) {
      BN.prototype.inspect = inspect;
    }
  } else {
    BN.prototype.inspect = inspect;
  }

  function inspect() {
    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';
  }
  /*
   var zeros = [];
  var groupSizes = [];
  var groupBases = [];
   var s = '';
  var i = -1;
  while (++i < BN.wordSize) {
    zeros[i] = s;
    s += '0';
  }
  groupSizes[0] = 0;
  groupSizes[1] = 0;
  groupBases[0] = 0;
  groupBases[1] = 0;
  var base = 2 - 1;
  while (++base < 36 + 1) {
    var groupSize = 0;
    var groupBase = 1;
    while (groupBase < (1 << BN.wordSize) / base) {
      groupBase *= base;
      groupSize += 1;
    }
    groupSizes[base] = groupSize;
    groupBases[base] = groupBase;
  }
   */


  var zeros = ['', '0', '00', '000', '0000', '00000', '000000', '0000000', '00000000', '000000000', '0000000000', '00000000000', '000000000000', '0000000000000', '00000000000000', '000000000000000', '0000000000000000', '00000000000000000', '000000000000000000', '0000000000000000000', '00000000000000000000', '000000000000000000000', '0000000000000000000000', '00000000000000000000000', '000000000000000000000000', '0000000000000000000000000'];
  var groupSizes = [0, 0, 25, 16, 12, 11, 10, 9, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5];
  var groupBases = [0, 0, 33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216, 43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625, 16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632, 6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149, 24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176];

  BN.prototype.toString = function toString(base, padding) {
    base = base || 10;
    padding = padding | 0 || 1;
    var out;

    if (base === 16 || base === 'hex') {
      out = '';
      var off = 0;
      var carry = 0;

      for (var i = 0; i < this.length; i++) {
        var w = this.words[i];
        var word = ((w << off | carry) & 0xffffff).toString(16);
        carry = w >>> 24 - off & 0xffffff;
        off += 2;

        if (off >= 26) {
          off -= 26;
          i--;
        }

        if (carry !== 0 || i !== this.length - 1) {
          out = zeros[6 - word.length] + word + out;
        } else {
          out = word + out;
        }
      }

      if (carry !== 0) {
        out = carry.toString(16) + out;
      }

      while (out.length % padding !== 0) {
        out = '0' + out;
      }

      if (this.negative !== 0) {
        out = '-' + out;
      }

      return out;
    }

    if (base === (base | 0) && base >= 2 && base <= 36) {
      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));
      var groupSize = groupSizes[base]; // var groupBase = Math.pow(base, groupSize);

      var groupBase = groupBases[base];
      out = '';
      var c = this.clone();
      c.negative = 0;

      while (!c.isZero()) {
        var r = c.modrn(groupBase).toString(base);
        c = c.idivn(groupBase);

        if (!c.isZero()) {
          out = zeros[groupSize - r.length] + r + out;
        } else {
          out = r + out;
        }
      }

      if (this.isZero()) {
        out = '0' + out;
      }

      while (out.length % padding !== 0) {
        out = '0' + out;
      }

      if (this.negative !== 0) {
        out = '-' + out;
      }

      return out;
    }

    assert(false, 'Base should be between 2 and 36');
  };

  BN.prototype.toNumber = function toNumber() {
    var ret = this.words[0];

    if (this.length === 2) {
      ret += this.words[1] * 0x4000000;
    } else if (this.length === 3 && this.words[2] === 0x01) {
      // NOTE: at this stage it is known that the top bit is set
      ret += 0x10000000000000 + this.words[1] * 0x4000000;
    } else if (this.length > 2) {
      assert(false, 'Number can only safely store up to 53 bits');
    }

    return this.negative !== 0 ? -ret : ret;
  };

  BN.prototype.toJSON = function toJSON() {
    return this.toString(16, 2);
  };

  if (Buffer) {
    BN.prototype.toBuffer = function toBuffer(endian, length) {
      return this.toArrayLike(Buffer, endian, length);
    };
  }

  BN.prototype.toArray = function toArray(endian, length) {
    return this.toArrayLike(Array, endian, length);
  };

  var allocate = function allocate(ArrayType, size) {
    if (ArrayType.allocUnsafe) {
      return ArrayType.allocUnsafe(size);
    }

    return new ArrayType(size);
  };

  BN.prototype.toArrayLike = function toArrayLike(ArrayType, endian, length) {
    this._strip();

    var byteLength = this.byteLength();
    var reqLength = length || Math.max(1, byteLength);
    assert(byteLength <= reqLength, 'byte array longer than desired length');
    assert(reqLength > 0, 'Requested array length <= 0');
    var res = allocate(ArrayType, reqLength);
    var postfix = endian === 'le' ? 'LE' : 'BE';
    this['_toArrayLike' + postfix](res, byteLength);
    return res;
  };

  BN.prototype._toArrayLikeLE = function _toArrayLikeLE(res, byteLength) {
    var position = 0;
    var carry = 0;

    for (var i = 0, shift = 0; i < this.length; i++) {
      var word = this.words[i] << shift | carry;
      res[position++] = word & 0xff;

      if (position < res.length) {
        res[position++] = word >> 8 & 0xff;
      }

      if (position < res.length) {
        res[position++] = word >> 16 & 0xff;
      }

      if (shift === 6) {
        if (position < res.length) {
          res[position++] = word >> 24 & 0xff;
        }

        carry = 0;
        shift = 0;
      } else {
        carry = word >>> 24;
        shift += 2;
      }
    }

    if (position < res.length) {
      res[position++] = carry;

      while (position < res.length) {
        res[position++] = 0;
      }
    }
  };

  BN.prototype._toArrayLikeBE = function _toArrayLikeBE(res, byteLength) {
    var position = res.length - 1;
    var carry = 0;

    for (var i = 0, shift = 0; i < this.length; i++) {
      var word = this.words[i] << shift | carry;
      res[position--] = word & 0xff;

      if (position >= 0) {
        res[position--] = word >> 8 & 0xff;
      }

      if (position >= 0) {
        res[position--] = word >> 16 & 0xff;
      }

      if (shift === 6) {
        if (position >= 0) {
          res[position--] = word >> 24 & 0xff;
        }

        carry = 0;
        shift = 0;
      } else {
        carry = word >>> 24;
        shift += 2;
      }
    }

    if (position >= 0) {
      res[position--] = carry;

      while (position >= 0) {
        res[position--] = 0;
      }
    }
  };

  if (Math.clz32) {
    BN.prototype._countBits = function _countBits(w) {
      return 32 - Math.clz32(w);
    };
  } else {
    BN.prototype._countBits = function _countBits(w) {
      var t = w;
      var r = 0;

      if (t >= 0x1000) {
        r += 13;
        t >>>= 13;
      }

      if (t >= 0x40) {
        r += 7;
        t >>>= 7;
      }

      if (t >= 0x8) {
        r += 4;
        t >>>= 4;
      }

      if (t >= 0x02) {
        r += 2;
        t >>>= 2;
      }

      return r + t;
    };
  }

  BN.prototype._zeroBits = function _zeroBits(w) {
    // Short-cut
    if (w === 0) return 26;
    var t = w;
    var r = 0;

    if ((t & 0x1fff) === 0) {
      r += 13;
      t >>>= 13;
    }

    if ((t & 0x7f) === 0) {
      r += 7;
      t >>>= 7;
    }

    if ((t & 0xf) === 0) {
      r += 4;
      t >>>= 4;
    }

    if ((t & 0x3) === 0) {
      r += 2;
      t >>>= 2;
    }

    if ((t & 0x1) === 0) {
      r++;
    }

    return r;
  }; // Return number of used bits in a BN


  BN.prototype.bitLength = function bitLength() {
    var w = this.words[this.length - 1];

    var hi = this._countBits(w);

    return (this.length - 1) * 26 + hi;
  };

  function toBitArray(num) {
    var w = new Array(num.bitLength());

    for (var bit = 0; bit < w.length; bit++) {
      var off = bit / 26 | 0;
      var wbit = bit % 26;
      w[bit] = num.words[off] >>> wbit & 0x01;
    }

    return w;
  } // Number of trailing zero bits


  BN.prototype.zeroBits = function zeroBits() {
    if (this.isZero()) return 0;
    var r = 0;

    for (var i = 0; i < this.length; i++) {
      var b = this._zeroBits(this.words[i]);

      r += b;
      if (b !== 26) break;
    }

    return r;
  };

  BN.prototype.byteLength = function byteLength() {
    return Math.ceil(this.bitLength() / 8);
  };

  BN.prototype.toTwos = function toTwos(width) {
    if (this.negative !== 0) {
      return this.abs().inotn(width).iaddn(1);
    }

    return this.clone();
  };

  BN.prototype.fromTwos = function fromTwos(width) {
    if (this.testn(width - 1)) {
      return this.notn(width).iaddn(1).ineg();
    }

    return this.clone();
  };

  BN.prototype.isNeg = function isNeg() {
    return this.negative !== 0;
  }; // Return negative clone of `this`


  BN.prototype.neg = function neg() {
    return this.clone().ineg();
  };

  BN.prototype.ineg = function ineg() {
    if (!this.isZero()) {
      this.negative ^= 1;
    }

    return this;
  }; // Or `num` with `this` in-place


  BN.prototype.iuor = function iuor(num) {
    while (this.length < num.length) {
      this.words[this.length++] = 0;
    }

    for (var i = 0; i < num.length; i++) {
      this.words[i] = this.words[i] | num.words[i];
    }

    return this._strip();
  };

  BN.prototype.ior = function ior(num) {
    assert((this.negative | num.negative) === 0);
    return this.iuor(num);
  }; // Or `num` with `this`


  BN.prototype.or = function or(num) {
    if (this.length > num.length) return this.clone().ior(num);
    return num.clone().ior(this);
  };

  BN.prototype.uor = function uor(num) {
    if (this.length > num.length) return this.clone().iuor(num);
    return num.clone().iuor(this);
  }; // And `num` with `this` in-place


  BN.prototype.iuand = function iuand(num) {
    // b = min-length(num, this)
    var b;

    if (this.length > num.length) {
      b = num;
    } else {
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = this.words[i] & num.words[i];
    }

    this.length = b.length;
    return this._strip();
  };

  BN.prototype.iand = function iand(num) {
    assert((this.negative | num.negative) === 0);
    return this.iuand(num);
  }; // And `num` with `this`


  BN.prototype.and = function and(num) {
    if (this.length > num.length) return this.clone().iand(num);
    return num.clone().iand(this);
  };

  BN.prototype.uand = function uand(num) {
    if (this.length > num.length) return this.clone().iuand(num);
    return num.clone().iuand(this);
  }; // Xor `num` with `this` in-place


  BN.prototype.iuxor = function iuxor(num) {
    // a.length > b.length
    var a;
    var b;

    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = a.words[i] ^ b.words[i];
    }

    if (this !== a) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = a.length;
    return this._strip();
  };

  BN.prototype.ixor = function ixor(num) {
    assert((this.negative | num.negative) === 0);
    return this.iuxor(num);
  }; // Xor `num` with `this`


  BN.prototype.xor = function xor(num) {
    if (this.length > num.length) return this.clone().ixor(num);
    return num.clone().ixor(this);
  };

  BN.prototype.uxor = function uxor(num) {
    if (this.length > num.length) return this.clone().iuxor(num);
    return num.clone().iuxor(this);
  }; // Not ``this`` with ``width`` bitwidth


  BN.prototype.inotn = function inotn(width) {
    assert(typeof width === 'number' && width >= 0);
    var bytesNeeded = Math.ceil(width / 26) | 0;
    var bitsLeft = width % 26; // Extend the buffer with leading zeroes

    this._expand(bytesNeeded);

    if (bitsLeft > 0) {
      bytesNeeded--;
    } // Handle complete words


    for (var i = 0; i < bytesNeeded; i++) {
      this.words[i] = ~this.words[i] & 0x3ffffff;
    } // Handle the residue


    if (bitsLeft > 0) {
      this.words[i] = ~this.words[i] & 0x3ffffff >> 26 - bitsLeft;
    } // And remove leading zeroes


    return this._strip();
  };

  BN.prototype.notn = function notn(width) {
    return this.clone().inotn(width);
  }; // Set `bit` of `this`


  BN.prototype.setn = function setn(bit, val) {
    assert(typeof bit === 'number' && bit >= 0);
    var off = bit / 26 | 0;
    var wbit = bit % 26;

    this._expand(off + 1);

    if (val) {
      this.words[off] = this.words[off] | 1 << wbit;
    } else {
      this.words[off] = this.words[off] & ~(1 << wbit);
    }

    return this._strip();
  }; // Add `num` to `this` in-place


  BN.prototype.iadd = function iadd(num) {
    var r; // negative + positive

    if (this.negative !== 0 && num.negative === 0) {
      this.negative = 0;
      r = this.isub(num);
      this.negative ^= 1;
      return this._normSign(); // positive + negative
    } else if (this.negative === 0 && num.negative !== 0) {
      num.negative = 0;
      r = this.isub(num);
      num.negative = 1;
      return r._normSign();
    } // a.length > b.length


    var a, b;

    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;

    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }

    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }

    this.length = a.length;

    if (carry !== 0) {
      this.words[this.length] = carry;
      this.length++; // Copy the rest of the words
    } else if (a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    return this;
  }; // Add `num` to `this`


  BN.prototype.add = function add(num) {
    var res;

    if (num.negative !== 0 && this.negative === 0) {
      num.negative = 0;
      res = this.sub(num);
      num.negative ^= 1;
      return res;
    } else if (num.negative === 0 && this.negative !== 0) {
      this.negative = 0;
      res = num.sub(this);
      this.negative = 1;
      return res;
    }

    if (this.length > num.length) return this.clone().iadd(num);
    return num.clone().iadd(this);
  }; // Subtract `num` from `this` in-place


  BN.prototype.isub = function isub(num) {
    // this - (-num) = this + num
    if (num.negative !== 0) {
      num.negative = 0;
      var r = this.iadd(num);
      num.negative = 1;
      return r._normSign(); // -this - num = -(this + num)
    } else if (this.negative !== 0) {
      this.negative = 0;
      this.iadd(num);
      this.negative = 1;
      return this._normSign();
    } // At this point both numbers are positive


    var cmp = this.cmp(num); // Optimization - zeroify

    if (cmp === 0) {
      this.negative = 0;
      this.length = 1;
      this.words[0] = 0;
      return this;
    } // a > b


    var a, b;

    if (cmp > 0) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;

    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }

    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    } // Copy rest of the words


    if (carry === 0 && i < a.length && a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = Math.max(this.length, i);

    if (a !== this) {
      this.negative = 1;
    }

    return this._strip();
  }; // Subtract `num` from `this`


  BN.prototype.sub = function sub(num) {
    return this.clone().isub(num);
  };

  function smallMulTo(self, num, out) {
    out.negative = num.negative ^ self.negative;
    var len = self.length + num.length | 0;
    out.length = len;
    len = len - 1 | 0; // Peel one iteration (compiler can't do it, because of code complexity)

    var a = self.words[0] | 0;
    var b = num.words[0] | 0;
    var r = a * b;
    var lo = r & 0x3ffffff;
    var carry = r / 0x4000000 | 0;
    out.words[0] = lo;

    for (var k = 1; k < len; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = carry >>> 26;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);

      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = k - j | 0;
        a = self.words[i] | 0;
        b = num.words[j] | 0;
        r = a * b + rword;
        ncarry += r / 0x4000000 | 0;
        rword = r & 0x3ffffff;
      }

      out.words[k] = rword | 0;
      carry = ncarry | 0;
    }

    if (carry !== 0) {
      out.words[k] = carry | 0;
    } else {
      out.length--;
    }

    return out._strip();
  } // TODO(indutny): it may be reasonable to omit it for users who don't need
  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit
  // multiplication (like elliptic secp256k1).


  var comb10MulTo = function comb10MulTo(self, num, out) {
    var a = self.words;
    var b = num.words;
    var o = out.words;
    var c = 0;
    var lo;
    var mid;
    var hi;
    var a0 = a[0] | 0;
    var al0 = a0 & 0x1fff;
    var ah0 = a0 >>> 13;
    var a1 = a[1] | 0;
    var al1 = a1 & 0x1fff;
    var ah1 = a1 >>> 13;
    var a2 = a[2] | 0;
    var al2 = a2 & 0x1fff;
    var ah2 = a2 >>> 13;
    var a3 = a[3] | 0;
    var al3 = a3 & 0x1fff;
    var ah3 = a3 >>> 13;
    var a4 = a[4] | 0;
    var al4 = a4 & 0x1fff;
    var ah4 = a4 >>> 13;
    var a5 = a[5] | 0;
    var al5 = a5 & 0x1fff;
    var ah5 = a5 >>> 13;
    var a6 = a[6] | 0;
    var al6 = a6 & 0x1fff;
    var ah6 = a6 >>> 13;
    var a7 = a[7] | 0;
    var al7 = a7 & 0x1fff;
    var ah7 = a7 >>> 13;
    var a8 = a[8] | 0;
    var al8 = a8 & 0x1fff;
    var ah8 = a8 >>> 13;
    var a9 = a[9] | 0;
    var al9 = a9 & 0x1fff;
    var ah9 = a9 >>> 13;
    var b0 = b[0] | 0;
    var bl0 = b0 & 0x1fff;
    var bh0 = b0 >>> 13;
    var b1 = b[1] | 0;
    var bl1 = b1 & 0x1fff;
    var bh1 = b1 >>> 13;
    var b2 = b[2] | 0;
    var bl2 = b2 & 0x1fff;
    var bh2 = b2 >>> 13;
    var b3 = b[3] | 0;
    var bl3 = b3 & 0x1fff;
    var bh3 = b3 >>> 13;
    var b4 = b[4] | 0;
    var bl4 = b4 & 0x1fff;
    var bh4 = b4 >>> 13;
    var b5 = b[5] | 0;
    var bl5 = b5 & 0x1fff;
    var bh5 = b5 >>> 13;
    var b6 = b[6] | 0;
    var bl6 = b6 & 0x1fff;
    var bh6 = b6 >>> 13;
    var b7 = b[7] | 0;
    var bl7 = b7 & 0x1fff;
    var bh7 = b7 >>> 13;
    var b8 = b[8] | 0;
    var bl8 = b8 & 0x1fff;
    var bh8 = b8 >>> 13;
    var b9 = b[9] | 0;
    var bl9 = b9 & 0x1fff;
    var bh9 = b9 >>> 13;
    out.negative = self.negative ^ num.negative;
    out.length = 19;
    /* k = 0 */

    lo = Math.imul(al0, bl0);
    mid = Math.imul(al0, bh0);
    mid = mid + Math.imul(ah0, bl0) | 0;
    hi = Math.imul(ah0, bh0);
    var w0 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w0 >>> 26) | 0;
    w0 &= 0x3ffffff;
    /* k = 1 */

    lo = Math.imul(al1, bl0);
    mid = Math.imul(al1, bh0);
    mid = mid + Math.imul(ah1, bl0) | 0;
    hi = Math.imul(ah1, bh0);
    lo = lo + Math.imul(al0, bl1) | 0;
    mid = mid + Math.imul(al0, bh1) | 0;
    mid = mid + Math.imul(ah0, bl1) | 0;
    hi = hi + Math.imul(ah0, bh1) | 0;
    var w1 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w1 >>> 26) | 0;
    w1 &= 0x3ffffff;
    /* k = 2 */

    lo = Math.imul(al2, bl0);
    mid = Math.imul(al2, bh0);
    mid = mid + Math.imul(ah2, bl0) | 0;
    hi = Math.imul(ah2, bh0);
    lo = lo + Math.imul(al1, bl1) | 0;
    mid = mid + Math.imul(al1, bh1) | 0;
    mid = mid + Math.imul(ah1, bl1) | 0;
    hi = hi + Math.imul(ah1, bh1) | 0;
    lo = lo + Math.imul(al0, bl2) | 0;
    mid = mid + Math.imul(al0, bh2) | 0;
    mid = mid + Math.imul(ah0, bl2) | 0;
    hi = hi + Math.imul(ah0, bh2) | 0;
    var w2 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w2 >>> 26) | 0;
    w2 &= 0x3ffffff;
    /* k = 3 */

    lo = Math.imul(al3, bl0);
    mid = Math.imul(al3, bh0);
    mid = mid + Math.imul(ah3, bl0) | 0;
    hi = Math.imul(ah3, bh0);
    lo = lo + Math.imul(al2, bl1) | 0;
    mid = mid + Math.imul(al2, bh1) | 0;
    mid = mid + Math.imul(ah2, bl1) | 0;
    hi = hi + Math.imul(ah2, bh1) | 0;
    lo = lo + Math.imul(al1, bl2) | 0;
    mid = mid + Math.imul(al1, bh2) | 0;
    mid = mid + Math.imul(ah1, bl2) | 0;
    hi = hi + Math.imul(ah1, bh2) | 0;
    lo = lo + Math.imul(al0, bl3) | 0;
    mid = mid + Math.imul(al0, bh3) | 0;
    mid = mid + Math.imul(ah0, bl3) | 0;
    hi = hi + Math.imul(ah0, bh3) | 0;
    var w3 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w3 >>> 26) | 0;
    w3 &= 0x3ffffff;
    /* k = 4 */

    lo = Math.imul(al4, bl0);
    mid = Math.imul(al4, bh0);
    mid = mid + Math.imul(ah4, bl0) | 0;
    hi = Math.imul(ah4, bh0);
    lo = lo + Math.imul(al3, bl1) | 0;
    mid = mid + Math.imul(al3, bh1) | 0;
    mid = mid + Math.imul(ah3, bl1) | 0;
    hi = hi + Math.imul(ah3, bh1) | 0;
    lo = lo + Math.imul(al2, bl2) | 0;
    mid = mid + Math.imul(al2, bh2) | 0;
    mid = mid + Math.imul(ah2, bl2) | 0;
    hi = hi + Math.imul(ah2, bh2) | 0;
    lo = lo + Math.imul(al1, bl3) | 0;
    mid = mid + Math.imul(al1, bh3) | 0;
    mid = mid + Math.imul(ah1, bl3) | 0;
    hi = hi + Math.imul(ah1, bh3) | 0;
    lo = lo + Math.imul(al0, bl4) | 0;
    mid = mid + Math.imul(al0, bh4) | 0;
    mid = mid + Math.imul(ah0, bl4) | 0;
    hi = hi + Math.imul(ah0, bh4) | 0;
    var w4 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w4 >>> 26) | 0;
    w4 &= 0x3ffffff;
    /* k = 5 */

    lo = Math.imul(al5, bl0);
    mid = Math.imul(al5, bh0);
    mid = mid + Math.imul(ah5, bl0) | 0;
    hi = Math.imul(ah5, bh0);
    lo = lo + Math.imul(al4, bl1) | 0;
    mid = mid + Math.imul(al4, bh1) | 0;
    mid = mid + Math.imul(ah4, bl1) | 0;
    hi = hi + Math.imul(ah4, bh1) | 0;
    lo = lo + Math.imul(al3, bl2) | 0;
    mid = mid + Math.imul(al3, bh2) | 0;
    mid = mid + Math.imul(ah3, bl2) | 0;
    hi = hi + Math.imul(ah3, bh2) | 0;
    lo = lo + Math.imul(al2, bl3) | 0;
    mid = mid + Math.imul(al2, bh3) | 0;
    mid = mid + Math.imul(ah2, bl3) | 0;
    hi = hi + Math.imul(ah2, bh3) | 0;
    lo = lo + Math.imul(al1, bl4) | 0;
    mid = mid + Math.imul(al1, bh4) | 0;
    mid = mid + Math.imul(ah1, bl4) | 0;
    hi = hi + Math.imul(ah1, bh4) | 0;
    lo = lo + Math.imul(al0, bl5) | 0;
    mid = mid + Math.imul(al0, bh5) | 0;
    mid = mid + Math.imul(ah0, bl5) | 0;
    hi = hi + Math.imul(ah0, bh5) | 0;
    var w5 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w5 >>> 26) | 0;
    w5 &= 0x3ffffff;
    /* k = 6 */

    lo = Math.imul(al6, bl0);
    mid = Math.imul(al6, bh0);
    mid = mid + Math.imul(ah6, bl0) | 0;
    hi = Math.imul(ah6, bh0);
    lo = lo + Math.imul(al5, bl1) | 0;
    mid = mid + Math.imul(al5, bh1) | 0;
    mid = mid + Math.imul(ah5, bl1) | 0;
    hi = hi + Math.imul(ah5, bh1) | 0;
    lo = lo + Math.imul(al4, bl2) | 0;
    mid = mid + Math.imul(al4, bh2) | 0;
    mid = mid + Math.imul(ah4, bl2) | 0;
    hi = hi + Math.imul(ah4, bh2) | 0;
    lo = lo + Math.imul(al3, bl3) | 0;
    mid = mid + Math.imul(al3, bh3) | 0;
    mid = mid + Math.imul(ah3, bl3) | 0;
    hi = hi + Math.imul(ah3, bh3) | 0;
    lo = lo + Math.imul(al2, bl4) | 0;
    mid = mid + Math.imul(al2, bh4) | 0;
    mid = mid + Math.imul(ah2, bl4) | 0;
    hi = hi + Math.imul(ah2, bh4) | 0;
    lo = lo + Math.imul(al1, bl5) | 0;
    mid = mid + Math.imul(al1, bh5) | 0;
    mid = mid + Math.imul(ah1, bl5) | 0;
    hi = hi + Math.imul(ah1, bh5) | 0;
    lo = lo + Math.imul(al0, bl6) | 0;
    mid = mid + Math.imul(al0, bh6) | 0;
    mid = mid + Math.imul(ah0, bl6) | 0;
    hi = hi + Math.imul(ah0, bh6) | 0;
    var w6 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w6 >>> 26) | 0;
    w6 &= 0x3ffffff;
    /* k = 7 */

    lo = Math.imul(al7, bl0);
    mid = Math.imul(al7, bh0);
    mid = mid + Math.imul(ah7, bl0) | 0;
    hi = Math.imul(ah7, bh0);
    lo = lo + Math.imul(al6, bl1) | 0;
    mid = mid + Math.imul(al6, bh1) | 0;
    mid = mid + Math.imul(ah6, bl1) | 0;
    hi = hi + Math.imul(ah6, bh1) | 0;
    lo = lo + Math.imul(al5, bl2) | 0;
    mid = mid + Math.imul(al5, bh2) | 0;
    mid = mid + Math.imul(ah5, bl2) | 0;
    hi = hi + Math.imul(ah5, bh2) | 0;
    lo = lo + Math.imul(al4, bl3) | 0;
    mid = mid + Math.imul(al4, bh3) | 0;
    mid = mid + Math.imul(ah4, bl3) | 0;
    hi = hi + Math.imul(ah4, bh3) | 0;
    lo = lo + Math.imul(al3, bl4) | 0;
    mid = mid + Math.imul(al3, bh4) | 0;
    mid = mid + Math.imul(ah3, bl4) | 0;
    hi = hi + Math.imul(ah3, bh4) | 0;
    lo = lo + Math.imul(al2, bl5) | 0;
    mid = mid + Math.imul(al2, bh5) | 0;
    mid = mid + Math.imul(ah2, bl5) | 0;
    hi = hi + Math.imul(ah2, bh5) | 0;
    lo = lo + Math.imul(al1, bl6) | 0;
    mid = mid + Math.imul(al1, bh6) | 0;
    mid = mid + Math.imul(ah1, bl6) | 0;
    hi = hi + Math.imul(ah1, bh6) | 0;
    lo = lo + Math.imul(al0, bl7) | 0;
    mid = mid + Math.imul(al0, bh7) | 0;
    mid = mid + Math.imul(ah0, bl7) | 0;
    hi = hi + Math.imul(ah0, bh7) | 0;
    var w7 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w7 >>> 26) | 0;
    w7 &= 0x3ffffff;
    /* k = 8 */

    lo = Math.imul(al8, bl0);
    mid = Math.imul(al8, bh0);
    mid = mid + Math.imul(ah8, bl0) | 0;
    hi = Math.imul(ah8, bh0);
    lo = lo + Math.imul(al7, bl1) | 0;
    mid = mid + Math.imul(al7, bh1) | 0;
    mid = mid + Math.imul(ah7, bl1) | 0;
    hi = hi + Math.imul(ah7, bh1) | 0;
    lo = lo + Math.imul(al6, bl2) | 0;
    mid = mid + Math.imul(al6, bh2) | 0;
    mid = mid + Math.imul(ah6, bl2) | 0;
    hi = hi + Math.imul(ah6, bh2) | 0;
    lo = lo + Math.imul(al5, bl3) | 0;
    mid = mid + Math.imul(al5, bh3) | 0;
    mid = mid + Math.imul(ah5, bl3) | 0;
    hi = hi + Math.imul(ah5, bh3) | 0;
    lo = lo + Math.imul(al4, bl4) | 0;
    mid = mid + Math.imul(al4, bh4) | 0;
    mid = mid + Math.imul(ah4, bl4) | 0;
    hi = hi + Math.imul(ah4, bh4) | 0;
    lo = lo + Math.imul(al3, bl5) | 0;
    mid = mid + Math.imul(al3, bh5) | 0;
    mid = mid + Math.imul(ah3, bl5) | 0;
    hi = hi + Math.imul(ah3, bh5) | 0;
    lo = lo + Math.imul(al2, bl6) | 0;
    mid = mid + Math.imul(al2, bh6) | 0;
    mid = mid + Math.imul(ah2, bl6) | 0;
    hi = hi + Math.imul(ah2, bh6) | 0;
    lo = lo + Math.imul(al1, bl7) | 0;
    mid = mid + Math.imul(al1, bh7) | 0;
    mid = mid + Math.imul(ah1, bl7) | 0;
    hi = hi + Math.imul(ah1, bh7) | 0;
    lo = lo + Math.imul(al0, bl8) | 0;
    mid = mid + Math.imul(al0, bh8) | 0;
    mid = mid + Math.imul(ah0, bl8) | 0;
    hi = hi + Math.imul(ah0, bh8) | 0;
    var w8 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w8 >>> 26) | 0;
    w8 &= 0x3ffffff;
    /* k = 9 */

    lo = Math.imul(al9, bl0);
    mid = Math.imul(al9, bh0);
    mid = mid + Math.imul(ah9, bl0) | 0;
    hi = Math.imul(ah9, bh0);
    lo = lo + Math.imul(al8, bl1) | 0;
    mid = mid + Math.imul(al8, bh1) | 0;
    mid = mid + Math.imul(ah8, bl1) | 0;
    hi = hi + Math.imul(ah8, bh1) | 0;
    lo = lo + Math.imul(al7, bl2) | 0;
    mid = mid + Math.imul(al7, bh2) | 0;
    mid = mid + Math.imul(ah7, bl2) | 0;
    hi = hi + Math.imul(ah7, bh2) | 0;
    lo = lo + Math.imul(al6, bl3) | 0;
    mid = mid + Math.imul(al6, bh3) | 0;
    mid = mid + Math.imul(ah6, bl3) | 0;
    hi = hi + Math.imul(ah6, bh3) | 0;
    lo = lo + Math.imul(al5, bl4) | 0;
    mid = mid + Math.imul(al5, bh4) | 0;
    mid = mid + Math.imul(ah5, bl4) | 0;
    hi = hi + Math.imul(ah5, bh4) | 0;
    lo = lo + Math.imul(al4, bl5) | 0;
    mid = mid + Math.imul(al4, bh5) | 0;
    mid = mid + Math.imul(ah4, bl5) | 0;
    hi = hi + Math.imul(ah4, bh5) | 0;
    lo = lo + Math.imul(al3, bl6) | 0;
    mid = mid + Math.imul(al3, bh6) | 0;
    mid = mid + Math.imul(ah3, bl6) | 0;
    hi = hi + Math.imul(ah3, bh6) | 0;
    lo = lo + Math.imul(al2, bl7) | 0;
    mid = mid + Math.imul(al2, bh7) | 0;
    mid = mid + Math.imul(ah2, bl7) | 0;
    hi = hi + Math.imul(ah2, bh7) | 0;
    lo = lo + Math.imul(al1, bl8) | 0;
    mid = mid + Math.imul(al1, bh8) | 0;
    mid = mid + Math.imul(ah1, bl8) | 0;
    hi = hi + Math.imul(ah1, bh8) | 0;
    lo = lo + Math.imul(al0, bl9) | 0;
    mid = mid + Math.imul(al0, bh9) | 0;
    mid = mid + Math.imul(ah0, bl9) | 0;
    hi = hi + Math.imul(ah0, bh9) | 0;
    var w9 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w9 >>> 26) | 0;
    w9 &= 0x3ffffff;
    /* k = 10 */

    lo = Math.imul(al9, bl1);
    mid = Math.imul(al9, bh1);
    mid = mid + Math.imul(ah9, bl1) | 0;
    hi = Math.imul(ah9, bh1);
    lo = lo + Math.imul(al8, bl2) | 0;
    mid = mid + Math.imul(al8, bh2) | 0;
    mid = mid + Math.imul(ah8, bl2) | 0;
    hi = hi + Math.imul(ah8, bh2) | 0;
    lo = lo + Math.imul(al7, bl3) | 0;
    mid = mid + Math.imul(al7, bh3) | 0;
    mid = mid + Math.imul(ah7, bl3) | 0;
    hi = hi + Math.imul(ah7, bh3) | 0;
    lo = lo + Math.imul(al6, bl4) | 0;
    mid = mid + Math.imul(al6, bh4) | 0;
    mid = mid + Math.imul(ah6, bl4) | 0;
    hi = hi + Math.imul(ah6, bh4) | 0;
    lo = lo + Math.imul(al5, bl5) | 0;
    mid = mid + Math.imul(al5, bh5) | 0;
    mid = mid + Math.imul(ah5, bl5) | 0;
    hi = hi + Math.imul(ah5, bh5) | 0;
    lo = lo + Math.imul(al4, bl6) | 0;
    mid = mid + Math.imul(al4, bh6) | 0;
    mid = mid + Math.imul(ah4, bl6) | 0;
    hi = hi + Math.imul(ah4, bh6) | 0;
    lo = lo + Math.imul(al3, bl7) | 0;
    mid = mid + Math.imul(al3, bh7) | 0;
    mid = mid + Math.imul(ah3, bl7) | 0;
    hi = hi + Math.imul(ah3, bh7) | 0;
    lo = lo + Math.imul(al2, bl8) | 0;
    mid = mid + Math.imul(al2, bh8) | 0;
    mid = mid + Math.imul(ah2, bl8) | 0;
    hi = hi + Math.imul(ah2, bh8) | 0;
    lo = lo + Math.imul(al1, bl9) | 0;
    mid = mid + Math.imul(al1, bh9) | 0;
    mid = mid + Math.imul(ah1, bl9) | 0;
    hi = hi + Math.imul(ah1, bh9) | 0;
    var w10 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w10 >>> 26) | 0;
    w10 &= 0x3ffffff;
    /* k = 11 */

    lo = Math.imul(al9, bl2);
    mid = Math.imul(al9, bh2);
    mid = mid + Math.imul(ah9, bl2) | 0;
    hi = Math.imul(ah9, bh2);
    lo = lo + Math.imul(al8, bl3) | 0;
    mid = mid + Math.imul(al8, bh3) | 0;
    mid = mid + Math.imul(ah8, bl3) | 0;
    hi = hi + Math.imul(ah8, bh3) | 0;
    lo = lo + Math.imul(al7, bl4) | 0;
    mid = mid + Math.imul(al7, bh4) | 0;
    mid = mid + Math.imul(ah7, bl4) | 0;
    hi = hi + Math.imul(ah7, bh4) | 0;
    lo = lo + Math.imul(al6, bl5) | 0;
    mid = mid + Math.imul(al6, bh5) | 0;
    mid = mid + Math.imul(ah6, bl5) | 0;
    hi = hi + Math.imul(ah6, bh5) | 0;
    lo = lo + Math.imul(al5, bl6) | 0;
    mid = mid + Math.imul(al5, bh6) | 0;
    mid = mid + Math.imul(ah5, bl6) | 0;
    hi = hi + Math.imul(ah5, bh6) | 0;
    lo = lo + Math.imul(al4, bl7) | 0;
    mid = mid + Math.imul(al4, bh7) | 0;
    mid = mid + Math.imul(ah4, bl7) | 0;
    hi = hi + Math.imul(ah4, bh7) | 0;
    lo = lo + Math.imul(al3, bl8) | 0;
    mid = mid + Math.imul(al3, bh8) | 0;
    mid = mid + Math.imul(ah3, bl8) | 0;
    hi = hi + Math.imul(ah3, bh8) | 0;
    lo = lo + Math.imul(al2, bl9) | 0;
    mid = mid + Math.imul(al2, bh9) | 0;
    mid = mid + Math.imul(ah2, bl9) | 0;
    hi = hi + Math.imul(ah2, bh9) | 0;
    var w11 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w11 >>> 26) | 0;
    w11 &= 0x3ffffff;
    /* k = 12 */

    lo = Math.imul(al9, bl3);
    mid = Math.imul(al9, bh3);
    mid = mid + Math.imul(ah9, bl3) | 0;
    hi = Math.imul(ah9, bh3);
    lo = lo + Math.imul(al8, bl4) | 0;
    mid = mid + Math.imul(al8, bh4) | 0;
    mid = mid + Math.imul(ah8, bl4) | 0;
    hi = hi + Math.imul(ah8, bh4) | 0;
    lo = lo + Math.imul(al7, bl5) | 0;
    mid = mid + Math.imul(al7, bh5) | 0;
    mid = mid + Math.imul(ah7, bl5) | 0;
    hi = hi + Math.imul(ah7, bh5) | 0;
    lo = lo + Math.imul(al6, bl6) | 0;
    mid = mid + Math.imul(al6, bh6) | 0;
    mid = mid + Math.imul(ah6, bl6) | 0;
    hi = hi + Math.imul(ah6, bh6) | 0;
    lo = lo + Math.imul(al5, bl7) | 0;
    mid = mid + Math.imul(al5, bh7) | 0;
    mid = mid + Math.imul(ah5, bl7) | 0;
    hi = hi + Math.imul(ah5, bh7) | 0;
    lo = lo + Math.imul(al4, bl8) | 0;
    mid = mid + Math.imul(al4, bh8) | 0;
    mid = mid + Math.imul(ah4, bl8) | 0;
    hi = hi + Math.imul(ah4, bh8) | 0;
    lo = lo + Math.imul(al3, bl9) | 0;
    mid = mid + Math.imul(al3, bh9) | 0;
    mid = mid + Math.imul(ah3, bl9) | 0;
    hi = hi + Math.imul(ah3, bh9) | 0;
    var w12 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
    c = (hi + (mid >>> 13) | 0) + (w12 >>> 26) | 0;
    w12 &= 0x3ffffff;
    /* k = 13 */

    lo = Math.imul(al9, bl4);
    mid = Math.imul(al9, bh4);
    mid = mid + Math.imul(ah9, bl4) | 0;
    hi = Math.imul(ah9, bh4);
    lo = lo + Math.imul(al8, bl5) | 0;
    mid = mid + Math.imul(al8, bh5) | 0;
    mid = mid + Math.imul(ah8, bl5) | 0;
    hi = hi + Math.imul(ah8, bh5) | 0;
    lo = lo + Math.imul(al7, bl6) | 0;
    mid = mid + Math.imul(al7, bh6) | 0;
    mid = mid + Math.imul(ah7, bl6) | 0;
    hi = hi + Math.imul(ah7, bh6) | 0;
    lo = lo + Math.imul(al6, bl7) | 0;
    mid = mid + Math.imul(al6, bh7) | 0;
    mid = mid + Math.imul(ah6, bl7) | 0;
    hi = 