import { configureStore, UnknownAction, ThunkAction, ThunkDispatch, Middleware } from '@reduxjs/toolkit';
import listenerMiddleware from '@/store/listeners';
import coinReducer, { CoinState } from '@/store/features/coin';
import fundReducer, { FundState } from '@/store/features/fund';
import quotationReducer, { QuotationState } from '@/store/features/quotation';
import settingReducer, { SettingState } from '@/store/features/setting';
import sortReducer, { SortState } from '@/store/features/sort';
import stockReducer, { StockState } from '@/store/features/stock';
import tabsReducer, { TabsState } from '@/store/features/tabs';
import updaterReducer, { UpdaderState } from '@/store/features/updater';
import walletReducer, { WalletState } from '@/store/features/wallet';
import webReducer, { WebState } from '@/store/features/web';
import zindexReducer, { ZindexState } from '@/store/features/zindex';
import translateReducer, { TranslateState } from '@/store/features/translate';
import chatGPTReducer, { ChatGPTState } from '@/store/features/chatGPT';

const { production } = window.contextModules.process;

const middleware: Middleware[] = [listenerMiddleware.middleware];

if (!production) {
  // middleware.push(logger);
}

const store = configureStore({
  reducer: {
    coin: coinReducer,
    fund: fundReducer,
    quotation: quotationReducer,
    setting: settingReducer,
    sort: sortReducer,
    stock: stockReducer,
    tabs: tabsReducer,
    updater: updaterReducer,
    wallet: walletReducer,
    web: webReducer,
    zindex: zindexReducer,
    translate: translateReducer,
    chatGPT: chatGPTReducer,
  },
  middleware: (getDefaultMiddleware) => getDefaultMiddleware().concat(middleware),
  devTools: !production,
});

/* Types */
export type StoreState = {
  wallet: WalletState;
  tabs: TabsState;
  updater: UpdaderState;
  fund: FundState;
  zindex: ZindexState;
  quotation: QuotationState;
  stock: StockState;
  setting: SettingState;
  sort: SortState;
  coin: CoinState;
  web: WebState;
  translate: TranslateState;
  chatGPT: ChatGPTState;
};

export type AppDispatch = typeof store.dispatch;
export type TypedDispatch = ThunkDispatch<StoreState, any, UnknownAction>;
export type TypedThunk<ReturnType = void> = ThunkAction<ReturnType, StoreState, unknown, UnknownAction>;
export type AsyncThunkConfig = {
  /** return type for `thunkApi.getState` */
  state: StoreState;
  /** type for `thunkApi.dispatch` */
  dispatch?: AppDispatch;
  /** type of the `extra` argument for the thunk middleware, which will be passed in as `thunkApi.extra` */
  extra?: unknown;
  /** type to be passed into `rejectWithValue`'s first argument that will end up on `rejectedAction.payload` */
  rejectValue?: unknown;
  /** return type of the `serializeError` option callback */
  serializedErrorType?: unknown;
  /** type to be returned from the `getPendingMeta` option callback & merged into `pendingAction.meta` */
  pendingMeta?: unknown;
  /** type to be passed into the second argument of `fulfillWithValue` to finally be merged into `fulfilledAction.meta` */
  fulfilledMeta?: unknown;
  /** type to be passed into the second argument of `rejectWithValue` to finally be merged into `rejectedAction.meta` */
  rejectedMeta?: unknown;
};
export interface ShareAction extends UnknownAction {
  readonly _share?: boolean;
  payload: any;
}

export default store;
