'use strict';

module.exports = function(ngModule) {
  ngModule.controller('sectionAppInfoController', function(
    $scope,
    stateService,
    responsesService,
    validationService
  ) {
    'ngInject';
    'use strict';

    $scope.formData = stateService.formData;
    $scope.validate = validationService.getValidationErrors;
    $scope.showAllHelp = {
      status: false,
      category:''
    };

    if (!$scope.formData.establishmentTypeId) {
      $scope.formData.establishmentTypeId = [];
    }

    // multiple choice responses
    let questionKeys = ['ApplicationType', 'EstablishmentType'];
    responsesService.getQuestionResponses(questionKeys).then(responses => {
      $scope.responses = responses;
    });

    $scope.vm = this;

    this.toggleEstablishmentType = function(id) {
      let index = $scope.formData.establishmentTypeId.indexOf(id);
      if (index > -1) {
        $scope.formData.establishmentTypeId.splice(index, 1);
      } else {
        $scope.formData.establishmentTypeId.push(id);
      }
    };

    this.toggleAllHelpText = function(event) {
      $scope.showAllHelp.status = !$scope.showAllHelp.status;
      $scope.showAllHelp.category = event.srcElement.id;
    }
  });
};
