﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Microsoft.AspNet.Identity;
using DOL.WHD.Section14c.Common;

namespace DOL.WHD.Section14c.DataAccess.Validators
{
    public class Section14cPasswordValidator : PasswordValidator
    {
        public bool RequireZxcvbn { get; set; }

        public override async Task<IdentityResult> ValidateAsync(string item)
        {
            var result = await base.ValidateAsync(item);
            var passwordComplexityScore = AppSettings.Get<int>("PasswordComplexityScore");
            if (RequireZxcvbn)
            {
                var errors = new List<string>(result.Errors);
                var zxcvbnResult = Zxcvbn.Zxcvbn.MatchPassword(item);
                if (zxcvbnResult.Score < passwordComplexityScore)
                {
                    errors.Add("Password does not meet complexity requirements.");
                }

                result = errors.Count <= 0 ? IdentityResult.Success : IdentityResult.Failed(errors.ToArray());
            }

            return result;
        }
    }
}
