﻿using System.Data.Entity;
using System.Linq;
using System.Threading.Tasks;
using DOL.WHD.Section14c.Domain.Models.Submission;
using System.Collections.Generic;

namespace DOL.WHD.Section14c.DataAccess.Repositories
{
    public class ApplicationRepository : IApplicationRepository
    {
        private readonly ApplicationDbContext _dbContext;
        private bool Disposed = false;

        public ApplicationRepository()
        {
            _dbContext = new ApplicationDbContext();
        }

        public IEnumerable<ApplicationSubmission> Get()
        {
            //explicitly loading related entities 
            return _dbContext.ApplicationSubmissions
                        .Include(a => a.ApplicationType).Include(a => a.PayType)
                        .Include(a => a.PieceRateWageInfo.Attachment).Include(a => a.PieceRateWageInfo.PrevailingWageMethod)
                        .Include(a => a.HourlyWageInfo.MostRecentPrevailingWageSurvey.Attachment).Include(a => a.HourlyWageInfo.Attachment).Include(a => a.HourlyWageInfo.PrevailingWageMethod)
                        .Include(a => a.Employer.EmployerStatus).Include(a => a.Employer.SCA) .Include(a => a.Employer.EO13658)
                        .AsQueryable();
}

        public async Task<int> AddAsync(ApplicationSubmission submission)
        {
            _dbContext.ApplicationSubmissions.Add(submission);
            return await SaveChangesAsync();
        }

        public async Task<int> ModifyApplication(ApplicationSubmission submission)
        {
            _dbContext.Entry(submission).State = EntityState.Modified;
            return await SaveChangesAsync();
        }

        public Task<int> SaveChangesAsync()
        {
            return _dbContext.SaveChangesAsync();
        }

        public void Dispose()
        {
            Dispose(true);
            System.GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!Disposed && disposing)
            {
                _dbContext.Dispose();
            }
        }
    }
}
