[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

This is a list of Information Security resources and tools I've found useful at some time during my study of security and I hope that others will too. 

This list is will be updated whenever I've found something awesome to add.

<img src="http://edwardqiu.com/images/blog/itsalive.gif"/>

### Contents
- [Recon](#recon)
- [Web](#web)
- [Vulnerable Web Applications](#vulnerable-web-applications)
- [Linux](#linux)
- [Exploit Development](#exploit-development)
- [Cryptography](#cryptography)
- [Privilege Escalation](#privilege-escalation)
- [Scripting](#scripting)
- [Courses](#courses)
- [Labs](#labs)
- [CTF](#ctf)
- [Wargames](#wargames)
- [OSCP](#oscp)
- [Penetration Testing](#penetration-testing)
- [Binary Exploitation](#binary-exploitation)
- [Reverse Engineering](#reverse-engineering)
- [Malware Samples](#malware-samples)
- [Bug Bounty](#bug-bounty)
- [Hacker Blogs](#hacker-blogs)
- [Controls](#controls)

### Recon
- [DNS Dumpster](https://dnsdumpster.com/)
- [SecLists](https://github.com/jhaddix/SecLists)
- [Sublist3r](https://github.com/aboul3la/Sublist3r)
- [Subfinder](https://github.com/subfinder/subfinder)
- [Amass](https://github.com/OWASP/Amass)
- [httprobe](https://github.com/tomnomnom/httprobe)
- [dirsearch](https://github.com/maurosoria/dirsearch)
- [webscreenshot](https://github.com/maaaaz/webscreenshot)
- [cc.py](https://github.com/si9int/cc.py)
- [@ITSecurityguard Visual Recon Guide](https://blog.it-securityguard.com/visual-recon-a-beginners-guide/)

### Web
- [Web Application Hacker’s Handbook 2nd Edition](http://mdsec.net/wahh/toc2e.html)
- [The Tangled Web](https://nostarch.com/tangledweb)
- [OWASP Top 10 - 2017](https://www.owasp.org/images/7/72/OWASP_Top_10-2017_%28en%29.pdf.pdf)
- [OWASP Top 10 - 2013](https://www.owasp.org/images/f/f8/OWASP_Top_10_-_2013.pdf)
- [Portswigger Web Security Blog](https://portswigger.net/blog)
- [detectify Web Security Blog](https://blog.detectify.com/category/web-security/)
- [HTTP Status Codes](https://httpstatuses.com/)
- [Dave Kukfa - Web Application Cheat Sheet](https://kukfa.co/resources/web-application-cheat-sheet/)

### Vulnerable Web Applications
- [Damn Vulnerable Web Application (DVWA)](http://www.dvwa.co.uk/)
- [OWASP Mutillidae 2](https://www.owasp.org/index.php/OWASP_Mutillidae_2_Project)
- [OWASP WebGoat](https://www.owasp.org/index.php/Category:OWASP_WebGoat_Project)
- [Rapid7 Hackazon](https://github.com/rapid7/hackazon)
- [Google Gruyere](https://google-gruyere.appspot.com/)

### Linux
- [Linux Journey](https://linuxjourney.com/)

### Exploit Development
- [Exploit Exercises](https://exploit-exercises.com/)
- [LiveOverflow - Binary Hacking Playlist](http://liveoverflow.com/binary_hacking/index.html)

### Cryptography
- [A Stick Figure Guide to AES](http://www.moserware.com/2009/09/stick-figure-guide-to-advanced.html)
- [Cryptopals Challenges](https://cryptopals.com/)
- [The Manga Guide to Cryptography](https://books.google.com/books/about/The_Manga_Guide_to_Cryptography.html?id=mrgrDwAAQBAJ&printsec=frontcover&source=kp_read_button#v=onepage&q&f=false)
- [Crypto 101](https://www.crypto101.io/)

### Privilege Escalation
- [g0tmi1k's Basic Linux Privilege Escalation](https://blog.g0tmi1k.com/2011/08/basic-linux-privilege-escalation/)
- [unix-privesc-check](https://github.com/pentestmonkey/unix-privesc-check)

### Scripting
- [Shell Scripting Tutorial](https://www.shellscript.sh)
- [Bash Academy](https://guide.bash.academy/)

### Courses
- [OSCP](https://www.offensive-security.com/information-security-certifications/oscp-offensive-security-certified-professional/)
- [Hacker101](https://www.hacker101.com)
- [Bugcrowd University](https://github.com/bugcrowd/bugcrowd_university)
- [Cybrary](https://www.cybrary.it/)
- [Pluralsight - Information and Cyber Security](https://www.pluralsight.com/browse/information-cyber-security)

### Labs
- [PentesterLab](https://pentesterlab.com/referral/-MCa2tgjacaaaQ)
- [Hack The Box](https://www.hackthebox.eu)
- [AttackDefense Labs](https://attackdefense.com/)
- [VulnHub](https://www.vulnhub.com/)

### CTF
- [Hacker101 CTF](https://ctf.hacker101.com/)
- [PicoCTF](https://picoctf.com/)
- [Google CTF](https://capturetheflag.withgoogle.com)
- [CTF Time](https://ctftime.org/)

### Wargames
- [OverTheWire](http://overthewire.org/wargames/)
- [SmashTheStack](http://smashthestack.org/wargames.html)
- [HackThisSite](https://www.hackthissite.org/)

### OSCP
- [Jeremy Chisamore's Zero to OSCP in 292 Days](https://blog.mallardlabs.com/zero-to-oscp-in-292-days-or-how-i-accidentally-the-whole-thing-part-2/)
- [Tulpa Security - Prep Guide for Offsec's PWK](https://tulpa-security.com/2016/09/19/prep-guide-for-offsecs-pwk/)

### Penetration Testing
- [Penetration Testing - A Systematic Approach](https://infosecwriters.com/Papers/MSaindane_Pentest.pdf)
- [The Red Team Field Manual (RTFM)](https://doc.lagout.org/rtfm-red-team-field-manual.pdf)
- [The Hacker Playbook](https://www.amazon.com/Hacker-Playbook-Practical-Penetration-Testing/dp/1980901759/ref=pd_lpo_sbs_14_t_0?_encoding=UTF8&psc=1&refRID=RXPDZKDEYEJRQZ48YMYQ)
- [IppSec - Hack The Box Walkthrough Videos](https://www.youtube.com/channel/UCa6eh7gCkpPo5XXUDfygQQA)

### Binary Exploitation
- [Pwnable.tw](https://pwnable.tw/)
- [Pwnable.kr](http://pwnable.kr/)
- [Exploit-Exercises](https://exploit-exercises.com)

### Reverse Engineering
- [malwareunicorn - How to start reverse engineering malware](http://amanda.secured.org/how-to-start-reverse-engineering-malware/)
- [malwareunicorn - RE101](https://securedorg.github.io/RE101/)
- [Ophir Harpaz - Reverse Engineering for Beginners](https://www.begin.re/)
- [Reversing.Kr](http://reversing.kr)

### Malware Samples
- [VirusBay](https://beta.virusbay.io/)
- [contagio malware dump](http://contagiodump.blogspot.com/)
- [VirusShare](https://virusshare.com/)
- [Malware.lu](https://malware.lu/)
- [MalShare](http://www.malshare.com/)

### Bug Bounty
- [Bug Bounty Forum](https://bugbountyforum.com/)
- [Bug Bounty World](https://bugbountyworld.com/)
- [Bug Bounty Notes](https://www.bugbountynotes.com/)
- [Pentester Land - List of bug bounty writeups](https://pentester.land/list-of-bug-bounty-writeups.html)
- [FireBounty](https://firebounty.com/)
- [Improving your reports - Google Bughunter University](https://sites.google.com/site/bughunteruniversity/improve)
- [Facebook Bounty Hunter's Guide](https://www.facebook.com/notes/facebook-bug-bounty/a-bounty-hunters-guide-to-facebook/946955115318715)
- [Breaking into Information Security: Learning the Ropes 101](https://leanpub.com/ltr101-breaking-into-infosec)
- [Web Hacking 101](https://leanpub.com/web-hacking-101)
- [jhaddix - The Bug Hunters Methodology](https://github.com/jhaddix/tbhm)

### Hacker Blogs
- [zseano](https://zseano.com/index.html)
- [Alyssa Herrera](https://medium.com/@alyssa.o.herrera)
- [Jonathan Bouman](https://medium.com/@jonathanbouman)
- [LiveOverflow](https://www.youtube.com/channel/UClcE-kVhqyiHCcjYwcpfj9w)

### Controls
- [SANS CIS Top 20](https://www.sans.org/security-resources/posters/20-critical-security-controls/55/download)
