# ghidra-scripts
[![](https://img.shields.io/github/stars/0xdea/ghidra-scripts.svg?style=flat&color=yellow)](https://github.com/0xdea/ghidra-scripts)
[![](https://img.shields.io/github/forks/0xdea/ghidra-scripts.svg?style=flat&color=green)](https://github.com/0xdea/ghidra-scripts)
[![](https://img.shields.io/github/watchers/0xdea/ghidra-scripts.svg?style=flat&color=red)](https://github.com/0xdea/ghidra-scripts)
[![](https://img.shields.io/badge/twitter-%400xdea-blue.svg)](https://twitter.com/0xdea)
[![](https://img.shields.io/badge/mastodon-%40raptor-purple.svg)](https://infosec.exchange/@raptor)

> "Humans are more suited to recognize food than to keep large graphs in their head."
>
> -- Halvar Flake

A collection of my Ghidra scripts to facilitate reverse engineering and vulnerability research.

Blog post: https://security.humanativaspa.it/automating-binary-vulnerability-discovery-with-ghidra-and-semgrep/

See also: https://github.com/federicodotta/ghidra-scripts

## VulnDev
* [**Rhabdomancer.java**](https://github.com/0xdea/ghidra-scripts/blob/main/Rhabdomancer.java). This script locates all calls to potentially insecure functions.
* [**Haruspex.java**](https://github.com/0xdea/ghidra-scripts/blob/main/Haruspex.java). This script extracts all pseudo-code generated by the Ghidra decompiler.

## iOS
* [**FOX_alpha.java**](https://github.com/0xdea/ghidra-scripts/blob/main/FOX_alpha.java). This script tries to fix Objective-C cross-references in iOS apps.

## Analysis
* [**ResolveMipsN32LinuxSyscallsScript**](https://github.com/0xdea/ghidra-scripts/blob/main/ResolveMipsN32LinuxSyscallsScript.java). This script resolves MIPS N32 syscalls.
