# 【NO.99】Linux服务器检查性能瓶颈

## 1.**概述**

如果Linux服务器突然访问卡顿变慢，负载暴增，如何在最短时间内找出Linux性能问题所在？

通过执行以下命令，可以在1分钟内对系统资源使用情况有个大致的了解。

- uptime
- dmesg | tail
- vmstat 1
- mpstat -P ALL 1
- pidstat 1
- iostat -xz 1
- free -m
- sar -n DEV 1
- sar -n TCP,ETCP 1
- top

其中一些命令需要安装sysstat包，有一些由procps包提供。这些命令的输出，有助于快速定位性能瓶颈，检查出所有资源（CPU、内存、磁盘IO等）的利用率（utilization）、饱和度（saturation）和错误（error）度量，也就是所谓的USE方法。

下面我们来逐一介绍下这些命令，有关这些命令更多的参数和说明，请参照命令的手册。

## 2.**平均负载**

```text
uptime
```

结果

![img](https://pic4.zhimg.com/80/v2-765adaf45d13f67cde79adbc913baacf_720w.webp)

这个命令可以快速查看机器的负载情况。在Linux系统中，这些数据表示等待CPU资源的进程和阻塞在不可中断IO进程（进程状态为D）的数量。这些数据可以让我们对系统资源使用有一个宏观的了解。

命令的输出分别表示1分钟、5分钟、15分钟的平均负载情况。通过这三个数据，可以了解服务器负载是在趋于紧张还是区域缓解。如果1分钟平均负载很 高，而15分钟平均负载很低，说明服务器正在命令高负载情况，需要进一步排查CPU资源都消耗在了哪里。反之，如果15分钟平均负载很高，1分钟平均负载 较低，则有可能是CPU资源紧张时刻已经过去。

上面例子中的输出，可以看见最近1分钟的平均负载非常高，且远高于最近15分钟负载，因此我们需要继续排查当前系统中有什么进程消耗了大量的资源。可以通过下文将会介绍的vmstat、mpstat等命令进一步排查。

## 3.**系统核心指标**

```text
vmstat 1
```

结果

![img](https://pic2.zhimg.com/80/v2-55685bfcb32dd0db63144f7a62e63985_720w.webp)

vmstat 命令，每行会输出一些系统核心指标，这些指标可以让我们更详细的了解系统状态。后面跟的参数1，表示每秒输出一次统计信息，表头提示了每一列的含义，这几介绍一些和性能调优相关的列：

- r：等待在CPU资源的进程数。这个数据比平均负载更加能够体现CPU负载情况，数据中不包含等待IO的进程。如果这个数值大于机器CPU核数，那么机器的CPU资源已经饱和。
- free：系统可用内存数（以千字节为单位），如果剩余内存不足，也会导致系统性能问题。下文介绍到的free命令，可以更详细的了解系统内存的使用情况。
- si, so：交换区写入和读取的数量。如果这个数据不为0，说明系统已经在使用交换区（swap），机器物理内存已经不足。
- us, sy, id, wa, st：这些都代表了CPU时间的消耗，它们分别表示用户时间（user）、系统（内核）时间（sys）、空闲时间（idle）、IO等待时间（wait）和被偷走的时间（stolen，一般被其他虚拟机消耗）。

上述这些CPU时间，可以让我们很快了解CPU是否出于繁忙状态。

一般情况下，如果用户时间和系统时间相加非常大，CPU出于忙于执行指令。

如果IO等待时间很长，那么系统的瓶颈可能在磁盘IO。

如果大量CPU时间消耗在用户态，也就是用户应用程序消耗了CPU时间。这不一定是性能问题，需要结合r队列，一起分析。

## 4.**CPU占用情况-每个核心**

```text
mpstat -P ALL 1
```

结果

![img](https://pic1.zhimg.com/80/v2-1352123f501c3bcba8aefc1956022a5c_720w.webp)

该命令可以显示每个CPU的占用情况，如果有一个CPU占用率特别高，那么有可能是一个单线程应用程序引起的。

## 5.**CPU占用情况-每个进程**

```text
pidstat 1
```

结果

![img](https://pic1.zhimg.com/80/v2-c34442a841f5278222d85f8b3093a234_720w.webp)

pidstat命令输出进程的CPU占用率，该命令会持续输出，并且不会覆盖之前的数据，可以方便观察系统动态。

如上的输出，可以看见两个JAVA进程占用了将近1600%的CPU时间，既消耗了大约16个CPU核心的运算资源。

## 6.**磁盘IO情况**

```text
iostat -xz 1
```

结果

![img](https://pic1.zhimg.com/80/v2-74131a6753a089832902e17904f49bdc_720w.webp)

iostat命令主要用于查看机器磁盘IO情况。该命令输出的列，主要含义是：

- r/s, w/s, rkB/s, wkB/s：分别表示每秒读写次数和每秒读写数据量（千字节）。读写量过大，可能会引起性能问题。
- await：IO操作的平均等待时间，单位是毫秒。这是应用程序在和磁盘交互时，需要消耗的时间，包括IO等待和实际操作的耗时。如果这个数值过大，可能是硬件设备遇到了瓶颈或者出现故障。
- avgqu-sz：向设备发出的请求平均数量。如果这个数值大于1，可能是硬件设备已经饱和（部分前端硬件设备支持并行写入）。
- %util：设备利用率。这个数值表示设备的繁忙程度，经验值是如果超过60，可能会影响IO性能（可以参照IO操作平均等待时间）。如果到达100%，说明硬件设备已经饱和。

如果显示的是逻辑设备的数据，那么设备利用率不代表后端实际的硬件设备已经饱和。值得注意的是，即使IO性能不理想，也不一定意味这应用程序性能会不好，可以利用诸如预读取、写缓存等策略提升应用性能。

## 7.**内存情况**

```text
free -m
```

结果

![img](https://pic4.zhimg.com/80/v2-c696ca705ffe07c561315b563263c17b_720w.webp)

free命令可以查看系统内存的使用情况，-m参数表示按照兆字节展示。最后两列分别表示用于IO缓存的内存数，和用于文件系统页缓存的内存数。需 要注意的是，第二行-/+ buffers/cache，看上去缓存占用了大量内存空间。这是Linux系统的内存使用策略，尽可能的利用内存，如果应用程序需要内存，这部分内存会 立即被回收并分配给应用程序。因此，这部分内存一般也被当成是可用内存。

如果可用内存非常少，系统可能会动用交换区（如果配置了的话），这样会增加IO开销（可以在iostat命令中提现），降低系统性能。

## **8.网络设备的吞吐率**

```text
sar -n DEV 1
```

结果

![img](https://pic1.zhimg.com/80/v2-497adddb31f7b761f37053205fe060b4_720w.webp)

sar命令在这里可以查看网络设备的吞吐率。在排查性能问题时，可以通过网络设备的吞吐量，判断网络设备是否已经饱和。

如示例输出中，eth0网卡设备，吞吐率大概在22 Mbytes/s，既176 Mbits/sec，没有达到1Gbit/sec的硬件上限。

## 9.**TCP连接数**

```text
sar -n TCP,ETCP 1
```

结果

![img](https://pic2.zhimg.com/80/v2-a04ae32ac3edcd7f7c56a443aa3ba255_720w.webp)

sar命令在这里用于查看TCP连接状态，其中包括：

- active/s：每秒本地发起的TCP连接数，既通过connect调用创建的TCP连接；
- passive/s：每秒远程发起的TCP连接数，即通过accept调用创建的TCP连接；
- retrans/s：每秒TCP重传数量；

TCP连接数可以用来判断性能问题是否由于建立了过多的连接，进一步可以判断是主动发起的连接，还是被动接受的连接。TCP重传可能是因为网络环境恶劣，或者服务器压力过大导致丢包。

## 10.**整体情况-TOP**

```text
top
```

结果

![img](https://pic3.zhimg.com/80/v2-fefd9a5f74294a1ead68fd19eed97e4e_720w.webp)

top命令包含了前面好几个命令的检查的内容。

比如系统负载情况（uptime）、系统内存使用情况（free）、系统CPU使用情况 （vmstat）等。因此通过这个命令，可以相对全面的查看系统负载的来源。

同时，top命令支持排序，可以按照不同的列排序，方便查找出诸如内存占用最 多的进程、CPU占用率最高的进程等。

但是，top命令相对于下面的一些命令，输出是一个瞬间值，如果不持续盯着，可能会错过一些线索。这时可能需要暂停top命令刷新，来记录和比对数据。

## 11.**查看系统日志**

```text
dmesg | tail
```

该命令会输出系统日志的最后10行。

原文地址：https://zhuanlan.zhihu.com/p/567441428

作者：linux