# 【NO.98】linux性能优化实战之cpu篇

对于性能来说，cpu的调度逻辑是影响性能的主要来源，本文主要来介绍下cpu跟性能相关的调度逻辑和排障工具。

## **1.cpu调度逻辑介绍：**

Linux 是一个多任务操作系统，支持远大于 CPU 数量的任务同时运行，而这里的同时运行采用的是分时逻辑的思路，只是看起来多个进程是同时运行的。

任务运行前，CPU通过系统事先帮它设置好的 CPU 寄存器和程序计数器（Program Counter，PC）来完成加载。

**CPU 上下文：**CPU 在运行任何任务前，必须的依赖环境，也就是 CPU 寄存器和程序计数器。
**CPU 寄存器：**是 CPU 内置的容量小、但速度极快的内存。
**程序计数器：**则是用来存储 CPU 正在执行的指令位置、或者即将执行的下一条指令位置。

**CPU 上下文切换**：就是先把前一个任务的 CPU 上下文保存到操作系统的内核中，然后加载新任务的上下文到这些寄存器和程序计数器，最后再跳转到程序计数器所指的新位置，运行新任务。

![img](https://pic4.zhimg.com/80/v2-998ae29ce74c2216e3df201b16c274e7_720w.webp)

在操作系统中CPU调度的任务有三类，分别是进程、线程和中断程序，所以上下文切换也可以分为这三类：

**系统调用：**
在开始介绍这三类上下文切换之前，我们先来看下系统调用，系统调用指的是用户态到内核态的转变，例如：open(),read()等。

一次系统调用的过程，只会发生在同一个进程中，其实是发生了两次 CPU 上下文切换，过程如下所示：

```text
1.CPU 寄存器里原来用户态的指令位置，需要先保存起来。
2.接着，为了执行内核态代码，CPU 寄存器需要更新为内核态指令的新位置。
3.最后才是跳转到内核态运行内核任务。
4.系统调用结束后，CPU 寄存器需要恢复原来保存的用户态，
5.然后再切换到用户空间，
6.继续运行进程。
```

**1.进程上下文切换：**

进程的上下文不仅包括了虚拟内存、栈、全局变量等用户空间的资源，还包括了内核堆栈、寄存器等内核空间的状态，进程的上下文切换步骤如下所示：

```text
1.在保存当前进程的内核状态和 CPU 寄存器之前，需要先把该进程的虚拟内存、栈等保存下来；
2.而加载了下一进程的内核态后，还需要刷新进程的虚拟内存和用户栈。
备注：每次上下文切换都需要几十纳秒到数微秒的 CPU 时间。
```

这种切换的次数变多，就会导致上下文切换时间变久，运行进程的时间占比变少，进而导致平均负载升高。

**进程调度原理：**

Linux 为每个 CPU 都维护了一个就绪队列，将活跃进程（即正在运行和正在等待 CPU 的进程）按照**优先级**和**等待 CPU 的时间**排序，然后选择最需要 CPU 的进程，也就是优先级最高和等待 CPU 时间最长的进程来运行。触发进程调度的场景如下所示：

```text
1.某个进程的时间片耗尽了，就会被系统挂起，切换到其它正在等待 CPU 的进程运行。
2.进程在系统资源不足（比如内存不足）时，要等到资源满足后才可以运行，这个时候进程也会被挂起，并由系统调度其他进程运行。
3.进程通过睡眠函数 sleep 这样的方法将自己主动挂起时，自然也会重新调度。
4.当有优先级更高的进程运行时，为了保证高优先级进程的运行，当前进程会被挂起，由高优先级进程来运行。
5.发生硬件中断时，CPU 上的进程会被中断挂起，转而执行内核中的中断服务程序。
```

**2.线程上下文切换：**

线程是**调度的基本单位**，而进程则是**资源拥有的基本单位**，内核中的任务调度，实际上的调度对象是线程，而进程只是给线程提供了虚拟内存、全局变量等资源。线程也有自己的私有数据，比如栈和寄存器等，这些在上下文切换时也是需要保存的。

对于**不同进程里面的线程之间的切换**，与进程间的上下文切换是一致的。
对于**同一进程里面的不同线程之间的切换**，区别较大，如下所示：

```text
因为虚拟内存是共享的，所以在切换时，虚拟内存这些资源就保持不动，
只需要切换线程的私有数据、寄存器等不共享的数据。
```

**3.中断上下文切换：**

为了快速响应硬件的事件，中断处理会打断进程的正常调度和执行，转而调用中断处理程序，响应设备事件。而在打断其他进程时，就需要将进程当前的状态保存下来，这样在中断结束后，进程仍然可以从原来的状态恢复运行，这种行为发生在内核态。

```text
1.中断上下文，只包括内核态中断服务程序执行所必需的状态，
包括 CPU 寄存器、内核堆栈、硬件中断参数等。
2.对同一个 CPU 来说，中断处理比进程拥有更高的优先级，
所以中断上下文切换并不会与进程上下文切换同时发生。
3.中断上下文切换也需要消耗 CPU，切换次数过多也会耗费大量的 CPU，
甚至严重降低系统的整体性能。
```



## **2.常用工具介绍：**

vmstat 是一个常用的系统性能分析工具，主要用来分析系统的内存使用情况，也常用来分析 CPU 上下文切换和中断的次数。

```text
# 每隔5秒输出1组数据
$ vmstat 5
procs -----------memory---------- ---swap-- -----io---- -system-- ------cpu-----
 r  b   swpd   free   buff  cache   si   so    bi    bo   in   cs us sy id wa st
 0  0      0 7005360  91564 818900    0    0     0     0   25   33  0  0 100  0  0

# 指标介绍：
# cs（context switch）：是每秒上下文切换的次数。
# in（interrupt）：则是每秒中断的次数。
# r（Running or Runnable）：是就绪队列的长度，也就是正在运行和等待 CPU 的进程数。
# b（Blocked）：则是处于不可中断睡眠状态的进程数。
# us 用户态使用的cpu占比
# sy 内核态使用的cpu占比
```

pidstat用来查看每个进程的详细情况：

**自愿上下文切换**（voluntary context switches）：是指进程无法获取所需资源，导致的上下文切换，比如说， I/O、内存等系统资源不足时，就会发生自愿上下文切换。

**非自愿上下文切换（**non voluntary context switches）：则是指进程由于时间片已到等原因，被系统强制调度，进而发生的上下文切换，比如说，大量进程都在争抢 CPU 时，就容易发生非自愿上下文切换。

```text
# 每隔1秒输出一组数据（需要 Ctrl+C 才结束）
# -wt 参数表示输出线程的上下文切换指标，t指的是线程
$ pidstat -wt 1
08:14:05      UID      TGID       TID   cswch/s nvcswch/s  Command
...
08:14:05        0     10551         -      6.00      0.00  sysbench
08:14:05        0         -     10551      6.00      0.00  |__sysbench
08:14:05        0         -     10552  18911.00 103740.00  |__sysbench
08:14:05        0         -     10553  18915.00 100955.00  |__sysbench
08:14:05        0         -     10554  18827.00 103954.00  |__sysbench
...
#指标解释：
# cswch：表示每秒自愿上下文切换的次数，
# nvcswch：表示每秒非自愿上下文切换的次数。
```

查看中断发生情况：

```text
# -d 参数表示高亮显示变化的区域
$ watch -d cat /proc/interrupts
           CPU0       CPU1
...
RES:    2450431    5279697   Rescheduling interrupts
...
#指标说明：
#重调度中断（RES），这个中断类型表示，唤醒空闲状态的 CPU 来调度新的任务运行。
```

场景总结：

1.**自愿上下文切换变多**：说明进程都在等待资源，有可能发生了 I/O 等其他问题。

2.**非自愿上下文切换变多**：说明进程都在被强制调度，也就是都在争抢 CPU，说明 CPU 的确成了瓶颈。

3.**中断次数变多**：说明 CPU 被中断处理程序占用，还需要通过查看 /proc/interrupts 文件来分析具体的中断类型。

**备注，两类压测工具介绍：**

stress基于多进程的，会fork多个进程，导致进程上下文切换，导致us开销很高。sysbench基于多线程的，会创建多个线程，单一进程基于内核线程切换，导致sy的内核开销很高。

原文地址：https://zhuanlan.zhihu.com/p/571624940

作者：linux