# 【NO.84】2022全网最详细的音视频开发学习路线，零基础到项目实战，从小白到音视频专家



## 1.**前言**

音视频的历史与前景在这里就不介绍了，小编之前的文章里面都有讲到。

## 2.行业现状分析

- 核心竞争力：定义音视频是程序届的皇冠，掌握音视频意味着拿到通往未来的船票，不用担心会被其他人替代。音视频是有门槛的。是与其他人拉开差距的分水岭
- 高端人才相关缺乏：Boss直聘中，北上广深很多年限上50w-70w的音视频岗位，常年还招不到人，月薪2-3万大多是刚从事音视频入门级开发者
- 技术迭代慢：就H264编码从95年成为标准至今，都在使用。比较偏底层技术，底层技术几十年不会有太大的改变

## 3.**招聘的公司**

招聘的公司行业分布广泛（以下列举大部分是互联网公司）

**互联网**

掌门科技 哔哩哔哩 字节跳动 腾讯 欢聚时代 快手 阿里巴巴 虎牙

即构科技 网易 小米 商汤科技 融云 蚂蚁金服 爱奇艺 …等等

**计算机软件**

华为 海康威视 浙江大华 …等等

**移动互联网**

常相伴(互动娱乐) 声网 …等等

**电子商务**

京东 拼多多 美团 …等等

**人力资源服务**

Boss直聘

## 4.音视频开发岗位

说道薪资待遇什么的，想必是你们比较关心的一件事。我就随便在Boss直聘搜索的音视频开发岗位的薪资。

从上图可以看出音视频开发岗位的薪资平均都是在20K以上，但是他们对学历还是有一定的要求的最低基本都是本科学历。

**为什么音视频的开发薪资这么高呢？**

因为是音视频岗位人才稀缺，很少有人会完整的音视频开发。

## **5.音视频开发总体学习知识点：**

**1.首先需要学习的是音视频基础知识**

有些朋友对音视频学习有些误区，以为需要很多的理论基础才开始去实践，实际上大家只需要懂：

视频：

- YUV格式
- RGB格式
- 帧率
- 分辨率
- H264 I P B帧原理

音频：

- PCM
- 采样率
- 采样格式
- 码率

等这些基础知识掌握了之后即可开启音视频学习的大门。

### **5.1.音视频基础开发知识：**

| 音视频基础知识 | o 音频基础知识，PCM格式、编码原理等  |
| :------------: | :----------------------------------: |
|                | o 视频基础知识，YUV格式、IPB帧原理等 |
|                |                                      |
| Ffmpeg环境搭建 |            o Windows平台             |
|                |             o Linux平台              |
|                |              o MAC平台               |
|                |                                      |
|    常用工具    |             o MediaInfo              |
|                |        o VLC播放器 o EasyICE         |

### **5.2.FFmpeg命令实战**

|  命令帮助  |  o 如何查询Ffmpeg命令帮助   |
| :--------: | :-------------------------: |
|            |      o Ffmpeg命令分类       |
|            |                             |
| ffplay命令 |      o ffplay播放控制       |
|            |       o ffplay播放pcm       |
|            |       o ffplay播放yuv       |
|            |   o ffplay使用filter播放    |
|            |                             |
| ffmpeg命令 |          o pcm提取          |
|            |          o yuv提取          |
|            |          o aac提取          |
|            |         o h264提取          |
|            |       o 视频录制命令        |
|            | o 多媒体文件的分解/复用命令 |
|            |      o 裁剪与合并命令       |
|            |     o 图片/视频互转命令     |
|            |       o 直播相关命令        |
|            |       o 各种滤镜命令        |

### **5.3.FFmpeg编程实战**

| 音视频渲染实战 |     o SDL环境搭建      |
| :------------: | :--------------------: |
|                |     o SDL事件处理      |
|                |     o SDL线程处理      |
|                |   o YUV视频播放实战    |
|                |   o PCM声音播放实战    |
|                |                        |
| FFmpeg API精讲 |    o FFmpeg框架分析    |
|                |  o FFmpeg内存模型分析  |
|                | o FFmpeg常用结构体精讲 |
|                |                        |
|  音视频编解码  |  o FFmpeg解码流程分析  |
|                |  o FFmpeg编码流程分析  |
|                |    o AAC编解码原理     |
|                |    o H264编解码原理    |
|                |     o AAC解码实战      |
|                |     o AAC编码实战      |
|                |     o H264解码实战     |
|                |     o H264编码实战     |
|                |     o MP3转AAC实战     |
|                |                        |
| 音视频封装格式 |   o FLV封装格式分析    |
|                |   o MP4封装格式分析    |
|                |   o 多媒体解复用实战   |
|                |    o 多媒体复用实战    |
|                | o 多媒体转封装格式实战 |
|                |      o 音频重采样      |
|                |     o 视频尺寸变换     |
|                |                        |
|  音视频过滤器  |     o 音视频过滤器     |
|                |      o 视频过滤器      |
|                |  o 过滤器实际项目实现  |
|                |                        |
|  ffplay播放器  |  o 掌握ffplay.c的意义  |
|                |    o ffplay框架分析    |
|                |      o 音视频解码      |
|                |      o 音视频控制      |
|                |      o 音视频同步      |
|                |       o 参数机制       |
|                |                        |
| 播放器开发实战 |    o 播放器框架分析    |
|                |       o 模块划分       |
|                |      o 音视频解码      |
|                |      o 播放器控制      |
|                |      o 音视频同步      |
|                |                        |
| ffmpeg录制转码 |  o 掌握ffmpeg.c的意义  |
|                |    o ffmpeg框架分析    |
|                |      o 音视频编码      |
|                |     o 封装格式转换     |
|                |       o 提取音频       |
|                |       o 提取视频       |
|                |       o logo叠加       |
|                |    o 音视频文件拼接    |
|                |      o filter机制      |

### **5.4.流媒体客户端实战**

|   RTMP流媒体   |      o RTMP协议分析       |
| :------------: | :-----------------------: |
|                |    o wireshark抓包分析    |
|                |      o H264 RTMP封装      |
|                |      o AAC RTMP封装       |
|                |      o RTMP拉流实战       |
|                |      o H264 RTMP解析      |
|                |      o AAC RTMP解析       |
|                |      o RTMP推流实战       |
|                |                           |
|   HLS流媒体    |       o HLS协议分析       |
|                |      o HTTP协议分析       |
|                |       o TS格式分析        |
|                |    o wireshark抓包分析    |
|                |       o HLS拉流实战       |
|                |   o FFmpeg HLS源码分析    |
|                |      o HLS多码率机制      |
|                |                           |
| HTTP-FLV流媒体 |    o HTTP-FLV协议分析     |
|                |    o wireshark抓包分析    |
|                |   o http chunk机制分析    |
|                |    o HTTP-FLV拉流实战     |
|                | o FFmpeg HTTP-FLV源码分析 |
|                |                           |
| RTSP流媒体实战 |      o RTSP协议分析       |
|                |       o RTP协议分析       |
|                |      o H264 RTP封装       |
|                |      o H264 RTP解析       |
|                |       o AAC RTP封装       |
|                |       o AAC RTP解析       |
|                |      o RTCP协议分析       |
|                |  o RTSP流媒体服务器搭建   |
|                |      o RTSP推流实战       |
|                |      o RTSP拉流实战       |
|                |    o wireshark抓包分析    |

### **5.5.SRS流媒体服务器**

| SRS 3.0源码剖析 |    o 整体框架分析     |
| :-------------: | :-------------------: |
|                 |    o RTMP推流分析     |
|                 |    o RTMP拉流分析     |
|                 |     o HLS拉流分析     |
|                 |  o HTTP-FLV拉流分析   |
|                 |   o FFmpeg转码分析    |
|                 |  o 首屏秒开技术分析   |
|                 | o forward集群源码分析 |
|                 |  o edge集群源码分析   |
|                 |  o 负载均衡部署方式   |

### **5.6.WebRTC实战**

|   WebRTC中级开发    |     o WebRTC通话原理分析      |
| :-----------------: | :---------------------------: |
|                     |     o WebRTC开发环境搭建      |
|                     |     o coturn最佳搭建方法      |
|                     |     o 如何采集音视频数据      |
|                     |     o 一对一通话时序分析      |
|                     |       o 信令服务器设计        |
|                     |           o SDP分析           |
|                     |      o Candidate类型分析      |
|                     |        o Web一对一通话        |
|                     |      o Web和Android通话       |
|                     |       o AppRTC快速演示        |
|                     |                               |
|   WebRTC高级开发    |     o 自定义摄像头分辨率      |
|                     |          o 码率限制           |
|                     |       o 调整编码器顺序        |
|                     |      o Mesh模型多方通话       |
|                     |        o Janus框架分析        |
|                     |   o Janus Web客户端源码分析   |
|                     | o Janus Android客户端源码分析 |
|                     | o Janus Windows客户端源码分析 |
|                     |        o Janus信令设计        |
|                     |    o 基于Janus实现会议系统    |
|                     |       o WebRTC源码编译        |
|                     |                               |
| Janus服务器源码分析 |          o 源码结构           |
|                     |          o 插件机制           |
|                     |          o 线程分析           |
|                     |        o 信令交互过程         |
|                     |        o videoroom分析        |
|                     |                               |
|   SRS4.x源码分析    |     o RTMP转发WebRTC逻辑      |
|                     |     o WebRTC转发RTMP逻辑      |
|                     |   o WebRTC音视频一对一通话    |
|                     |       o WebRTC多人通话        |
|                     |     o WebRTC SFU模型分析      |
|                     |          o stun分析           |
|                     |          o turn分析           |
|                     |           o sdp分析           |
|                     |           o rtp分析           |
|                     |          o srtp分析           |
|                     |        o 拥塞控制算法         |
|                     |             o FEC             |
|                     |        o jitter buffer        |

### **5.7.Android NDK开发**

|       音视频开发       |        o So库适配总结        |
| :--------------------: | :--------------------------: |
|                        | o JNI Native层构建 Java 对象 |
|                        |        o JNI异常处理         |
|                        |         o 编译FFmpeg         |
|                        |       o 编译ijkplayer        |
|                        |   o 基于ijkplayer二次开发    |
|                        |   o OpenSL ES播放音频数据    |
|                        |     o MediaCodec硬件解码     |
|                        |  o OpenGL ES Shader显示视频  |
|                        |        o RTMP推流直播        |
| GSYVideoPlayer源码分析 |       o 多视频同时播放       |
|                        |          o gif截图           |
|                        |        o 边播放边缓存        |
|                        |            o 水印            |
|                        |            o 弹幕            |

### 6.**总结：**

**以上就是音视频开发学习知识点，相比音视频开发自学非常困难的，网上通俗易懂的难找到，网上部分资源是对应的开源版本较低，比如雷霄骅(雷神)博客的FFmpeg版本较低，音视频涉及大量的开源库和协议，比如ffmpeg的编译，如果不熟悉各种编译报错，Janus编译涉及各种开源组件编译不通过，比如WebRTC涉及的RTP RTCP SDP STUN等协议，部分嵌入式音视频的朋友技术面窄，技术不深入。**

原文链接：https://zhuanlan.zhihu.com/p/478164918

作者：[Hu先生的Linux](https://www.zhihu.com/people/huhu520-10)