# 【NO.81】学C++的以后都能从事哪些岗位？

相信很多人对编程的接触都来自于大学时的C++语言编程，但这门课只告诉你什么是编程语言，并没有告诉你如何熟练地掌握编程。所以，很多人在毕业前夕发现，虽然学了C++，但似乎不知道自己能做什么，能找到什么样的工作，能去什么样的公司，这是必然的。所以这篇文章从C++的角度谈谈我对C++的理解。

这次我不会讲什么复杂的应用场景，也不会讲语言底层的优化特性。只说我大学学完C++能做什么吧。当然，由于C语言和C++的密切关系，我们会混淆在一起说。道理也差不多。

## **1.实验室开发**

不敢说`C++`是世界上最好的语言，但`C++`基本是工科生中的大语言。暂且不说计算机专业，很多工科专业，比如电信、电气、通信等专业，基本上正常的学习中都会使用到`C++`。

都说`C++`兼具面向过程以及面向对象的特性，既拥有比较优秀的运行速度，又有良好的大型项目开发能力，那简直可以制霸高校实验室了。当然我们知道，另外一门同样在高校实验室里与`C++`不相上下的语言，就是`Matlab`了。

像我研究生期间就是左手`Matlab`试探，右手`C++`优化。论文专利什么的就靠这两种语言双管齐下。还记得在实验室里，基本所有的算法都是用`C/C++`写的。

最开始就学`C++`的基本都是老理工男了。就算指针再怎么难理解，虚函数表再怎么无情，也磨不灭我们这些工科生对编程的热情。

## **2.后端开发**

不过等到真正要找工作的时候，就不是那么回事了。听说现在由于算法岗已经是诸神黄昏了，导致一大批人冲向了后端开发。

而主流的后端开发语言就那么几种，以`Java`、`C++`领衔，`Python`和`Go`紧跟其后。作为写了这么多年的老`C++ coder`了，哪能不去凑个热闹。

所以呀，学了`C++`之后，第一选择当然就是去面试后台开发的岗位啦。只不过我们都常说一句话，语言都不是最重要的。那对于学了`C++`想找后端开发的同学而言，什么最重要呢？

其实软件开发工程需要掌握的技能不外乎那么几点，各种经验分享和面经都已经说烂了。但是那些只是大的方向，具体涉及到的概念和技术点非常多，在这里也没办法全部罗列。总的来说，想通过`C++`找一份合适的后端开发工作，我建议可以从以下几个方面来提升自己：

### **2.1.扎实的编程基础。**

这个基础扎实首先意味着你比较熟悉`C++`这门语言了，知道不同版本的语言特性（比如`C++11`以及新出的`C++20`的区别），对常见的语言机制（比如多态、虚函数表、模板等）的底层有自己理解。

虽然说不看重你用什么语言，但是最起码你得比较熟练的使用一门语言吧。怎么才算熟练呢，大概`C++`底层机制、多线程编程、跨平台编程这些你都需要有所了解吧。

除此之外，编程能力的素养还体现在算法思想和数据结构的理解上。毕竟程序的基础就是算法和数据结构嘛。所以一些基本的数据结构，比如链表、数组、二叉树、队列之类的，还有一些基本的算法思想，比如贪心、分治、动态规划等都最好需要好好掌握一下。

### **2.2.系统的理论知识。**

这个就是科班与非科班比较明显的差距所在了。**很多非科班的同学其实编程能力很强，但是由于没有接受过系统的理论学习，所以在理论学习上会比较吃亏。而后端开发涉及的东西比较多，从网络到性能再到架构，都需要系统的计算机理论来支撑的。**

所以如果连计算机网络、操作系统、计算机组成原理、编译原理这些书都没见过的同学，需要赶紧买几本回来压压惊了。

### **2.3.后端基础。**

想去做后端开发，起码得知道后端是什么吧。这就意味着你得知道一些基本的软件工程、软件架构、设计模式等知识。同时，搞个后端哪能不懂数据库呢，那你不得再学些诸如`MySQL`、`Redis`等数据库的基本操作吗？

当然到这，可能也就算是个入门水平。真正上手后端开发的时候，像微服务、中间件（`Kafka`/`Zookeeper`/`Hadoop`等）等相关概念与技术的学习不也得提上日程了嘛。

当然对于校招生来说，**由于的确是缺少大型的上线项目经验，所以对后端基础的要求不会太高，更多的是看编程能力和计算机理论基础。不**过倘若是已经工作想转行的同学来说，后端基础还是会比较看重的。

这三点是在我看来目前互联网公司比较看重的地方，大家可以对照着反思自己是否具备这样的能力了。如果还没有，可以抓紧时间好好准备准备。

## **3 .客户端开发**

毕竟`C++`已经是一个很成熟的语言了，所以除了后端开发其实它还有很多其它的开发岗位可以选择。自然而然的，就是客户端开发了。

相信大多数学`C++`的同学都用过`C++`写桌面软件吧。那时候估计还是用MFC，照着代码书上敲一遍就能写一个比较简单的界面了。所以如果不想做后端，完全可以靠`C++`找一份客户端开发的工作。

只不过，客户端也并不容易呀。做客户端同样也需要扎实的编程基础和计算机理论基础，同时可能还要熟悉`Windows`/`C++`编译链接机制、`QT`客户端开发技术体系、`Windows`消息机制等技术。

所以，假如你学的是`C++`，同时也不在乎业内莫名其名的岗位歧视链的话，找一个客户端开发的工作也是非常不错的。只不过相较于后端开发，你可能需要重新审视客户端这个角色。

在我看来，客户端与后端在职业发展上的区别主要有以下几点：

### **3.1.技术天花板**

这就是岗位歧视链中最经常拿来讨论的一个点。普遍认为客户端的天花板较低，长期在市场上的竞争力不高。甚至还有人拿`CTO`基本全是后端开发出身的例子来验证这个歧视链。

怎么说呢，我觉得对于大多数人来说，客户端的天花板的确比后端要低。因为客户端是一个两级分化比较严重的技术，厉害的人天花板可以突破天际，而一般的人真的就很一般。而后端相较之下，的确职业高度的分布稍微均匀一些。

但是，当客户端开发达到一定深度后，难度绝对不比后端开发难度低。**反而有时候为了获得更好的端上体验以及更快的用户响应，涉及到的技术会更加底层，更加硬核。** 记住一点，客户端开发绝不是改改`UI`，改改文案这么简单。

所以我特别不喜欢这种歧视链，从非常片面的角度去论证某个职业或者技术的好与坏，甚至还上升到歧视的层面。**我比较认同的是兴趣爱好论，而不是这种天花板论。**

### **3.2.发展方向**

客户端客户端，很显然是面向用户的。这就意味着客户端的开发是直接接触到用户，这也是与后端开发最主要的区别。

说简单一点，客户端开发就是为用户服务，优化用户体验，让产品变得更好用。所以客户端有一个天然的优势，就是离用户很近，知道用户想要的是什么。

问问自己，**你觉得自己干技术能干几年，写代码还能写到多少岁。身体熬得住吗，头发还剩多少？干技术这行，还是需要天赋和意识的，特别是真正顶尖的技术大牛。** 不是所有人能够在技术这条道上一直走下去。

那走不下去怎么办？转型。

所以客户端的发展从来都不只是技术，而是业务技术两手抓，当然会有所侧重。业务能力意味着产品思维，放大点说就是互联网思维。这就是客户端的一大优势。

### **3.3就业选择**

这的确是目前客户端发展的一个痛点。放开到二三四线城市，后端的需求的确要比客户端要大。因为在小公司里，往往不需要那么复杂的客户端支撑。

很多时候都是把后端开发程序员当作全栈来用。很多人都会考虑说，假如干了客户端，之后跳回老家就找不到合适的公司了。虽然这的确很有可能，但也没这么夸张。

只要你的基础扎实，并且善于学习，其实到哪儿都能找到差不多的工作的。不过在一线城市，后端和客户端并没有明显的差别，互联网大厂对这两种岗位的需求都是很大的。

## **4 .音视频开发/多媒体开发**

我们知道现在基本各个大平台都在做短视频，同时也不断接入各种直播模式。在这个趋势中，对于音视频/多媒体方向的开发需求越来越广。

比较成熟的互联网大厂通常会把音视频/多媒体技术方向独立出来，作为为全公司所有产品线提供中台的支撑。然后相关的处理算法会封装成SDK给各个业务中调用。

这说明音视频/多媒体开发是很重要的一份工作，而在对音视频或流媒体进行处理的时候，算法效率就是很重要的评价标准。这不就是`C++`所擅长的场景嘛。

所以呢，学了`C++`还可以选择去做音视频开发的方向。这个方向更偏向于具体的场景，比如播放器，比如直播平台，比如音视频特效等。当然了，`C++`更多的还是偏算法实现的方向，许多多媒体开发本身还是立足于平台，比如基于`Android`、`iOS`或者`Windows`，来进行满足平台特性的开发。

不过想要找这个方向的岗位，基本的音视频开发的理论知识得掌握吧。**这里同样也包括了很多理论层面的知识，比如图像、音频、视频的采集、渲染、处理、传输等方面的问题，图像和音视频的加工、裁剪、编解码等处理。**

一些基本的处理库，用于图像处理的像`OpenGL`、`OpenCV`等，用于视频编解码的`x264`、`OpenH264`、`ffmpeg`，用于音视频处理的`speexdsp`、`libfaac`、`opus`等库不也得熟悉熟悉吧。

还有音视频传输的协议、直播推/拉流的协议，如`RTMP`、`RTSP`等也可以掌握掌握。哈哈不要被吓到，毕竟会`C++`只是基本的编程能力，但是具体的岗位肯定有业务能力上的要求。

## **5. 游戏开发**

游戏开发也是`C++`的可以进军领域之一，像很多游戏引擎都是基于`C++`开发的。只不过游戏开发真的需要兴趣和热情。如果不是因为喜欢游戏，建议还是不要选择游戏开发的岗位。

不是说游戏开发前景不好，而是说这件事如果没有足够的热情很难走得很远，并且因为方向不是很大众，到时候想换方向了，可选择性就不是很多。

国内比较出名的游戏厂商就那么几家，但是投递的人却很多。这也导致这个行业的竞争很大，所以在招聘的时候会更看中你的游戏开发经历。

如果是校招生，很少会有比较多的游戏开发经验，**但是可以通过许多途径去弥补这一缺陷，比如参加游戏开发比赛，比如自己开发**`demo`。**起码也得了解过或者用过一些游戏引擎，这样简历也会更加饱满一点。**

对于游戏开发的业务能力要求刚刚也提到过一点，大概包括游戏引擎的使用和了解，比如常见的`Cocosa2d`、`Unity3D`等，游戏引擎的实现原理和机制，还有面试时候基本都会问到的计算机图形学理论。计算图形学是游戏开发领域及其重要的理论基础，毕竟游戏离不开各种图像模型的渲染和处理。

所以呢，如果你在大学期间有基础过一些图像学的工作，比如一些模型绘制、三维渲染的工作就可以去尝试一下游戏开发的岗位。我之前有个师兄在研究生阶段是做医学图像处理的，主要的工作就是对人体脏器和血管进行三维显示的，然后就去做了游戏开发。美滋滋。

## **6 .嵌入式开发**

上面几种岗位选择都是偏软件方向想的，而`C/C++`还有一类非常大的就业方向，就是去做嵌入式。嵌入式本身可能是偏硬件一点，但是现在做个什么事，都是软硬不分家的。

嵌入式的开发同样也会涉及到网络编程、并发编程等方面。通俗点解释可能就是，嵌入式代码是运行在别的小系统上，而不是传统意义的计算机上。

所以嵌入式开发更适合原来专业是电信、微电子之类的专业，**毕竟这个方向除了需要编程能力，还需要基本的电路理论素养。**

一般招聘嵌入式开发岗的公司大多是以硬件产品为主的互联网+公司，比如小米、华为等。进去公司很多都是在做物联网相关的工作，毕竟这是热点。当然也会有其它的业务方向，例如芯片、机器人等。

## **7. 总结**

说了这么多，有没有发现好像只会`C++`是找不到工作的。不管是哪个岗位，在对`C++`基础的要求上，还会有额外的东西。这其实很好理解，毕竟`C++`只是一门语言，只是一个工具。

就好比你光有一把弓箭，是没办法射大雕的。**你还需要许多额外的能力和知识储备，甚至还需要一点预判的意识，才能够在合适的时机以合适的力度射出那一箭。**

而`C++`，只是那支射出的箭罢了。你越熟悉它，箭头便愈发锃亮，破坏力也就越强。并且同时，空中盘旋的也不只有一只大雕，你还需要选择机会最大的那一只。

原文链接：https://zhuanlan.zhihu.com/p/579042527

作者：[Hu先生的Linux](https://www.zhihu.com/people/huhu520-10)