# 【NO.75】资深工程师带你探秘C++内存管理（理论篇）

在互联网的服务中，C++常用于搭建高性能、高并发、大流量、低延时的后端服务。如何合理的分配内存满足系统高性能需求是一个高频且重要的话题，而且因为内存自身的特点和实际问题的复杂，组合出了诸多难题。

我们可以对内存进行多种类型的划分，**从内存申请大小来看**：

1. 小对象分配：小于4倍内存页大小的内存分配，在4KiB页大小情况下，<16KiB算作小对象分配；
2. 大对象分配：大于等于4倍内存页大小的内存分配，在4KiB页大小情况下，>=16KiB算作大对象分配。

**从一块内存的被持有时长来看**：

1. 后端一次请求内甚至更短时间申请和释放
2. 任意时间窗口内内存持有和更新
3. 几乎与应用进程等长的内存持有和更新
4. 某个进程消亡后一段时间内，由该进程申请的仍具有意义的内存持有和释放

当然还可以按照内存申请释放频率、读写频率进行进一步的分类。

内存管理服务于应用系统，目的是协助系统更好的解决瓶颈问题，比如对于『如何降低后端响应的延迟和提高稳定性』内存管理可能要考虑的是：

1. 处理内存读写并发（读频繁or写频繁）降低响应时间和CPU消耗
2. 应用层的内存的池化复用
3. 底层内存向系统申请的内存块大小及内存碎片化

每一个问题展开可能都是一个比较大的话题，本文作为系列文章《探秘C++内存管理》的开篇，先介绍Linux C++程序内存管理的理论基础。后续会继续解密C++程序常用的内存管理库的实现原理，包括ptmalloc，jemalloc，tcmalloc等，介绍当前业界流行的内存分配器如何管理C++程序的内存。了解内存分配器原理，更有助于工程师在实践中降低处理内存使用问题的成本，根据系统量身打造应用层的内存管理体系。

## **1.Linux内存管理**

GEEK TALK

Linux自底向上大致可以被划分为：

- 硬件(Physical Hardware)
- 内核层(Kernel Space)
- 用户层(User Space)

![img](https://pic1.zhimg.com/80/v2-42b224a85f079dfcd2dabb8c184c7cf8_720w.webp)

*△图1：Linux结构*

内核模块在内核空间中运行，应用程序在用户空间中运行，二者的内存地址空间不重叠。这种方法确保在用户空间中运行的应用程序具有一致的硬件视图，而与硬件平台无关。用户空间通过使用系统调用以可控的方式使内核服务，如：陷入内核态，处理缺页中断。

Linux的内存管理系统自底向上大致可以被划分为：

- 内核层内存管理 : 在 Linux 内核中 , 通过内存分配函数管理内存：

- - kmalloc()/__get_free_pages()：申请较小内存（kmalloc()以字节为单位，__get_free_pages()以一页128K为单位），申请的内存位于物理内存的映射区域，而且在物理上也是连续的，它们与真实的物理地址只有一个固定的偏移。
  - vmalloc()：申请较大内存，虚拟内存空间给出一块连续的内存区，但不保证物理内存连续，开销远大于__get_free_pages()，需要建立新的页表。

- 用户层内存管理：通过调用系统调用函数（brk、mmap等），实现常用的内存管理接口（malloc, free, realloc, calloc）管理内存；经典内存管理库ptmalloc2、tcmalloc、jemalloc。

- 应用程序通过内存管理库或直接调用系统内存管理函数分配内存，根据应用程序本身的程序特性进行使用，如：单个变量内存申请和释放、内存池化复用等。

至此单个进程可以使用Linux提供的内存划分顺利的运行，从用户程序来看Linux进程的内存模型大致如下所示：

![img](https://pic3.zhimg.com/80/v2-905f8d551f38a8fb401bb24e97d2fb2e_720w.webp)

*△图2：Linux进程的内存模型*

- 栈区(Stack)：存储程序执行期间的本地变量和函数的参数，从高地址向低地址生长
- 堆区(Heap): 动态内存分配区域，通过malloc、new、free和delete等函数管理

在标准C库中，提供了malloc/free函数分配释放内存，这些函数的底层是基于brk/mmap这些系统调用实现的，对照图2来看：

- brk(): 用于申请和释放小内存。数据段的末尾，堆内存的开始，叫做brk(program break)。通过设置heap的结束地址，将该地址向高或低移动实现堆内存的扩张或收缩。低地址内存必须在高地址内存的释放之后才能得到的释放，被标记为空闲区的低地址，无法被合并，如果后续再来内存空间的请求大于此空闲区，这部分将成为内存空洞。默认情况下，当最高地址空间的空闲内存超过128K（可由M_TRIM_THRESHOLD选项调节）时，执行内存紧缩操作（trim）。
- mmap()：用于申请大内存。mmap（memory map）是一种内存映射文件的方法，即将一个文件或者其它对象映射到进程的虚拟地址空间中（堆和栈中间的文件映射区域 Memory Mapping Segment），实现文件磁盘地址和进程虚拟地址空间中一段虚拟地址的一一对映关系。实现这样的映射关系后，进程就可以采用指针的方式读写操作这一段内存，而系统会自动回写脏页面到对应的文件磁盘上，内核空间对这段区域的修改也直接反映用户空间，从而可以实现不同进程间的文件共享。大于 128 K 的内存，使用系统调用mmap()分配内存。与 brk() 分配内存不同的是，mmap() 分配的内存可以单独释放。
- munmp()：释放有mmap()创建的这段内存空间。

但在对于多个同时运行的进程，系统仍需处理有限的物理内存和增长的内存地址等问题。那么当Linux存在多个同时运行的进程时，一次内存的分配过程具体都经过哪些过程呢？现代Linux系统上内存的分配主要过程如下[1] ：

1. 应用程序通过调用内存分配函数，系统调用brk或者mmap进行内存分配，申请虚拟内存地址空间。
2. 虚拟内存至物理内存映射处理过程，通过请求MMU分配单元，根据虚拟地址计算出该地址所属的页面，再根据页面映射表的起始地址计算出该页面映射表(PageTable)项所在的物理地址，根据物理地址在高速缓存的TLB中寻找该表项的内容，如果该表项不在TLB中，就从内存将其内容装载到TLB中。

![img](https://pic4.zhimg.com/80/v2-688a881aaf95d3ce3df2fe5b3c007b7b_720w.webp)

*△图3：Linux内存分配机制（虚拟+物理映射）*

对于内存分配过程中涉及到工具进一步剖析：

- 虚拟内存(Virtual Memory)：现代操作系统普遍使用的一种技术，每个进程有用独立的逻辑地址空间，内存被分为大小相等的多个块，称为页(Page)。每个页都是一段连续的地址，对应物理内存上的一块称为页框，通常页和页框大小相等。虚拟内存使得多个虚拟页面共享同一个物理页面，而内核和用户进程、不同用户进程隔离。
- MMU(Memory-Management Unit)：内存管理单元，负责管理虚拟地址到物理地址的内存映射，实现各个用户进程都拥有自己的独立的地址空间，提供硬件机制的内存访问权限检查，保护每个进程所用的内存不会被其他的进程所破坏。
- PageTable：虚拟内存至物理内存页面映射关系存储单元。
- TLB(Translation Lookaside Buffer)：高速虚拟地址映射缓存， 主要为了提升MMU地址映射处理效率，加了缓存机制，如果存在即可直接取出映射地址供使用。

这里要提到一个很重要的概念，内存的延迟分配，只有在真正访问一个地址的时候才建立这个地址的物理映射，这是 Linux 内存管理的基本思想之一。Linux 内核在用户申请内存的时候，只是分配了虚拟内存，并没有分配实际物理内存；当用户第一次使用这块内存的时候，内核会发生缺页中断，分配物理内存，建立虚拟内存和物理内存之间的映射关系。当一个进程发生缺页中断的时候，进程会陷入内核态，执行以下操作：

- 检查要访问的虚拟地址是否合法
- 查找/分配一个物理页
- 填充物理页内容
- 建立映射关系（虚拟地址到物理地址）
- 重新执行触发缺页中断的指令

如果填充物理页的过程需要读取磁盘，那这次缺页中断是majflt，否则是minflt。我们需要重点关注majflt的值，因为majflt对于性能的损害是致命的，随机读一次磁盘的耗时数量级在几个毫秒，而minflt只有在大量的时候才会对性能产生影响。

## **2.总结**

GEEK TALK

通过对Linux内存管理的介绍，我们可以看到内存管理需要解决的问题：

- 调用系统提供的有限接口操作虚存读写
- 权衡单次分配较大内存和多次分配较少内存带来成本：控制缺页中断（尤其是majflt）vs 进程占用过多内存
- 降低内存碎片
- 降低内存管理库自身带来的额外损耗

原文地址：https://zhuanlan.zhihu.com/p/568776770

作者：linux