# 【NO.618】浅谈linux定时器时间轮算法

## 1.时间轮实现

Linux定时器分为低精度定时器和高精度定时器两种类型，内核对其均有实现。本文讨论的是我们在应用程序开发中比较常见的低精度定时器。作为常用的基础组件，定时器常用的几种实现方法包括：基于排序链表实现、基于小根堆实现、基于红黑树实现、基于时间轮实现。本文讲解的是时间复杂度最优，也是linux内核采用的基于时间轮的实现方式。

采用有序链表实现的定时器，添加定时器的时间复杂度为O(n)；采用小根堆或红黑树实现的定时器，添加定时器的时间复杂度为O(lgn)。之所以没法做到O(1)的复杂度，究其原因是所有定时器节点挂在一条链表（或一棵树）上。时间轮算法的核心思路是将定时器散列到多条链上，是典型的空间换时间的策略。下文从单个时间轮出发讲解，逐步扩展至linux实现定时器所采用的多级时间轮算法。

## 2.简单的单时间轮

单时间轮只有一个由bucket串起来的轮子，下图所示的时间轮有8个bucket，每个bucket下链接着未来对应时刻到期的节点。假设图中相邻bucket到期时间的间隔为slot=1s，从当前时刻0s开始计时，1s时到期的定时器节点挂在bucket[1]下，2s时到期的定时器节点挂在bucket[2]下……当tick检查到时间过去了1s时，bucket[1]下所有节点执行超时动作，当时间到了2s时，bucket[2]下所有节点执行超时动作…….

![img](https://pic3.zhimg.com/80/v2-cdd812bd00ff94c2375cacdec8303c42_720w.webp)

由于bucket是一个数组，能直接根据下标定位到具体定时器节点链，因此添加删除节点、定时器到期执行的时间复杂度均为O(1)。

但使用这个定时器所受的限制也显而易见：待添加的timer到期时间必须在8s以内。这显然不能满足实际需求。当然要扩展也很容易，直接增加bucket的个数就可以了。在 Linux 系统中，我们可以设置slot为1个jiffy(1/HZ)的定时器，假设最大的到期时间范围要达到 2^32个 jiffies，如果采用上面这样的单时间轮，我们就需要2^32个 bucket，这会带来巨大的内存消耗，显然是需要优化改进的。

## 3.改进的单时间轮

改进的单时间轮其实是一个对时间和空间折中的思路，即不会像单时间轮那样有O(1)的时间复杂度，但也不会像单时间轮那样对bucket个数有巨大的需求。其原理也很简单，就是每个bucket不单可以挂接到期时间expire=slot的定时器，还可挂接expire%N=slot的定时器(N为bucket个数)。这也正好顺应时间轮的轮回作用。如图2所示，定时器中expire表示到期时间，rotation表示节点在时间轮转了几圈后才到期。当当前时间指针指向某个bucket时，不能像简单时间轮那样直接对bucket下的所有节点执行超时动作，而是需要对链表中节点遍历一遍，判断轮子转动的次数是否等于节点中的rotation值，当两者相等时，方可执行超时操作。

![img](https://pic3.zhimg.com/80/v2-660ad476cd1aae5ac39ef5a59e391d46_720w.webp)

## 4.多时间轮

上面所述的时间轮都是单枪匹马战斗的，因此很难在时间和空间上都达到理想效果。Linux所实现的多时间轮算法，借鉴了日常生活中水表的度量方法，通过低刻度走得快的轮子带动高一级刻度轮子走动的方法，达到了仅使用较少刻度即可表示很大范围度量值的效果。

![img](https://pic1.zhimg.com/80/v2-cce7c9b5e10b03519576045d7dae3938_720w.webp)

Linux定时器时间轮分为5个级别的轮子(tv1 ~ tv5)，如图3所示。每个级别的轮子的刻度值(slot)不同，规律是次级轮子的slot等于上级轮子的slot之和。Linux定时器slot单位为1jiffy，tv1轮子分256个刻度，每个刻度大小为1jiffy。tv2轮子分64个刻度，每个刻度大小为256个jiffy，即tv1整个轮子所能表达的范围。相邻轮子也只有满足这个规律，才能达到“低刻度轮子转一圈，高刻度轮子走一格”的效果。tv3，tv4，tv5也都是分为64个刻度，因此容易算出，最高一级轮子tv5所能表达的slot范围达到了256*64*64*64*64 = 2^32 jiffies。

Linux时间轮定时器算法的关键在于添加定时器操作和时间轮进位迁移链表操作。先来说添加定时器。添加定时器的关键又在于知道每个时间轮每一个刻度所能表示的到期时间的范围。图4列出了每一级时间轮能度量的jiffies的大小。假设有一个定时器在1000个jiffies后到期，根据图4容易看出其应该挂在tv2轮上。tv2轮每个刻度表示的大小为256个jiffies，则其应该挂在(1000/256)=3即第三个bucket上。

Linux在定时器到期检查上的操作也实现得很巧妙。假设curr_time=0x12345678，那么下一个检查的时刻为0x12345679。如果tv1.bucket[0x79]上链表非空，则下一个检查时刻tv1.bucket[0x79]上的定时器节点超时。如果curr_time到了0x12345700，低8位为空，说明有进位产生，这时移出8～13位对应的定时器链表(即正好对应着tv2轮)，重新加入定时器系统，这就完成了一次进位迁移操作。同样地，当curr_time的第8-13位为0时，这表明tv2轮对tv3轮有进位发生，将curr_time第14-19位的值作为下标，移出tv3中对应的定时器链表，然后将它们重新加入到定时器系统中来。tv4,tv5依次类推。之所以能够根据curr_time来检查超时链，是因为tv1~tv5轮的度量范围正好依次覆盖了整型的32位：tv1(1-8位)，tv2(9-14位)，tv3(15-20位)，tv4(21-26位)，tv5(27-32位)；而curr_time计数的递增中，低位向高位的进位正是低级时间轮转圈带动高级时间轮走动的过程。

## 5.对比

最后比较一下多级时间轮和单个简单时间轮的时间复杂度及空间复杂度：linux使用了总计256+64+64+64+64=512个bucket，即可实现[0，2^32) jiffies的超时范围。相比简单的单时间轮，时间上仅仅多了1/256次(为约等于值，忽略了tv2以上产生的进位操作)的链表迁移操作耗时。可以认为其添加、删除定时器节点及到期check的操作时间复杂度均为O(1)。

原文地址：https://zhuanlan.zhihu.com/p/342285267

作者：linux