# 【NO.555】数据库设计的三范式和反范式

## 1.范式的概念

为了建立冗余较小、结构合理的数据库，设计数据库时必须遵循一定的规则。在关系型数据库中这种规则就称为范式。范式是符合某一种设计要求的总结。要想设计一个结构合理的关系型数据库，必须满足一定的范式。

三范式和反范式是空间和时间的关系。三范式是为了降低空间；反范式是通过增加空间来提升运行效率。

## 2.三范式

（1）目的：减少空间占用。
（2）内容：列不可分、依赖主键（联合索引）、在依赖主键（联合索引）的基础上直接依赖。

### 2.1 范式一

确保每列保持原子性；数据库表中的所有字段都是不可分解的原子值。
例如：某表中有一个地址字段，如果经常需要访问地址字段中的城市属性，则需要将该字段拆分为多个字段，省份、城市、详细地址等。

![image-20230225155314101](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155314101.png)
可以才分为：

![image-20230225155327216](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155327216.png)

### 2.2 范式二

确保表中的每列都和主键相关，而不能只与主键的某一部分相关（组合索引)。

![image-20230225155346455](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155346455.png)
因为订单编号与客户的信息相关，订单编号和商品编号一起唯一确定数量，商品编号和商品信息相关；所以可以拆分成三个表：

![image-20230225155359192](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155359192.png)

### 2.3 范式三

确保每列都和主键直接相关，而不是间接相关；减少数据冗余。

例如

![image-20230225155412047](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155412047.png)
可以拆分为：

![image-20230225155432650](C:\Users\Administrator\AppData\Roaming\Typora\typora-user-images\image-20230225155432650.png)

## 3.反范式

反范式是经常使用的设计。比如用户表采用的就是反范式，因为如果用户表不采用反范式设计，将会产生很多的关联关系表，这就会涉及到联表查询，非常影响效率，特别对登录来说，是不可容忍的。

因此，反范式允许冗余存储，为了提升查询效率。

## 4.总结

范式二中，对于联合索引，主键不能依赖一部分，而要依赖整体；出现重复的要拆分。
反范式是经常使用的设计。三范式可以避免数据冗余，减少数据库的空间，减小维护数据完整性的麻烦。但是采用数据库范式化设计，可能导致数据库业务涉及的表变多，并且造成更多的联表查询，将导致整个系统的性能降低。因此处于性能考虑，可能需要进行反范式设计。
————————————————
版权声明：本文为CSDN博主「Lion Long」的原创文章，遵循CC 4.0 BY-SA版权协议，转载请附上原文出处链接及本声明。
原文链接：https://blog.csdn.net/Long_xu/article/details/127532598