# 【NO.523】多线程还是多进程的选择及区别

**鱼还是熊掌：浅谈多进程多线程的选择**

关于多进程和多线程，教科书上最经典的一句话是“进程是资源分配的最小单位，线程是CPU调度的最小单位”，这句话应付考试基本上够了，但如果在工作中遇到类似的选择问题，那就没有这么简单了，选的不好，会让你深受其害。

经常在网络上看到有的XDJM问“多进程好还是多线程好？”、“Linux下用多进程还是多线程？”等等期望一劳永逸的问题，我只能说：没有最好，只有更好。根据实际情况来判断，哪个更加合适就是哪个好。

我们按照多个不同的维度，来看看多线程和多进程的对比（注：因为是感性的比较，因此都是相对的，不是说一个好得不得了，另外一个差的无法忍受）。

![img](https://pic4.zhimg.com/80/v2-55ed14ca36f32e693f441de0a7cd225f_720w.webp)

看起来比较简单，优势对比上是“线程 3.5 v 2.5 进程”，我们只管选线程就是了？

呵呵，有这么简单我就不用在这里浪费口舌了，还是那句话，没有绝对的好与坏，只有哪个更加合适的问题。我们来看实际应用中究竟如何判断更加合适。

**1）需要频繁创建销毁的优先用线程**

原因请看上面的对比。

这种原则最常见的应用就是Web服务器了，来一个连接建立一个线程，断了就销毁线程，要是用进程，创建和销毁的代价是很难承受的

**2）需要进行大量计算的优先使用线程**

所谓大量计算，当然就是要耗费很多CPU，切换频繁了，这种情况下线程是最合适的。

这种原则最常见的是图像处理、算法处理。

**3）强相关的处理用线程，弱相关的处理用进程**

什么叫强相关、弱相关？理论上很难定义，给个简单的例子就明白了。

一般的Server需要完成如下任务：消息收发、消息处理。“消息收发”和“消息处理”就是弱相关的任务，而“消息处理”里面可能又分为“消息解码”、“业务处理”，这两个任务相对来说相关性就要强多了。因此“消息收发”和“消息处理”可以分进程设计，“消息解码”、“业务处理”可以分线程设计。

当然这种划分方式不是一成不变的，也可以根据实际情况进行调整。

**4）可能要扩展到多机分布的用进程，多核分布的用线程**

原因请看上面对比。

**5）都满足需求的情况下，用你最熟悉、最拿手的方式**

至于“数据共享、同步”、“编程、调试”、“可靠性”这几个维度的所谓的“复杂、简单”应该怎么取舍，我只能说：没有明确的选择方法。但我可以告诉你一个选择原则：如果多进程和多线程都能够满足要求，那么选择你最熟悉、最拿手的那个。

需要提醒的是：虽然我给了这么多的选择原则，但实际应用中基本上都是“进程+线程”的结合方式，千万不要真的陷入一种非此即彼的误区。

**进程与线程**

进程是程序执行时的一个实例，即它是程序已经执行到课中程度的数据结构的汇集。从内核的观点看，进程的目的就是担当分配系统资源（CPU时间、内存等）的基本单位。

线程是进程的一个执行流，是CPU调度和分派的基本单位，它是比进程更小的能独立运行的基本单位。一个进程由几个线程组成（拥有很多相对独立的执行流的用户程序共享应用程序的大部分数据结构），线程与同属一个进程的其他的线程共享进程所拥有的全部资源。

> "进程——资源分配的最小单位，线程——程序执行的最小单位"

进程有独立的地址空间，一个进程崩溃后，在保护模式下不会对其它进程产生影响，而线程只是一个进程中的不同执行路径。线程有自己的堆栈和局部变量，但线程没有单独的地址空间，一个线程死掉就等于整个进程死掉，所以多进程的程序要比多线程的程序健壮，但在进程切换时，耗费资源较大，效率要差一些。但对于一些要求同时进行并且又要共享某些变量的并发操作，只能用线程，不能用进程。

总的来说就是：进程有独立的地址空间，线程没有单独的地址空间（同一进程内的线程共享进程的地址空间）。

使用多线程的**理由之一**是和进程相比，它是一种非常"节俭"的多任务操作方式。我们知道，在Linux系统下，启动一个新的进程必须分配给它独立的地址空间，建立众多的数据表来维护它的代码段、堆栈段和数据段，这是一种"昂贵"的多任务工作方式。而运行于一个进程中的多个线程，它们彼此之间使用相同的地址空间，共享大部分数据，启动一个线程所花费的空间远远小于启动一个进程所花费的空间，而且，线程间彼此切换所需的时间也远远小于进程间切换所需要的时间。据统计，总的说来，一个进程的开销大约是一个线程开销的30倍左右，当然，在具体的系统上，这个数据可能会有较大的区别。

使用多线程的**理由之二**是线程间方便的通信机制。对不同进程来说，它们具有独立的数据空间，要进行数据的传递只能通过通信的方式进行，这种方式不仅费时，而且很不方便。线程则不然，由于同一进程下的线程之间共享数据空间，所以一个线程的数据可以直接为其它线程所用，这不仅快捷，而且方便。当然，数据的共享也带来其他一些问题，有的变量不能同时被两个线程所修改，有的子程序中声明为static的数据更有可能给多线程程序带来灾难性的打击，这些正是编写多线程程序时最需要注意的地方。

除了以上所说的优点外，不和进程比较，多线程程序作为一种多任务、并发的工作方式，当然有以下的优点：

- 提高应用程序响应。这对图形界面的程序尤其有意义，当一个操作耗时很长时，整个系统都会等待这个操作，此时程序不会响应键盘、鼠标、菜单的操作，而使用多线程技术，将耗时长的操作（time consuming）置于一个新的线程，可以避免这种尴尬的情况。
- 使多CPU系统更加有效。操作系统会保证当线程数不大于CPU数目时，不同的线程运行于不同的CPU上。
- 改善程序结构。一个既长又复杂的进程可以考虑分为多个线程，成为几个独立或半独立的运行部分，这样的程序会利于理解和修改。

在linux上编程采用多线程还是多进程的争执由来已久，这种争执最常见到在B/S通讯中服务端并发技术 的选型上，比如WEB服务器技术中，Apache是采用多进程的（perfork模式，每客户连接对应一个进程，每进程中只存在唯一一个执行线 程）。

从Unix发展历史看，伴随着Unix的诞生多进程就出现了，而多线程很晚才被系统支持，例如Linux直到内核2.6，才支持符合Posix规范的NPTL线程库。进程和线程的特点，也就是各自的优缺点如下：

> 进程优点：编程、调试简单，可靠性较高。
> 进程缺点：创建、销毁、切换速度慢，内存、资源占用大。
> 线程优点：创建、销毁、切换速度快，内存、资源占用小。
> 线程缺点：编程、调试复杂，可靠性较差。

上面的对比可以归结为一句话：“线程快而进程可靠性高”。线程有个别名叫“轻量级进程”，在有的书籍资料上介绍线程可以十倍、百倍的效率快于进程； 而进程之间不共享数据，没有锁问题，结构简单，一个进程崩溃不像线程那样影响全局，因此比较可靠。我相信这个观点可以被大部分人所接受，因为和我们所接受的知识概念是相符的。

在写这篇文章前，我也属于这“大部分人”，这两年在用C语言编写的几个C/S通讯程序中，因时间紧总是采用多进程并发技术，而且是比较简单的现场为 每客户fork()一个进程，当时总是担心并发量增大时负荷能否承受，盘算着等时间充裕了将它改为多线程形式，或者改为预先创建进程的形式，直到最近在网上看到了一篇论文《Linux系统下多线程与多进程性能分析》才认真思考这个问题，我自己也做了实验。

下面是得出结论的实验步骤和过程，结论究竟是怎样的？ 感兴趣就一起看看吧。

实验代码使用论文中的代码样例，做了少量修改，值得注意的是这样的区别：

> 论文实验和我的实验时间不同，论文所处的年代linux内核是2.4，我的实验linux内核是2.6，2.6使用的线程库是NPTL，2.4使用的是老的Linux线程库（用进程模拟线程的那个LinuxThread）。
> 论文实验和我用的机器不同，论文描述了使用的环境：单cpu 机器基本配置为:celeron 2.0 GZ, 256M, Linux 9.2,内核 2.4.8。我的环境是：双核 Intel(R) Xeon(R) CPU 5130 @ 2.00GHz（做实验时，禁掉了一核），512MG内存，Red Hat Enterprise Linux ES release 4 (Nahant Update 4)，内核2.6.9-42。

进程实验代码（fork.c）：

```text
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#define P_NUMBER 255 //并发进程数量
#define COUNT 5 //每次进程打印字符串数
#define TEST_LOGFILE "logFile.log"
FILE *logFile=NULL;

char *s="hello linux\0";

int main()
{
    int i=0,j=0;
    logFile=fopen(TEST_LOGFILE,"a+");//打开日志文件
    for(i=0;i<P_NUMBER;i++)
    {
        if(fork()==0)//创建子进程，if(fork()==0){}这段代码是子进程运行区间
        {
            for(j=0;j<COUNT;j++)
            {
                printf("[%d]%s\n",j,s);//向控制台输出
                /*当你频繁读写文件的时候，Linux内核为了提高读写性能与速度，会将文件在内存中进行缓存，这部分内存就是Cache Memory(缓存内存)。可能导致测试结果不准，所以在此注释*/
                //fprintf(logFile,"[%d]%s\n",j,s);//向日志文件输出，
            }
            exit(0);//子进程结束
        }
    }
    
    for(i=0;i<P_NUMBER;i++)//回收子进程
    {
        wait(0);
    }
    
    printf("Okay\n");
    return 0;
}
```

线程实验代码（thread.c）：

```text
#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#define P_NUMBER 255//并发线程数量
#define COUNT 5 //每线程打印字符串数
#define TEST_LOG "logFile.log"
FILE *logFile=NULL;

char *s="hello linux\0";

print_hello_linux()//线程执行的函数
{
    int i=0;
    for(i=0;i<COUNT;i++)
    {
        printf("[%d]%s\n",i,s);//想控制台输出
        /*当你频繁读写文件的时候，Linux内核为了提高读写性能与速度，会将文件在内存中进行缓存，这部分内存就是Cache Memory(缓存内存)。可能导致测试结果不准，所以在此注释*/
        //fprintf(logFile,"[%d]%s\n",i,s);//向日志文件输出
    }
    pthread_exit(0);//线程结束
}

int main()
{
    int i=0;
    pthread_t pid[P_NUMBER];//线程数组
    logFile=fopen(TEST_LOG,"a+");//打开日志文件
    
    for(i=0;i<P_NUMBER;i++)
        pthread_create(&pid[i],NULL,(void *)print_hello_linux,NULL);//创建线程
        
    for(i=0;i<P_NUMBER;i++)
        pthread_join(pid[i],NULL);//回收线程
        
    printf("Okay\n");
    return 0;
}
```

两段程序做的事情是一样的，都是创建“若干”个进程/线程，每个创建出的进程/线程打印“若干”条“hello linux”字符串到控制台和日志文件，两个“若干”由两个宏 P_NUMBER和COUNT分别定义，程序编译指令如下：

> gcc -o fork fork.c
> gcc -lpthread -o thread thread.c

实验通过time指令执行两个程序，抄录time输出的挂钟时间（real时间）：

> time ./fork
> time ./thread

每批次的实验通过改动宏 P_NUMBER和COUNT来调整进程/线程数量和打印次数，每批次测试五轮，得到的结果如下：

**一、重复论文实验步骤**

**(注：本文平均值算法采用的是去掉一个最大值去掉一个最小值，然后平均)**

![img](https://pic1.zhimg.com/80/v2-1db70ff34894c2842deaff54536ed21c_720w.webp)

![img](https://pic1.zhimg.com/80/v2-62696a994debe07dd598ba9ee37f6968_720w.webp)

![img](https://pic3.zhimg.com/80/v2-8b8fa5f61dbf81323c1f60b475e3c672_720w.webp)

![img](https://pic4.zhimg.com/80/v2-d738d0aa346fdf93633d108d5c2b0837_720w.webp)

![img](https://pic4.zhimg.com/80/v2-7151bfc65aa35bc9d17ee37261edcf7b_720w.webp)

![img](https://pic2.zhimg.com/80/v2-2d34d995d9dad1e895cc591c7128cf21_720w.webp)

![img](https://pic2.zhimg.com/80/v2-09b47cce7a97e2eb133f06084ff99399_720w.webp)

![img](https://pic2.zhimg.com/80/v2-ac9a47de97b930896e8e94562cc14df9_720w.webp)

本轮实验是为了和论文作对比，因此将进程/线程数量限制在255个，论文也是测试了255个进程/线程分别进行5次，10 次,50 次,100 次,500 次……10000 次打印的用时，论文得出的结果是：**任务量较大时,多进程比多线程效率高;而完成的任务量较小时,多线程比多进程要快，重复打印 600 次时,多进程与多线程所耗费的时间相同。**

虽然我的实验直到1000打印次数时，多进程才开始领先，但考虑到使用的是NPTL线程库的缘故，从而可以证实了论文的观点。从我的实验数据看，多线程和多进程两组数据非常接近，考虑到数据的提取具有瞬间性，因此可以认为他们的速度是相同的。

是不是可以得出这样的结论：**多线程创建、销毁速度快，而多线程切换速度快，**这个结论我们会在第二个试验中继续试图验证

当前的网络环境中，我们更看中高并发、高负荷下的性能，纵观前面的实验步骤，最长的实验周期不过2分钟多一点，因此下面的实验将向两个方向延伸，第一，增加并发数量，第二，增加每进程/线程的工作强度。

**二、增加并发数量的实验**

下面的实验打印次数不变，而进程/线程数量逐渐增加。在实验过程中多线程程序在后四组（线程数350，500，800,1000）的测试中都出现了“段错误”，出现错误的原因和多线程预分配线程栈有关。

实验中的计算机CPU是32位，寻址最大范围是4GB（2的32次方），Linux是按照3GB/1GB的方式来分配内存，其中1GB属于所有进程共享的内核空间，3GB属于用户空间（进程虚拟内存空间）。Linux2.6的默认线程栈大小是8M（通过ulimit -a查看），对于多线程，在创建线程的时候系统会为每一个线程预分配线程栈地址空间，也就是8M的虚拟内存空间。线程数量太多时，线程栈累计的大小将超过进程虚拟内存空间大小（计算时需要排除程序文本、数据、共享库等占用的空间），这就是实验中出现的“段错误”的原因。

Linux2.6的默认线程栈大小可以通过 ulimit -s 命令查看或修改，我们可以计算出线程数的最大上线: (1024*1024*1024*3) / (1024*1024*8) = 384，实际数字应该略小与384，因为还要计算程序文本、数据、共享库等占用的空间。在当今的稍显繁忙的WEB服务器上，突破384的并发访问并不是稀 罕的事情，要继续下面的实验需要将默认线程栈的大小减小，但这样做有一定的风险，比如线程中的函数分配了大量的自动变量或者函数涉及很深的栈帧（典型的是 递归调用），线程栈就可能不够用了。可以配合使用POSIX.1规定的两个线程属性guardsize和stackaddr来解决线程栈溢出问 题，guardsize控制着线程栈末尾之后的一篇内存区域，一旦线程栈在使用中溢出并到达了这片内存，程序可以捕获系统内核发出的告警信号，然后使用 malloc获取另外的内存，并通过stackaddr改变线程栈的位置，以获得额外的栈空间，这个动态扩展栈空间办法需要手工编程，而且非常麻烦。

有两种方法可以改变线程栈的大小，使用 ulimit -s 命令改变系统默认线程栈的大小，或者在代码中创建线程时通过pthread_attr_setstacksize函数改变栈尺寸，在实验中使用的是第一种，在程序运行前先执行ulimit指令将默认线程栈大小改为1M：

> ulimit -s 1024
> time ./thread

![img](https://pic4.zhimg.com/80/v2-f12f33e6a39a0eaa3caa0f1a8f071db7_720w.webp)

![img](https://pic4.zhimg.com/80/v2-8c04b599c9129cec1076c9be7d81db03_720w.webp)

![img](https://pic3.zhimg.com/80/v2-f946486c7f0d8b44dfaef9924ad0b1ca_720w.webp)

![img](https://pic1.zhimg.com/80/v2-da5d1f70d93ce95aab159441f1bf74cc_720w.webp)

![img](https://pic2.zhimg.com/80/v2-b9e63fcd9f7a3802eecc431202ce9099_720w.webp)

![img](https://pic2.zhimg.com/80/v2-7a7123c645e2162a3b2bcaa2448a4b75_720w.webp)

【实验结论】

当线程/进程逐渐增多时，执行相同任务时，线程所花费时间相对于进程有下降的趋势（本人怀疑后两组数据受系统其他瓶颈的影响），这是不是进一步验证了多线程创建、销毁速度快，而多进程切换速度快。

**三、增加每进程/线程的工作强度的实验**

这次将程序打印数据增大，原来打印字符串为：

```text
char *s = "hello linux\0";
```

现在修改为每次打印256个字节数据:

```text
char *s = "1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\
    1234567890abcdef\0";
```

![img](https://pic3.zhimg.com/80/v2-37068d10e2dfca1130b11ab371d6b7f2_720w.webp)

![img](https://pic1.zhimg.com/80/v2-318a7eeeee8e8aff464fde1332b1765c_720w.webp)

![img](https://pic3.zhimg.com/80/v2-46d699f94f23150dc996d1587e77fdce_720w.webp)

【实验结论】

从上面的实验比对结果看，即使Linux2.6使用了NPTL线程库，多线程比较多进程在效率上没有任何的优势，在线程数增大时多线程程序还出现了运行错误，实验可以得出下面的结论：

> 在Linux2.6上，多线程并不比多进程速度快，考虑到线程栈的问题，多进程在并发上有优势。

**四、多进程和多线程在创建和销毁上的效率比较**

预先创建进程或线程可以节省进程或线程的创建、销毁时间，在实际的应用中很多程序使用了这样的策略，比如Apapche预先创建进程、Tomcat 预先创建线程，通常叫做进程池或线程池。在大部分人的概念中，进程或线程的创建、销毁是比较耗时的，在stevesn的著作《Unix网络编程》中有这样 的对比图（第一卷 第三版 30章 客户/服务器程序设计范式）：

![img](https://pic1.zhimg.com/80/v2-419f80771bd6bf01603e9dfb70115c68_720w.webp)

stevens已驾鹤西去多年，但《Unix网络编程》一书仍具有巨大的影响力，上表中stevens比较了三种服务器上多进程和多线程的执行效 率，因为三种服务器所用计算机不同，表中数据只能纵向比较，而横向无可比性，stevens在书中提供了这些测试程序的源码（也可以在网上下载）。书中介 绍了测试环境，两台与服务器处于同一子网的客户机，每个客户并发5个进程（服务器同一时间最多10个连接），每个客户请求从服务器获取4000字节数据， 预先派生子进程或线程的数量是15个。

第0行是迭代模式的基准测试程序，服务器程序只有一个进程在运行（同一时间只能处理一个客户请求），因为没有进程或线程的调度切换，因此它的速度是 最快的，表中其他服务模式的运行数值是比迭代模式多出的差值。迭代模式很少用到，在现有的互联网服务中，DNS、NTP服务有它的影子。第1～5行是多进 程服务模式，期中第1行使用现场fork子进程，2～5行都是预先创建15个子进程模式，在多进程程序中套接字传递不太容易（相对于多线 程），stevens在这里提供了4个不同的处理accept的方法。6～8行是多线程服务模式，第6行是现场为客户请求创建子线程，7～8行是预先创建 15个线程。表中有的格子是空白的，是因为这个系统不支持此种模式，比如当年的BSD不支持线程，因此BSD上多线程的数据都是空白的。

从数据的比对看，现场为每客户fork一个进程的方式是最慢的，差不多有20倍的速度差异，Solaris上的现场fork和预先创建子进程的最大差别是504.2 ：21.5，但我们不能理解为预先创建模式比现场fork快20倍，原因有两个：

\1. stevens的测试已是十几年前的了，现在的OS和CPU已起了翻天覆地的变化，表中的数值需要重新测试。

\2. stevens没有提供服务器程序整体的运行计时，我们无法理解504.2 ：21.5的实际运行效率，有可能是1504.2 : 1021.5，也可能是100503.2 : 100021.5，20倍的差异可能很大，也可能可以忽略。

因此我写了下面的实验程序，来计算在Linux2.6上创建、销毁10万个进程/线程的绝对用时。

创建10万个进程（forkcreat.c）:

```text
#include <stdio.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>

int count;//子进程创建成功数量 
int fcount;//子进程创建失败数量 
int scount;//子进程回收数量 

/*信号处理函数–子进程关闭收集*/
void sig_chld(int signo)
{
    pid_t chldpid;//子进程id
    int stat;//子进程的终止状态
    
    //子进程回收，避免出现僵尸进程
    while((chldpid=wait(&stat)>0))
    {
        scount++;
    }
}

int main()
{
    //注册子进程回收信号处理函数
    signal(SIGCHLD,sig_chld);
    
    int i;
    for(i=0;i<100000;i++)//fork()10万个子进程
    {
        pid_t pid=fork();
        if(pid==-1)//子进程创建失败
        {
            fcount++;
        }
        else if(pid>0)//子进程创建成功
        {
            count++;
        }
        else if(pid==0)//子进程执行过程
        {
            exit(0);
        }
    }
    
    printf("count:%d fount:%d scount:%d\n",count,fcount,scount);
}
```

创建10万个线程（pthreadcreat.c）:

```text
#include <stdio.h>
#include <pthread.h>

int count=0;//成功创建线程数量

void thread(void)
{
    //啥也不做
}

int main(void)
{
    pthread_t id;//线程id
    int i,ret;
    
    for(i=0;i<100000;i++)//创建10万个线程
    {
        ret=pthread_create(&id,NULL,(void *)thread,NULL);
        if(ret!=0)
        {
            printf("Create pthread error!\n");
            return(1);
        }
        count++;
        pthread_join(id,NULL);
    }
    
    printf("count:%d\n",count);
}
```

![img](https://pic2.zhimg.com/80/v2-e4afb6ab7e86dc046d3d7bda65bb65a1_720w.webp)

从数据可以看出，多线程比多进程在效率上有10多倍的优势，但不能让我们在使用哪种并发模式上定性，这让我想起多年前政治课上的一个场景：在讲到优越性时，面对着几个对此发表质疑评论的调皮男生，我们的政治老师发表了高见，“不能只横向地和当今的发达国家比，你应该纵向地和过去中国几十年的发展历史 比”。政治老师的话套用在当前简直就是真理，我们看看，即使是在赛扬CPU上，创建、销毁进程/线程的速度都是空前的，可以说是有质的飞跃的，平均创建销毁一个进程的速度是0.18毫秒，对于当前服务器几百、几千的并发量，还有预先派生子进程/线程的必要吗？

预先派生子进程/线程比现场创建子进程/线程要复杂很多，不仅要对池中进程/线程数量进行动态管理，还要解决多进程/多线程对accept的“抢” 问题，在stevens的测试程序中，使用了“惊群”和“锁”技术。即使stevens的数据表格中，预先派生线程也不见得比现场创建线程快，在 《Unix网络编程》第三版中，新作者参照stevens的测试也提供了一组数据，在这组数据中，现场创建线程模式比预先派生线程模式已有了效率上的优势。因此我对这一节实验下的结论是：

> 预先派生进程/线程的模式（进程池、线程池）技术，不仅复杂，在效率上也无优势，在新的应用中可以放心大胆地为客户连接请求去现场创建进程和线程。

我想，这是fork迷们最愿意看到的结论了。

**五、双核系统重复论文实验步骤**

![img](https://pic1.zhimg.com/80/v2-8ca64c8c326094b7ea2522e43b8aad54_720w.webp)

![img](https://pic1.zhimg.com/80/v2-05f1fa1f9963c72bc7e16ebdb68175b0_720w.webp)

![img](https://pic2.zhimg.com/80/v2-3c49863261a69b3e630de25ec60cbaf9_720w.webp)

![img](https://pic4.zhimg.com/80/v2-cf1a25b4c71b469a2fce9ac09c9b405f_720w.webp)

【实验结论】

双核处理器在完成任务量较少时，没有系统其他瓶颈因素影响时基本上是单核的两倍，在任务量较多时，受系统其他瓶颈因素的影响，速度明显趋近于单核的速度。

**六、并发服务的不可测性**

看到这里，你会感觉到我有挺进程、贬线程的论调，实际上对于现实中的并发服务具有不可测性，前面的实验和结论只可做参考，而不可定性。

**结束语**

本篇文章比较了Linux系统上多线程和多进程的运行效率，在实际应用时还有其他因素的影响，比如网络通讯时采用长连接还是短连接，是否采用 select、poll，这些都可能影响到并发模式的选型。

原文地址：https://zhuanlan.zhihu.com/p/381901463

作者：linux