# 【NO.461】YUV与RGB的格式/采样方式/存储方式

## 1.YUV与RGB

YUV,RGB是色彩空间模型,而BMP,PNG,JPEG,GIF是图像的文件存储格式。

RGB(RED GREEN BLUE),我们都知道任何颜色都可以通过原色 red green blue通过不同的比例混合出来,三个色基都为零,混合为黑色, 三个色基都最强,混合为白色.这种简单的色彩空间模型广泛应用与计算机.

YUV, Y表示亮度,U V表示色差信息(分别表示blue 和 Red的色差信息), 因为科学发现,人类的研究对色彩的亮度信息比较敏感,对色差信息相对比没那么敏感.亮度信号是强度的感觉，它和色度信号断开，这样的话强度就可以在不影 响颜色的情况下改变。YUV 格式通常用于 PAL制，即欧洲的电视传输标准，而且缺省情况下是图像和视频压缩的标准。YUV 使用RGB的信息，但它从全彩色图像中产生一个黑白图像，然后提取出三个主要的颜色变成两个额外的信号来描述颜色。把这三个信号组合回来就可以产生一个全 彩色图像。

YCbCr 是在世界数字组织视频标准研制过程中作为ITU - R BT1601 建议的一部分, 其实是YUV经过缩放和偏移的翻版。其中Y与YUV 中的Y含义一致, Cb , Cr 同样都指色彩, 只是在表示方法上不同而已。在YUV 家族中, YCbCr 是在计算机系统中应用最多的成员, 其应用领域很广泛,JPEG、MPEG均采用此格式。一般人们所讲的YUV大多是指YCbCr。

现在很多人都将YCbCr跟YUV混为一谈,因为YCbCr是根据YUV演变出来的,而目前YCbCr应用更加普遍,很多时候说的YUV指的是YCbCr.

## 2.RGB的格式

常用的RGB存储格式有如下

- RGB565 每个像素用16位表示，RGB分量分别使用5位、6位、5位
- RGB555 每个像素用16位表示，RGB分量都使用5位（剩下1位不用）
- RGB24 每个像素用24位表示，RGB分量各使用8位
- RGB32 每个像素用32位表示，RGB分量各使用8位（剩下8位不用）
- ARGB32 每个像素用32位表示，RGB分量各使用8位（剩下的8位用于表示Alpha通道值）

## 3.YUV的格式

YUV格式有两大类：planar和packed。

- 对于planar的YUV格式，先连续存储所有像素点的Y，紧接着存储所有像素点的U，随后是所有像素点的V。
- 对于packed的YUV格式，每个像素点的Y,U,V是连续交叉存储的。

## 4.YUV的采样方式

YUV码流的存储格式其实与其采样的方式密切相关，主流的采样方式有三种，YUV4:4:4，YUV4:2:2，YUV4:2:0，如何根据其采样格式来从码流中还原每个像素点的YUV值，因为只有正确地还原了每个像素点的YUV值，才能通过YUV与RGB的转换公式提取出每个像素点的RGB值，然后显示出来。

用三个图来直观地表示采集的方式吧，以黑点表示采样该像素点的Y分量，以空心圆圈表示采用该像素点的UV分量。

![img](https://pic2.zhimg.com/80/v2-6fe7bd6c885fd6eaa768c5b87e8c15a5_720w.webp)

- YUV 4:4:4采样，每一个Y对应一组UV分量，每像素32位
- YUV 4:2:2采样，每两个Y共用一组UV分量，每像素16位
- YUV 4:2:0采样，每四个Y共用一组UV分量，每像素16位

平常所讲的YUV A:B:C的意思一般是指基于4个象素来讲,其中Y采样了A次，U采样了B次,V采样了C次.

YUV 格式可以分为打包格式packed format和平面格式planar format。打包格式将YUV分量存放在同一个数组中，通常是几个相邻的像素组成一个宏像素（macro-pixel）；而平面格使用三个数组分开存放YUV三个分量，就像是一个三维平面一样。Packed format和planner format的区别在于，packed format中的YUV是混合在一起的，因此就有了UYVY、YUYV等等，他们在码流中排列的方式有所不同。而对于planner format每一个Y分量，U分量和V分量都是以独立的平面组织的，也就是说所有的U分量都在Y分量之后出现，而V分量在所有的U分量之后。就像三个大色块一样。

## 5.YUV的存储方式

下面用图的形式给出常见的YUV码流的存储方式，并在存储方式后面附有取样每个像素点的YUV数据的方法，其中，Cb、Cr的含义等同于U、V。YUV的存储格式实在是太多了,这里我简单列举几个,其他都类似.

YUYV 格式 （属于YUV422）

![img](https://pic3.zhimg.com/80/v2-46489d8be9aeb08bb62f0225a84d5132_720w.webp)

### 5.1 YUV422P（属于YUV422）

![img](https://pic1.zhimg.com/80/v2-ac35307cc2c78820234fb4f2bac27fe8_720w.webp)

YUV422P也属于YUV422的一种，它是一种Plane模式，即打包模式，并不是将YUV数据交错存储，而是先存放所有的Y分量，然后存储所有的U（Cb）分量，最后存储所有的V（Cr）分量，如上图所示。其每一个像素点的YUV值提取方法也是遵循YUV422格式的最基本提取方法，即两个Y共用一个UV。比如，对于像素点Y’00、Y’01 而言，其Cb、Cr的值均为 Cb00、Cr00。

以YUV420 planar数据为例， 以720×480大小图象YUV420 planar为例，

其存储格式是： 共大小为(720×480×3>>1)字节，

分为三个部分:Y,U和V

Y分量： (720×480)个字节

U(Cb)分量：(720×480>>2)个字节

V(Cr)分量：(720×480>>2)个字节

三个部分内部均是行优先存储，三个部分之间是Y,U,V 顺序存储。

即YUV数据的0－－720×480字节是Y分量值，

720×480－－720×480×5/4字节是U分量

720×480×5/4 －－720×480×3/2字节是V分量。

NV21(属于YUV420)

![img](https://pic1.zhimg.com/80/v2-b0188009afdec90db2f3960f08e792a4_720w.webp)

NV21属于YUV420格式，是一种two-plane模式，即Y和UV分为两个Plane，但是UV（CbCr）为交错存储，而不是分为三个plane。其提取方式与上一种类似，即Y’00、Y’01、Y’10、Y’11共用Cr00、Cb00

YUV420 planar数据存储， 以720×488大小图象YUV420 planar为例，

其存储格式是： 共大小为(720×480×3>>1)字节，

分为三个部分: Y分量：　　 　(720×480)个字节 U(Cb)分量：　　(720×480>>2)个字节　　　　 V(Cr)分量：　　 (720×480>>2)个字节

三个部分内部均是行优先存储，三个部分之间是Y,U,V 顺序存储。

即YUV数据的0－－720×480字节是Y分量值， 720×480－－720×480×5/4字节是U分量 720×480×5/4 －－720×480×3/2字节是V分量。

## 6.YV12

![img](https://pic4.zhimg.com/80/v2-a79ba08deec44d518347c0fe6cee62ef_720w.webp)

YV12属于YUV420格 式，也是一种Plane模式，将Y、U、V分量分别打包，依次存储。其每一个像素点的YUV数据提取遵循YUV420格式的提取方式，即4个Y分量共用一 组UV。注意，上图中，Y’00、Y’01、Y’10、Y’11共用Cr00、Cb00，其他依次类推。

RGB 到 YUV的转换

Y=0.30R+0.59G+0.11B ， U=0.493(B－Y) ， V=0.877(R－Y) , 从公式中，我们关键要理解的一点是，UV / CbCr信号实际上就是蓝色差信号和红色差信号，进而言之，实际上一定程度上间接的代表了蓝色和红色的强度，理解这一点对于我们理解各种颜色变换处理的过程会有很大的帮助。

原文作者：零声音视频开发

原文链接：https://zhuanlan.zhihu.com/p/455441075