# 【NO.410】音视频开发技术的基本知识

互联网信息的传播与娱乐方式经历了从文字到图片再到音视频的转变，现如今抖音、快手等短视频更是如日中天，特别是5G时代的到来，笔者相信互联网对音视频开发者的需求会迎来更大的增长需求，何况音视频开发者因为其稀缺性薪酬本来就比较高。

在学习音视频开发之前，我们先来了解一下音视频的基本知识。

## 1.音频

声波的三要素：频率、振幅和波形。频率代表音阶的高低，振幅代表响度，波形代表音色。

频率越高，波长就越短。低频声响的波长则较长，所以其可以更容易地绕过障碍物，因此能量衰减就小，声音就会传得远。人的听力有一个频率范围，大约是20Hz~20kHz。

音频数据的承载方式最常用的是脉冲编码调制，即PCM。

### 1.1 数字信号

在自然界中，声音是连续不断的，是一种模拟信号，那怎样才能把声音保存下来呢？那就是把声音数字化，即转换为数字信号。

将模拟信号数字化，要经过采样、量化和编码三个步骤。

音频数字化有一个问题：数字信号并不能连续保存所有时间点的振幅。

实际上，音频数字化并不需要保存连续的信号，就可以还原到人耳可接受的声音。

### 1.2 采样率

每一秒钟所采样的数目称为采样频率或采率，单位为HZ（赫兹）。采样频率越高所能描述的声波频率就越高。

> 根据奈奎斯特定理，按比声音最高频率高2倍以上的频率对声音进行采样，经过数字化处理之后，人耳听到的声音质量不会被降低。所以采样频率一般为44.1kHz。

- 8khz：电话等使用，对于记录人声已经足够使用。
- 22.05khz：广播使用频率。
- 44.1khz：音频CD。
- 48khz：DVD、数字电视中使用。
- 96khz-192khz：DVD-Audio、蓝光高清等使用。

### 1.3 量化格式

量化格式也叫采样大小或采样精度，指的是一个采样使用多少bit存放，一般是16bit，一个字节是8bit。

### 1.4 编解码

描述一段PCM数据一般需要以下几个概念：量化格式(sampleFormat)、采样率(sampleRate)、声道数(channel)。
量化格式和采样率上面提到过了，声道数是指支持能不同发声的音响的个数。不难理解，立体声道的声道数默认为2个声道。

数据比特率，即1秒时间内的比特数目。

\>

> 以CD的音质为例，量化格式（位深度）为16比特，样率为44100，声道数为2。
> 比特率:
> 比特率 = 采样率 × 采样深度 × 通道数
> 44100 * 16 * 2 = 1378.123kbps **注意这里的k表示1024**
> 一分钟音频数据的大小：1378.125 * 60 / 8 / 1024 = 10.09MB
> 注意：1个字节等于8位，也就是8比特

这不对啊，我们平时听的阴影四五分钟也才四五兆，到了你这里怎么一秒钟就十多兆了呢？这就是编码的功劳了。

我们先来看看比特率中的数字和字母到底是什么意思？

> 首先128k的全称“128kbps”，我们分解一下：128是数字，k是千位符，b是单位，s是秒，ps其实就是“/s”。这样来看，128kbps就是128kb/s。也就是每秒128kb。请注意，这里的b是小写的b，也就是位。
> 知道了这个，我们就能算出来128kb的文件大概占用多少的存储空间：
> 128*1000=128000b/s÷8=16000B/s÷1024=15.625KB/s
> 15.625KB/s*60=937.5KB/分钟÷1024=0.9155MB/分钟
> 所以，128kb的音频文件，大概每分钟长度的大小都在0.92M或者916kb左右。
> **注意b和B是不同的概念**

编码就是一个压缩的过程，而压缩又分为有损压缩和无损压缩：

有损压缩就是去掉冗余信号，冗余信号是指不能被人耳感知到的信号，包含人耳听觉范围之外的音频信号以及被掩蔽掉的音频信号等

无损压缩就是通过优化排列方式来达到压缩目的。

常见的音频编码格式：

1. WAV(无损)

WAV编码就是在PCM数据格式的前面加上44字节，分别用来描述PCM的采样率、声道数、数据格式等信息。

特点：音质非常好，大量软件都支持。
缺点：因为没用经过压缩，所以文件占用的储存空间会特别大。

适用场合：多媒体开发的中间文件、保存音乐和音效素材。

1. MP3(有损)

MP3具有不错的压缩比，使用LAME编码（MP3编码格式的一种实现）的中高码率的MP3文件，听感上非常接近源WAV文件。现如今市面上的音乐大多是这种编码格式。

特点：音质在128Kbit/s以上表现还不错，压缩比比较高，大量软件和硬件都支持，兼容性好。
缺点：由于技术比较落后，同样码率下音质会比AAC、OGG差一些。

1. AAC(有损)

AAC是新一代的音频有损压缩技术，它通过一些附加的编码技术（比如PS、SBR等），衍生出了LC-AAC、HE-AAC、HE-AAC v2三种主要的编码格式。

LC-AAC是比较传统的AAC，相对而言，其主要应用于中高码率场景的编码（≥80Kbit/s）；

HE-AAC（相当于AAC+SBR）主要应用于中低码率场景的编码（≤80Kbit/s）；

而新近推出的HE-AAC v2（相当于AAC+SBR+PS）主要应用于低码率场景的编码（≤48Kbit/s）。事实上大部分编码器都设置为≤48Kbit/s自动启用PS技术，而>48Kbit/s则不加PS，相当于普通的HE-AAC。

特点：在小于128Kbit/s的码率下表现优异，并且多用于视频中的音频编码。
不足：虽然在低码率上表现比MP3好一些，但是还没有达到全面碾压的地步。

适用场合：128Kbit/s以下的音频编码，多用于视频中音频轨的编码。

AAC格式主要分为两种：ADIF、ADTS。

ADIF：Audio Data Interchange Format。音频数据交换格式。这种格式的特征是可以确定的找到这个音频数据的开始，不能在音频数据流中间开始的解码，即它的解码必须在明确定义的开始处进行。这种格式常用在磁盘文件中。

ADTS：Audio Data Transport Stream。音频数据传输流。这种格式的特征是它是一个有同步字的比特流，解码可以在这个流中任何位置开始。它的特征类似于mp3数据流格式。

ADTS可以在任意帧解码，它每一帧都有头信息。ADIF只有一个统一的头，所以必须得到所有的数据后解码。且这两种的header的格式也是不同的，目前一般编码后的都是ADTS格式的音频流。

1. Ogg(有损)

Ogg是一种非常有潜力的编码，在各种码率下都有比较优秀的表现，尤其是在中低码率场景下。Ogg除了音质好之外，还是完全免费的，这为Ogg获得更多的支持打好了基础。Ogg有着非常出色的算法，可以用更小的码率达到更好的音质，128Kbit/s的Ogg比192Kbit/s甚至更高码率的MP3还要出色。但目前因为还没有媒体服务软件的支持，因此基于Ogg的数字广播还无法实现。Ogg目前受支持的情况还不够好，无论是软件上的还是硬件上的支持，都无法和MP3相提并论。

特点：可以用比MP3更小的码率实现比MP3更好的音质，高中低码率下均有良好的表现。
缺点：兼容性不够好，流媒体特性不支持。

适用场合：语音聊天的音频消息场景。

1. FLAC(无损)

FLAC是一套著名的自由音频压缩编码，其特点是无损压缩。不同于其他有损压缩编码如MP3 及AAC，它不会破坏任何原有的音频资讯，所以可以还原音乐光盘音质。2012年以来它已被很多软件及硬件音频产品（如CD等）所支持.

FLAC与MP3不同，MP3是音频压缩编码，但FLAC是无损压缩，也就是说音频以FLAC编码压缩后不会丢失任何信息，将FLAC文件还原为WAV文件后，与压缩前的WAV文件内容相同。这种压缩与ZIP的方式类似，但FLAC的压缩比率大于ZIP和RAR，因为FLAC是专门针对PCM音频的特点设计的压缩方式。而且可以使用播放器直接播放FLAC压缩的文件，就象通常播放你的MP3文件一样.

## 2.视频

所谓视频其实就是由很多的静态图片组成的。由于人类眼睛的特殊结构，画面快速切换时，画面会有残留，所以静态图片快速切换的时候感觉起来就是连贯的动作。这就是视频的原理。

视频帧：
既然视频是由许多静态图片组成的，那么视频的每一张静态图片就叫一帧。

视频帧又分为I帧、B帧和P帧：

I帧：帧内编码帧，大多数情况下I帧就是关键帧，就是一个完整帧，无需任何辅助就能独立完整显示的画面。

B帧：帧是双向预测帧。参考前后图像帧编码生成。需要前面的 I/P 帧或者后面的 P 帧来协助形成一个画面。

P帧：前向预测编码帧。是一个非完整帧，通过参考前面的I帧或P帧生成画面。

> 所以 I 帧是很关键的存在，压缩 I 帧就可以很容易压制掉空间的大小，而压缩P帧和B帧可以压缩掉时间上的冗余信息 。所以在视频 seek 的时候，I 帧很关键，如果视频 seek 之后发生往前的跳动，有可能就是你要seek到的位置没用关键帧，这就需要处理了。好像Android自带的播放器就会有这个问题，有时候无法精确地seek到某个位置。

还有一个叫 IDR 帧的概念，IDR都是I帧，可以防止一帧解码出错，导致后面所有帧解码出错的问题。
因为 H264 采用的是多帧预测，导致 I 帧不能作为独立的观察条件，所以多出一个叫 IDR 帧的特殊 I 帧用于参考，IDR 帧最关键的概念就是：在解码器过程中一旦收到 IDR 帧，就会立即清空参考帧缓冲区，并将IDR帧作为被参考帧。这样，即便前面一帧解码出现重大错误，也不会蔓延到后面的数据中。

**注：关键帧都是I帧，但是I帧不一定是关键帧** 这是为什么？求高人指点！！！

DTS全称：Decoding Time Stamp。标示读入内存中数据流在什么时候开始送入解码器中进行解码。也就是解码顺序的时间戳。

PTS全称：Presentation Time Stamp。用于标示解码后的视频帧什么时候被显示出来。

> **在没有B帧的情况下，DTS和PTS的输出顺序是一样的，一旦存在B帧，PTS和DTS则会不同。** 因为解码的顺序和播放的顺序可能是不一致的。

GOP（Group Of Picture）就是两个 I 帧之间的距离，一般 GOP 设置得越大，画面的效果就会越好，到那时需要解码的时间就会越长。所以如果码率固定而 GOP 值越大，P/B帧 数量会越多，画面质量就会越高。

帧率：
帧率，即单位时间内帧的数量，单位为：帧/秒 或fps（frames per second）。帧率越高，每秒切换的图片就越多，画面越顺滑，过渡越自然。
帧率的一般以下几个典型值：

- 24/25 fps：1秒 24/25 帧，一般的电影帧率。
- 30/60 fps：1秒 30/60 帧，游戏的帧率，30帧可以接受，60帧会感觉更加流畅逼真。Android系统的高性能渲染就是以60帧为标准。
- 85 fps以上人眼基本无法察觉出来了，所以更高的帧率在视频里没有太大意义。

色彩空间：

我们都知道RGB是三原色，通过RGB三种基础色，可以混合出所有的颜色。

还有一张是YUV，这种色彩空间并不是我们熟悉的。这是一种亮度与色度分离的色彩格式。
早期的电视都是黑白的，即只有亮度值，即Y。有了彩色电视以后，加入了UV两种色度，形成现在的YUV，也叫YCbCr。
Y：亮度，就是灰度值。除了表示亮度信号外，还含有较多的绿色通道量。
U：蓝色通道与亮度的差值。
V：红色通道与亮度的差值。

因为人眼对亮度敏感，对色度不敏感，因此减少部分UV的数据量，人眼却无法感知出来，这样可以通过压缩UV的分辨率，在不影响观感的前提下，减小视频的体积。大大提高传输的效率和节省带宽。
关于YUV这里我就不多说了，后面我会专门写一篇文章介绍。比如YUV444，YUV422，YUV420和YUV420sp以及YUV和RGB是如何转换的等等。

视频编码格式：

视频编码格式有很多，比如H26x系列和MPEG系列的编码，这些编码格式都是为了适应时代发展而出现的。
其中，H26x（1/2/3/4/5）系列由ITU（International Telecommunication Union）国际电传视讯联盟主导的。
MPEG（1/2/3/4）系列由MPEG（Moving Picture Experts Group, ISO旗下的组织）主导。
H264是目前最主流的视频编码标准，目前大多数的视频和流媒体都是使用这种编码格式。

> H264编码算法是十分复杂，不是三言两语能够讲清楚的，也不在我的能力范围只能，我们要做到的就是知道怎么使用就好了。

## 3.编解码

编码：编码就是将原始音频数据也就是PCM压缩的一个过程；或者是将原始的视频数据RGB或YUV压缩的一个过程。

解码：解码就是编码一个逆过程，比如将编码后的数据AAC解码成PCM给播放器播放；或者将编码后的H264数据解码成YUV或RGB给播放器渲染的过程。

编解码又分为硬件编解码和软件编解码。

软件编解码就是指利用CPU的计算能力来进行编解码码，通常如果CPU的能力不是很强的时候，一则编解码速度会比较慢，二则手机可能出现发热现象。但是，由于使用统一的算法，兼容性会很好。

硬件编解码解码，指的是利用手机上专门的解码芯片来加速解码。通常硬解码的解码速度会快很多，但是由于硬解码由各个厂家实现，质量参差不齐，非常容易出现兼容性问题。

## 4.封装格式

封装格式业界也有人称音视频容器，比如我们经常看到的视频后缀名：`mp4、rmvb、avi、mkv、mov`等就是音视频的容器，它们将音频和视频甚至是字幕一起打包进去，封装成一个文件。

原文作者：零声音视频开发

原文链接：https://zhuanlan.zhihu.com/p/431679639