# 【NO.392】C++音视频开发的技术要点

每日专注分享音视频技术点，ffmpeg，webRTC技术，流媒体服务器，SRS，sfu模型，H264码率，等等技术栈文章视频。

------

总体来讲，音视频开发是有一定的技术门槛的，我觉得至少需要在这个领域踏踏实实积累个3-5年，才能对音视频相关的开发知识有一个整体、深刻的理解。

从技术上来讲，需要从如下两个大类知识点上去积累：

## 1. C/C++通用开发知识

音视频开发的主要编程语言就是C和C++。

这块的专业知识积累是通用的，并不局限于某个特定的行业，属于程序员的技术功底。

可以重点关注如下几个方面：

计算机系统的底层工作原理

操作系统原理

程序的编译、链接和加载机制

C/C++语言特性背后蕴含的思想，底层工作原理，适用场景，存在什么样的问题

软件设计原则和设计模式

数据结构和算法

多线程并发编程原理

网络编程

跨平台

操作系统API

软件调试

## 2. 音视频领域专业知识

这块属于从事音视频行业的专业知识。

这块的专业知识是非常多的，每个功能模块背后涉及很多专业的知识。

音视频的开发可以分为两大块，涉及的内容大致如下：

音视频客户端开发

客户端应用开发

音视频引擎开发

音视频引擎SDK

音视频引擎框架

音视频引擎功能模块

音/视频采集

音/视频渲染

音/视频数据处理

音/视频编/解码

录制

串流

音视频同步

流媒体服务器开发

通用服务器开发知识，需要关注如下几个点

高稳定性

高性能

高并发

高可用

流媒体服务器开发

SFU vs MCU

流媒体协议转换

弱网下的音视频传输协议

录制 & 转码

…

上述内容中，客户端应用开发、音视频引擎SDK、音视频引擎框架、通用服务器开发等主要涉及C/C++通用开发知识，但要设计好这些部分必须对音视频相关的知识和产品业务有比较深刻的理解才能做到。

通常，音视频架构师比较关注这些部分。

而音视频引擎底层功能模块和SFU/MCU流媒体服务器的开发，则和音视频的专业知识密切相关。

音视频的采集模块

视频数据可以通过如下方式获得：

USB摄像头

专业的硬件视频采集卡（有软压卡和硬压卡之分）

网络摄像机（支持RTSP协议）

操作系统提供的屏幕录制API

读取音视频文件并解码

订阅流媒体服务器上的流

音频数据可以通过如下方式获得：

声卡

扬声器播放声音的回环采集（依赖操作系统的API）

读取音视频文件并解码

订阅流媒体服务器上的流

支持音频输入的网络摄像机（支持RTSP协议）

支持音频输入的视频采集卡

在手机上，操作系统的SDK会提供相关的音视频采集接口

音/视频渲染

视频渲染一般需要了解OpenGL，而音频渲染需要了解OpenAL

可以通过开源库SDL来快速实现渲染模块

在Windows下使用DirectShow框架，操作系统提供了对应的视频和音频渲染模块（通过GraphEdit可以看到）

在DirectShow中渲染器会涉及到音视频同步的策略，当然，也完全可以自己去实现音视频同步模块

音/视频数据处理

这些模块基本是在编码前或解码后，对视频或音频的原始数据进行某种算法上的处理

视频处理主要包括分辨率转换、色彩空间转换、帧率转换、图像增强、多路视频拼接、添加字幕、添加LOGO图片等，这块对整体的性能影响比较大，往往需要使用SIMD指令进行汇编优化或使用GPU算法进行加速

音频处理主要包括回声消除、噪声抑制、自动增益、混音等，这块往往会涉及比较多的信号处理和数学知识，是音频中比较复杂的一块

音/视频编/解码

视频编/解码

要理解视频的基本编码原理，熟悉视频编码的关键参数和码流格式

目前使用比较多的是H.264，H.265开始逐步在使用，其他的视频编码也有很多，如AVS、VP8、VP9等

视频编码对音视频引擎的性能影响比较大，这块基本都是需要使用GPU加速的，目前的Intel集显对H.264和H.265支持还是比较好的，NVIDIA的独立显卡在编码上存在路数的限制；手机上一般都有对应的硬件加速模块；在性能较好的硬件上，可以考虑开源的X264

音频编/解码

要理解音频的基本编码原理，熟悉音频的关键参数和码流格式

目前使用比较多的是AAC，其他的音频编码也有很多，如G7.11、G.722、OPUS等

在PC上，一般音频的相关模块对性能的影响不明显，但在海思嵌入式系统上，音频模块对性能的影响就不能忽略，因为海思基本没有提供音频的硬件加速模块，而ARM CPU性能也有点弱

录制

需要理解FLV、MP4、TS等容器格式

对于特殊的录制方式要注意软件的处理方式，例如，加片头和片尾的录制功能，追加录制

MP4录制要注意moov box放在文件开始或结束对录制文件的写入和点播的影响

录制时音视频均匀混合的策略

串流

理解视频互动、直播和点播的工作原理

关键评价指标

延迟

首屏时间

同步

流畅性

画质/音质

理解下述的几种音视频传输协议

RTMP

HTTP + FLV / Websocket + FLV

HLS

RTP & RTCP

RTSP

SIP

WebRTC

H.323

弱网下的音视频传输协议

理解TCP协议栈原理

可靠的UDP传输协议

KCP

SRT

QUIC

FEC + 丢包重传机制（如NACK）

音视频的开发并不是完全从零开始，而是有许多可以依赖的开源库，但要用好这些库，需要对上述的音视频专业知识有深刻的理解。

**比较常见的音视频开源库，如下：**

ffmpeg

可以直接使用ffmpeg的命令行实现转码、切片等常见功能

可以基于FFmpeg API封装开发自己的音视频模块

live555

比较完善的RTSP库

x264

比较常用的H.264编码库

fdkaac

比较常用的AAC编解码库

librtmp

支持rtmp协议，产品化时需要自己进一步完善

pjsip

支持sip协议

webrtc

google开源的webrtc库，有比较好的音/视频引擎，对网络状态的实时评估可以借鉴，回声消除模块也是比较有名的

SDL

比较有名的音视频渲染库

SRS

国内比较知名的RTMP流媒体服务器，支持HLS、HTTP+FLV，4.0版本开始支持WebRTC

OWT

Intel开源的WebRTC套件，支持了WebRTC客户端SDK和分布式的WebRTC MCU服务器

OpenCV

著名的视频算法库

另外，视频的编码和解码可以基于Intel Media SDK和NVIDIA的NVENC来实现。

在海思嵌入式上，海思芯片（如Hi3531D等）提供了硬件的音视频采集、音视频渲染、视频编/解码、视频图像处理等核心功能，这就需要借助于海思提供的SDK进行开发了。

-完-



![img](https://pic4.zhimg.com/80/v2-05fd788d5924a2ea37fb9efc77802a8b_720w.webp)

原文作者：零声音视频开发

原文链接：https://zhuanlan.zhihu.com/p/454809166