# 【NO.384】MPEG音频编码三十年

**前言**

很明显，声音信息的电子格式要早于视觉信息的电子格式，用电子格式分发声音信息的服务也是如此。同样，音频的数字格式与视频数字格式的出现时间也不同。在上世纪80年代初，唱片公司可以通过CD（Compact Disc）向消费者市场发行数字音频，而在80年代后期出现的D1数字磁带则专用于录音室的专业应用。但压缩技术却颠倒了它们的出现顺序：压缩数字视频比压缩数字音频要早10年。所以和之前我所写的文章《视频编码四十年》[1]不同，本文的标题是《音频编码三十年》。

如果**音频**缺乏恰当的定义，那么这篇文章有可能成为争议来源。在本文中，我们所指的音频是人类可听范围内的声音，而非人类发声系统所产生的声音或者发声模型不可用的其他音源。实际上，早在CD出现之前的20年，数字语音就已经存在于专业应用（trunk network，主干网络）中了。ITU-T G.721的“32 kbit/s ADPCM（adaptive differential pulse code modulation，自适应差分脉冲编码调制）”可以追溯到1984年，同一年H.120被批准为推荐标准。

因此，本文的标题也可以是《音频编码四十年》。不过如果以此为标题的话，本文将充斥大量的语音压缩标准，而使真正的音频标准失去了关注。因此，本文将只关注音频压缩标准，其中的音频并不包括语音。但其中有一个例外，我会在下文提到。

与视频压缩中ITU-T（国际电信联盟电信标准化部门）这个非MPEG组织开发了视频编码标不同，音频压缩中MPEG占据主导地位。需要音频压缩用于数字音频广播标准的ITU-R（国际电信联盟无线通信部门）也倾向于依赖外部资源，其中就包括MPEG。

**MPEG-1 Audio**

关于MPEG（专注于视频压缩领域的组织)如何以及为何会研究音频压缩，感兴趣的人可以阅读这篇文章（其中还包括许多其他内容）：https://ride.chiariglione.org/the-1st-mpeg-project/。 MPEG音频工作组成立活动于1998年12月1-2日举行，当时最多元化的音频编码专家组在汉诺威（德国城市）会面（当时这一传统还没有完全确立）并启动了这项工作，在大家的不懈努力下，最终MPEG在1992年11月推出了MPEG-1音频标准。

MPEG中的音频组常常是未来创新的先行者。比如，其一，广播世界还在回避低分辨率的MPEG-1视频压缩标准时，它却非常重视MPEG-1音频压缩标准；其二，与视频主要依赖相同的编码架构不同，音频征集提案需要产出两类算法：一类充分成熟、易于实现、但是效果稍差；另一类算法更新、在当时却比较难实现，但效果更好。将两类算法合并的工作非常辛苦，但终于实现了使用这两种技术的三层（3 Layers）标准。

Layer 1用于数字压缩磁带（DCC），这个产品在几年以后停用了；Layer 2用于音频广播，以及作为Video CD（VCD）的音频组件使用；第三层（MP3）就不需要特别介绍了。MP3在接下来的MPEG-2中进行修订后，它在听感上与原CD信号几乎没有差异的同时，提供128 kbit/s的码率。这与原本CD信号1.44 Mbit/s的码率相比，实现了11:1的压缩。

**MPEG-2 Audio**

该标准于1994年批准，主要目的是用于多声道音频，其中的关键要求是MPEG-1音频解码器应能解码MPEG-2音频码流的立体声组件。向后兼容在广播领域十分有用，因为运营商可以升级到多声道服务，而不会失去只拥有MPEG-1音频解码器的客户。

**MPEG-2 AAC**

人们希望提供最佳质量音频而不受向后兼容约束，这种需求推动了MPEG-2 AAC的工作。这意味着Layer 2必须同时解码Layer 1和Layer 2，而Layer 3必须解码所有Layer。1997年4月所发布的MPEG-2 AAC就是构建在MP3技术之上，可以提供128 kbit/s 码率听感透明的立体声信号和320 kbit/s 的5.1声道信号（例如数字电视中的信号）。

**MPEG-4 AAC**

1998年，MPEG-4 AAC与其他两个MPEG-4组件（Systems and Visual，系统和视觉）一同发布。MPEG-4 AAC也是构建在MPEG-2 AAC之上。2003年，Apple宣布旗下的iTunes和iPod将使用MPEG-4 AAC作为主要的压缩格式，这一举动动摇了MP3在音乐发行中的主导地位。大部分PC、智能手机和之后的平板都可以播放AAC歌曲。Apple没有把AAC当作纯粹的播放器技术使用，它推出的iTunes服务提供以MPEG-4 文件格式打包的AAC格式的歌曲，文件扩展名为“.m4a”。

**AAC-LD**

1999年，MPEG发布了包含AAC低延迟版本的MPEG-4 Amendment 1，被称为AAC-LD（Low Delay AAC，低延迟AAC）。AAC编码器/解码器通常需要约55毫秒的单向延迟（转换延迟+look-ahead处理），而AAC-LD通过简化和替换某些AAC工具（更低延迟的新转换和look-ahead处理的移除）达到了仅21毫秒的单向延迟。AAC可以作为通话编解码器使用，同时具有音乐编码器的信号带宽和感知音质，并且可以对单声道信号在64 kb/s码率时实现卓越的音质。

**MPEG-4 HE-AAC**

2003年，作为MPEG-4的第一次修订，MPEG发布了MPEG-4 HE-AAC（High Efficiency Advanced Audio Coding）。HE-AAC巩固了移动手持设备作为高音质音频获取工具的地位，能够以48 kbit/s接收高音质立体声音乐（压缩能力比AAC高出2.5倍）。与CD信号相比，它的压缩比几乎达到了30:1。

HE-AAC向核心AAC引擎添加了SBR（Spectral Bandwidth Replication，频谱带宽复制）。由于AAC已被广泛部署，因此允许通过仅将SBR工具添加到现有AAC实现中而扩展为HE-AAC。

**MPEG HE-AAC v2**

同样在2003年，9个月之后，MPEG 推出了MPEG HE-AAC v2。它源于MPEG-4二次修订（Parametric coding for high-quality audio，高质量音频的参数编码）中所包含的工具。虽然核心参数编码器并没有被广泛接受，修订中的PS（Parametric Stereo，参数立体声）工具可以将立体声音乐高效编码为单声道信号加少量辅助信息（side information）。 HE-AAC v2——PS工具和HE-AAC的结合，能够以32 kb/s传输具有优质音频质量的立体声信号。

3GPP也采用了HE-AAC v2，并将其命名为Enhanced aacPlus。3GPP的采用为HE-AAC v2技术集成到移动电话创造了条件。今天，超过百亿的移动设备支持HE-AAC v2格式歌曲的传输和播放。由于HE-AAC构建于AAC之上，所以这些设备也支持AAC格式歌曲的传输和播放。

**ALS 和SLS**

2005年，MPEG发布了两种用于无损压缩音频的算法——ALS（Audio Lossless coding）和SLS（Scalable to Lossless coding）。这两种算法都可以完美（即无损）重建标准的CD音频信号，压缩比接近2:1。具有可变的压缩比是SLS的一个重要特性：它可以将立体声信号压缩到128 kb/s（11:1压缩比），并达到和AAC编解码器一样的出色质量，但它是通过持续增加编码码率（即降低压缩比）实现压缩比为2:1的无损重建。

**MPEG Surround（MPEG环绕声）**

ALS/SLS是MPEG-4中最后一批重要的标准，它们也是MPEG中“最长寿”的音频标准。第一个版本于1999年发布，20年以后（2019年），MPEG才发布了第五个版本。

在MPEG-4退出历史舞台之后，MPEG开发了MPEG-D系列音频编码标准。其中第一个就是MPEG Surround（MPEG环绕声），于2007年发布。在某种意义上，这项技术是HE-AAC v2工具的通用PS（Parametric Stereo，参数立体声），MPEG Surround可以被用作5-2声道压缩工具，或者M-N声道压缩工具。这个通用的PS工具其后就是HE-AAC编解码器。因此，MPEG Surround构建在HE-AAC之上，正如HE-AAC构建在AAC之上。MPEG Surround为低码率应用的立体声和多声道之间提供了连接。它具备良好的压缩效果，同时保持了非常清晰的音质，且算力消耗较低。虽然HE-AAC能够以48 kbit/s传输立体声，但MPEG Surround可以在相同的48 kbit/s传输预算下传输5.1声道音频，且复杂度不超过立体声 HE-AAC。因此，想要将立体声服务拓展到5.1声道音频，可以使用MPEG Surround直接替代。

**AAC-ELD**

2007年，MPEG推出了AAC-ELD（Enhanced Low Delay AAC）技术。这项技术结合了来自其他标准的工具：HE-AAC v2和AAC-LD的SBR和PS。这个新的编解码器在适度增加延迟的同时提供了更加强大的信号压缩：AAC-ELD以48 kb/s的速度为单声道信号提供出色的音频质量（单向延迟仅为32毫秒）。

**SAOC**

2010年，MPEG发布了MPEG-D SAOC（Spatial Audio Object Coding，空间音频对象编码），它可以高效编码多声道信号（多个对象的混合，比如将各种单一乐器混合）。SAOC将多声道信号下行混音（例如立体声到单声道），先将单声道信号和一些辅助信息进行编码和传输，然后将接收到的单声道信号和辅助信息进行解码然后上行混音到立体声信号，以便用户感知到乐器被放置在正确位置，且最终立体声信号与原始信号相同。这是通过以下方法实现的：在任何时刻任何频率区域，其中一种乐器将更倾向于主导其他乐器，所以此时/此频率区域，其他信号（如果存在的话）将更难被感知到。SAOC分析输入信号，将每个声道分为时间“块”和频率“块”，然后再确定每个“块”的主导程度。这些信息都被编码为辅助信息。

SAOC的一个应用是远程会议，其中多个地点的会议电话可以在会议连接时被混合为单一声道，并和SAOC的辅助信息一起传输给每个会议参与者。在用户终端，单声道被上行混音为立体声（或者三声道：左-中-右）并进行呈现，使得每个远程会议参与者都处于前音场的不同位置。

**USAC**

2011年，MPEG推出了USAC（Unified Speech and Audio Coding），它将语音编码和音频编码工具合并到一个算法中。USAC结合了MPEG AAC工具（利用人类感知音频方法）和最先进的语音编码工具（利用人类产生语音的方法）。因此，编码器同时具备感知模型和语音激励模型/声道模型，可以每隔20毫秒动态地选择音乐/语音编码工具。使用这种方法，USAC在压缩任何输入信号（无论是音乐、语音还是音乐和语音的混合信号）时都达到了高水平的性能。

按照MPEG标准的传统，USAC将立体声信号的“良好”性能扩展到低至16 kb/s，并随着码率的提升提供更高的音质。128 kbit/s的立体声信号质量稍好于MPEG-4 AAC，因此USAC可以代替AAC，因为在任何码率下，USAC在性能上都能与AAC匹敌，或者优于AAC。类似地，USAC能够编码多声道音频信号，并且能够以最佳方式编码语音内容。

**DRC**

MPEG-D DRC（Dynamic Range Control，动态范围控制）技术可以让听者能够控制音频水平。它可以作为每种MPEG音频编码技术的后处理器使用，并在播放时修改解码信号的动态范围。DRC可用来降低电影中音量最大的部分，这样就不会打扰到你的邻居。它可以在恶劣音频环境下（汽车、公交车、房间里有很多人）放大音频中的安静部分，还可以将音频的动态与智能手机扬声器的输出（其动态范围通常非常有限）匹配。在规范音频输出信号音量方面（在一些监管环境中可能会强制执行），DRC标准也发挥了非常重要的作用。DRC发布于2015年，并在2017年扩展为Amendment 1参数型DRC，增益映射和均衡工具。

**3D Audio**

MPEG-H 3D音频发布于2015年，一如既往，它也是MPEG系列工具（系统、视频和音频）中的一部分。它提供了沉浸式音频内容的高效编码：编码范围通常在11~22个内容声道。3D音频算法可以处理任何声道组合、对象以及HOA（Higher Order Ambisonics）内容。HOA中对象为单声道音频，具有动态的时间位置，HOA能够将整个声场编码为多声道“HOA系数”信号。

由于3D音频内容是沉浸式的，所以可以将其看作是一部360度“电影（即视频加音频）”。用户坐在360度球体中心（最佳聆听地点），音频被解码和呈现给用户，这样用户就会感知到来自周围环境中某个地方的音频。MPEG-H 3D音频也可以通过耳机呈现，因为并不是每个用户都拥有11或者22声道的聆听空间。除此之外，MPEG-H 3D音频支持HRTF（Head Related Transfer Function，头相关变换函数）的默认和个性化使用，以便使听者感知音频内容（仿佛来自听者周围的音源），就像使用扬声器一样。3D音频在耳机中播放所添加的一个功能是：无论听者如何转动头部，听者所听到的音频可以一直保持在“正确位置”。也就是说，当用户看向前方时，声音是来自“前方”，而当用户转动头部看向右侧时候，声音会被感知为来自用户左侧。因此，对于360度视频应用来说，MPEG-H 3D音频已经是一个接近完整的解决方案了。

**结语**

在这三十年中，MPEG的音频组向市场输入了一代又一代的音频编码标准。作为MPEG最佳传统，这些标准在某种意义上是通用的，可用于纯音频或者音频+视频应用程序。随着新一代音频编码标准构建在前代编码标准之上，这些编码标准通常可进行扩展。

下图展示了这三十年的音频编码之路。

![图片](https://oscimg.oschina.net/oscnet/up-8b45373170944c378ddcac1e21621fcc099.png)

令人遗憾的是，MPEG组织已经不复存在了，但是关于MPEG的记忆都保存在了我的博客上：

https://mpeg.chiariglione.org/，欢迎大家阅读。

**注释：**

[1] https://blog.chiariglione.org/forty-years-of-video-coding-and-counting/

**致谢：**

本文已获得作者Leonardo Chiariglione授权翻译和发布，特此感谢。

**原文链接：**

https://blog.chiariglione.org/thirty-years-of-audio-coding-and-counting/

**特别说明：**

作者在原文基础上进行了修改，并审阅了本篇中文译文。

原文作者：Leonardo Chiariglione

原文链接：https://www.livevideostack.cn/news/thirty-years-of-audio-coding-and-counting/