# 【NO.383】腾讯云实时音视频出海技术实践及落地

**编者按：** 互联网出海热潮涌动，社交娱乐、跨境电商、在线教育等产品与音视频技术密切相关，如何在纷繁复杂的基础设施和网络条件下提供高质量的音视频服务，是出海产品和云服务商面临的共同挑战。

本次分享将详细介绍腾讯云音视频客户在出海过程中所遇到的挑战，以及RT-ONE™网络的应对策略，为出海应用的音视频技术实践提供参考借鉴。

*文/崔立鹏
整理/LiveVideoStack*

![图片](https://oscimg.oschina.net/oscnet/up-b2c03aaa9767376373c6dad69832521792d.png)

今天跟大家分享的内容是腾讯云音视频在出海方面的一些技术实践，在最开始，我想分享下一个问题，为什么要讲出海？其实，这两年我们可以感受到国内的消费互联网到了平稳发展的阶段，像前几年那样创新应用层出不穷，某些应用一下子就能爆火的情况越来越少出现了。在这种情况下，国内很多公司都选择出海，去海外发展自己的业务，这是我们观察到整个行业的一个趋势。腾讯云也是顺应这个潮流，来支撑这些客户的业务发展，在此之外，腾讯云在全球都有布局，海外一些本土的客户也是有音视频需求的。虽然原来我们以国内业务为主，被行业不同的客户磨炼到今天，我们可以看到在产品实力上并不比国外云厂商差，有些方面的竞争力反而是领先的，这也是我们出海的一个比较好的信心来源。

![图片](https://oscimg.oschina.net/oscnet/up-51478b18297c80158209d8d9c0cd80a66f0.png)

然后再来看一下行业的情况，从整体上来看，海外音视频的应用是在蓬勃发展的。最近两年，国内市场抖音，快手，视频号增长还不错，但是新的应用比较少。但整个海外的情况，2020到2021年，娱乐出海的收入指数翻了两倍多，在全球社交应用推广榜Top20里，有十几家都是国内出海的客户，除了TikTok大家还比较熟悉之外，有些本地人都不知道是中国的应用，比如BIGO，LiveMe。我们C端产品的竞争力其实是很不错的，能够和欧美厂商PK。

![图片](https://oscimg.oschina.net/oscnet/up-fc29d0476cc87e2f2d7b66a4dcd5354100f.png)

在整个泛娱乐出海大潮下，音视频是重头戏，但音视频出海还是面临着很大的挑战。这可能和其他应用的出海不同，比如图文类或者阅读类应用的出海不会有特别多的技术相关的挑战，包括国内基础设施比较完备在音视频方面也都能比较好支撑，但海外环境对音视频技术挑战巨大：

1. 海外的用户网络很不稳定的，带宽受限，丢包比较多这种情况经常存在；
2. 一些国家的运营商可能会封禁UDP流量；
3. 用户的机型也比较复杂，国内只有几大手机厂商，但是国外有很多很老的手机厂商也在使用，这部分用户的终端性能问题突出；
4. 应用升级的覆盖周期很长，国内网络比较流畅，大家应用升级比较快，但是海外的很多用户可能几个月都达不到很高的版本覆盖，这导致在升级一些功能的时候出现了很大的挑战；
5. 安全合规在国内一直在收紧，海外的安全合规要求更高，像GDPR这些，这对企业来说也是红线，这对我们也提出了一些要求；
6. 创新玩法也是不断要更新迭代的。

为了应对这些挑战，作为基础设施厂商，我们还是要想办法解决这些问题。我接下来会分两块来讲解，一块是产品上的优化，一块是玩法上的创新。

## **1.产品优化**

![图片](https://oscimg.oschina.net/oscnet/up-e90702a5ed5d9d21c0ea4c513a3260960b5.png)

去年在LVS上海站大会上，我们发布了云端一体的方案：云上的RT-ONE™音视频通信网络和端上的视立方SDK RT-cube™方案。这是基于我们多年的音视频服务经验，发现很多开发者想要一个综合的解决方案，比如，在做音视频通话的时候是需要发文字消息的，做直播的时候是需要弹幕或者美颜的。因此我们做了一个决定：通过云端一体的方案来满足行业需求。推出市场一年之后，我们可以看到融合之后效果还是不错的，举一个简单的例子：我们之前的直播主要是RTMP推流CDN拉流, 端到端延迟在3到5秒左右，如果客户想要更低延迟的直播，那么可以用1秒左右延迟的快直播，还有客户需要主播间连麦互动时，300毫秒以内有RTC。但是，这么一个个的产品的SDK是比较分裂的，每个能力都需要单独对接。通过融合之后，开发者可以很方便地在这三者间做平滑的切换，比如主播要去互动的时候就用RTC，观众需要观看的时候就可以走高延迟的CDN直播或者快直播，如果主播想要互动的话，直接再切成RTC。通过这种融合，可以帮助开发者大幅度降低开发门槛，以及产品体验上的提升。All in one SDK包含了采集、美颜、传输、直播/点播的播放还有短视频内容剪辑，这些产品能力的组合，可以帮助行业内开发者更快实现一些产品功能。

![图片](https://oscimg.oschina.net/oscnet/up-be154df1896f229129b23702c578009ef20.png)

全球的网络部署方面也是很重要的。实际上，我们在很多国家发现网络覆盖还不好，比如在南美和非洲，我们的布点是不够的，经过过去几年的发展，我们在全球部署了2800多个加速节点，有200T的带宽储备，我们整个腾讯的27个区域，71个可用区都部署了RT-ONE™的服务，这保证了我们在全球能有一个比较好的网络覆盖。在比较好的网络覆盖的基础上，去做一些技术方面的优化就会变得更容易一些。

![图片](https://oscimg.oschina.net/oscnet/up-7ff1f4c22151726249cbbb0204a63097c80.png)

接下来就是QoS优化的问题。整个RTC传输里，大家遇到最重要的问题就是要怎么去对抗拥塞、丢包、抖动、延时这些问题。我们通过云端智能流控引擎，去应对海外的极端网络环境，比如限带宽，有些地区用户的下行网络只有100kbps左右；还有高丢包，突发抖动等场景。这里是RTC流控的整个架构图，我们可以看到在客户端上，在本地做音视频采集之后，会把CPU等相关网络参数实时上报，还有网络模块，它会对本地抖动做一个统计，并进行初步的带宽评估，与QoE相关的音频卡顿，视频卡顿统计之后，上传到智能流控引擎，智能流控引擎会根据实时数据做一个决策，去决定最终用一个怎样的码率进行传输。在极端的情况下，我们可以把视频的码率降到100k以内，来保证用户有最基础的通话质量。在最开始设计的时候，我们进行了一个模块化的设计，状态上报系统和云端配置系统是独立的，这保证了后期升级的时候更快速便利，例如，我们之前用大数据和人工智能去处理之前一些地区的数据去实现一个更好的QoS算法。另外，针对udp封禁的情况，我们降级至tcp去进行传输，为了保证用户能够实现一个基础通话。

![图片](https://oscimg.oschina.net/oscnet/up-39bd823bd129b541a7a127f2b75e6d92bb1.png)

另外一块就是音频的优化，我们使用了天籁实验室开发的信源信道联合编码技术。音频端到端传输包括从采集到前处理、编码、再到传输，再到解码、增强、回放。传统的音频传输优化集中在信道环节，比如FEC实际上是通过增加带宽消耗来降低丢包率，但FEC加多反而会导致更大的网络浪费。我们在这个基础上把优化聚焦到了信源这一环节，希望在信源侧淡弱FEC，实现更高效的带宽利用。除了本身信源侧的FEC之外，我们还结合了信道的FEC来联合调控，实现更高效率的带宽利用。大家可以看一下右图，这是一个高码率应用传输的比例，我们新的算法生成之后，FEC后高码率流下降30%，卡顿率下降50%，这是信源信道联合编码技术带来的优化。

![图片](https://oscimg.oschina.net/oscnet/up-d840fffc5b730d167c47dbf4624dfdaba38.png)

此外我们也通过音频混流来对下行带宽进行了优化。海外市场很多应用都是用来做语聊的，比如房间内有8个主播聊天，有几十个观众在收听，如果按正常的50k码率的音频来计算，每个人去拉流，就有400k码率的下行带宽需求。如果使用刚才的技术，其实能优化的也是有限的。所以我们选择在房间内把这些音频混在一起之后，再推回房间，然后用户拉流的时候只需拉一路，就能收到8个人的声音，这可以直接把下行带宽的占用从400k降到50k，这对用户的下行网络是有极大改善的。除此之外，比如语聊房中需要知道哪个主播在说话，主播音量的波动需要能体现出来，这在常规的单流拉流上很容易判断，但混流之后，就比较麻烦了，所以我们在做云端混流的时候加入每个发言人的身份和音量的信息到SEI里进行下发，同时我们也针对发言人比较多的情况进行一个能量竞争选路，来确保最终的产品能力和不混流是一样的。

![图片](https://oscimg.oschina.net/oscnet/up-46c98fff945d89c4ba3d22e0c174aa6578e.png)

在视频方面，我们也做了ROI编码优化的工作，我们把更多的码率分配至用户关注的区域上。通过观察左边原始的编码方案以及右边的ROI编码方案，我们可以看到主播脸部的清晰度明显提升，这是码率分配的策略，这个策略使得整个视频的码率降低20%-30%左右。

![图片](https://oscimg.oschina.net/oscnet/up-eedfa6185f239eeaea5668ee4d176eb5918.png)

另外就是之前提及的安全合规，这方面随着各国监管的逐渐规范，挑战也越来越严峻。如果提供基础技术的厂商无法通过这些认证，就会给客户带来很多合规风险，所以我们也做了大量的工作，比如我们需要独立部署的环境，国内外的隔离，来实现符合当地法律法规，也通过了一些权威认证比如ISO27017/27018/27701/29151、CSA STAR、NIST CSF等。对出海应用来说，合规是生命线，一定不能掉以轻心。

## **2.玩法创新**

下面，我分享一下与玩法创新相关的内容，之前也提及过，海外的创新玩法是层出不穷的。我们观察到，在线社交娱乐在向虚拟化、沉浸式发展演进。

![图片](https://oscimg.oschina.net/oscnet/up-2faa18a1b6de958ceb3309768f16a5d9485.png)

通过左边的曲线图，我们可以看出虚拟形象社交App的全球下载量增速非常迅猛，这也是为什么行业内都在关注的元宇宙等相关概念。受风俗文化影响，海外一些区域的用户习惯与国内用户不同，比如国内直播比较普遍，但是中东反而语聊更多，用户不愿意视频的情况下，虚拟形象可以用来代替露脸，能够传达的信息也比语聊更多一些。在虚拟形象社交App中，我们可以看到卡拉OK、语音聊天和儿童早教类App占比较高。

![图片](https://oscimg.oschina.net/oscnet/up-023e3738e2c42ae6da7754b2bc9fa137030.png)

针对这些情况，我们也提供了相应的方案。比如给QQ音乐开发的演唱会场景，当用户参与虚拟演唱会时，每个用户可以通过在聊天框内输入弹幕或者特定指令操作虚拟世界里对应人物。还有给斗鱼做的云蹦迪，还有下面的云端虚拟会展类场景都比较有意思，越来越多的社交应用也往这方面发展。

![图片](https://oscimg.oschina.net/oscnet/up-f98d0aa456b8b3d3bbf36269bc78138eb97.png)

针对这些行业需求，我们同样开发了云+端方案：

云渲染指的是画面是在云端渲染出来的，并不需要在客户端集成渲染引擎，只需要打开一个网页或者一个播放器就可以加载播放视频。在需要互动的情况下，通过信令也能传到云端。

端渲染是指在客户端通过SDK，通过Unity等渲染引擎实现的虚拟场景渲染，比如可以支持用户自定义“捏脸”，表情随动或者语音驱动。

除了视频渲染方面，元宇宙里音频方面的需求也可能不同，比如在沉浸实时互动中，可能需要无限用户上麦。在一个比较大的虚拟世界里，可能有上千人在互动，这些人都是开麦的，你走进一个区域，你能听见附近的人说话，听不见较远的人说话。之前，业内一般只能做到50人上限，这极大地限制了虚拟世界的广度，所以我们就开发了无限上麦的功能。还有3D空间音频，在一个虚拟世界里，我们希望听到的声音是有方位感的。上述功能构成了整个沉浸式实时互动方案。

![图片](https://oscimg.oschina.net/oscnet/up-949cfd9c0704f6c8e92925adef70a29875a.png)

这里也展开介绍一下基于云渲染的虚拟直播。之前提及QQ音乐的云端演唱会是一个比较典型的场景。我们底层提供了云渲染PaaS平台，这是基于腾讯的IaaS去部署的，可以渲染设计好的虚拟世界的场景，比如演唱会的场景，其中虚拟角色的场景，还有沟通软件等都可以在上面运行。在此基础上，我们可以实现多人的互动房间，动捕或者弹幕驱动虚拟人，在云渲染出来之后，可以通过快直播来拉流播放，例如QQ音乐的云端演唱会和斗鱼的云蹦迪。这项技术支持多人会议、线上会展、偏游戏类偏互动类的娱乐场景以及虚拟客服等。

![图片](https://oscimg.oschina.net/oscnet/up-68620a341892948436c9a21b25e5f3e896a.png)

这是云渲染虚拟直播方案的架构图。从观众端来看，通过网页或者播放器拉云端渲染出的直播流进行播放，用户操作通过弹幕或者鼠标按键采集后，通过信令通道发送到云端的云渲染引擎。云渲染会结合用户输入把视频模型渲染出来。同时，也有一些活动控制插件，比如角色、场景、镜头和控场。主播端的权限会多一些，云渲染为他渲染出独立视角，供全网用户直播观看，如果有观众想加入到活动现场看到自己视角的画面，云渲染也可以为他单独渲染一幅个人视角的画面。

![图片](https://oscimg.oschina.net/oscnet/up-73013ffae6adfc8b820500642b625f3a9f8.png)

其次是基于端渲染的虚拟直播方案。刚才提到的云渲染在一些场景下还是存在限制，比如用户的下行网络不流畅的情况下，视频还是会出现卡顿，其次云渲染的画面成本较高，更适合多人直播的场景，不适合每个人都去渲染画面。在此情况下，端渲染还是有其独一无二的优势。它不需要太多的网络带宽，只用传很小的信令数据就可以实现驱动。我们开发了一套Avatar的虚拟形象和3D虚拟世界的套件，让用户可以通过拍照自动生成自定义形象，用户可以用声音、面部表情进行驱动。在虚拟世界里，面部可以有不同的视角，第一人称或者第三人称的视角，用户还可以做动作，比如移动、打招呼等。我们也开发了一些常见的场景如会议类、KTV类、蹦迪类等场景。

![图片](https://oscimg.oschina.net/oscnet/up-3381d4c82dada3e7d66c2ffecbc14f39778.png)

再者是我们刚才提及的无限上麦，最初我们称其为千人上麦，然后我们发现也不止千人，更多人数也是可以支持的。它最典型的场景是右下角的场景，每个人在一个场景里，每个人都能听到附近的人说话。整个虚拟世界里可能有上千人，所有人都是可以开麦开摄像头的，我们只需要在拉流的时候只拉附近的流就可以，我们可以输入他的位置去进行声音的选录，确保他只听到一部分与他相关的人的声音。

![图片](https://oscimg.oschina.net/oscnet/up-7c38c27a5706eb2bba7c66f4bba6800b167.png)

**3D音效体验** 音频： 进度条 *00:00* *00:51* 后退15秒 倍速 快进15秒

↑↑3D音频请使用耳机收听↑↑

最后是虚拟世界里的空间音频：基于位置的3D实时语音。大家都能够容易的分辨出声音是从哪个方向来的，是因为如果一个声音在不同的位置，我们两只耳朵听到的声音不一样。基于这个原理，我们只需把两只耳朵听到的声音记录下来，回放出来，我们就会觉得这个声音就是在某个位置的。HRTF技术就是实现声音从无方位感到有3D位置声音的转化，实现空间音频的效果。在虚拟世界里，比如在虚拟会议和娱乐类的场景中，如果我们希望更有沉浸感的体验，可以通过这个技术来实现。比如在吃鸡类的游戏中，大家可以通过这个技术去锁定对方的位置。

## **3.未来的挑战与思考**

刚才提到了一些我们具体的技术优化和玩法创新，截至目前为止，我们服务了国内大多数的出海企业，比如在海外很火的Weplay、SoulChill 等游戏或社交类应用。腾讯云音视频作为国内音视频云服务的代表，在支撑国内应用出海方面责无旁贷。

![图片](https://oscimg.oschina.net/oscnet/up-f780e970f409e9886549da7996b2a84ba47.png)

最后，我也分享一下我们对于未来的挑战和思考。国内的大环境越来越内卷，市场竞争特别激烈，新业务发展特别困难。经过多年激烈市场竞争的洗礼，很多国内互联网公司的产品还是很有竞争力的，我们可以借着现在的机会走出去，把优秀的产品输出到更多国家，寻找更广阔的市场。当然出海的过程可能会面临种种挑战，比如要做好本地化运营和跨国团队的管理，要从零建立生态链，但总的来看当前是最好的时机。腾讯云作为底层音视频技术提供方，也希望能和大家一起共创，把腾讯积累的成熟技术分享给业内更多从业者，让大家出海更顺畅一些。也期待跟更多从业者交流，一起把中国企业出海做大做强！

原文作者：*崔立鹏*

原文链接：https://www.livevideostack.cn/news/tencent-cloud-real-time-audio-and-video-technology-practice-and-landing/