# 【NO.316】作为程序员，如何彻底理解高并发中的协程

作为程序员，想必你多多少少听过**协程**这个词，这项技术近年来越来越多的出现在程序员的视野当中，尤其高性能高并发领域。当你的同学、同事提到协程时**如果你的大脑一片空白，对其毫无概念。。。**

![img](https://pic1.zhimg.com/80/v2-8e644b4905f84d7869da06d7eab4cc60_720w.webp)

那么这篇文章正是为你量身打造的。话不多说，今天的主题就是作为程序员，你应该如何彻底理解协程。

**普通的函数**

我们先来看一个普通的函数，这个函数非常简单：

```text
def func():
   print("a")
   print("b")
   print("c")
```

这是一个简单的普通函数，当我们调用这个函数时会发生什么？

1. 调用func
2. func开始执行，直到return
3. func执行完成，返回函数A

是不是很简单，函数func执行直到返回，并打印出：

```text
a
b
c
```

So easy，有没有，有没有！

![动图封面](https://pic1.zhimg.com/v2-2682e7b6f1d6311effccb552410a3f9c_b.jpg)



很好！注意这段代码是用python写的，**但本篇关于协程的讨论适用于任何一门语言**，**因为协程并不是一种语言的特性**。而我们只不过恰好使用了python来用作示例，因其足够简单。那么协程是什么呢？

**从普通函数到协程**

接下来，我们就要从普通函数过渡到协程了。和普通函数只有一个返回点不同，协程可以有**多个返回点**。这是什么意思呢？

```text
void func() {
  print("a")
  暂停并返回
  print("b")
  暂停并返回
  print("c")
}
```

普通函数下，只有当执行完print("c")这句话后函数才会返回，但是在协程下当执行完print("a")后func就会因“暂停并返回”这段代码返回到调用函数。有的同学可能会一脸懵逼，这有什么神奇的吗？我写一个return也能返回，就像这样：

```text
void func() {
  print("a")
  return
  print("b")
  暂停并返回
  print("c")
}
```

直接写一个return语句确实也能返回，**但这样写的话return后面的代码都不会被执行到了**。协程之所以神奇就神奇在当我们从协程返回后**还能继续调用该协程**，并且是**从该协程的上一个返回点后继续执行**。这足够神奇吧，就好比孙悟空说一声“定”，函数就被暂停了：

```text
void func() {
  print("a")
  定
  print("b")
  定
  print("c")
}
```

这时我们就可以返回到调用函数，当调用函数什么时候想起该协程后可以再次调用该协程，该协程会从上一个返回点继续执行。Amazing，有没有，集中注意力，千万不要翻车。

只不过孙大圣使用的口诀“定”字，在编程语言中一般叫做yield(其它语言中可能会有不同的实现，但本质都是一样的)。需要注意的是，当普通函数返回后，进程的地址空间中不会再保存该函数运行时的任何信息，而协程返回后，函数的运行时信息是需要保存下来的，那么函数的运行时状态到底在内存中是什么样子呢，关于这个问题你可以参考**[这里](https://link.zhihu.com/?target=http%3A//mp.weixin.qq.com/s%3F__biz%3DMzU2NTYyOTQ4OQ%3D%3D%26mid%3D2247484963%26idx%3D1%26sn%3D542d3bec57c6a9dfc17c83005fd2c030%26chksm%3Dfcb9817dcbce086b10cb44cad7c9777b0088fb8d9d6baf71ae36a9b03e1f8ef5bec62b79d6f7%26scene%3D21%23wechat_redirect)**。接下来，我们就用实际的代码看一看协程。

**Show Me The Code**

下面我们使用一个真实的例子来讲解，语言采用python，不熟悉的同学不用担心，这里不会有理解上的门槛。在python语言中，这个“定”字同样使用关键词yield，这样我们的func函数就变成了：

```text
void func() {
  print("a")
  yield
  print("b")
  yield
  print("c")
}
```

注意，这时我们的func就不再是简简单单的函数了，而是升级成为了协程，那么我们该怎么使用呢，很简单：

```text
def A():
  co = func() # 得到该协程
  next(co)    # 调用协程
  print("in function A") # do something
  next(co)    # 再次调用该协程
```

我们看到虽然func函数没有return语句，也就是说虽然没有返回任何值，但是我们依然可以写co = func()这样的代码，意思是说co就是我们拿到的协程了。接下来我们调用该协程，使用next(co)，运行函数A看看执行到第3行的结果是什么：

```text
a
```

显然，和我们的预期一样，协程func在print("a")后因执行yield而暂停并返回函数A。接下来是第4行，这个毫无疑问，A函数在做一些自己的事情，因此会打印：

```text
a
in function A
```

接下来是重点的一行，当执行第5行再次调用协程时该打印什么呢？如果func是普通函数，那么会执行func的第一行代码，也就是打印a。但func不是普通函数，而是协程，我们之前说过，协程会在上一个返回点继续运行，因此这里应该执行的是func函数第一个yield之后的代码，也就是print("b")。

```text
a
in function A
b
```

看到了吧，协程是一个很神奇的函数，它会自己记住之前的执行状态，当再次调用时会从上一次的返回点继续执行。

**图形化解释**

为了让你更加彻底的理解协程，我们使用图形化的方式再看一遍，首先是普通的函数调用：

![img](https://pic1.zhimg.com/80/v2-c2866a7fb52187265c5556a4ef43faf0_720w.webp)

在该图中，方框内表示该函数的指令序列，如果该函数不调用任何其它函数，那么应该从上到下依次执行，但函数中可以调用其它函数，因此其执行并不是简单的从上到下，箭头线表示执行流的方向。从图中我们可以看到，我们首先来到funcA函数，执行一段时间后发现调用了另一个函数funcB，这时控制转移到该函数，执行完成后回到main函数的调用点继续执行。这是普通的函数调用。接下来是协程。

![img](https://pic3.zhimg.com/80/v2-af1d2bd803afd382c29a344df986f5b2_720w.webp)

在这里，我们依然首先在funcA函数中执行，运行一段时间后调用协程，协程开始执行，直到第一个挂起点，此后就像普通函数一样返回funcA函数，funcA函数执行一些代码后再次调用该协程，注意，协程这时就和普通函数不一样了，协程并不是从第一条指令开始执行而是**从上一次的挂起点开始执行**，执行一段时间后遇到第二个挂起点，这时协程再次像普通函数一样返回funcA函数，funcA函数执行一段时间后整个程序结束。

![img](https://pic3.zhimg.com/80/v2-5d4060d402805294bfa5c34385bf7cd6_720w.webp)



**函数只是协程的一种特例**

怎么样，神奇不神奇，**和普通函数不同的是，协程能知道自己上一次执行到了哪里**。现在你应该明白了吧，协程会在函数被暂停运行时保存函数的运行状态，并可以从保存的状态中恢复并继续运行。很熟悉的味道有没有，这不就是操作系统对**[线程](https://link.zhihu.com/?target=http%3A//mp.weixin.qq.com/s%3F__biz%3DMzU2NTYyOTQ4OQ%3D%3D%26mid%3D2247484768%26idx%3D1%26sn%3D049db350af9e5eea5cf3523ceb83f447%26chksm%3Dfcb9823ecbce0b28ca28d021e68c78138cde4a1b86ea7209c0c667d3d544d223d8b2aecbccec%26scene%3D21%23wechat_redirect)**的调度嘛，线程也可以被暂停，操作系统保存线程运行状态然后去调度其它线程，此后该线程再次被分配CPU时还可以继续运行，就像没有被暂停过一样。只不过线程的调度是操作系统实现的，这些对程序员都不可见，而协程是在用户态实现的，对程序员可见。这就是为什么有的人说可以把协程理解为用户态线程的原因。

也就是说现在程序员可以扮演操作系统的角色了，你可以自己控制协程在什么时候运行，什么时候暂停，也就是说协程的调度权在你自己手上。**在协程这件事儿上，调度你说了算**。当你在协程中写下yield的时候就是想要暂停该协程，当使用next()时就是要再次运行该协程。现在你应该理解为什么说函数只是协程的一种特例了吧，函数其实只是没有挂起点的协程而已。

**协程的历史**

有的同学可能认为协程是一种比较新的技术，然而其实协程这种概念早在1958年就已经提出来了，**要知道这时线程的概念都还没有提出来**。到了1972年，终于有编程语言实现了这个概念，这两门编程语言就是Simula 67 以及Scheme。



![img](https://pic3.zhimg.com/80/v2-69adba72bd637aa5c4592ad52adaf386_720w.webp)



但协程这个概念始终没有流行起来，甚至在1993年还有人考古一样专门写论文挖出协程这种古老的技术。因为这一时期还没有线程，如果你想在操作系统写出并发程序那么你将不得不使用类似协程这样的技术，后来线程开始出现，操作系统终于开始原生支持程序的并发执行，就这样，协程逐渐淡出了程序员的视线。直到近些年，随着互联网的发展，尤其是移动互联网时代的到来，服务端对高并发的要求越来越高，协程再一次重回技术主流，各大编程语言都已经支持或计划开始支持协程。那么协程到底是如何实现的呢？

**协程是如何实现的**

让我们从问题的本质出发来思考这个问题。协程的本质是什么呢？其实就是可以被暂停以及可以被恢复运行的函数。那么可以被暂停以及可以被恢复意味着什么呢？看过篮球比赛的同学想必都知道(没看过的也能知道)，篮球比赛也是可以被随时暂停的，暂停时大家需要记住球在哪一方，各自的站位是什么，等到比赛继续的时候大家回到各自的位置，裁判哨子一响比赛继续，就像比赛没有被暂停过一样。

![img](https://pic2.zhimg.com/80/v2-7790ac94fc3581fe7a01f579c953a5a9_720w.webp)

看到问题的关键了吗，比赛之所以可以被暂停也可以继续是因为比赛状态被记录下来了（站位、球在哪一方），这里的状态就是计算机科学中常说的上下文，context。回到协程。协程之所以可以被暂停也可以继续，那么一定要记录下被暂停时的状态，也就是上下文，当继续运行的时候要恢复其上下文(状态)，那么接下来很自然的一个问题就是，函数运行时的状态是什么？这个关键的问题的答案就在《**[函数运行起来后在内存中是什么样子的](https://link.zhihu.com/?target=http%3A//mp.weixin.qq.com/s%3F__biz%3DMzU2NTYyOTQ4OQ%3D%3D%26mid%3D2247484963%26idx%3D1%26sn%3D542d3bec57c6a9dfc17c83005fd2c030%26chksm%3Dfcb9817dcbce086b10cb44cad7c9777b0088fb8d9d6baf71ae36a9b03e1f8ef5bec62b79d6f7%26scene%3D21%23wechat_redirect)**》这篇文章中，函数运行时所有的状态信息都位于函数运行时栈中。函数运行时栈就是我们需要保存的状态，也就是所谓的上下文，如图所示：

![img](https://pic3.zhimg.com/80/v2-3018077c86c24fd3b79abe9e85c964ea_720w.webp)

从图中我们可以看出，该进程中只有一个线程，栈区中有四个栈帧，main函数调用A函数，A函数调用B函数，B函数调用C函数，当C函数在运行时整个进程的状态就如图所示。现在我们已经知道了函数的运行时状态就保存在栈区的栈帧中，接下来重点来了哦。既然函数的运行时状态保存在栈区的栈帧中，那么如果我们想暂停协程的运行就必须保存整个栈帧的数据，那么我们该将整个栈帧中的数据保存在哪里呢？想一想这个问题，整个进程的内存区中哪一块是专门用来长时间(进程生命周期)存储数据的？是不是大脑又一片空白了？

![img](https://pic1.zhimg.com/80/v2-8e644b4905f84d7869da06d7eab4cc60_720w.webp)

先别空白！很显然，这就是堆区啊，heap，我们可以将栈帧保存在堆区中，那么我们该怎么在堆区中保存数据呢？希望你还没有晕，在堆区中开辟空间就是我们常用的C语言中的malloc或者C++中的new。我们需要做的就是在堆区中申请一段空间，让后把协程的整个栈区保存下，当需要恢复协程的运行时再从堆区中copy出来恢复函数运行时状态。再仔细想一想，为什么我们要这么麻烦的来回copy数据呢？实际上，我们需要做的是直接把协程的运行需要的栈帧空间直接开辟在堆区中，这样都不用来回copy数据了，如图所示。

![img](https://pic3.zhimg.com/80/v2-0e66529d63362d8a7922b5479f669de6_720w.webp)

从图中我们可以看到，该程序中开启了两个协程，这两个协程的栈区都是在堆上分配的，这样我们就可以随时中断或者恢复协程的执行了。有的同学可能会问，那么进程地址空间最上层的栈区现在的作用是什么呢？这一区域依然是用来保存函数栈帧的，只不过这些函数并不是运行在协程而是普通线程中的。现在你应该看到了吧，在上图中实际上有3个执行流：

1. 一个普通线程
2. 两个协程

虽然有3个执行流但我们创建了几个线程呢？**一个线程**。现在你应该明白为什么要使用协程了吧，使用协程理论上我们可以**开启无数并发执行流，只要堆区空间足够**，同时还没有创建线程的开销，所有协程的调度、切换都发生在用户态，这就是为什么协程也被称作用户态线程的原因所在。掌声在哪里？

![动图封面](https://pic2.zhimg.com/v2-871188900160cf278461a4c9f010bbcd_b.jpg)



因此即使你创建了N多协程，但在操作系统看来依然只有一个线程，也就是说协程对操作系统来说是不可见的。这也许是为什么协程这个概念比线程提出的要早的原因，可能是写普通应用的程序员比写操作系统的程序员最先遇到需要多个并行流的需求，那时可能都还没有操作系统的概念，或者操作系统没有并行这种需求，所以非操作系统程序员只能自己动手实现执行流，也就是协程。现在你应该对协程有一个清晰的认知了吧。

![img](https://pic3.zhimg.com/80/v2-dccacb3e83e38ab4136591cf60ae70ce_720w.webp)

**总结**

到这里你应该已经理解协程到底是怎么一回事了，但是，依然有一个问题没有解决，为什么协程这种技术又一次重回视线，协程适用于什么场景下呢？该怎么使用呢？

原文地址：https://zhuanlan.zhihu.com/p/523579316

作者：linux