# 【NO.297】什么是DPDK？DPDK的原理及学习路线总结

## 1.什么是DPDK

　　对于用户来说，它可能是一个性能出色的包数据处 理加速软件库；对于开发者来说，它可能是一个实践包处理新想法的创 新工场；对于性能调优者来说，它可能又是一个绝佳的成果分享平台。　

　　DPDK用软件的方式在通用多核处理器上演绎着数据包处理的新篇 章，而对于数据包处理，多核处理器显然不是唯一的平台。支撑包处理 的主流硬件平台大致可分为三个方向。
　　·硬件加速器
　　·网络处理器
　　·多核处理器

　　在类似 IA（Intel Architecture）多核处理器为目标的平台上，网络数据包处理远早于DPDK而存在。从商业版的 Windows到开源的Linux操作系统，所有跨主机通信几乎都会涉及网络 协议栈以及底层网卡驱动对于数据包的处理。然而，低速网络与高速网 络处理对系统的要求完全不一样。

## 2.DPDK原理

网络设备（路由器、交换机、媒体网关、SBC、PS网关等）需要在瞬间进行大量的报文收发，因此在传统的网络设备上，往往能够看到专门的NP（Network Process）处理器，有的用FPGA，有的用ASIC。这些专用器件通过内置的硬件电路（或通过编程形成的硬件电路）高效转发报文，只有需要对报文进行深度处理的时候才需要CPU干涉。

但在公有云、NFV等应用场景下，基础设施以CPU为运算核心，往往不具备专用的NP处理器，操作系统也以通用Linux为主，网络数据包的收发处理路径如下图所示：

![img](https://pic4.zhimg.com/80/v2-39d9c5742815718ffc3e616342c75c9b_720w.webp)

在虚拟化环境中，路径则会更长：

![img](https://pic3.zhimg.com/80/v2-ee0175b746bbf5eed76de9f29bb4bbda_720w.webp)

由于包处理任务存在内核态与用户态的切换，以及多次的内存拷贝，系统消耗变大，以CPU为核心的系统存在很大的处理瓶颈。为了提升在通用服务器（COTS）的数据包处理效能，Intel推出了服务于IA（Intel Architecture）系统的DPDK技术。

DPDK是Data Plane Development Kit的缩写。简单说，DPDK应用程序运行在操作系统的User Space，利用自身提供的数据面库进行收发包处理，绕过了Linux内核态协议栈，以提升报文处理效率。

## 3.DPDK源码目录结构　

　　lib/ : DPDK的库源代码
　　drivers/ : DPDK轮询模式驱动程序源代码
　　app/ : DPDK应用程序源代码
　　examples/ : DPDK的一些应用程序例子源代码
　　config/ : DPDK关于arm和x86平台的一些编译配置
　　buildtools/ : DPDK一些编译配置的脚本
　　mk/ : DPDK的Makefile
　　usertools/ : DPDK提供给用户的一些实用工具

## 4.常用术语及缩写

　　ACL：Access Control List，访问控制列表，是路由器和交换机接口的指令列表，用来控制端口进出的数据包；简而言之就是用来控制数据流。
　　SSL：Secure Sockets Layer，安全套接层，是为网络通信提供安全及数据完整性的一种安全协议，在传输层对网络连接进行加密。
　　RSS：Receive Side Scaling，是一种能够在多处理器系统下使接收报文在多个CPU之间高效分发的网卡驱动技术。
　　NUMA：Non Uniform Memory Access Architecture，非统一内存访问架构；
　　QOS：Quality of Service，服务质量，指一个网络能够利用各种基础技术，为指定的网络通信提供更好的服务能力, 是网络的一种安全机制， 是用来解决网络延迟和阻塞等问题的一种技术。
　　NIC：Network Interface Card，网卡，网卡是局域网中最基本的部件之一，它是连接计算机与网络的硬件设备。
　　PCI：Peripheral Component Interconnect，计算机一种标准总线，NIC就是使用的这种总线方式。
　　PMD：Poll Mode Drive，轮询模式驱动，DPDK就是采用的这种模式。
　　RTE：Run Time Environment，通过PMD实现快速分组处理数据的一个框架。
　　MPLS：Multi-Protocol Label Switching，多协议标签交换，是一种用于快速数据包交换和路由的体系，它为网络数据流量提供了目标、路由地址、转发和交换等能力。更特殊的是，它具有管理各种不同形式通信流的机制。

## 5.DPDK框架简介

　　DPDK为IA上的高速包处理而设计。

　　图1-6所示的DPDK主要模块分 解展示了以基础软件库的形式，为上层应用的开发提供一个高性能的基 础I/O开发包。它大量利用了有助于包处理的软硬件特性，如大页、缓 存行对齐、线程绑定、预取、NUMA、IA最新指令的利用、Intel DDIO、内存交叉访问等。
　　核心库Core Libs，提供系统抽象、大页内存、缓存池、定时器及无 锁环等基础组件。
　　PMD库，提供全用户态的驱动，以便通过轮询和线程绑定得到极高 的网络吞吐，支持各种本地和虚拟的网卡。
　　Classify库，支持精确匹配（Exact Match）、最长匹配（LPM）和 通配符匹配（ACL），提供常用包处理的查表操作。
　　QoS库，提供网络服务质量相关组件，如限速（Meter）和调度 （Sched）。

![img](https://pic1.zhimg.com/80/v2-617431c4136778d6ccc9462016a76f10_720w.webp)

## 6.DPDK的轮询模式

　　DPDK采用了轮询或者轮询混杂中断的模式来进行收包和发包，此 前主流运行在操作系统内核态的网卡驱动程序基本都是基于异步中断处 理模式。

## 　　1、异步中断模式

　　当有包进入网卡收包队列后，网卡会产生硬件 （MSIX/MSI/INTX）中断，进而触发CPU中断，进入中断服务程序，在 中断服务程序（包含下半部）来完成收包的处理。当然为了改善包处理 性能，也可以在中断处理过程中加入轮询，来避免过多的中断响应次 数。总体而言，基于异步中断信号模式的收包，是不断地在做中断处 理，上下文切换，每次处理这种开销是固定的，累加带来的负荷显而易 见。在CPU比I/O速率高很多时，这个负荷可以被相对忽略，问题不 大，但如果连接的是高速网卡且I/O频繁，大量数据进出系统，开销累 加就被充分放大。中断是异步方式，因此CPU无需阻塞等待，有效利用 率较高，特别是在收包吞吐率比较低或者没有包进入收包队列的时候， CPU可以用于其他任务处理。
当有包需要发送出去的时候，基于异步中断信号的驱动程序会准备 好要发送的包，配置好发送队列的各个描述符。在包被真正发送完成 时，网卡同样会产生硬件中断信号，进而触发CPU中断，进入中断服务 程序，来完成发包后的处理，例如释放缓存等。与收包一样，发送过程 也会包含不断地做中断处理，上下文切换，每次中断都带来CPU开销； 同上，CPU有效利用率高，特别是在发包吞吐率比较低或者完全没有发 包的情况。

## 　　2、轮询模式

　　DPDK起初的纯轮询模式是指收发包完全不使用任何中断，集中所 有运算资源用于报文处理。但这不是意味着DPDK不可以支持任何中 断。根据应用场景需要，中断可以被支持，最典型的就是链路层状态发 生变化的中断触发与处理。

原文链接：https://zhuanlan.zhihu.com/p/397919872

作者：[Hu先生的Linux](https://www.zhihu.com/people/huhu520-10)