# 【NO.292】工作年限、成长路线、进阶技术。怎样才能成为架构师？

## 1.前言

你只面向工作学习吗？

如果说编程只是单纯的承接产品需求开发系统功能，那么基本可以把程序开发简单理解成按照需求PRD，定义属性、创建方法、调用展示，这三个步骤。

尤其是在一些大公司中，会有易用的、完善的、标准的架构体系和运维服务，例如：RPC、MQ、Redis集群、分布式任务、配置中心、分库分表组件、网关等搭配出来的系统架构。也因此让程序员做到只关心业务功能开发！

让程序员只关心业务开发，有成熟的系统架构、有标准的开发流程、有通用的功能设计，对于团队效能提升来说是非常好的事。但一部分程序员正因为有这样的好事，让日复一日的岁月做着同样的事，最后成为工具人。

*如果是框架和中间件的存在，是了让程序员只关心业务开发。那为什么你面试的时候会被问到核心组件的设计和原理呢？* 在这个年代，别放弃学习是你几乎唯一的生存途径。

## 2.你的成长阶段目标？

![img](https://pic4.zhimg.com/80/v2-fe2d27b18865ec50f02fd950b361243b_720w.webp)

就编程开发这条道路而言，每一个成长阶段的目标都会有它随着带来的难以攻克的难。

- 上学阶段，对突如其来的奇怪知识，想把它在自己电脑运行起来，就很难。
- 工作1~3年，以前掌握的都是毛皮，接下来需要有深度的学习，而深入后都将与数学硬碰硬。
- 工作3~5年，看以前理论性的知识也没那么难，但怎么实际要解决一些复杂项目，还是专心脑干。
- 工作5~7年，薪资与职位都会成为这个阶段非常难以突破的瓶颈，积累不足、沉淀不够，现状不满！
- 工作7~10年，以前觉得什么都难学，现在可能让你有空闲时间都难。并不一定年龄到了，本事就到了。

随着年龄的增长，每一阶段都有难以跨越的难。而那些看上去突破了瓶颈，达到了你想要的高度的人。其实每一个阶段，他们都跑在前面。

但就单纯的技术成长而言，其实理论知识并不难，只要你学就还能会，只是付出的时间成本不同罢了。但过了理论知识这一关后，接下来要面对的是创造能力，也就是为什么你感觉自己会了那么多技术内容，但是实际开发时却总感觉写不出好代码的阶段。

会了核心技术但又写不出好代码，就很像是：会汉字但写不出诗词歌赋、懂色彩但绘不出山河大川、能蹦跳但舞不出摇曳生姿。

所以，多实战一些项目代码，多看一些设计模式，会让你更好的理解代码该怎么用，也就能提升突破当前的阶段屏障。

## 3.怎么成长为架构师？

![img](https://pic4.zhimg.com/80/v2-85c6144f048101033160c79de8010fb3_720w.webp)

讲到架构师，架构师的成长更多的取决你们的研发组是否需要一个架构师，也同时需要你在这个岗位起到应有的作用。

**那么上图对于架构师的能力概况，有哪些具体的事项呢？**

1. 定得了规范、设计了架构。
2. 有一定的技术深入和广度，改的了bug、处理得了事故。
3. 带了了小组推进项目落地，也能协同其他组配合。
4. 了解运营和业务规划，提前介入产品开发阶段。
5. 懂得了业务和运营，了解数据指标和各项ROI。
6. 架构更多的是经验和经历的结合，而不是一个单项内容的单一渠道。
7. 不是没有架构师就没有架构，有时候是一个公司或者小组承接的项目并没有那么大，使用成型架构模式即可。
8. 但如果有非常复杂的场景设计，都是十几个系统的分组安排开发，提供服务，支持几万秒杀，几十万日活，在扩展到上百万DAU，就需要有架构师来把控。
9. 再比如：从下单、到交易、到支付、到结算、到活动、到玩法、怎么支持。这个体量的复杂度才需要有架构权衡。
10. 没有绝对的对和绝对的错，只是什么时候更适合罢了。多学一些，别给自己设定边界，才更好突围！

**做好架构，远看是部门效率，近看是解决烂代码！**很多时候的急，可能让整个工程烂掉。烂的越来越多，最终也会影响业务发展。那么这些烂代码都怎么来的呢？

1. bug很多时候是接手了的烂代码或者别人的思路没有继续继承。
2. 业务需求简单开始就写的没有扩展性，后面也不断的堆积。
3. 没有很好的结构和命名、也从不格式化。
4. 预期不到将来业务走向，设计不出合理的扩展性系统。
5. 炫技大于整体规划和设计，一个新技能的引入，但缺少相应的匹配。
6. 没有设计，功能都是流程式，需要啥就写ifelse。
7. 总想一把梭，没关系的，心里有抱怨，部门有急功近利，不给你长时间的铺垫，没有有人带，写不出好东西。
8. 组内缺少相应的流程规范和评审，设计评审、代码评审，也没与标杆项目可以参考。
9. 懂几个jdk源码从不是写好代码的根本只是基本功。就像老木匠用斧子，新木匠用电锯，但做出来的东西，有的就好，有的就不好。
10. 没有永远好的代码，如果像代码更好，就需要一直维护，一直改造。
11. 没有业务对应的体量，不谈QPS、TPS、TP99、TP999，服务健康度，很多空谈都是耍流氓。

**烂**，来自于很多方面，业务、产品、研发，三方共同努力才能更好的减少烂的出现，而这些也是每一个研发都应该努力的方向，也几乎是你要成为架构师的必经之路。

## 4.总结

写了这么多主要是想帮助那些和我一样在这条路上持续拼搏的同好，可能大家都会在这些阶段迷茫过：上学时技术怎么学、求职时简历怎么写、工作时个人怎么成长等等。所以很多时候更多的仍然是自己的克制和自己的选择！

原文链接：https://zhuanlan.zhihu.com/p/382942954

作者：[Hu先生的Linux](https://www.zhihu.com/people/huhu520-10)