# 【NO.258】多业务建模在美团搜索排序中的实践

## 1.引言

美团的使命是“帮大家吃得更好，生活更好”，美团 App 承载的业务包括外卖、到店餐饮、买菜、优选、酒店、旅游、休闲娱乐等各类生活服务。美团首页的搜索是美团 App 上各类生活服务最大的流量分发入口，每天为数千万的用户提供各种服务。美团搜索排序是一个典型的多业务混合排序建模问题，一个典型的多业务搜索场景是当用户搜索地点，如 “望京” 的时候，用户的需求不是很明确，此时搜索的结果页如下图 1 所示，下方的商家列表中会包含望京附近餐饮、电影、休闲娱乐、酒店等多种业务的结果，这就是一个多业务混合排序场景。

![图1 美团搜索结果页面](https://p0.meituan.net/travelcube/0396bf7d5456b9acb2b73afb9dc935da193147.jpg)

图1 美团搜索结果页面



而多业务场景存在如下几点挑战：

1. 因业务之间存在共性和特性，如何让模型兼顾这两种特性，实现更好的数据学习。比如到店餐饮对距离特征非常敏感，而旅游景点业务对距离特征相对不敏感。
2. 业务天然存在高频和低频特性（比如外卖和旅游），导致模型的训练数据中多业务样本数量不平衡。
3. 各个业务往往有自己不同的主目标，如何满足不同业务的目标，最终能够提升搜索的用户体验。

本文分享了美团搜索中的多业务排序建模优化工作，我们主要聚焦在到店商家多业务场景，后续的内容会分为以下四个部分：第一部分是对美团搜索排序分层架构进行简单介绍；第二部分会介绍多路融合层上的多业务融合建模；第三部分会介绍精排模型的多业务排序建模；最后一部分是总结和展望。希望能对从事相关工作的同学有所启发或者帮助。

## 2.排序流程简介

美团搜索系统流程如下图 2 所示，整体流程分为数据层、召回层、排序层和展示层。其中排序层分为以下几个子部分：

1. **粗排层**：使用相对简单的模型对召回候选集进行初步过滤，实现排序效果和性能的 Trade-off。
2. **多路融合层**：使用查询词特征、上下文场景特征构建配额模型，进行不同业务候选集的数量控制，实现用户需求的精确理解。
3. **精排层**：使用亿级别特征的深度学习模型，捕捉各种显式和隐式信号，实现 Item 排序分数的精准预估。
4. **重排层**：使用小模型和各种机制对精排后的结果进行调序，实现精细定向的优化。
5. **异构排序层**：使用深度学习模型对异构聚块进行排序，实现多业务的高承载。

多层排序架构设计主要是为了平衡排序效果和性能。本文后续提到的多业务建模优化工作主要从多路融合层和精排层进行介绍。

![图2 系统架构图](https://p0.meituan.net/travelcube/af2c07ea8cdb97f226d70528c99beabd284642.png)

图2 系统架构图



## 3.多业务建模实践

### 3.1 多业务配额模型（多路融合层）

随着美团业务的发展，美团搜索接入了到餐、到综、酒店、旅游等业务。对于业务意图模糊的搜索词，比如用户搜索“五道口”，需要根据用户、查询词、场景等多种因素来综合判断用户的业务意图。为了融合不同业务的召回结果，给 L2 精排一个比例合适的候选集，我们设计了一个多业务配额模型来平衡多业务召回的比例。这种基于配额对多路召回结果进行合并的做法在搜索、推荐场景中十分常用，比如淘宝首页搜索、美团推荐等。

为了多路召回的灵活接入，适配美团搜索业务的发展，我们不断迭代搜索配额模型。下面将详细介绍美团多业务配额模型的迭代过程，文章后续部分会将多业务配额模型（Multi-Business Quota Model）简称为MQM。

![图3 多路融合过程](https://p0.meituan.net/travelcube/1057cd04b138e77cfe9db5f4cd9f51b3171288.png)

图3 多路融合过程



#### 3.1.1 一维目标多业务配额

考虑到大搜结果存在多路不同业务的召回，为了刻画用户搜索 Query 对三路业务召回的意图强弱，我们采用多目标的建模方式，以每一路召回是否被点击、下单为目标进行建模，实现了多业务配额初版模型 MQM-V1。该模型输出各路召回的点击、下单联合概率，作为最终的配额分布。在特征层面，我们使用 Query 维度特征、Context 维度特征、Cross 维度特征、User 维度特征，来刻画用户在不同场景的实时个性化需求。MQM-V1 模型结构如下图 4 所示。

![图4 MQM-V1 模型结构图](https://p0.meituan.net/travelcube/c43b5fe81904440c10b3493d0575a608209034.png)

图4 MQM-V1 模型结构图



MQM-V1 版本上线后，整体线上点击率 +0.53%，各业务访购率基本持平。

#### 3.1.2 二维目标多业务配额

随着大搜召回策略的不断迭代，大搜不仅引入了按业务拆分的召回方式，而且引入了向量检索、地理位置近邻检索等跨多业务的异构召回方式，导致大搜召回策略不断增加，多业务配额模型也面临新召回源带来的冷启动问题。同时，为了加强多业务配额模型的个性化，我们参考借鉴了[6]中用户行为序列建模的方法。综上，该版本 MQM-V2 与 MQM-V1 区别如下：

- 建模目标上，从以召回方式点击的一维目标升级到召回方式叉乘业务的二维目标，使得多路融合的粒度也更细、精度更高。
- 行为序列建模模块引入Transformer Layer。
- 为了解决新召回源接入的冷启动问题，我们引入了人工经验层，包括业务先验和历史统计，综合模型输出决定每一路召回的配额。

![图5 MQM-V2 模型结构图](https://p0.meituan.net/travelcube/ca914b175af3b123dfbf9edf64f20d96290839.png)

图5 MQM-V2 模型结构图



MQM-V2 版本上线后，各业务指标率均有提升，其中旅游访购率 +2%，到餐访购率 +0.57%，到综、酒店访购率持平。

### 3.2 多业务排序模型（精排层）

从美团搜索精排模型升级为 DNN 模型，一直到 2019 年底，美团搜索的精排模型结构是业界主流的 Embedding&MLP 的范式结构，期间我们也尝试过业界提出的模型结构比如PNN[1]、DeepFM[2]、DCN[3]、AutoInt[4]、FiBiNet[5]等等。

随着迭代的进行，我们发现针对特定业务的优化难以在精排模型发挥作用，为了兼顾各个业务的特性，支持各个业务更加有效的针对性迭代优化，需要探索出一种模型结构来适配美团搜索这样的多业务场景。下面会具体介绍精排模型在多业务建模上的发展史，文章后续部分将多业务精排模型（Multi-Business Network）简称为 MBN。

#### 3.2.1 独立子网络拆分

考虑到酒店和旅游在美团大搜排序策略的流量里面占比较少，而针对小流量的相关优化在目前统一的 Embedding&MLP 模型结构里面很难体现，我们尝试了如图 6 所示的人工自定义多塔模型 MBN-V1 结构：主网络复用目前的模型结构。具体情况介绍参考[6]中的行为序列建模部分，增加酒店和旅游独立子网络；酒店子网络的输入包括酒店独有特征和主网络的打分输出，旅游子网络的输入包括旅游独有特征、主网络的打分输出、主网络最后一层 FC，酒店和旅游子塔输入不同是因为业务逻辑不同导致数据分布差异大，这是实践出的结果，最终的输出是对三个输出的加权求和。

![图6 MBN-V1 模型结构图](https://p0.meituan.net/travelcube/d70c6c71e56f50eaa05783fe3865b2e5255298.png)

图6 MBN-V1 模型结构图



针对加权求和的权重部分，我们采取了两种方式对权重进行设定：

- 第一种，采用硬切分的方式，就是说权重向量是一个 One-hot 稀疏向量：对酒店商家进行预测，只选取酒店子网络的输出，其余类推。
- 第二种，采用软切分的方式，把多业务配额模型的输出作为权重值。

线上实验发现第二种方法比第一种好，我们认为采用硬切分会导致子塔分支的参数只能被对应业务的数据更新，而各业务的数据占比不均导致学习不佳，而软切分会达到一种知识迁移的作用。最终线上的效果相比统一的 Embedding& MLP 模型，整体旅游取得了正向效果：其中整体点击率 +0.17%，其余业务访购率效果基本持平。

#### 3.2.2 子网络权重自学习

基于第一版多业务精排模型取得了初步正向效果，我们继续添加美食业务子塔，同时考虑到 MBN-V1 依赖配额模型的输出，这样会导致配额模型的变更可能会对精排模型的效果产生影响，针对这些因素我们上线了第二版多业务模型 MBN-V2，模型结构如图7所示。相比 MBN-V1 的区别如下：

- 添加美食业务的独立子网络。
- 解耦精排模型和配额模型，在精排模型中集成权重生成子网络，该子网络的输入主要是一些 Query 维度，Context 维度的特征。

![图7 MBN-V2 模型结构图](https://p0.meituan.net/travelcube/33c293b5552faf8c2d903e0b4b0fc770329080.png)

图7 MBN-V2 模型结构图



线上实验效果：MBN-V2 相比 MBN-V1，整体点击率 +0.1%，业务访购率效果基本持平。

#### 3.2.3 子网络特征自适应

在第二版模型的基础上，我们进一步添加到综业务子塔，随着子网络的变多，目前对于子网络的输入采用人工设计，这种方式需要花费大量的时间进行离线实验。考虑到目前的多业务子塔结构十分类似业界的多任务学习，我们也尝试引入业界的多任务学习结构；同时，我们针对 MBN-V2 中的权重子网络输出进行分析发现其输出的权重对不同业务商户的输出差不多，那么会带来业务的针对性优化不明显。基于上述部分，我们迭代了第三版多业务精排 MBN-V3，结构如下图 8 所示，改进点如下：

![图8 MBN-V3 模型结构图](https://p0.meituan.net/travelcube/64fd623c9871c90aaa006532fcf89717471041.png)

图8 MBN-V3 模型结构图



- 补充到综子网络，采用 MMoE[7]多任务学习结构，来自动学习特征表征输出给上层子网络，从而取代人工设计子网络的输入。
- 精排模型的损失函数除了采用用户线上反馈计算的主 LambdaLoss 外，额外添加了业务的分类交叉熵 Loss，达到预测某业务 Item 得分时，对应的业务子塔权重最大的目的。

线上实验效果：MBN-V3 相比 MBN-V2，整体点击率效果持平、美食业务访购率 +0.36%，到综业务访购率 +1.07%，酒店业务访购率 +0.27%，旅游业务访购率 +0.35%。

#### 3.2.4 多业务特征表达优化

虽然 MMoE 多任务学习结构在业界很多场景得到了应用，在我们的多业务建模场景也取得了有效验证，但是我们持续跟进业界前沿，并且结合业务场景进行落地。

我们尝试了腾讯提出的 PLE[8]结构，迭代出多业务精排 MBN-V4。 PLE 可以看成是 MMoE 的改进版，它对于每一个任务有自己特定的专家层，不同任务之间有共享的专家层，相比 MMoE 是所有专家输出的加权求和，PLE 子任务的输入是子任务独有的专家和共享专家输出的加权求和，更容易学出业务的特性；同时基于性能考虑，我们选取了单层 PLE 也即 CGC 结构，结构如下图9所示：

![图9 MBN-V4 模型结构图](https://p1.meituan.net/travelcube/22f453e8b1da32cf455d9a890a746efc479185.png)

图9 MBN-V4 模型结构图



线上实验效果：MBN-V4 相比 MBN-V3，整体点击率 +0.1%，美食业务访购率 +0.53%，其余业务访购率波动持平；我们对 MMoE 和 CGC 的专家权重进行可视化如下图 10所示，分析发现：CGC 结构的专家层权重相比 MMoE 在同一业务多条样本之间的专家权重方差更小，更加稳定，说明 CGC 相比 MMoE 在特征表示上更加有优势。

![图10 MMoE、CGC 专家权重分析](https://p0.meituan.net/travelcube/4936e5e577d753ac5c20b65c4c3f490659369.png)

图10 MMoE、CGC 专家权重分析



## 4.总结和展望

2019 年底开始，为了解决实际的多业务召回排序问题，美团搜索进行了大量探索，从工程到算法到产品形态各个层面丰富对多业务的支持。其中排序算法层面主要在多路召回融合层和精排层进行优化。

多路融合层主要完成搜索结果从结果相关到结果优质的筛选过程，需要解决不同召回方式（文本召回、推荐召回、向量召回）和不同业务召回结果的融合截断问题，直接决定了用户能浏览到的结果候选集。这其中最重要的问题就是判断用户对各个业务的需求强弱以及各业务的召回质量，对每个业务结果和召回结果确定合适的精排准入标准。

多业务配额模型通过整合用户实时需求、Query 的历史统计信息、搜索上下文信息和每个召回源质量情况，给出了每路召回、每个业务的应进入精排的比例。该模型保证了不同场景下精排候选集的结果多样性和优质性，实现了新业务、新召回方法接入的少侵入性，降低业务、召回接入成本。同时也为精排层分业务的网络结构提供了融合各个业务子网络结果的先验权重。

精排层在多路融合层的基础上进一步对多业务搜索结果进行精细化排序建模打分。用户的需求和美团业务一样是多样的，为了能充分建模各种场景下的需求，精排多业务排序模型从底层数据（丰富分业务的特征）、模型结构到业务目标融合都进行了多轮迭代。其中模型结构和相应的目标融合直接对各种大小业务、场景和相应的业务目标进行了分片建模，有效地缓解了小业务小场景在统一建模中被大业务样本淹没的问题。同时该模型支持新老业务的快速迭代，各业务可以方便独立地迭代特征、模型结构和相应的目标。

上述优化覆盖了线上全流量，在搜索用户体验和各业务价值均有明显提升，但还有很多工作可以持续优化。

- **业务独有特征利用**：目前我们采用对某些业务添加业务独有特征，其余业务对于这些缺失的独有特征给默认值，但是这样会带来很多冗余的计算量，这部分不管从效果还是性能方面都存在优化空间。
- **样本不平衡学习**：不同业务的数据量在美团搜索上差异大，如何让模型更好的学习出小业务的分布，我们正在探索迁移学习和 Meta-Learning 等方法。
- **多目标优化**：美团搜索既要兼顾用户的搜索体验，也要服务美团各个业务的战略目标，所以各个业务的主优化指标不一定一致，多目标优化也是一个持续探索的方向。

本文叙述的工作集中在美团多业务商家搜索排序上，同时随着优选、买菜、团好货、闪购等商品类业务的发展，我们也正在进行商品类多业务混排以及商家商品异构多业务混排工作。

## 5.参考资料

- [1] [Product-based neural networks for user response prediction](https://arxiv.org/pdf/1611.00144.pdf)
- [2] [DeepFM: A Factorization-Machine based Neural Network for CTR Prediction](http://www.ijcai.org/proceedings/2017/0239.pdf)
- [3] [Deep & Cross Network for Ad Click Predictions](https://arxiv.org/abs/1708.05123)
- [4] [AutoInt: Automatic Feature Interaction Learning via Self-Attentive Neural Networks](https://arxiv.org/abs/1810.11921)
- [5] [FiBiNET: Combining Feature Importance and Bilinear feature Interaction for Click-Through Rate Prediction](https://arxiv.org/pdf/1905.09433.pdf)
- [6] [Transformer 在美团搜索排序中的实践](https://tech.meituan.com/2020/04/16/transformer-in-meituan.html)
- [7] [Modeling Task Relationships in Multi-task Learning with Multi-gate Mixture-of-Experts](https://dl.acm.org/doi/10.1145/3219819.3220007)
- [8] [Progressive Layered Extraction (PLE): A Novel Multi-Task Learning (MTL) Model for Personalized Recommendations](https://dl.acm.org/doi/abs/10.1145/3383313.3412236)

## 6.作者简介

培浩、肖垚、晓江、家琪、陈胜、云森、永超、利前等，均来自美团平台搜索与 NLP 部。

原文作者：美团技术团队

原文链接：https://tech.meituan.com/2021/07/08/multi-business-modeling.html