# 【NO.253】美团商品知识图谱的构建及应用

## 1.背景

### 1.1 美团大脑

近年来，人工智能正在快速地改变人们的生活，背后其实有两大技术驱动力：**深度学习**和**知识图谱**。我们将深度学习归纳为隐性的模型，它通常是面向某一个具体任务，比如说下围棋、识别猫、人脸识别、语音识别等等。通常而言，在很多任务上它能够取得很优秀的结果，同时它也有一些局限性，比如说它需要海量的训练数据，以及强大的计算能力，难以进行跨任务的迁移，并且不具有较好的可解释性。在另一方面，知识图谱作为显式模型，同样也是人工智能的一大技术驱动力，它能够广泛地适用于不同的任务。相比深度学习，知识图谱中的知识可以沉淀，具有较强的可解释性，与人类的思考更加贴近，为隐式的深度模型补充了人类的知识积累，和深度学习互为补充。因此，全球很多大型的互联网公司都在知识图谱领域积极进行布局。

![图1 人工智能两大驱动力](https://p0.meituan.net/travelcube/9e103e034af6351bde26ae1b4cce3167531676.png)

图1 人工智能两大驱动力



美团连接了数亿用户和数千万商户，背后也蕴含着丰富的日常生活相关知识。2018年，美团知识图谱团队开始构建美团大脑，着力于利用知识图谱技术赋能业务，进一步改善用户体验。具体来说，美团大脑会对美团业务中涉及到的千万级别商家、亿级别的菜品/商品、数十亿的用户评论，以及背后百万级别的场景进行深入的理解和结构化的知识建模，构建人、店、商品、场景之间的知识关联，从而形成生活服务领域大规模的知识图谱。现阶段，美团大脑已覆盖了数十亿实体，数百亿三元组，在餐饮、外卖、酒店、金融等场景中验证了知识图谱的有效性。

![图2 美团大脑](https://p1.meituan.net/travelcube/cf613a933f133ff00bd75b37f5d30c681071820.png)

图2 美团大脑



### 1.2 在新零售领域的探索

美团逐步突破原有边界，在生活服务领域探索新的业务，不仅局限于通过外卖、餐饮帮大家“吃得更好”，近年来也逐步拓展到零售、出行等其他领域，帮大家“生活更好”。在零售领域中，美团先后落地了美团闪购、美团买菜、美团优选、团好货等一系列相应的业务，逐步实现“万物到家”的愿景。为了更好地支持美团的新零售业务，我们需要对背后的零售商品建立知识图谱，积累结构化数据，深入对零售领域内商品、用户、属性、场景等的理解，以便能更好地为用户提供零售商品领域内的服务。

相比于围绕商户的餐饮、外卖、酒店的等领域，零售商品领域对于知识图谱的建设和应用提出了更大的挑战。一方面，商品数量更加庞大，覆盖的领域范围也更加宽广。另一方面，商品本身所具有的显示信息往往比较稀疏，很大程度上需要结合生活中的常识知识来进行推理，方可将隐藏在背后的数十维的属性进行补齐，完成对商品完整的理解。在下图的例子中，“乐事黄瓜味”这样简单的商品描述其实就对应着丰富的隐含信息，只有对这些知识进行了结构化提取和相应的知识推理后，才能够更好的支持下游搜索、推荐等模块的优化。

![图3 商品结构化信息的应用](https://p0.meituan.net/travelcube/67f21c3f78a95e6469007b42ddc22ca6982740.png)

图3 商品结构化信息的应用



### 1.3 商品图谱建设的目标

我们针对美团零售业务的特点，制定了多层级、多维度、跨业务的零售商品知识图谱体系。

![图4 商品知识图谱体系](https://p0.meituan.net/travelcube/0b9af8cae3f71d8296a6aa3eb191a8e3407927.png)

图4 商品知识图谱体系



**多层级**

在不同业务的不同应用场景下，对于“商品”的定义会有所差别，需要对各个不同颗粒度的商品进行理解。因此，在我们的零售商品知识图谱中，建立了五层的层级体系，具体包括： - **L1-商品SKU/SPU**：对应业务中所售卖的商品颗粒度，是用户交易的对象，往往为商户下挂的商品，例如“望京家乐福所售卖的蒙牛低脂高钙牛奶250ml盒装”。这一层级也是作为商品图谱的最底层的基石，将业务商品库和图谱知识进行打通关联。 - **L2-标准商品**：描述商品本身客观事实的颗粒度，例如“蒙牛低脂高钙牛奶250ml盒装”，无论通过什么渠道在什么商户购买，商品本身并没有任何区别。商品条形码则是在标准商品这层的客观依据。在这一层级上，我们可以建模围绕标准商品的客观知识，例如同一个标准商品都会具有同样的品牌、口味、包装等属性。 - **L3-抽象商品**：进一步我们将标准商品向上抽象的商品系列，例如“蒙牛低脂高钙牛奶”。在这一层级中，我们不再关注商品具体的包装、规格等，将同系列的商品聚合为抽象商品，承载了用户对于商品的主观认知，包括用户对商品系列的别名俗称、品牌认知、主观评价等。 - **L4-主体品类**：描述商品主体的本质品类，列如“鸡蛋”、“奶油草莓”、“台式烤肠”等。这一层作为商品图谱的后台类目体系，以客观的方式对商品领域的品类进行建模，承载了用户对于商品的需求，例如各品牌各产地的鸡蛋都能够满足用户对于鸡蛋这个品类的需求。 - **L5-业务类目**：相比于主体品类的后台类目体系，业务类目作为前台类目体系会依据业务当前的发展阶段进行人工定义和调整，各个业务会根据当前业务阶段的特点和需求建立对应的前台类目体系。

**多维度**

- **商品属性视角**：围绕商品本身，我们需要有海量的属性维度来对商品进行描述。商品属性维度主要分为两类：一类是通用的属性维度，包括品牌、规格、包装、产地等；另一类是品类特有的属性维度，例如对于牛奶品类我们会关注脂肪含量（全脂/低脂/脱脂牛奶）、存储方式（常温奶、冷藏奶）等。商品属性主要是刻画了商品的客观知识，往往会建立在标准商品这一层级上。
- **用户认知视角**：除了客观的商品属性维度以外，用户往往对于商品会有一系列的主观认知，例如商品的别名俗称（“小黑瓶”、“快乐水”）、对于商品的评价（“香甜可口”、“入口即化”、“性价比高”）、商品的清单/榜单（“进口食品榜单”、“夏季消暑常备”）等维度。这些主观认知往往会建立在抽象商品这一层级上。
- **品类/类目视角**：从品类/类目的视角来看，不同品类/类目也会有各自不同的关注点。在这一层级上，我们会建模各个品类/类目下有哪些典型的品牌、用户关注哪些典型属性、不同品类的复购周期是多长时间等。

**跨业务**

美团大脑商品知识图谱的目标是希望能够对客观世界中的商品知识进行建模，而非局限于单个业务之中。在商品图谱的五层体系中，标准商品、抽象商品、品类体系都是与业务解耦的，围绕着客观商品所建立的，包括围绕这些层级建立的各维度数据也均是刻画了商品领域的客观知识。

在应用于各个业务当中时，我们将客观的图谱知识向上关联至业务前台类目，向下关联至业务商品SPU/SKU，则可以完成各个业务数据的接入，实现各个业务数据和客观知识之间的联通，提供更加全面的跨业务的全景数据视角。利用这样的数据，在用户方面我们可以更加全面的建模、分析用户对于业务、品类的偏好，对于价格、品质等的敏感程度，在商品方面我们可以更准确的建模各品类的复购周期、地域/季节/节日偏好等。

### 1.4 商品图谱建设的挑战

商品知识图谱的构建的挑战主要来源于以下三个方面：

1. **信息来源质量低**：商品本身所具有的信息比较匮乏，往往以标题和图片为主。尤其在美团闪购这样LBS的电商场景下，商户需要上传大量的商品数据，对于商品信息的录入存在很多信息不完整的情况。在标题和图片之外，商品详情虽然也蕴含着大量的知识信息，但是其质量往往参差不齐，并且结构各异，从中进行知识挖掘难度极高。
2. **数据维度多**：在商品领域有众多的数据维度需要进行建设。以商品属性部分为例，我们不仅需要建设通用属性，诸如品牌、规格、包装、口味等维度，同时还要覆盖各个品类/类目下特定关注的属性维度，诸如脂肪含量、是否含糖、电池容量等，整体会涉及到上百维的属性维度。因此，数据建设的效率问题也是一大挑战。
3. **依赖常识/专业知识**：人们在日常生活中因为有很丰富的常识知识积累，可以通过很简短的描述获取其背后隐藏的商品信息，例如在看到“乐事黄瓜”这样一个商品的时候知道其实是乐事黄瓜味的薯片、看到“唐僧肉”的时候知道其实这不是一种肉类而是一种零食。因此，我们也需要探索结合常识知识的语义理解方法。同时，在医药、个护等领域中，图谱的建设需要依赖较强的专业知识，例如疾病和药品之间的关系，并且此类关系对于准确度的要求极高，需要做到所有知识都准确无误，因此也需要较好的专家和算法相结合的方式来进行高效的图谱构建。

## 2.商品图谱建设

在了解了图谱建设的目标和挑战后，接下来我们将介绍商品图谱数据建设的具体方案。

### 2.1 层级体系建设

**品类体系建设**

本质品类描述了商品本质所属的最细类别，它聚合了一类商品，承载了用户最终的消费需求，如“高钙牛奶”、“牛肉干”等。本质品类与类目也是有一定的区别，类目是若干品类的集合，它是抽象后的品类概念，不能够明确到具体的某类商品品类上，如“乳制品”、“水果”等。

**品类打标**：对商品图谱的构建来说，关键的一步便是建立起商品和品类之间的关联，即对商品打上品类标签。通过商品和品类之间的关联，我们可以建立起商品库中的商品与用户需求之间的关联，进而将具体的商品展示到用户面前。下面简单介绍下品类打标方法：

1. **品类词表构建**：品类打标首先需要构建一个初步的商品品类词表。首先，我们通过对美团的各个电商业务的商品库、搜索日志、商户标签等数据源进行分词、NER、新词发现等操作，获得初步的商品候选词。然后，通过标注少量的样本进行二分类模型的训练（判断一个词是否是品类）。此外，我们通过结合主动学习的方法，从预测的结果中挑选出难以区分的样本，进行再次标注，继续迭代模型，直到模型收敛。
2. **品类打标**：首先，我们通过对商品标题进行命名实体识别，并结合上一步中的品类词表来获取商品中的候选品类，如识别“蒙牛脱脂牛奶 500ml”中的“脱脂牛奶”、“牛奶”等。然后，在获得了商品以及对应的品类之后，我们利用监督数据训练品类打标的二分类模型，输入商品的SPU_ID和候选品类TAG构成的Pair，即，对它进行是否匹配的预测。具体的，我们一方面利用结合业务中丰富的半结构化语料构建围绕标签词的统计特征，另一方面利用命名实体识别、基于BERT的语义匹配等模型产出高阶相关性特征，在此基础上，我们将上述特征输入到终判模型中进行模型训练。
3. **品类标签后处理**：在这一步中，我们对模型打上的品类进行后处理的一些策略，如基于图片相关性、结合商品标题命名实体识别结果等的品类清洗策略。

通过上述的三个步骤，我们便可以建立起商品与品类之间的联系。

**品类体系**：品类体系由品类和品类间关系构成。常见的品类关系包括同义词和上下位等。在构建品类体系的过程中，常用的以下几种方法来进行关系的补全。我们主要使用下面的一些方法： 1. **基于规则的品类关系挖掘**。在百科等通用语料数据中，有些品类具有固定模式的描述，如“玉米又名苞谷、苞米棒子、玉蜀黍、珍珠米等”、“榴莲是著名热带水果之一”，因此，可以使用规则从中提取同义词和上下位。 2. **基于分类的品类关系挖掘**。类似于上文中提到的品类打标方法，我们将同义词和上下位构建为的样本，通过在商品库、搜索日志、百科数据、UGC中挖掘的统计特征以及基于Sentence-BERT得到的语义特征，使用二分类模型进行品类关系是否成立的判断。对于训练得到的分类模型，我们同样通过主动学习的方式，选出结果中的难分样本，进行二次标注，进而不断迭代数据，提高模型性能。 3. **基于图的品类关系推理**。在获得了初步的同义词、上下位关系之后，我们使用已有的这些关系构建网络，使用GAE、VGAE等方法对网络进行链路预测，从而进行图谱边关系的补全。

![图5 商品图谱品类体系的构建](https://p1.meituan.net/travelcube/0cd71be91cad215eddd22456f8902de8249465.png)

图5 商品图谱品类体系的构建



**标准/抽象商品**

标准商品是描述商品本身客观事实的颗粒度，和销售渠道和商户无关，而商品条形码是标准商品这层的客观依据。标品关联即将同属于某个商品条形码的业务SKU/SPU，都正确关联到该商品条形码上，从而在标准商品层级上建模相应的客观知识，例如标准商品对应的品牌、口味和包装等属性。 下面通过一个案例来说明标品关联的具体任务和方案。

**案例**：下图是一个公牛三米插线板的标准商品。商家录入信息的时候，会把商品直接关联到商品条码上。通过商户录入数据完成了一部分的标品关联，但这部分比例比较少，且存在大量的链接缺失，链接错误的问题。另外，不同的商家对于同样的标品，商品的标题的描述是千奇百怪的。我们的目标是补充缺失的链接，将商品关联到正确的标品上。

![图6 商品图谱标品关联任务](https://p0.meituan.net/travelcube/88048546ffa3d65c40dcd69ad7da3b7d624180.png)

图6 商品图谱标品关联任务



针对标品关联任务，我们构建了商品领域的同义词判别模型：通过远监督的方式利用商户已经提供的少量有关联的数据，作为已有的知识图谱构造远监督的训练样本。在模型中，正例是置信度比较高的标品码；负例是原始数据中商品名或者图像类似但不属于同一标品的SPU。构造准确率比较高的训练样本之后，通过BERT模型进行同义词模型训练。最后，通过模型自主去噪的方式，使得最终的准确率能够达到99%以上。总体能做到品牌，规格，包装等维度敏感。

![图7 商品图谱标品关联方法](https://p0.meituan.net/travelcube/b6b701f9982109208c3d2d90127d7ccb648102.png)

图7 商品图谱标品关联方法



抽象商品是用户认知的层面，作为用户所评论的对象，这一层对用户偏好建模更加有效。同时，在决策信息的展示上，抽象商品粒度也更符合用户认知。例如下图所示冰淇淋的排行榜中，罗列了用户认知中抽象商品对应的SKU，然后对应展示不同抽象商品的特点、推荐理由等。抽象商品层整体的构建方式，和标准商品层比较类似，采用标品关联的模型流程，并在数据构造部分进行规则上的调整。

![图8 商品图谱抽象商品聚合](https://p0.meituan.net/travelcube/9f00a0826aec9c2898c349f88f4ba482694147.png)

图8 商品图谱抽象商品聚合



### 2.2 属性维度建设

对一个商品的全面理解，需要涵盖各个属性维度。例如“乐事黄瓜味薯片”，需要挖掘它对应的品牌、品类、口味、包装规格、标签、产地以及用户评论特色等属性，才能在商品搜索、推荐等场景中精准触达用户。商品属性挖掘的源数据主要包含商品标题、商品图片和半结构化数据三个维度。

![图9 商品图谱属性建设](https://p1.meituan.net/travelcube/0c2aad7c8b02b70512b4ec51734589dd705593.png)

图9 商品图谱属性建设



商品标题包含了对于商品最重要的信息维度，同时，商品标题解析模型可以应用在查询理解中，对用户快速深入理解拆分，为下游的召回排序也能提供高阶特征。因此，这里我们着重介绍一下利用商品标题进行属性抽取的方法。

商品标题解析整体可以建模成文本序列标注的任务。例如，对于商品标题“乐事黄瓜薯片”，目标是理解标题文本序列中各个成分，如乐事对应品牌，黄瓜对应口味，薯片是品类，因此我们使用命名实体识别（NER）模型进行商品标题解析。然而商品标题解析存在着三大挑战：（1）上下文信息少；（2）依赖常识知识；（3）标注数据通常有较多的噪音。为了解决前两个挑战，我们首先尝试在模型中引入了图谱信息，主要包含以下三个维度：

- **节点信息**：将图谱实体作为词典，以Soft-Lexicon方式接入，以此来缓解NER的边界切分错误问题。
- **关联信息**：商品标题解析依赖常识知识，例如在缺乏常识的情况下，仅从标题“乐事黄瓜薯片”中，我们无法确认“黄瓜”是商品品类还是口味属性。因此，我们引入知识图谱的关联数据缓解了常识知识缺失的问题：在知识图谱中，乐事和薯片之间存在着“品牌-售卖-品类”的关联关系，但是乐事跟黄瓜之间则没有直接的关系，因此可以利用图结构来缓解NER模型常识知识缺少的问题。具体来说，我们利用Graph Embedding的技术对图谱进行的嵌入表征，利用图谱的图结构信息对图谱中的单字，词进行表示，然后将包含了图谱结构信息的嵌入表示和文本语义的表征进行拼接融合，再接入到NER模型之中，使得模型能够既考虑到语义，也考虑到常识知识的信息。
- **节点类型信息**：同一个词可以代表不同的属性，比如“黄瓜”既可以作为品类又可以作为属性。因此，对图谱进行Graph Embedding建模的时候，我们根据不同的类型对实体节点进行拆分。在将图谱节点表征接入NER模型中时，再利用注意力机制根据上下文来选择更符合语义的实体类型对应的表征 ，缓解不同类型下词语含义不同的问题，实现不同类型实体的融合。

![图10 商品图谱标题解析](https://p0.meituan.net/travelcube/d9623de64d23d70f9b0761f45f596166488327.png)

图10 商品图谱标题解析



接下来我们探讨如何缓解标注噪音的问题。在标注过程中，少标漏标或错标的问题无法避免，尤其像在商品标题NER这种标注比较复杂的问题上，尤为显著。对于标注数据中的噪音问题，采用以下方式对噪音标注优化：不再采取原先非0即1的Hard的训练方式，而是采用基于置信度数据的Soft训练方式，然后再通过Bootstrapping的方式迭代交叉验证，然后根据当前的训练集的置信度进行调整。我们通过实验验证，使用Soft训练+Bootstrapping多轮迭代的方式，在噪声比例比较大的数据集上，模型效果得到了明显提升。具体的方法可参见我们在NLPCC 2020比赛中的论文《Iterative Strategy for Named Entity Recognition with Imperfect Annotations》。

![图11 基于噪音标注的NER优化](https://p0.meituan.net/travelcube/34f146e4c5c20840089a867d24a188c8319107.png)

图11 基于噪音标注的NER优化



### 2.3 效率提升

知识图谱的构建往往是针对于各个领域维度的数据单独制定的挖掘方式。这种挖掘方式重人工，比较低效，针对每个不同的领域、每个不同的数据维度，我们都需要定制化的去建设任务相关的特征及标注数据。在商品场景下，挖掘的维度众多，因此效率方面的提高也是至关重要的。我们首先将知识挖掘任务建模为三类分类任务，包括节点建模、关系建模以及节点关联。在整个模型的训练过程中，最需要进行效率优化的其实就是上述提到的两个步骤：（1）针对任务的特征提取；（2）针对任务的数据标注。

![图12 知识挖掘任务建模](https://p0.meituan.net/travelcube/e3f1f413dead7e7f3781749fce0dba36571254.png)

图12 知识挖掘任务建模



针对特征提取部分，我们摒弃了针对不同挖掘任务做定制化特征挖掘的方式，而是尝试将特征和任务解耦，构建跨任务通用的图谱挖掘特征体系，利用海量的特征库来对目标的节点/关系/关联进行表征，并利用监督训练数据来进行特征的组合和选择。具体的，我们构建的图谱特征体系主要由四个类型的特征组构成： 1. 规则模板型特征主要是利用人工先验知识，融合规则模型能力。 2. 统计分布型特征，可以充分利用各类语料，基于不同语料不同层级维度进行统计。 3. 句法分析型特征则是利用NLP领域的模型能力，引入分词、词性、句法等维度特征。 4. 嵌入表示型特征，则是利用高阶模型能力，引入BERT等语义理解模型的能力。

![图13 知识挖掘特征体系](https://p0.meituan.net/travelcube/77ef23cced777b2cbd12968c79ad0e57636871.png)

图13 知识挖掘特征体系



针对数据标注部分，我们主要从三个角度来提升效率。 1. 通过半监督学习，充分的利用未标注的数据进行预训练。 2. 通过主动学习技术，选择对于模型来说能够提供最多信息增益的样本进行标注。 3. 利用远程监督方法，通过已有的知识构造远监督样本进行模型训练，尽可能的发挥出已有知识的价值。

### 2.4 人机结合-专业图谱建设

当前医药健康行业结构性正在发生变化，消费者更加倾向于使用在线医疗解决方案和药品配送服务，因此医药业务也逐渐成为了美团的重要业务之一。相比于普通商品知识图谱的建设，药品领域知识具有以下两个特点：（1）具有极强的专业性，需要有相关背景知识才能判断相应的属性维度，例如药品的适用症状等。（2）准确度要求极高，对于强专业性知识不允许出错，否则更容易导致严重后果。因此我们采用将智能模型和专家知识结合的方式来构建药品知识图谱。

药品图谱中的知识可以分为弱专业知识和强专业知识两类，弱专业知识即一般人能够较容易获取和理解的知识，例如药品的使用方法、适用人群等；而强专业知识则是需要具有专业背景的人才能够判断的知识，例如药品的主治疾病、适应症状等。由于这两类数据对专家的依赖程度不同，因此我们分别采取不同的挖掘链路：

- **弱专业知识**：对于药品图谱的弱专业知识挖掘，我们从说明书、百科知识等数据源中提取出相应的信息，并结合通过专家知识沉淀出来的规则策略，借助通用语义模型从中提取相应的知识，并通过专家的批量抽检，完成数据的建设。
- **强专业知识**：对于药品图谱的强专业知识挖掘，为了确保相关知识百分百准确，我们通过模型提取出药品相关属性维度的候选后，将这些候选知识给到专家进行全量质检。在这里，我们主要是通过算法的能力，尽可能减少专业药师在基础数据层面上的精力花费，提高专家从半结构化语料中提取专业知识的效率。

在药品这类专业性强的领域，专业知识的表述和用户习惯往往存在差异。因此我们除了挖掘强弱专业知识外，还需要填补专业知识和用户之间的差异，才能将药品图谱更好的与下游应用结合。为此，我们从用户行为日志以及领域日常对话等数据源中，挖掘了疾病、症状和功效的别名数据，以及药品通用名的俗称数据，来打通用户习惯和专业表述之间的通路。

![图14 人机结合的专业知识挖掘](https://p0.meituan.net/travelcube/6c03e3f1eb156f138d50565d17c4dcba838119.png)

图14 人机结合的专业知识挖掘



## 3.商品图谱的落地应用

自从谷歌将知识图谱应用于搜索引擎，并显著提升了搜索质量与用户体验，知识图谱在各垂直领域场景都扮演起了重要的角色。在美团商品领域中，我们也将商品图谱有效的应用在围绕商品业务的搜索、推荐、商家端、用户端等多个下游场景当中，接下来我们举几个典型的案例进行介绍。

### 3.1 结构化召回

商品图谱的数据，对于商品的理解很有帮助。例如，在商品搜索中，如用户在搜索头疼腰疼时，通过结构化的知识图谱，才能知道什么药品是有止疼功效的；用户在搜索可爱多草莓、黄瓜薯片时，需要依赖图谱的常识知识来理解用户真正需求是冰淇淋和薯片，而不是草莓和黄瓜。

![图15 基于图谱的结构化召回](https://p0.meituan.net/travelcube/44079fcc1e7587a6df37093a9bea1ec1494227.png)

图15 基于图谱的结构化召回



### 3.2 排序模型泛化性

图谱的类目信息、品类信息、属性信息，一方面可以作为比较强有力的相关性的判断方法和干预手段，另一方面可以提供不同粗细粒度的商品聚合能力，作为泛化性特征提供到排序模型，能有效地提升排序模型的泛化能力，对于用户行为尤为稀疏的商品领域来说则具有着更高的价值。具体的特征使用方式则包括： 1. 通过各颗粒度进行商品聚合，以ID化特征接入排序模型。 2. 在各颗粒度聚合后进行统计特征的建设。 3. 通过图嵌入表示的方式，将商品的高维向量表示和排序模型结合。

![图16 基于图谱的排序优化](https://p0.meituan.net/travelcube/3253ed72719c06177550fc3ab3ba0640435014.png)

图16 基于图谱的排序优化



### 3.3 多模态图谱嵌入

现有的研究工作已经在多个领域中证明了，将知识图谱的数据进行嵌入表示，以高维向量表示的方式和排序模型结合，可以有效地通过引入外部知识达到缓解排序/推荐场景中数据稀疏以及冷启动问题的效果。然而，传统的图谱嵌入的工作往往忽视了知识图谱中的多模态信息，例如商品领域中我们有商品的图片、商品的标题、商家的介绍等非简单的图谱节点型的知识，这些信息的引入也可以进一步提升图谱嵌入对推荐/排序的信息增益。

![图17 基于多模态图谱的推荐-背景](https://p1.meituan.net/travelcube/32038708cca851aeb805f0de73f314a6398773.png)

图17 基于多模态图谱的推荐-背景



现有的图谱嵌入方法在应用到多模态图谱表征的时候会存在一些问题，因为在多模态场景下，图谱中边的含义不再是单纯的语义推理关系，而是存在多模态的信息补充的关系，因此我们也针对多模态图谱的特点，提出了MKG Entity Encoder和MKG Attention Layer来更好的建模多模态知识图谱，并将其表征有效的接入至推荐/排序模型中，具体方法可以参考我们在CIKM 2020发表了的论文《Multi-Modal Knowledge Graphs for Recommender Systems》。

![图18 基于图谱的排序优化-模型](https://p0.meituan.net/travelcube/7f5c24dd26c3183dd9764b0f4b4b8e45379428.png)

图18 基于图谱的排序优化-模型



### 3.4 用户/商家端优化

商品图谱在用户端提供显式化的可解释性信息，辅助用户进行决策。具体的呈现形式包括筛选项、特色标签、榜单、推荐理由等。筛选项的维度受当前查询词对应品类下用户关注的属性类别决定，例如，当用户搜索查询词为薯片时，用户通常关注的是它的口味、包装、净含量等，我们将会根据供给数据在这些维度下的枚举值展示筛选项。商品的特色标签则来源于标题、商品详情页信息与评论数据的提取，以简洁明了的结构化数据展示商品特色。商品的推荐理由通过评论抽取与文本生成两种渠道获得，与查询词联动，以用户视角给出商品值得买的原因，而榜单数据则更为客观，以销量等真实数据，反应商品品质。

在商家端，即商家发布侧，商品图谱则提供了基于商品标题的实时预测能力，帮助商家进行类目的挂载、属性信息的完善。例如，商家填写标题“德国进口德亚脱脂纯牛奶12盒”后，商品图谱提供的在线类目预测服务可将其挂载到“食品饮料-乳制品-纯牛奶”类目，并通过实体识别服务，得到商品的“产地-德国”，“是否进口-进口”，“品牌-德亚”，“脂肪含量-脱脂”，“规格-12盒”的属性信息，预测完成后，由商家确认发布，降低商家对商品信息的维护成本，并提升发布商品的信息质量。

## 4.作者简介

雪智，凤娇，姿雯，匡俊，林森，武威等，均来自美团平台搜索与NLP部NLP中心。

## 5.招聘信息

美团大脑知识图谱团队大量岗位持续招聘中，实习、校招、社招均可，坐标北京/上海，欢迎感兴趣的同学加入我们，利用自然语言和知识图谱技术，帮大家吃得更好，生活更好。简历可投递至：caoxuezhi@meituan.com。

原文作者：美团技术团队

原文链接：https://tech.meituan.com/2021/09/02/meituan-commodity-nlp-practice.html