# 【NO.249】从零开始学架构（下篇）

以下内容来自于腾讯PCG工程师Chaoweili

## 10.业务高可用

### 10.1 异地多活

不同地区都提供业务服务，一个地区故障（机器宕机、机房故障、网络故障），其他地区可用，故障地区用户可请求到其他地区进行服务。异地多活实现复杂成本高，并不是所有系统都无脑的实现异地多活。

#### 10.1.1 异地多活架构

同城异区：同一城市双机房部署，例如北京双机房

跨地异区：不同城市多机房，例如：北京和广州两个机房

跨国异区：不同国家多个机房，例如：中国亚马逊，美国亚马逊

#### 10.1.2 异地多活设计技巧

1） 核心业务异地多活

2） 核心数据最终一致性

3） 多种手段同步数据：1）消息队列表； 2）二次读取；3）存储同步；4）回源同步；5）重新生成数据

4） 只保证大部分用户异地多活

#### 10.1.3 异地多活设计步骤

1） 业务分级：访问量大；核心业务；收入高的业务

2） 数据分类：数据量；唯一性；实时性；可丢失性；可恢复性

3） 数据同步：存储系统同步；消息队列同步；重复生成

4） 异常处理：多通道同步；同步和访问结合（数据分区同步）；日志记录；用户补偿（点券会员资格等安抚用户）

### 10.2 接口级的故障应对方案

内部：程序bug；外部：黑客攻击

#### 10.2.1 降级

业务接口功能降低，只提供部分功能。比如：只读不写；部分功能停止；尽量保证核心功能。

降级操作：1）单个服务提供接口打开降级开关；2）降级系统批量操作

#### 10.2.2 熔断

某个接口响应很慢会拖慢整个系统，熔断就是不在访问这个接口直接报错。

降级：接口本身功能故障处理；熔断：外部被调接口故障

#### 10.2.3 限流

降级：故障时按优先级处理

限流：故障时减少用户请求压力

**限流方式：**

1） 基于请求限流：

a. 总量限流：一个直播不能超过100万人

b. 时间段限流：一分钟最多接收N个人请求

2） 基于资源限流

例如：cpu、内存、句柄数等按可支持的qps负载限流

#### 10.2.4 排队

排队是限流的一个形式，限流是拒绝，排队是等待，比如用kafka队列缓存用户请求

排队模块将超量请求放入消息队列，调度模块读取队列，调用服务模块提供服务处理

**【第4部分】 可扩展架构模式**

## 11.可扩展模式

### 11.1 可扩展概述

不断迭代，产生新的功能

### 11.2 可扩展的基本思想

拆成不同子模块，拆分方式：按流程；按服务；按功能

### 11.3 可扩展方式

1） 面向流程拆分: 分层架构

2） 面向服务拆分: SOA、 微服务

3） 面向功能拆分 : 微内核架构。

## 12.分层架构

1） C/S、B/S架构

2） MVC结构、MVP架构

3） 逻辑分层架构：接入层、应用层、逻辑层、存储层

## 13.SOA架构

SOA（ Service Oriented Architecture）：面向服务的架构，解决传统企业IT系统重复建设和扩展效率低的问题。

1） 服务：所有业务功能都是一个服务

2） ESB（Eneterprise Service Bus）企业服务总线

3） 松耦合：各个服务之间减少依赖和相互影响

## 14.微服务

### 14.1 微服务的问题

1） 划分过细，服务之间的关系复杂

2） 服务数量过多，团队效率下降：功能改动需要N个服务同时配合改动

3） 调用链太长，性能下降，也增加了定位问题的成本：rpc链路长，增加了网络耗时

4） 如果没有自动化支撑，无法快速交付

5） 如果没有服务治理，微服务数量多了后管理混乱

### 14.2 微服务最佳实践

1） 合理拆分，粒度不易过细

2） 基础设施：自动发布、服务治理、服务发现、负载均衡、监控上报

### 14.3 拆分方法

1） 基于业务逻辑拆分：按功能拆分服务模块

2） 基于可扩展拆分：稳定服务粒度粗一些，不稳定服务拆分细一些

3） 基于可靠性拆分：核心服务保证高可高，和非核心服务拆分开

4） 基于性能拆分：对于要求不同的模块拆分开，同一个模块的读写性能按需也可以拆分（比如，写少读量非常巨大）

### 14.4 基础设施

![img](https://pic3.zhimg.com/80/v2-119f9921620ff8ce6579e5d281b0f552_720w.webp)

1） 自动化测试：单元测试，接口测试，集成测试

2） 自动化部署：自动编译发布部署，版本管理，资源管理，灰度和回滚

3） 配置中心

4） RPC框架和协议：HTTP/REST，json/pb

5） API网关：微服务内部互联互通，对外部使用API网关：接入鉴权、权限控制、加密、路由、流量控制、协议转换

6） 服务发现：各个服务注册、状态维护、路由调度等。服务发现两种实现方式：自理式和代理式

7） 服务路由：服务路由调度算法：随机、轮询、最小负载（cpu内存等）、最小连接数等

8） 服务容错：容错方式：重试、流控（频控）、服务隔离（故障节点剔除）

9） 服务监控：上报监控系统

10） 服务跟踪：跟踪一个请求的整个链路。跟踪方式：采样跟踪、染色跟踪

11） 服务安全：接入安全、数据安全、传输安全

## 15.微内核架构

### 15.1 基本概念

**微内核架构（Microkemel Architecture）**：也被称为插件化架构( Plug-in Architecture)，是一种面向功能进行拆分的可扩展性架构。包含：核心系统和插件模块

### 15.2 设计关键点

1） 插件管理

2） 插件连接

3） 插件通信

### 15.3 OSGi架构简析

OSGi 的全称是 Open Services Gateway initiative，本身其实是指 OSGi Alliance。

![img](https://pic3.zhimg.com/80/v2-dfc1c8ccf6eb955a78091d8e2aead96e_720w.webp)

(1) 模块层( Module 层〉：插件管理，插件配置文件等

(2) 生命周期层( Lifrcycle层）：插件连接，提供执行时模块管理，对层OSGi框架的访问

(3) 服务层( Service层）：插件通信

**【第5部分】 架构实战**

## 16.消息队列设计实战

消息队列为例

列出三种方案：kafka、MySQL、自研存储

![img](https://pic4.zhimg.com/80/v2-6163e6c2c33745d133f363a3d350d64b_720w.webp)

![img](https://pic1.zhimg.com/80/v2-86d482db16a301a2deba1f214f265bc4_720w.webp)

评审对比后选择：2，MySQL

然后继续优化：表设计、主从部署、主备切换、读写服务

## 17.互联网架构演进

1） 潮流派

2） 保守派

3） 跟风派

除非是开创新的技术能够创造一种新业务，其他情况下都是业务发展推动技术的发展。

### 17.3 互联网业务发展

#### 17.3.1 业务复杂性

1） 初创期：创新

2） 发展期：快。功能迭代和优化

3） 架构期：量级越来越大，海量服务之道

4） 竞争期：平台化/服务化

5） 成熟期：对于弱势不断优化

#### 17.3.2 用户规模

1） 性能

2） 可用性

## 18.互联网架构模板

### 18.1 总体结构

![img](https://pic3.zhimg.com/80/v2-45da97d7d81599aa9c29e884534d31fa_720w.webp)

### 18.2 存储层技术

1）SQL

2）NoSQL

3）小文件存储

4）大文件存储

### 18.3 开发层技术

1） 开发框架

2） Web服务器

3） 容器

### 18.4 服务层技术

1） 配置中心

2） 服务中心

3） 消息队列

### 18.5 网络层技术

1） 负载均衡：CDN、Ngnix 、LVS、F5

2） CDN

3） 多机房：同城多机房、跨城、跨国

4） 多中心

### 18.6 用户层技术

1） 用户管理

2） 消息推送

3） 存储云与图片云

### 18.7 业务层技术

复杂性的一个主要原因就是系统越来越庞大，业务越来越多 ，降低复杂性最好的方式就是 “拆”，化整为零、分而治之，将整体复杂性分散到多个子业务或子系统里面去 。

### 18.8 平台技术

#### 18.8.1 运维平台

1） 配置

2） 部署

3） 监控

4） 应急

运维平台核心要素：标准化、平台化、可视化

#### 18.8.2 测试平台

1） 用例管理

2） 资源管理

3） 任务管理

4） 数据管理

#### 18.8.3 数据平台

1） 数据管理

2） 数据分析

3） 数据应用

#### 18.8.4 管理平台

1） 身份认证

2） 权限控制

## 19.架构重构

### 19.1 有的放矢

1） 后台系统重构：解决不合理的耦合

2） 游戏后台重构：解决全局单点的可用性问题

3） X系统：解决大系统带来的开发效率问题

### 19.2 合纵连横

#### 19.2.1 合纵

团队内部达成一致

#### 19.2.2 连横

外部团队协调合作

### 19.3 运筹帷幄

重构实施：

1） 划分优先级

2） 问题分类

3） 先易后难

### 19.4 文武双全—项目管理+技术能力

项目管理

技术能力

## 20.开源系统

1） 开源：解决痛点

2） 二次修改开源项目：优化轮子

原文作者：鹅厂架构师

原文链接：https://zhuanlan.zhihu.com/p/540745359