# 【NO.237】浅谈如何搭建知识体系

> 在电影《教父》中，有一句台词：“在一秒钟内看到本质的人和花半辈子也看不清一件事本质的人，自然是不一样的命运。”

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTy5ThgcxoZCTEKlxJR60zk4m79uibQMaiapNnzUBJROWw0sRDRibpDWFzg/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

为什么你只能看见的是豹子身上的花斑？为什么看到本质的人和他人的命运会不同呢？

这是因为他人的知识水平比你更加全面，更加深刻。知识的全面性能让你的选择面更广，每多掌握一门知识，就多一种未来。其次它能够让你的主动权更强，本领域的专精能让你更早接触新的知识领域，获得先发优势。以一道有趣的题目为例：

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTEwknUgTr2ibiccH7wxCOFdO7Mib5JE65FRiamhNexfFcY7DEuq3mHorgYg/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

有一只熊掉到一个陷阱里，陷阱深 19.617 米，下落时间正好 2 秒，求熊是什么颜色的?  

看到这道题的陷阱深度以及下落时间，相信朋友们会很容易联想到重力加速度，可是题目的却让我们选择熊的颜色，这样的题目应该怎么解析呢？ 

其答案如下：

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTzdMK68SLicicbChXxpsTLsGBWLoiam9eF32nqfmlFoWsr0hwhT3yiay0jQ/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

在这里我们无须过于细究其解题实际步骤，但它解题的方式却使用了物理、地理、生物以及数学等多个学科的知识。 

如果我们仅仅具有某一学科的知识，则无法选出正确的答案。这也是知识体系的魅力之一，它让我们在解决问题时拥有“十八般武艺”。

### 1.**知识 VS 知识体系**

#### 1.1 什么是知识

根据柏拉图的定义，一条陈述能称得上是知识必须满足三个条件，它一定是被验证过的，正确的，而且是被人们相信的。

在这里又会有一个常见的疑问，信息是不是知识？个人认为知识一定是信息，而信息则需要加以过滤、加工方可成为知识。知识是客观并可重复的，它能够指导我们决策或行动。

#### 1.2 什么是知识体系

知识体系有三个特性：目标性、体系性以及抽象性，多使用逻辑树进行构建。 

目标是指方向聚焦，体系有重点。体系是指结构完整、层次分明，前 2 层分支的平衡性越好，归纳程度也越强。而抽象则是知识体系是知识从具体到抽象的表现，呈现了知识的特征或本质。再进一层，什么是好的知识体系呢？除了上述所描述的有目标、够全面、抽象程度高，还有一点则是知识体系应该是**相互独立但非无限穷尽**的。 

有的知识仅须停留在知道，有的则需要运用并且创新。

#### 1.3 知识体系的作用

16 年美国生物学科学家估算大脑的存储容量约为 1000 万亿字节，相当于 1000TB。但同样容量的数据为什么在检索、使用的时候，人脑却远比电脑低效呢？检索从数据表的角度理解是索引和表结构，使用从代码的角度理解是类的封装和继承。建立知识体系，目的是建立类似电脑的数据存储和应用结构。从而认知知识全貌及迅速找到知识的关联。 前者用于查漏补缺，后者则用于知识的高效检索及组合使用。

### 2. **构建知识体系的步骤**

整体分为 4 步：找方法、建框架、收集知识、学习方式。

#### 2.1 找到自己的普适性方法

查理芒格曾经说过：“在手拿铁锤的人看来，世界就像一颗钉子。”因为你的手上只有铁锤，所以你只能用处理钉子的方式去处理一切，用铁锤去旋转螺丝钉，用铁锤去炒菜。 很多时候我们并不是不会解决问题，而是缺少解决问题的方法，构建知识体系也是如此。

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTV1jpiaY6I1qOVFGW5FlkaGLia6Y24Vgn6m6dHcKwBydmOicLvMOQTGSVA/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

在构建之前，我们应找到自己的普适性方法。对于笔者而言它是逻辑思维，但对于你而言可能是经济学的定律、数学的定理亦或者生物学中的生物群落。 上图仅仅只是一个示例，解决问题更多不应给自己设定框架，我们应使用多种方法的组合。

#### 2.2 明确体系的方向

我们总说这是一个信息爆炸的时代，每时每刻我们接收着大量的信息和噪声，如果不予以治理、过滤，我们将无法听到真正的声音。早在 2300 多年前，庄子曾经说过以有限的生命追逐无限的知识，那么一定会失败。搭建知识体系的目的在于**圈定范围、有序学习。**

**1）明确体系目标**

目标决定了我们要建立什么样的知识体系。使用逆向思维以目标作为终点，反向度量与目标的距离。

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTbTEHgcYVuUAMNWHygkm41OEksBcIiaYpJVzgJnaUPygsmMia1Yn7NKng/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

思考产品经理需要学习什么知识，思路会无序延伸，容易遗漏并导致知识框架不平衡。 这种情况不妨反过来想，要应聘的岗位要求产品经理拥有什么样的知识？从岗位的 JD 入手反推我们的知识体系。

**2）明确体系的广度以及深度**

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTtDACKibwybrrXQD65N71ywSOV3CIch74LcWibFoGh7XH3sRhF5ghMZPQ/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

广度，体现在知识树的纵向分类，解决的是要不要的问题。深度，则体现在知识树的横向延伸，面向的是学习程度。 归纳程度越高，知识检索的效率越高。共性越强，后续在学习同类知识时，复用可能性越大。

通过树枝的纵向广度和横向深度，我们可以了解哪部分知识是目前缺失的，结合主干的优先级确认学习路径。

#### 2.3 收集知识

**1）评估优先级**

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTicdu3wdNR4g0gUzGs3QVhLwVNyVLPeVEKTClOTc1iacaVQtjqvVkgtrA/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

知识优先级的评估方式可以使用耗时和价值四象限图进行评估。 一般来说大部分耗时和价值呈正比例关系。耗时越短，说明被过滤的知识越多，知识也越片面。被过滤的知识只能作为学习的起点，每个人知识的侧重都是不同的，学习之前我们应尽可能的了解全貌。

**2）主动降噪**

主动降噪指知识卸载和去重。时间是我们最宝贵的资源。当占用你时间的信息源越多，耗费在学习的时间越少。 去重则是，减少同类信息源。同样是新闻，同类领域保留 2-3 个就够了。

**3）找到专业领域的大佬**

要想变成专业领域的牛人，一定踩过不少的坑。对比度娘，他们是更好的搜索引擎和导航地图，让他们帮助你提高获取知识的质量和效率。 选择的标准只需要比当前的你专业就足够了。

**4）付费知识＞免费知识**

免费知识的特征是：干扰信息多（广告）、获取路径长（关注、下载）、知识不完整（试听体验）。 如果获取知识耗费的时间成本已经大于金钱成本，不妨尝试一下付费，花钱是为了更好的挣钱。

#### 2.4 学习方式

由于社畜大部分的时间都在于工作，所以本节想分享工作中的学习方式。

**1）在翻译中学习**

在翻译中学习，可理解为遇见问题时**先用对方的解法**。对话的前提，是拥有对等的角度和相近的高度。只有足够全面的了解，解决需求的方法才能不拘泥于产品设计。

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTcx7ZHWga9qdopLcvg4tx6Ij6a8ib4FFpkrMswBr8p4M6UmBcbWoRYUA/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

如：在撰写 PRD 时，为了减少沟通成本。我会将可能将需求能翻译为研发的语言，减少理解的时间。其次也随着“翻译”能力的加深，系统的实现方式及约束也了解愈深。 不仅加深了对技术的了解，也能更好从系统实现方式的角度评估需求的可行性、实现成本以及周期。

**2）在使用中学习**

学习新的知识，应以使用为导向。当某个节点使用了常规的手段，关键指标仍无法提升。不妨尝试新的领域，现学现用并以使用作为终点，反推需要学习的知识。 以使用作为目的的好处是避免**踌躇不前**和**半途而废**，实践出新知。

**3）在复盘中学习**

![图片](https://mmbiz.qpic.cn/mmbiz_png/j3gficicyOvav1C1dASM293M0xYPjgzlJTO60UxbSP5ILQJtc2DG5egIhIaawNHf2Rjs1AuVHbFL41QYLz428wlw/640?wx_fmt=png&wxfrom=5&wx_lazy=1&wx_co=1)

复盘的目的为知识提炼，让其形成体系。在现实生活中没有太多的灵光一现，更多的是旧知识新组合。 

带着原有的基础再去学习新知识，能够让我们迅速找到知识的共性，从而提高学习的效率或同类问题的解决之中。而体系的扩张，也让知识不再是孤岛，每一个知识都能找到和其他知识联结的枢纽，让我们在输出解决方案时拥有更多的排列组合。

单次知识的提炼很容易，但是坚持才能带来质变。1900 年到 1999 年，道琼斯指数增长了 176 倍，但它的年复合增长不过 5.3%而已。

**写在最后**

一篇纯理论的通识文章写的非常吃力，5 个工作日的凌晨完成了这篇文章，质量上的欠缺也请多多包涵。 感谢你看到这里，谢谢。

原文作者：wisehuang

原文链接：https://mp.weixin.qq.com/s/E0u7LmT__x4R9mWNxfDDjA