# 【NO.229】云时代，我们需要怎样的数据库？

本文作者腾讯云TDSQL负责人潘安群。潘安群主要负责腾讯云分布式数据库研发，拥有超过13年分布式数据库研发经验，研发成果多次入选国际顶会VLDB、SIGMOD等。他带领团队打造的安全可控分布式数据库TDSQL，是业内首个应用于互联网银行核心交易系统、首个进入银行传统核心系统、首个助力传统大型银行实现银行业首例“大型机”下移分布式平台的国产企业级分布式数据库。

## **0.引言**

数据库技术发展已达半个世纪之久，数据库图灵奖得主Michael Stonebraker曾在Readings in Database Systems中将数据库模型技术分为9个不同的时代与类型，而云时代开始以后，我们可以从全新的视角审视数据库等基础技术的过去和未来。

基于云计算，包括数据库在内的IT基础技术发生从技术形态到线上线下整个市场结合的大幅变化，数据库技术呈现从传统集中式到云时代分布式迁移替换的趋势，这也给国产数据库赋予机遇与挑战。

在2020年11月，Gartner发布了2020年度的数据库厂商评估报告，国数据库厂商占据三席，标志着国内数据库进入全新发展阶段。

同时，Gartner预测，到2022年，世界上3/4的数据库都会跑在云上，而我们认为，云数据库的发展，目前正在经历从第一阶段“数据库上云，即从数据库到云数据库”，到第二阶段“从云数据库到云原生数据库”的变革。

归根结底，云数据库做了什么得到了业内的认可？未来数据库发展趋势是什么？我们可以如何在新机遇下的云融合时代把握技术创新的脉搏？在当前国产数据库也成为一个热门话题之际，我们谈一谈我们的理解和思考，与大家共勉。

## **1.云时代的IT基础技术形态演变**

随着云计算的发展，整个IT基础技术翻天覆地的变化体现在几个方面：

IT设施部署，从过去的零散化走向今天的集中化、规模化。过去，每一个企业自建各自的数据中心等IT基础设施，包括服务器、网络到操作系统、数据库等，形成企业市场上零散化的IT设施模式。而今天基于云计算服务，企业IT设施呈现集中化、规模化效应，对效率、性能、成本的要求提升。

IT服务交付，从过去的软件交付模式走向服务交付模式。过去购买商业化软件，或者是使用开源软件产品，基本是通过商业化或开源的方式进行分发，而现在完全变成一个个服务的形式进行交付。这带来的变化是，用户不需要再盘算该购买几台服务器，而是在具有数据库使用需求时，直接云上使用即可。

开发方式，将呈现从过去业务进行非常底层的开发以及调用底层API等操作的模式，转向SaaS化、Severless模式的服务。在云上，开发者可以使用各种各样的SaaS服务。无论从效率、基础技术能力等方面来说，这都是一个巨大的变化。

而数据形式及应用场景领域而言，事实上过去的数据形式或应用场景相对单一，以传统数据库为例，场景主要集中在了比如金融、运营商、政务等传统行业领域。随着互联网、移动互联网、产业互联网的发展，各个行业也正逐步加速其电子化、信息化发展趋势，应用服务形式呈多样化发展，使得当前行业的数据形式及应用场景也越来越多样化，并对底层数据库能力提出更多的要求和挑战。过去，行业场景中更多以结构化的数据为主，关系型数据库可以支撑极大部分场景需求，现在我们可以看到涌现出了许多如NoSQL、Graph图数据库等各种类型的数据库，NoSQL下属同时还可以细分KV型、文档型等多种类别，而且整体数据库类型还有持续增加的趋势。这是非常合理的现象。也就是说，对于未来数据库来说，其自身发展也会呈现多样化的、而且是融合、创新的趋势。我们知道，按照传统经验来说，如果一个技术产品是单一的形态，那么追求的是尽量做到通用化，然而，在当前多样化需求的趋势下，技术应用层面需要进行各种权衡和取舍。

因此可以说，这是云时代的发展变化，对数据库带来的新的挑战和要求。在当前云数据库成为大势所趋的同时，我们认为，国产云数据库要发展好，需要持续在基础能力、成本效率、产品化、未来技术融合等各个层面进行探索突破。

## **2.云数据库技术演进的挑战**

结合云计算的特点，国产云数据库发展面临着需要持续探索可用性与一致性、高并发性能、弹性可扩展等基础能力突破，同时面向云时代的多样化趋势打造新一代分布式数据库产品的挑战和要求。

### 2.1 可用性与一致性。

作为数据库，高可用性、数据一致性是最基础的挑战。高可用性，要求达到99.999%以上；数据强一致性，意味着数据不出错，数据库高度可靠。云计算时代，技术设施的升级换代对技术实现方式带来变革。过去，比如金融行业，系统基于稳定性较高的传统集中式大型机或小型机来保障系统的可用性与一致性。然而，传统集中式结构存在明显的技术边界，包括性能和吞吐量的边界，今天它们已然面临较大的吞吐和性能瓶颈，无法满足云时代的产业需求。自然地，当前产业趋势是向分布式架构转型升级，转向基于x86等的分布式、开放式平台。传统架构系统依赖于大型机或小型机在硬件层面进行的大量的冗余设计，在硬件层面实现可用性与一致性保障。而相对来说，基于x86机器部署的新一代分布式架构系统，则在如何实现性能、无限水平扩展的基础上保证数据一致以及系统高可用提出新的挑战要求。

### 2.2 性能成本。

云计算时代，如果实现了规模化以后，还不能实现成本降低的话，是不可接受的。云计算要帮助提升整个社会资源利用率，性能成本需要控制到最低。

对于腾讯云的服务来说，我们需要考虑的是如何能够保证客户以最便宜的价格买到最高级的服务——比如花最少的钱买到最大的磁盘空间、以及最好的TPS等产品表现。而在这个过程中，最核心的就是资源利用率。举个例子，云计算服务商如果把资源利用率提升20%，对客户、服务商本身而言将能极大地降低一部分成本。

### 2.3 云原生意味着一定是弹性伸缩的。

弹性伸缩，也就是可以根据用户的实际需求进行资源分配与使用，而不再是过去通过预采购或预分配的方式。过去，客户大部分都是先预估，然后采购，所以资源利用率一直被诟病；现在则不需要用户再预估自己未来可能会用到多少资源，而是可以根据实时的使用需求实现弹性伸缩。也因为这样，通过提高资源利用率，云数据库才可以实现成本上的优势。但是，极致弹性伸缩对数据库在更高程度的SQL支持、分布式事务能力方面，提出了更高的要求。

### 2.4 云数据库产品化服务化程度。

国内数据库发展历程也经历多个阶段，但正是云计算、互联网的时代兴起，国内诸多腾讯这类云厂商得以抓住机会，基于自身业务场景特点和需求，发展新一代数据库等基础软件技术。在过去很多年的时间当中，腾讯非常重看重的一点就是，如何打磨提升整个数据库的产品化程度，提升用户体验，包括技术产品化、服务完善等方面。互联网厂商基于内部业务场景发展自己的技术体系，这是优势的一面，而在to B开放的过程中，同时也面临产品标准化、通用性、使用体验等挑战。面向行业客户提供技术产品，其要求比支撑内部使用高得多。对于传统企业客户而言，腾讯云希望提供给到客户的是一个完整的产品，而不是一个半成品。因此，产品化程度，是腾讯一直持续强调的能力。

### 2.5 海量场景验证。

最后关键的一点是，对于云数据库而言，包括稳定性、特性需求等基础能力的发展，核心条件是需要有足够的应用场景进行打磨。数据库系统的研发、完善是一个非常复杂的过程，如何让数据库得到实践、得到应用？走到今天，我们认为，持续的、海量的场景打磨，是产品发展的关键条件。得益于腾讯自身以及云上各行各业的应用，超过百万开发者的使用，腾讯云数据库能够有足够的空间打磨产品。这是我们的挑战，也是推动我们发展的土壤。

这些挑战是云数据库发展过程中的必经之路，也是我们在云计算时代创造出新一代分布式数据库产品的机遇。

## **3.云数据库未来关键趋势**

基于这些挑战以及云计算时代赋予的机会，我们认为未来云数据库发展将包括几大趋势要求：

**弹性伸缩：解决成本核心问题——资源利用率**

前面提到，成本与性能是核心的要素。这里引申出来一个云计算时代的差异，那就是我们需要实现对CPU、内存和磁盘等基础设施资源的灵活调度。

云数据库时代我们将通过对极致的弹性伸缩架构探索，来综合解决性能、效率和成本问题。针对不同的场景侧重，云原生分布式数据库可分为两种架构：一种是Shared Nothing，一种是Shared Storage，两者都可以通过实现计算与存储分离架构来整体获得更优秀的弹性伸缩能力，克服传统架构下的存储量受限、扩展难、主从延迟高等缺点，同时也能够帮助我们将成本控制得更低，充分释放领先技术的成本效益。

而计算与存储全Serverless架构的数据库服务也是未来可重点关注的方向，它在可自动无感扩缩容的基础上，同时实现可按实际使用计费，不用不付费，提升云数据库效用。

**多模多引擎趋势下的数据库底层与服务超融合**

新基建、产业互联网快速发展，各行各业数字化进程加速，数据形式越来越多样化，越来越海量，如何能最高效地解决数据库在性能、成本、服务等方面问题，超融合是必然趋势。

当下我们处于各行各业都在推进电子化、信息化建设和数字化转型的趋势浪潮之下，行业不断涌现出大量的新兴场景。数据库作为支撑各类IT系统架构的基础软件技术，其整个技术形态也随之出现各类新的应用实现，包括大量的NoSQL实践，以及存储领域有传统的B+ Tree、现在的LSM Tree，和行存、列存等架构形态产品；而根据workload类型区分的话，则涌现出包括OLTP、OLAP，或者两者混合形成的HTAP型数据库等。

而多种多样的引擎产品，在大多数情况下不会独立存在来服务于一个企业或系统。One size fits none。从技术角度看，极致的性能成本与通用性有着天然的矛盾，因此，在多样化场景下，一定会是多引擎共存，充分发挥各种引擎的特点与优势，才能实现极致与通用的兼得。

但是不是作为云数据库服务厂商，我们把这些各类引擎产品都暴露给客户、开发者自行选择呢？从产品服务体验的角度看，必然不是。多模态技术引擎的现状必然对开发者选型带来选型、开发应用上的困难——即如何能够在保证适应不同的场景下，同时获得足够高的性能表现，这也是当前数据库发展面临的一个困境。为了解决这个问题，未来我们希望是不需要用户来进行这些复杂的选择，而是系统基于AI智能调度、serverless等解决方案，来彻底实现多引擎的统一标准化服务。从底层的角度看，未来开发者无需感知具体的产品选型，而比如在做数据分析的时候，系统能够自动帮助调度性能最好、事务交易一致性得到保障的方案。

在此基础上，未来云数据库服务的趋势还是交付方式的融合，包括软硬件一体化、私有云与公有云平台融合等多种产品和服务交付方案，能够让客户在敏感业务和运营成本之间实现更加精细化管理。

### 3.1 **智能化：AI+DB**

智能化技术等底层技术生态融合变革，实现数据库自治与智能管理也是未来数据库趋势之一。过去，对于一个企业，也许几个DBA来管理几十套实例就足够了，但比如对腾讯来说，数十万的数据库实例，难以通过配置人力来维持运营，因此倒逼我们必须要通过工具或平台来解决运营效率的问题。此外，当前分布式微服务改造的趋势下，未来企业IT运营也将具有越来越强烈的自治需求。智能化技术与数据库底层的融合，能实现对数据库进行全生命周期智能管理。

### **3.2 加速释放新硬件红利**

过去一个新硬件的推广周期很长，很多传统企业在采购新硬件方面相对非常保守。而对于云厂商来说，相对有条件逐步率先探索新硬件的应用，比如先在非关键性应用，同时也具备海量的场景验证，来实现稳步规模化的推广。这个角度来说，基于云计算服务，云原生数据库相对更加容易探索、释放到新硬件带来的红利。

当前我们也处于新硬件创新层出不穷的时代，包括SSD、NVM、RDMA+SPDK、千核服务器、异构处理器等，基于云数据库服务，广大的客户、普通开发者也能够更快速地享受到新硬件带来的加持。

因此，融合、自治、效用是未来企业级分布式数据库基本特点。腾讯云数据库将从实践层面对以上趋势进行落地推进，来满足各行各业客户未来对数据库的多样性需求。

原文作者：潘安群

原文链接：https://mp.weixin.qq.com/s/2uG1WjCjqOJWJceCTj5zSA