# 【NO.153】Linux专家谈如何学习Linux，以及Linux的职业发展

记得最早接触linux是在2002年，那个时候，还在上大学，曾经为安装一个系统让我们忘记疲劳，挑灯夜战，不亦乐乎。那时如果会安装一个Linux系统也是可以走进不少女生宿舍，哈哈。那时Linux的学习资料还很少，能够学习的书籍也不多，网上Linux技术社区也很少，就凭着Redhat6.2自带的几页使用说明开始了学习linux的生涯。

转眼间，10几年过去了，我也与Linux相伴了10多年，10年间，随着虚拟化、云计算时代的来临，Linux迅猛发展，在服务器领域已经占据半壁江山，而基于Linux的运维也面临新的挑战：面对越来越复杂的业务，面对越来越多样化的用户需求，不断扩展的应用需要越来越合理的模式来保障Linux灵活便捷、安全稳定地持续提供服务，这种模式中的保障因素就是Linux运维。从初期的几台服务器发展到庞大的云计算数据中心，单靠人工已经无法满足在技术、业务、管理等方面的要求，那么标准化、自动化、稳定性、可靠性等业务需求越来越被人们所重视。因此，对Linux的高性能、可靠性提出了更高的要求。

2009年我完成了基于Linux操作系统的作品《循序渐进Linux——基础知识、服务器搭建、系统管理、性能调优、集群应用》，此书出版后，得到了很多同行的认可，但是，此书出版已近6年，书中介绍的部分知识点和操作系统版本已经变得陈旧，已不能满足Linux以及开源技术迅速发展的需求，抱着对读者和本书负责的态度，我决定修订此书，因此也就有了这本《循序渐进Linux（第2版）——基础知识、服务器搭建、系统管理、性能调优、虚拟化与集群应用》这本新书。

今天不讲深入的东西，只想将自己多年来学习Linux的心得与感受与大家一起分享下，希望能给爱好Linux的朋友们或者Linux的同行们一点意见和建议，一点经验心得与大家共勉！

## 1.Linux在各领域发展的现状与趋势

很多新手都有一个很疑惑的问题：“Linux我听过，但是学习linux系统，能在上面干什么呢，或者说linux系统具体能做什么”，带着这个疑问，在本书的开篇，我们先来了解下Linux与开源软件的关系以及Linux的应用领域和未来的发展趋势。

### **1.1.Linux与开源软件**

Linux是一种自由和开放源代码的类UNIX操作系统，该操作系统的内核由林纳斯托瓦兹在1991年首次发布，之后，在加上用户空间的应用程序之后，就成为了Linux操作系统。严格来讲，Linux只是操作系统内核本身，但通常采用“Linux内核”来表达该意思。而Linux则常用来指基于Linux内核的完整操作系统，它包括GUI组件和许多其他实用工具。

GNU通用公共许可协议（GNU General Public License，简称GNU GPL或GPL），是一个广泛被使用的自由软件许可协议条款，最初由理查德斯托曼为GNU计划而撰写，GPL给予了计算机程序自由软件的定义， 任何基于GPL软件开发衍生的产品在发布时必须采用GPL许可证方式，且必须公开源代码，

Linux是自由软件和开放源代码软件发展中最著名的例子。只要遵循GNU通用公共许可证，任何个人和机构都可以自由地使用Linux的所有底层源代码，也可以自由地修改和再发布。随着Linux操作系统飞速发展，各种集成在Linux上的开源软件和实用工具也得到了应用和普及，因此，Linux也成为了开源软件的代名词。

### **1.2. Linux在服务器领域的发展**

随着开源软件在世界范围内影响力日益增强，Linux服务器操作系统在整个服务器操作系统市场格局中占据了越来越多的市场份额，已经形成了大规模市场应用的局面。并且保持着快速的增长率。尤其在政府、金融、农业、交通、电信等国家关键领域。此外，考虑到Linux的快速成长性以及国家相关政策的扶持力度，Linux服务器产品一定能够冲击更大的服务器市场。

据权威部门统计，目前Linux在服务器领域已经占据75%的市场份额，同时，Linux在服务器市场的迅速崛起，已经引起全球IT产业的高度关注，并以强劲的势头成为服务器操作系统领域中的中坚力量。

### **1.3. Linux在桌面领域的发展**

近年来，特别在国内市场，Linux桌面操作系统的发展趋势非常迅猛。国内如中标麒麟Linux、红旗Linux、深度Linux等系统软件厂商都推出的Linux桌面操作系统，目前已经在政府、企业、OEM等领域得到了广泛应用。另外SUSE、Ubuntu也相继推出了基于Linux的桌面系统，特别是Ubuntu Linux，已经积累了大量社区用户。但是，从系统的整体功能、性能来看，Linux桌面系统与Windows系列相比还有一定的差距，主要表现在系统易用性、系统管理、软硬件兼容性、软件的丰富程度等方面。

### **1.4. Linux在移动嵌入式领域的发展**

Linux的低成本、强大的定制功能以及良好的移植性能，使得Linux在嵌入式系统方面也得到广泛应用，目前Linux以广泛应用于手机、平板电脑、路由器、电视和电子游戏机等领域。在移动设备上广泛使用的Android操作系统就是创建在Linux内核之上的。目前，Android已经成为全球最流行的智能手机操作系统，据2015年权威部门最新统计，Android操作系统的全球市场份额已达84.6%。

此外，思科在网络防火墙和路由器也使用了定制的Linux，阿里云也开发了一套基于Linux的操作系统“YunOS”，可用于智能手机、平板电脑和网络电视；常见的数字视频录像机、舞台灯光控制系统等都在逐渐采用定制版本的Linux来实现，而这一切均归功与Linux与开源的力量。

### **1.5. Linux在云计算/大数据领域的发展**

互联网产业的迅猛发展，促使云计算、大数据产业的形成并快速发展，云计算、大数据作为一个基于开源软件的平台，Linux占据了核心优势；据Linux基金会的研究，86%的企业已经使用Linux操作系统进行云计算、大数据平台的构建，目前，Linux已开始取代Unix成为最受青睐的云计算、大数据平台操作系统。

## 2.选择适合自己的Linux发行版

谈到Linux的发行版本，太多了，可能谁也不能给出一个准确的数字，但是有一点是可以肯定的，Linux正在变得越来越流行。面对这么多的Linux发行版，打算从其他系统转到Linux系统来的初学者可能会感到困惑，即便是忠实的Linux用户也没有时间和精力去挨个尝试，因此初学者在学习Linux之前，需要有一个明确的方向，选择一个适合自己的Linux系统至关重要。下面我们就分类介绍。

### **2.1. 常见的Linux发行版**

#### **2.1.1.Red Hat Linux**

Red Hat Linux是Red Hat最早发行的个人版本的Linux，其1.0版本于1994年11月3日发行。虽然其历史不及其他Linux发行版本悠久，但比起很多的Linux发行套件，Red Hat的历史要悠久得多。自从Red Hat 9.0版本发布后，Red Hat公司就不再开发桌面版的Linux发行套件，Red Hat Linux停止了开发，而将全部力量集中在服务器版的开发上，也就是Red Hat Enterprise Linux版。2004年4月30日，Red Hat公司正式停止对Red Hat 9.0版本的支援，标志着Red Hat Linux的正式完结。原本的桌面版Red Hat Linux发行套件则与来自开源社区的Fedora进行合并，成为Fedora Core发行版本。

目前Red Hat分为两个系列：由Red Hat公司提供收费技术支持和更新的Red Hat Enterprise Linux，以及由社区开发的免费的Fedora Core。

#### 2.1.2. Fedora Core

Fedora Core（缩写为FC）被Red Hat公司定位为新技术的测试平台，许多新的技术都会在FC中检验。如果稳定的话Red Hat公司则会考虑加入到Red Hat Enterprise Linux中。

Fedora Core 1发布于2003年年末，而FC的定位便是桌面用户。FC提供了最新的软件包，同时它的版本更新周期也非常短，仅有6个月。由于版本更新频繁，性能和稳定性得不到保证，因此一般在服务器上不推荐采用Fedora Core。

Fedora对于用户而言，是一套功能完备、更新迅速的免费操作系统，因此，个人领域的应用，例如开发、体验新功能等可选择此发行版本。

#### **2.1.3．Red Hat Enterprise Linux**

Red Hat Enterprise Linux（缩写为RHEL，Red Hat的企业版Linux）。Red Hat现在主要做服务器版的Linux开发，在版本上注重了性能和稳定性，以及对硬件的支持。由于企业版操作系统的开发周期较长，注重性能、稳定性和服务端软件支持，因此版本更新相对较缓慢。

RHEL的版本都是基于Fedora。大约每六个版本的Fedora会有一个新版本的RHEL发布，因此，RHEL大约3年发布一个新版本。其最新版本是2015年3月6日发布的RHEL 7.1。本书就是以此版本展开讲述的。

#### **2.1.4．Centos**

CentOS全名为“社区企业操作系统”（Community Enterprise Operating System）。它是来自于RHEL依照开放源代码规定发布的源代码所编译而成，由于RHEL是商业产品，因此必须将所有Red Hat的Logo标识改成自己的CentOS标识，这就产生了CentOS操作系统，两者的不同在于，CentOS并不包含封闭源代码软件。因此，CentOS不但可以自由使用，而且还能享受CentOS提供的免费长期升级和更新服务。这是CentOS的一个很大优势。

CentOS采取从RHEL的源代码包来构建，它的版本号有两个部分：一个主要版本和一个次要版本，主要和次要版本号分别对应于RHEL的主要版本与更新包，例如CentOS6.5构建在RHEL6.0更新的第5版。但是从RHEL7.0版本以后，CentOS版本命名格式又稍有变化：主要版本仍然对应于RHEL的主要版本，次要版本以RHEL更新包发布日期为准，例如RHEL7.1对应的CentOS版本为CentOS 7.1.1503，这表示RHEL7.1版本是2015年3月份发布的。

在2014年CentOS宣布与Red Hat合作，但CentOS将会在新的委员会下继续运作，并不受RHEL的影响。这个策略表明CentOS后续发展将有Red Hat作为强有力的支持。

#### **2.1.5. SuSE Linux**

SUSE是德国最著名的Linux发行版，也享有很高的声誉，不过命运相当坎坷；2003年11月4日，Novell公司对外宣布将收购SUSE。2004年1月该收购顺利完成，Novell同时将SUSE正式命名为SUSE Linux。Novell公司收购SUSE，加速了SUSE Linux的发展，将免费SUSE Linux改为openSUSE社区项目，但在2010年，Attachmate公司收购了Novell，在被收购后，SUSE Linux发展受阻，而就在3年后，SUSE再次易主，2014年9月Attachmate公司被上市公司Micro Focus收购，但幸运的是：SUSE官方宣布开源作为SUSE的发展之本，仍将持续贡献开源，SUSE仍将全力投入对openSUSE的支持。

虽然SUSE多次易主，但并不影响它的专业性，据不完全统计，SUSE Linux现在欧洲Linux市场占有将近80%的份额，大部分关键性应用都是建立在SUSE Linux下的。而由于SUSE多次易主，再加上SUSE在中国的营销模式问题，现在SUSE在中国的Linux市场份额并不大，但是这些并不影响SUSE Linux高可靠性与稳定性的事实。随着SUSE的发展，相信SUSE Linux在中国的应用会越来越多。

#### **2.1.6. Ubuntu Linux**

Ubuntu（中文谐音为友帮拓、优般图、乌班图）是一个以桌面应用为主的Linux操作系统，基于Debian GNU/Linux，Ubuntu的目标在于为一般用户提供一个最新的、同时又相当稳定的主要由自由软件构建而成的操作系统。Ubuntu具有庞大的社区力量，用户可以方便地从社区获得帮助。

#### **2.1.7. 发行版总结**

上面主要介绍了几种最常见的Linux发行版本，其实Linux的发行版本还有很多，比较常见的还有Debian GNU/Linux、Mandriva、Gentoo、Slackware、Knoppix、MEPIS和Xandros，以及国产的红旗Redflag、深度deepin Linux和中标麒麟Linux等，这里不再一一介绍。其实纵观Linux的各个发行版，Linux发行版本无非是朝着这两个方面而来，一是服务器市场，二是桌面市场。

以Ubuntu Linux为代表的Linux发行版走的是桌面市场路线，虽然它们给用户带来很多惊喜，更新也很快，但是由于桌面市场有着Windows这样强劲的对手，因此Linux桌面发展不容乐观，目前Ubuntu Linux也开始向企业级服务器市场发力。

以Red Hat系列版本为代表的Linux发行版现在主要面向企业级Linux的服务器市场，重点开发Linux的企业版本，其他的（例如国产Redflag、中标麒麟Linux等）都重点投入在了Linux服务器市场。Linux两大发布厂商现在都走了Linux服务器市场的路线，可见Linux作为企业级服务器有着巨大的发展前途。据权威部门统计，Linux在服务器市场的占有率每年都在持续上升。

其实很多Linux的应用都是针对Linux服务器的，本书的讲述也是主要针对Linux在服务器下的各种应用展开的。

### **2.2.初学者入门首选——Centos系列**

在了解了Linux几个主要发行版本后，我们就找到了为何选择CentOS作为初学者入门学习的理由了。

CentOS现在拥有庞大的网络用户群体，网络Linux资源基本80%都是基于CentOS发行版的，如果在学习过程中遇到任何问题，在网络中可以较容易地搜索到解决方案。

CentOS系列版本可以轻松获得。可以从CentOS官网或者163开源、sohu开源、阿里云开源站下载CentOS各个版本的安装介质，如果是第一次接触Linux，那么建议先安装Fedora Core。Fedora Core的安装简单，对硬件支持很好，界面也很华丽，同时也可以体验Linux的最新功能。如果对Linux有一定的了解，需要深入学习，建议使用CentOS发行版系统。

CentOS应用范围广，具有典型性和代表性，现在基本所有的互联网公司后台服务器都采用CentOS作为操作系统，可以说学会了CentOS，不但能迅速融入企业的工作环境，还能触类旁通，其它类似的Linux发行版也能很快掌握。同时，现在周围学习Linux的用户一般也都是以CentOS为主的，这样交流方便，学习中出现问题，更容易得到解决。最主要的是CentOS的安装和使用上也是最简单的，因此基本上不会在“装系统”上浪费过多时间。

### **2.3. 桌面平台首选——Ubuntu Linux**

说到Linux桌面市场，Ubuntu Linux几乎占据了桌面Linux的半壁江山，Ubuntu Linux主打Linux桌面之最，界面美观，简洁而不失华丽，如果想在Linux下进行娱乐休闲，Ubuntu Linux绝对是首选。

Ubuntu的安装非常人性化，只需按照提示一步一步进行。Ubuntu被誉为对硬件支持最好最全面的Linux发行版之一，许多在其他发行版上无法使用的，或者在默认配置时无法使用的硬件，在Ubuntu上都能轻松安装使用。因此用户可以像安装Windows一样轻松地安装Ubuntu，尽情体验Ubuntu Linux带来的乐趣。

### **2.4. 企业级应用首选——RHEL/Centos系列**

企业级的应用追求的是可靠性和稳定性，这就要求构建企业级应用的系统平台具有高可靠性和高稳定性。企业级Linux的发行版本就是解决的这个问题。

RHEL与Centos两个Linux发现版本，并没有太大差别，所不同的是RHEL属于商业Linux发行版本，如果要使用RHEL版本，则需要购买商业授权和咨询服务，Red Hat提供系统的技术支持并提供系统的免费升级。目前Red Hat官网已经不再提供可免费下载的光盘介质，如果需要试用，可通过官网下载有试用时间的评估版Linux。而CentOS属于非商业发行版，可以从网上免费下载CentOS各个版本的安装介质，但CentOS并不提供商业支持，当然使用者也不用负上任何商业责任。

那么，到底是选择CentOS还是RHEL呢，这取决于你所在公司是否拥有相应的技术力量，如果是单纯的业务型企业，那么建议选购RHEL发行版并购买相应服务，这样可以节省企业的IT管理费用，并可得到专业的技术支持服务。相反，如果企业技术力量比较强大，并且有多年Linux使用经验的话，那么CentOS发行版将是最好的选择。

## 3.养成良好的Linux操作习惯

开始Linux的学习之后，请不要用Windows的工作方式来思考问题，因为它们之间确实有很大的不同，比如它们之间的内存管理机制、进程运行机制等都有很大不同，因此抛开Windows的那种思维，用全新的理念尝试去挖掘Linux身上特有的潜质，对初学者是至关重要的。

### **3.1. 一定要习惯命令行方式**

Linux是由命令行组成的操作系统，精髓在命令行，无论图形界面发展到什么水平，命令行方式的操作永远是不会变的。Linux命令有许多强大的功能：从简单的磁盘操作、文件存取，到进行复杂的多媒体图像和流媒体文件的制作，都离不开命令行。虽然Linux也有桌面系统，但是X-window也只是运行在命令行模式下的一个应用程序。

因此，可以说命令是学习Linux系统的基础，在很大程度上学习Linux就是学习命令，很多Linux高手其实都是玩儿命令很熟练的人。

也许对于刚刚从Windows系统进入Linux学习的初学者来说，立刻进入枯燥的命令学习实在太难，但是一旦学会就爱不释手。因为它的功能实在太强大了。

### **3.2. 理论结合实践**

有很多初学者都会遇到这么一个问题，自己对系统的每个命令都很熟悉，但是在系统出现故障的时候，就无从下手了，甚至不知道在什么时候用什么命令去检查系统，这是很多Linux新手最无奈的事情了。说到底，就是学习的理论知识没有很好地与系统实际操作相结合。

很多Linux知识，例如每个命令的参数含义，在书本上说得很清楚，看起来也很容易理解，但是一旦组合起来使用，却并不那么容易，没有多次的动手练习，其中的技巧是无法完全掌握的。

人类大脑不像计算机的硬盘，除非硬盘坏掉或者硬盘被格式化，否则储存的资料将永远记忆在硬盘中，而且时刻可以调用。而在人类记忆的曲线中，必须要不断地重复练习才会将一件事情记得比较牢。学习Linux也一样，如果无法坚持学习的话，就会学了后面的，忘记了前面的。还有些Linux初学者也学了很多Linux知识，但是由于长期不用，导致学过的东西在很短的时间内又忘记了，久而久之，失去了学习的信心。

可见，要培养自己的实战技能，只有勤于动手，肯于实践，这也是学好Linux的根本。

### **3.3. 学会使用Linux联机帮助**

各个Linux的发行版本的技术支持时间都较短，这对于Linux初学者来说往往是不够的，其实当安装了完整的Linux系统后其中已经包含了一个强大的帮助，只是可能你还没有发现它，或者还没有掌握使用它的技巧。例如，对于tar命令的使用不是很熟悉，那么只要在命令行输入“man tar”，就会得到tar的详细说明和用法。

主流的Linux发行版都自带了非常详细的帮助文档，包括使用说明和FAQ，从系统的安装到系统的维护，再到系统安全，针对不同层次用户的详尽文档。仔细阅读文档后，60%的问题都可在这里得到解决。

### **3.4. 学会独立思考问题，独立解决问题**

遇到问题，首先想到的应该是如何自己去解决这个问题，解决方式有很多，比如看书查资料、网络搜索引擎搜索和浏览技术论坛等，通过这几种方式，90%的问题都能得到解决

独立思考并解决问题，不但锻炼了自己独立解决问题的能力，在技术上也能得到快速提高。如果通过以上方式实在解决不了的话，可以向人询问，得到答案后要思考为何这么做，然后做笔记记录解决过程。最忌讳的方式是只要遇到问题，就去问人，虽然这样可能会很快解决问题，但是长久下去遇到问题就会依赖别人，技术上也不会进步。

### **3.5. 学习专业英语**

如果想深入学习Linux，一定要尝试去看英文文档。因为，技术性的东西写的最好的，最全面的文档都是英语写的，最先发布的高新技术也都是用英语写的。即便是非英语国家的人发布技术文档，也都首先翻译成英语在国际学术杂志和网络上发表。安装一个新的软件时先看Readme文档，再看Install文档，然后看FAQ文档，最后才动手安装，这样遇到问题就知道原因了。因此，学习一点专业的英语是很有必要的。

## 4.Linux学习路线图

Linux开发或管理人才是企业目前急需的技术人才之一，笔者根据10多年Linux相关工作经验，总结出了一套学习Linux的线路图，大家可以此线路图为依据，抓住重点，分清主次，相信一定能达到事半功倍的效果。如果读者能认真学习完并掌握本线路图所涉及的技术要点，那么也就基本掌握了企业对Linux开发或管理人才的基本应用需求。

Linux学习线路图如下图所示，初级阶段主要是对Linux基础知识以及系统基本应用的介绍，要掌握的内容较多，如果初次接触Linux，那么入门还是有一定难度的，Linux注重的是命令操作，因此初级阶段以学习基础命令为主，多看书、多实践是学好命令的根本。

![img](https://pic3.zhimg.com/80/v2-2d0c0f2b9162d97eede19aa0b6dc52ca_720w.webp)

![img](https://pic4.zhimg.com/80/v2-04a5cf9f8e18bb3cbb107e2e30d23b6f_720w.webp)

![img](https://pic3.zhimg.com/80/v2-1c853b97fd831bdbe90cbac08f2eca26_720w.webp)

![img](https://pic2.zhimg.com/80/v2-325ca96c0ae4145eaaebc239a07651b1_720w.webp)

原文地址：https://zhuanlan.zhihu.com/p/304842470

作者：[Hu先生的Linux](https://www.zhihu.com/people/huhu520-10)