# 【NO.115】一大波C++进阶知识干货分享，请接收！

2020年是全球IT科技版图震荡和转折之年，系统级软件作为数字世界的核心基础设施，被视为“卡脖子”技术的关键，成为IT产学研“兵家必争之地”。C++语言一直被誉为系统级编程“皇冠上的明珠”。

在疫情放假那段时间，我就专心钻研C++进阶知识，终于功夫不负有心人，在不断地学习以及练习中，学会了很多知识，也算是学有所成，现在是一名月收入上万的Linux高级互联网架构师，觉得这么长时间的努力还是没有白费。

![img](https://pic1.zhimg.com/80/v2-9b95855affa78bfede6b505f254443e4_720w.webp)

## 1.源码分析专栏

关于这一部分的内容还是非常广阔的，主要讲一下关于nginx方面的知识。

### 1.1.Nginx基础架构

core ：Nginx的核心源代码，包括常用数据结构的以及Nginx 内核实现的核心代码；

event：Nginx事件驱动模型，以及定时器的实现相关代码；

http ：Nginx 实现http 服务器相关的代码；

mail ：Nginx 实现邮件代理服务器相关的代码；

misc ：辅助代码，测试C++头 的兼容性，以及对Google_PerfTools 的支持；

os ：不同体系统结构所提供的系统函数的封装，提供对外统一的系统调用接口；

stream：nginx（tcp/udp）反向代理及与上游通信的基础模块

### 1.2.HTTP架构

它的架构主要有七层，包括Controller、View、Application、Business、Component、Datadriver、Systemdriver。

这方面知识非常广阔，我主要拿两个重点讲，可能下面也有些内容讲得不够全面，大家都可以进交流群详细了解，免费领取相关学习资料。

1、Application

应用层在最上面，其针对实际中的单个页面或则单个接口, Controller通过HTTP请求地址中的参数找到对应的Application,然后执行中指定的公共方法，比如main(), 然后应用就开始启动。

应用层的职责包括接受HTTP参数(- 般是间接接受，比如从request对象中获取) ，调用Business层的特定业务，保存业务执行结果，这些结果最终会由View显示出来，当然是通过Controller协调。应用层是M层分解成五层之后最高的层，Controller会 与此层直接通信。

2、Business

业务层在应用层之下，通常一个应用实例对应一个业务实例， 而一个业务有可能为多个应用服务,业务是一个执行流， 它通过执行一系列的操作来完成应用的需求。

这些操作来自下层的组件层Component,可能一个业务需 要一个或则多 个组件来完成-个完整的需求。因为一个业务实例通常只对应-个功能，所以只有-个固定的方法会被上层的应用调用，比如flow()。 业务层的职责是帮应用层执行业务流并且有必要的时候返回数据给应用层，它会调用下层Component的方法。

### 1.3.进程间的通信机制

进程通常被定义为一个正在运行的程序的实例，它由两个部分组成：
一个是操作系统用来管理进程的内核对象，它是系统用来存放关于进程的统计信息的地方。
另一个是地址空间，它包含所有的可执行模块或DLL模块的代码和数据，还包含动态分配的空间，如线程堆栈和堆分配空间。

每个进程被赋予它自己的虚拟地址空间，当进程中的一个线程正在运行时，该线程可以访问只属于它的进程的内存。属于其它进程的内存则是隐藏的，并不能被正在运行的线程访问。

### 1.4.Nginx高级数据结构

![img](https://pic2.zhimg.com/80/v2-c21d86c61bb6a3d5756d945a3fde65ed_720w.webp)

### 1.5.Slab共享共存

使用共享内存，需要在配置文件里加上该共享内存的相关配置信息，而 Nginx 在进行配置解析的过程中，根据这些配置信息就会创建对应的共享内存，不过此时的创建仅仅只是代表共享内存的结构体 ngx_shm_zone_t 变量的创建。具体实现在函数 ngx_shared_memory_add 内。

### 1.6.upstream机制设计

1、轮询(weight)

指定轮询几率，weight和访问比率成正比，用于后端服务器性能不均的情况。默认当weight不指定时，各服务器weight相同，每个请求按时间顺序逐一分配到不同的后端服务器，如果后端服务器down掉，能自动剔除。

2、ip_hash

每个请求按访问ip的hash结果分配，这样每个访客固定访问一个后端服务器，可以解决session不能跨服务器的问题。如果后端服务器down掉，要手工down掉。

3、fair（第三方插件）

按后端服务器的响应时间来分配请求，响应时间短的优先分配。

4、url_hash（第三方插件）

按访问url的hash结果来分配请求，使每个url定向到同一个后端服务器，后端服务器为缓存服务器时比较有效。在upstream中加入hash语句，hash_method是使用的hash算法。

设备的状态有:

（1）down：表示单前的server暂时不参与负载

（2）weight：权重，默认为1， weight越大，负载的权重就越大。

（3）max_fails：允许请求失败的次数默认为1。当超过最大次数时，返回proxy_next_upstream 模块定义的错误。

（4）fail_timeout：max_fails次失败后，暂停的时间。

（5）backup：备用服务器, 其它所有的非backup机器down或者忙的时候，请求backup机器，所以这台机器压力会最轻。



## 2.对标腾讯T1-T9学习技术路线图谱

![img](https://pic4.zhimg.com/80/v2-0136174b9a47c53154bd90972b8b93b3_720w.webp)

## **3. 数十位大佬大厂面经视频及2021面试题资源分享**

![img](https://pic1.zhimg.com/80/v2-238077f1b5caa91c38999aac3cd24bfc_720w.webp)

## **4.金三银四”程序员26套求职简历模板**

![img](https://pic4.zhimg.com/80/v2-8eea469345276a43b1f78991b5d4e8f3_720w.webp)

作为一个过来人给大家提个醒，C++的学习是一个漫长的过程，特别是进阶需要花很多时间，学习过程也困难重重，所以最好是找学习的小伙伴，相互帮助一起学，学起来会感觉轻松一些，学习效果也不言而喻。

原文链接：https://linuxcpp.0voice.com/?id=107

作者：[HG](https://linuxcpp.0voice.com/?auth=10)