layui.define(['jquery', 'layer'], function (exports) {
    var $ = layui.jquery;
    var obj = {

        /**
         * POST请求
         * @param url
         * @param data
         * @param reload
         */
        post: function (url, data, reload = '') {
            data._csrf_zzzy = _csrf_zzzy;
            $.ajax({
                url: site_api+'?r='+ url,
                type: 'POST',
                dataType: 'json',
                data: data,
                success: function (res) {
                    if (res.code === 0) {
                        layer.msg(res.msg, {anim: 0, time: 1500}, function () {
                            if (reload) {
                                window.location.href = site_api +'?r='+ reload;
                            } else {
                                window.location.reload();
                            }
                        });
                    } else {
                        layer.msg(res.msg, {anim: 0, time: 1500});
                    }
                }
            });
        }
    };
    //输出接口
    exports('common', obj);
});
