<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:14
 */
 

use \yii\helpers\Url;

$this->title = '用户列表';
?>
<style>
    .layui-table-cell{
        height: auto;
        line-height: normal;
    }
</style>
<div class="layui-fluid">
    <form class="layui-form" lay-filter="userSearch" action="">
        <div  class="layui-row" style="padding: 5px 10px;">
            <div class="layui-col-md4">
                <label class="layui-form-label">用户昵称</label>
                <div class="layui-input-block">
                    <input type="text" name="nickname" placeholder="请输入" autocomplete="off" class="layui-input">
                </div>
            </div>
            <button lay-filter="search" lay-submit type="button" class="layui-btn layui-btn-blue" style="margin-left: 10px;">
                <i class="layui-icon">&#xe615;</i>筛选
            </button>
        </div>
    </form>
    <div class="layui-row layui-col-space15">
        <div class="layui-col-md12">
            <div class="layui-card">
                <div class="layui-card-body">
                    <table class="layui-hide" id="table" lay-filter="table"></table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    layui.use(['table','form'], function () {
        var table = layui.table,  form = layui.form;
        var table_init = {
            elem: '#table',
            method: "POST",
            where:{
                _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
            },
            url: "<?= Url::to(['user/list']);?>",
            cols: [[
                {field: 'id', title: '编号', sort: true, width: 80},
                {field: '', title: '头像',width: 80,templet:'<div><img style="width: 40px;height:40px;" src="{{d.avatar_url}}" alt=""></div>'},
                {field: 'nickname', title: '昵称'},
                {field: 'gender', title: '性别',templet: function(d){
                        if(d.gender == 1){
                            return '男';
                        }else if(d.gender == 2){
                            return '女';
                        }else{
                            return '未知';
                        }
                    }
                },
                {field: 'make_num', title: '制作次数'},
                {field: 'created_at', title: '加入时间', width: 200},
            ]], page: true, limit: 10
        };
        table.render(table_init);
        //搜索
        form.on('submit(search)', function (data) {
            var where = data.field;
            console.log(where);
            table.reload('table', {
                where: where
                , page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
        });

    });
</script>