<?php

/* @var $this yii\web\View */

$this->title = '主页';
?>
<style>
    .layui-card:last-child{
        background-color: #f7f8fa;
    }
    .layui-card-header{
        border-bottom: 1px solid #e6e6e6;
    }
</style>
<div class="layui-fluid">
    <div class="layui-col-md12" style="padding: 20px;">
        <div class="layui-row layui-col-space15">
            <div class="layui-col-sm4 layui-col-md4">
                <div class="layui-card">
                    <div class="layui-card-header">
                        当天制作
                        <span class="layui-badge layui-bg-blue layuiadmin-badge" style="background-color:#4C84FF!important; ">制作</span>
                    </div>
                    <div class="layui-card-body layuiadmin-card-list">
                        <p class="layuiadmin-big-font"><?=$make_num?></p>
                        <p>
                            总制作次数
                            <span class="layuiadmin-span-color"><?=$make_total?><i class="layui-inline layui-icon layui-icon-face-smile"></i></span>
                        </p>
                    </div>
                </div>
            </div>
            <div class="layui-col-sm4 layui-col-md4">
                <div class="layui-card">
                    <div class="layui-card-header">
                        当天新增
                        <span class="layui-badge layui-bg-cyan layuiadmin-badge">用户</span>
                    </div>
                    <div class="layui-card-body layuiadmin-card-list">
                        <p class="layuiadmin-big-font"><?=$user_num?></p>
                        <p>
                            总用户数量
                            <span class="layuiadmin-span-color"><?=$user_total?><i class="layui-inline layui-icon layui-icon-username"></i></span>
                        </p>
                    </div>
                </div>
            </div>
            <div class="layui-col-sm4 layui-col-md4">
                <div class="layui-card">
                    <div class="layui-card-header">
                        证件照
                        <span class="layui-badge layui-bg-orange layuiadmin-badge">证件照</span>
                    </div>
                    <div class="layui-card-body layuiadmin-card-list">
                        <p class="layuiadmin-big-font"><?=$item_total?></p>
                        <p>
                            支持证件照类型总数量
                            <span class="layuiadmin-span-color"><i class="layui-inline layui-icon layui-icon-flag"></i></span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="layui-row" style="margin-top:20px;padding: 10px;">
        <div id="main" style="width: 100%;height:400px;"></div>
    </div>
</div>
<script src="<?= Yii::$app->request->baseUrl?>/statics/lib/echarts.min.js"></script>
<script type="text/javascript">
    var myChart = echarts.init(document.getElementById('main'));
    layui.use([ 'layer'], function () {
        $ = layui.jquery;
        $("#pay").click(function () {
            var url = "<?=$api['pay_idcard']?>";
            layer.open({
                type: 2,
                title: '充值',
                shadeClose: true,
                shade: 0.8,
                area: ['800px', '600px'],
                content: url,
                cancel: function(index, layero){
                    window.location.reload();
                }

            });
        })
    });
    // 指定图表的配置项和数据
    var option = {
        title: {
            text: '最近7日统计'
        },
        tooltip : {

        },

        xAxis: {
            type: 'category',
            boundaryGap: true,
            axisLine:{
                lineStyle:{
                    color:'#999',
                }
            },
            data: ["<?=$time[0]?>","<?=$time[1]?>","<?=$time[2]?>","<?=$time[3]?>","<?=$time[4]?>","<?=$time[5]?>","<?=$time[6]?>",]
        },
        yAxis: {
            type: 'value',
            boundaryGap: [0, '20%'],
            axisLine:{
                lineStyle:{
                    color:'#999',

                }
            },
            splitLine:{
                lineStyle:{
                    width:1,
                    type:'dashed',
                    color:'#ccc',
                }
            }
        },
        grid: {
            left: '1%',
            right: '3%',
            bottom: '2%',
            containLabel: true
        },
        series: [{
            name: '制作次数',
            type: 'line',
            barWidth : '30%',
            smooth: true,
            itemStyle: {
                normal: {
                    color: '#c23531',
                    lineStyle:{
                        width:1
                    },
                    label: {
                        show: true, //开启显示
                        position: 'top', //在上方显示
                        textStyle: { //数值样式
                            color: 'black',
                            fontSize: 16
                        }
                    }
                }
            },
            data: ["<?=$data[0]?>","<?=$data[1]?>","<?=$data[2]?>","<?=$data[3]?>","<?=$data[4]?>","<?=$data[5]?>","<?=$data[6]?>",]
        }]
    };

    // 使用刚指定的配置项和数据显示图表。
    myChart.setOption(option);
</script>

