<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:25
 */

use \yii\helpers\Url;

$this->title = '基本设置';
?>
<style>
    .layui-form-label {
        width: 120px;
        font-size: 14px;
        color: #353535;
        padding: 9px;
    }
    .layui-input-block {
        margin-left: 160px;
        width: 40%;
    }
</style>
<div class="layui-fluid">
    <div class="layui-col-md12">
        <div class="layui-card">
            <div class="layui-card-header">基本设置</div>
            <div class="layui-card-body">
                <form class="layui-form">
                    <input type="hidden" name="id" value="<?=$item->id?>">

                    <div class="layui-form-item" style="margin-bottom: 0;">
                        <label class="layui-form-label" style="line-height: 100px;">入口二维码</label>
                        <div class="layui-input-block" style="">
                            <img style="width: 100px;height: 100px;" src="<?= $item->h5_qrcode?>" alt="">
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">入口地址</label>
                        <div class="layui-input-block" style="line-height: 36px;">
                            <?= $item->h5_url?>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">公众号名称</label>
                        <div class="layui-input-block" style="line-height: 36px;">
                            <?= $item->wx_name?>
                        </div>
                    </div>
                    <div class="layui-form-item" style="margin-top: 20px;">
                        <label class="layui-form-label" style="line-height: 60px;">公众号二维码</label>
                        <div class="layui-input-block">
                            <input type="hidden"  name="wx_qrcode" value="<?= $item->wx_qrcode?>" />
                            <?php if($item->wx_qrcode){?>
                                <img id="wx_qrcode" style="width: 80px;height: 80px;" src="<?= $item->wx_qrcode?>" alt="">
                            <?php }else{?>
                                <img id="wx_qrcode" style="width: 80px;height: 80px;" src="<?= Yii::$app->request->baseUrl ?>/statics/images/qr.png" alt="">
                            <?php }?>
                            <a style="margin-left: 10px;color:#4C84FF;display: none; " href="#" id="logo">上传二维码</a>
                        </div>
                    </div>

                    <div class="layui-form-item" >
                        <label class="layui-form-label">公众号账号</label>
                        <div class="layui-input-block" style="line-height: 36px;">
                            <?= $item->wx_account ?>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">下载设置</label>
                        <div class="layui-input-block">
                            <input type="radio" name="is_download" value="1" title="免费下载" <?php if($item->is_download == 1){?> checked<?php }?>  />
                            <input type="radio" name="is_download" value="2" title="关注公众号后可下载" <?php if($item->is_download == 2){?> checked<?php }?> />
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">应用主题颜色</label>
                        <div class="layui-input-block">
                            <select name="theme" lay-verify="required">
                                <option <?php if($item->theme ==1){?> selected <?php }?> value="1">蓝色</option>
                                <option <?php if($item->theme ==2){?> selected <?php }?> value="2">黄色</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">客服微信</label>
                        <div class="layui-input-block">
                            <input type="text" name="service_tel" value="<?= $item->service_tel ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">上班时间</label>
                        <div class="layui-input-block">
                            <input type="text" name="service_time" value="<?= $item->service_time ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">证件照Api Key</label>
                        <div class="layui-input-block">
                            <input type="text" name="zjzapi_key" value="<?= $item->zjzapi_key ?>" class="layui-input"/>
                            <a target="_blank" style="color: #01AAED;font-size: 13px;line-height: 30px;" href="https://www.zjzapi.com/">去申请</a>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label for="L_repass" class="layui-form-label"></label>
                        <button class="layui-btn layui-btn-blue" type="button" lay-filter="save" lay-submit>
                            立即提交
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



</div>

<script>
    layui.use(['form', 'layer','upload','common'], function () {
        $ = layui.jquery;
        var form = layui.form;
        var layer = layui.layer;
        var upload = layui.upload;
        var common = layui.common;


        //监听提交
        form.on('submit(save)', function (data) {
            common.post('setting/index',data.field);
        });


        var upload_data = {
            _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
        };
        upload.render({
            elem: '#logo',
            data:upload_data,
            field:'UploadForm[image]',
            url: '<?php echo Url::to(['setting/upload'])?>',
            done: function(res){
                if(res.code == 0){
                    $("input[name='wx_qrcode']").val(res.data.url);
                    $("#wx_qrcode").attr('src',res.data.url);
                }
            } ,error: function(){
                layer.msg('上传失败', {anim: 0});
            }
        });

    });
</script>

