<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:25
 */

use \yii\helpers\Url;

$this->title = '站点设置';
?>
<style>
    .layui-form-label {
        width: 120px;
        font-size: 14px;
        color: #353535;
        padding: 9px;
    }
    .layui-input-block {
        margin-left: 160px;
        width: 40%;
    }
</style>
<div class="layui-fluid">
    <div class="layui-col-md12">
        <div class="layui-card">
            <div class="layui-card-header">站点设置</div>
            <div class="layui-card-body">
                <form class="layui-form">
                    <input type="hidden" name="id" value="<?=$item->id?>">
                    <div class="layui-form-item">
                        <label class="layui-form-label">网站标题</label>
                        <div class="layui-input-block">
                            <input type="text" name="main_title" value="<?= $item->main_title ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">网站副标题</label>
                        <div class="layui-input-block">
                            <input type="text" name="secondary_title" value="<?= $item->secondary_title ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">网站关键词</label>
                        <div class="layui-input-block">
                            <textarea name="keywords" placeholder="请输入内容" class="layui-textarea"><?= $item->keywords ?></textarea>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">网站描述</label>
                        <div class="layui-input-block">
                            <textarea name="description" placeholder="请输入内容" class="layui-textarea"><?= $item->description ?></textarea>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">备案号</label>
                        <div class="layui-input-block">
                            <input type="text" name="policeicp" value="<?= $item->policeicp ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">版权信息</label>
                        <div class="layui-input-block">
                            <input type="text" name="copyright" value="<?= $item->copyright ?>" class="layui-input" placeholder="例如:xx科技"/>
                        </div>
                    </div>
                    <div class="layui-form-item" style="margin-top: 20px;">
                        <label class="layui-form-label" style="line-height: 60px;">小程序码</label>
                        <div class="layui-input-block">
                            <input type="hidden"  name="xapp_qrcode" value="<?= $item->xapp_qrcode?>" />
                            <?php if($item->xapp_qrcode){?>
                                <img id="xapp_qrcode" style="width: 80px;height: 80px;" src="<?= $item->xapp_qrcode?>" alt="">
                            <?php }else{?>
                                <img id="xapp_qrcode" style="width: 80px;height: 80px;" src="<?= Yii::$app->request->baseUrl ?>/statics/images/qr.png" alt="">
                            <?php }?>
                            <a style="margin-left: 10px;color:#4C84FF; " href="#" id="logo">上传</a>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label for="L_repass" class="layui-form-label"></label>
                        <button class="layui-btn layui-btn-blue" type="button" lay-filter="save" lay-submit>
                            立即提交
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    layui.use(['form', 'layer','upload','common'], function () {
        $ = layui.jquery;
        var form = layui.form;
        var layer = layui.layer;
        var upload = layui.upload;
        var common = layui.common;


        //监听提交
        form.on('submit(save)', function (data) {
            common.post('pc/index',data.field);
        });


        var upload_data = {
            _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
        };
        upload.render({
            elem: '#logo',
            data:upload_data,
            field:'UploadForm[image]',
            url: '<?php echo Url::to(['setting/upload'])?>',
            done: function(res){
                if(res.code == 0){
                    $("input[name='xapp_qrcode']").val(res.data.url);
                    $("#xapp_qrcode").attr('src',res.data.url);
                }
            } ,error: function(){
                layer.msg('上传失败', {anim: 0});
            }
        });

    });
</script>

