<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:25
 */

use \yii\helpers\Url;

$this->title = '小程序跳转';
?>
<style>
    .layui-form-label {
        width: 120px;
        font-size: 14px;
        color: #353535;
        padding: 9px;
    }
    .layui-input-block {
        margin-left: 160px;
        width: 40%;
    }
</style>
<div class="layui-fluid">
    <div class="layui-col-md12">
        <div class="layui-card">
            <div class="layui-card-header">编辑</div>
            <div class="layui-card-body">
                <form class="layui-form">
                    <input type="hidden" name="id" value="<?=$item->id?>" />
                    <div class="layui-form-item">
                        <label class="layui-form-label">名称</label>
                        <div class="layui-input-block">
                            <input type="text" name="name" placeholder="小程序名称"  lay-verify="required" lay-verType="tips"	lay-reqText="请填写小程序名称"  value="<?= $item->name ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item" style="margin-top: 20px;">
                        <label class="layui-form-label" style="line-height: 60px;">图标</label>
                        <div class="layui-input-block">
                            <input type="hidden"  name="icon_url" lay-verify="required"  lay-reqText="请上传图标" value="<?= $item->icon_url?>" />
                            <?php if($item->icon_url){?>
                                <img id="icon_url" style="width: 80px;height: 80px;" src="<?= $item->icon_url?>" alt="">
                            <?php }else{?>
                                <img id="icon_url" style="width: 80px;height: 80px;" src="<?= Yii::$app->request->baseUrl ?>/statics/images/null.png" alt="">
                            <?php }?>
                            <a style="margin-left: 10px;color:#4C84FF;" href="#" id="icon">上传图片</a>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">APPID</label>
                        <div class="layui-input-block">
                            <input type="text" name="appid" placeholder="小程序APPID" lay-verify="required"  lay-verType="tips"	lay-reqText="请填写APPID"  value="<?= $item->appid ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">路径</label>
                        <div class="layui-input-block">
                            <input type="text" name="path" placeholder="小程序路径，如：pages/index/index" lay-verify="required" lay-verType="tips"	lay-reqText="请填写小程序路径" value="<?= $item->path ?>" class="layui-input"/>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">介绍</label>
                        <div class="layui-input-block">
                            <textarea name="info"  lay-verify="required" lay-verType="tips"	lay-reqText="请填写介绍" placeholder="请输入内容" class="layui-textarea"><?= $item->info ?></textarea>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label for="L_repass" class="layui-form-label"></label>
                        <button class="layui-btn layui-btn-blue" type="button" lay-filter="save" lay-submit>
                            立即提交
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



</div>

<script>
    layui.use(['form','common','upload'], function () {
        var form = layui.form;
        var common = layui.common;
        var upload = layui.upload;

        var upload_data = {
            _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
        };
        upload.render({
            elem: '#icon',
            data:upload_data,
            field:'UploadForm[image]',
            accept:'images',
            acceptMime:'image/*',
            exts:'jpg|png|gif|bmp|jpeg',
            url: '<?php echo Url::to(['setting/upload'])?>',
            done: function(res){
                if(res.code == 0){
                    $("input[name='icon_url']").val(res.data.url);
                    $("#icon_url").attr('src',res.data.url);
                }else{
                    layer.msg(res.msg, {anim: 0});
                }
            } ,error: function(){
                layer.msg('上传失败', {anim: 0});
            }
        });
        upload.render({
            elem: '#qrcode',
            data:upload_data,
            field:'UploadForm[image]',
            accept:'images',
            acceptMime:'image/*',
            exts:'jpg|png|gif|bmp|jpeg',
            url: '<?php echo Url::to(['setting/upload'])?>',
            done: function(res){
                if(res.code == 0){
                    $("input[name='qrcode_url']").val(res.data.url);
                    $("#qrcode_url").attr('src',res.data.url);
                }else{
                    layer.msg(res.msg, {anim: 0});
                }
            } ,error: function(){
                layer.msg('上传失败', {anim: 0});
            }
        });
        //监听提交
        form.on('submit(save)', function (res) {
            common.post('more/edit',res.field,'more/list');
        });
    });
</script>

