
<?php
use yii\helpers\Url;
use yii\helpers\Html;

$version = '1.2.7';
$current_url = Yii::$app->request->absoluteUrl;
$cid =  Yii::$app->controller->id;
$a_name = Yii::$app->controller->action->id;
$we7_url = mb_substr($current_url, 0, stripos($current_url, 'addons/'));
$api_url = mb_substr($current_url, 0, stripos($current_url, '?r='));
$base_url = mb_substr($current_url, 0, stripos($current_url, 'index.php?r='));
$we7_account_name =Yii::$app->helpers->getApp("app_name");
$app_type=Yii::$app->helpers->getApp('app_type');
$we7_account_type_name = '';
if($app_type == 1 || $app_type == 3){
    $we7_account_type_name = '公众号应用 ';
}else if($app_type == 4){
    $we7_account_type_name = '小程序应用 ';
}
$we7_copyright=\Yii::$app->helpers->getApp("we7_copyright") ?: [];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?= Html::encode($this->title) ?></title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="<?= Yii::$app->request->baseUrl ?>/statics/lib/layui/css/layui.css?v=<?= $version ?>" media="all">
    <link rel="stylesheet" href="<?= Yii::$app->request->baseUrl ?>/statics/css/site.css?v=<?= $version ?>">
    <script src="<?= Yii::$app->request->baseUrl?>/statics/lib/layui/layui.js?v=<?= $version ?>"></script>
    <script>
        var $ = null;
        var site_api = "<?=$api_url?>";
        var _csrf_zzzy = "<?php echo Yii::$app->request->csrfToken?>";
        layui.config({
            base: "<?=$base_url?>statics/lib/layui/modules/"
        }).extend({
            common: 'common'
        });
        layui.use('element', function(){
            $ = layui.$
        });
    </script>
    <style>
        .layui-icon-login-wechat{
            color: #777;
        }
        .layui-this .layui-icon-login-wechat{
            color: #4C84FF;
        }
    </style>
</head>
<body class="layui-layout-body">
<div id="LAY_app">
    <div class="layui-layout layui-layout-admin">
        <div class="layui-header">
            <!-- 头部区域 -->
            <div class="layui-nav layui-layout-left">
                <span>证件照制作</span>
            </div>
            <ul class="layui-nav layui-layout-right" style="margin-right: 100px;">
                <li class="layui-nav-item">
                    <a href="javascript:;">
                        <?php echo $we7_account_type_name;?>
                        <cite><?php echo $we7_account_name;?></cite>
                    </a>
                    <dl class="layui-nav-child">
                        <dd style="text-align: center;">
                            <?php if($app_type == 4){?>
                                <a href="<?php echo Url::to(['setting/wxapp']);?>">小程序设置</a>
                            <?php }else{?>
                                <a href="<?php echo Url::to(['setting/index']);?>">平台设置</a>
                            <?php }?>
                        </dd>
                        <hr>
                        <?php if(is_ind()){?>
                            <dd  style="text-align: center;"><a href='<?=Url::to(['common/logout'])?>'>退出登录</a></dd>
                        <?php }else{?>
                            <dd  style="text-align: center;"><a href='<?= $we7_url ?>web/index.php?c=module&a=display'>返回系统</a></dd>
                        <?php }?>
                    </dl>
                </li>
                <li class="layui-nav-item layui-hide-xs">
                    <a href="javascript:;"></a>
                </li>
                <li class="layui-nav-item layui-show-xs-inline-block layui-hide-sm">
                    <a href="javascript:;" ></a>
                </li>
            </ul>
        </div>

        <!-- 侧边菜单 -->
        <div class="layui-side layui-side-menu" style="background-color: #fbfbfb !important; margin-bottom: 60px; ">
            <div class="layui-side-scroll">
                <ul class="layui-nav layui-nav-tree" >

                    <li class="layui-nav-item <?php if($cid == 'site' ){?>layui-this<?php }?>">
                        <a href="<?php echo Url::to(['site/index']);?>" >
                            <i class="layui-icon layui-icon-home"></i>
                            <cite>主页</cite>
                        </a>
                    </li>
                    <li class="layui-nav-item <?php if($cid == 'item' ){?>layui-this<?php }?>">
                        <a href="<?php echo Url::to(['item/list']);?>">
                            <i class="layui-icon layui-icon-app"></i>
                            <cite>规格列表</cite>
                        </a>
                    </li>
                    <li class="layui-nav-item <?php if($cid == 'user' ){?>layui-this<?php }?>">
                        <a href="<?php echo Url::to(['user/list']);?>">
                            <i class="layui-icon layui-icon-user"></i>
                            <cite>用户列表</cite>
                        </a>
                    </li>
                    <li class="layui-nav-item <?php if($cid == 'issue' ){?>layui-this<?php }?>">
                        <a href="<?php echo Url::to(['issue/list']);?>">
                            <i class="layui-icon layui-icon-survey"></i>
                            <cite>常见问题</cite>
                        </a>
                    </li>

                    <?php if($app_type ==4){?>
                        <li  class="layui-nav-item <?php if($cid == 'setting' && $a_name=='wxapp' ){?>layui-this<?php }?>">
                            <a href="<?php echo Url::to(['setting/wxapp']);?>" >
                                <i class="layui-icon layui-icon-set"></i>
                                <cite>小程序设置</cite>
                            </a>
                        </li>
                        <li class="layui-nav-item <?php if($cid == 'more'){?>layui-this<?php }?>">
                            <a href="<?php echo Url::to(['more/list']);?>" >
                                <i class="layui-icon layui-icon-cols"></i>
                                <cite>小程序跳转</cite>
                            </a>
                        </li>
                        <li class="layui-nav-item <?php if($cid == 'setting' && $a_name=='official-account'){?>layui-this<?php }?>">
                            <a href="<?php echo Url::to(['setting/official-account']);?>" >
                                <i class="layui-icon layui-icon-login-wechat"></i>
                                <cite>公众号关注</cite>
                            </a>
                        </li>
                        <?php if(is_ind()){?>
                            <li class="layui-nav-item <?php if($cid == 'setting' && $a_name=='push'){?>layui-this<?php }?>">
                                <a href="<?php echo Url::to(['setting/push']);?>" >
                                    <i class="layui-icon layui-icon-release"></i>
                                    <cite>小程序发布</cite>
                                </a>
                            </li>
                            <li class="layui-nav-item <?php if($cid == 'pc' && $a_name=='index'){?>layui-this<?php }?>">
                                <a href="<?php echo Url::to(['pc/index']);?>" >
                                    <i class="layui-icon layui-icon-engine"></i>
                                    <cite>站点设置</cite>
                                </a>
                            </li>
                        <?php }?>
                    <?php }else{?>
                        <li  class="layui-nav-item <?php if($cid == 'setting' ){?>layui-this<?php }?>">
                            <a href="<?php echo Url::to(['setting/index']);?>" >
                                <i class="layui-icon layui-icon-set"></i>
                                <cite>平台设置</cite>
                            </a>
                        </li>
                    <?php }?>
                </ul>
            </div>
        </div>
        <!-- 页面标签 -->
        <div class="layadmin-pagetabs" id="LAY_app_tabs" style="display: none;">
            <div class="layui-icon layadmin-tabs-control layui-icon-prev" layadmin-event="leftPage"></div>
            <div class="layui-icon layadmin-tabs-control layui-icon-next" layadmin-event="rightPage"></div>
            <div class="layui-icon layadmin-tabs-control layui-icon-down">
                <ul class="layui-nav layadmin-tabs-select" lay-filter="layadmin-pagetabs-nav">
                    <li class="layui-nav-item" lay-unselect>
                        <a href="javascript:;"></a>
                        <dl class="layui-nav-child layui-anim-fadein">
                            <dd layadmin-event="closeThisTabs"><a href="javascript:;">关闭当前标签页</a></dd>
                            <dd layadmin-event="closeOtherTabs"><a href="javascript:;">关闭其它标签页</a></dd>
                            <dd layadmin-event="closeAllTabs"><a href="javascript:;">关闭全部标签页</a></dd>
                        </dl>
                    </li>
                </ul>
            </div>
            <div class="layui-tab" lay-unauto lay-allowClose="true" lay-filter="layadmin-layout-tabs">
                <ul class="layui-tab-title" id="LAY_app_tabsheader">
                    <li lay-id="home/console.html" lay-attr="home/console.html" class="layui-this"><i class="layui-icon layui-icon-home"></i></li>
                </ul>
            </div>
        </div>

        <!-- 主体内容 -->
        <div class="layui-body" id="LAY_app_body">
            <?= $content ?>
        </div>
        <!-- 辅助元素，一般用于移动设备下遮罩 -->
        <div class="layadmin-body-shade" layadmin-event="shade"></div>
    </div>
    <div class="layui-header zy-footer">
        <?php if(is_ind()){?>
                Powered by <a href="https://www.zjzapi.com"><b>鹧应证件照</b></a> © 2018-<?=date('Y')?> <a href="https://www.zjzapi.com">www.zjzapi.com</a>
        <?php }else{?>
            <?php if(empty($we7_copyright['footerleft'])){?>
                Powered by <a target="_blank" href="https://www.w7.cc"><b>微擎</b></a> © 2014-2015 <a target="_blank"  href="https://www.w7.cc">www.we7.cc</a>
            <?php }else{?>
                <?php echo $we7_copyright['footerleft']?>
            <?php }?>
            <?php if(!empty($we7_copyright['icp'])){?>
                <p>备案号：<a  href="http://www.miitbeian.gov.cn" target="_blank"><?=$we7_copyright['icp']?></a></p>
            <?php }?>
        <?php }?>
    </div>
</div>
</body>
</html>


