<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:14
 */
 

use \yii\helpers\Url;

$this->title = '用户列表';
?>
<style>
    .layui-table-cell{
        height: auto;
        line-height: normal;
    }
</style>
<div class="layui-fluid">
    <form class="layui-form" lay-filter="userSearch" action="">
        <div  class="layui-row" style="padding: 5px 10px;">
            <div class="layui-col-md4">
                <label class="layui-form-label">规格名称</label>
                <div class="layui-input-block">
                    <input type="text" name="name" placeholder="请输入" autocomplete="off" class="layui-input">
                </div>
            </div>
            <button lay-filter="search" lay-submit type="button" class="layui-btn layui-btn-blue" style="margin-left: 10px;">
                <i class="layui-icon">&#xe615;</i>筛选
            </button>
        </div>
    </form>
    <div class="layui-row layui-col-space15">
        <div class="layui-col-md12">
            <div class="layui-card">
                <div class="layui-card-body">
                    <table class="layui-hide" id="table" lay-filter="table"></table>
                    <script type="text/html" id="table-edit">
                        <a href="#" class="zy-edit" lay-event="edit">编辑</a>
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    layui.use(['table','form'], function () {
        var table = layui.table,  form = layui.form;
        var table_init = {
            elem: '#table',
            method: "POST",
            where:{
                _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
            },
            url: "<?= Url::to(['item/list']);?>",
            cols: [[
                {field: 'id', title: '编号', width: 100 },
                {field: 'name', title: '规格', },
                {field: 'width_px', title: '宽（像素）'},
                {field: 'height_px', title: '高（像素）'},
                {field: 'width_mm', title: '宽（尺寸）'},
                {field: 'height_mm', title: '高（尺寸）'},
                {title: '像素' ,templet: function(d){return d.dpi +'DPI'}},
                {width: 200, title: '操作', align: 'center', fixed: 'right', toolbar: '#table-edit'}
            ]], page: true, limit: 15
        };
        table.render(table_init);
        table.on('tool(table)', function (obj) {
            var data = obj.data;
            var layEvent = obj.event;
            if (layEvent == 'edit') {
                window.location.href = '<?=Url::to(['item/edit'])?>' + '&id=' + data.id;
            }
        });
        //搜索
        form.on('submit(search)', function (data) {
            var where = data.field;
            table.reload('table', {
                where: where
                , page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
        });

    });
</script>