<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/3
 * Time: 下午4:14
 */
 

use \yii\helpers\Url;

$this->title = '常见问题';
?>




<div class="layui-fluid">
    <div style="margin-top: 20px;">
        <a style="margin-left: 16px;" href="<?= Url::to(['issue/edit'])?>" class="layui-btn layui-btn-blue">
            <i class="layui-icon">&#xe61f;</i>新增
        </a>
    </div>
    <div class="layui-row layui-col-space15">
        <div class="layui-col-md12">
            <div class="layui-card">
                <div class="layui-card-body">
                    <table class="layui-hide" id="table" lay-filter="table"></table>
                    <script type="text/html" id="table-edit">
                        <a href="#" class="zy-edit" lay-event="edit">编辑</a>
                        <a href="#" class="zy-del" lay-event="del">删除</a>
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    layui.use(['table','common'], function () {
        var table = layui.table,  common = layui.common;
        var table_init = {
            elem: '#table',
            method: "POST",
            where:{
                _csrf_zzzy:"<?php echo Yii::$app->request->csrfToken?>"
            },
            url: "<?= Url::to(['issue/list']);?>",
            cols: [[
                {field: 'id', title: '编号', sort: true, width: 100, fixed: 'left'},
                {field: 'title', title: '标题'},
                {field: 'created_at', title: '添加时间', width: 200},
                {width: 200, title: '操作', align: 'center', fixed: 'right', toolbar: '#table-edit'}
            ]], page: true, limit: 10
        };

        table.render(table_init);
        //监听工具条
        table.on('tool(table)', function(obj){
            var data = obj.data;

            if(obj.event === 'del'){
                layer.confirm('确认要删除吗？',function(index){
                    common.post('issue/del',{id: data.id},'issue/list');
                });
            } else if(obj.event === 'edit'){
                window.location.href = '<?= Url::to(['issue/edit'])?>&id='+data.id;
            }
        });
    });
</script>