<?php
use yii\helpers\Url;
use yii\helpers\Html;


?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>安装 - 管理员配置</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="<?= \Yii::$app->request->baseUrl ?>/statics/lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="<?= \Yii::$app->request->baseUrl ?>/statics/css/site.css">
    <script src="<?= \Yii::$app->request->baseUrl?>/statics/lib/layui/layui.js"></script>
    <script>
        var $ = null;
        var site_api = "<?=$api_url?>";
        var _csrf_zzzy = "<?php echo \Yii::$app->request->csrfToken?>";
        layui.config({
            base: "<?=$base_url?>statics/lib/layui/modules/"
        }).extend({
            common: 'common'
        });
        layui.use('element', function(){
            $ = layui.$
        });
    </script>
    <style>
           .progress{
               border-top: 1px solid #ccc;    margin-top: 10px;margin-bottom: 5px;
           }
           .progress-c{
               width: 20px;height: 20px;border-radius: 20px;background-color: #ccc;color: #fff;font-size: 12px;line-height: 20px;text-align: center;margin: -10px auto 0;
           }
           .progress-c-select{
                background-color: #4C84FF;
                box-shadow: 0 0 10px 5px rgb(76 132 255 / 50%);
            }
        .progress-line{
            text-align: center;padding-top: 20px;padding-bottom: 20px;
        }
        .progress-line i{
            font-size: 30px;
        }
           .progress-line p{
               line-height: 40px;
           }
        .progress-select{
            color: #4C84FF;
        }
        .install-title{
            background-color: #E4EAFB;
            text-align: center;
            line-height: 40px;
            color: #333;
            font-size: 16px;
        }
        .layui-container{
            margin-top: 50px;
            padding: 0;
            background-color: #fff;
        }
        .layui-form-label{
            width: 120px;
        }
           .layui-input-block{
               margin-left: 150px;
           }
    </style>
</head>
<body>
<form class="layui-form" action="" >
<div class="layui-container">
    <div class="layui-row" >
        <div class="layui-col-md12 install-title">
            鹧应证件照免费版 安装
        </div>
    </div>
    <div class="layui-row" style="padding: 0 10px;">
        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-slider"></i>
            <p>环境检测</p>
            <div class="progress"><div class="progress-c" >1</div></div>
        </div>
        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-template-1"></i>
            <p>数据库配置</p>
            <div class="progress"><div class="progress-c" >2</div></div>
        </div>
        <div class="layui-col-md3 progress-line progress-select">
            <i class="layui-icon layui-icon-user"></i>
            <p>管理员配置</p>
            <div class="progress"><div class="progress-c progress-c-select" >3</div></div>
        </div>
        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-ok-circle"></i>
            <p>安装完成</p>
            <div class="progress"><div class="progress-c" >4</div></div>
        </div>
    </div>
    <div  class="layui-row">
        <div class="layui-card">
            <div class="layui-card-header">管理员信息</div>
            <div class="layui-card-body" style="padding: 30px 60px;">

                    <div class="layui-form-item">
                        <label class="layui-form-label">管理员账号</label>
                        <div class="layui-input-block">
                            <input type="text" name="username" value="admin" required lay-verify="required" placeholder="请输入管理员账号" autocomplete="off" lay-verType="tips" class="layui-input" >
                        </div>
                    </div>

                    <div class="layui-form-item">
                        <label class="layui-form-label">管理员密码</label>
                        <div class="layui-input-block">
                            <input type="password" name="password" value="" required lay-verify="required" placeholder="请输入密码" autocomplete="off" lay-verType="tips" class="layui-input" />
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">确认密码</label>
                        <div class="layui-input-block">
                            <input type="password" name="password_ok" value="" required lay-verify="required" placeholder="确认密码" autocomplete="off" lay-verType="tips" class="layui-input" />
                        </div>
                    </div>
            </div>
        </div>

        <div style="text-align: center;padding-bottom: 30px;">
            <a href="<?=Url::to(['install/step2'])?>" class="layui-btn layui-btn-primary">上一步</a>
            <button class="layui-btn" type="button" lay-submit lay-filter="formDemo">下一步</button>
        </div>
    </div>
</div>
</form>
<script>
    layui.use(['form','common'], function(){
        var form = layui.form;
        var common = layui.common;
        form.on('submit(formDemo)', function(data){
            var password = data.field.password;
            var password_ok = data.field.password_ok;
            password = password.trim();
            password_ok = password_ok.trim();
            if(password.length < 6){
                layer.msg('密码太短了');
                return false;
            }
            if(password != password_ok){
                layer.msg('两次密码不一致');
                return false;
            }
            common.post('install/step3',data.field,'install/step4');
        });
    });
</script>
</body>
</html>


