<?php
use yii\helpers\Url;
use yii\helpers\Html;


$next = true;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>安装 - 检测环境</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="<?= \Yii::$app->request->baseUrl ?>/statics/lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="<?= \Yii::$app->request->baseUrl ?>/statics/css/site.css">
    <script src="<?= \Yii::$app->request->baseUrl?>/statics/lib/layui/layui.js"></script>
    <script>
        var $ = null;
        var site_api = "<?=$api_url?>";
        var _csrf_zzzy = "<?php echo \Yii::$app->request->csrfToken?>";
        layui.config({
            base: "<?=$base_url?>statics/lib/layui/modules/"
        }).extend({
            common: 'common'
        });
        layui.use('element', function(){
            $ = layui.$
        });
    </script>
    <style>
           .progress{
               border-top: 1px solid #ccc;    margin-top: 10px;margin-bottom: 5px;
           }
           .progress-c{
               width: 20px;height: 20px;border-radius: 20px;background-color: #ccc;color: #fff;font-size: 12px;line-height: 20px;text-align: center;margin: -10px auto 0;
           }
           .progress-c-select{
                background-color: #4C84FF;
                box-shadow: 0 0 10px 5px rgb(76 132 255 / 50%);
            }
        .progress-line{
            text-align: center;padding-top: 20px;padding-bottom: 20px;
        }
        .progress-line i{
            font-size: 30px;
        }
           .progress-line p{
               line-height: 40px;
           }
        .progress-select{
            color: #4C84FF;
        }
        .install-title{
            background-color: #E4EAFB;
            text-align: center;
            line-height: 40px;
            color: #333;
            font-size: 16px;
        }
        .layui-container{
            margin-top: 50px;
            padding: 0;
            background-color: #fff;
        }
    </style>
</head>
<body>
<div class="layui-container">
    <div class="layui-row" >
        <div class="layui-col-md12 install-title">
            鹧应证件照免费版 安装
        </div>
    </div>
    <div class="layui-row" style="padding: 0 10px;">
        <div class="layui-col-md3 progress-line progress-select">
            <i class="layui-icon layui-icon-slider"></i>
            <p>环境检测</p>
            <div class="progress"><div class="progress-c progress-c-select" >1</div></div>
        </div>

        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-template-1"></i>
            <p>数据库配置</p>
            <div class="progress"><div class="progress-c" >2</div></div>
        </div>
        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-user"></i>
            <p>管理员配置</p>
            <div class="progress"><div class="progress-c" >3</div></div>
        </div>
        <div class="layui-col-md3 progress-line">
            <i class="layui-icon layui-icon-ok-circle"></i>
            <p>安装完成</p>
            <div class="progress"><div class="progress-c" >4</div></div>
        </div>
    </div>
    <div  class="layui-row">
        <div class="layui-card">
            <div class="layui-card-header">系统环境检测</div>
            <div class="layui-card-body">
                <table class="layui-table">
                    <thead>
                        <tr>
                            <th style="width: 25%;">检查项目	</th>
                            <th style="width: 25%;">当前配置	</th>
                            <th style="width: 25%;">所需配置	</th>
                            <th style="width: 25%;">检测结果	</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($check1 as $row){?>
                            <tr>
                                <td><?=$row['name']?></td>
                                <td><?=$row['present']?></td>
                                <td><?=$row['need']?></td>
                                <td>
                                    <?php if($row['status']){?>
                                        <i style="font-weight: bold;color: #5FB878;" class="layui-icon layui-icon-ok"></i>
                                    <?php }else{?>
                                        <?php $next = false;?>
                                        <i style="font-weight: bold;color: #FF5722;" class="layui-icon layui-icon-close"></i>
                                    <?php }?>
                                </td>
                            </tr>
                        <?php }?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="layui-card">
            <div class="layui-card-header">依赖性检测</div>
            <div class="layui-card-body">
                <table class="layui-table">
                    <thead>
                    <tr>
                        <th style="width: 25%;">检查项目	</th>
                        <th style="width: 25%;">当前配置	</th>
                        <th style="width: 25%;">所需配置	</th>
                        <th style="width: 25%;">检测结果	</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($check2 as $row){?>
                            <tr>
                                <td><?=$row['name']?></td>
                                <td><?=$row['present']?></td>
                                <td><?=$row['need']?></td>
                                <td>
                                    <?php if($row['status']){?>
                                        <i style="font-weight: bold;color: #5FB878;" class="layui-icon layui-icon-ok"></i>
                                    <?php }else{?>
                                        <?php $next = false;?>
                                        <i style="font-weight: bold;color: #FF5722;" class="layui-icon layui-icon-close"></i>
                                    <?php }?>
                                </td>
                            </tr>
                        <?php }?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="layui-card">
            <div class="layui-card-header">权限检测</div>
            <div class="layui-card-body">
                <table class="layui-table">
                    <thead>
                    <tr>
                        <th style="width: 25%;">检查项目	</th>
                        <th style="width: 25%;">当前权限	</th>
                        <th style="width: 25%;">所需权限	</th>
                        <th style="width: 25%;">检测结果	</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($check3 as $row){?>
                            <tr>
                                <td><?=$row['name']?></td>
                                <td><?=$row['present']?></td>
                                <td><?=$row['need']?></td>
                                <td>
                                    <?php if($row['status']){?>
                                        <i style="font-weight: bold;color: #5FB878;" class="layui-icon layui-icon-ok"></i>
                                    <?php }else{?>
                                        <?php $next = false;?>
                                        <i style="font-weight: bold;color: #FF5722;" class="layui-icon layui-icon-close"></i>
                                    <?php }?>
                                </td>
                            </tr>
                        <?php }?>
                    </tbody>
                </table>
            </div>
        </div>
        <div style="text-align: center;padding-bottom: 30px;">
            <?php if($next){?>
                <a href="<?=Url::to(['install/step2'])?>" class="layui-btn">下一步</a>
            <?php }else{?>
                <a href="javascript:void(0);" class="layui-btn layui-btn-disabled">下一步</a>
            <?php }?>
        </div>
    </div>
</div>

</body>
</html>


